/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.textdisplay;

import com.gamelion.speedx.Debug;
import com.gamelion.speedx.FontPool;
import com.gamelion.speedx.IFont;
import com.gamelion.speedx.textdisplay.IParserListener;
import com.gamelion.speedx.textdisplay.Parser;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RichTextDisplay {
    private FontPool fontPool;
    private Layouter layouter = new Layouter();

    public void setFontPool(FontPool pool) {
        this.fontPool = pool;
    }

    public void layout(String str, int width) {
        this.layouter.layout(str, this.fontPool, width);
    }

    public int width() {
        return this.layouter.width;
    }

    public int height() {
        return this.layouter.height;
    }

    public void paint(Graphics g) {
        int itemsNum = this.layouter.items.size();
        for (int i = 0; i < itemsNum; ++i) {
            ((Item)this.layouter.items.elementAt(i)).paint(g);
        }
    }

    private class Layouter
    implements IParserListener {
        private static final float JUSTIFY_WIDTH_THRESHOLD = 0.7f;
        private Vector items = new Vector();
        private int rowStartIndex;
        private int rowWidth;
        private int rowItemsWidth;
        private int rowHeight;
        private int rowY;
        private Parser parser = new Parser(this);
        private int width;
        private int height;
        private IFont activeFont;
        private int spaceWidth;
        private int layoutType;

        public void layout(String text, FontPool fontPool, int width) {
            this.width = width;
            this.layoutType = 0;
            this.rowStartIndex = 0;
            this.rowWidth = 0;
            this.rowItemsWidth = 0;
            this.rowY = 0;
            this.rowHeight = 0;
            this.activeFont = fontPool.defaultFont();
            this.spaceWidth = this.activeFont.charWidth(' ');
            this.items.removeAllElements();
            this.parser.parse(text);
            this.layoutRow(false);
            this.height = this.rowY;
        }

        public void onText(String text) {
            this.addItem(new TextItem(text, this.activeFont));
        }

        public void onImage(String imageName) {
            try {
                this.addItem(new ImageItem(Image.createImage((String)imageName)));
            }
            catch (Exception ex) {
                Debug.error("Failed to load " + imageName);
            }
        }

        public void onLayoutChange(int layoutType) {
            if (layoutType == this.layoutType) {
                return;
            }
            if (this.rowStartIndex != this.items.size()) {
                this.layoutRow(false);
            }
            this.layoutType = layoutType;
        }

        public void onFontChange(String fontName) {
            this.activeFont = RichTextDisplay.this.fontPool.getFont(fontName);
            if (this.activeFont == null) {
                Debug.error("Could not find font " + fontName + " using default one");
                this.activeFont = RichTextDisplay.this.fontPool.defaultFont();
                this.spaceWidth = this.activeFont.charWidth(' ');
            }
        }

        public void onBreak() {
            this.layoutRow(true);
        }

        private void addItem(Item item) {
            if (this.items.size() - this.rowStartIndex == 0) {
                this.putItem(item);
                this.rowWidth = item.width;
                return;
            }
            int updatedWidth = this.rowWidth + item.width + this.spaceWidth;
            if (updatedWidth > this.width) {
                this.layoutRow(false);
                this.putItem(item);
                this.rowWidth = item.width;
            } else {
                this.putItem(item);
                this.rowWidth = updatedWidth;
            }
        }

        private void putItem(Item item) {
            this.items.addElement(item);
            this.rowItemsWidth += item.width;
            this.rowHeight = Math.max(this.rowHeight, item.height);
        }

        private void layoutRow(boolean forced) {
            int x = 0;
            for (int i = this.rowStartIndex; i < this.items.size(); ++i) {
                Item item = (Item)this.items.elementAt(i);
                item.y = this.rowY + (this.rowHeight - item.height) / 2;
                if (this.layoutType == 0) {
                    item.x = x;
                } else if (this.layoutType == 1) {
                    item.x = this.width - x - item.width;
                } else if (this.layoutType == 2) {
                    item.x = x + (this.width - this.rowWidth) / 2;
                } else if (this.layoutType == 3) {
                    item.x = (float)this.rowWidth < (float)this.width * 0.7f || this.items.size() - this.rowStartIndex <= 2 ? x : (i < this.items.size() - 1 ? x * this.width / this.rowWidth : this.width - item.width);
                }
                x += item.width + this.spaceWidth;
            }
            if (forced && this.rowHeight == 0) {
                this.rowHeight = this.activeFont.height();
            }
            this.rowStartIndex = this.items.size();
            this.rowWidth = 0;
            this.rowItemsWidth = 0;
            this.rowY += this.rowHeight;
            this.rowHeight = 0;
        }
    }

    private class ImageItem
    extends Item {
        public Image img;

        public ImageItem(Image img) {
            this.img = img;
            this.width = img.getWidth();
            this.height = img.getHeight();
        }

        public void paint(Graphics g) {
            g.drawImage(this.img, this.x, this.y, 20);
        }
    }

    private class TextItem
    extends Item {
        public String text;
        public IFont font;

        public TextItem(String text, IFont font) {
            this.text = text;
            this.font = font;
            this.width = font.stringWidth(text);
            this.height = font.height();
        }

        public void paint(Graphics g) {
            this.font.drawString(g, this.text, this.x, this.y, 20);
        }
    }

    private abstract class Item {
        public int x;
        public int y;
        public int width;
        public int height;

        private Item() {
        }

        public abstract void paint(Graphics var1);
    }
}

