/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.startupsequence;

import com.gamelion.speedx.BitmapFont;
import com.gamelion.speedx.Debug;
import com.gamelion.speedx.FontPool;
import com.gamelion.speedx.SoundPool;
import com.gamelion.speedx.SpeedXMIDlet;
import com.gamelion.speedx.TexturePool;
import com.gamelion.speedx.menu.LabelsAtlas;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Texture2D;

public class LoadingThread
extends Thread {
    private SpeedXMIDlet midlet;
    private boolean finished = false;

    public LoadingThread(SpeedXMIDlet midlet) {
        this.midlet = midlet;
    }

    public boolean finished() {
        return this.finished;
    }

    public void run() {
        try {
            Debug.trace("Loading thread started");
            this.loadFonts();
            this.loadTextures();
            this.loadSounds();
            this.midlet.menu().setup();
            this.midlet.game().setup();
            LabelsAtlas atlas = this.midlet.labelsAtlas();
            atlas.addDigits(this.midlet.fontPool().getFont("options"));
            atlas.rebuildTexture();
            Debug.trace("loading thread finished");
            System.gc();
            this.finished = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadFonts() {
        Debug.trace("Load fonts");
        FontPool pool = this.midlet.fontPool();
        pool.addFont("options", new BitmapFont("/font_button.xml"));
        pool.addFont("small", new BitmapFont("/font_small.xml"));
        pool.addFont("medium", new BitmapFont("/font_medium.xml"));
    }

    private void loadTextures() {
        Debug.trace("Load textures");
        this.loadTexture("particle", "/particle.bin");
        this.loadTexture("block1", "/block1.bin");
        this.loadTexture("spike1", "/spike1.bin");
        this.loadTexture("redband", "/redband.bin");
        this.loadTexture("bar", "/bar.bin");
        this.loadTexture("raster", "/raster.bin");
        this.loadTexture("displaybg", "/displaybg.bin");
        this.loadTexture("button", "/button.bin");
        this.loadTexture("ring", "/ring.bin");
        this.loadTexture("shield_mark", "/shield_mark.bin");
        this.loadTexture("start_light", "/start_light.bin");
        this.loadTexture("pause", "/pause.bin");
        this.loadTexture("shadow", "/shadow.bin");
        this.loadTexture("spot1", "/spot1.bin");
        this.loadTexture("spot2", "/spot2.bin");
        this.loadTexture("spot3", "/spot3.bin");
        this.loadTexture("spot4", "/spot4.bin");
        this.loadTexture("dark1", "/dark1.bin");
        this.loadTexture("darkspike1", "/darkspike1.bin");
        this.loadTexture("hl", "/hl.bin");
        this.loadTexture("tutorial", "/tutorial.bin");
        this.loadTexture("warning", "/warning.bin");
        this.loadTexture("none", "/none.bin");
        this.loadTexture("blackout", "/blackout.bin");
        this.loadTexture("dark_nebula", "/dark_nebula.bin");
        this.loadTexture("gravity_well", "/gravity_well.bin");
        this.loadTexture("hue_shift", "/hue_shift.bin");
        this.loadTexture("plasma_cloud", "/plasma_cloud.bin");
        this.loadTexture("tutorial_1", "/tutorial_1.bin");
        this.loadTexture("tutorial_2", "/tutorial_2.bin");
        this.loadTexture("tutorial_3", "/tutorial_3.bin");
        this.loadTexture("tutorial_4", "/tutorial_4.bin");
        this.loadTexture("tutorial_5", "/tutorial_5.bin");
        this.loadTexture("personal_best", "/personal_best.bin");
        this.loadTexture("game_over_header", "/game_over.bin");
        this.loadTexture("pause_header", "/pause_header.bin");
    }

    private void loadSounds() {
        Debug.trace("Load sounds");
        SoundPool pool = this.midlet.soundPool();
        pool.addSound("alarm", "/audio/alarm.wav", "audio/x-wav");
        pool.addSound("bonusup", "/audio/bonusup.wav", "audio/x-wav");
        pool.addSound("shieldup", "/audio/shieldup.wav", "audio/x-wav");
        pool.addSound("shockwave", "/audio/shockwave.wav", "audio/x-wav");
        pool.addSound("nuke", "/audio/nuke.wav", "audio/x-wav");
        pool.addSound("fold", "/audio/fold.wav", "audio/x-wav");
        pool.addSound("freez", "/audio/freez.wav", "audio/x-wav");
        pool.addSound("breakobs", "/audio/breakobs.wav", "audio/x-wav");
        pool.addSound("power_down", "/audio/power_down.wav", "audio/x-wav");
        pool.addSound("warning", "/audio/warning.wav", "audio/x-wav");
        pool.addSound("click", "/audio/click.wav", "audio/x-wav");
        pool.addSound("alarm", "/audio/alarm.wav", "audio/x-wav");
        pool.addSound("alarm2", "/audio/alarm2.wav", "audio/x-wav");
    }

    private void loadTexture(String name, String fileName) {
        try {
            Debug.trace("Loading " + fileName);
            TexturePool pool = this.midlet.texturePool();
            DataInputStream stream = new DataInputStream(this.getClass().getResourceAsStream(fileName));
            short width = stream.readShort();
            short height = stream.readShort();
            byte bytesPerTexel = stream.readByte();
            byte[] data = new byte[width * height * bytesPerTexel];
            stream.read(data);
            int format = 0;
            switch (bytesPerTexel) {
                case 1: {
                    format = 97;
                    break;
                }
                case 2: {
                    format = 98;
                    break;
                }
                case 3: {
                    format = 99;
                    break;
                }
                case 4: {
                    format = 100;
                    break;
                }
                default: {
                    Debug.error("invalid texel format");
                }
            }
            Image2D img2d = new Image2D(format, (int)width, (int)height, data);
            pool.addTexture(name, new Texture2D(img2d));
        }
        catch (IOException ex) {
            Debug.error(ex, "Failed to load " + fileName);
        }
    }
}

