/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.menu;

import java.util.Random;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class Particles {
    private static final int PARTICLES_NUM = 32;
    private static final int Z_MAX = 180;
    private static final int RANGE = 10;
    private static final int SIZE = 1;
    private Appearance appearance = new Appearance();
    private VertexBuffer vertices;
    private VertexArray positions;
    private IndexBuffer indices;
    private short[] pos;

    public Particles(Texture2D texture) {
        this.appearance.setTexture(0, texture);
        PolygonMode polyMode = new PolygonMode();
        polyMode.setCulling(162);
        this.appearance.setPolygonMode(polyMode);
        CompositingMode compMode = new CompositingMode();
        compMode.setBlending(64);
        compMode.setDepthTestEnable(true);
        compMode.setDepthWriteEnable(false);
        this.appearance.setCompositingMode(compMode);
        Random rand = new Random(-559038737L);
        this.pos = new short[384];
        byte[] uv = new byte[384];
        byte[] colors = new byte[384];
        int posIndex = 0;
        int uvIndex = 0;
        int colorIndex = 0;
        for (int i = 0; i < 32; ++i) {
            int x = rand.nextInt(10) - 5;
            int y = rand.nextInt(10) - 5;
            int z = rand.nextInt(180);
            byte r = (byte)(220 + (rand.nextInt(60) - 30) / 2 - 128);
            byte g = (byte)(200 + (rand.nextInt(100) - 50) / 2 - 128);
            byte b = 0;
            this.pos[posIndex++] = (short)(x - 1);
            this.pos[posIndex++] = (short)(y - 1);
            this.pos[posIndex++] = (short)z;
            uv[uvIndex++] = 0;
            uv[uvIndex++] = 0;
            colors[colorIndex++] = r;
            colors[colorIndex++] = g;
            colors[colorIndex++] = b;
            this.pos[posIndex++] = (short)(x + 1);
            this.pos[posIndex++] = (short)(y - 1);
            this.pos[posIndex++] = (short)z;
            uv[uvIndex++] = 64;
            uv[uvIndex++] = 0;
            colors[colorIndex++] = r;
            colors[colorIndex++] = g;
            colors[colorIndex++] = b;
            this.pos[posIndex++] = (short)(x - 1);
            this.pos[posIndex++] = (short)(y + 1);
            this.pos[posIndex++] = (short)z;
            uv[uvIndex++] = 0;
            uv[uvIndex++] = 64;
            colors[colorIndex++] = r;
            colors[colorIndex++] = g;
            colors[colorIndex++] = b;
            this.pos[posIndex++] = (short)(x + 1);
            this.pos[posIndex++] = (short)(y + 1);
            this.pos[posIndex++] = (short)z;
            uv[uvIndex++] = 64;
            uv[uvIndex++] = 64;
            colors[colorIndex++] = r;
            colors[colorIndex++] = g;
            colors[colorIndex++] = b;
        }
        this.positions = new VertexArray(128, 3, 2);
        this.positions.set(0, 128, this.pos);
        VertexArray uvArray = new VertexArray(128, 2, 1);
        uvArray.set(0, 128, uv);
        VertexArray colorArray = new VertexArray(128, 3, 1);
        colorArray.set(0, 128, colors);
        this.vertices = new VertexBuffer();
        this.vertices.setPositions(this.positions, 1.0f, null);
        this.vertices.setTexCoords(0, uvArray, 0.015625f, null);
        this.vertices.setColors(colorArray);
        int[] stripIndices = new int[128];
        int[] stripsLen = new int[32];
        int stripIndex = 0;
        int lenIndex = 0;
        for (int i = 0; i < 32; ++i) {
            stripIndices[stripIndex] = stripIndex;
            stripIndices[stripIndex + 1] = stripIndex + 1;
            stripIndices[stripIndex + 2] = stripIndex + 2;
            stripIndices[stripIndex + 3] = stripIndex + 3;
            stripIndex += 4;
            stripsLen[lenIndex++] = 4;
        }
        this.indices = new TriangleStripArray(stripIndices, stripsLen);
    }

    public void onUpdate(float dt) {
        short[] pos = this.pos;
        for (int i = 0; i < 128; ++i) {
            int n = i * 3 + 2;
            pos[n] = (short)(pos[n] - 1);
            if (pos[i * 3 + 2] >= 0) continue;
            int n2 = i * 3 + 2;
            pos[n2] = (short)(pos[n2] + 180);
        }
        this.positions.set(0, 128, pos);
    }

    public void onRepaint(Graphics3D g) {
        g.render(this.vertices, this.indices, this.appearance, null);
    }
}

