/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.game;

public class Vector3f {
    public float x;
    public float y;
    public float z;

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(Vector3f v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public void setNegate(Vector3f v) {
        this.x = -v.x;
        this.y = -v.y;
        this.z = -v.z;
    }

    public float sqrLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float length() {
        return (float)Math.sqrt(this.sqrLength());
    }

    public void normalize() {
        float length = this.length();
        if (length == 0.0f) {
            return;
        }
        float _1overLen = 1.0f / length;
        this.x *= _1overLen;
        this.y *= _1overLen;
        this.z *= _1overLen;
    }

    public static float distanceSqr(Vector3f a, Vector3f b) {
        float dx = a.x - b.x;
        float dy = a.y - b.y;
        float dz = a.z - b.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public static float dot(Vector3f a, Vector3f b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static void cross(Vector3f v, Vector3f a, Vector3f b) {
        v.set(a.y * b.z - a.z * b.y, a.z * b.x - a.x * b.z, a.x * b.y - a.y * b.x);
    }

    public static void lerp(Vector3f output, Vector3f a, Vector3f b, float frac) {
        output.set(a.x + (b.x - a.x) * frac, a.y + (b.y - a.y) * frac, a.z + (b.z - a.z) * frac);
    }

    public void add(Vector3f v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

