/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.game;

import com.gamelion.speedx.Utils;

public class Color {
    public float r;
    public float g;
    public float b;
    public float a;

    public Color() {
        this.a = 1.0f;
        this.b = 1.0f;
        this.g = 1.0f;
        this.r = 1.0f;
    }

    public Color(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = 1.0f;
    }

    public Color(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public Color(int argb, boolean hasAlpha) {
        this.r = (float)(argb >> 16 & 0xFF) / 255.0f;
        this.g = (float)(argb >> 8 & 0xFF) / 255.0f;
        this.b = (float)(argb >> 0 & 0xFF) / 255.0f;
        this.a = hasAlpha ? (float)(argb >> 24) / 255.0f : 1.0f;
    }

    public void set(Color col) {
        this.r = col.r;
        this.g = col.g;
        this.b = col.b;
        this.a = col.a;
    }

    public int toInt() {
        return (int)(this.a * 255.0f) << 24 | (int)(this.r * 255.0f) << 16 | (int)(this.g * 255.0f) << 8 | (int)(this.b * 255.0f);
    }

    static void blend(Color from, Color to, float f, Color out) {
        out.r = Utils.lerp(from.r, to.r, f);
        out.g = Utils.lerp(from.g, to.g, f);
        out.b = Utils.lerp(from.b, to.b, f);
        out.a = Utils.lerp(from.a, to.a, f);
    }
}

