/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.menu;

import com.gamelion.speedx.Debug;
import com.gamelion.speedx.IFont;
import com.gamelion.speedx.Utils;
import com.gamelion.speedx.menu.IOptionsListListener;
import com.gamelion.speedx.menu.LabelsAtlas;
import java.util.Vector;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Transform;

public class OptionsList {
    private static final float LEFT = 10.0f;
    private static final float RIGHT = 230.0f;
    private static final float APEAR_TIME = 0.25f;
    private static final float DISAPEAR_TIME = 0.25f;
    private static final float DELAY_PER_OPTION = 0.1f;
    private static final float HIGLIGHT_TIME = 0.3f;
    private static final int DEFAULT_COLOR = 0xFFFFFF;
    private static final int SELECTED_COLOR = 13270034;
    private static final float V_SPACING = 10.0f;
    private Vector options;
    private LabelsAtlas atlas;
    private IFont font;
    private int top;
    private Transform transform;
    private IOptionsListListener listener;
    private String title;
    private int lastFrameVisibleOptionsCount;

    public OptionsList(LabelsAtlas atlas, IOptionsListListener listener, int top, IFont font) {
        this.atlas = atlas;
        this.listener = listener;
        this.options = new Vector();
        this.font = font;
        this.top = top;
        this.transform = new Transform();
    }

    public void addOption(int optionId, String textId) {
        Option option = new Option(0, optionId, textId, this.nextOptionY());
        this.atlas.addLabel(textId, textId, this.font);
        this.options.addElement(option);
    }

    public void addOption(int optionId, String textId, boolean state) {
        Option option = new Option(1, optionId, textId, this.nextOptionY());
        option.onOffState = state;
        this.atlas.addLabel(textId, textId, this.font);
        this.atlas.addLabel("on", "on", this.font);
        this.atlas.addLabel("off", "off", this.font);
        this.options.addElement(option);
    }

    public void addOption(int optionId, String textId, String[] valuesTextIds, int index) {
        Option option = new Option(2, optionId, textId, this.nextOptionY());
        option.valuesIds = valuesTextIds;
        option.selectedValue = index;
        this.atlas.addLabel(textId, textId, this.font);
        for (int i = 0; i < valuesTextIds.length; ++i) {
            this.atlas.addLabel(valuesTextIds[i], valuesTextIds[i], this.font);
        }
        this.options.addElement(option);
    }

    public void setOptionState(int optionId, boolean state) {
        for (int i = 0; i < this.options.size(); ++i) {
            Option option = (Option)this.options.elementAt(i);
            if (option.optionId != optionId) continue;
            option.onOffState = state;
        }
    }

    public void setTitle(String title) {
        this.title = title;
        this.atlas.addLabel(title, title, this.font);
    }

    public void show() {
        int size = this.options.size();
        this.lastFrameVisibleOptionsCount = 0;
        for (int i = 0; i < size; ++i) {
            Option option = (Option)this.options.elementAt(i);
            option.hasPointerFocus = i == 0;
            option.highlightTimer = i == 0 ? 0.3f : 0.0f;
            option.forceHighlight = false;
            option.appear = true;
            option.dissapear = false;
            option.timer = (float)(-i) * 0.1f;
        }
    }

    public void hide(int optionId) {
        int size = this.options.size();
        for (int i = 0; i < size; ++i) {
            Option option = (Option)this.options.elementAt(i);
            option.dissapear = true;
            option.timer = (float)(-i) * 0.1f;
            if (option.optionId != optionId) continue;
            option.forceHighlight = true;
        }
    }

    public void update(float dt) {
        int size = this.options.size();
        int invisibleCount = 0;
        for (int i = 0; i < size; ++i) {
            Option option = (Option)this.options.elementAt(i);
            if (option.appear) {
                option.timer += dt;
                if (option.timer > 0.25f) {
                    option.appear = false;
                }
            }
            if (option.dissapear) {
                option.timer += dt;
                if (option.timer > 0.25f) {
                    ++invisibleCount;
                }
            }
            if (option.hasPointerFocus || option.forceHighlight) {
                option.highlightTimer += dt;
                option.highlightTimer = Math.min(0.3f, option.highlightTimer);
                continue;
            }
            option.highlightTimer -= dt;
            option.highlightTimer = Math.max(0.0f, option.highlightTimer);
        }
        int visibleCount = this.options.size() - invisibleCount;
        if (invisibleCount == this.options.size()) {
            this.listener.onMenuHidden();
        }
        if (this.lastFrameVisibleOptionsCount != this.options.size() && visibleCount == this.options.size()) {
            this.listener.onMenuVisible();
        }
        this.lastFrameVisibleOptionsCount = visibleCount;
    }

    public void render(Graphics3D g3d) {
        if (this.title != null) {
            this.drawLabel(g3d, -1, this.title, 10.0f, this.top - this.font.height() * 5 / 3, 1.0f, 4);
        }
        int size = this.options.size();
        block5: for (int i = 0; i < size; ++i) {
            Option opt = (Option)this.options.elementAt(i);
            float progress = this.animationProgress(opt);
            float scale = this.scale(progress);
            int drawColor = this.alpha(progress) << 24 | this.color(opt.highlightTimer);
            this.drawLabel(g3d, drawColor, opt.textId, 10.0f, opt.y, scale, 4);
            switch (opt.type) {
                case 1: {
                    this.drawLabel(g3d, drawColor, opt.onOffState ? "on" : "off", 230.0f, opt.y, scale, 8);
                    continue block5;
                }
                case 2: {
                    this.drawLabel(g3d, drawColor, opt.valuesIds[opt.selectedValue], 230.0f, opt.y, scale, 8);
                    continue block5;
                }
                case 0: {
                    continue block5;
                }
                default: {
                    Debug.error("Invalid label type " + opt.type);
                }
            }
        }
    }

    public void onPointerPressed(int x, int y) {
        this.updatePointerFocusFlag(y);
    }

    public void onPointerDragged(int x, int y) {
        this.updatePointerFocusFlag(y);
    }

    public void onPointerReleased(int x, int y) {
        this.updatePointerFocusFlag(y);
        this.fireEvent(this.findOption(y));
    }

    public void onKeyReleased(int code) {
        int selectedIndex = this.selectedOptionIndex();
        if (selectedIndex == -1) {
            return;
        }
        int optionsNum = this.options.size();
        if (code == 50) {
            if (selectedIndex > 0) {
                this.clearFocusFlag();
                ((Option)this.options.elementAt((int)(selectedIndex - 1))).hasPointerFocus = true;
            }
        } else if (code == 56) {
            if (selectedIndex < optionsNum - 1) {
                this.clearFocusFlag();
                ((Option)this.options.elementAt((int)(selectedIndex + 1))).hasPointerFocus = true;
            }
        } else if (code == 53) {
            this.fireEvent((Option)this.options.elementAt(selectedIndex));
        }
    }

    private int color(float timer) {
        float factor = Math.max(Math.min(timer / 0.3f, 1.0f), 0.0f);
        return Utils.lerpARGB(0xFFFFFF, 13270034, factor);
    }

    private int alpha(float animationProgress) {
        return (int)(255.0f * animationProgress);
    }

    private float scale(float animationProgress) {
        return animationProgress;
    }

    private float animationProgress(Option option) {
        float progress = 1.0f;
        if (option.appear) {
            progress = option.timer / 0.25f;
        } else if (option.dissapear) {
            progress = 1.0f - option.timer / 0.25f;
        }
        if (progress < 0.0f) {
            progress = 0.0f;
        } else if (progress > 1.0f) {
            progress = 1.0f;
        }
        return progress;
    }

    private void drawLabel(Graphics3D g3d, int color, String labelId, float x, float y, float scaleY, int align) {
        float translateX = 0.0f;
        if ((align & 8) != 0) {
            translateX = this.atlas.labelWidth(labelId);
        }
        this.transform.setIdentity();
        this.transform.postTranslate(x - translateX, y, 0.0f);
        this.transform.postTranslate(0.0f, (float)(this.font.height() / 2), 0.0f);
        this.transform.postScale(1.0f, scaleY, 1.0f);
        this.transform.postTranslate(0.0f, (float)(-this.font.height() / 2), 0.0f);
        this.atlas.drawLabel(g3d, labelId, this.transform, color);
    }

    private void updatePointerFocusFlag(int y) {
        int selectedIndex = this.selectedOptionIndex();
        this.clearFocusFlag();
        Option selected = this.findOption(y);
        if (selected != null) {
            selected.hasPointerFocus = true;
        } else if (selectedIndex != -1) {
            ((Option)this.options.elementAt((int)selectedIndex)).hasPointerFocus = true;
        }
    }

    private void clearFocusFlag() {
        int size = this.options.size();
        for (int i = 0; i < size; ++i) {
            Option option = (Option)this.options.elementAt(i);
            option.hasPointerFocus = false;
        }
    }

    private Option findOption(int y) {
        int index = (int)(((float)(y - this.top) - 5.0f) / ((float)this.font.height() + 10.0f));
        if (index >= 0 && index < this.options.size()) {
            return (Option)this.options.elementAt(index);
        }
        return null;
    }

    private int selectedOptionIndex() {
        int size = this.options.size();
        for (int i = 0; i < size; ++i) {
            if (!((Option)this.options.elementAt((int)i)).hasPointerFocus) continue;
            return i;
        }
        return -1;
    }

    private void fireEvent(Option opt) {
        if (opt != null && !opt.appear && !opt.dissapear) {
            switch (opt.type) {
                case 0: {
                    this.listener.onOptionClicked(opt.optionId);
                    break;
                }
                case 1: {
                    opt.onOffState = !opt.onOffState;
                    this.listener.onOptionStateChanged(opt.optionId, opt.onOffState);
                    break;
                }
                case 2: {
                    ++opt.selectedValue;
                    opt.selectedValue %= opt.valuesIds.length;
                    this.listener.onOptionIndexChanged(opt.optionId, opt.selectedValue);
                    break;
                }
                default: {
                    Debug.error("Invalid option type " + opt.type);
                }
            }
        }
    }

    private float nextOptionY() {
        int num = this.options.size();
        float y = this.top + num * this.font.height();
        return y += (float)num * 10.0f;
    }

    private class Option {
        public static final int TYPE_CLICKABLE = 0;
        public static final int TYPE_BOOLEAN = 1;
        public static final int TYLE_LIST = 2;
        public float y;
        public int optionId;
        public String textId;
        public int type;
        public boolean onOffState;
        public boolean forceHighlight;
        public String[] valuesIds;
        public int selectedValue;
        public boolean appear;
        public boolean dissapear;
        public float timer;
        public boolean hasPointerFocus;
        public float highlightTimer;

        public Option(int type, int optionId, String textId, float y) {
            this.type = type;
            this.y = y;
            this.optionId = optionId;
            this.textId = textId;
        }
    }
}

