/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx;

import com.gamelion.speedx.Debug;
import com.gamelion.speedx.FontPool;
import com.gamelion.speedx.IGameState;
import com.gamelion.speedx.Settings;
import com.gamelion.speedx.SoundPool;
import com.gamelion.speedx.SpeedXCanvas;
import com.gamelion.speedx.TexturePool;
import com.gamelion.speedx.game.Game;
import com.gamelion.speedx.menu.LabelsAtlas;
import com.gamelion.speedx.menu.Menu;
import com.gamelion.speedx.startupsequence.StartupSequence;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class SpeedXMIDlet
extends MIDlet
implements Runnable {
    public static final int STATE_STARTUP = 0;
    public static final int STATE_MENU = 1;
    public static final int STATE_GAME = 2;
    private Thread thread;
    private boolean paused;
    private boolean stop;
    private Display display;
    private SpeedXCanvas canvas;
    private long timeStamp;
    private Settings settings;
    private IGameState activeState;
    private IGameState nextState;
    private StartupSequence startupSequence;
    private Menu menu;
    private Game game;
    private FontPool fontPool;
    private TexturePool texturePool;
    private LabelsAtlas labelsAtlas;
    private SoundPool soundPool;
    private String version;
    private boolean afterSoundQuestion = false;

    public void stop() {
        this.onDestroy();
        this.notifyDestroyed();
    }

    public void changeState(int state) {
        if (state == 0) {
            this.nextState = this.startupSequence;
        } else if (state == 2) {
            this.nextState = this.game;
        } else if (state == 1) {
            this.nextState = this.menu;
        } else {
            Debug.error("unknown state id " + state);
            this.nextState = null;
        }
    }

    public void startMenu() {
        this.changeState(1);
    }

    public void startGame(int difficulty) {
        this.game.setDifficulty(difficulty);
        this.changeState(2);
    }

    public IGameState activeState() {
        return this.activeState;
    }

    public Menu menu() {
        return this.menu;
    }

    public Game game() {
        return this.game;
    }

    public SpeedXCanvas canvas() {
        return this.canvas;
    }

    public FontPool fontPool() {
        return this.fontPool;
    }

    public TexturePool texturePool() {
        return this.texturePool;
    }

    public LabelsAtlas labelsAtlas() {
        return this.labelsAtlas;
    }

    public SoundPool soundPool() {
        return this.soundPool;
    }

    public Settings settings() {
        return this.settings;
    }

    public String version() {
        return this.version;
    }

    public void markAfterSoundQuestion() {
        this.afterSoundQuestion = true;
    }

    public void onFocusChanged(boolean focused) {
        boolean bl = this.paused = !focused;
        if (this.activeState != null) {
            this.activeState.onFocusChanged(focused);
        }
        if (focused && this.afterSoundQuestion) {
            this.menu.startAudio();
        } else {
            this.menu.stopAudio();
        }
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        this.onDestroy();
    }

    protected void pauseApp() {
    }

    protected void startApp() throws MIDletStateChangeException {
        if (this.thread == null) {
            Debug.setLevel(0);
            Debug.trace("starting game thread");
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void run() {
        try {
            Debug.trace("game thread started");
            this.loadVersion();
            this.display = Display.getDisplay((MIDlet)this);
            this.canvas = new SpeedXCanvas(this);
            this.display.setCurrent((Displayable)this.canvas);
            this.canvas.setFullScreenMode(true);
            this.settings = new Settings();
            this.settings.load();
            this.fontPool = new FontPool();
            this.texturePool = new TexturePool();
            this.labelsAtlas = new LabelsAtlas();
            this.soundPool = new SoundPool();
            this.startupSequence = new StartupSequence(this);
            this.menu = new Menu(this);
            this.game = new Game(this);
            this.changeState(0);
            this.timeStamp = System.currentTimeMillis();
            while (!this.stop) {
                this.updateStateChanges();
                long now = System.currentTimeMillis();
                long dt = now - this.timeStamp;
                this.timeStamp = now;
                if (this.activeState != null) {
                    this.activeState.onUpdate((float)dt / 1000.0f);
                }
                this.canvas.repaint();
                this.canvas.serviceRepaints();
            }
            Debug.trace("game thread finished");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private void updateStateChanges() {
        if (this.nextState != null) {
            if (this.activeState != null) {
                this.activeState.onLeave();
            }
            this.activeState = this.nextState;
            this.nextState = null;
            this.activeState.onEnter();
        }
    }

    private void onDestroy() {
        this.stop = true;
    }

    private void loadVersion() {
        try {
            InputStream is = this.getClass().getResourceAsStream("/version.bin");
            DataInputStream dis = new DataInputStream(is);
            this.version = dis.readUTF();
        }
        catch (IOException ex) {
            Debug.error(ex, "");
        }
    }
}

