/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenAbout
implements IScreen {
    private MainCanvas mainCanvas;
    private static final int COMP_ID_BACK = 0;
    private static final int COMP_ID_INLOGIC = 1;
    private static final int TOTAL_COMP_IDS = 2;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iSelectedCompId;
    private int _iInteruption = 0;
    private int _iCycle = 10;
    private int _iMusicControler = 0;
    private int _iFinalHeight;
    private int _iTotalRowTiles = 0;
    private int _iTotalColTiles = 0;
    private int _iOffsetX;
    private int _iOffsetXDefault = 5;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private int[] _animationSequence = new int[4];
    private boolean _bChangeSequence = false;
    private Rectangle[] _rectItems = new Rectangle[2];
    private Rectangle _rectDialog;
    private Rectangle _rectTop;
    private Image _imgBg;
    private Image _imgCorpLogo;
    private Sprite _sprFkIcons;
    private PreparedText _ptAbout;
    private PreparedText _ptTitle;
    private AnimationComponent[] _animationComponents = new AnimationComponent[4];

    public ScreenAbout(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this.initSprites();
        this.initImages();
        this.initFonts();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.prepareTxt();
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 3});
        Resources.loadSprites(new int[]{0});
        Resources.loadGFont(0);
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2, 3});
        Resources.freeSprites(new int[]{0});
        Resources.freeGFont(0);
    }

    private void initDimensions() {
        this._WIDTH = this.mainCanvas.getWidth();
        this._HEIGHT = this.mainCanvas.getHeight();
    }

    private void initSprites() {
        this._sprFkIcons = Resources.resSprs[0];
    }

    private void initImages() {
        this._imgBg = Resources.resImgs[2];
        this._imgCorpLogo = Resources.resImgs[3];
    }

    private void initFonts() {
        this._ptAbout = new PreparedText(Resources.resGFonts[0]);
        this._ptTitle = new PreparedText(Resources.resGFonts[0]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0] = 0;
        this._animationSequence[1] = 1;
        this._animationSequence[2] = 2;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this._rectTop, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this._rectDialog, this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this._rectItems[0], this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(1);
    }

    private void prepareTxt() {
        this._ptAbout.prepareText(X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + ", " + X.singleton.getAppProperty("MIDlet-Version"), this._rectDialog.width);
        this._ptTitle.prepareText(Resources.resTexts[0].getHashedString(23), this._rectDialog.width);
    }

    private void freeGraphics() {
        this._imgBg = null;
        this._imgCorpLogo = null;
        this._sprFkIcons = null;
    }

    private void calculatePositions() {
        this._rectTop = new Rectangle(this._iOffsetXDefault, this._sprFkIcons.getHeight() - this._sprFkIcons.getHeight(), this._WIDTH - (this._iOffsetXDefault << 1), this._sprFkIcons.getHeight());
        int _windowWidth = this._WIDTH >> 1;
        int _offsetX = _windowWidth % this._sprFkIcons.getWidth() > 0 ? _windowWidth % this._sprFkIcons.getWidth() : this._sprFkIcons.getWidth();
        int _offsetTopY = (this._sprFkIcons.getHeight() - this._sprFkIcons.getHeight() << 1) + this._sprFkIcons.getHeight();
        int _offsetBottomY = this._sprFkIcons.getHeight() + (this._sprFkIcons.getHeight() - this._sprFkIcons.getHeight());
        int _panelHeight = this._HEIGHT - _offsetTopY - _offsetBottomY;
        this._iOffsetX = _offsetX;
        this._iFinalHeight = _panelHeight % this._sprFkIcons.getWidth() == 0 ? _panelHeight : _panelHeight - _panelHeight % this._sprFkIcons.getWidth();
        this._rectDialog = new Rectangle(_offsetX, _offsetTopY, this._WIDTH - (_offsetX << 1), this._iFinalHeight);
        this._rectItems[0] = new Rectangle(MainCanvas.WIDTH - (this._sprFkIcons.getWidth() << 1), MainCanvas.HEIGHT - (this._sprFkIcons.getHeight() << 1), this._sprFkIcons.getWidth() << 1, this._sprFkIcons.getHeight() << 1);
        this.calculateWindowTiles();
    }

    private void calculateWindowTiles() {
        this._iTotalColTiles = (this._WIDTH - (this._iOffsetX << 1)) / this._sprFkIcons.getWidth();
        this._iTotalRowTiles = this._iFinalHeight / this._sprFkIcons.getWidth();
    }

    public void beforeInteruption() {
        this.mainCanvas.getSoundManager().Stop();
        this._iInteruption = 1;
    }

    public void afterInteruption() {
        if (this._iInteruption == 0 && this.mainCanvas.getSoundManager().IsSoundOn()) {
            this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        }
    }

    public void update(long lastRunLenght) {
        this.updateSoundInterupt();
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void updateSoundInterupt() {
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _nextMode) {
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 2));
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintBody(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.drawImage(this._imgBg, 0, 0, 20);
    }

    private void paintBody(Graphics g) {
        this.paintTitle(g);
        this.paintCorpLogo(g);
        this.paintAbout(g);
    }

    private void paintTitle(Graphics g) {
        this._ptTitle.drawText(g, this._rectTop, this._ptAbout.getTextHeight() >> 2, 3);
    }

    private void paintWindow(Graphics g) {
    }

    private void paintCorpLogo(Graphics g) {
        g.drawImage(this._imgCorpLogo, this._rectDialog.getCenterX(), this._rectDialog.getCenterY(), 3);
    }

    private void paintAbout(Graphics g) {
        this._ptAbout.drawText(g, this._rectDialog, this._ptAbout.getTextHeight() >> 1, 33);
    }

    private void paintFK(Graphics g) {
        this._sprFkIcons.setFrame(5);
        this._sprFkIcons.setPosition(this._rectItems[0].x + (this._sprFkIcons.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1) + this._sprFkIcons.getWidth(), this._rectItems[0].y + (this._sprFkIcons.getHeight() >> 1) - (this._sprFkIcons.getHeight() >> 1) + this._sprFkIcons.getWidth());
        this._sprFkIcons.paint(g);
    }

    private int getWindowTileSprite(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < this._iTotalColTiles - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == this._iTotalColTiles - 1) {
            return 2;
        }
        if (_y == this._iTotalRowTiles - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < this._iTotalRowTiles - 1 && _y > 0) {
            return 3;
        }
        if (_x == this._iTotalColTiles - 1 && _y < this._iTotalRowTiles - 1 && _y > 0) {
            return 5;
        }
        if (_y == this._iTotalRowTiles - 1 && _x < this._iTotalColTiles - 1 && _x > 0) {
            return 7;
        }
        if (_y == this._iTotalRowTiles - 1 && _x == this._iTotalColTiles - 1) {
            return 8;
        }
        return 4;
    }

    public void keyPressed(int keyCode) {
        if (this._iInteruption == 1) {
            this._iInteruption = 0;
            this.afterInteruption();
        }
    }

    public void keyReleased(int keyCode) {
        if (Keys.isFKRightCode(keyCode)) {
            this.startAnimation(true, 0);
            this.mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this._rectItems.length; ++i) {
            if (this._rectItems[i] == null || !this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyPressed(-7);
                    break;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this._rectItems[this._iSelectedCompId].contains(x, y)) {
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this._iSelectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            default: {
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }
}

