/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import sk.inlogic.MainCanvas;
import sk.inlogic.util.Rectangle;

public class AnimationComponent {
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iDirection = -1;
    public static final int _LEFT = 0;
    public static final int _RIGHT = 1;
    public static final int _TOP = 2;
    public static final int _BOTTOM = 3;
    public static final int _TOP_LEFT_CORNER = 4;
    public static final int _TOP_RIGHT_CORNER = 5;
    public static final int _BOTTOM_LEFT_CORNER = 6;
    public static final int _BOTTOM_RIGHT_CORNER = 7;
    private int _iState = 0;
    private int _STOP_ANIMATION = 0;
    private int _SHOW_ANIMATION = 1;
    private int _HIDE_ANIMATION = 2;
    private int _INPROGRESS_ANIMATION = 3;
    private Rectangle _defaultRectangle;
    private boolean _bShow;
    private int _iDefaultX;
    private int _iDefaultY;
    private int _iDefaultWidth;
    private int _iDefaultHeight;
    private int _iActualX;
    private int _iActualY;
    private int _iActualWidth;
    private int _iActualHeight;
    private int _iSteps = 6;
    private int _iStepCounter = 0;
    private int _iShiftPerStepsX = 0;
    private int _iShiftPerStepsY = 0;
    private int _iShiftX = 0;
    private int _iShiftY = 0;
    private int _iOffsetX = 0;
    private int _iOffsetY = 0;
    private MainCanvas mainCanvas;

    public AnimationComponent(MainCanvas mc, Rectangle _rectangle, int width, int height) {
        this.mainCanvas = mc;
        this._defaultRectangle = _rectangle;
        this._WIDTH = width;
        this._HEIGHT = height;
        this._iDefaultX = _rectangle.x;
        this._iDefaultY = _rectangle.y;
        this._iDefaultWidth = _rectangle.width;
        this._iDefaultHeight = _rectangle.height;
    }

    public void startShowAnimation(int _direction) {
        this._iDirection = _direction;
        this.initVarForShowAnimation(_direction);
    }

    public void startHideAnimation(int _direction) {
        this.initVarForHideAnimation(_direction);
    }

    private void initVarForShowAnimation(int _direction) {
        switch (_direction) {
            case 0: {
                this._bShow = true;
                this.prepareRectangleLeftShow();
                this.setAnimationState(this._SHOW_ANIMATION);
                break;
            }
            case 1: {
                this._bShow = true;
                this.prepareRectangleRightShow();
                this.setAnimationState(this._SHOW_ANIMATION);
                break;
            }
            case 2: {
                this._bShow = true;
                this.prepareRectangleTopShow();
                this.setAnimationState(this._SHOW_ANIMATION);
                break;
            }
            case 3: {
                this._bShow = true;
                this.prepareRectangleBottomShow();
                this.setAnimationState(this._SHOW_ANIMATION);
                break;
            }
            case 4: {
                this._bShow = true;
                this.prepareRectangleUpLeftCornerShow();
                this.setAnimationState(this._SHOW_ANIMATION);
                break;
            }
            case 5: {
                this._bShow = true;
                this.prepareRectangleUpRightCornerShow();
                this.setAnimationState(this._SHOW_ANIMATION);
                break;
            }
            case 6: {
                this._bShow = true;
                this.prepareRectangleDownLeftCornerShow();
                this.setAnimationState(this._SHOW_ANIMATION);
                break;
            }
            case 7: {
                this._bShow = true;
                this.prepareRectangleDownRightCornerShow();
                this.setAnimationState(this._SHOW_ANIMATION);
            }
        }
    }

    private void initVarForHideAnimation(int _direction) {
        switch (_direction) {
            case 0: {
                this._bShow = false;
                this.setAnimationState(this._HIDE_ANIMATION);
                break;
            }
            case 1: {
                this._bShow = false;
                this.setAnimationState(this._HIDE_ANIMATION);
                break;
            }
            case 2: {
                this._bShow = false;
                this.setAnimationState(this._HIDE_ANIMATION);
                break;
            }
            case 3: {
                this._bShow = false;
                this.setAnimationState(this._HIDE_ANIMATION);
                break;
            }
            case 4: {
                this._bShow = false;
                this.setAnimationState(this._HIDE_ANIMATION);
                break;
            }
            case 5: {
                this._bShow = false;
                this.setAnimationState(this._HIDE_ANIMATION);
                break;
            }
            case 6: {
                this._bShow = false;
                this.setAnimationState(this._HIDE_ANIMATION);
                break;
            }
            case 7: {
                this._bShow = false;
                this.setAnimationState(this._HIDE_ANIMATION);
            }
        }
    }

    private void prepareRectangleLeftShow() {
        this._defaultRectangle.x = this._iActualX = 0 - this._iDefaultWidth;
        this._iShiftX = Math.abs(this._defaultRectangle.x) + this._iDefaultX;
        this._iOffsetX = this._iShiftX % this._iSteps;
        this._iShiftPerStepsX = this._iShiftX / this._iSteps;
    }

    private void prepareRectangleRightShow() {
        this._defaultRectangle.x = this._iActualX = this._WIDTH;
        this._iShiftX = Math.abs(this._WIDTH - this._iDefaultX);
        this._iOffsetX = this._iShiftX % this._iSteps;
        this._iShiftPerStepsX = this._iShiftX / this._iSteps;
    }

    private void prepareRectangleTopShow() {
        this._defaultRectangle.y = this._iActualY = 0 - this._iDefaultHeight;
        this._iShiftY = Math.abs(this._defaultRectangle.y) + this._iDefaultY;
        this._iOffsetY = this._iShiftY % this._iSteps;
        this._iShiftPerStepsX = this._iShiftY / this._iSteps;
    }

    private void prepareRectangleBottomShow() {
        this._defaultRectangle.y = this._iActualY = this._HEIGHT;
        this._iShiftY = Math.abs(this._HEIGHT - this._iDefaultY);
        this._iOffsetY = this._iShiftY % this._iSteps;
        this._iShiftPerStepsX = this._iShiftY / this._iSteps;
    }

    private void prepareRectangleUpLeftCornerShow() {
        this._defaultRectangle.x = this._iActualX = 0 - this._iDefaultWidth;
        this._defaultRectangle.y = this._iActualY = 0 - this._iDefaultHeight;
        this._iShiftX = Math.abs(this._defaultRectangle.x) + this._iDefaultX;
        this._iShiftY = Math.abs(this._defaultRectangle.y) + this._iDefaultY;
        this._iOffsetX = this._iShiftX % this._iSteps;
        this._iOffsetY = this._iShiftY % this._iSteps;
        this._iShiftPerStepsX = this._iShiftX / this._iSteps;
        this._iShiftPerStepsY = this._iShiftY / this._iSteps;
    }

    private void prepareRectangleUpRightCornerShow() {
        this._defaultRectangle.x = this._iActualX = this._WIDTH;
        this._defaultRectangle.y = this._iActualY = 0 - this._iDefaultHeight;
        this._iShiftX = Math.abs(this._WIDTH - this._iDefaultX);
        this._iShiftY = Math.abs(this._defaultRectangle.y) + this._iDefaultY;
        this._iOffsetX = this._iShiftX % this._iSteps;
        this._iOffsetY = this._iShiftY % this._iSteps;
        this._iShiftPerStepsX = this._iShiftX / this._iSteps;
        this._iShiftPerStepsY = this._iShiftY / this._iSteps;
    }

    private void prepareRectangleDownLeftCornerShow() {
        this._defaultRectangle.x = this._iActualX = 0 - this._iDefaultWidth;
        this._defaultRectangle.y = this._iActualY = this._HEIGHT;
        this._iShiftX = Math.abs(this._defaultRectangle.x) + this._iDefaultX;
        this._iShiftY = Math.abs(this._HEIGHT - this._iDefaultY);
        this._iOffsetX = this._iShiftX % this._iSteps;
        this._iOffsetY = this._iShiftY % this._iSteps;
        this._iShiftPerStepsX = this._iShiftX / this._iSteps;
        this._iShiftPerStepsY = this._iShiftY / this._iSteps;
    }

    private void prepareRectangleDownRightCornerShow() {
        this._defaultRectangle.x = this._iActualX = this._WIDTH;
        this._defaultRectangle.y = this._iActualY = this._HEIGHT;
        this._iShiftX = Math.abs(this._WIDTH - this._iDefaultX);
        this._iShiftY = Math.abs(this._HEIGHT - this._iDefaultY);
        this._iOffsetX = this._iShiftX % this._iSteps;
        this._iOffsetY = this._iShiftY % this._iSteps;
        this._iShiftPerStepsX = this._iShiftX / this._iSteps;
        this._iShiftPerStepsY = this._iShiftY / this._iSteps;
    }

    public void update() {
        if (this._bShow) {
            if (this._iState == this._SHOW_ANIMATION || this._iState == this._INPROGRESS_ANIMATION) {
                if (this._iDirection == 0) {
                    this.showLeftAnimation();
                } else if (this._iDirection == 1) {
                    this.showRightAnimation();
                } else if (this._iDirection == 2) {
                    this.showTopAnimation();
                } else if (this._iDirection == 3) {
                    this.showBottomAnimation();
                } else if (this._iDirection == 4) {
                    this.showTopLeftCornerAnimation();
                } else if (this._iDirection == 5) {
                    this.showTopRightCornerAnimation();
                } else if (this._iDirection == 6) {
                    this.showBottomLeftCornerAnimation();
                } else if (this._iDirection == 7) {
                    this.showBottomRightCornerAnimation();
                }
            }
        } else if (this._iState == this._HIDE_ANIMATION || this._iState == this._INPROGRESS_ANIMATION) {
            if (this._iDirection == 0) {
                this.hideLeftAnimation();
            } else if (this._iDirection == 1) {
                this.hideRightAnimation();
            } else if (this._iDirection == 2) {
                this.hideTopAnimation();
            } else if (this._iDirection == 3) {
                this.hideBottomAnimation();
            } else if (this._iDirection == 4) {
                this.hideTopLeftCornerAnimation();
            } else if (this._iDirection == 5) {
                this.hideTopRightCornerAnimation();
            } else if (this._iDirection == 6) {
                this.hideBottomLeftCornerAnimation();
            } else if (this._iDirection == 7) {
                this.hideBottomRightCornerAnimation();
            }
        }
    }

    private void showLeftAnimation() {
        if (this._iStepCounter < this._iSteps) {
            this._defaultRectangle.x += this._iShiftPerStepsX;
            ++this._iStepCounter;
            this.setAnimationState(this._INPROGRESS_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetX > 0) {
            this._defaultRectangle.x += this._iOffsetX;
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        this.setAnimationState(this._STOP_ANIMATION);
        this.mainCanvas.repaint();
    }

    private void showRightAnimation() {
        if (this._iStepCounter < this._iSteps) {
            this._defaultRectangle.x -= this._iShiftPerStepsX;
            ++this._iStepCounter;
            this.setAnimationState(this._INPROGRESS_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetX > 0) {
            this._defaultRectangle.x -= this._iOffsetX;
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        this.setAnimationState(this._STOP_ANIMATION);
        this.mainCanvas.repaint();
    }

    private void showTopAnimation() {
        if (this._iStepCounter < this._iSteps) {
            this._defaultRectangle.y += this._iShiftPerStepsX;
            ++this._iStepCounter;
            this.setAnimationState(this._INPROGRESS_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetY > 0) {
            this._defaultRectangle.y += this._iOffsetY;
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        this.setAnimationState(this._STOP_ANIMATION);
        this.mainCanvas.repaint();
    }

    private void showBottomAnimation() {
        if (this._iStepCounter < this._iSteps) {
            this._defaultRectangle.y -= this._iShiftPerStepsX;
            ++this._iStepCounter;
            this.setAnimationState(this._INPROGRESS_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetY > 0) {
            this._defaultRectangle.y -= this._iOffsetY;
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        this.setAnimationState(this._STOP_ANIMATION);
        this.mainCanvas.repaint();
    }

    private void showTopLeftCornerAnimation() {
        if (this._iStepCounter < this._iSteps) {
            this._defaultRectangle.x += this._iShiftPerStepsX;
            this._defaultRectangle.y += this._iShiftPerStepsY;
            ++this._iStepCounter;
            this.setAnimationState(this._INPROGRESS_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetY > 0) {
            this._defaultRectangle.y += this._iOffsetY;
            if (this._iOffsetX > 0) {
                this._defaultRectangle.x += this._iOffsetX;
            }
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetX > 0) {
            this._defaultRectangle.x += this._iOffsetX;
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        this.setAnimationState(this._STOP_ANIMATION);
        this.mainCanvas.repaint();
    }

    private void showTopRightCornerAnimation() {
        if (this._iStepCounter < this._iSteps) {
            this._defaultRectangle.x -= this._iShiftPerStepsX;
            this._defaultRectangle.y += this._iShiftPerStepsY;
            ++this._iStepCounter;
            this.setAnimationState(this._INPROGRESS_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetY > 0) {
            this._defaultRectangle.y += this._iOffsetY;
            if (this._iOffsetX > 0) {
                this._defaultRectangle.x -= this._iOffsetX;
            }
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetX > 0) {
            this._defaultRectangle.x -= this._iOffsetX;
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        this.setAnimationState(this._STOP_ANIMATION);
        this.mainCanvas.repaint();
    }

    private void showBottomLeftCornerAnimation() {
        if (this._iStepCounter < this._iSteps) {
            this._defaultRectangle.x += this._iShiftPerStepsX;
            this._defaultRectangle.y -= this._iShiftPerStepsY;
            ++this._iStepCounter;
            this.setAnimationState(this._INPROGRESS_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetY > 0) {
            this._defaultRectangle.y -= this._iOffsetY;
            if (this._iOffsetX > 0) {
                this._defaultRectangle.x += this._iOffsetX;
            }
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetX > 0) {
            this._defaultRectangle.x += this._iOffsetX;
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        this.setAnimationState(this._STOP_ANIMATION);
        this.mainCanvas.repaint();
    }

    private void showBottomRightCornerAnimation() {
        if (this._iStepCounter < this._iSteps) {
            this._defaultRectangle.x -= this._iShiftPerStepsX;
            this._defaultRectangle.y -= this._iShiftPerStepsY;
            ++this._iStepCounter;
            this.setAnimationState(this._INPROGRESS_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetY > 0) {
            this._defaultRectangle.y -= this._iOffsetY;
            if (this._iOffsetX > 0) {
                this._defaultRectangle.x -= this._iOffsetX;
            }
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetX > 0) {
            this._defaultRectangle.x -= this._iOffsetX;
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        this.setAnimationState(this._STOP_ANIMATION);
        this.mainCanvas.repaint();
    }

    private void hideLeftAnimation() {
        if (this._iStepCounter > 0) {
            this._defaultRectangle.x -= this._iShiftPerStepsX;
            --this._iStepCounter;
            this.setAnimationState(this._INPROGRESS_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetX > 0) {
            this._defaultRectangle.x -= this._iOffsetX;
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        this.setAnimationState(this._STOP_ANIMATION);
        this.mainCanvas.repaint();
    }

    private void hideRightAnimation() {
        if (this._iStepCounter > 0) {
            this._defaultRectangle.x += this._iShiftPerStepsX;
            --this._iStepCounter;
            this.setAnimationState(this._INPROGRESS_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetX > 0) {
            this._defaultRectangle.x += this._iOffsetX;
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        this.setAnimationState(this._STOP_ANIMATION);
        this.mainCanvas.repaint();
    }

    private void hideTopAnimation() {
        if (this._iStepCounter > 0) {
            this._defaultRectangle.y -= this._iShiftPerStepsX;
            --this._iStepCounter;
            this.setAnimationState(this._INPROGRESS_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetY > 0) {
            this._defaultRectangle.y -= this._iOffsetY;
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        this.setAnimationState(this._STOP_ANIMATION);
        this.mainCanvas.repaint();
    }

    private void hideBottomAnimation() {
        if (this._iStepCounter > 0) {
            this._defaultRectangle.y += this._iShiftPerStepsX;
            --this._iStepCounter;
            this.setAnimationState(this._INPROGRESS_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetY > 0) {
            this._defaultRectangle.y += this._iOffsetY;
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        this.setAnimationState(this._STOP_ANIMATION);
        this.mainCanvas.repaint();
    }

    private void hideTopLeftCornerAnimation() {
        if (this._iStepCounter > 0) {
            this._defaultRectangle.x -= this._iShiftPerStepsX;
            this._defaultRectangle.y -= this._iShiftPerStepsY;
            --this._iStepCounter;
            this.setAnimationState(this._INPROGRESS_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetY > 0) {
            this._defaultRectangle.y -= this._iOffsetY;
            if (this._iOffsetX > 0) {
                this._defaultRectangle.x -= this._iOffsetX;
            }
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetX > 0) {
            this._defaultRectangle.x -= this._iOffsetX;
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        this.setAnimationState(this._STOP_ANIMATION);
        this.mainCanvas.repaint();
    }

    private void hideTopRightCornerAnimation() {
        if (this._iStepCounter > 0) {
            this._defaultRectangle.x += this._iShiftPerStepsX;
            this._defaultRectangle.y -= this._iShiftPerStepsY;
            --this._iStepCounter;
            this.setAnimationState(this._INPROGRESS_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetY > 0) {
            this._defaultRectangle.y -= this._iOffsetY;
            if (this._iOffsetX > 0) {
                this._defaultRectangle.x += this._iOffsetX;
            }
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetX > 0) {
            this._defaultRectangle.x += this._iOffsetX;
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        this.setAnimationState(this._STOP_ANIMATION);
        this.mainCanvas.repaint();
    }

    private void hideBottomLeftCornerAnimation() {
        if (this._iStepCounter > 0) {
            this._defaultRectangle.x -= this._iShiftPerStepsX;
            this._defaultRectangle.y += this._iShiftPerStepsY;
            --this._iStepCounter;
            this.setAnimationState(this._INPROGRESS_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetY > 0) {
            this._defaultRectangle.y += this._iOffsetY;
            if (this._iOffsetX > 0) {
                this._defaultRectangle.x -= this._iOffsetX;
            }
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetX > 0) {
            if (this._iOffsetX > 0) {
                this._defaultRectangle.x -= this._iOffsetX;
            }
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        this.setAnimationState(this._STOP_ANIMATION);
        this.mainCanvas.repaint();
    }

    private void hideBottomRightCornerAnimation() {
        if (this._iStepCounter > 0) {
            this._defaultRectangle.x += this._iShiftPerStepsX;
            this._defaultRectangle.y += this._iShiftPerStepsX;
            --this._iStepCounter;
            this.setAnimationState(this._INPROGRESS_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetY > 0) {
            this._defaultRectangle.y += this._iOffsetY;
            if (this._iOffsetX > 0) {
                this._defaultRectangle.x += this._iOffsetX;
            }
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        if (this._iOffsetX > 0) {
            this._defaultRectangle.x += this._iOffsetX;
            this.setAnimationState(this._STOP_ANIMATION);
            this.mainCanvas.repaint();
            return;
        }
        this.setAnimationState(this._STOP_ANIMATION);
        this.mainCanvas.repaint();
    }

    public boolean isComponentAnimated() {
        return this._iState == this._STOP_ANIMATION;
    }

    public void setAnimationState(int _newState) {
        this._iState = _newState;
    }

    public int getAnimationState() {
        return this._iState;
    }
}

