/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Elements {
    private MyCanvas canvas;
    public int xPosition;
    public int yPosition;
    public int width;
    public int height;
    public byte xVel;
    public byte yVel;
    public byte dir;
    public byte stage;
    public byte type;
    public boolean hidden;
    public boolean collided;
    private int length;
    private int rand;
    private boolean isEnd;
    int tileX;
    int tileY;
    private byte frame = 0;

    public Elements(int xPosition, int yPosition, int width, int height, int xVel, int yVel, boolean hidden, int type, int tileX, int tileY, MyCanvas canvas) {
        this.canvas = canvas;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.xVel = (byte)xVel;
        this.yVel = (byte)yVel;
        this.hidden = hidden;
        this.tileX = tileX;
        this.tileY = tileY;
        this.type = (byte)type;
    }

    public void draw(Graphics g) {
        try {
            switch (this.type) {
                case 0: {
                    this.xPosition += this.xVel;
                    this.yPosition += this.yVel;
                    g.setColor(0xADADAD);
                    g.fillRect(this.xPosition, this.yPosition, this.width, this.height);
                    g.setColor(12100352);
                    g.drawLine(this.xPosition, this.yPosition, this.xPosition - 2 * this.xVel, this.yPosition - 2 * this.yVel);
                    g.setColor(5118464);
                    g.drawLine(this.xPosition + 1, this.yPosition + 1, this.xPosition - 2 * this.xVel + 1, this.yPosition - 2 * this.yVel + 1);
                    break;
                }
                case 1: {
                    this.xPosition += this.xVel;
                    this.yPosition += this.yVel;
                    g.setColor(0xADADAD);
                    g.fillRect(this.xPosition, this.yPosition, this.width, this.height);
                    g.setColor(12100352);
                    g.drawLine(this.xPosition, this.yPosition, this.xPosition - 2 * this.xVel, this.yPosition - 2 * this.yVel);
                    g.setColor(5118464);
                    g.drawLine(this.xPosition + 1, this.yPosition + 1, this.xPosition - 2 * this.xVel + 1, this.yPosition - 2 * this.yVel + 1);
                    break;
                }
                case 2: {
                    if (this.collided) {
                        this.rand = 6 + this.stage;
                        g.drawRegion(MyCanvas.levelTileImg, (int)this.canvas.tileClip[this.rand << 2], (int)this.canvas.tileClip[(this.rand << 2) + 1], (int)this.canvas.tileClip[(this.rand << 2) + 2], (int)this.canvas.tileClip[(this.rand << 2) + 3], 0, this.xPosition + 24, this.yPosition, 0);
                        g.drawRegion(MyCanvas.levelTileImg, (int)this.canvas.tileClip[this.rand << 2], (int)this.canvas.tileClip[(this.rand << 2) + 1], (int)this.canvas.tileClip[(this.rand << 2) + 2], (int)this.canvas.tileClip[(this.rand << 2) + 3], 0, this.xPosition, this.yPosition, 0);
                        this.stage = (byte)(this.stage + 1);
                        if (this.stage <= 3) break;
                        this.hidden = true;
                        break;
                    }
                    this.rand = 5;
                    g.drawRegion(MyCanvas.levelTileImg, (int)this.canvas.tileClip[this.rand << 2], (int)this.canvas.tileClip[(this.rand << 2) + 1], (int)this.canvas.tileClip[(this.rand << 2) + 2], (int)this.canvas.tileClip[(this.rand << 2) + 3], 0, this.xPosition, this.yPosition, 0);
                    this.yPosition += this.yVel;
                    break;
                }
                case 3: {
                    this.rand = 3;
                    g.drawRegion(MyCanvas.effectsImg, (int)this.canvas.effectClip[this.rand * 6 + 0], (int)this.canvas.effectClip[this.rand * 6 + 1], (int)this.canvas.effectClip[this.rand * 6 + 2], (int)this.canvas.effectClip[this.rand * 6 + 3], 0, this.xPosition, this.yPosition + 24, 0);
                    this.rand = 5;
                    g.drawRegion(MyCanvas.effectsImg, (int)this.canvas.effectClip[this.rand * 6 + 0], (int)this.canvas.effectClip[this.rand * 6 + 1], (int)this.canvas.effectClip[this.rand * 6 + 2], (int)this.canvas.effectClip[this.rand * 6 + 3], 0, this.xPosition + (24 - this.canvas.effectClip[this.rand * 6 + 2] >> 1), this.yPosition - this.stage + 24 / 2, 0);
                    this.stage = (byte)(this.stage + 2);
                    if (this.stage <= 24) break;
                    this.hidden = true;
                    break;
                }
                case 4: {
                    this.rand = 3;
                    g.drawRegion(MyCanvas.effectsImg, (int)this.canvas.effectClip[this.rand * 6 + 0], (int)this.canvas.effectClip[this.rand * 6 + 1], (int)this.canvas.effectClip[this.rand * 6 + 2], (int)this.canvas.effectClip[this.rand * 6 + 3], 0, this.xPosition, this.yPosition + 24, 0);
                    this.rand = 6;
                    g.drawRegion(MyCanvas.effectsImg, (int)this.canvas.effectClip[this.rand * 6 + 0], (int)this.canvas.effectClip[this.rand * 6 + 1], (int)this.canvas.effectClip[this.rand * 6 + 2], (int)this.canvas.effectClip[this.rand * 6 + 3], 0, this.xPosition + (24 - this.canvas.effectClip[this.rand * 6 + 2] >> 1), this.yPosition - this.stage + 24 / 2, 0);
                    this.stage = (byte)(this.stage + 2);
                    if (this.stage <= 24) break;
                    this.hidden = true;
                    break;
                }
                case 5: {
                    this.rand = (7 + this.frame) * 6;
                    if (this.xVel == 0 || this.xVel == 1) {
                        g.drawRegion(MyCanvas.effectsImg, (int)this.canvas.effectClip[this.rand + 0], (int)this.canvas.effectClip[this.rand + 1], (int)this.canvas.effectClip[this.rand + 2], (int)this.canvas.effectClip[this.rand + 3], 0, this.xPosition - this.canvas.effectClip[this.rand + 2], this.yPosition - (this.canvas.effectClip[this.rand + 3] >> 1), 0);
                    }
                    if (this.xVel == 0 || this.xVel == -1) {
                        g.drawRegion(MyCanvas.effectsImg, (int)this.canvas.effectClip[this.rand + 0], (int)this.canvas.effectClip[this.rand + 1], (int)this.canvas.effectClip[this.rand + 2], (int)this.canvas.effectClip[this.rand + 3], 2, this.xPosition, this.yPosition - (this.canvas.effectClip[this.rand + 3] >> 1), 0);
                    }
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame <= 2) break;
                    this.hidden = true;
                    break;
                }
                case 6: {
                    this.rand = (29 + this.frame) * 4;
                    g.drawRegion(MyCanvas.levelTileImg, (int)this.canvas.tileClip[this.rand], (int)this.canvas.tileClip[this.rand + 1], (int)this.canvas.tileClip[this.rand + 2], (int)this.canvas.tileClip[this.rand + 3], 0, this.xPosition, this.yPosition, 0);
                    this.xPosition += this.xVel;
                    break;
                }
                case 7: {
                    this.rand = (10 + this.frame) * 6;
                    g.drawRegion(MyCanvas.effectsImg, (int)this.canvas.effectClip[this.rand + 0], (int)this.canvas.effectClip[this.rand + 1], (int)this.canvas.effectClip[this.rand + 2], (int)this.canvas.effectClip[this.rand + 3], 0, this.xPosition + this.canvas.effectClip[this.rand + 4], this.yPosition + this.canvas.effectClip[this.rand + 4], 0);
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame <= 2) break;
                    this.hidden = true;
                    break;
                }
                case 8: {
                    if (this.length == 0) {
                        if (this.isEnd) {
                            this.height -= this.yVel;
                            if (this.height <= 0) {
                                this.isEnd = false;
                                ++this.length;
                            }
                        } else {
                            this.height += this.yVel;
                            if (this.height >= 24 << 2) {
                                this.isEnd = true;
                                ++this.length;
                            }
                        }
                    } else {
                        this.length = this.length < 10 ? (this.length = this.length + 1) : 0;
                    }
                    this.rand = (31 + this.frame) * 4;
                    for (int i = 0; i < this.height; i += this.yVel) {
                        g.drawRegion(MyCanvas.levelTileImg, (int)this.canvas.tileClip[this.rand], (int)this.canvas.tileClip[this.rand + 1], (int)this.canvas.tileClip[this.rand + 2], (int)this.yVel, 0, this.xPosition, this.yPosition + i, 0);
                    }
                    this.rand = (32 + this.frame) * 4;
                    g.drawRegion(MyCanvas.levelTileImg, (int)this.canvas.tileClip[this.rand], (int)this.canvas.tileClip[this.rand + 1], (int)this.canvas.tileClip[this.rand + 2], (int)this.canvas.tileClip[this.rand + 3], 0, this.xPosition, this.yPosition + this.height, 0);
                    break;
                }
                case 9: {
                    if (this.length == 0) {
                        if (this.isEnd) {
                            this.frame = (byte)(this.frame - 1);
                            if (this.frame <= 0) {
                                this.isEnd = false;
                                ++this.length;
                            }
                        } else {
                            this.frame = (byte)(this.frame + 1);
                            if (this.frame >= 2) {
                                this.isEnd = true;
                                ++this.length;
                            }
                        }
                    } else {
                        this.length = this.length < 8 ? (this.length = this.length + 1) : 0;
                    }
                    this.rand = 104;
                    g.drawRegion(MyCanvas.levelTileImg, this.canvas.tileClip[this.rand] + this.canvas.tileClip[this.rand + 2] * this.frame, (int)this.canvas.tileClip[this.rand + 1], (int)this.canvas.tileClip[this.rand + 2], (int)this.canvas.tileClip[this.rand + 3], 0, this.xPosition, this.yPosition + this.height, 0);
                    break;
                }
                case 10: {
                    this.rand = (MyCanvas.gameLevel == 5 ? 14 : 26) * 4;
                    g.drawRegion(MyCanvas.levelTileImg, this.canvas.tileClip[this.rand] + this.canvas.tileClip[this.rand + 2] * this.frame, (int)this.canvas.tileClip[this.rand + 1], (int)this.canvas.tileClip[this.rand + 2], (int)this.canvas.tileClip[this.rand + 3], 0, this.xPosition, this.yPosition + this.height, 0);
                    break;
                }
                case 11: {
                    this.rand = ((byte)(MyCanvas.gameLevel == 5 ? 5 : 33) + this.frame) * 4;
                    this.stage = (byte)(this.stage + 1);
                    if (this.stage >= 3) {
                        if (this.canvas.levelTileMap[this.tileY][this.tileX] == '~') {
                            this.canvas.levelTileMap[this.tileY][this.tileX] = 64;
                        }
                        g.drawRegion(MyCanvas.levelTileImg, (int)this.canvas.tileClip[this.rand], (int)this.canvas.tileClip[this.rand + 1], (int)this.canvas.tileClip[this.rand + 2], (int)this.canvas.tileClip[this.rand + 3], 0, this.xPosition, this.yPosition + this.length, 0);
                        this.length += this.yVel;
                        this.frame = (byte)(this.frame + 1);
                    }
                    if (this.stage == 4) {
                        if (this.canvas.levelTileMap[this.tileY][this.tileX + 1] == '~') {
                            this.canvas.addElementArr(new Elements(this.xPosition + 24, this.yPosition, 24, 24, 0, 24 >> 2, false, 11, this.tileX + 1, this.tileY, this.canvas));
                        }
                        if (this.canvas.levelTileMap[this.tileY][this.tileX - 1] != '~') break;
                        this.canvas.addElementArr(new Elements(this.xPosition - 24, this.yPosition, 24, 24, 0, 24 >> 2, false, 11, this.tileX - 1, this.tileY, this.canvas));
                        break;
                    }
                    if (this.frame <= 4) break;
                    this.stage = 0;
                    this.hidden = true;
                    break;
                }
                case 12: {
                    this.frame = (byte)this.width;
                    if (this.stage % 4 != 0) {
                        g.drawRegion(MyCanvas.effectsImg, 112 + (this.frame % 2 == 1 ? 0 : 22), 87 + (this.frame < 3 ? 0 : 22), 22, 22, 0, this.canvas.hero.xPosition, this.canvas.hero.yPosition - 24, 0);
                    }
                    this.stage = (byte)(this.stage + 1);
                    if (this.stage <= 10) break;
                    this.hidden = true;
                }
            }
        }
        catch (Exception e) {
            System.out.println(this.frame + "err in Elements draw " + this.type + " type>>" + e);
        }
        if (!this.canvas.isInView(this.xPosition, this.yPosition, this.width, this.height) && this.type != 11) {
            this.hidden = true;
            if (this.type == 8 || this.type == 9 || this.type == 10) {
                char[] cArray = this.canvas.levelTileMap[this.tileY];
                int n = this.tileX;
                cArray[n] = (char)(cArray[n] - 32);
            }
        }
        this.checkCollison();
    }

    private void checkCollison() {
        try {
            block1 : switch (this.type) {
                case 0: {
                    for (int i = 0; i < this.canvas.enemyArr.length; ++i) {
                        if (this.canvas.enemyArr[i] == null || this.canvas.enemyArr[i].isDead || !MyCanvas.intersectsOfSprites(this.xPosition, this.yPosition, this.width, this.height, this.canvas.enemyArr[i].xPosition, this.canvas.enemyArr[i].yPosition, this.canvas.enemyArr[i].width, this.canvas.enemyArr[i].height)) continue;
                        this.canvas.enemyArr[i].hits = (byte)(this.canvas.enemyArr[i].hits + 10);
                        if (this.canvas.enemyArr[i].hits >= this.canvas.enemyArr[i].hitCounter) {
                            this.canvas.enemyArr[i].isDead = true;
                            this.canvas.score += 100;
                            if (this.canvas.enemyArr[i].type < 2) {
                                this.canvas.enemyArr[i].frame = 0;
                            } else if (this.canvas.enemyArr[i].type == 3) {
                                this.canvas.enemyArr[i].frame = (byte)4;
                            }
                            this.canvas.enemyArr[i].frameCtr = 0;
                        }
                        this.canvas.addTopLayerElement(new Elements(this.xPosition, this.yPosition, 0, 0, 0, 0, false, 7, 0, 0, this.canvas));
                        this.hidden = true;
                        break block1;
                    }
                    break;
                }
                case 1: 
                case 6: {
                    if (!this.hidden && this.checkHeroAttack()) {
                        this.hidden = true;
                        this.canvas.addTopLayerElement(new Elements(this.xPosition, this.yPosition, 0, 0, 0, 0, false, 7, 0, 0, this.canvas));
                        break;
                    }
                    if (this.canvas.hero.isHit || this.hidden || this.collided || !MyCanvas.intersectsOfSprites(this.xPosition, this.yPosition, this.width, this.height, this.canvas.hero.xPosition, this.canvas.hero.yPosition + (this.canvas.hero.action == 8 || this.canvas.hero.action == 15 || this.canvas.hero.action == 13 ? this.canvas.hero.height / 2 : 0), this.canvas.hero.width, this.canvas.hero.height / (this.canvas.hero.action == 8 || this.canvas.hero.action == 15 || this.canvas.hero.action == 13 ? 2 : 1))) break;
                    this.canvas.hero.isHit = true;
                    this.hidden = true;
                    this.canvas.addTopLayerElement(new Elements(this.xPosition, this.yPosition, 0, 0, 0, 0, false, 7, 0, 0, this.canvas));
                    break;
                }
                case 2: {
                    if (this.canvas.hero.isHit || this.hidden || this.collided || !MyCanvas.intersectsOfSprites(this.xPosition, this.yPosition, this.width, this.height, this.canvas.hero.xPosition, this.canvas.hero.yPosition, this.canvas.hero.width, this.canvas.hero.height)) break;
                    this.canvas.hero.isHit = true;
                    this.canvas.life = (byte)(this.canvas.life - 5);
                    break;
                }
                case 8: {
                    if (!(this.canvas.hero.isHit || this.hidden || this.collided)) {
                        if (MyCanvas.intersectsOfSprites(this.xPosition, this.yPosition + this.height, this.width, 24, this.canvas.hero.xPosition, this.canvas.hero.yPosition + (this.canvas.hero.action == 8 ? this.canvas.hero.height / 2 : 0), this.canvas.hero.width, this.canvas.hero.height / (this.canvas.hero.action == 8 ? 4 : 2))) {
                            this.canvas.hero.isHit = true;
                            this.canvas.life = (byte)(this.canvas.life - 5);
                        }
                    }
                    if (!MyCanvas.intersectsOfSprites(this.canvas.hero.xPosition, this.canvas.hero.yPosition, this.canvas.hero.width, this.canvas.hero.height, this.xPosition, this.yPosition, this.width, this.height + 24)) break;
                    if (this.canvas.hero.xPosition < this.xPosition) {
                        this.canvas.hero.xPosition = this.xPosition - this.canvas.hero.width;
                        break;
                    }
                    this.canvas.hero.xPosition = this.xPosition + this.width;
                    break;
                }
                case 9: {
                    if (this.canvas.hero.isHit || this.hidden || this.frame != 0) break;
                    if (!MyCanvas.intersectsOfSprites(this.xPosition, this.yPosition + (24 >> 1), this.width, this.height, this.canvas.hero.xPosition, this.canvas.hero.yPosition + (this.canvas.hero.action == 8 ? this.canvas.hero.height / 2 : 0), this.canvas.hero.width, this.canvas.hero.height / (this.canvas.hero.action == 8 ? 2 : 1))) break;
                    this.canvas.hero.isHit = true;
                    this.canvas.life = (byte)(this.canvas.life - 5);
                    break;
                }
                case 10: {
                    if (this.canvas.hero.isHit || this.hidden) break;
                    if (!MyCanvas.intersectsOfSprites(this.xPosition, this.yPosition + (24 >> 1), this.width, this.height, this.canvas.hero.xPosition, this.canvas.hero.yPosition + (this.canvas.hero.action == 8 ? this.canvas.hero.height / 2 : 0), this.canvas.hero.width, this.canvas.hero.height / (this.canvas.hero.action == 8 ? 2 : 1))) break;
                    this.canvas.life = 0;
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in elements type " + this.type + " checkCollison>>" + e);
        }
    }

    private boolean checkHeroAttack() {
        switch (this.canvas.hero.action) {
            case 25: {
                if (this.canvas.hero.frame != 2 || !MyCanvas.intersectsOfSprites(this.canvas.hero.dir > 0 ? this.canvas.hero.xPosition + this.canvas.hero.width : this.canvas.hero.xPosition - (this.canvas.hero.width << 1), this.canvas.hero.yPosition - 12, this.canvas.hero.width << 1, this.canvas.hero.height, this.xPosition, this.yPosition, this.width, this.height)) break;
                return true;
            }
            case 26: {
                if (this.canvas.hero.frame != 5 || !MyCanvas.intersectsOfSprites(this.canvas.hero.dir > 0 ? this.canvas.hero.xPosition + this.canvas.hero.width : this.canvas.hero.xPosition - (this.canvas.hero.width << 1), this.canvas.hero.yPosition - 12, this.canvas.hero.width << 1, this.canvas.hero.height, this.xPosition, this.yPosition, this.width, this.height)) break;
                return true;
            }
            case 27: {
                if (this.canvas.hero.frame != 2 || !MyCanvas.intersectsOfSprites(this.canvas.hero.dir > 0 ? this.canvas.hero.xPosition + this.canvas.hero.width : this.canvas.hero.xPosition - (this.canvas.hero.width << 1), this.canvas.hero.yPosition - 12, this.canvas.hero.width << 1, this.canvas.hero.height, this.xPosition, this.yPosition, this.width, this.height)) break;
                return true;
            }
        }
        return false;
    }
}

