/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Hero {
    private MyCanvas canvas;
    public int xPosition;
    public int yPosition;
    public int width;
    public int height;
    public byte dir = 1;
    public byte frame;
    public byte bowPos = 1;
    private byte heroOffY;
    public byte frameCtr;
    public byte framePtr;
    public byte xVel;
    public byte yVel;
    public int jumpCtr;
    public int jumpLimit;
    public boolean JumpHtReached;
    public byte actionFrmPtr = 0;
    public boolean isHit = false;
    private byte hitCounter = 0;
    public boolean receiveKeypressed = false;
    public boolean swordLock = false;
    public byte weapon = 0;
    public boolean fireArrow;
    private byte waitCtr;
    public boolean isDead;
    private boolean isEnd;
    public byte action = 0;
    public static final byte STAND = 0;
    public static final byte RUN = 1;
    public static final byte JUMP = 2;
    public static final byte EDGE_HANG = 3;
    public static final byte EDGE_CLIMB = 4;
    public static final byte DIE = 5;
    public static final byte FALL = 6;
    public static final byte POWERUP_BREAK = 7;
    public static final byte CROUCH = 8;
    public static final byte SLIDE = 9;
    public static final byte HORSE_RIDE = 10;
    public static final byte BOW_ARROW = 11;
    public static final byte DIE_ON_HORSE = 12;
    public static final byte HORSE_CROUCH = 15;
    public static final byte HORSE_JUMP = 23;
    public static final byte SLIDE_DUCK = 13;
    public static final byte HAND_FIGHT = 14;
    public static final byte TOP_EDGE_CLIMB = 16;
    public static final byte TOP_EDGE_GETDOWN = 17;
    public static final byte SEQENCE_1 = 18;
    public static final byte SEQENCE_2 = 19;
    public static final byte SEQENCE_3 = 20;
    public static final byte SEQENCE_4 = 21;
    public static final byte SEQENCE_5 = 22;
    public static final byte SEQENCE_MOVE = 24;
    public static final byte SWORD_1 = 25;
    public static final byte SWORD_2 = 26;
    public static final byte SWORD_3 = 27;
    public byte imageNo;
    private byte imageRotation;
    private byte[] seqArr = new byte[]{8, 3, 3, 3, 4};
    public static Image[] image;
    public byte swordLockCtr = (byte)10;
    public short[] heroClipping = new short[]{0, 0, 28, 58, 28, 1, 28, 57, 56, 0, 28, 58, 84, 1, 32, 57, 116, 3, 20, 55, 136, 2, 27, 56, 163, 0, 40, 58, 203, 2, 32, 56, 235, 2, 19, 56, 0, 9, 26, 46, 26, 8, 26, 47, 52, 0, 25, 55, 77, 2, 22, 53, 0, 6, 28, 30, 28, 8, 39, 28, 67, 7, 36, 29, 103, 0, 26, 36, 0, 36, 9, 30, 9, 36, 26, 30, 35, 36, 15, 29, 50, 36, 26, 28, 76, 36, 29, 14, 76, 50, 29, 20, 9, 66, 26, 5, 50, 64, 26, 13, 105, 50, 12, 20, 0, 0, 20, 69, 20, 18, 24, 51, 44, 8, 28, 61, 72, 16, 33, 53, 105, 18, 31, 51, 136, 12, 25, 57, 161, 24, 29, 45, 190, 35, 27, 34, 0, 9, 38, 60, 38, 0, 50, 69, 88, 10, 72, 59, 160, 19, 72, 50, 0, 0, 36, 57, 36, 10, 34, 47, 70, 38, 64, 19, 134, 7, 30, 50, 164, 9, 43, 48, 207, 7, 42, 50, 26, 7, 76, 56, 102, 0, 82, 63, 0, 63, 77, 61, 77, 63, 79, 61, 156, 67, 36, 33, 0, 35, 26, 28, 156, 100, 30, 24, 99, 8, 32, 47, 0, 2, 51, 51, 52, 1, 65, 52, 117, 1, 47, 52, 164, 0, 57, 53, 0, 60, 63, 54, 63, 53, 65, 61, 128, 74, 53, 40, 181, 74, 61, 40, 0, 117, 30, 50, 30, 118, 51, 49, 0, 117, 30, 50, 81, 114, 50, 53, 131, 114, 52, 53, 183, 114, 70, 53, 0, 10, 38, 58, 38, 0, 35, 68, 73, 9, 40, 59, 113, 19, 49, 49, 164, 19, 49, 49, 213, 22, 45, 46, 258, 22, 38, 46, 254, 21, 29, 37, 0, 23, 33, 58, 33, 30, 51, 51, 84, 15, 48, 66, 132, 44, 29, 37, 132, 0, 40, 44, 172, 0, 41, 44, 163, 46, 45, 35, 184, 47, 30, 28, 0, 0, 71, 87, 71, 7, 100, 80, 171, 1, 82, 86, 283, 2, 26, 56, 131, 17, 34, 38};
    private byte[] heroPlacingRt = new byte[]{0, 0, 0, 1, -1, 0, -6, 1, 2, 3, 0, 2, -10, 0, -7, 2, 3, 2, -2, 1, 4, 1, 4, 0, 8, 5, 0, 28, -2, 0, -2, -1, -2, -8, 27, -3, 16, -3, 20, -10, 12, -10, 6, -8, 6, -8, 14, 10, 11, -1, 13, -10, 0, 0, -8, 1, -20, -43, -25, -44, -12, -56, -3, 0, 15, -21, 23, -31, -4, -2, 0, -11, 0, -1, 0, 8, -2, 1, -1, 11, -1, 39, 1, 8, -6, 10, 1, 8, -25, 19, -32, 16, -28, 17, -28, 17, -5, 0, 0, 0, 8, 21, -3, 14, -5, 7, -5, 6, -5, 6, -24, 5, -24, 4, -3, -3, -5, 18, -5, 18, 6, 8, 5, 9, 6, 8, -8, 5, -1, 5, 2, 5, -10, 0, -4, -10, -4, -1, -19, -3, -19, -3, 2, 12, 2, 12, 0, 22, 0, -1, -20, 6, 0, -9, 2, 20, -9, 13, -10, 13, 4, 22, 7, 11, -23, -10, -41, 0, -34, 0, 0, 1, 1, 26};
    private byte[] heroPlacingLf = new byte[]{0, 0, 0, 1, 1, 0, 2, 1, 6, 3, 1, 2, -2, 0, 3, 2, 6, 2, 4, 1, -2, 1, -1, 0, -2, 5, 0, 28, -9, 0, -6, -1, 4, -8, -8, -3, -8, -3, -7, -10, -7, -10, -7, -8, -7, -8, -12, 10, -9, -1, 3, -10, -4, 0, 4, 1, 12, -43, 12, -44, 1, -56, -2, 0, -16, -21, -26, -31, -6, -2, -22, -11, -44, -1, -44, 8, -6, 1, -5, 11, -35, 39, -3, 8, -9, 10, -15, 8, -25, 19, -32, 16, -28, 17, -28, 17, -5, 0, 0, 0, 8, 21, -1, 14, -19, 9, -36, 8, -17, 8, -9, 7, -14, 6, -37, -1, -28, 19, -25, 19, 3, 11, -17, 12, 3, 11, -13, 8, -20, 8, -39, 8, -4, 1, -7, -9, -12, 0, -5, -5, -5, -5, -18, 14, -12, 14, -1, 22, -5, -1, -3, 6, -25, -9, -3, 20, -3, 13, -3, 13, -24, 22, 7, 11, -23, -10, -41, 0, -34, 0, 0, 1, -7, 26};
    private byte[] framePos = new byte[]{0, 2, 9, 13, 26, 34, 38, 41, 44, 51, 52, 60, 63, 66, 69, 73, 74, 81, 82, 85, 86};

    public Hero(int xPosition, int yPosition, int width, int height, int direction, boolean hidden, MyCanvas canvas) {
        this.canvas = canvas;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.dir = (byte)direction;
    }

    public static void initResources() {
        try {
            image = new Image[11];
            if (MyCanvas.gameLevel == 2) {
                Hero.image[2] = Image.createImage((String)"/h_bow_arrow.png");
                Hero.image[6] = Image.createImage((String)"/h_horse.png");
                Hero.image[10] = Image.createImage((String)"/h_horse_jump.png");
            } else {
                Hero.image[0] = Image.createImage((String)"/h_st_run.png");
                Hero.image[5] = Image.createImage((String)"/h_die.png");
                Hero.image[7] = Image.createImage((String)"/h_seq1.png");
                Hero.image[8] = Image.createImage((String)"/h_seq2.png");
                if (MyCanvas.gameLevel != 4) {
                    Hero.image[1] = Image.createImage((String)"/h_jump.png");
                    Hero.image[2] = Image.createImage((String)"/h_bow_arrow.png");
                    Hero.image[3] = Image.createImage((String)"/h_eg_hang.png");
                    Hero.image[4] = Image.createImage((String)"/h_sword.png");
                    Hero.image[9] = Image.createImage((String)"/h_handfight.png");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in Hero Image Creation :" + e.toString());
        }
    }

    void updateHero() {
        try {
            switch (this.action) {
                case 0: {
                    if (MyCanvas.gameLevel == 2) {
                        this.action = (byte)10;
                        this.frame = 1;
                        this.frameCtr = 0;
                        this.yVel = (byte)5;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(4) || MyCanvas.haveKeyHold(4)) {
                        this.action = 1;
                        this.dir = 1;
                    } else if (MyCanvas.haveKeyPressed(64) || MyCanvas.haveKeyHold(64)) {
                        this.action = 1;
                        this.dir = (byte)-1;
                    } else if (MyCanvas.haveKeyPressed(16)) {
                        this.action = (byte)8;
                    }
                    if (MyCanvas.haveKeyPressed(1)) {
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 2;
                        this.jumpCtr = 0;
                        this.xVel = (byte)(24 >> 1);
                        this.JumpHtReached = false;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(256)) {
                        if (MyCanvas.isPowerAvailable) {
                            this.action = (byte)7;
                            this.frame = 0;
                            this.frameCtr = 0;
                            break;
                        }
                        if (this.checkForHandFight()) {
                            this.action = (byte)14;
                            this.canvas.playSound(6);
                            this.frame = (byte)-1;
                            break;
                        }
                        this.action = (byte)MyCanvas.random(25, 27);
                        this.canvas.playSound(4);
                        this.frame = (byte)-1;
                        this.frameCtr = 0;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(2048) && this.canvas.arrowCount > 0) {
                        this.action = (byte)11;
                        this.frame = 1;
                        this.frameCtr = 0;
                        this.weapon = 1;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(128)) {
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 2;
                        this.jumpCtr = 0;
                        this.JumpHtReached = false;
                        this.dir = (byte)-1;
                        this.xVel = (byte)(24 >> 1);
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(2)) break;
                    this.action = (byte)2;
                    this.frame = (byte)-1;
                    this.jumpLimit = 2;
                    this.jumpCtr = 0;
                    this.JumpHtReached = false;
                    this.dir = 1;
                    this.xVel = (byte)(24 >> 1);
                    break;
                }
                case 1: {
                    if (MyCanvas.haveKeyReleased(4) || MyCanvas.haveKeyReleased(64)) {
                        if (this.weapon == 0) {
                            this.action = 0;
                            this.frame = 0;
                        } else {
                            this.action = (byte)11;
                            this.frame = 1;
                        }
                        this.frameCtr = 0;
                    }
                    if (MyCanvas.haveKeyHold(4)) {
                        this.action = 1;
                        this.dir = 1;
                    } else if (MyCanvas.haveKeyHold(64)) {
                        this.action = 1;
                        this.dir = (byte)-1;
                    } else if (MyCanvas.haveKeyPressed(16)) {
                        this.action = (byte)8;
                    } else if (MyCanvas.haveKeyPressed(256)) {
                        this.action = (byte)MyCanvas.random(25, 27);
                        this.canvas.playSound(4);
                        this.frame = (byte)-1;
                    }
                    if (!MyCanvas.haveKeyPressed(1)) break;
                    this.action = (byte)2;
                    this.frame = (byte)-1;
                    this.jumpLimit = 2;
                    this.jumpCtr = 0;
                    this.JumpHtReached = false;
                    this.xVel = (byte)(24 >> 1);
                    break;
                }
                case 8: {
                    if (!MyCanvas.haveKeyReleased(16) && !MyCanvas.haveKeyPressed(1)) break;
                    if (this.weapon == 0) {
                        this.action = 0;
                        this.frame = 0;
                    } else {
                        this.action = (byte)11;
                        this.frame = 1;
                    }
                    this.frameCtr = 0;
                    break;
                }
                case 2: {
                    if (!MyCanvas.haveKeyHold(1) || this.jumpLimit >= 3) break;
                    ++this.jumpLimit;
                    break;
                }
                case 9: {
                    if (MyCanvas.haveKeyPressed(1)) {
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 2;
                        this.jumpCtr = 0;
                        this.xVel = (byte)(24 >> 1);
                        this.JumpHtReached = false;
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(16)) break;
                    this.action = (byte)13;
                    break;
                }
                case 13: {
                    if (!MyCanvas.haveKeyReleased(16) && !MyCanvas.haveKeyPressed(1)) break;
                    this.action = (byte)9;
                    break;
                }
                case 11: {
                    this.fireArrow = false;
                    if (MyCanvas.gameLevel != 2 && MyCanvas.haveKeyPressed(2048)) {
                        this.action = 0;
                        this.weapon = 0;
                    } else if (MyCanvas.haveKeyPressed(1)) {
                        this.bowPos = this.bowPos < 3 ? (this.bowPos = (byte)(this.bowPos + 1)) : this.bowPos;
                    } else if (MyCanvas.haveKeyPressed(16)) {
                        this.bowPos = this.bowPos > 1 ? (this.bowPos = (byte)(this.bowPos - 1)) : this.bowPos;
                    } else if (!this.fireArrow && MyCanvas.haveKeyPressed(256)) {
                        if (MyCanvas.gameLevel != 2) {
                            this.canvas.arrowCount = (byte)(this.canvas.arrowCount - 1);
                        }
                        if (MyCanvas.isPowerAvailable) {
                            this.action = (byte)7;
                            this.frame = 0;
                            this.frameCtr = 0;
                        } else {
                            this.fireArrow = true;
                            switch (this.frame) {
                                case 1: {
                                    this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 39 : -12), this.yPosition + 12, 3, 3, (24 * MyCanvas.cos(0) >> 9) * this.dir, -(24 * MyCanvas.sin(0) >> 9), false, 0, 0, 0, this.canvas));
                                    break;
                                }
                                case 2: {
                                    this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 36 : -9), this.yPosition - 1, 3, 3, (24 * MyCanvas.cos(25) >> 9) * this.dir, -(24 * MyCanvas.sin(25) >> 9), false, 0, 0, 0, this.canvas));
                                    break;
                                }
                                case 3: {
                                    this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 24 : 3), this.yPosition - 10, 3, 3, (24 * MyCanvas.cos(60) >> 9) * this.dir, -(24 * MyCanvas.sin(60) >> 9), false, 0, 0, 0, this.canvas));
                                }
                            }
                            this.canvas.playSound(5);
                        }
                    }
                    if (MyCanvas.gameLevel == 2 && (MyCanvas.haveKeyPressed(4) || MyCanvas.haveKeyHold(4))) {
                        this.action = (byte)10;
                        this.dir = 1;
                        break;
                    }
                    if (MyCanvas.gameLevel != 2) {
                        if (MyCanvas.haveKeyPressed(4) || MyCanvas.haveKeyHold(4)) {
                            if (this.dir == 1) {
                                this.action = 1;
                                this.dir = 1;
                                break;
                            }
                            this.dir = 1;
                            break;
                        }
                        if (!MyCanvas.haveKeyPressed(64) && !MyCanvas.haveKeyHold(64)) break;
                        if (this.dir == -1) {
                            this.action = 1;
                            this.dir = (byte)-1;
                            break;
                        }
                        this.dir = (byte)-1;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(8)) {
                        this.action = (byte)15;
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(4)) break;
                    this.action = (byte)23;
                    this.frame = (byte)-1;
                    this.jumpLimit = 2;
                    this.jumpCtr = 0;
                    this.xVel = (byte)(24 >> 1);
                    this.JumpHtReached = false;
                    break;
                }
                case 15: {
                    if (!MyCanvas.haveKeyReleased(8) && !MyCanvas.haveKeyPressed(2)) break;
                    this.action = (byte)10;
                    this.frame = 1;
                    this.frameCtr = 0;
                    break;
                }
                case 10: {
                    this.fireArrow = false;
                    if (MyCanvas.haveKeyPressed(1)) {
                        this.bowPos = this.bowPos < 3 ? (this.bowPos = (byte)(this.bowPos + 1)) : this.bowPos;
                    } else if (MyCanvas.haveKeyPressed(16)) {
                        this.bowPos = this.bowPos > 1 ? (this.bowPos = (byte)(this.bowPos - 1)) : this.bowPos;
                    } else if (!this.fireArrow && MyCanvas.haveKeyPressed(256)) {
                        if (MyCanvas.gameLevel != 2) {
                            this.canvas.arrowCount = (byte)(this.canvas.arrowCount - 1);
                        }
                        this.fireArrow = true;
                        switch (this.frame) {
                            case 1: {
                                this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 39 : -12), this.yPosition + 12, 3, 3, (24 * MyCanvas.cos(0) >> 9) * this.dir, -(24 * MyCanvas.sin(0) >> 9), false, 0, 0, 0, this.canvas));
                                break;
                            }
                            case 2: {
                                this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 36 : -9), this.yPosition - 1, 3, 3, (24 * MyCanvas.cos(25) >> 9) * this.dir, -(24 * MyCanvas.sin(25) >> 9), false, 0, 0, 0, this.canvas));
                                break;
                            }
                            case 3: {
                                this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 24 : 3), this.yPosition - 10, 3, 3, (24 * MyCanvas.cos(60) >> 9) * this.dir, -(24 * MyCanvas.sin(60) >> 9), false, 0, 0, 0, this.canvas));
                            }
                        }
                        this.canvas.playSound(5);
                    }
                    if (MyCanvas.haveKeyPressed(8)) {
                        this.action = (byte)15;
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(4)) break;
                    this.action = (byte)23;
                    this.frame = (byte)-1;
                    this.jumpLimit = 2;
                    this.jumpCtr = 0;
                    this.xVel = (byte)(24 >> 1);
                    this.JumpHtReached = false;
                    break;
                }
                case 3: {
                    if (MyCanvas.haveKeyPressed(1)) {
                        if (MyCanvas.isReadyToClimb) {
                            this.action = (byte)16;
                            this.xPosition = this.canvas.edgeOffX;
                            this.yPosition = this.canvas.edgeOffY;
                            break;
                        }
                        this.action = (byte)4;
                        this.frame = 0;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(16)) {
                        this.action = (byte)6;
                        this.yPosition += 24 >> 2;
                        break;
                    }
                    if (this.dir > 0 && (MyCanvas.haveKeyPressed(64) || MyCanvas.haveKeyPressed(128))) {
                        this.action = (byte)2;
                        this.dir = (byte)-1;
                        this.frame = (byte)-1;
                        this.jumpLimit = 3;
                        this.jumpCtr = 0;
                        this.xVel = (byte)(24 >> 1);
                        this.JumpHtReached = false;
                        break;
                    }
                    if (this.dir >= 0 || !MyCanvas.haveKeyPressed(4) && !MyCanvas.haveKeyPressed(2)) break;
                    this.action = (byte)2;
                    this.dir = 1;
                    this.frame = (byte)-1;
                    this.jumpLimit = 3;
                    this.jumpCtr = 0;
                    this.xVel = (byte)(24 >> 1);
                    this.JumpHtReached = false;
                    break;
                }
                case 6: {
                    this.xVel = 0;
                    if (MyCanvas.haveKeyHold(4) || MyCanvas.haveKeyHold(2)) {
                        if (MyCanvas.isReadyToClimb) {
                            this.action = (byte)3;
                            this.xPosition = this.canvas.edgeOffX;
                            this.yPosition = this.canvas.edgeOffY;
                            this.frame = (byte)-1;
                        }
                        this.dir = 1;
                        this.xVel = (byte)6;
                        break;
                    }
                    if (!MyCanvas.haveKeyHold(64) && !MyCanvas.haveKeyHold(128)) break;
                    if (MyCanvas.isReadyToClimb) {
                        this.action = (byte)3;
                        this.xPosition = this.canvas.edgeOffX;
                        this.yPosition = this.canvas.edgeOffY;
                        this.frame = (byte)-1;
                    }
                    this.dir = (byte)-1;
                    this.xVel = (byte)6;
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in updateHero>>" + e);
        }
    }

    private void updateHeroForBoss() {
        try {
            if (this.swordLock) {
                this.swordLockCtr = (byte)(this.swordLockCtr - 1);
                if (MyCanvas.haveKeyPressed(256)) {
                    this.canvas.addTopLayerElement(new Elements(this.canvas.hero.xPosition + (this.canvas.hero.dir == 1 ? this.canvas.hero.width << 1 : -this.canvas.hero.width), this.canvas.hero.yPosition + (this.canvas.hero.height >> 1), 0, 0, 0, 0, false, 5, 0, 0, this.canvas));
                    this.swordLockCtr = (byte)(this.swordLockCtr + 6);
                }
                if (this.swordLockCtr >= 25) {
                    this.frame = 0;
                    this.frameCtr = 0;
                    this.waitCtr = 0;
                    this.swordLock = false;
                    if (this.canvas.boss.life < 10) {
                        this.action = (byte)22;
                        this.canvas.playSound(5);
                        this.canvas.boss.setAction((byte)6);
                        this.receiveKeypressed = false;
                        return;
                    }
                    this.swordLockCtr = (byte)10;
                    this.action = (byte)20;
                    this.canvas.boss.life = (byte)(this.canvas.boss.life - 5);
                    this.canvas.boss.setAction((byte)5);
                } else if (this.swordLockCtr < 0) {
                    this.swordLock = false;
                    this.swordLockCtr = (byte)10;
                    this.action = 0;
                    this.frame = 0;
                    this.actionFrmPtr = 0;
                    this.imageNo = 0;
                    this.waitCtr = 0;
                    this.canvas.boss.setAction((byte)1);
                }
                return;
            }
            if (this.action == 8 && (MyCanvas.haveKeyReleased(16) || MyCanvas.haveKeyPressed(1))) {
                this.action = 0;
            }
            if (this.canvas.boss != null && this.canvas.boss.life <= 0 || !this.receiveKeypressed || this.canvas.boss.action == 1) {
                return;
            }
            if (MyCanvas.haveKeyPressed(256)) {
                this.action = (byte)MyCanvas.random(19, 21);
                if (this.canvas.boss.life < 10) {
                    this.action = (byte)19;
                }
                if (this.action == 21) {
                    this.canvas.playSound(4);
                    this.canvas.boss.setAction((byte)MyCanvas.random(2, 3));
                } else if (this.action == 20) {
                    this.canvas.boss.setAction((byte)5);
                } else if (this.action == 19) {
                    this.canvas.boss.setAction((byte)4);
                }
                this.frameCtr = 0;
                this.frame = 0;
                this.waitCtr = 0;
            } else if (this.action == 0 && MyCanvas.haveKeyHold(4)) {
                if (this.xPosition < MyCanvas.canvasWidth - this.canvas.boss.width * 3) {
                    this.xPosition += 4;
                }
                this.action = (byte)24;
            } else if (this.action == 0 && MyCanvas.haveKeyHold(64)) {
                this.xPosition -= 4;
                this.action = (byte)24;
            } else if (this.action == 0 && MyCanvas.haveKeyHold(16)) {
                this.action = (byte)8;
            } else if (this.canvas.boss.action != 1) {
                if (MyCanvas.random(0, 10) < 2) {
                    byte by = this.canvas.currPage;
                    this.canvas.getClass();
                    if (by != 18) {
                        this.canvas.boss.setAction((byte)1);
                        this.receiveKeypressed = false;
                        this.canvas.boss.waitCtr = 0;
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in updateHeroForBoss>>" + e);
        }
    }

    void update() {
        try {
            byte by = this.canvas.currPage;
            this.canvas.getClass();
            if (by != 18) {
                if (MyCanvas.gameLevel == 4 && this.action != 5) {
                    this.updateHeroForBoss();
                } else if (MyCanvas.gameLevel != 4) {
                    this.updateHero();
                }
            }
            if (this.dir == 1) {
                this.imageRotation = 0;
                this.canvas.HeroXposOnScr = (MyCanvas.canvasWidth >> 1) - this.width * (MyCanvas.gameLevel == 2 ? 3 : 1);
            } else {
                this.imageRotation = (byte)2;
                this.canvas.HeroXposOnScr = MyCanvas.canvasWidth >> 1;
            }
            switch (this.action) {
                case 0: {
                    this.receiveKeypressed = true;
                    this.xVel = 0;
                    this.weapon = 0;
                    this.actionFrmPtr = 0;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    if (this.frameCtr > 3) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    this.imageNo = 0;
                    if (this.frame > 1) {
                        this.frame = 0;
                    }
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                    break;
                }
                case 1: {
                    this.actionFrmPtr = 1;
                    this.frame = (byte)(this.frame + 1);
                    this.imageNo = 0;
                    if (this.frame > 6) {
                        this.frame = 0;
                    }
                    this.xPosition += 10 * this.dir;
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                    break;
                }
                case 8: {
                    this.imageNo = 0;
                    this.actionFrmPtr = (byte)15;
                    this.frame = 0;
                    break;
                }
                case 2: {
                    this.actionFrmPtr = (byte)2;
                    this.imageNo = 1;
                    this.xPosition += this.xVel * this.dir;
                    if (this.JumpHtReached) {
                        if (!MyCanvas.isGroundTouched) {
                            this.frame = (byte)2;
                            this.action = (byte)6;
                            this.yPosition += 24 >> 2;
                            break;
                        }
                    }
                    if (this.JumpHtReached) {
                        if (MyCanvas.isGroundTouched) {
                            this.frame = (byte)2;
                            this.action = (byte)6;
                            this.yPosition += 24 >> 2;
                            break;
                        }
                    }
                    if (this.jumpCtr >= this.jumpLimit) break;
                    if (this.frame < 1) {
                        this.frame = (byte)(this.frame + 1);
                    }
                    if (this.frame != 0) {
                        this.yPosition -= 24 >> 1;
                        ++this.jumpCtr;
                    }
                    if (this.jumpCtr < this.jumpLimit) break;
                    this.JumpHtReached = true;
                    break;
                }
                case 11: {
                    this.actionFrmPtr = (byte)3;
                    this.imageNo = (byte)2;
                    this.frame = this.bowPos;
                    if (MyCanvas.gameLevel != 2 && !MyCanvas.isGroundTouched) {
                        this.imageNo = 1;
                        this.frame = (byte)2;
                        this.action = (byte)6;
                        this.actionFrmPtr = (byte)2;
                    } else if (MyCanvas.gameLevel == 2 && !MyCanvas.isGroundTouched) {
                        this.action = (byte)23;
                        this.xVel = (byte)(24 >> 1);
                        this.JumpHtReached = true;
                    }
                    if (MyCanvas.gameLevel == 2 || this.canvas.arrowCount >= 1) break;
                    this.action = 0;
                    this.weapon = 0;
                    break;
                }
                case 15: {
                    this.actionFrmPtr = (byte)8;
                    this.frame = 1;
                    this.imageNo = (byte)6;
                    this.heroOffY = (byte)(this.heroOffY + 1);
                    if (this.heroOffY > 3) {
                        this.heroOffY = 0;
                    }
                    this.xPosition += 4 * this.dir;
                    break;
                }
                case 10: {
                    this.actionFrmPtr = (byte)3;
                    this.imageNo = (byte)2;
                    this.frame = this.bowPos;
                    this.heroOffY = (byte)(this.heroOffY + 1);
                    if (this.heroOffY > 3) {
                        this.heroOffY = 0;
                    }
                    this.xPosition += 4 * this.dir;
                    if (MyCanvas.gameLevel != 2 || MyCanvas.isGroundTouched) break;
                    this.action = (byte)23;
                    this.xVel = (byte)(24 >> 1);
                    this.JumpHtReached = true;
                    break;
                }
                case 23: {
                    this.actionFrmPtr = (byte)18;
                    this.imageNo = (byte)10;
                    this.xPosition += this.xVel * this.dir;
                    if (this.JumpHtReached) {
                        if (MyCanvas.isGroundTouched) {
                            this.action = (byte)10;
                            this.actionFrmPtr = (byte)3;
                            this.imageNo = (byte)2;
                            this.frame = 1;
                            this.frameCtr = 0;
                            break;
                        }
                    }
                    if (this.JumpHtReached) {
                        if (!MyCanvas.isGroundTouched) {
                            this.frame = (byte)2;
                            this.yPosition += 24 >> 2;
                            break;
                        }
                    }
                    if (this.jumpCtr >= this.jumpLimit) break;
                    if (this.frame < 1) {
                        this.frame = (byte)(this.frame + 1);
                    }
                    if (this.frame != 0) {
                        this.yPosition -= 24 >> 1;
                        ++this.jumpCtr;
                    }
                    if (this.jumpCtr < this.jumpLimit) break;
                    this.JumpHtReached = true;
                    break;
                }
                case 12: {
                    this.actionFrmPtr = (byte)8;
                    this.frame = 0;
                    this.imageNo = (byte)6;
                    if (this.frameCtr < 8) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                    } else {
                        this.yVel = (byte)(this.yVel + 1);
                        this.frameCtr = 0;
                    }
                    if (this.yVel <= 6) break;
                    this.yVel = (byte)6;
                    this.canvas.getClass();
                    this.canvas.currPage = (byte)9;
                    this.canvas.shutterY = 0;
                    this.canvas.shutterMaxY = 24 * 2;
                    break;
                }
                case 3: {
                    this.actionFrmPtr = (byte)4;
                    this.imageNo = (byte)3;
                    break;
                }
                case 4: {
                    this.actionFrmPtr = (byte)4;
                    this.imageNo = (byte)3;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame != 5) break;
                    this.action = (byte)6;
                    this.yPosition -= 24 * 2;
                    break;
                }
                case 16: {
                    this.actionFrmPtr = (byte)4;
                    this.imageNo = (byte)3;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame <= 7) break;
                    if (this.weapon == 0) {
                        this.action = 0;
                        this.frame = 0;
                        this.actionFrmPtr = 0;
                        this.imageNo = 0;
                    } else {
                        this.action = (byte)11;
                        this.frame = 1;
                        this.actionFrmPtr = (byte)3;
                        this.imageNo = (byte)2;
                    }
                    this.frameCtr = 0;
                    this.yPosition -= this.height;
                    this.xPosition += 24 * this.dir;
                    break;
                }
                case 17: {
                    this.actionFrmPtr = (byte)4;
                    this.imageNo = (byte)3;
                    this.xPosition = this.canvas.edgeOffX;
                    this.yPosition = this.canvas.edgeOffY;
                    this.frame = (byte)(this.frame - 1);
                    if (this.frame >= 6) break;
                    this.action = (byte)3;
                    break;
                }
                case 5: {
                    this.imageNo = (byte)5;
                    this.actionFrmPtr = (byte)6;
                    if (this.frameCtr < 8) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                    } else {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    if (this.frame <= 2) break;
                    this.frame = (byte)2;
                    this.canvas.getClass();
                    this.canvas.currPage = (byte)9;
                    this.canvas.shutterY = 0;
                    this.canvas.shutterMaxY = 24 * 2;
                    break;
                }
                case 7: {
                    this.imageNo = (byte)5;
                    this.actionFrmPtr = (byte)7;
                    if (this.frameCtr < 1) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                    } else {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    if (this.frame <= 2) break;
                    this.frame = (byte)2;
                    if (this.weapon == 0) {
                        this.action = 0;
                        this.frame = 0;
                    } else {
                        this.action = (byte)11;
                        this.frame = 1;
                        this.actionFrmPtr = (byte)3;
                        this.imageNo = (byte)2;
                    }
                    this.frameCtr = 0;
                    break;
                }
                case 25: {
                    this.imageNo = (byte)4;
                    this.actionFrmPtr = (byte)5;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame <= 3) break;
                    this.action = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    break;
                }
                case 26: {
                    this.imageNo = (byte)7;
                    this.actionFrmPtr = (byte)10;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame <= 7) break;
                    this.action = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    break;
                }
                case 27: {
                    this.imageNo = (byte)8;
                    this.actionFrmPtr = (byte)14;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame <= 3) break;
                    this.action = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    break;
                }
                case 14: {
                    this.imageNo = (byte)9;
                    this.actionFrmPtr = (byte)16;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame > 2 && this.waitCtr == 0) {
                        this.frame = 0;
                        this.waitCtr = 1;
                        break;
                    }
                    if (this.waitCtr == 1) {
                        this.frame = 0;
                        this.waitCtr = (byte)2;
                        break;
                    }
                    if (this.waitCtr == 2) {
                        this.frame = (byte)3;
                        this.waitCtr = (byte)3;
                        break;
                    }
                    if (this.frame > 6 && this.waitCtr > 2) {
                        this.frame = (byte)3;
                        this.waitCtr = (byte)4;
                        break;
                    }
                    if (this.waitCtr != 4) break;
                    this.action = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    this.waitCtr = 0;
                    this.canvas.expectedLoopTime >>= 1;
                    break;
                }
                case 6: {
                    if (this.isDead) {
                        this.imageNo = (byte)5;
                        this.actionFrmPtr = (byte)6;
                        this.frame = 0;
                        this.yPosition += 24 >> 1;
                        if (!MyCanvas.isGroundTouched) break;
                        this.action = (byte)5;
                        break;
                    }
                    this.actionFrmPtr = (byte)2;
                    if (MyCanvas.isGroundTouched) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frame != 3 || this.frameCtr < 3) {
                            this.imageNo = 0;
                            this.actionFrmPtr = 1;
                            this.frame = (byte)3;
                            break;
                        }
                        this.JumpHtReached = false;
                        this.xVel = 0;
                        if (this.weapon == 0) {
                            this.action = 0;
                            this.frame = 0;
                            this.actionFrmPtr = 0;
                            this.imageNo = 0;
                        } else {
                            this.action = (byte)11;
                            this.frame = 1;
                            this.actionFrmPtr = (byte)3;
                            this.imageNo = (byte)2;
                        }
                        this.frameCtr = 0;
                        break;
                    }
                    this.xPosition += this.xVel * this.dir;
                    this.frameCtr = 0;
                    this.actionFrmPtr = (byte)2;
                    this.imageNo = 1;
                    this.frame = this.frame < 2 ? (byte)(this.frame + 1) : (byte)2;
                    this.yPosition += 24 >> 1;
                    break;
                }
                case 9: {
                    this.actionFrmPtr = (byte)9;
                    this.imageNo = 1;
                    this.frame = 0;
                    this.xPosition += (24 >> 2) * this.dir;
                    this.yPosition += 24 >> 3;
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                    break;
                }
                case 13: {
                    this.actionFrmPtr = (byte)20;
                    this.imageNo = 1;
                    this.frame = 0;
                    this.xPosition += (24 >> 2) * this.dir;
                    this.yPosition += 24 >> 3;
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                    break;
                }
                case 18: {
                    this.imageNo = (byte)7;
                    this.actionFrmPtr = (byte)10;
                    if (this.seqArr[this.action - 18] - 1 == this.frame) {
                        if (!this.swordLock) {
                            this.canvas.addTopLayerElement(new Elements(this.canvas.hero.xPosition + (this.canvas.hero.dir == 1 ? this.canvas.hero.width << 1 : -this.canvas.hero.width), this.canvas.hero.yPosition + (this.canvas.hero.height >> 1), 0, 0, 0, 0, false, 5, 0, 0, this.canvas));
                        }
                        this.swordLock = true;
                        this.canvas.boss.setAction((byte)6);
                    } else {
                        this.receiveKeypressed = false;
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr > 0) {
                            this.frame = (byte)(this.frame + 1);
                            this.frameCtr = 0;
                        }
                    }
                    if (this.waitCtr <= 5) break;
                    this.action = 0;
                    this.frame = 0;
                    this.actionFrmPtr = 0;
                    this.imageNo = 0;
                    this.waitCtr = 0;
                    break;
                }
                case 19: {
                    this.imageNo = (byte)7;
                    this.actionFrmPtr = (byte)11;
                    if (this.seqArr[this.action - 18] - 1 == this.frame && this.canvas.boss.frame == 15) {
                        if (MyCanvas.haveKeyPressed(256) || this.canvas.boss.life < 10) {
                            this.action = (byte)18;
                            this.canvas.playSound(4);
                            this.frameCtr = 0;
                            this.frame = 0;
                            this.waitCtr = 0;
                            this.imageNo = (byte)7;
                            this.actionFrmPtr = (byte)10;
                            this.canvas.boss.setAction((byte)6);
                        }
                    }
                    if (this.seqArr[this.action - 18] - 1 == this.frame) {
                        this.receiveKeypressed = true;
                        this.waitCtr = (byte)(this.waitCtr + 1);
                    } else {
                        this.receiveKeypressed = false;
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr > 2) {
                            this.frame = (byte)(this.frame + 1);
                            this.frameCtr = 0;
                        }
                    }
                    if (this.waitCtr <= 5) break;
                    this.action = 0;
                    this.frame = 0;
                    this.actionFrmPtr = 0;
                    this.imageNo = 0;
                    this.waitCtr = 0;
                    break;
                }
                case 20: {
                    this.imageNo = (byte)7;
                    this.actionFrmPtr = (byte)12;
                    if (this.seqArr[this.action - 18] - 1 == this.frame) {
                        this.receiveKeypressed = true;
                        this.waitCtr = (byte)(this.waitCtr + 1);
                    } else {
                        this.receiveKeypressed = false;
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr > 2) {
                            this.frame = (byte)(this.frame + 1);
                            this.frameCtr = 0;
                            if (this.frame == 2) {
                                this.canvas.addTopLayerElement(new Elements(this.canvas.hero.xPosition + (this.canvas.hero.dir == 1 ? this.canvas.hero.width << 1 : -this.canvas.hero.width), this.canvas.hero.yPosition + (this.canvas.hero.height >> 1), 0, 0, 0, 0, false, 5, 0, 0, this.canvas));
                            }
                        }
                    }
                    if (this.waitCtr <= 5) break;
                    this.action = 0;
                    this.frame = 0;
                    this.actionFrmPtr = 0;
                    this.imageNo = 0;
                    this.waitCtr = 0;
                    break;
                }
                case 21: {
                    this.imageNo = (byte)8;
                    this.actionFrmPtr = (byte)13;
                    if (this.swordLock) break;
                    if (this.frame == this.seqArr[this.action - 18] - 1 && (this.canvas.boss.frame == 8 || this.canvas.boss.frame == 12)) {
                        if (!this.swordLock) {
                            this.canvas.addTopLayerElement(new Elements(this.canvas.hero.xPosition + (this.canvas.hero.dir == 1 ? this.canvas.hero.width << 1 : -this.canvas.hero.width), this.canvas.hero.yPosition + (this.canvas.hero.height >> 1), 0, 0, 0, 0, false, 5, 0, 0, this.canvas));
                        }
                        this.swordLock = true;
                    }
                    if (this.seqArr[this.action - 18] - 1 == this.frame) {
                        this.waitCtr = (byte)(this.waitCtr + 1);
                    } else {
                        this.receiveKeypressed = false;
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr > 2) {
                            this.frame = (byte)(this.frame + 1);
                            this.frameCtr = 0;
                        }
                    }
                    if (this.waitCtr <= 5) break;
                    this.action = 0;
                    this.frame = 0;
                    this.actionFrmPtr = 0;
                    this.imageNo = 0;
                    this.waitCtr = 0;
                    break;
                }
                case 22: {
                    this.imageNo = (byte)8;
                    this.actionFrmPtr = (byte)14;
                    if (this.seqArr[this.action - 18] - 1 == this.frame) {
                        if (this.waitCtr % 3 == 0) {
                            this.canvas.addTopLayerElement(new Elements(this.canvas.hero.xPosition + (this.canvas.hero.dir == 1 ? this.canvas.hero.width << 1 : -this.canvas.hero.width), this.canvas.hero.yPosition + (this.canvas.hero.height >> 1), 0, 0, 0, 0, false, 5, 0, 0, this.canvas));
                        }
                        this.canvas.boss.life = 0;
                        this.waitCtr = (byte)(this.waitCtr + 1);
                    } else {
                        this.receiveKeypressed = false;
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr > 3) {
                            this.frame = (byte)(this.frame + 1);
                            this.frameCtr = 0;
                        }
                    }
                    if (this.waitCtr <= 5) break;
                    this.action = 0;
                    this.frame = 0;
                    this.actionFrmPtr = 0;
                    this.imageNo = 0;
                    this.waitCtr = 0;
                    break;
                }
                case 24: {
                    this.imageNo = 0;
                    this.actionFrmPtr = (byte)(this.actionFrmPtr == 0 ? 19 : 0);
                    this.frame = 0;
                    if (this.actionFrmPtr != 0) break;
                    this.action = 0;
                }
            }
            this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + this.frame);
            if (this.isHit) {
                if (this.hitCounter == 0) {
                    this.canvas.life = (byte)(this.canvas.life - 7);
                }
                this.hitCounter = (byte)(this.hitCounter + 1);
                if (this.hitCounter > 15) {
                    this.isHit = false;
                    this.hitCounter = 0;
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in hero update>>" + this.action + " " + e);
        }
    }

    public void draw(Graphics g) {
        try {
            if (MyCanvas.gameLevel == 2) {
                if (this.hitCounter % 2 == 0 || this.action == 5) {
                    if (this.action == 11 || this.action == 10 || this.action == 15) {
                        if (this.action == 15) {
                            this.framePtr = this.framePos[17];
                        }
                        g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]) + (this.heroOffY == 3 ? (byte)1 : this.heroOffY), 0);
                        if (this.action != 15) {
                            this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + (this.fireArrow ? 2 : 3) + this.frame * 2);
                            g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]) + (this.heroOffY == 3 ? (byte)1 : this.heroOffY), 0);
                        }
                        this.actionFrmPtr = (byte)8;
                        this.imageNo = (byte)6;
                        this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + this.heroOffY);
                        g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]), 0);
                    } else {
                        if (this.action != 23) {
                            this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + this.heroOffY);
                        }
                        g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]), 0);
                        if (this.action == 23) {
                            return;
                        }
                        this.framePtr = this.action == 15 ? this.framePos[17] : (byte)(this.framePos[this.actionFrmPtr] + this.yVel);
                        g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]) + (this.heroOffY == 3 ? (byte)1 : this.heroOffY), 0);
                    }
                }
                return;
            }
            if (this.hitCounter % 2 == 0 || this.action == 5 || this.action == 14) {
                g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]), 0);
                if (this.action == 11) {
                    this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + 0);
                    g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]), 0);
                    this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + (this.fireArrow ? 2 : 3) + this.frame * 2);
                    g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]), 0);
                }
            }
            if (this.swordLock) {
                g.setColor(0xFF0000);
                g.drawRect(this.xPosition + this.width * 2, this.yPosition, 25, 4);
                g.fillRect(this.xPosition + this.width * 2, this.yPosition, (int)this.swordLockCtr, 4);
            }
        }
        catch (Exception e) {
            System.out.println("err in hero draw>>" + e);
        }
    }

    private boolean checkForHandFight() {
        for (int i = 0; i < this.canvas.enemyArr.length; ++i) {
            if (this.canvas.enemyArr[i] == null || this.canvas.enemyArr[i].type > 1 || this.canvas.enemyArr[i].isDead || Math.abs(this.canvas.enemyArr[i].xDistance) >= this.canvas.enemyArr[i].width || Math.abs(this.canvas.enemyArr[i].yDistance) >= this.canvas.enemyArr[i].height >> 1) continue;
            if (this.dir > 0 && this.canvas.enemyArr[i].xDistance > 0) {
                this.canvas.enemyArr[i].waitCtr = 0;
                this.canvas.enemyArr[i].type = (byte)5;
                this.canvas.enemyArr[i].frame = (byte)-1;
                this.canvas.enemyArr[i].dir = (byte)-1;
                this.canvas.enemyArr[i].xPosition = this.xPosition + 28 + 3;
                this.canvas.expectedLoopTime <<= 1;
                return true;
            }
            if (this.dir >= 0 || this.canvas.enemyArr[i].xDistance >= 0) continue;
            this.canvas.enemyArr[i].waitCtr = 0;
            this.canvas.enemyArr[i].type = (byte)5;
            this.canvas.enemyArr[i].frame = (byte)-1;
            this.canvas.enemyArr[i].dir = 1;
            this.canvas.enemyArr[i].xPosition = this.xPosition - this.canvas.enemyArr[i].width - 3;
            this.canvas.expectedLoopTime <<= 1;
            return true;
        }
        return false;
    }
}

