/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Enemy {
    private MyCanvas canvas;
    int xPosition;
    int yPosition;
    int width;
    int height;
    int xDistance;
    int yDistance;
    byte dir;
    byte type;
    byte action;
    boolean hidden;
    boolean isDead;
    boolean isAttack;
    boolean isEnd;
    private int tempX;
    private int tempY;
    private int xEnd;
    private int yEnd;
    private int rand;
    public byte hitCounter = 1;
    public byte hits;
    private byte imageNo;
    private byte imageRotation;
    public byte frame;
    public byte frameCtr;
    private byte framePtr;
    public byte waitCtr;
    public byte xVel;
    public byte yVel;
    public byte actionFrmPtr;
    private byte damage;
    private byte counter;
    private byte deadCtr;
    int tileX;
    int tileY;
    char tileType;
    public static Image[] image;

    public Enemy(int xPosition, int yPosition, int width, int height, int direction, int hitCounter, int type, int imageNo, int actionFrmPtr, MyCanvas canvas, int tileX, int tileY, char tileType) {
        this.canvas = canvas;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.dir = (byte)direction;
        this.type = (byte)type;
        this.imageNo = (byte)imageNo;
        this.actionFrmPtr = (byte)actionFrmPtr;
        this.hitCounter = (byte)hitCounter;
        this.tileX = tileX;
        this.tileY = tileY;
        this.tileType = tileType;
    }

    public static void initResources() {
        try {
            image = new Image[6];
            if (MyCanvas.gameLevel == 2) {
                Enemy.image[3] = Image.createImage((String)"/e_C_horse.png");
            } else {
                Enemy.image[0] = Image.createImage((String)"/e_die.png");
                Enemy.image[1] = Image.createImage((String)"/e_A_sword.png");
                Enemy.image[2] = Image.createImage((String)"/e_B_bowStand.png");
                Enemy.image[5] = Image.createImage((String)"/e_punchDie.png");
            }
            Enemy.image[4] = Image.createImage((String)"/e_D_bowHalf.png");
        }
        catch (Exception e) {
            System.out.println("Error in Enemy Image Creation :" + e.toString());
        }
    }

    private void update(Graphics g) {
        try {
            switch (this.type) {
                case 0: {
                    this.xDistance = this.xPosition + (this.width >> 1) - (this.canvas.hero.xPosition + (this.canvas.hero.width >> 1));
                    this.yDistance = this.yPosition - this.canvas.hero.yPosition;
                    if (this.isDead) {
                        if (this.deadCtr > 10) {
                            this.hidden = true;
                        } else if (this.frame == 2) {
                            this.deadCtr = (byte)(this.deadCtr + 1);
                        }
                        this.imageNo = 0;
                        this.actionFrmPtr = 0;
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr <= 3) break;
                        this.frameCtr = 0;
                        this.frame = (byte)(this.frame + 1);
                        if (this.frame < 3) break;
                        this.frame = (byte)2;
                        break;
                    }
                    this.blockHero();
                    if (Math.abs(this.yDistance) < this.height >> 1 && Math.abs(this.xDistance) < this.canvas.hero.width + this.width * 3 / 2) {
                        this.dir = (byte)(this.xDistance > 0 ? -1 : 1);
                        if (this.frame != 5 && this.waitCtr == 0) {
                            int n;
                            if (this.frame > 5) {
                                n = 2;
                            } else {
                                byte by = (byte)(this.frame + 1);
                                n = by;
                                this.frame = by;
                            }
                            this.frame = (byte)n;
                            this.frame = (byte)(this.frame < 2 ? 2 : (int)this.frame);
                        } else {
                            this.waitCtr = (byte)(this.waitCtr + 1);
                            if (this.waitCtr > 10) {
                                this.waitCtr = 0;
                                this.frame = (byte)2;
                            }
                        }
                        if (this.frame == 5 && !this.canvas.hero.isHit && MyCanvas.intersectsOfSprites(this.canvas.hero.xPosition, this.canvas.hero.yPosition, this.canvas.hero.width << 1, this.canvas.hero.height, this.xPosition + (this.dir == 1 ? MyCanvas.enemyPlacingRt[this.framePtr * 2] : MyCanvas.enemyPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? MyCanvas.enemyPlacingRt[this.framePtr * 2 + 1] : MyCanvas.enemyPlacingLf[this.framePtr * 2 + 1]), MyCanvas.enemyClipping[this.framePtr * 4 + 2], MyCanvas.enemyClipping[this.framePtr * 4 + 3])) {
                            this.waitCtr = (byte)(this.waitCtr + 1);
                            this.canvas.hero.isHit = true;
                        }
                    } else if (Math.abs(this.tempX) < 24 << 1 && this.tempY == 0) {
                        this.tempX += (24 >> 3) * this.dir;
                        this.xPosition += (24 >> 3) * this.dir;
                        if (this.isEnd) {
                            int n;
                            if (this.frame > 0) {
                                byte by = (byte)(this.frame - 1);
                                n = by;
                                this.frame = by;
                            } else {
                                n = 7;
                            }
                            this.frame = (byte)n;
                            byte by = this.frame = this.frame >= 1 && this.frame <= 5 ? (byte)0 : this.frame;
                            if (this.frame <= 0) {
                                this.isEnd = false;
                            }
                        } else {
                            this.frame = this.frame < 7 ? (this.frame = (byte)(this.frame + 1)) : (byte)0;
                            int n = this.frame = this.frame >= 1 && this.frame <= 5 ? 6 : this.frame;
                            if (this.frame >= 7) {
                                this.isEnd = true;
                            }
                        }
                    } else {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr <= 2) break;
                        this.frameCtr = 0;
                        this.frame = (byte)(this.frame != 1 ? 1 : 0);
                        int n = this.tempY = this.tempY > 5 ? 0 : (this.tempY = this.tempY + 1);
                        if (this.tempY == 0) {
                            this.dir = (byte)(this.dir * -1);
                            this.tempX += (24 >> 2) * this.dir;
                            this.xPosition += (24 >> 2) * this.dir;
                        }
                    }
                    if (!this.checkHeroAttack()) break;
                    this.hits = (byte)(this.hits + this.damage);
                    if (this.hits >= this.hitCounter) {
                        this.isDead = true;
                        this.canvas.score += 100;
                        this.frame = 0;
                        this.frameCtr = 0;
                    }
                    this.canvas.addTopLayerElement(new Elements(this.canvas.hero.xPosition + (this.canvas.hero.dir == 1 ? this.canvas.hero.width << 1 : -this.canvas.hero.width), this.canvas.hero.yPosition + (this.canvas.hero.height >> 1), 0, 0, 0, 0, false, 5, 0, 0, this.canvas));
                    break;
                }
                case 1: {
                    this.xDistance = this.xPosition + (this.width >> 1) - (this.canvas.hero.xPosition + (this.canvas.hero.width >> 1));
                    this.yDistance = this.yPosition - this.canvas.hero.yPosition;
                    if (this.isDead) {
                        if (this.deadCtr > 10) {
                            this.hidden = true;
                        } else if (this.frame == 2) {
                            this.deadCtr = (byte)(this.deadCtr + 1);
                        }
                        this.imageNo = 0;
                        this.actionFrmPtr = 0;
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr <= 3) break;
                        this.frameCtr = 0;
                        this.frame = (byte)(this.frame + 1);
                        if (this.frame < 3) break;
                        this.frame = (byte)2;
                        break;
                    }
                    this.blockHero();
                    this.dir = (byte)(this.xDistance > 0 ? -1 : 1);
                    if (Math.abs(this.yDistance) < this.height >> 1 && Math.abs(this.xDistance) < this.canvas.hero.width + this.width * 3 && this.waitCtr == 0) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr > 4) {
                            this.frameCtr = 0;
                            this.frame = (byte)(this.frame == 3 ? 2 : 3);
                            if (this.frame == 3) {
                                this.waitCtr = (byte)(this.waitCtr + 1);
                                this.frameCtr = 0;
                                this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 54 : -16), this.yPosition + 16, 3, 3, (24 * MyCanvas.cos(0) >> 9) * this.dir, 24 * MyCanvas.sin(0) >> 9, false, 1, 0, 0, this.canvas));
                            }
                        }
                    } else {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr > 2) {
                            this.frameCtr = 0;
                            this.frame = (byte)(this.frame == 0 ? 1 : 0);
                            if (this.waitCtr != 0) {
                                this.waitCtr = (byte)(this.waitCtr + 1);
                            }
                            if (this.waitCtr > 5) {
                                this.waitCtr = 0;
                                this.frame = (byte)3;
                            }
                        }
                    }
                    if (!this.checkHeroAttack()) break;
                    this.hits = (byte)(this.hits + this.damage);
                    if (this.hits >= this.hitCounter) {
                        this.isDead = true;
                        this.canvas.score += 100;
                        this.frame = 0;
                        this.frameCtr = 0;
                    }
                    this.canvas.addTopLayerElement(new Elements(this.canvas.hero.xPosition + (this.canvas.hero.dir == 1 ? this.canvas.hero.width << 1 : -this.canvas.hero.width), this.canvas.hero.yPosition + (this.canvas.hero.height >> 1), 0, 0, 0, 0, false, 5, 0, 0, this.canvas));
                    break;
                }
                case 2: {
                    if (this.isDead) {
                        this.frame = (byte)2;
                    } else {
                        this.xDistance = this.xPosition + (this.width >> 1) - (this.canvas.hero.xPosition + (this.canvas.hero.width >> 1));
                        if (this.xDistance > this.canvas.hero.width + (this.width >> 1)) {
                            this.waitCtr = (byte)(this.waitCtr + 1);
                            if (this.waitCtr < 3) {
                                this.frame = 0;
                            } else if (this.waitCtr < 6) {
                                this.frame = 1;
                                if (this.waitCtr == 5) {
                                    this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 54 : -16), this.yPosition + 16, 3, 3, (24 * MyCanvas.cos(0) >> 9) * this.dir, 24 * MyCanvas.sin(0) >> 9, false, 1, 0, 0, this.canvas));
                                }
                            } else {
                                this.frame = 0;
                                if (this.waitCtr > 8) {
                                    this.waitCtr = 0;
                                }
                            }
                        } else {
                            this.frame = 0;
                            this.waitCtr = 0;
                        }
                        if (!this.canvas.hero.isHit && MyCanvas.intersectsOfSprites(this.xPosition, this.yPosition, 5, this.height, this.canvas.hero.xPosition, this.canvas.hero.yPosition, this.canvas.hero.width, this.canvas.hero.height)) {
                            this.canvas.hero.isHit = true;
                            this.canvas.life = (byte)(this.canvas.life - 5);
                        }
                    }
                    this.rand = this.rand > 2 ? 0 : (this.rand = this.rand + 1);
                    this.frameCtr = (byte)(MyCanvas.enemyFramePos[this.actionFrmPtr] + this.rand + 3);
                    this.xPosition -= 24 >> 3;
                    this.yPosition += this.rand == 1 || this.rand == 2 ? 1 : -1;
                    if (image[this.imageNo] == null) {
                        System.out.println(this.imageNo + " image[imageNo] is null");
                    }
                    g.drawRegion(image[this.imageNo], (int)MyCanvas.enemyClipping[this.frameCtr * 4], (int)MyCanvas.enemyClipping[this.frameCtr * 4 + 1], (int)MyCanvas.enemyClipping[this.frameCtr * 4 + 2], (int)MyCanvas.enemyClipping[this.frameCtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? MyCanvas.enemyPlacingRt[this.frameCtr * 2] : MyCanvas.enemyPlacingLf[this.frameCtr * 2]), this.yPosition - (this.rand == 3 ? 1 : this.rand) + (this.dir == 1 ? MyCanvas.enemyPlacingRt[this.frameCtr * 2 + 1] : MyCanvas.enemyPlacingLf[this.frameCtr * 2 + 1]), 0);
                    if (this.xPosition >= -this.width * 3) break;
                    this.hidden = true;
                    System.out.println("in here....");
                    break;
                }
                case 3: {
                    if (this.isDead) {
                        this.frame = (byte)(this.frame < 4 ? 4 : (int)this.frame);
                        if (this.deadCtr > 10) {
                            this.hidden = true;
                        } else if (this.frame >= 5) {
                            this.deadCtr = (byte)(this.deadCtr + 1);
                        }
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr <= 6) break;
                        this.frameCtr = 0;
                        this.frame = (byte)(this.frame + 1);
                        if (this.frame < 5) break;
                        this.frame = (byte)5;
                        break;
                    }
                    this.xDistance = this.xPosition + (this.width >> 1) - (this.canvas.hero.xPosition + (this.canvas.hero.width >> 1));
                    this.yDistance = this.yPosition - this.canvas.hero.yPosition;
                    this.dir = (byte)(this.xDistance > 0 ? -1 : 1);
                    if (MyCanvas.gameLevel == 2) {
                        byte by = this.waitCtr = this.waitCtr > 12 ? (byte)0 : (this.waitCtr = (byte)(this.waitCtr + 1));
                        if (this.waitCtr < 10 && Math.abs(this.xDistance) < (this.canvas.hero.width << 1) + (this.width << 1)) {
                            this.frame = (byte)2;
                        } else if (this.waitCtr < 10 && Math.abs(this.xDistance) < (this.canvas.hero.width << 2) + (this.width << 2)) {
                            this.frame = 1;
                        } else if (this.waitCtr < 10) {
                            this.frame = 0;
                        } else if (this.yDistance < 0) {
                            this.frame = (byte)3;
                        }
                    } else {
                        byte by = this.waitCtr = this.waitCtr > 20 ? (byte)0 : (this.waitCtr = (byte)(this.waitCtr + 1));
                        if (this.waitCtr < 10 && Math.abs(this.xDistance) < (this.canvas.hero.width >> 1) + (this.width >> 1)) {
                            this.frame = (byte)2;
                        } else if (this.waitCtr < 10 && Math.abs(this.xDistance) < (this.canvas.hero.width << 1) + (this.width << 1)) {
                            this.frame = 1;
                        } else if (this.waitCtr < 10) {
                            this.frame = 0;
                        } else if (this.yDistance < 0) {
                            this.frame = (byte)3;
                        }
                    }
                    if (this.waitCtr == 9 && this.yDistance < 0) {
                        switch (this.frame) {
                            case 0: {
                                this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 40 : 0), this.yPosition + 26, 3, 3, -(24 * MyCanvas.cos(155) >> 9) * this.dir, 24 * MyCanvas.sin(155) >> 9, false, 1, 0, 0, this.canvas));
                                break;
                            }
                            case 1: {
                                this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 34 : 6), this.yPosition + 31, 3, 3, -(24 * MyCanvas.cos(145) >> 9) * this.dir, 24 * MyCanvas.sin(145) >> 9, false, 1, 0, 0, this.canvas));
                                break;
                            }
                            case 2: {
                                this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 22 : 18), this.yPosition + 34, 3, 3, -(24 * MyCanvas.cos(120) >> 9) * this.dir, 24 * MyCanvas.sin(120) >> 9, false, 1, 0, 0, this.canvas));
                            }
                        }
                    }
                    if (MyCanvas.gameLevel != 2) break;
                    if (this.xPosition + this.width > -24) break;
                    this.hidden = true;
                    break;
                }
                case 4: {
                    this.rand = (27 + this.frame) * 4;
                    g.drawRegion(MyCanvas.levelTileImg, (int)this.canvas.tileClip[this.rand], (int)this.canvas.tileClip[this.rand + 1], (int)this.canvas.tileClip[this.rand + 2], (int)this.canvas.tileClip[this.rand + 3], 0, this.xPosition + 9, this.yPosition + -2, 0);
                    this.waitCtr = (byte)(this.waitCtr + 1);
                    if (this.waitCtr > 15 && this.waitCtr < 22) {
                        this.rand = (28 + this.frame) * 4;
                        g.drawRegion(MyCanvas.levelTileImg, (int)this.canvas.tileClip[this.rand], (int)this.canvas.tileClip[this.rand + 1], (int)this.canvas.tileClip[this.rand + 2], (int)this.canvas.tileClip[this.rand + 3], 0, this.xPosition, this.yPosition, 0);
                    }
                    if (this.waitCtr != 22) break;
                    this.canvas.addElementArr(new Elements(this.xPosition - (24 >> 2), this.yPosition, 24 >> 1, 3, -(24 >> 1), 0, false, 6, 0, 0, this.canvas));
                    this.waitCtr = 0;
                    break;
                }
                case 5: {
                    this.imageNo = (byte)5;
                    this.actionFrmPtr = (byte)6;
                    this.waitCtr = (byte)(this.waitCtr + 1);
                    if (this.waitCtr < 4) {
                        this.frame = (byte)(this.frame + 1);
                    } else if (this.waitCtr == 4) {
                        this.frame = (byte)3;
                    } else if (this.waitCtr > 4 && this.waitCtr != 8) {
                        this.frame = (byte)4;
                    } else if (this.waitCtr == 8) {
                        this.frame = (byte)5;
                    }
                    if (this.waitCtr > 10) {
                        this.deadCtr = (byte)(this.deadCtr + 1);
                        boolean bl = this.hidden = this.deadCtr > 10;
                    }
                    if (!this.hidden) break;
                    this.canvas.score += 100;
                }
            }
            this.imageRotation = this.dir == 1 ? (byte)2 : (byte)0;
            this.framePtr = (byte)(MyCanvas.enemyFramePos[this.actionFrmPtr] + this.frame);
        }
        catch (Exception e) {
            System.out.println("err in Enemy update in " + this.type + " type>>" + e);
        }
        if (!this.hidden && !this.canvas.isInView(this.xPosition, this.yPosition, this.height, this.width)) {
            if (MyCanvas.gameLevel != 2) {
                this.hidden = true;
                this.canvas.levelTileMap[this.tileY][this.tileX] = this.tileType;
            }
        }
    }

    public void draw(Graphics g) {
        try {
            this.update(g);
            if (this.deadCtr % 2 == 0) {
                g.drawRegion(image[this.imageNo], (int)MyCanvas.enemyClipping[this.framePtr * 4], (int)MyCanvas.enemyClipping[this.framePtr * 4 + 1], (int)MyCanvas.enemyClipping[this.framePtr * 4 + 2], (int)MyCanvas.enemyClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? MyCanvas.enemyPlacingRt[this.framePtr * 2] : MyCanvas.enemyPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? MyCanvas.enemyPlacingRt[this.framePtr * 2 + 1] : MyCanvas.enemyPlacingLf[this.framePtr * 2 + 1]), 0);
            }
        }
        catch (Exception e) {
            System.out.println("err in Enemy in type>>" + this.type + " frame>>" + this.frame + " draw>>" + e);
        }
    }

    private boolean checkHeroAttack() {
        switch (this.canvas.hero.action) {
            case 25: {
                if (this.canvas.hero.frame != 2 || !MyCanvas.intersectsOfSprites(this.canvas.hero.dir > 0 ? this.canvas.hero.xPosition + this.canvas.hero.width : this.canvas.hero.xPosition - (this.canvas.hero.width << 1), this.canvas.hero.yPosition - 12, this.canvas.hero.width << 1, this.canvas.hero.height, this.xPosition, this.yPosition, this.width, this.height)) break;
                this.damage = 1;
                return true;
            }
            case 26: {
                if (this.canvas.hero.frame != 5 || !MyCanvas.intersectsOfSprites(this.canvas.hero.dir > 0 ? this.canvas.hero.xPosition + this.canvas.hero.width : this.canvas.hero.xPosition - (this.canvas.hero.width << 1), this.canvas.hero.yPosition - 12, this.canvas.hero.width << 1, this.canvas.hero.height, this.xPosition, this.yPosition, this.width, this.height)) break;
                this.damage = 1;
                return true;
            }
            case 27: {
                if (this.canvas.hero.frame != 2 || !MyCanvas.intersectsOfSprites(this.canvas.hero.dir > 0 ? this.canvas.hero.xPosition + this.canvas.hero.width : this.canvas.hero.xPosition - (this.canvas.hero.width << 1), this.canvas.hero.yPosition - 12, this.canvas.hero.width << 1, this.canvas.hero.height, this.xPosition, this.yPosition, this.width, this.height)) break;
                this.damage = 1;
                return true;
            }
        }
        return false;
    }

    private void blockHero() {
        if (MyCanvas.intersectsOfSprites(this.canvas.hero.xPosition, this.canvas.hero.yPosition, this.canvas.hero.width, this.canvas.hero.height, this.xPosition, this.yPosition, this.width, this.height)) {
            this.canvas.hero.xPosition = this.canvas.hero.xPosition < this.xPosition ? this.xPosition - this.canvas.hero.width : this.xPosition + this.width;
        }
    }
}

