/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Boss {
    private MyCanvas canvas;
    int xPosition;
    int yPosition;
    int width;
    int height;
    byte dir;
    byte action;
    boolean hidden;
    public byte damage;
    public byte hitCounter = 1;
    public byte hits;
    public byte frame;
    public byte framePtr;
    private byte frameCtr;
    public byte actionFrmPtr;
    private byte imageNo;
    private byte counter;
    private byte deadCtr;
    public byte waitCtr;
    public byte life = (byte)100;
    Image[] image;
    short[] clipArr = new short[]{0, 0, 34, 93, 0, -35, 0, -35, 34, 1, 34, 92, 0, -34, 0, -34, 68, 20, 38, 73, 2, -16, -6, -16, 106, 33, 77, 60, -39, -2, -4, -2, 183, 37, 77, 56, 1, 2, -44, 2, 0, 7, 67, 57, 0, 2, -33, 2, 67, 9, 46, 55, -1, 3, -11, 3, 113, 0, 83, 64, -44, -6, -5, -6, 196, 0, 83, 64, -44, -6, -5, -6, 0, 1, 43, 72, -4, -14, -5, -14, 43, 15, 66, 58, -5, 0, -27, 0, 110, 15, 66, 58, -5, 0, -27, 0, 177, 24, 72, 49, -39, 9, 1, 9, 0, 0, 43, 78, 1, -20, -10, -20, 43, 42, 53, 36, 3, 18, -16, 18, 96, 53, 66, 25, -26, 33, -26, 33, 43, 42, 53, 36, 3, 18, -16, 18, 162, 47, 64, 31, -33, 27, -13, 27, 260, 0, 31, 93, 0, -35, 0, -35};

    public Boss(int xPosition, int yPosition, int width, int height, int direction, int hitCounter, int type, MyCanvas canvas) {
        this.canvas = canvas;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.dir = (byte)direction;
        this.actionFrmPtr = this.actionFrmPtr;
        this.hitCounter = (byte)hitCounter;
        try {
            this.image = new Image[4];
            for (int i = 0; i < this.image.length; ++i) {
                this.image[i] = Image.createImage((String)("/b" + i + ".png"));
            }
            this.clipArr = canvas.convertBytetoShort(canvas.readFile("/b"));
        }
        catch (Exception e) {
            System.out.println("err in boss image " + e);
        }
        canvas.getClass();
        canvas.camType = (byte)2;
    }

    private void update(Graphics g) {
        try {
            if (this.life <= 0) {
                this.waitCtr = (byte)(this.waitCtr + 1);
                if (this.waitCtr < 20) {
                    return;
                }
                this.hidden = true;
                this.canvas.getClass();
                this.canvas.currPage = (byte)10;
            }
            switch (this.action) {
                case 0: {
                    this.imageNo = 0;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    if (this.frameCtr > 3) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    if (this.frame > 1) {
                        this.frame = 0;
                    }
                    byte by = this.canvas.currPage;
                    this.canvas.getClass();
                    if (by != 18) {
                        this.waitCtr = (byte)(this.waitCtr + 1);
                    }
                    if (this.xPosition - this.canvas.hero.xPosition != (this.canvas.hero.width << 1) + 10) {
                        this.action = (byte)7;
                        this.waitCtr = 0;
                        break;
                    }
                    if (this.waitCtr <= 20) break;
                    this.setAction((byte)1);
                    this.waitCtr = 0;
                    break;
                }
                case 1: {
                    this.imageNo = 0;
                    if (this.frame < 4) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr <= 2) break;
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                        if (this.canvas.hero.isHit || this.frame != 3 || this.canvas.hero.action != 0) break;
                        this.canvas.hero.isHit = true;
                        this.canvas.life = (byte)(this.canvas.life - 5);
                        this.canvas.addTopLayerElement(new Elements(this.canvas.hero.xPosition + (this.canvas.hero.dir == 1 ? this.canvas.hero.width << 1 : -this.canvas.hero.width), this.canvas.hero.yPosition + (this.canvas.hero.height >> 1), 0, 0, 0, 0, false, 5, 0, 0, this.canvas));
                        break;
                    }
                    this.setAction((byte)0);
                    break;
                }
                case 2: {
                    this.imageNo = 1;
                    if (this.frame < 8) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr <= 2) break;
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                        break;
                    }
                    if (this.canvas.hero.swordLock) break;
                    this.setAction((byte)0);
                    break;
                }
                case 3: {
                    this.imageNo = (byte)2;
                    if (this.frame < 12) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr <= 2) break;
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                        break;
                    }
                    if (this.canvas.hero.swordLock) break;
                    this.setAction((byte)0);
                    break;
                }
                case 4: {
                    this.imageNo = (byte)3;
                    if (this.frame < 16) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr <= 2) break;
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                        break;
                    }
                    if (this.canvas.hero.swordLock) break;
                    this.setAction((byte)0);
                    break;
                }
                case 5: {
                    this.imageNo = (byte)3;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    if (this.frameCtr <= 10) break;
                    this.setAction((byte)0);
                    break;
                }
                case 6: {
                    this.imageNo = (byte)3;
                    if (this.canvas.hero.swordLock) {
                        this.frame = (byte)17;
                        break;
                    }
                    this.frame = (byte)15;
                    break;
                }
                case 7: {
                    this.imageNo = 0;
                    this.frame = (byte)(this.frame == 0 ? 18 : 0);
                    this.xPosition = this.canvas.hero.xPosition + ((this.canvas.hero.width << 1) + 10);
                    if (this.frame != 0) break;
                    this.action = 0;
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in boss update " + e);
        }
    }

    public void draw(Graphics g) {
        try {
            this.update(g);
            if (this.life > 0 || this.waitCtr % 2 == 0 || this.waitCtr > 10) {
                g.drawRegion(this.image[this.imageNo], (int)this.clipArr[this.frame * 8], (int)this.clipArr[this.frame * 8 + 1], (int)this.clipArr[this.frame * 8 + 2], (int)this.clipArr[this.frame * 8 + 3], 0, this.xPosition + this.clipArr[this.frame * 8 + (this.dir < 0 ? 4 : 6)], this.yPosition + this.clipArr[this.frame * 8 + (this.dir < 0 ? 5 : 7)], 0);
            }
            if (this.life > 0) {
                if (this.canvas.hero.swordLock) {
                    if (this.canvas.shakeX == 0 && this.canvas.shakeY == 0) {
                        this.canvas.shakeX = (byte)MyCanvas.random(0, 2);
                        this.canvas.shakeY = (byte)(MyCanvas.random(0, 10) < 5 ? 2 : -2);
                    }
                    this.canvas.shakeX = -this.canvas.shakeX;
                    this.canvas.shakeY = -this.canvas.shakeY;
                } else {
                    this.canvas.shakeX = 0;
                    this.canvas.shakeY = 0;
                }
                g.setColor(0);
                g.drawRect(MyCanvas.canvasWidth - 52 - this.canvas.shakeX, 4 - this.canvas.shakeY, 50, 5);
                g.setColor(0xFF0000);
                g.fillRect(MyCanvas.canvasWidth - 52 - this.canvas.shakeX, 4 - this.canvas.shakeY, this.life >> 1, 5);
            }
        }
        catch (Exception e) {
            System.out.println("err in boss draw>>" + e);
        }
    }

    public void setAction(byte act) {
        this.waitCtr = 0;
        this.frameCtr = 0;
        switch (act) {
            case 0: {
                this.action = act;
                this.imageNo = 0;
                this.frame = 0;
                break;
            }
            case 1: {
                this.canvas.playSound(4);
                this.action = act;
                this.imageNo = 1;
                this.frame = (byte)2;
                break;
            }
            case 2: {
                this.action = act;
                this.imageNo = 1;
                this.frame = (byte)5;
                break;
            }
            case 3: {
                this.action = act;
                this.imageNo = (byte)2;
                this.frame = (byte)9;
                break;
            }
            case 4: {
                this.life = this.life > 0 ? (this.life = (byte)(this.life - 2)) : (byte)0;
                this.action = act;
                this.imageNo = (byte)3;
                this.frame = (byte)13;
                break;
            }
            case 5: {
                this.life = this.life > 0 ? (this.life = (byte)(this.life - 2)) : (byte)0;
                this.action = act;
                this.imageNo = (byte)3;
                this.frame = (byte)13;
                break;
            }
            case 6: {
                this.action = act;
                this.imageNo = (byte)3;
                this.frame = (byte)15;
                break;
            }
        }
    }
}

