/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Hero {
    private MyCanvas canvas;
    public int xPosition;
    public int yPosition;
    public int width;
    public int height;
    public byte dir = 1;
    public byte frame;
    public byte bowPos = 1;
    private byte heroOffY;
    public byte frameCtr;
    public byte framePtr;
    public byte xVel;
    public byte yVel;
    public int jumpCtr;
    public int jumpLimit;
    public boolean JumpHtReached;
    public byte actionFrmPtr = 0;
    public boolean isHit = false;
    private byte hitCounter = 0;
    public boolean receiveKeypressed = false;
    public boolean swordLock = false;
    public byte weapon = 0;
    public boolean fireArrow;
    private byte waitCtr;
    public boolean isDead;
    private boolean isEnd;
    public byte action = 0;
    public static final byte STAND = 0;
    public static final byte RUN = 1;
    public static final byte JUMP = 2;
    public static final byte EDGE_HANG = 3;
    public static final byte EDGE_CLIMB = 4;
    public static final byte DIE = 5;
    public static final byte FALL = 6;
    public static final byte POWERUP_BREAK = 7;
    public static final byte CROUCH = 8;
    public static final byte SLIDE = 9;
    public static final byte HORSE_RIDE = 10;
    public static final byte BOW_ARROW = 11;
    public static final byte DIE_ON_HORSE = 12;
    public static final byte HORSE_CROUCH = 15;
    public static final byte HORSE_JUMP = 23;
    public static final byte SLIDE_DUCK = 13;
    public static final byte HAND_FIGHT = 14;
    public static final byte TOP_EDGE_CLIMB = 16;
    public static final byte TOP_EDGE_GETDOWN = 17;
    public static final byte SEQENCE_1 = 18;
    public static final byte SEQENCE_2 = 19;
    public static final byte SEQENCE_3 = 20;
    public static final byte SEQENCE_4 = 21;
    public static final byte SEQENCE_5 = 22;
    public static final byte SEQENCE_MOVE = 24;
    public static final byte SWORD_1 = 25;
    public static final byte SWORD_2 = 26;
    public static final byte SWORD_3 = 27;
    public byte imageNo;
    private byte imageRotation;
    private byte[] seqArr = new byte[]{8, 3, 3, 3, 4};
    public static Image[] image;
    public short[] heroClipping = new short[]{0, 0, 20, 42, 20, 1, 20, 41, 41, 0, 21, 42, 62, 1, 23, 41, 85, 2, 15, 40, 100, 1, 19, 41, 119, 0, 30, 42, 149, 1, 23, 41, 172, 1, 14, 41, 0, 7, 19, 33, 19, 6, 19, 34, 38, 0, 18, 40, 56, 1, 17, 39, 0, 4, 21, 22, 21, 6, 28, 20, 49, 5, 27, 21, 76, 0, 19, 26, 0, 26, 6, 21, 7, 26, 19, 21, 26, 27, 11, 19, 37, 27, 19, 20, 56, 27, 21, 9, 57, 36, 19, 15, 7, 49, 19, 3, 37, 47, 19, 9, 77, 36, 9, 15, 0, 0, 15, 50, 15, 13, 17, 37, 32, 6, 21, 44, 53, 12, 24, 38, 77, 13, 23, 37, 100, 9, 18, 41, 118, 17, 21, 33, 139, 25, 20, 25, 0, 4, 28, 44, 28, 0, 36, 48, 64, 6, 53, 42, 117, 11, 53, 37, 0, 0, 26, 41, 26, 7, 25, 34, 51, 27, 47, 14, 98, 5, 22, 36, 120, 6, 31, 35, 151, 5, 31, 36, 19, 5, 55, 41, 74, 0, 60, 46, 0, 46, 56, 44, 56, 46, 58, 44, 114, 49, 26, 24, 1, 25, 18, 21, 114, 73, 22, 17, 73, 6, 23, 34, 0, 1, 36, 37, 37, 1, 49, 37, 86, 1, 34, 37, 120, 0, 42, 38, 1, 43, 45, 40, 46, 38, 48, 45, 94, 54, 38, 29, 132, 54, 45, 29, 1, 85, 21, 36, 22, 85, 37, 36, 1, 85, 21, 36, 59, 83, 37, 38, 97, 83, 37, 38, 134, 83, 50, 38, 0, 7, 28, 42, 28, 0, 25, 49, 53, 6, 29, 43, 82, 14, 35, 35, 117, 14, 35, 35, 152, 16, 33, 33, 185, 16, 28, 33, 186, 15, 21, 27, 0, 17, 24, 42, 24, 22, 37, 37, 61, 11, 35, 48, 97, 32, 21, 27, 97, 0, 29, 32, 126, 0, 30, 32, 119, 33, 33, 26, 134, 34, 22, 20, 0, 0, 52, 63, 53, 5, 72, 58, 125, 1, 60, 62, 283, 2, 26, 56, 96, 12, 25, 28};
    private byte[] heroPlacingRt = new byte[]{0, 0, 0, 1, -1, 0, -3, 1, 3, 2, 1, 1, -7, 0, -3, 1, 3, 1, -2, 2, 3, 0, 3, -2, 4, 3, 0, 20, -1, 0, -2, 0, -1, -6, 19, -3, 10, -3, 14, -6, 7, -6, 4, -6, 5, -7, 28, 8, 24, 0, 17, -7, 0, 0, -4, -1, -9, -17, -14, -19, -17, -37, -4, 0, 7, -19, 19, -27, -3, -2, 0, -6, 0, 0, 0, 5, 3, 1, 3, 8, -3, 28, 1, 6, -4, 7, 0, 6, -19, 14, -23, 10, -20, 12, -20, 12, -2, 0, 0, 0, 7, 15, 0, 12, -6, 5, -7, 5, -6, 5, -21, 4, -22, 2, -2, -3, 0, 12, -1, 12, 9, 5, 8, 5, 9, 5, -3, 4, 1, 4, 2, 4, -4, 0, 0, -7, -2, -1, -9, -1, -9, -1, 2, 9, 2, 9, 0, 16, 0, -1, -14, 4, 0, -7, 2, 14, -6, 9, -7, 9, 3, 15, 5, 10, -21, -6, -33, 1, -29, 1, 0, 1, 0, 18};
    private byte[] heroPlacingLf = new byte[]{0, 0, 0, 1, 0, 0, 0, 1, 2, 2, 0, 1, -3, 0, 0, 1, 3, 1, 4, 2, -1, 0, 0, 2, 0, 3, 0, 20, -6, 0, -4, -1, 3, -6, -4, -3, -8, -3, -4, -6, -4, -6, -4, -6, -3, -7, -8, 8, -4, 0, 3, -7, -2, 0, 2, -1, 3, -17, 5, -19, 9, -37, -3, 0, -14, -19, -25, -27, -4, -2, -15, -6, -32, 0, -32, 5, -8, 1, -7, 8, -23, 28, -2, 6, -6, 7, -10, 6, -19, 14, -23, 10, -20, 12, -20, 12, -2, 0, 0, 0, 7, 15, -2, 12, -6, 5, -7, 5, -6, 5, -21, 4, -22, 2, -2, -3, 0, 12, -1, 12, 9, 5, 8, 5, 9, 5, -3, 4, 1, 4, 2, 4, -4, 0, 0, -7, -2, -1, -9, -1, -9, -1, 2, 9, 2, 9, -1, 16, -4, -1, -3, 4, -15, -7, -3, 14, -3, 9, -3, 9, -16, 15, 5, 10, -21, -6, -33, 1, -29, 1, 0, 1, -5, 18};
    private byte[] framePos = new byte[]{0, 2, 9, 13, 26, 34, 38, 41, 44, 51, 52, 60, 63, 66, 69, 73, 74, 81, 82, 85, 86};

    public Hero(int xPosition, int yPosition, int width, int height, int direction, boolean hidden, MyCanvas canvas) {
        this.canvas = canvas;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.dir = (byte)direction;
    }

    public static void initResources() {
        try {
            image = new Image[11];
            if (MyCanvas.gameLevel == 2) {
                Hero.image[2] = Image.createImage((String)"/h_bow_arrow.png");
                Hero.image[6] = Image.createImage((String)"/h_horse.png");
                Hero.image[10] = Image.createImage((String)"/h_horse_jump.png");
            } else {
                Hero.image[0] = Image.createImage((String)"/h_st_run.png");
                Hero.image[5] = Image.createImage((String)"/h_die.png");
                if (MyCanvas.gameLevel != 4) {
                    Hero.image[1] = Image.createImage((String)"/h_jump.png");
                    Hero.image[2] = Image.createImage((String)"/h_bow_arrow.png");
                    Hero.image[3] = Image.createImage((String)"/h_eg_hang.png");
                    Hero.image[4] = Image.createImage((String)"/h_sword.png");
                    Hero.image[9] = Image.createImage((String)"/h_handfight.png");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in Hero Image Creation :" + e.toString());
        }
    }

    void updateHero() {
        try {
            switch (this.action) {
                case 0: {
                    if (MyCanvas.gameLevel == 2) {
                        this.action = (byte)10;
                        this.frame = 1;
                        this.frameCtr = 0;
                        this.yVel = (byte)5;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(4) || MyCanvas.haveKeyHold(4)) {
                        this.action = 1;
                        this.dir = 1;
                    } else if (MyCanvas.haveKeyPressed(64) || MyCanvas.haveKeyHold(64)) {
                        this.action = 1;
                        this.dir = (byte)-1;
                    } else if (MyCanvas.haveKeyPressed(16)) {
                        this.action = (byte)8;
                    }
                    if (MyCanvas.haveKeyPressed(1)) {
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 2;
                        this.jumpCtr = 0;
                        this.xVel = (byte)(16 >> 1);
                        this.JumpHtReached = false;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(256)) {
                        if (MyCanvas.isPowerAvailable) {
                            this.action = (byte)7;
                            this.frame = 0;
                            this.frameCtr = 0;
                            break;
                        }
                        if (this.checkForHandFight()) {
                            this.action = (byte)14;
                            this.canvas.playSound(6);
                            this.frame = (byte)-1;
                            break;
                        }
                        this.action = (byte)25;
                        this.canvas.playSound(4);
                        this.frame = (byte)-1;
                        this.frameCtr = 0;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(2048) && this.canvas.arrowCount > 0) {
                        this.action = (byte)11;
                        this.frame = 1;
                        this.frameCtr = 0;
                        this.weapon = 1;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(128)) {
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 2;
                        this.jumpCtr = 0;
                        this.JumpHtReached = false;
                        this.dir = (byte)-1;
                        this.xVel = (byte)(16 >> 1);
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(2)) break;
                    this.action = (byte)2;
                    this.frame = (byte)-1;
                    this.jumpLimit = 2;
                    this.jumpCtr = 0;
                    this.JumpHtReached = false;
                    this.dir = 1;
                    this.xVel = (byte)(16 >> 1);
                    break;
                }
                case 1: {
                    if (MyCanvas.haveKeyReleased(4) || MyCanvas.haveKeyReleased(64)) {
                        if (this.weapon == 0) {
                            this.action = 0;
                            this.frame = 0;
                        } else {
                            this.action = (byte)11;
                            this.frame = 1;
                        }
                        this.frameCtr = 0;
                    }
                    if (MyCanvas.haveKeyHold(4)) {
                        this.action = 1;
                        this.dir = 1;
                    } else if (MyCanvas.haveKeyHold(64)) {
                        this.action = 1;
                        this.dir = (byte)-1;
                    } else if (MyCanvas.haveKeyPressed(16)) {
                        this.action = (byte)8;
                    } else if (MyCanvas.haveKeyPressed(256)) {
                        this.action = (byte)25;
                        this.canvas.playSound(4);
                        this.frame = (byte)-1;
                    }
                    if (!MyCanvas.haveKeyPressed(1)) break;
                    this.action = (byte)2;
                    this.frame = (byte)-1;
                    this.jumpLimit = 2;
                    this.jumpCtr = 0;
                    this.JumpHtReached = false;
                    this.xVel = (byte)(16 >> 1);
                    break;
                }
                case 8: {
                    if (!MyCanvas.haveKeyReleased(16) && !MyCanvas.haveKeyPressed(1)) break;
                    if (this.weapon == 0) {
                        this.action = 0;
                        this.frame = 0;
                    } else {
                        this.action = (byte)11;
                        this.frame = 1;
                    }
                    this.frameCtr = 0;
                    break;
                }
                case 2: {
                    if (!MyCanvas.haveKeyHold(1) || this.jumpLimit >= 3) break;
                    ++this.jumpLimit;
                    break;
                }
                case 9: {
                    if (MyCanvas.haveKeyPressed(1)) {
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 2;
                        this.jumpCtr = 0;
                        this.xVel = (byte)(16 >> 1);
                        this.JumpHtReached = false;
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(16)) break;
                    this.action = (byte)13;
                    break;
                }
                case 13: {
                    if (!MyCanvas.haveKeyReleased(16) && !MyCanvas.haveKeyPressed(1)) break;
                    this.action = (byte)9;
                    break;
                }
                case 11: {
                    this.fireArrow = false;
                    if (MyCanvas.gameLevel != 2 && MyCanvas.haveKeyPressed(2048)) {
                        this.action = 0;
                        this.weapon = 0;
                    } else if (MyCanvas.haveKeyPressed(1)) {
                        this.bowPos = this.bowPos < 3 ? (this.bowPos = (byte)(this.bowPos + 1)) : this.bowPos;
                    } else if (MyCanvas.haveKeyPressed(16)) {
                        this.bowPos = this.bowPos > 1 ? (this.bowPos = (byte)(this.bowPos - 1)) : this.bowPos;
                    } else if (!this.fireArrow && MyCanvas.haveKeyPressed(256)) {
                        if (MyCanvas.gameLevel != 2) {
                            this.canvas.arrowCount = (byte)(this.canvas.arrowCount - 1);
                        }
                        if (MyCanvas.isPowerAvailable) {
                            this.action = (byte)7;
                            this.frame = 0;
                            this.frameCtr = 0;
                        } else {
                            this.fireArrow = true;
                            switch (this.frame) {
                                case 1: {
                                    this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 28 : -8), this.yPosition + 8, 3, 3, (16 * MyCanvas.cos(0) >> 9) * this.dir, -(16 * MyCanvas.sin(0) >> 9), false, 0, 0, 0, this.canvas));
                                    break;
                                }
                                case 2: {
                                    this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 24 : -4), this.yPosition - 0, 3, 3, (16 * MyCanvas.cos(25) >> 9) * this.dir, -(16 * MyCanvas.sin(25) >> 9), false, 0, 0, 0, this.canvas));
                                    break;
                                }
                                case 3: {
                                    this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 17 : 3), this.yPosition - 7, 3, 3, (16 * MyCanvas.cos(60) >> 9) * this.dir, -(16 * MyCanvas.sin(60) >> 9), false, 0, 0, 0, this.canvas));
                                }
                            }
                            this.canvas.playSound(5);
                        }
                    }
                    if (MyCanvas.gameLevel == 2 && (MyCanvas.haveKeyPressed(4) || MyCanvas.haveKeyHold(4))) {
                        this.action = (byte)10;
                        this.dir = 1;
                        break;
                    }
                    if (MyCanvas.gameLevel != 2) {
                        if (MyCanvas.haveKeyPressed(4) || MyCanvas.haveKeyHold(4)) {
                            if (this.dir == 1) {
                                this.action = 1;
                                this.dir = 1;
                                break;
                            }
                            this.dir = 1;
                            break;
                        }
                        if (!MyCanvas.haveKeyPressed(64) && !MyCanvas.haveKeyHold(64)) break;
                        if (this.dir == -1) {
                            this.action = 1;
                            this.dir = (byte)-1;
                            break;
                        }
                        this.dir = (byte)-1;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(8)) {
                        this.action = (byte)15;
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(4)) break;
                    this.action = (byte)23;
                    this.frame = (byte)-1;
                    this.jumpLimit = 2;
                    this.jumpCtr = 0;
                    this.xVel = (byte)(16 >> 1);
                    this.JumpHtReached = false;
                    break;
                }
                case 15: {
                    if (!MyCanvas.haveKeyReleased(8) && !MyCanvas.haveKeyPressed(2)) break;
                    this.action = (byte)10;
                    this.frame = 1;
                    this.frameCtr = 0;
                    break;
                }
                case 10: {
                    this.fireArrow = false;
                    if (MyCanvas.haveKeyPressed(1)) {
                        this.bowPos = this.bowPos < 3 ? (this.bowPos = (byte)(this.bowPos + 1)) : this.bowPos;
                    } else if (MyCanvas.haveKeyPressed(16)) {
                        this.bowPos = this.bowPos > 1 ? (this.bowPos = (byte)(this.bowPos - 1)) : this.bowPos;
                    } else if (!this.fireArrow && MyCanvas.haveKeyPressed(256)) {
                        if (MyCanvas.gameLevel != 2) {
                            this.canvas.arrowCount = (byte)(this.canvas.arrowCount - 1);
                        }
                        this.fireArrow = true;
                        switch (this.frame) {
                            case 1: {
                                this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 28 : -8), this.yPosition + 8, 3, 3, (16 * MyCanvas.cos(0) >> 9) * this.dir, -(16 * MyCanvas.sin(0) >> 9), false, 0, 0, 0, this.canvas));
                                break;
                            }
                            case 2: {
                                this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 24 : -4), this.yPosition - 0, 3, 3, (16 * MyCanvas.cos(25) >> 9) * this.dir, -(16 * MyCanvas.sin(25) >> 9), false, 0, 0, 0, this.canvas));
                                break;
                            }
                            case 3: {
                                this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 17 : 3), this.yPosition - 7, 3, 3, (16 * MyCanvas.cos(60) >> 9) * this.dir, -(16 * MyCanvas.sin(60) >> 9), false, 0, 0, 0, this.canvas));
                            }
                        }
                        this.canvas.playSound(5);
                    }
                    if (MyCanvas.haveKeyPressed(8)) {
                        this.action = (byte)15;
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(4)) break;
                    this.action = (byte)23;
                    this.frame = (byte)-1;
                    this.jumpLimit = 2;
                    this.jumpCtr = 0;
                    this.xVel = (byte)(16 >> 1);
                    this.JumpHtReached = false;
                    break;
                }
                case 3: {
                    if (MyCanvas.haveKeyPressed(1)) {
                        if (MyCanvas.isReadyToClimb) {
                            this.action = (byte)16;
                            this.xPosition = this.canvas.edgeOffX;
                            this.yPosition = this.canvas.edgeOffY;
                            break;
                        }
                        this.action = (byte)4;
                        this.frame = 0;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(16)) {
                        this.action = (byte)6;
                        this.yPosition += 16 >> 2;
                        break;
                    }
                    if (this.dir > 0 && (MyCanvas.haveKeyPressed(64) || MyCanvas.haveKeyPressed(128))) {
                        this.action = (byte)2;
                        this.dir = (byte)-1;
                        this.frame = (byte)-1;
                        this.jumpLimit = 3;
                        this.jumpCtr = 0;
                        this.xVel = (byte)(16 >> 1);
                        this.JumpHtReached = false;
                        break;
                    }
                    if (this.dir >= 0 || !MyCanvas.haveKeyPressed(4) && !MyCanvas.haveKeyPressed(2)) break;
                    this.action = (byte)2;
                    this.dir = 1;
                    this.frame = (byte)-1;
                    this.jumpLimit = 3;
                    this.jumpCtr = 0;
                    this.xVel = (byte)(16 >> 1);
                    this.JumpHtReached = false;
                    break;
                }
                case 6: {
                    this.xVel = 0;
                    if (MyCanvas.haveKeyHold(4) || MyCanvas.haveKeyHold(2)) {
                        if (MyCanvas.isReadyToClimb) {
                            this.action = (byte)3;
                            this.xPosition = this.canvas.edgeOffX;
                            this.yPosition = this.canvas.edgeOffY;
                            this.frame = (byte)-1;
                        }
                        this.dir = 1;
                        this.xVel = (byte)4;
                        break;
                    }
                    if (!MyCanvas.haveKeyHold(64) && !MyCanvas.haveKeyHold(128)) break;
                    if (MyCanvas.isReadyToClimb) {
                        this.action = (byte)3;
                        this.xPosition = this.canvas.edgeOffX;
                        this.yPosition = this.canvas.edgeOffY;
                        this.frame = (byte)-1;
                    }
                    this.dir = (byte)-1;
                    this.xVel = (byte)4;
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in updateHero>>" + e);
        }
    }

    void update() {
        try {
            byte by = this.canvas.currPage;
            this.canvas.getClass();
            if (by != 18) {
                this.updateHero();
            }
            if (this.dir == 1) {
                this.imageRotation = 0;
                this.canvas.HeroXposOnScr = (MyCanvas.canvasWidth >> 1) - this.width * (MyCanvas.gameLevel == 2 ? 3 : 1);
            } else {
                this.imageRotation = (byte)2;
                this.canvas.HeroXposOnScr = MyCanvas.canvasWidth >> 1;
            }
            switch (this.action) {
                case 0: {
                    this.receiveKeypressed = true;
                    this.xVel = 0;
                    this.weapon = 0;
                    this.actionFrmPtr = 0;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    if (this.frameCtr > 3) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    this.imageNo = 0;
                    if (this.frame > 1) {
                        this.frame = 0;
                    }
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                    break;
                }
                case 1: {
                    this.actionFrmPtr = 1;
                    this.frame = (byte)(this.frame + 1);
                    this.imageNo = 0;
                    if (this.frame > 6) {
                        this.frame = 0;
                    }
                    this.xPosition += 6 * this.dir;
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                    break;
                }
                case 8: {
                    this.imageNo = 0;
                    this.actionFrmPtr = (byte)15;
                    this.frame = 0;
                    break;
                }
                case 2: {
                    this.actionFrmPtr = (byte)2;
                    this.imageNo = 1;
                    this.xPosition += this.xVel * this.dir;
                    if (this.JumpHtReached) {
                        if (!MyCanvas.isGroundTouched) {
                            this.frame = (byte)2;
                            this.action = (byte)6;
                            this.yPosition += 16 >> 2;
                            break;
                        }
                    }
                    if (this.JumpHtReached) {
                        if (MyCanvas.isGroundTouched) {
                            this.frame = (byte)2;
                            this.action = (byte)6;
                            this.yPosition += 16 >> 2;
                            break;
                        }
                    }
                    if (this.jumpCtr >= this.jumpLimit) break;
                    if (this.frame < 1) {
                        this.frame = (byte)(this.frame + 1);
                    }
                    if (this.frame != 0) {
                        this.yPosition -= 16 >> 1;
                        ++this.jumpCtr;
                    }
                    if (this.jumpCtr < this.jumpLimit) break;
                    this.JumpHtReached = true;
                    break;
                }
                case 11: {
                    this.actionFrmPtr = (byte)3;
                    this.imageNo = (byte)2;
                    this.frame = this.bowPos;
                    if (MyCanvas.gameLevel != 2 && !MyCanvas.isGroundTouched) {
                        this.imageNo = 1;
                        this.frame = (byte)2;
                        this.action = (byte)6;
                        this.actionFrmPtr = (byte)2;
                    } else if (MyCanvas.gameLevel == 2 && !MyCanvas.isGroundTouched) {
                        this.action = (byte)23;
                        this.xVel = (byte)(16 >> 1);
                        this.JumpHtReached = true;
                    }
                    if (MyCanvas.gameLevel == 2 || this.canvas.arrowCount >= 1) break;
                    this.action = 0;
                    this.weapon = 0;
                    break;
                }
                case 15: {
                    this.actionFrmPtr = (byte)8;
                    this.frame = 1;
                    this.imageNo = (byte)6;
                    this.heroOffY = (byte)(this.heroOffY + 1);
                    if (this.heroOffY > 3) {
                        this.heroOffY = 0;
                    }
                    this.xPosition += 6 * this.dir;
                    break;
                }
                case 10: {
                    this.actionFrmPtr = (byte)3;
                    this.imageNo = (byte)2;
                    this.frame = this.bowPos;
                    this.heroOffY = (byte)(this.heroOffY + 1);
                    if (this.heroOffY > 3) {
                        this.heroOffY = 0;
                    }
                    this.xPosition += 3 * this.dir;
                    if (MyCanvas.gameLevel != 2 || MyCanvas.isGroundTouched) break;
                    this.action = (byte)23;
                    this.xVel = (byte)(16 >> 1);
                    this.JumpHtReached = true;
                    break;
                }
                case 23: {
                    this.actionFrmPtr = (byte)18;
                    this.imageNo = (byte)10;
                    this.xPosition += this.xVel * this.dir;
                    if (this.JumpHtReached) {
                        if (MyCanvas.isGroundTouched) {
                            this.action = (byte)10;
                            this.actionFrmPtr = (byte)3;
                            this.imageNo = (byte)2;
                            this.frame = 1;
                            this.frameCtr = 0;
                            break;
                        }
                    }
                    if (this.JumpHtReached) {
                        if (!MyCanvas.isGroundTouched) {
                            this.frame = (byte)2;
                            this.yPosition += 16 >> 2;
                            break;
                        }
                    }
                    if (this.jumpCtr >= this.jumpLimit) break;
                    if (this.frame < 1) {
                        this.frame = (byte)(this.frame + 1);
                    }
                    if (this.frame != 0) {
                        this.yPosition -= 16 >> 1;
                        ++this.jumpCtr;
                    }
                    if (this.jumpCtr < this.jumpLimit) break;
                    this.JumpHtReached = true;
                    break;
                }
                case 12: {
                    this.actionFrmPtr = (byte)8;
                    this.frame = 0;
                    this.imageNo = (byte)6;
                    if (this.frameCtr < 8) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                    } else {
                        this.yVel = (byte)(this.yVel + 1);
                        this.frameCtr = 0;
                    }
                    if (this.yVel <= 6) break;
                    this.yVel = (byte)6;
                    this.canvas.getClass();
                    this.canvas.currPage = (byte)9;
                    this.canvas.shutterY = 0;
                    this.canvas.shutterMaxY = 16 * 2;
                    break;
                }
                case 3: {
                    this.actionFrmPtr = (byte)4;
                    this.imageNo = (byte)3;
                    break;
                }
                case 4: {
                    this.actionFrmPtr = (byte)4;
                    this.imageNo = (byte)3;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame != 5) break;
                    this.action = (byte)6;
                    this.yPosition -= 16 * 2;
                    break;
                }
                case 16: {
                    this.actionFrmPtr = (byte)4;
                    this.imageNo = (byte)3;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame <= 7) break;
                    if (this.weapon == 0) {
                        this.action = 0;
                        this.frame = 0;
                        this.actionFrmPtr = 0;
                        this.imageNo = 0;
                    } else {
                        this.action = (byte)11;
                        this.frame = 1;
                        this.actionFrmPtr = (byte)3;
                        this.imageNo = (byte)2;
                    }
                    this.frameCtr = 0;
                    this.yPosition -= this.height;
                    this.xPosition += 16 * this.dir;
                    break;
                }
                case 17: {
                    this.actionFrmPtr = (byte)4;
                    this.imageNo = (byte)3;
                    this.xPosition = this.canvas.edgeOffX;
                    this.yPosition = this.canvas.edgeOffY;
                    this.frame = (byte)(this.frame - 1);
                    if (this.frame >= 6) break;
                    this.action = (byte)3;
                    break;
                }
                case 5: {
                    this.imageNo = (byte)5;
                    this.actionFrmPtr = (byte)6;
                    if (this.frameCtr < 8) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                    } else {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    if (this.frame <= 2) break;
                    this.frame = (byte)2;
                    this.canvas.getClass();
                    this.canvas.currPage = (byte)9;
                    this.canvas.shutterY = 0;
                    this.canvas.shutterMaxY = 16 * 2;
                    break;
                }
                case 7: {
                    this.imageNo = (byte)5;
                    this.actionFrmPtr = (byte)7;
                    if (this.frameCtr < 1) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                    } else {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    if (this.frame <= 2) break;
                    this.frame = (byte)2;
                    if (this.weapon == 0) {
                        this.action = 0;
                        this.frame = 0;
                    } else {
                        this.action = (byte)11;
                        this.frame = 1;
                        this.actionFrmPtr = (byte)3;
                        this.imageNo = (byte)2;
                    }
                    this.frameCtr = 0;
                    break;
                }
                case 25: {
                    this.imageNo = (byte)4;
                    this.actionFrmPtr = (byte)5;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame <= 3) break;
                    this.action = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    break;
                }
                case 26: {
                    this.imageNo = (byte)7;
                    this.actionFrmPtr = (byte)10;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame <= 7) break;
                    this.action = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    break;
                }
                case 27: {
                    this.imageNo = (byte)8;
                    this.actionFrmPtr = (byte)14;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame <= 3) break;
                    this.action = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    break;
                }
                case 14: {
                    this.imageNo = (byte)9;
                    this.actionFrmPtr = (byte)16;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame > 2 && this.waitCtr == 0) {
                        this.frame = 0;
                        this.waitCtr = 1;
                        break;
                    }
                    if (this.waitCtr == 1) {
                        this.frame = 0;
                        this.waitCtr = (byte)2;
                        break;
                    }
                    if (this.waitCtr == 2) {
                        this.frame = (byte)3;
                        this.waitCtr = (byte)3;
                        break;
                    }
                    if (this.frame > 6 && this.waitCtr > 2) {
                        this.frame = (byte)3;
                        this.waitCtr = (byte)4;
                        break;
                    }
                    if (this.waitCtr != 4) break;
                    this.action = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    this.waitCtr = 0;
                    this.canvas.expectedLoopTime >>= 1;
                    break;
                }
                case 6: {
                    if (this.isDead) {
                        this.imageNo = (byte)5;
                        this.actionFrmPtr = (byte)6;
                        this.frame = 0;
                        this.yPosition += 16 >> 1;
                        if (!MyCanvas.isGroundTouched) break;
                        this.action = (byte)5;
                        break;
                    }
                    this.actionFrmPtr = (byte)2;
                    if (MyCanvas.isGroundTouched) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frame != 3 || this.frameCtr < 3) {
                            this.imageNo = 0;
                            this.actionFrmPtr = 1;
                            this.frame = (byte)3;
                            break;
                        }
                        this.JumpHtReached = false;
                        this.xVel = 0;
                        if (this.weapon == 0) {
                            this.action = 0;
                            this.frame = 0;
                            this.actionFrmPtr = 0;
                            this.imageNo = 0;
                        } else {
                            this.action = (byte)11;
                            this.frame = 1;
                            this.actionFrmPtr = (byte)3;
                            this.imageNo = (byte)2;
                        }
                        this.frameCtr = 0;
                        break;
                    }
                    this.xPosition += this.xVel * this.dir;
                    this.frameCtr = 0;
                    this.actionFrmPtr = (byte)2;
                    this.imageNo = 1;
                    this.frame = this.frame < 2 ? (byte)(this.frame + 1) : (byte)2;
                    this.yPosition += 16 >> 1;
                    break;
                }
                case 9: {
                    this.actionFrmPtr = (byte)9;
                    this.imageNo = 1;
                    this.frame = 0;
                    this.xPosition += (16 >> 2) * this.dir;
                    this.yPosition += 16 >> 3;
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                    break;
                }
                case 13: {
                    this.actionFrmPtr = (byte)20;
                    this.imageNo = 1;
                    this.frame = 0;
                    this.xPosition += (16 >> 2) * this.dir;
                    this.yPosition += 16 >> 3;
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                }
            }
            this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + this.frame);
            if (this.isHit) {
                if (this.hitCounter == 0) {
                    this.canvas.life = (byte)(this.canvas.life - 7);
                }
                this.hitCounter = (byte)(this.hitCounter + 1);
                if (this.hitCounter > 15) {
                    this.isHit = false;
                    this.hitCounter = 0;
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in hero update>>" + this.action + " " + e);
        }
    }

    public void draw(Graphics g) {
        try {
            if (MyCanvas.gameLevel == 2) {
                if (this.hitCounter % 2 == 0 || this.action == 5) {
                    if (this.action == 11 || this.action == 10 || this.action == 15) {
                        if (this.action == 15) {
                            this.framePtr = this.framePos[17];
                        }
                        g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]) + (this.heroOffY == 3 ? (byte)1 : this.heroOffY), 0);
                        if (this.action != 15) {
                            this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + (this.fireArrow ? 2 : 3) + this.frame * 2);
                            g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]) + (this.heroOffY == 3 ? (byte)1 : this.heroOffY), 0);
                        }
                        this.actionFrmPtr = (byte)8;
                        this.imageNo = (byte)6;
                        this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + this.heroOffY);
                        g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]), 0);
                    } else {
                        if (this.action != 23) {
                            this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + this.heroOffY);
                        }
                        g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]), 0);
                        if (this.action == 23) {
                            return;
                        }
                        this.framePtr = this.action == 15 ? this.framePos[17] : (byte)(this.framePos[this.actionFrmPtr] + this.yVel);
                        g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]) + (this.heroOffY == 3 ? (byte)1 : this.heroOffY), 0);
                    }
                }
                return;
            }
            if (this.hitCounter % 2 == 0 || this.action == 5 || this.action == 14) {
                g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]), 0);
                if (this.action == 11) {
                    this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + 0);
                    g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]), 0);
                    this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + (this.fireArrow ? 2 : 3) + this.frame * 2);
                    g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]), 0);
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in hero draw>>" + e);
        }
    }

    private boolean checkForHandFight() {
        for (int i = 0; i < this.canvas.enemyArr.length; ++i) {
            if (this.canvas.enemyArr[i] == null || this.canvas.enemyArr[i].type > 1 || this.canvas.enemyArr[i].isDead || Math.abs(this.canvas.enemyArr[i].xDistance) >= this.canvas.enemyArr[i].width || Math.abs(this.canvas.enemyArr[i].yDistance) >= this.canvas.enemyArr[i].height >> 1) continue;
            if (this.dir > 0 && this.canvas.enemyArr[i].xDistance > 0) {
                this.canvas.enemyArr[i].waitCtr = 0;
                this.canvas.enemyArr[i].type = (byte)5;
                this.canvas.enemyArr[i].frame = (byte)-1;
                this.canvas.enemyArr[i].dir = (byte)-1;
                this.canvas.enemyArr[i].xPosition = this.xPosition + 28 + 3;
                this.canvas.expectedLoopTime <<= 1;
                return true;
            }
            if (this.dir >= 0 || this.canvas.enemyArr[i].xDistance >= 0) continue;
            this.canvas.enemyArr[i].waitCtr = 0;
            this.canvas.enemyArr[i].type = (byte)5;
            this.canvas.enemyArr[i].frame = (byte)-1;
            this.canvas.enemyArr[i].dir = 1;
            this.canvas.enemyArr[i].xPosition = this.xPosition - this.canvas.enemyArr[i].width - 3;
            this.canvas.expectedLoopTime <<= 1;
            return true;
        }
        return false;
    }
}

