/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.text;

import com.lemonquest.text.LQFont;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class LQSimpleFont
extends LQFont {
    protected Font m_font;
    protected int m_textColor;
    protected int m_edgeColor;

    public LQSimpleFont(Font font, int textColor, int edgeColor) {
        this.m_font = font;
        this.m_textColor = textColor;
        this.m_edgeColor = edgeColor;
    }

    public short[][] drawString(Graphics g, String data, int x, int y, int width, int height, int anchor) {
        this.drawFastString(g, data, null, x, y, width, height, anchor);
        return null;
    }

    public int drawString(Graphics g, String text, int x, int y, int anchor) {
        int textWidth = this.m_font.stringWidth(text);
        if (this.m_edgeColor >= 0) {
            g.setColor(this.m_edgeColor);
            g.drawString(text, x + 1, y - 1, anchor);
            g.drawString(text, x - 1, y + 1, anchor);
            g.drawString(text, x - 1, y - 1, anchor);
            g.drawString(text, x + 1, y + 1, anchor);
        }
        g.setColor(this.m_textColor);
        g.drawString(text, x, y, anchor);
        return textWidth;
    }

    public short[][] drawFastString(Graphics g, String data, short[][] mLineData, int x, int y, int width, int height, int anchor) {
        int fontHeight = this.m_font.getHeight();
        String[] strings = LQSimpleFont.getStrings(data, width, this.m_font);
        int textHeight = strings.length * fontHeight;
        if ((anchor & 0x20) != 0) {
            y -= textHeight;
        } else if ((anchor & 2) != 0) {
            y = y + fontHeight + (height - textHeight >> 1);
        }
        if ((anchor & 8) != 0) {
            x += width;
        } else if ((anchor & 1) != 0) {
            x += width / 2;
        }
        for (int i = 0; i < strings.length; ++i) {
            int tmpY = y + fontHeight * i;
            if (this.m_edgeColor >= 0) {
                g.setColor(this.m_edgeColor);
                g.drawString(strings[i], x + 1, tmpY - 1, anchor);
                g.drawString(strings[i], x - 1, tmpY + 1, anchor);
                g.drawString(strings[i], x - 1, tmpY - 1, anchor);
                g.drawString(strings[i], x + 1, tmpY + 1, anchor);
            }
            g.setColor(this.m_textColor);
            g.drawString(strings[i], x, tmpY, anchor);
        }
        return null;
    }

    public short[][] drawFastString(Graphics g, String data, int x, int y, int width, int height, int anchor, int firstLine, int linesToDraw) {
        int fontHeight = this.m_font.getHeight();
        String[] strings = LQSimpleFont.getStrings(data, width, this.m_font);
        int maxLines = height / fontHeight;
        if (maxLines > linesToDraw) {
            maxLines = linesToDraw;
        }
        int textHeight = maxLines * fontHeight;
        if ((anchor & 8) != 0) {
            x += width;
        } else if ((anchor & 1) != 0) {
            x += width / 2;
        }
        if ((anchor & 0x20) != 0) {
            y -= textHeight;
            anchor &= 0xFFFFFFDF;
        } else if ((anchor & 2) != 0) {
            y += height - textHeight >> 1;
            anchor &= 0xFFFFFFFD;
        }
        anchor |= 0x10;
        for (int i = firstLine; i < firstLine + maxLines && i < strings.length; ++i) {
            int tmpY = y + (i - firstLine) * fontHeight;
            if (this.m_edgeColor >= 0) {
                g.setColor(this.m_edgeColor);
                g.drawString(strings[i], x + 1, tmpY - 1, anchor);
                g.drawString(strings[i], x - 1, tmpY + 1, anchor);
                g.drawString(strings[i], x - 1, tmpY - 1, anchor);
                g.drawString(strings[i], x + 1, tmpY + 1, anchor);
            }
            g.setColor(this.m_textColor);
            g.drawString(strings[i], x, tmpY, anchor);
        }
        return null;
    }

    public short[][] getLineData(String text, int width) {
        String[] strings = LQSimpleFont.getStrings(text, width, this.m_font);
        return new short[strings.length][];
    }

    public int getFontHeight() {
        return this.m_font.getHeight();
    }

    public int getLineSpacing() {
        return 0;
    }

    protected static String[] getStrings(String s, int drawWidth, Font fnt) {
        int sl = s.length();
        int beginID = 0;
        int endID = 0;
        int lineWidth = 0;
        int spaceID = 0;
        Vector<String> vS = new Vector<String>();
        for (int i = 0; i < sl; ++i) {
            boolean bLineEnd = false;
            boolean bLink = false;
            char ch = s.charAt(i);
            if (i == sl - 1) {
                endID = i + 1;
                bLineEnd = true;
            } else {
                if (ch == ' ' || ch == '.') {
                    spaceID = i;
                }
                if ((lineWidth = fnt.substringWidth(s, beginID, i - beginID + 1)) >= drawWidth) {
                    if (ch != ' ' && ch != '.') {
                        if (spaceID <= beginID) {
                            endID = i;
                            bLink = true;
                        } else {
                            endID = spaceID + 1;
                        }
                    } else {
                        endID = i + 1;
                    }
                    bLineEnd = true;
                }
                if (ch == '\n') {
                    endID = i + 1;
                    bLineEnd = true;
                }
            }
            if (!bLineEnd) continue;
            String tstr = s.substring(beginID, endID);
            tstr = tstr.replace('\n', ' ');
            if (bLink) {
                tstr = tstr + "-";
            }
            vS.addElement(tstr);
            beginID = endID;
        }
        Object[] strs = new String[vS.size()];
        vS.copyInto(strs);
        return strs;
    }
}

