/*
 * Decompiled with CFR 0.152.
 */
import com.lemonquest.ui.LQDialog;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TxtShow {
    String[] txtStrs;
    int txtDrawX;
    int txtDrawY;
    int txtWidth;
    int lineHeight;
    int lineShowNum;
    int txtPageNum;
    int txtShowPageID;
    int txtColor = 0xFFFFFF;
    Font txtFont;
    byte horizontalType;
    static final byte H_LEFT = 0;
    static final byte H_RIGHT = 1;
    static final byte H_CENTER = 3;
    int bgColor;
    int jumpRange;
    int countTimes;
    LQDialog dialogLQ;
    boolean isDrawTxtImage;

    public TxtShow(String[] stra, int width, int height, int rsn, Font fnt, boolean isDrawTxtImage) {
        this.init(width, height, rsn, fnt);
        this.isDrawTxtImage = isDrawTxtImage;
        if (!isDrawTxtImage) {
            Vector<String> vS = new Vector<String>();
            for (int i = 0; i < stra.length; ++i) {
                if (stra[i].length() == 0) {
                    vS.addElement(stra[i]);
                    continue;
                }
                String[] tstra = null;
                tstra = TxtShow.getStrings(stra[i], width, this.txtFont);
                for (int j = 0; j < tstra.length; ++j) {
                    vS.addElement(tstra[j]);
                }
            }
            this.txtStrs = new String[vS.size()];
            vS.copyInto(this.txtStrs);
            this.initPageData();
        } else {
            this.dialogLQ = new LQDialog(stra, width, rsn * GameScreen.fontLQ.getFontHeight(), GameScreen.fontLQ);
            this.txtStrs = new String[this.dialogLQ.m_lineData.length];
            this.txtPageNum = this.dialogLQ.m_pageNum;
        }
    }

    public TxtShow(String str, int width, int height, int rsn, Font fnt, boolean isDrawTxtImage) {
        this.init(width, height, rsn, fnt);
        this.isDrawTxtImage = isDrawTxtImage;
        if (!isDrawTxtImage) {
            this.txtStrs = TxtShow.getStrings(str, width, this.txtFont);
            this.initPageData();
        } else {
            this.dialogLQ = new LQDialog(str, width, rsn * GameScreen.fontLQ.getFontHeight(), GameScreen.fontLQ);
            this.txtStrs = new String[this.dialogLQ.m_lineData.length];
            this.txtPageNum = this.dialogLQ.m_pageNum;
        }
    }

    private void init(int width, int height, int rsn, Font fnt) {
        this.txtWidth = width;
        this.lineHeight = height;
        this.lineShowNum = rsn;
        this.txtFont = fnt;
    }

    private void initPageData() {
        this.txtPageNum = this.txtStrs.length / this.lineShowNum;
        if (this.txtStrs.length % this.lineShowNum != 0) {
            ++this.txtPageNum;
        }
        this.txtShowPageID = 0;
    }

    public void setTxtMode(byte ht, int tc, int bc, int jr) {
        this.horizontalType = ht;
        this.txtColor = tc;
        this.bgColor = bc;
        this.jumpRange = jr;
    }

    public boolean keyPressed(int keyCode, int key, byte keyType) {
        if (keyType == 0) {
            if (key == 8 || keyCode == 7 || keyCode == 11 || keyCode == 6) {
                boolean tmp = this.dialogLQ.scrollDown();
                this.txtShowPageID = this.dialogLQ.m_currentPage;
                return tmp;
            }
        } else if (keyType == 1) {
            switch (key) {
                case 1: {
                    boolean tmp = this.dialogLQ.scrollUp();
                    this.txtShowPageID = this.dialogLQ.m_currentPage;
                    return tmp;
                }
                case 6: {
                    boolean tmp = this.dialogLQ.scrollDown();
                    this.txtShowPageID = this.dialogLQ.m_currentPage;
                    return tmp;
                }
            }
        }
        return false;
    }

    public void draw(Graphics g, int x, int y) {
        this.txtDrawX = x;
        this.txtDrawY = y;
        if (!this.isDrawTxtImage) {
            ++this.countTimes;
            if (this.txtStrs == null) {
                return;
            }
            g.setFont(this.txtFont);
            for (int i = 0; i < this.lineShowNum; ++i) {
                int tdx;
                int lid = this.lineShowNum * this.txtShowPageID + i;
                if (lid >= this.txtStrs.length) continue;
                switch (this.horizontalType) {
                    case 3: {
                        tdx = this.txtDrawX + (this.txtWidth - this.txtFont.stringWidth(this.txtStrs[lid]) >> 1);
                        break;
                    }
                    case 1: {
                        tdx = this.txtDrawX + this.txtWidth - this.txtFont.stringWidth(this.txtStrs[lid]);
                        break;
                    }
                    default: {
                        tdx = this.txtDrawX;
                    }
                }
                TxtShow.drawString(g, this.txtStrs[lid], tdx, this.txtDrawY + this.lineHeight * i, this.txtColor, this.bgColor, this.jumpRange);
            }
        } else {
            int anchor = 0;
            switch (this.horizontalType) {
                case 3: {
                    anchor = 17;
                    break;
                }
                case 1: {
                    anchor = 24;
                    break;
                }
                default: {
                    anchor = 20;
                }
            }
            this.dialogLQ.draw(g, this.txtDrawX, this.txtDrawY, anchor);
        }
    }

    public int getTxtWidth() {
        return this.txtWidth;
    }

    public int getTxtHeight() {
        if (this.txtStrs == null) {
            return 0;
        }
        if (this.txtStrs.length < this.lineShowNum) {
            return this.lineHeight * this.txtStrs.length;
        }
        return this.lineHeight * this.lineShowNum;
    }

    public void setHCenter() {
        this.txtDrawX = 176 - this.txtWidth >> 1;
    }

    public void setVCenter() {
        this.txtDrawY = 208 - this.getTxtHeight() >> 1;
    }

    public static String[] getStrings(String s, int drawWidth, Font fnt) {
        int sl = s.length();
        int beginID = 0;
        int endID = 0;
        int lineWidth = 0;
        int spaceID = 0;
        Vector<String> vS = new Vector<String>();
        for (int i = 0; i < sl; ++i) {
            boolean bLineEnd = false;
            boolean bLink = false;
            char ch = s.charAt(i);
            if (i == sl - 1) {
                endID = i + 1;
                bLineEnd = true;
            } else {
                if (ch == ' ') {
                    spaceID = i;
                }
                if ((lineWidth = fnt.substringWidth(s, beginID, i - beginID + 1)) >= drawWidth) {
                    if (ch != ' ') {
                        if (spaceID <= beginID) {
                            endID = i;
                            bLink = true;
                        } else {
                            endID = spaceID + 1;
                        }
                    } else {
                        endID = i + 1;
                    }
                    bLineEnd = true;
                }
            }
            if (!bLineEnd) continue;
            String tstr = s.substring(beginID, endID);
            if (bLink) {
                tstr = tstr + "-";
            }
            vS.addElement(tstr);
            beginID = endID;
        }
        Object[] strs = new String[vS.size()];
        vS.copyInto(strs);
        return strs;
    }

    public static void drawString(Graphics g, String s, int x, int y, int frontColor, int bgColor) {
        if (bgColor >= 0) {
            g.setColor(bgColor);
            g.drawString(s, x - 1, y - 1, 0);
            g.drawString(s, x, y - 1, 0);
            g.drawString(s, x + 1, y - 1, 0);
            g.drawString(s, x - 1, y, 0);
            g.drawString(s, x + 1, y, 0);
            g.drawString(s, x - 1, y + 1, 0);
            g.drawString(s, x, y + 1, 0);
            g.drawString(s, x + 1, y + 1, 0);
        }
        g.setColor(frontColor);
        g.drawString(s, x, y, 0);
    }

    public static void drawString(Graphics g, String s, int x, int y, int frontColor, int bgColor, int jrange) {
        if (jrange == 0) {
            TxtShow.drawString(g, s, x, y, frontColor, bgColor);
        } else {
            int w = 0;
            int[] f = new int[]{-jrange, 0, jrange, 0};
            for (int i = 0; i < s.length(); ++i) {
                w = Font.getFont((int)0, (int)0, (int)8).substringWidth(s, 0, i);
                TxtShow.drawString(g, s.substring(i, i + 1), x + w, y + f[i + 0 & 3], frontColor, bgColor);
            }
        }
    }
}

