/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Animation {
    static final int EXTEND_PER_ACTION = 2;
    static final int EXTEND_PER_MODULE = 4;
    static final int EXTEND_PER_SPRITE = 4;
    static final int EXTEND_PER_MECHMODULE = 4;
    static final int EXTEND_PER_COLBOX = 4;
    static final int EXTEND_PER_ATTBOX = 4;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT180 = 1;
    int m_imageID;
    byte[][] m_actions;
    byte[] m_nFrames;
    short[] m_mechModels;
    byte[] m_mechModelFlag;
    public byte[][] m_frames;
    byte[] m_colBox;
    byte[] m_attBox;
    short[] m_modules;
    public Image s_images;
    public int simaWidth;
    public int simaHeight;

    public void loadAnimation(DataInputStream is) throws Exception {
        int num;
        int i;
        int size = is.readUnsignedShort();
        this.m_imageID = is.readUnsignedShort();
        int count = is.readUnsignedShort();
        this.m_modules = new short[count * 4];
        for (i = 0; i < count; ++i) {
            this.m_modules[4 * i] = (short)(is.readByte() & 0xFF);
            this.m_modules[4 * i + 1] = (short)(is.readByte() & 0xFF);
            this.m_modules[4 * i + 2] = (short)(is.readByte() & 0xFF);
            this.m_modules[4 * i + 3] = (short)(is.readByte() & 0xFF);
        }
        count = is.readUnsignedShort();
        this.m_colBox = new byte[count * 4];
        this.m_attBox = new byte[count * 4];
        this.m_frames = new byte[count][];
        for (i = 0; i < count; ++i) {
            size = is.readUnsignedByte();
            num = is.readUnsignedByte();
            this.m_frames[i] = new byte[num * 4];
            this.m_frames[i] = Map.readData(is, num * 4);
            this.m_colBox = Map.readData(is, 4);
            this.m_attBox = Map.readData(is, 4);
        }
        count = is.readUnsignedShort();
        this.m_nFrames = new byte[count];
        this.m_actions = new byte[count][];
        this.m_mechModelFlag = new byte[count];
        this.m_mechModels = new short[count * 4];
        for (i = 0; i < count; ++i) {
            size = is.readUnsignedByte();
            num = is.readUnsignedByte();
            this.m_nFrames[i] = (byte)num;
            this.m_actions[i] = new byte[num * 2];
            this.m_actions[i] = Map.readData(is, num * 2);
            this.m_mechModelFlag[i] = (byte)is.readUnsignedByte();
            size = (size - 1 - num * 2 - 1) / 2;
            for (int j = 0; j < size; ++j) {
                this.m_mechModels[i * 4 + j] = is.readShort();
            }
        }
    }

    public int getFrame(int actionID, int frameID) {
        if (actionID < 0 || actionID >= this.m_nFrames.length) {
            return -1;
        }
        if (frameID < 0 || frameID >= this.m_nFrames[actionID]) {
            return -1;
        }
        return this.m_actions[actionID][frameID << 1] & 0xFF;
    }

    public int[] getFrameX(int frameIndex) {
        int[] temp = new int[2];
        byte[] s = this.m_frames[frameIndex];
        int minX = 0;
        int maxX = 0;
        for (int i = 0; i < s.length; i += 4) {
            int modID = (s[i] & 0xFF) << 2;
            int flag = s[i + 1] & 0xFF;
            short modX = this.m_modules[modID];
            short modY = this.m_modules[modID + 1];
            short modW = this.m_modules[modID + 2];
            short modH = this.m_modules[modID + 3];
            int posX = Math.abs(s[i + 2]);
            if (i == 0) {
                minX = posX;
                maxX = posX + modW;
                continue;
            }
            if (minX > posX) {
                minX = posX;
            }
            if (maxX >= posX + modW) continue;
            maxX = posX + modW;
        }
        temp[0] = minX;
        temp[1] = maxX;
        return temp;
    }

    public void draw(Graphics g, int screenX, int screenY, boolean flipX, boolean flipY, int frameIndex) {
        byte[] s = this.m_frames[frameIndex];
        int dgflag = 0;
        for (int i = 0; i < s.length; i += 4) {
            int modID = (s[i] & 0xFF) << 2;
            int flag = s[i + 1] & 0xFF;
            short modX = this.m_modules[modID];
            short modY = this.m_modules[modID + 1];
            short modW = this.m_modules[modID + 2];
            short modH = this.m_modules[modID + 3];
            boolean flipXs = flipX ^ (flag & 1) != 0;
            boolean flipYs = flipY ^ (flag & 2) != 0;
            int posX = screenX;
            int posY = screenY;
            posX = flipX ? (posX -= s[i + 2]) : (posX += s[i + 2]);
            posY = flipY ? (posY -= s[i + 3]) : (posY += s[i + 3]);
            short s2 = flipYs ? modH : (short)0;
            dgflag = Animation.trans(flipXs, flipYs);
            if ((posY -= s2) > 208 || posY + modH < 0 || (posX -= flipXs ? modW : (short)0) > 176 || posX + modW < 0) continue;
            this.drawRegion_Nokia(g, this.m_imageID, 0, modX, modY, modW, modH, dgflag, posX, posY);
        }
    }

    static int trans(boolean flipX, boolean flipY) {
        if (!flipX && !flipY) {
            return 0;
        }
        if (flipX && !flipY) {
            return 2;
        }
        if (!flipX && flipY) {
            return 1;
        }
        return 3;
    }

    public void drawRegion_Nokia(Graphics g, int imageID, int palID, int sx, int sy, int sw, int sh, int flag, int dx, int dy) {
        if (g == null) {
            return;
        }
        int a = g.getClipX();
        int b = g.getClipY();
        int w = g.getClipWidth();
        int h = g.getClipHeight();
        g.setClip(dx, dy, sw, sh);
        int iw = 0;
        int ih = 0;
        DirectGraphics dg = GameScreen.dg;
        if (flag != 0) {
            iw = this.simaWidth;
            ih = this.simaHeight;
        }
        switch (flag) {
            case 0: {
                g.drawImage(this.s_images, dx - sx, dy - sy, 0);
                break;
            }
            case 2: {
                dg.drawImage(this.s_images, dx - (iw - sx - sw), dy - sy, 0, 8192);
                break;
            }
            case 1: {
                dg.drawImage(this.s_images, dx - sx, dy - (ih - sy - sh), 0, 16384);
                break;
            }
            case 3: {
                dg.drawImage(this.s_images, dx - (iw - sx - sw), dy - (ih - sy - sh), 0, 180);
            }
        }
        g.setClip(a, b, w, h);
    }
}

