/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.util;

public class LQMath {
    public static final int[] SinTable = new int[]{0, 175, 349, 523, 698, 872, 1045, 1219, 1392, 1564, 1736, 1908, 2079, 2250, 2419, 2588, 2756, 2924, 3090, 3256, 3420, 3584, 3746, 3907, 4067, 4226, 4384, 4540, 4695, 4848, 5000, 5150, 5299, 5446, 5592, 5736, 5878, 6018, 6157, 6293, 6428, 6561, 6691, 6820, 6947, 7071, 7193, 7314, 7431, 7547, 7660, 7771, 7880, 7986, 8090, 8192, 8290, 8387, 8480, 8572, 8660, 8746, 8829, 8910, 8988, 9063, 9135, 9205, 9272, 9336, 9397, 9455, 9511, 9563, 9613, 9659, 9703, 9744, 9781, 9816, 9848, 9877, 9903, 9925, 9945, 9962, 9976, 9986, 9994, 9998, 10000};

    public static int sin(int g) {
        int delta = 1;
        if (g < 0) {
            g *= -1;
            delta = -1;
        }
        if (g > 360) {
            g %= 360;
        }
        if (g <= 90) {
            return SinTable[g] * delta;
        }
        if (g > 90 && g <= 180) {
            return SinTable[90 - (g - 90)] * delta;
        }
        if (g > 180 && g <= 270) {
            return -SinTable[g - 180] * delta;
        }
        return -SinTable[360 - g] * delta;
    }

    public static int cos(int g) {
        if ((g = Math.abs(g)) >= 360) {
            g %= 360;
        }
        if (g <= 90) {
            return LQMath.sin(90 - g);
        }
        if (g > 90 && g <= 180) {
            return -LQMath.sin(g - 90);
        }
        if (g > 180 && g <= 270) {
            return LQMath.sin(270 - (g - 180));
        }
        return -LQMath.sin(360 - (g - 270));
    }

    public static int tan(int g) {
        return LQMath.sin(g) / LQMath.cos(g);
    }

    public static int arcsin(int n) {
        for (int i = 0; i < 360; ++i) {
            if (LQMath.sin(i) < n) continue;
            return i;
        }
        return 0;
    }
}

