/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Role {
    public static final byte ROLE_ID_MIKE = 0;
    public static final byte ROLE_ID_ENEMY = 8;
    public static final byte ROLE_ID_BOSS = 26;
    public static final byte ROLE_HERO = 0;
    public static final byte ROLE_NPC = 1;
    public static final byte ROLE_ENEMY = 2;
    public static final byte ROLE_BOX = 3;
    public static final byte ROLE_CONTAINER = 4;
    public static final byte ROLE_CAN_GET_GOODS = 5;
    public static final byte ROLE_GROUND_SWITCH = 6;
    public static final byte ROLE_WALL_SWITCH = 7;
    public static final byte ROLE_ELE_GROUND = 8;
    public static final byte ROLE_CAN_OPENED_DOOR = 9;
    public static final byte ROLE_GROUND = 10;
    public static final byte ROLE_HAVE_PLACED_GOODS = 11;
    public static final byte ROLE_GROUND_MOVE = 14;
    Hashtable hEvent = new Hashtable();
    Hashtable hRule = new Hashtable();
    public static final byte STATE_SLEEP = 0;
    public static final byte STATE_MOVE = 1;
    public static final byte STATE_APPOINTED_ACTION = 2;
    public static final byte STATE_STAND_WALL = 3;
    public static final byte STATE_KNOCK_WALL = 4;
    public static final byte STATE_READY_CHASE = 5;
    public static final byte STATE_CHASE = 6;
    public static final byte STATE_TARGET_LOST = 7;
    public static final byte STATE_DISAPPEAR = 8;
    public static final byte STATE_DISPLAY = 9;
    public static final byte STATE_BLASTING = 10;
    public static final byte STATE_SET_BOM = 11;
    public static final byte STATE_ATTACK = 12;
    public static final byte STATE_FAIL = 13;
    private byte startTx;
    private byte startTy;
    private byte wayStandWall;
    public static final byte STATE_ITEM = 10;
    public byte roleId;
    public byte rtx;
    public byte rty;
    public int rfx;
    public int rfy;
    public byte drawX;
    public byte drawY;
    public byte platHeight;
    public byte state;
    public byte step = 0;
    public boolean stop = true;
    public byte way = 0;
    public Map map;
    public GameScreen gs;
    public Vector vPathEnemy;
    public Vector vPath;
    public boolean isFocus;
    public byte npcID;
    public Actor actor;
    public Actor actTip;
    public boolean isDisable;
    public byte roleType;
    public boolean isBack;
    public boolean focusMap;
    public byte powerState;
    public static final byte POWER_OFF = 0;
    public static final byte POWER_DOWN = 1;
    public static final byte POWER_ON = 2;
    public static final byte POWER_UP = 3;
    public static final byte POWER_TRUE = 4;
    public static final byte POWER_FALSE = 5;
    public static final byte ENEMY_STOP = 0;
    public static final byte ENEMY_LINE = 1;
    public static final byte ENEMY_ROUND = 2;
    public static final byte ENEMY_SLEEP = 3;
    byte goodsID = (byte)-1;
    byte effectArea;
    public boolean isReAction;
    int powerGroundSpace;
    byte doorBlockX;
    byte doorBlockY;
    public byte goodsType;
    public byte autoActionID;
    public boolean isClimb;
    public boolean isPush;
    public boolean isPower;
    public boolean isRePower;
    public boolean isBlock;
    public boolean isPressTrig;
    public boolean isLockedScreen;
    public boolean isHandTrig;
    public boolean isBom;
    public boolean isDestroy;
    public byte bBomNums;
    public byte bKeyNums;
    public boolean isInGrass;
    public boolean isPainted;
    boolean isStandWall;
    public boolean isLocked;
    private boolean isBomCall;
    private byte tipState;
    private byte tip;
    public static final byte TIP_NONE = 10;
    public static final byte TIP_SURPRISE = 0;
    public static final byte TIP_ACTIVE = 1;
    public static final byte TIP_ASK = 2;
    public static final byte TIP_PUZE = 3;
    public boolean isDead;
    public boolean isHide;
    public byte rowS;
    public byte colS;
    public byte maxStep;
    private byte statePre;
    private byte timer;
    private boolean isLost;
    private short pathIndex;
    public boolean pathAdd;
    public static final byte ENEMY_STATE_STOP = 0;
    public static final byte ENEMY_STATE_MOVE_LINE = 1;
    public static final byte ENEMY_MOVE_AROUND = 2;
    public static final byte ENEMY_STATE_SLEEP = 3;
    public static final byte ENEMY_STATE_AUTOROTE = 4;
    private byte enemyState;
    private byte wayOrigi;
    private byte wayIndex;
    private byte wayTimer;
    private boolean isSearchHero;
    private byte searchTimer;
    private boolean isMoveBom;
    boolean isBoxStop;
    int roleX;
    int roleY;
    boolean isPushBoxDown;
    boolean isBox;
    public boolean isMovePause;
    private byte moveTimer;
    public Role roleSupBuild;
    public boolean isChangeGameState;
    public boolean isItemGoods;
    public byte itemGoodsType;
    public byte itemLiveNums;
    public byte[] nextMoveSite;
    public static final byte[] STEP_OFF_X = new byte[]{1, -1, 1, -1};
    public static final byte[] STEP_OFF_Y = new byte[]{1, -1, -1, 1};
    public static final byte[] SX_OFF = new byte[]{-1, 1, -1, 1};
    public static final byte[] SY_OFF = new byte[]{-1, 1, 1, -1};
    private byte jumpSpace;
    private byte jumpState;
    public static final byte JUMP_UP = 2;
    public static final byte JUMP_DOWN = 1;
    public static final byte JUMP_NONE = 0;
    private Role roleActive;
    boolean isFail;
    public byte findTx;
    public byte findTy;
    public boolean isFindPre;
    public byte findTimer;
    public boolean isNpc;
    public boolean isUniteBuild;
    public byte uniteNpcId;
    private byte moveState;
    public static final byte MOVE_NORMAL = 0;
    public static final byte MOVE_UP = 1;
    public static final byte MOVE_DOWN = 3;
    public static final byte MOVE_PUSH_BOX = 2;
    public static final byte MOVE_STONE = 4;
    public static final byte MOVE_TO_STONE = 5;
    public static final byte MOVE_UP_BOX = 6;
    public static final byte MOVE_DOWN_BOX = 7;
    public static final byte MOVE_AUTO = 8;
    public static final byte MOVE_STAND_WALL = 9;
    public static final byte MOVE_LEAVE_STONE = 10;
    private boolean isStandBox;
    Role roleBox;
    private short sx;
    private short sy;
    private short px;
    private short py;
    public Role roleStand;
    public boolean isStandRole;
    public boolean isStandStone;
    public boolean isReadyStandRole;
    private Role roleStone;
    private static final byte[] MOVE_WAY = new byte[]{1, 3, 3, 1};
    private static final byte[] JUMP_WAY = new byte[]{2, 1, 1, 2};
    private Role roleAttackObj;
    private byte chaseTime;
    private byte pathIndexPre;
    private boolean isChaseed;
    public boolean isMoved;
    private byte firstState;
    private byte firstWay;
    private byte firstStep;
    private int sfx;
    private int sfy;
    private boolean isMove;
    private byte preWay;
    byte[] rotaWay;
    byte[] rotaSleep;
    public static byte CASE_TRIG = 0;
    public static byte CASE_ACTIVE = 1;
    public static byte CASE_DESTROY = (byte)2;
    private static byte[] CASE_ID = new byte[]{CASE_TRIG, CASE_ACTIVE, CASE_DESTROY};
    static final byte[][] x = new byte[][]{{-1, 0, 1, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2}, {-1, 0, 1, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2}, {-1, -1, -1, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3}, {1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3}};
    static final byte[][] y = new byte[][]{{-1, -1, -1, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3}, {1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3}, {-1, 0, 1, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2}, {-1, 0, 1, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2}};
    static final byte[][] bitNums = new byte[][]{{0, 3, 4, 8}, {0, 4, 9}, {1, 5, 10}, {2, 6, 11}, {2, 6, 7, 12}};
    public byte bombState;
    public static final byte UNUSED = 0;
    public static final byte BE_PLACED = 1;
    public static final byte BLASTING = 2;

    public Role() {
    }

    public Role(Map map, byte id, byte roleID) {
        this.rowS = (byte)4;
        this.colS = (byte)2;
        this.maxStep = (byte)(map.tileHeight / this.rowS - 1);
        this.nextMoveSite = new byte[2];
        this.map = map;
        this.gs = map.gs;
        this.npcID = (byte)(id + 1);
        this.roleId = roleID;
        this.setState((byte)0);
        this.isHide = false;
        this.tipState = (byte)10;
    }

    public void setBlock(boolean block) {
        this.powerState = (byte)(block ? 2 : 0);
        this.uniteBuild(block);
        this.map.setBlock(this.rtx, this.rty, block);
    }

    public void draw(Graphics g) {
        this.draw(g, 0, 0, (short)0);
    }

    public void draw(Graphics g, int offX, int offY, short offH) {
        this.isPainted = true;
        if (this.isHide) {
            return;
        }
        int x = this.rfx + this.map.cameraX + offX;
        int y = this.rfy + this.map.cameraY + offY;
        int n = y = this.roleType != 7 ? y - offH : y;
        if (this.roleType == 1) {
            y += offH;
        }
        block0 : switch (this.state) {
            case 9: {
                if (this.timer % 2 == 0) {
                    this.drawPowerRole(g, x, y);
                }
                byte by = this.timer;
                this.timer = (byte)(by + 1);
                if (by < 10) break;
                this.isLocked = false;
                this.setState((byte)0);
                break;
            }
            case 8: {
                break;
            }
            case 12: {
                if (this.roleType == 0) {
                    this.actor.changeAction(36 + this.way);
                } else {
                    this.actor.changeAction(8 + this.way);
                }
                if (this.actor.draw(g, x, y)) {
                    if (this.roleType == 0) {
                        this.isLocked = false;
                    }
                    if (this.roleType == 2) {
                        this.destroy();
                    }
                    this.stop();
                }
                return;
            }
            case 13: {
                if (this.statePre == 3 || this.isStandWall || this.moveState == 9) {
                    this.isStandWall = true;
                    this.actor.changeAction(40 + this.wayStandWall);
                } else {
                    this.actor.changeAction(40 + this.way);
                }
                if (this.actor.draw(g, x, y)) {
                    this.gs.gameOver();
                    this.isFail = false;
                }
                return;
            }
            case 10: {
                switch (this.roleType) {
                    case 2: {
                        this.actor.changeAction(12);
                        if (!this.actor.draw(g, x, y)) break block0;
                        this.isLocked = false;
                        this.destroy();
                        this.checkBottomRole();
                        this.checkEvent(this, CASE_DESTROY);
                        break;
                    }
                    case 0: {
                        this.actor.changeAction(44);
                        if (!this.actor.draw(g, x, y)) break block0;
                        this.gs.gameOver();
                        break;
                    }
                    default: {
                        this.actor.changeAction(3);
                        if (!this.actor.draw(g, x, y)) break block0;
                        this.isLocked = false;
                        this.destroy();
                        this.checkBottomRole();
                        if (this.roleType == 3 && this.isUniteBuild) {
                            this.map.setBlock(this.rtx, this.rty, true);
                        }
                        if (!this.isBom) break block0;
                        this.detonate();
                        break;
                    }
                }
                break;
            }
            default: {
                switch (this.roleType) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.drawRole(g, x, y);
                        this.isStandWall = false;
                        break block0;
                    }
                }
                this.drawPowerRole(g, x, y);
            }
        }
    }

    public void drawPowerRole(Graphics g, int x, int y) {
        if (g != null && this.roleType == 5) {
            g.drawImage(GameScreen.imaShadow, x - 11, y - 6, 0);
        }
        this.actor.changeAction(this.powerState);
        boolean flag = this.actor.draw(g, x, y);
        if ((this.powerState == 1 || this.powerState == 3) && this.roleType == 3) {
            this.gs.isBoxDown = true;
        }
        switch (this.powerState) {
            case 1: {
                if (flag) {
                    this.powerState = (byte)2;
                    this.isLocked = false;
                    this.setPowerState(this.powerState);
                    if (this.roleType == 14) {
                        this.setEnemyState((byte)1, true);
                    }
                    if (this.roleType == 3) {
                        this.uniteBuild(false);
                    }
                    this.gs.isBoxDown = false;
                }
                this.platHeight = (byte)(this.platHeight - 4);
                break;
            }
            case 3: {
                if (!flag) break;
                this.powerState = 0;
                this.isLocked = false;
                this.setPowerState(this.powerState);
                this.gs.isBoxDown = false;
            }
        }
    }

    public void powerSwitch() {
        this.actor.setLoop(1);
        switch (this.powerState) {
            case 0: {
                if (this.roleType == 8) {
                    this.isDisable = true;
                }
                this.powerState = 1;
                break;
            }
            case 2: {
                this.isDisable = false;
                this.powerState = (byte)3;
            }
        }
    }

    public void setWay(byte way) {
        this.preWay = way;
        this.way = way;
    }

    public void drawRole(Graphics g, int x, int y) {
        this.sx = (short)x;
        this.sy = (short)y;
        if (g != null && (this.roleType != 1 || this.roleId == 20 || this.roleId == 21)) {
            g.drawImage(GameScreen.imaShadow, x - 11, y - 6, 0);
        }
        switch (this.state) {
            case 0: 
            case 5: 
            case 7: {
                this.actor.changeAction(this.way);
                if (this.roleType != 2 || this.enemyState != 4) break;
                if (this.wayTimer >= this.rotaSleep[this.wayIndex]) {
                    this.wayIndex = (byte)(this.wayIndex + 1);
                    if (this.wayIndex >= this.rotaSleep.length - 1 || this.rotaWay[this.wayIndex] < 0 || this.rotaWay[this.wayIndex] > 3) {
                        this.wayIndex = 0;
                    }
                    this.wayTimer = 0;
                }
                this.setWay(this.rotaWay[this.wayIndex]);
                this.wayTimer = (byte)(this.wayTimer + 1);
                break;
            }
            case 1: {
                this.drawWalk(g, x, y, this.way);
                break;
            }
            case 3: {
                this.actor.changeAction(20 + this.wayStandWall);
                break;
            }
            case 4: {
                this.actor.changeAction(28 + this.wayStandWall);
                if (this.actor.draw(g, x, y)) {
                    this.setState((byte)3);
                    this.callEnemy(this.rtx, this.rty, 5, false);
                }
                return;
            }
            case 11: {
                this.actor.changeAction(32 + this.way);
                if (this.actor.draw(g, x, y)) {
                    this.setState((byte)0);
                    this.map.bomC4.keyPress();
                }
                return;
            }
            case 2: {
                if (this.actor.draw(g, x, y)) {
                    this.isLocked = false;
                    this.setState((byte)0);
                }
                return;
            }
        }
        boolean tmp = false;
        tmp = this.actor.draw(g, x, y);
        if (this.roleType == 0 && this.state == 3 && tmp) {
            this.isLocked = false;
        }
        if (this.state == 1 && (this.moveState == 7 || this.moveState == 6) && this.isFail && tmp) {
            this.setState((byte)13);
        }
        if (this.roleType != 0) {
            this.drawTip(g, x, y);
        }
    }

    public void callEnemy(int tx, int ty, int regin, boolean callType) {
        Vector v = this.map.vEnemys;
        for (int i = 0; i < v.size(); ++i) {
            Role role = (Role)v.elementAt(i);
            if (role.isChaseed || role.state == 10 || !this.isInArea(role.rtx, role.rty, tx, ty, regin)) continue;
            role.isBomCall = callType;
            role.startChase((byte)tx, (byte)ty);
        }
    }

    public boolean isInArea(int ax, int ay, int bx, int by, int area) {
        return Math.abs(ax - bx) <= area && Math.abs(ay - by) <= area;
    }

    private void drawTip(Graphics g, int x, int y) {
        if (this.tipState == 10 || this.actTip == null) {
            return;
        }
        this.actTip.changeAction(this.tipState * 2 + this.tip);
        if (this.tip == 0) {
            if (!this.map.isDanger) {
                this.tip = this.actTip.draw(g, x, y) ? (byte)1 : 0;
            } else {
                this.actTip.draw(g, x, y);
            }
        } else {
            this.actTip.draw(g, x, y);
        }
    }

    public void tip(byte tipState) {
        this.tip = 0;
        this.tipState = tipState;
        this.timer = 0;
    }

    public void appointedAction(int actionID) {
        this.actor.changeAction(actionID);
        this.setState((byte)2);
    }

    public void hiden() {
        this.isHide = true;
        if (this.roleType == 0) {
            return;
        }
        if (this.isUniteBuild) {
            this.map.buildData[this.rty][this.rtx] = -128;
        } else {
            this.map.roleData[this.rty][this.rtx] = -128;
        }
    }

    public void init(byte rtx, byte rty) {
        this.isHide = false;
        this.rtx = rtx;
        this.rty = rty;
        this.init(false);
        this.setSiteType(this.npcID);
    }

    public void dead() throws Exception {
    }

    public void destroy() {
        this.checkEvent(this, CASE_DESTROY);
        this.isDisable = true;
        if (this.roleType == 2) {
            this.map.vEnemys.removeElement(this);
        }
        Map.npcs.remove("" + this.npcID);
        this.hiden();
    }

    public void autoMove() {
        if (this.step == 0) {
            byte[] temp = (byte[])this.vPath.elementAt(this.pathIndex);
            this.way = Map.getWay(this.rtx, this.rty, temp[0], temp[1]);
            if (this.roleType == 2 && this.gs.getCurrentRole().rtx == temp[0] && this.gs.getCurrentRole().rty == temp[1]) {
                this.gs.getCurrentRole().setState((byte)13);
                return;
            }
            if (this.map.isBlock(temp[0], temp[1], true, true)) {
                return;
            }
            this.pathIndex = (short)(this.pathIndex - 1);
            this.nextMoveSite = temp;
        }
        this.move(this.way, this.step, this.maxStep, this.rowS, this.colS);
        if (this.step >= this.maxStep) {
            this.step = 0;
            if (this.pathIndex < 0) {
                this.isLocked = false;
                if (this.isBack) {
                    this.way = Map.getRotateWay(this.way);
                    this.isBack = false;
                }
                if (this.roleType == 2) {
                    this.endAutoMove();
                } else {
                    this.stop();
                }
            }
            if (this.roleType == 0) {
                this.activeObject();
            }
            this.checkBottomRole();
        } else {
            this.step = (byte)(this.step + 1);
        }
    }

    private void endAutoMove() {
        if (this.statePre == 7) {
            if (this.isLost) {
                this.stop();
            } else {
                this.setEnemyState(this.enemyState, false);
            }
            this.tip((byte)10);
        } else {
            this.lostTarget();
        }
    }

    private void lostTarget() {
        this.searchTimer = 0;
        this.tip((byte)2);
        this.setState((byte)7);
    }

    public void setState(byte state) {
        this.statePre = this.state;
        this.state = state;
        this.timer = 0;
        if (state == 4) {
            this.gs.soundRes.playMidi(4, 1);
        }
    }

    public void startMove(Vector path) {
        if (path == null) {
            this.stop();
            return;
        }
        this.init(false);
        this.roleActive = null;
        this.pathIndex = (short)(path.size() - 1);
        this.startMove((byte)8, null);
        this.vPath = path;
        this.stop = false;
        this.step = 0;
    }

    public void setEnemyState(byte enemyState, boolean reset) {
        this.searchTimer = 0;
        this.isSearchHero = false;
        this.isChaseed = false;
        this.chaseTime = 0;
        this.enemyState = enemyState;
        switch (enemyState) {
            case 4: {
                this.stop();
                if (reset) break;
                this.setWay(this.firstWay);
                break;
            }
            case 0: {
                this.stop();
                if (reset) break;
                this.setWay(this.wayOrigi);
                break;
            }
            case 1: 
            case 2: {
                if (reset) {
                    this.pathAdd = true;
                    this.pathIndex = 1;
                } else {
                    this.pathIndex = this.pathIndexPre;
                    this.step = this.firstStep;
                    this.setWay(this.firstWay);
                    this.rfx = this.sfx;
                    this.rfy = this.sfy;
                }
                this.startMove((byte)0, null);
                break;
            }
            case 3: {
                if (reset) break;
                this.setWay(this.wayOrigi);
            }
        }
    }

    private void drawWalk(Graphics g, int x, int y, byte way) {
        if (this.isBack) {
            way = Map.getRotateWay(way);
        }
        switch (this.moveState) {
            case 0: 
            case 5: 
            case 8: 
            case 10: {
                this.actor.changeAction(way + 4);
                break;
            }
            case 2: {
                this.actor.changeAction(way + 8);
                break;
            }
            case 1: 
            case 6: {
                x = this.px;
                y = this.py;
                this.actor.changeAction(way + 12);
                break;
            }
            case 3: 
            case 7: {
                x = this.px;
                y = this.py;
                this.actor.changeAction(way + 16);
                break;
            }
            case 9: {
                this.actor.changeAction(this.wayStandWall + 24);
            }
        }
    }

    private void boxMove() {
        boolean bl = this.isMoveBom = this.map.bomC4.rtx == this.rtx && this.map.bomC4.rty == this.rty;
        if (this.stop && this.step == 0) {
            this.setState((byte)0);
            return;
        }
        if (this.step == 0) {
            if (this.way == 0) {
                this.roleX = this.rtx - 1;
                this.roleY = this.rty - 1;
            } else if (this.way == 1) {
                this.roleX = this.rtx - 1;
                this.roleY = this.rty;
                this.isPushBoxDown = true;
            }
            this.isBox = true;
            byte[] nTile = this.map.getNextTile(this.rtx, this.rty, this.way);
            if (nTile == null || this.map.isBoxBlock(nTile[0], nTile[1])) {
                this.stop();
                this.isBoxStop = true;
                if (this.gs.currentRole.moveState == 2) {
                    this.gs.currentRole.stop();
                }
                return;
            }
            this.nextMoveSite = nTile;
            this.isBoxStop = false;
        }
        this.colS = 1;
        this.rowS = (byte)2;
        this.maxStep = (byte)(this.map.tileHeight / this.rowS - 1);
        this.move(this.way, this.colS, this.rowS);
        if (!this.map.bomC4.isHide && this.isMoveBom) {
            this.map.bomC4.setPixSit(this.rtx, this.rty, this.rfx, this.rfy);
        }
        if (this.step == 0 && this.map.isHoleBox(this.rtx, this.rty)) {
            this.stop();
            this.gs.getCurrentRole().stop();
            this.powerSwitch();
        }
        this.isMoveBom = false;
    }

    private void move(byte way, byte cols, byte rows) {
        this.move(way, this.step, this.maxStep, rows, cols);
        if (this.step >= this.maxStep) {
            this.checkBottomRole();
            this.step = 0;
        } else {
            this.step = (byte)(this.step + 1);
        }
    }

    public byte[] getNextTile() {
        byte[] nTile = this.map.getNextTile(this.rtx, this.rty, this.way);
        return nTile;
    }

    public Role getNextRole() {
        byte[] nTile = this.map.getNextTile(this.rtx, this.rty, this.way);
        if (nTile != null) {
            return this.map.getRoleObject(nTile[0], nTile[1]);
        }
        return null;
    }

    private void pushBox() {
        if (this.stop && this.step == 0) {
            this.setState((byte)0);
            return;
        }
        if (this.step == 0) {
            byte[] nTile = this.roleBox.getNextTile();
            if (this.way == 1) {
                if (this.roleBox.isBoxStop) {
                    this.stop();
                    this.roleBox.stop();
                    return;
                }
            } else if (nTile == null || this.map.isBoxBlock(nTile[0], nTile[1])) {
                this.stop();
                this.roleBox.stop();
                return;
            }
            nTile = this.map.getNextTile(this.rtx, this.rty, this.way);
            this.nextMoveSite = nTile;
        }
        this.colS = 1;
        this.rowS = (byte)2;
        if (this.step == 0) {
            if (this.way == 1 && this.roleBox != null) {
                byte[] boxTile;
                if (!this.roleBox.isPushBoxDown && ((boxTile = this.roleBox.map.getNextTile(this.roleBox.rtx, this.roleBox.rty, this.roleBox.way)) == null || this.roleBox.map.isBoxBlock(boxTile[0], boxTile[1]))) {
                    return;
                }
                this.roleBox.isPushBoxDown = false;
                this.roleBox.isBox = false;
            }
        }
        this.maxStep = (byte)(this.map.tileHeight / this.rowS - 1);
        this.move(this.way, this.colS, this.rowS);
    }

    private void enemyMove() {
        if (this.roleType == 14) {
            boolean bl = this.isMoveBom = this.map.bomC4.rtx == this.rtx && this.map.bomC4.rty == this.rty;
            if (this.isMovePause) {
                byte by = this.moveTimer;
                this.moveTimer = (byte)(by + 1);
                if (by >= 12 && !this.isReadyStandRole) {
                    this.moveTimer = 0;
                    this.isMovePause = false;
                }
                return;
            }
        }
        if (this.isFindPre) {
            return;
        }
        if (this.step == this.maxStep / 2) {
            byte[] temp = (byte[])this.vPathEnemy.elementAt(this.pathIndex);
            this.way = Map.getWay(this.rtx, this.rty, temp[0], temp[1]);
            if (this.roleType == 2 && this.map.isBlock(temp[0], temp[1], true, true)) {
                return;
            }
            this.pathIndex = this.pathAdd ? (short)(this.pathIndex + 1) : (short)(this.pathIndex - 1);
            this.nextMoveSite = temp;
        }
        byte rowS = 2;
        byte colS = 1;
        byte maxStep = 7;
        if (this.isStandRole) {
            this.roleStand.move(this.way, this.step, maxStep, rowS, colS);
        }
        this.move(this.way, this.step, maxStep, rowS, colS);
        if (this.roleType == 14 && !this.map.bomC4.isHide && this.isMoveBom) {
            this.map.bomC4.setPixSit(this.rtx, this.rty, this.rfx, this.rfy);
        }
        if (this.step >= maxStep) {
            int size = this.vPathEnemy.size();
            if (this.enemyState == 2) {
                if (this.pathIndex >= size) {
                    this.pathIndex = 0;
                }
            } else if (this.pathIndex < 0) {
                this.pathIndex = 1;
                this.pathAdd = true;
                if (this.roleType == 14) {
                    this.isMovePause = true;
                }
            } else if (this.pathIndex >= size) {
                this.pathIndex = (byte)(size - 2);
                this.pathAdd = false;
                if (this.roleType == 14) {
                    this.isMovePause = true;
                }
            }
            this.step = 0;
        } else {
            this.step = (byte)(this.step + 1);
        }
    }

    private void move() {
        if (this.stop && this.step == 0) {
            if (this.moveState == 9) {
                this.setState((byte)3);
            } else {
                this.setState((byte)0);
            }
            return;
        }
        if (this.step == 0) {
            if (this.preWay != this.way) {
                this.setWay(this.way);
                return;
            }
            byte[] nTile = this.map.getNextTile(this.rtx, this.rty, this.way);
            byte[] wTile = this.map.getWallTile(this.rtx, this.rty, this.way);
            if (nTile == null) {
                this.stop();
                return;
            }
            switch (this.moveState) {
                case 0: {
                    Role role;
                    if (this.map.isBlock(nTile[0], nTile[1], true, true)) {
                        Role role2;
                        boolean isBox = false;
                        if (nTile != null) {
                            role2 = this.map.getRoleObject(nTile[0], nTile[1]);
                            if (this.isStandBox) {
                                if (role2 != null && role2.isClimb) {
                                    isBox = true;
                                }
                            } else if (role2 != null && role2.roleType == 2 && role2.way == Map.getRotateWay(this.way)) {
                                this.setState((byte)13);
                            }
                            if (wTile != null && wTile[2] < 1) {
                                role2 = this.map.getRoleObject(wTile[0], wTile[1]);
                                if (role2 != null && role2.isClimb) {
                                    this.isStandBox = true;
                                    this.jump(JUMP_WAY[this.way], (byte)16);
                                    isBox = true;
                                    nTile = wTile;
                                } else if (role2 == null && this.isStandBox) {
                                    this.isStandBox = false;
                                    this.jump(JUMP_WAY[this.way], (byte)16);
                                    isBox = true;
                                    nTile = wTile;
                                }
                            }
                        }
                        if (!isBox) {
                            role2 = this.map.getRoleObject(nTile[0], nTile[1]);
                            this.stop();
                            if (!(role2 == null || this.isMove || !this.map.isWall(nTile[0], nTile[1]) || this.map.roleData[nTile[1]][nTile[0]] != -128 && role2.roleId != 29 && role2.roleId != 30 || this.isStandBox)) {
                                this.setState((byte)3);
                                this.wayStandWall = Map.getRotateWay(this.way);
                                return;
                            }
                            if (!this.isMove && this.map.isWall(nTile[0], nTile[1]) && this.map.roleData[nTile[1]][nTile[0]] == -128 && !this.isStandBox) {
                                this.setState((byte)3);
                                this.wayStandWall = Map.getRotateWay(this.way);
                            }
                            return;
                        }
                    } else if (this.isStandBox && ((role = this.map.getRoleObject(nTile[0], nTile[1])) == null || !role.isClimb)) {
                        this.stop();
                        return;
                    }
                    this.nextMoveSite = nTile;
                    break;
                }
                case 9: {
                    Role role;
                    boolean isStop = false;
                    byte[] bTile = this.map.getNextTile(nTile[0], nTile[1], Map.getRotateWay(this.wayStandWall));
                    boolean block = this.map.isBlockSandWall(nTile[0], nTile[1]);
                    isStop = bTile != null ? ((role = this.map.getRoleObject(bTile[0], bTile[1])) != null ? (!this.map.isWall(bTile[0], bTile[1]) ? true : (this.map.roleData[bTile[1]][bTile[0]] != -128 && role.roleId != 29 && role.roleId != 30 ? true : this.map.isBlockRole(this.map.getRoleObject(nTile[0], nTile[1])))) : (!this.map.isWall(bTile[0], bTile[1]) ? true : (this.map.roleData[bTile[1]][bTile[0]] != -128 ? true : this.map.isBlockRole(this.map.getRoleObject(nTile[0], nTile[1]))))) : true;
                    if (!isStop) {
                        isStop = block;
                    }
                    if (isStop) {
                        this.stopStand();
                        return;
                    }
                    this.nextMoveSite = nTile;
                    break;
                }
                case 6: 
                case 7: {
                    this.nextMoveSite = nTile;
                }
            }
            this.isMove = true;
        }
        this.moveRole();
        this.checkItemGoods();
    }

    public void stopStand() {
        this.stop();
        this.setState((byte)3);
    }

    public void stop() {
        this.chaseTime = 0;
        this.stop = true;
        this.setState((byte)0);
        this.step = 0;
        this.isChaseed = false;
    }

    private void moveRole() {
        this.isMoved = true;
        this.move(this.way, this.step, this.maxStep, this.rowS, this.colS);
        if (this.step >= this.maxStep) {
            if (this.roleType == 0) {
                if (this.stop) {
                    this.setState(this.moveState == 9 ? (byte)3 : 0);
                    this.focus();
                }
                this.checkBottomRole();
                this.activeObject();
                this.checkEvent(this.roleActive, CASE_ACTIVE);
            }
            this.step = 0;
        } else {
            this.step = (byte)(this.step + 1);
        }
    }

    public boolean checkBottomRole() {
        Role role;
        if (this.roleType == 0 && this.isStandBox) {
            return false;
        }
        if (this.roleSupBuild != null && this.roleSupBuild.isPressTrig) {
            this.roleSupBuild.setPowerState((byte)0);
            this.checkEvent(this.roleSupBuild, CASE_TRIG);
            this.roleSupBuild = null;
            if (this.state == 10) {
                return true;
            }
        }
        if ((role = this.map.getRoleBuild(this.rtx, this.rty)) == null) {
            role = this.map.getRoleObject(this.rtx, this.rty);
        }
        this.roleSupBuild = role;
        if (role != null && role.isPressTrig) {
            role.setPowerState((byte)2);
        } else if (role != null && !role.isDisable && role.roleType == 8 && role.powerState == 0 && this.roleType != 3) {
            if (this.roleType == 2) {
                this.gs.getCurrentRole().leaveSearch();
            }
            this.setState((byte)10);
            return true;
        }
        return this.checkEvent(role, CASE_TRIG);
    }

    public boolean checkEvent(Role role, byte eventId) {
        if (role != null && !role.isDisable && role.checkRule(eventId) && role.runBat(eventId)) {
            this.stop();
            if (this.roleType == 3) {
                this.gs.getCurrentRole().stop();
            }
            return true;
        }
        return false;
    }

    public boolean runBat(byte eventId) {
        Vector v = (Vector)this.hEvent.get("" + eventId);
        if (v != null && v.size() > 0) {
            if (this.isPressTrig && !this.isLockedScreen) {
                this.gs.autoAction.startForce(v);
                return false;
            }
            this.gs.startBat(v);
            return true;
        }
        return false;
    }

    public boolean checkRule(byte eventId) {
        Vector v = (Vector)this.hRule.get("" + eventId);
        if (v == null || v.size() <= 0) {
            return true;
        }
        return this.gs.autoAction.isSatisfy(v);
    }

    public void checkItemGoods() {
    }

    private void jump() {
        switch (this.jumpState) {
            case 1: {
                this.rfy += this.jumpSpace;
                break;
            }
            case 2: {
                this.rfy -= this.jumpSpace;
            }
        }
        this.jumpState = 0;
    }

    public void jump(byte jumpWay, byte jumpHeight) {
        this.jumpState = jumpWay;
        this.jumpSpace = jumpHeight;
    }

    public void move(byte way, byte currentStep, byte MaxStep, byte rows, byte cols) {
        switch (this.moveState) {
            case 0: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                if (this.isFocus) {
                    this.map.cameraY += STEP_OFF_Y[way] * cols;
                    this.map.cameraX += STEP_OFF_X[way] * rows;
                }
                this.rfy += SY_OFF[way] * cols;
                this.rfx += SX_OFF[way] * rows;
                break;
            }
            default: {
                this.stop = true;
            }
        }
        byte endStep = (byte)(MaxStep / 2);
        if (this.roleType == 3) {
            if (this.way == 0) {
                endStep = (byte)(this.maxStep - 1);
            } else if (this.way == 1) {
                endStep = 0;
            }
        }
        if (this.roleType == 0) {
            if (this.moveState == 9) {
                if (this.way == 0) {
                    endStep = MaxStep;
                } else if (this.way == 1) {
                    endStep = 0;
                }
            } else if (this.moveState == 2 && this.way == 0) {
                endStep = (byte)(this.maxStep - 1);
            }
        }
        if (currentStep == endStep) {
            this.jump();
            this.endMove();
        }
    }

    public void activeObject() {
        block3: for (int i = 0; i < 4; ++i) {
            byte[] nTile = this.map.getNextTile(this.rtx, this.rty, (byte)i);
            if (nTile == null) continue;
            Role role = this.map.getRoleObject(nTile[0], nTile[1]);
            if (role == null) {
                role = this.map.getRoleBuild(nTile[0], nTile[1]);
            }
            switch (i) {
                case 1: 
                case 2: {
                    if (role != null && role.roleType == 7) continue block3;
                }
                default: {
                    if (role != null && !role.isDisable && role.roleType != 9 && role.roleType != 8) {
                        this.roleActive = role;
                        this.tip((byte)1);
                        break block3;
                    }
                    this.roleActive = null;
                    this.tip((byte)10);
                }
            }
        }
    }

    public void run() {
        if (!this.isPainted) {
            this.draw(null);
        }
        this.isPainted = false;
        block0 : switch (this.state) {
            case 1: {
                this.rowS = (byte)4;
                this.colS = (byte)2;
                this.maxStep = (byte)(this.map.tileHeight / this.rowS - 1);
                if (this.moveState == 8) {
                    this.autoMove();
                    break;
                }
                switch (this.roleType) {
                    case 1: 
                    case 2: 
                    case 14: {
                        this.enemyMove();
                        break block0;
                    }
                    case 3: {
                        this.boxMove();
                        break block0;
                    }
                }
                switch (this.moveState) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 9: {
                        if (this.moveState == 9) {
                            this.colS = 1;
                            this.rowS = (byte)2;
                            this.maxStep = (byte)(this.map.tileHeight / this.rowS - 1);
                        }
                        this.move();
                        break;
                    }
                    case 2: {
                        this.pushBox();
                        break;
                    }
                    case 10: {
                        this.moveRole();
                        if (this.step != 0) break;
                        this.stop();
                        break;
                    }
                    case 5: {
                        this.moveRole();
                        if (this.step != 0) break;
                        this.roleStone.isStandRole = true;
                        this.roleStone.roleStand = this;
                        this.roleStone.isReadyStandRole = false;
                        this.isStandStone = true;
                        this.stop();
                        this.moveState = (byte)4;
                    }
                }
                break;
            }
            case 5: {
                if (this.tip != 1) break;
                if (this.vPath != null && (this.isBomCall || !this.gs.getCurrentRole().isInGrass)) {
                    this.isChaseed = true;
                    this.startMove(this.vPath);
                } else {
                    this.lostTarget();
                }
                this.isBomCall = false;
                break;
            }
            case 7: {
                if (this.tip != 1) break;
                if (this.timer == 0) {
                    this.setWay(Map.getLeftWay(this.way, true));
                } else if (this.timer == 10) {
                    this.setWay(Map.getLeftWay(this.way, false));
                } else if (this.timer == 20) {
                    this.setWay(Map.getLeftWay(this.way, false));
                }
                byte by = this.timer;
                this.timer = (byte)(by + 1);
                if (by < 30) break;
                if (this.isChaseed) {
                    Vector v = this.map.getPath(this.rtx, this.rty, this.startTx, this.startTy);
                    if (v != null) {
                        this.startMove(v);
                        this.tip((byte)10);
                        break;
                    }
                    this.isLost = true;
                    this.stop();
                    break;
                }
                this.gs.getCurrentRole().leaveSearch();
                this.tip((byte)10);
                this.setWay(this.firstWay);
                this.setState(this.firstState);
            }
        }
        Role role = this.gs.getCurrentRole();
        if (role.isInGrass) {
            this.map.isDanger = false;
            this.findTimer = 0;
            this.isFindPre = false;
            if (this.isSearchHero && !this.isChaseed) {
                this.tip((byte)10);
            }
            return;
        }
        if (this.roleType == 2 && this.state != 10 && role.state != 13) {
            boolean find = false;
            if (this.isInArea(role.rtx, role.rty, this.rtx, this.rty, 3) && this.state != 10) {
                find = this.search(role.rtx, role.rty);
            }
            if (!find) {
                if (this.isFindPre && role.isMoved) {
                    this.findTx = role.rtx;
                    this.findTy = role.rty;
                    this.startChase(this.findTx, this.findTy);
                }
                if (this.isFindPre && !role.isMoved && this.state != 5 && this.state != 7) {
                    this.tip((byte)10);
                }
                this.map.isDanger = false;
                this.findTimer = 0;
            } else {
                if (this.searchTimer <= 0) {
                    this.searchTimer = (byte)(this.searchTimer + 1);
                }
                this.isSearchHero = true;
                this.map.isDanger = true;
                this.tip((byte)0);
                this.findTimer = (byte)(this.findTimer + 1);
                if (this.findTimer >= 10) {
                    this.stop();
                    if (role.state != 10 && (role.state != 1 || role.moveState != 6 && role.moveState != 7)) {
                        role.setState((byte)13);
                    }
                    if (role.state == 1 && (role.moveState != 6 || role.moveState != 7)) {
                        role.isFail = true;
                    }
                }
            }
            this.isFindPre = find;
        }
    }

    public void leaveSearch() {
        this.findTimer = 0;
        this.map.isDanger = false;
    }

    public void setTileSite(byte[] site) {
        this.rtx = site[0];
        this.rty = site[1];
    }

    public void endMove() {
        if (this.isStandStone) {
            this.setTileSite(this.roleStone.nextMoveSite);
            return;
        }
        this.setSiteType((byte)-128);
        this.setTileSite(this.nextMoveSite);
        this.setSiteType(this.npcID);
        this.setWay(this.way);
        if (GameScreen.gameState != 4 && this.roleType == 0 && this.gs.gamePlan != 0 && this.gs.gameMode == 0) {
            this.gs.step = (short)(this.gs.step + 1);
        } else if (GameScreen.gameState != 4 && this.roleType == 0 && this.gs.gameMode == 1 && this.gs.deathModeGamePlan != 3 && this.gs.deathModeGamePlan != 7 && this.gs.deathModeGamePlan != 11 && this.gs.deathModeGamePlan != 16) {
            if (this.gs.maxStep > 0) {
                this.gs.maxStep = (short)(this.gs.maxStep - 1);
            }
            if (this.gs.maxStep <= 0) {
                this.gs.gameOver();
            }
        }
    }

    public void focus(boolean changeSite) {
        this.isFocus = true;
        this.map.focus(this.rtx, this.rty, false);
        if (changeSite) {
            this.map.roleData[this.rty][this.rtx] = this.npcID;
            this.countSite();
        }
    }

    public void loseFocus() {
        this.isFocus = false;
    }

    public void focus() {
        if (this.gs.getCurrentRole() != null) {
            this.gs.getCurrentRole().isFocus = false;
        }
        this.isFocus = true;
        this.map.focus(this.rtx, this.rty, false);
        this.countSite();
    }

    public void init(boolean flag) {
        if (flag) {
            this.setSiteType(this.npcID);
        }
        this.countSite();
    }

    public void countSite() {
        this.rfx = this.map.getTileXPixValue(this.rtx, this.rty) + this.map.tileWidth / 2;
        this.rfy = this.map.getTileYPixValue(this.rtx, this.rty) + this.map.tileHeight / 2;
    }

    public void setSiteType(byte type) {
        if (this.roleId != 0) {
            try {
                if (!this.isUniteBuild) {
                    this.map.roleData[this.rty][this.rtx] = type;
                } else {
                    this.map.buildData[this.rty][this.rtx] = -type;
                }
            }
            catch (Exception ex) {
                System.out.println("y" + this.rty + " x" + this.rtx + "  t" + type);
            }
        }
        this.isInGrass = this.map.buildData[this.rty][this.rtx] >= 0;
    }

    public void uniteBuild(boolean block) {
        int rid = this.map.roleData[this.rty][this.rtx];
        this.map.roleData[this.rty][this.rtx] = rid != this.npcID ? rid : -128;
        Map.npcs.put("" + this.npcID, this);
        this.map.buildData[this.rty][this.rtx] = -this.npcID;
        this.uniteNpcId = -this.npcID;
        this.isUniteBuild = true;
        this.map.setBlock(this.rtx, this.rty, block);
    }

    public void unUniteBuild() {
        this.map.buildData[this.rty][this.rtx] = -128;
        this.map.setBlock(this.rtx, this.rty, false);
        this.map.roleData[this.rty][this.rtx] = this.npcID;
        this.isUniteBuild = false;
    }

    public void keyPress(int keyCode, int key) {
        if (this.gs.isBoxDown) {
            return;
        }
        switch (this.state) {
            case 0: {
                if (key == 8) {
                    this.keyFire();
                    break;
                }
                if (keyCode == 48) {
                    this.keyBom();
                    break;
                }
                this.keyWalk(keyCode, key);
                break;
            }
            case 3: {
                if (key == 8) {
                    if (this.keyKillEnemy()) {
                        return;
                    }
                    this.isMoved = false;
                    this.setState((byte)4);
                    break;
                }
                if (keyCode == 48) {
                    this.keyBom();
                    break;
                }
                byte way = this.getGameWay(key);
                if (this.wayStandWall == this.getGameWay(key) && this.map.getGroundType(this.rtx, this.rty) == 0) {
                    this.stop();
                    this.setWay(this.wayStandWall);
                    break;
                }
                if (way == -1) break;
                if (Map.getFace(way, this.wayStandWall) != 1) break;
                this.setWay(way);
                this.startMove((byte)9, null);
            }
        }
    }

    private boolean keyKillEnemy() {
        this.roleAttackObj = this.getAroundEnemy();
        if (this.roleAttackObj != null && this.state != 12) {
            this.setState((byte)12);
            return true;
        }
        return false;
    }

    private void keyBom() {
        Role r = this.map.getRoleBuild(this.rtx, this.rty);
        if (r != null && r.roleId == 11) {
            return;
        }
        byte id = this.map.mapData[this.rty][this.rtx];
        if (id >= 12 && id <= 15 || id == 17 || id == 18) {
            return;
        }
        if (this.map.bomC4.isCanBom()) {
            this.map.bomC4.keyPress();
        } else if (this.bBomNums > 0 || this.bBomNums == 0 && this.map.bomC4.canPickup()) {
            if (!this.isInGrass) {
                this.setState((byte)11);
            }
        } else {
            this.gs.alert("You don't have a bomb !");
        }
    }

    private Role getAroundEnemy() {
        if (this.isStandBox) {
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            byte[] nTile = this.map.getNextTile(this.rtx, this.rty, (byte)i);
            Role role = null;
            if (nTile == null || (role = this.map.getRoleObject(nTile[0], nTile[1])) == null || role.roleType != 2 || role.state == 12) continue;
            this.leaveSearch();
            role.stop();
            role.setState((byte)12);
            this.setWay(Map.getWay(this.rtx, this.rty, role.rtx, role.rty));
            role.setWay(this.way);
            this.gs.soundRes.playMidi(2, 1);
            return role;
        }
        return null;
    }

    private void keyFire() {
        byte[] nTile;
        Role role;
        if (this.keyKillEnemy()) {
            return;
        }
        byte[] tile = this.map.getWallTile(this.rtx, this.rty, this.way);
        int gType = -128;
        byte[] nextTile = this.getNextTile();
        if (nextTile != null) {
            gType = this.map.getGroundType(nextTile[0], nextTile[1]);
        }
        if (gType != -128 && tile != null) {
            role = this.map.getRoleObject(tile[0], tile[1]);
            switch (tile[2]) {
                case 0: {
                    if (this.isStandBox || role != null) break;
                    this.startMove(MOVE_WAY[this.way], tile);
                    break;
                }
                case 1: {
                    if (!this.isStandBox) {
                        if (role == null || !role.isClimb) break;
                        this.isStandBox = true;
                        this.startMove(MOVE_WAY[this.way], tile);
                        break;
                    }
                    if (role != null || this.way != 0 && this.way != 3) break;
                    this.isStandBox = false;
                    this.startMove(MOVE_WAY[this.way], tile);
                }
            }
        }
        if ((tile = this.map.getNextTile(this.rtx, this.rty, this.way)) != null) {
            role = this.map.getRoleObject(tile[0], tile[1]);
            if (this.isStandBox && !this.map.isBlock(tile[0], tile[1], true, true)) {
                this.isStandBox = false;
                this.startMove((byte)7, tile);
            } else if (role != null && role.isClimb && !this.isStandBox) {
                if (this.roleSupBuild != null && this.roleSupBuild.isPressTrig) {
                    this.roleSupBuild.setPowerState((byte)0);
                    this.checkEvent(this.roleSupBuild, CASE_TRIG);
                    this.roleSupBuild = null;
                }
                this.isStandBox = true;
                this.startMove((byte)6, tile);
            }
        }
        if (this.roleActive != null && this.roleActive.isHandTrig && !this.isStandBox) {
            this.checkEvent(this.roleActive, CASE_TRIG);
        }
        if (!this.isStandStone) {
            Role role2;
            nTile = this.map.getNextTile(this.rtx, this.rty, this.way);
            if (nTile != null && (role2 = this.map.getRoleBuild(nTile[0], nTile[1])) != null && role2.roleType == 14 && role2.isMovePause) {
                role2.isReadyStandRole = true;
                this.roleStone = role2;
                this.startMove((byte)5, nTile);
                return;
            }
        } else {
            if (this.roleStone.isMovePause) {
                nTile = this.map.getNextTile(this.rtx, this.rty, this.way);
                if (nTile == null || this.map.isBlock(nTile[0], nTile[1], true, true)) {
                    return;
                }
                this.roleStone.isStandRole = false;
                this.roleStone.roleStand = null;
                this.isStandStone = false;
                this.startMove((byte)10, nTile);
            }
            return;
        }
    }

    public void startChase(byte tx, byte ty) {
        this.vPath = this.map.getPath(this.rtx, this.rty, tx, ty);
        if (this.chaseTime == 0) {
            this.pathIndexPre = (byte)this.pathIndex;
            this.startTx = this.rtx;
            this.startTy = this.rty;
            if (this.vPath != null) {
                this.countSite();
            }
            int size = this.vPathEnemy.size();
            this.step = this.maxStep;
            if (this.enemyState == 2 && this.pathIndex >= size) {
                this.pathIndex = 0;
            }
            this.chaseTime = (byte)(this.chaseTime + 1);
            this.firstState = this.state;
            this.firstWay = this.way;
            this.sfx = this.rfx;
            this.sfy = this.rfy;
            this.firstStep = this.step;
        }
        this.gs.getCurrentRole().isMoved = false;
        this.tip((byte)0);
        this.setState((byte)5);
    }

    public void startMove(byte moveState, byte[] nTile) {
        this.isMove = false;
        if (nTile != null) {
            this.nextMoveSite = nTile;
        }
        this.stop = false;
        this.setState((byte)1);
        this.moveState = moveState;
        this.px = this.sx;
        this.py = this.sy;
    }

    private void keyWalk(int KeyCode, int key) {
        boolean flag;
        byte nWay = this.getGameWay(key);
        boolean bl = flag = nWay != -1;
        if (this.isStandStone) {
            if (nWay >= 0) {
                this.setWay(nWay);
            }
            return;
        }
        if (!this.stop || this.step != 0) {
            return;
        }
        if (flag) {
            Role role;
            this.way = nWay;
            if (!this.isStandBox && (role = this.getNextRole()) != null && role.isPush && role.powerState == 0) {
                if (this.roleBox != null) {
                    this.roleBox.isBoxStop = false;
                }
                this.roleBox = role;
                this.roleBox.setWay(this.way);
                this.roleBox.startMove((byte)0, null);
                this.startMove((byte)2, null);
                return;
            }
            this.startMove((byte)0, null);
        }
    }

    public byte getGameWay(int key) {
        byte nWay;
        switch (key) {
            case 1: {
                nWay = 0;
                break;
            }
            case 6: {
                nWay = 1;
                break;
            }
            case 2: {
                nWay = 2;
                break;
            }
            case 5: {
                nWay = 3;
                break;
            }
            default: {
                return -1;
            }
        }
        return nWay;
    }

    public void saveRms() {
        try {
            Rms rms = new Rms();
            rms.open("" + this.roleId);
            rms.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void readRms() {
        try {
            Rms rms = new Rms();
            rms.open("" + this.roleId);
            rms.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void spl(String s) {
        System.out.println(s);
    }

    public void keyReleased(int KeyCode, int key) {
        if (key != 8) {
            this.stop = true;
            if (this.roleType == 0 && this.moveState == 2 && this.roleBox != null) {
                this.roleBox.isPushBoxDown = false;
            }
            if (this.roleBox != null) {
                this.roleBox.stop = true;
            }
        }
    }

    public void flash() {
    }

    public static void readRole(Role role, DataInputStream dis, boolean rms, Role roleMain) throws Exception {
        switch (role.roleType) {
            case 0: {
                role.setWay(dis.readByte());
                role.autoActionID = dis.readByte();
                dis.readByte();
                dis.readByte();
                dis.readByte();
                role.bKeyNums = dis.readByte();
                dis.readByte();
                role.bBomNums = dis.readByte();
                role.actTip = new Actor("/res/tip.dat", GameScreen.imaTip);
                break;
            }
            case 1: {
                role.setWay(dis.readByte());
                role.isHide = dis.readByte() == 0;
                break;
            }
            case 2: {
                role.actTip = new Actor("/res/tip.dat", GameScreen.imaTip);
                role.setWay(dis.readByte());
                role.wayOrigi = role.way;
                byte state = dis.readByte();
                if (state == 4) {
                    role.rotaWay = new byte[4];
                    role.rotaSleep = new byte[4];
                    for (int i = 0; i < 4; ++i) {
                        role.rotaWay[i] = dis.readByte();
                        role.rotaSleep[i] = dis.readByte();
                    }
                } else {
                    Map.readData(dis, 8);
                }
                role.setEnemyState(state, true);
                break;
            }
            case 5: {
                role.goodsID = dis.readByte();
                break;
            }
            case 6: {
                boolean bl = role.isReAction = dis.readByte() == 0;
                if (dis.readByte() == 0) {
                    role.hiden();
                }
                role.isLockedScreen = dis.readByte() == 0;
                break;
            }
            case 14: {
                role.setPowerState(dis.readByte() != 0 ? (byte)2 : 0);
                break;
            }
            case 7: {
                dis.readByte();
                break;
            }
            case 8: {
                role.setPowerState(dis.readByte());
                role.powerGroundSpace = dis.readByte();
                break;
            }
            case 9: {
                byte flag = dis.readByte();
                role.doorBlockX = dis.readByte();
                role.doorBlockY = dis.readByte();
                role.setPowerState(flag == 0 ? (byte)2 : 0);
                break;
            }
            case 10: {
                role.setPowerState(dis.readByte() == 0 ? (byte)2 : 0);
                break;
            }
            case 11: {
                break;
            }
            case 3: {
                role.platHeight = (byte)16;
            }
        }
    }

    public void readPath(DataInputStream dis) throws Exception {
        int pathLength = dis.readByte();
        this.vPathEnemy = new Vector(pathLength);
        for (int i = 0; i < pathLength; ++i) {
            this.vPathEnemy.addElement(new byte[]{dis.readByte(), dis.readByte()});
        }
    }

    public void setPowerState(byte state) {
        block9: {
            if (this.isDisable) {
                return;
            }
            this.powerState = state;
            block0 : switch (state) {
                case 0: 
                case 2: {
                    switch (this.roleType) {
                        case 9: {
                            this.map.setBlock(this.rtx, this.rty, state == 0);
                            this.map.setBlock(this.doorBlockX, this.doorBlockY, state == 0);
                            if (this.gs.currentRole != null && (this.gs.currentRole.rtx == this.rtx && this.gs.currentRole.rty == this.rty || this.gs.currentRole.rtx == this.doorBlockX && this.gs.currentRole.rty == this.doorBlockY)) {
                                this.gs.currentRole.setState((byte)10);
                                break block0;
                            }
                            break block9;
                        }
                        case 10: {
                            this.map.setBlock(this.rtx, this.rty, state != 0);
                        }
                    }
                }
            }
        }
        this.isMovePause = true;
        this.moveTimer = 0;
    }

    public void powerFastSwitch() {
        this.setPowerState(this.powerState == 2 ? (byte)0 : 2);
    }

    public int getGoodNums(byte goodsId) {
        if (goodsId == 0) {
            return this.bKeyNums;
        }
        return this.bBomNums;
    }

    public void setGoodNums(byte nums, byte goodsId) {
        if (goodsId == 0) {
            this.bKeyNums = nums;
        } else {
            this.bBomNums = nums;
        }
    }

    public void open() {
    }

    public void close() {
    }

    public void show(byte rtx, byte rty) {
        this.setState((byte)9);
        this.isHide = false;
        this.rtx = rtx;
        this.rty = rty;
        this.init(true);
        if (this.isUniteBuild) {
            this.uniteBuild(this.isBlock);
        }
    }

    public void readCase(DataInputStream dis) throws Exception {
        for (int i = 0; i < CASE_ID.length; ++i) {
            Vector v = AutoAction.readActions(dis);
            this.hEvent.put(CASE_ID[i] + "", v);
            v = AutoAction.readActions(dis);
            this.hRule.put(CASE_ID[i] + "", v);
        }
    }

    public boolean search(byte heroX, byte heroY) {
        int i;
        byte[][] areaGroup = new byte[13][];
        int length = x[this.way].length;
        for (i = 0; i < length; ++i) {
            byte[] tmp = new byte[]{(byte)(this.rtx + x[this.way][i]), (byte)(this.rty + y[this.way][i]), -1, -1};
            areaGroup[i] = tmp;
        }
        length = bitNums.length;
        for (i = 0; i < length; ++i) {
            boolean isBlocked = false;
            int l = bitNums[i].length;
            for (int j = 0; j < l; ++j) {
                byte[] tmp = areaGroup[bitNums[i][j]];
                tmp[2] = 1;
                if (this.map.isEyeBlock(tmp[0], tmp[1])) {
                    isBlocked = true;
                }
                if (isBlocked) {
                    tmp[3] = 1;
                    continue;
                }
                if (tmp[2] == 1 && tmp[3] == 1) continue;
                tmp[3] = 0;
            }
        }
        length = areaGroup.length;
        for (i = 0; i < length; ++i) {
            byte[] tmp = areaGroup[i];
            if (tmp[2] != 1 || tmp[3] != 0 || heroX != tmp[0] || heroY != tmp[1]) continue;
            return true;
        }
        return false;
    }

    public Vector detonate() {
        byte[] x = new byte[]{-1, 0, 1, -1, 0, 1, -1, 0, 1};
        byte[] y = new byte[]{-1, -1, -1, 0, 0, 0, 1, 1, 1};
        Vector v = new Vector();
        int length = x.length;
        for (int i = 0; i < length; ++i) {
            byte tx = (byte)(this.rtx + x[i]);
            byte ty = (byte)(this.rty + y[i]);
            Role role = this.map.getRoleObject(tx, ty);
            this.checkBom(role);
            role = this.map.getRoleBuild(tx, ty);
            this.checkBom(role);
            role = this.gs.getCurrentRole();
            if (role.rtx != tx || role.rty != ty || role.state == 10) continue;
            role.setState((byte)10);
        }
        this.gs.soundRes.playMidi(3, 1);
        return v;
    }

    private void checkBom(Role role) {
        if (role != null && (role.isDestroy || role.isBom) && role.state != 10) {
            role.setState((byte)10);
        }
    }

    public void bom() {
        if (this.roleType == 2) {
            this.gs.getCurrentRole().leaveSearch();
        }
        this.setState((byte)10);
        this.bombState = (byte)2;
        this.detonate();
    }
}

