/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Map {
    public static final byte ROTATE_NONE = 0;
    public static final byte ROTATE_HORIZONTAL = 1;
    public static final byte ROTATE_VERTICAL = 2;
    public static final byte ROTATE_180 = 3;
    public static final byte UP = 0;
    public static final byte DOWN = 1;
    public static final byte LEFT = 2;
    public static final byte RIGHT = 3;
    public static final byte[] WAY_X_OFF = new byte[]{0, 0, -1, 1};
    public static final byte[] WAY_Y_OFF = new byte[]{-1, 1, 0, 0};
    public static final byte GROUND_TYPE_NORMAL = 0;
    public static final byte GROUND_WALL = 1;
    public static final byte GROUND_HALF = 2;
    public static final byte BUILE_NULL = -128;
    public static final byte ROW_SPEED = 4;
    public static final byte COL_SPEED = 2;
    public int cameraX;
    public int cameraY;
    public int cameraW;
    public int cameraH;
    public byte tileWidth;
    public byte tileHeight;
    public short[][] bgPixels;
    private Image[] imaGounds;
    private boolean[] groundBlock;
    private byte[] groundtype;
    private byte[] blockBox;
    private byte[] holeBox;
    private byte[] groundId;
    public byte groundLength;
    private byte[] groundRotate;
    private byte bgRow;
    private byte bgCol;
    public Image[] imaBuild;
    private byte[] buildOffBaseX;
    private byte[] buildOffBaseY;
    private byte[] buildBaseX;
    private byte[] buildBaseY;
    private byte[][] buildBlock;
    private byte[] buildTileW;
    private byte[] buildTileH;
    public byte[] buildHeight;
    public byte[][] mapData;
    public byte[][] buildData;
    public byte[][] roleData;
    public boolean[][] block;
    public byte mapWidth;
    public byte mapHeight;
    public byte[] bArrayRegion;
    public static Hashtable npcs = new Hashtable();
    GameScreen gs;
    public String sResbom = "bom";
    public Hashtable imaRoles;
    public Image[] imaIcons;
    public String[] resPng;
    public String[] resDat;
    public boolean[] isPush;
    public boolean[] isHandTrig;
    public boolean[] isPressTrig;
    public boolean[] isDestroy;
    public boolean[] isBom;
    public boolean[] isClimb;
    public boolean[] isBlock;
    public boolean[] isUniteBuild;
    public boolean[] isCanGet;
    public short[] roleHeight;
    public Image imaGroundBuf;
    public Vector vEnemys;
    public Bomb bomC4;
    private Image[] enemyViewImgs;
    public static final byte tileDrawH = 15;
    private short[][] build;
    private short[] buildW;
    private short[] buildH;
    Graphics gbg;
    private Role roleMain;
    private int moveTarX;
    private int moveTarY;
    private byte moveOffX;
    private byte moveOffY;
    public boolean isFocus;
    public boolean isDanger;
    public static int buildNums = 0;
    Role boxRole = null;
    private Image bgRes;
    public static final byte FACE_BACK = 0;
    public static final byte FACE_FLANK = 1;
    public static final byte FACE_FACE = 2;
    private static final byte[] WALL_TILE_X_OFF = new byte[]{1, -1, -1, 1};
    private static final byte[] WALL_TILE_Y_OFF = new byte[]{-1, 1, 1, -1};
    private Image imaSmall;
    private Vector openList;
    private Vector closeList;
    private byte[][][] mapInfo;
    private int[][] mapF;
    private int openListIndex;
    private int closeListIndex;
    byte beginX = (byte)9;
    byte beginY = (byte)9;
    byte endX = 0;
    byte endY = 0;
    boolean isFinding;
    boolean isNoWay;

    public Map(GameScreen gs) throws Exception {
        this.vEnemys = new Vector(5);
        this.openList = new Vector();
        this.closeList = new Vector();
        this.enemyViewImgs = new Image[2];
        for (int i = 0; i < this.enemyViewImgs.length; ++i) {
            this.enemyViewImgs[i] = Image.createImage((String)("/res/jc" + i + ".png"));
        }
        this.gs = gs;
        try {
            this.imaRoles = new Hashtable();
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("/res/role.bin"));
            int length = dis.readShort();
            this.imaIcons = new Image[length];
            this.resPng = new String[length];
            this.resDat = new String[length];
            this.isPush = new boolean[length];
            this.isClimb = new boolean[length];
            this.isBlock = new boolean[length];
            this.isUniteBuild = new boolean[length];
            this.isPressTrig = new boolean[length];
            this.isHandTrig = new boolean[length];
            this.isDestroy = new boolean[length];
            this.isBom = new boolean[length];
            this.isCanGet = new boolean[length];
            this.roleHeight = new short[length];
            for (int i = 0; i < length; ++i) {
                this.roleHeight[i] = (short)dis.readUnsignedByte();
                this.resPng[i] = dis.readUTF();
                this.resDat[i] = dis.readUTF();
                this.isPush[i] = dis.readByte() == 0;
                this.isDestroy[i] = dis.readByte() == 0;
                this.isHandTrig[i] = dis.readByte() == 0;
                this.isPressTrig[i] = dis.readByte() == 0;
                this.isBom[i] = dis.readByte() == 0;
                this.isClimb[i] = dis.readByte() == 0;
                this.isBlock[i] = dis.readByte() == 0;
                this.isUniteBuild[i] = dis.readByte() == 0;
                this.isCanGet[i] = dis.readByte() == 0;
            }
            dis.close();
        }
        catch (Exception ex) {
            Main.Fake(ex);
            ex.printStackTrace();
        }
    }

    public void readRes(GameScreen gs, String path) throws Exception {
        this.gs = gs;
        try {
            int i;
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(path));
            int length = 0;
            byte[] data = null;
            length = dis.readInt();
            data = Map.readData(dis, length);
            this.tileWidth = dis.readByte();
            this.tileHeight = dis.readByte();
            this.tileHeight = (byte)16;
            this.bgRow = dis.readByte();
            this.bgCol = dis.readByte();
            this.groundLength = (byte)(this.bgRow * this.bgCol);
            Image ground = Image.createImage((byte[])data, (int)0, (int)length);
            data = null;
            this.bgRes = ground;
            ground = null;
            length = dis.readByte();
            this.groundId = Map.readData(dis, length);
            this.groundRotate = Map.readData(dis, length);
            this.groundBlock = new boolean[length];
            this.groundtype = new byte[length];
            this.blockBox = new byte[length];
            this.holeBox = new byte[length];
            byte[] temp = Map.readData(dis, length);
            for (i = 0; i < length; ++i) {
                this.holeBox[i] = (byte)(temp[i] & 1);
                int n = i;
                temp[n] = (byte)(temp[n] >> 1);
                this.blockBox[i] = (byte)(temp[i] & 1);
                int n2 = i;
                temp[n2] = (byte)(temp[n2] >> 1);
                byte cornerOut = (byte)(temp[i] & 1);
                int n3 = i;
                temp[n3] = (byte)(temp[n3] >> 1);
                byte cornerIn = (byte)(temp[i] & 1);
                int n4 = i;
                temp[n4] = (byte)(temp[n4] >> 1);
                byte wallBlack = (byte)(temp[i] & 1);
                int n5 = i;
                temp[n5] = (byte)(temp[n5] >> 1);
                byte wallLigth = (byte)(temp[i] & 1);
                int n6 = i;
                temp[n6] = (byte)(temp[n6] >> 1);
                boolean bl = this.groundBlock[i] = (temp[i] & 1) == 1;
                if (wallBlack == 1) {
                    this.groundtype[i] = 2;
                    continue;
                }
                if (wallLigth != 1) continue;
                this.groundtype[i] = 1;
            }
            length = dis.readByte();
            this.buildOffBaseX = new byte[length];
            this.buildOffBaseY = new byte[length];
            this.buildBaseX = new byte[length];
            this.buildBaseY = new byte[length];
            this.buildBlock = new byte[length][];
            this.buildTileW = new byte[length];
            this.buildTileH = new byte[length];
            this.buildHeight = new byte[length];
            this.imaBuild = new Image[length];
            for (i = 0; i < length; ++i) {
                this.readS60Build(dis, i);
            }
            dis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void readS40(DataInputStream dis, int length) throws Exception {
        int tileH = 15;
        this.bgPixels = new short[length][];
        this.groundLength = (byte)(this.bgRow * this.bgCol);
        for (int i = 0; i < length; ++i) {
            this.bgPixels[i] = new short[this.tileWidth * tileH];
            int l = this.tileWidth * tileH;
            for (int j = 0; j < l; ++j) {
                this.bgPixels[i][j] = dis.readShort();
            }
        }
    }

    public void readS60(DataInputStream dis, Image ground) throws Exception {
    }

    private void readS40Build(DataInputStream dis, int index) throws Exception {
        this.buildW[index] = dis.readShort();
        this.buildH[index] = dis.readShort();
        this.build[index] = new short[dis.readInt()];
        int l = this.build[index].length;
        for (int i = 0; i < l; ++i) {
            this.build[index][i] = dis.readShort();
        }
        this.buildOffBaseX[index] = dis.readByte();
        this.buildOffBaseY[index] = dis.readByte();
        this.buildBaseX[index] = dis.readByte();
        this.buildBaseY[index] = dis.readByte();
        this.buildTileW[index] = dis.readByte();
        this.buildTileH[index] = dis.readByte();
        this.buildHeight[index] = dis.readByte();
        this.buildBlock[index] = new byte[this.buildTileW[index] * this.buildTileH[index]];
        this.buildBlock[index] = Map.readData(dis, this.buildBlock[index].length);
    }

    public void setCameraClip(int x, int y, int w, int h) {
        this.cameraW = w;
        this.cameraH = h;
    }

    public void changeGround(int x, int y, byte resID) {
        this.mapData[y][x] = resID;
        this.setBlock(x, y, this.groundBlock[resID]);
    }

    public void setBlock(int x, int y, boolean block) {
        this.block[y][x] = block;
        this.refurshSmallMap();
    }

    public void changeBuild(int x, int y, byte resID) {
        this.buildData[y][x] = resID;
        if (resID != -128) {
            this.countBuildBlock(x, y, resID);
        }
    }

    public Role getRoleObject(int rtx, int rty) {
        byte npcId = this.roleData[rty][rtx];
        return this.getRoleObject(npcId);
    }

    public Role getRoleBuild(int rtx, int rty) {
        byte id = this.buildData[rty][rtx];
        if (id < 0) {
            return this.getRoleObject((byte)Math.abs(id));
        }
        return null;
    }

    public Role getRoleObject(byte npcId) {
        Role role = (Role)npcs.get("" + npcId);
        return role;
    }

    public Role getRoleObjectId(byte roleId) {
        Enumeration e = npcs.keys();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            Role role = (Role)npcs.get(o);
            if (role.roleId != roleId) continue;
            return role;
        }
        return null;
    }

    public void readHead(DataInputStream dis, int gamePlan) throws Exception {
        dis.readByte();
        int index = 0;
        while (index++ < gamePlan) {
            short length = dis.readShort();
            dis.skip(length);
        }
        dis.readShort();
    }

    public void readMapData(String path, int gamePlan, boolean rms) {
        try {
            int a;
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(path));
            this.readHead(dis, gamePlan);
            byte length = dis.readByte();
            this.mapWidth = dis.readByte();
            this.mapHeight = dis.readByte();
            this.mapF = new int[this.mapWidth][this.mapHeight];
            this.mapInfo = new byte[this.mapWidth][this.mapHeight][5];
            this.roleData = new byte[this.mapHeight][this.mapWidth];
            this.bArrayRegion = new byte[this.mapWidth * this.mapHeight];
            this.mapData = new byte[this.mapHeight][this.mapWidth];
            for (a = 0; a < this.mapHeight; ++a) {
                this.mapData[a] = Map.readData(dis, this.mapWidth);
            }
            this.buildData = new byte[this.mapHeight][this.mapWidth];
            for (a = 0; a < this.mapHeight; ++a) {
                for (int b = 0; b < this.mapWidth; ++b) {
                    this.buildData[a][b] = -128;
                }
            }
            int bLength = dis.readInt();
            this.block = new boolean[this.mapHeight][this.mapWidth];
            if (bLength > 0) {
                byte[] bData = new byte[bLength];
                byte[] x = new byte[bLength];
                byte[] y = new byte[bLength];
                bData = Map.readData(dis, bLength);
                x = Map.readData(dis, bLength);
                y = Map.readData(dis, bLength);
                for (int a2 = 0; a2 < bLength; ++a2) {
                    this.buildData[y[a2]][x[a2]] = bData[a2];
                    this.countBuildBlock(x[a2], y[a2], bData[a2]);
                }
            }
            for (int n = 0; n < this.mapHeight; ++n) {
                for (int m = 0; m < this.mapWidth; ++m) {
                    byte id = this.mapData[n][m];
                    if (id == -1 && !this.block[n][m] && this.buildData[n][m] == -128) {
                        this.block[n][m] = true;
                        continue;
                    }
                    if (id < 0 || id >= this.groundBlock.length || this.block[n][m]) continue;
                    this.block[n][m] = this.groundBlock[id];
                }
            }
            int roleNums = dis.readShort();
            for (int m = 0; m < roleNums; ++m) {
                byte id = dis.readByte();
                if (this.imaRoles.get(this.resPng[id]) == null) {
                    try {
                        Image res = Image.createImage((String)("/res/" + this.resPng[id] + ".png"));
                        this.imaRoles.put(this.resPng[id], res);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (this.imaIcons[id] != null) continue;
                try {
                    this.imaIcons[id] = Image.createImage((String)("/res/" + this.resPng[id] + "t.png"));
                    continue;
                }
                catch (Exception ex) {
                    this.imaIcons[id] = null;
                }
            }
            if (this.imaRoles.get(this.sResbom) == null) {
                try {
                    Image res = Image.createImage((String)("/res/" + this.sResbom + ".png"));
                    this.imaRoles.put(this.sResbom, res);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            try {
                this.creatSmallMap();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            dis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void readRoleData(String path, boolean rms, byte gamePlan) throws Exception {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(path));
        this.readHead(dis, gamePlan);
        this.readRole(dis, rms, true);
        dis.close();
    }

    public void clearRoleSate() {
        for (int i = 0; i < this.mapHeight; ++i) {
            for (int j = 0; j < this.mapWidth; ++j) {
                this.roleData[i][j] = -128;
                if (this.buildData[i][j] >= 0) continue;
                this.buildData[i][j] = -128;
            }
        }
        this.roleMain = this.getRoleObjectId((byte)0);
        npcs.clear();
        this.isDanger = false;
    }

    public void readRole(DataInputStream dis, boolean rms, boolean init) throws Exception {
        this.vEnemys.removeAllElements();
        this.clearRoleSate();
        int bLength = dis.readByte();
        int l = this.bArrayRegion.length;
        for (int i = 0; i < l; ++i) {
            this.bArrayRegion[i] = 0;
        }
        if (bLength > 0) {
            byte[] rId = new byte[bLength];
            byte[] x = new byte[bLength];
            byte[] y = new byte[bLength];
            rId = Map.readData(dis, bLength);
            x = Map.readData(dis, bLength);
            y = Map.readData(dis, bLength);
            for (int npc = 0; npc < bLength; ++npc) {
                byte roleType;
                byte id = rId[npc];
                String datRes = "/res/" + this.resDat[rId[npc]] + ".dat";
                Role role = new Role(this, (byte)npc, id);
                role.actor = new Actor(datRes, (Image)this.imaRoles.get(this.resPng[id]));
                role.rtx = x[npc];
                role.rty = y[npc];
                role.platHeight = (byte)this.roleHeight[id];
                role.isPush = this.isPush[id];
                role.isClimb = this.isClimb[id];
                role.isBlock = this.isBlock[id];
                role.isPressTrig = this.isPressTrig[id];
                role.isHandTrig = this.isHandTrig[id];
                role.isBom = this.isBom[id];
                role.isDestroy = this.isDestroy[id];
                role.init(true);
                if (this.isUniteBuild[id]) {
                    role.uniteBuild(role.isBlock);
                }
                role.roleType = roleType = dis.readByte();
                Role.readRole(role, dis, rms, this.roleMain);
                role.readPath(dis);
                if (role.roleType == 0) {
                    this.gs.currentRole = role;
                } else if (role.roleType == 2) {
                    this.vEnemys.addElement(role);
                }
                npcs.put("" + role.npcID, role);
            }
        }
        this.bomC4 = new Bomb(this.gs, this);
    }

    public boolean isLegalityTile(byte[] tile) {
        return tile != null && tile != null && !this.block[tile[1]][tile[0]];
    }

    public byte getRoteWay(boolean flag, byte way) {
        switch (way) {
            case 0: {
                return flag ? (byte)2 : 3;
            }
            case 1: {
                return flag ? (byte)3 : 2;
            }
            case 2: {
                return flag ? (byte)1 : 0;
            }
            case 3: {
                return flag ? (byte)0 : 1;
            }
        }
        return 0;
    }

    public void setData(byte[][] data, byte value, short rtx, short rty) {
        data[rty][rtx] = value;
    }

    public void run() {
        Enumeration e = npcs.keys();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            Role role = (Role)npcs.get(o);
            if (role == null) continue;
            role.run();
        }
        this.bomC4.run();
    }

    public int getTileXPixValue(int rtx, int rty) {
        return rtx * (this.tileWidth / 2) + rty * (this.tileWidth / 2) + this.tileWidth / 2 - this.tileWidth / 2;
    }

    public int getTileYPixValue(int rtx, int rty) {
        int sy = (this.mapWidth - 1) * (this.tileHeight / 2);
        return sy - rtx * (this.tileHeight / 2) + rty * (this.tileHeight / 2) + this.tileHeight / 2 - this.tileHeight / 2;
    }

    public void focus(byte rtx, byte rty, boolean fast) {
        int tempX = this.getTileXPixValue(rtx, rty);
        int tempY = this.getTileYPixValue(rtx, rty);
        this.moveTarX = -tempX + this.cameraW / 2 - this.tileWidth / 2;
        this.moveTarY = -tempY + this.cameraH / 2;
        this.cameraX = this.moveTarX;
        this.cameraY = this.moveTarY;
    }

    public void focus(short rtx, short rty) {
        int tempX = this.getTileXPixValue(rtx, rty);
        int tempY = this.getTileYPixValue(rtx, rty);
        this.moveTarX = -tempX + this.cameraW / 2;
        this.moveTarY = -tempY + 104;
        this.isFocus = true;
        this.moveOffX = (byte)((this.moveTarX - this.cameraX) / 8);
        this.moveOffX = (byte)(this.moveOffX >= 0 ? 5 : -5);
        this.moveOffY = (byte)((this.moveTarY - this.cameraY) / 8);
        this.moveOffY = (byte)(this.moveOffY >= 0 ? 5 : -5);
    }

    private void readS60Build(DataInputStream dis, int index) throws Exception {
        byte[] temp = new byte[dis.readInt()];
        temp = Map.readData(dis, temp.length);
        this.imaBuild[index] = Image.createImage((byte[])temp, (int)0, (int)temp.length);
        this.buildOffBaseX[index] = dis.readByte();
        this.buildOffBaseY[index] = dis.readByte();
        this.buildBaseX[index] = dis.readByte();
        this.buildBaseY[index] = dis.readByte();
        this.buildTileW[index] = dis.readByte();
        this.buildTileH[index] = dis.readByte();
        this.buildHeight[index] = dis.readByte();
        this.buildBlock[index] = new byte[this.buildTileW[index] * this.buildTileH[index]];
        this.buildBlock[index] = Map.readData(dis, this.buildBlock[index].length);
    }

    public void drawSmall(Graphics g, short xx, short yy) {
        g.setColor(10679285);
        if (!Constant.isShowSmall) {
            return;
        }
        int w = 40;
        int h = 40;
        int x = 134;
        int y = 2;
        g.setClip(x, y, w, h);
        int centerX = x + 20;
        int centerY = y + 20;
        int mx = centerX - this.gs.getCurrentRole().rtx * 2;
        int my = centerY - this.gs.getCurrentRole().rty * 2;
        g.drawImage(this.imaSmall, mx, my, 0);
        block6: for (int i = 0; i < this.vEnemys.size(); ++i) {
            Role role = (Role)this.vEnemys.elementAt(i);
            g.setColor(0xFFFF00);
            int sx = mx + role.rtx * 2 - 1;
            int sy = my + role.rty * 2 - 1;
            g.fillRect(sx, sy, 4, 4);
            int imgW = this.enemyViewImgs[0].getWidth() >> 1;
            int imgH = this.enemyViewImgs[0].getHeight();
            DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
            switch (role.way) {
                case 0: {
                    dg.drawImage(this.enemyViewImgs[0], sx - imgW / 2 - 1, sy - imgH + 2, 0, 0);
                    continue block6;
                }
                case 1: {
                    dg.drawImage(this.enemyViewImgs[0], sx - imgW / 2 - 1, sy + 2, 0, 180);
                    continue block6;
                }
                case 2: {
                    dg.drawImage(this.enemyViewImgs[1], sx - 2 - imgW, sy - imgH / 2, 0, 180);
                    continue block6;
                }
                case 3: {
                    dg.drawImage(this.enemyViewImgs[1], sx + 2, sy - imgH / 2, 0, 0);
                }
            }
        }
        g.setColor(0xFF0000);
        g.fillRect(centerX - 1, centerY - 1, 4, 4);
        g.setColor(this.isDanger ? 0xFF0000 : 0x434343);
        g.drawRect(x, y, w - 1, h - 1);
    }

    public void draw(Graphics g) {
        g.setColor(3865);
        g.fillRect(0, 0, 176, 208);
        try {
            int w = 0;
            int h = 0;
            int startCol = 0;
            int startRow = 0;
            boolean xx = false;
            int yy = 0;
            int x = 0;
            int y = 0;
            y = yy;
            this.drawGround(g, x, y, startRow, startCol, w, h);
            this.drawBuild(g, x, y, startRow, startCol, w, h);
            g.setClip(0, 0, 176, 208);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setCameraClip(0, 0, 176, 208);
        this.run();
    }

    private void drawBuild(Graphics g, int xx, int yy, int startRow, int startCol, int w, int h) {
        buildNums = 0;
        Role hero = this.gs.getCurrentRole();
        boolean aa = hero.roleBox != null;
        int rx = 0;
        int ry = 0;
        if (aa) {
            rx = hero.roleBox.roleX;
            ry = hero.roleBox.roleY;
        }
        int bx = 0;
        int by = 0;
        short buildH = 0;
        int x = this.cameraX;
        int y = this.cameraY;
        int hTw = this.tileWidth / 2;
        int hTh = this.tileHeight / 2;
        int sx = this.mapWidth * hTw - hTw;
        for (int a = 0; a < this.mapHeight; ++a) {
            int tx = sx + x + a * hTw;
            int ty = y + a * hTh;
            for (int b = this.mapWidth - 1; b >= 0; --b) {
                byte id;
                if (tx + this.tileWidth <= 0 || tx >= this.cameraW + 10 || ty + this.tileHeight <= 0 || ty - this.tileHeight > this.cameraH + 10) {
                    tx -= hTw;
                    ty += hTh;
                    continue;
                }
                if (aa && a == ry && b == rx) {
                    bx = tx;
                    by = ty;
                }
                if ((id = this.buildData[a][b]) != -128) {
                    this.drawBuild(g, GameScreen.dg, tx, ty, id);
                }
                buildH = id >= 0 ? (short)this.buildHeight[id] : (short)0;
                byte rid = this.roleData[a][b];
                this.boxRole = null;
                if (rid != -128) {
                    buildH = this.drawRole(g, rid, (byte)b, buildH);
                }
                byte rrid = 0;
                if (aa && this.boxRole != null && this.boxRole == hero.roleBox && (rrid = this.roleData[ry][rx]) != -128) {
                    buildH = this.drawRole(g, rrid, (byte)b, (short)0);
                }
                if (this.bomC4.rtx == b && this.bomC4.rty == a) {
                    this.bomC4.draw(g, buildH);
                }
                if (hero.rtx == b && hero.rty == a) {
                    hero.draw(g, 0, 0, buildH);
                }
                rid = this.roleData[a][b];
                Role role = null;
                if (rid != -128) {
                    role = (Role)npcs.get("" + Math.abs(rid));
                }
                if (role != null && role.roleId == 28 && role.rtx == b && role.rty == a) {
                    role.draw(g, 0, 0, buildH);
                }
                g.setClip(0, 0, 176, 208);
                if (id == 4) {
                    g.drawImage(this.imaBuild[id], tx - this.buildBaseX[id], ty - this.buildBaseY[id], 0);
                }
                tx -= hTw;
                ty += hTh;
            }
        }
    }

    private void drawGround(Graphics g, int xx, int yy, int startRow, int startCol, int w, int h) {
        int x = this.cameraX;
        int y = this.cameraY;
        int hTw = this.tileWidth / 2;
        int hTh = this.tileHeight / 2;
        int sx = this.mapWidth * hTw - hTw;
        for (int a = 0; a < this.mapHeight; ++a) {
            int tx = sx + x + a * hTw;
            int ty = y + a * hTh;
            for (int b = this.mapWidth - 1; b >= 0; --b) {
                if (tx + this.tileWidth < 0 || tx >= this.cameraW || ty + this.tileHeight < 0 || ty >= this.cameraH) {
                    tx -= hTw;
                    ty += hTh;
                    continue;
                }
                byte id = this.mapData[a][b];
                if ((id >> 6 & 1) != 1) {
                    byte cId = (byte)(id & 0x3F);
                    this.drawGroundImage(g, GameScreen.dg, tx, ty, cId);
                }
                tx -= hTw;
                ty += hTh;
            }
        }
    }

    public byte getGroundType(int tx, int ty) {
        if (!this.isLegalityTile(tx, ty)) {
            return 0;
        }
        byte id = this.mapData[ty][tx];
        if (id >= this.groundLength || id < 0) {
            return 0;
        }
        return this.groundtype[id];
    }

    public boolean isLegalityTile(int tx, int ty) {
        return tx >= 0 && tx < this.mapWidth && ty >= 0 && ty < this.mapHeight;
    }

    public byte drawRole(Graphics g, byte id, byte offX, short offY) {
        Role role;
        this.boxRole = role = (Role)npcs.get("" + Math.abs(id));
        if (role != null && role.roleId != 28) {
            role.draw(g, 0, 0, offY);
            if (role.isClimb) {
                return role.platHeight;
            }
        }
        return 0;
    }

    public static byte getWay(byte ctx, byte cty, byte ntx, byte nty) {
        if (nty == cty) {
            return ntx > ctx ? (byte)3 : 2;
        }
        if (ntx == ctx) {
            return nty > cty ? (byte)1 : 0;
        }
        return ntx > ctx ? (byte)3 : 1;
    }

    public boolean isHoleBox(int cx, int cy) {
        byte rid = this.mapData[cy][cx];
        byte bid = this.buildData[cy][cx];
        byte cId = (byte)(rid & 0x3F);
        if (rid != -1 && cId >= 0 && bid == -128) {
            return this.holeBox[cId] == 1;
        }
        return false;
    }

    public boolean isBoxBlock(int cx, int cy) {
        byte rid = this.roleData[cy][cx];
        if (rid != -128) {
            return true;
        }
        rid = this.buildData[cy][cx];
        if (rid != -128 && rid >= 0) {
            return true;
        }
        if (!this.bomC4.isHide && this.bomC4.rtx == cx && this.bomC4.rty == cy) {
            return true;
        }
        rid = this.mapData[cy][cx];
        byte cId = (byte)(rid & 0x3F);
        if (this.block[cy][cx] && !this.isHoleBox(cx, cy)) {
            return true;
        }
        if (rid != -1 && cId >= 0) {
            return this.blockBox[cId] == 1;
        }
        return rid < 0;
    }

    public boolean isBlock(int cx, int cy, boolean role, boolean build) {
        if (cy < 0 || cx < 0 || cy >= this.mapHeight || cx >= this.mapWidth || cy >= 176) {
            return true;
        }
        if (this.block[cy][cx]) {
            return true;
        }
        if (role) {
            Role roleObj;
            byte rid = this.roleData[cy][cx];
            if (rid != -128 && (roleObj = this.getRoleObject(rid)) != null) {
                return this.isBlockRole(roleObj);
            }
            if (cx == this.gs.getCurrentRole().rtx && cy == this.gs.getCurrentRole().rty && this.gs.getCurrentRole().isInGrass) {
                return true;
            }
        }
        return false;
    }

    public boolean isBlockRole(Role role) {
        if (role != null) {
            return role.state != 10 && role.isBlock;
        }
        return false;
    }

    public boolean isBlockSandWall(int tx, int ty) {
        boolean block = this.block[ty][tx];
        if (block && this.buildData[ty][tx] == -128 && this.roleData[ty][tx] == -128 && this.getGroundType(tx, ty) == 2) {
            return false;
        }
        return block;
    }

    public static byte getFace(byte way1, byte way2) {
        if (way1 == way2) {
            return 0;
        }
        if (way1 == Map.getRotateWay(way2)) {
            return 2;
        }
        return 1;
    }

    public static byte getLeftWay(byte way, boolean left) {
        switch (way) {
            case 0: 
            case 1: {
                return left ? (byte)2 : 3;
            }
            case 2: 
            case 3: {
                return left ? (byte)0 : 1;
            }
        }
        return 0;
    }

    public static byte getRotateWay(byte way) {
        switch (way) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    public byte[] getNextWallTile(int tx, int ty, byte way, int layerNums) {
        byte wallH = 99;
        do {
            int tileY;
            int tileX;
            if (this.getGroundType(tileX = (tx += WALL_TILE_X_OFF[way]), tileY = (ty += WALL_TILE_Y_OFF[way])) != 0 || this.isBlock(tileX, tileY, false, true)) continue;
            return new byte[]{(byte)tileX, (byte)tileY, wallH};
        } while ((wallH = (byte)((byte)(wallH + 1))) < layerNums);
        return null;
    }

    public byte[] getNextTile(int tx, int ty, byte way) {
        byte[] temp = new byte[]{(byte)(tx += WAY_X_OFF[way]), (byte)(ty += WAY_Y_OFF[way])};
        if (tx < 0 || ty < 0 || tx >= this.mapWidth || ty >= this.mapHeight) {
            return null;
        }
        return temp;
    }

    public byte[] getNextTile(int tx, int ty, byte way, boolean checkWall) {
        byte[] temp = new byte[3];
        temp[2] = 0;
        byte[] tile = this.getNextTile(tx, ty, way);
        if (tile == null) {
            return null;
        }
        temp[0] = tile[0];
        temp[1] = tile[1];
        return temp;
    }

    public byte[] getWallTile(int tx, int ty, byte way) {
        boolean wall;
        byte[] tile = this.getNextTile(tx, ty, way);
        if (tile == null) {
            return null;
        }
        byte gType = this.getGroundType(tile[0], tile[1]);
        boolean bl = wall = gType == 1;
        if (wall) {
            return this.getNextWallTile(tile[0], tile[1], way, 2);
        }
        return null;
    }

    public boolean isWall(int tx, int ty) {
        byte bid = this.buildData[ty][tx];
        return bid >= 0 && bid != -128 && this.buildHeight[bid] > 16;
    }

    public boolean isEyeBlock(int tx, int ty) {
        if (!this.isLegalityTile(tx, ty)) {
            return true;
        }
        boolean block = false;
        try {
            block = this.block[ty][tx];
        }
        catch (Exception ex) {
            // empty catch block
        }
        return this.buildData[ty][tx] >= 0;
    }

    private void drawBuild(Graphics g, DirectGraphics dg, int x, int y, int id) {
        ++buildNums;
        if (id >= 0 && id != 4) {
            g.drawImage(this.imaBuild[id], x - this.buildBaseX[id], y - this.buildBaseY[id], 0);
        } else if (id < 0) {
            this.drawRole(g, (byte)Math.abs(id), (byte)0, (short)0);
        }
    }

    public int getIndex(int rx, int ry) {
        return ry * this.mapWidth + rx;
    }

    private void drawGroundImage(Graphics g, DirectGraphics dg, int x, int y, int gID) {
        if (gID >= this.groundLength) {
            return;
        }
        byte resId = this.groundId[gID];
        try {
            if (resId < this.groundLength) {
                int row = resId / this.bgRow;
                int col = resId % this.bgRow;
                g.setClip(x, y, (int)this.tileWidth, 15);
                g.drawImage(this.bgRes, x + -col * this.tileWidth, y + -row * 15, 0);
                g.setClip(0, 0, 176, 208);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void destoryRes() {
        this.groundBlock = null;
        this.groundId = null;
        this.groundRotate = null;
        this.imaBuild = null;
        this.buildOffBaseX = null;
        this.buildOffBaseY = null;
        this.buildBaseX = null;
        this.buildBaseY = null;
        this.buildBlock = null;
        this.buildTileW = null;
        this.buildTileH = null;
        this.buildHeight = null;
        this.imaGounds = null;
    }

    public void destoryData() {
        this.bomC4 = null;
        this.imaSmall = null;
        this.imaGroundBuf = null;
        this.gbg = null;
        this.mapF = null;
        this.mapInfo = null;
        this.roleData = null;
        this.buildData = null;
        this.block = null;
        this.mapData = null;
        this.bArrayRegion = null;
        Enumeration e = npcs.keys();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            Role role = (Role)npcs.get(o);
            if (role.actor == null) continue;
            role.actor.destory();
        }
    }

    public int getMapBgWidth() {
        return this.mapWidth * (this.tileWidth / 2) + this.mapHeight * (this.tileWidth / 2);
    }

    public int getMapBgHeight() {
        return this.mapWidth * (this.tileHeight / 2) + this.mapHeight * (this.tileHeight / 2);
    }

    public void mapBuffer() throws Exception {
        this.imaGroundBuf = null;
        this.imaGroundBuf = Image.createImage((int)this.getMapBgWidth(), (int)this.getMapBgHeight());
        Graphics g = this.imaGroundBuf.getGraphics();
        g.setColor(3865);
        g.fillRect(0, 0, this.imaGroundBuf.getWidth(), this.imaGroundBuf.getHeight());
        int x = 0;
        int y = 0;
        int hTw = this.tileWidth / 2;
        int hTh = this.tileHeight / 2;
        int sx = this.mapWidth * hTw - hTw;
        for (int a = 0; a < this.mapHeight; ++a) {
            int tx = sx + x + a * hTw;
            int ty = y + a * hTh;
            for (int b = this.mapWidth - 1; b >= 0; --b) {
                byte gid = this.mapData[a][b];
                if (gid >= 0) {
                    this.drawGroundImage(g, null, tx, ty, gid);
                }
                tx -= hTw;
                ty += hTh;
            }
        }
    }

    public void creatSmallMap() {
        Image tmp;
        this.imaSmall = tmp = Image.createImage((int)(this.mapWidth * 2), (int)(this.mapHeight * 2));
        this.refurshSmallMap();
    }

    public void refurshSmallMap() {
        if (this.imaSmall == null) {
            return;
        }
        Graphics g = this.imaSmall.getGraphics();
        g.setColor(0x292929);
        g.fillRect(0, 0, this.imaSmall.getWidth(), this.imaSmall.getHeight());
        for (int i = 0; i < this.mapHeight; ++i) {
            int x = 0;
            int y = i * 2;
            for (int j = 0; j < this.mapWidth; ++j) {
                if (this.block[i][j]) {
                    g.setColor(0xC5C2C2);
                    g.fillRect(x, y, 2, 2);
                }
                x += 2;
            }
        }
    }

    public static final byte[] readData(DataInputStream dis, int length) throws Exception {
        byte[] data = new byte[length];
        dis.read(data, 0, length);
        return data;
    }

    public Vector getPath(int beginX, int beginY, int endX, int endY) {
        this.beginX = (byte)beginX;
        this.beginY = (byte)beginY;
        this.endX = (byte)endX;
        this.endY = (byte)endY;
        this.startFind();
        return this.beginFindWay();
    }

    private void startFind() {
        int j;
        int i;
        this.isNoWay = false;
        this.isFinding = false;
        this.openListIndex = 0;
        this.closeListIndex = 0;
        this.openList.removeAllElements();
        this.closeList.removeAllElements();
        for (i = 0; i < this.mapWidth; ++i) {
            for (j = 0; j < this.mapHeight; ++j) {
                this.mapF[i][j] = 0;
                for (int k = 0; k < 5; ++k) {
                    this.mapInfo[i][j][k] = 0;
                }
            }
        }
        for (i = 0; i < this.mapHeight; ++i) {
            for (j = 0; j < this.mapWidth; ++j) {
                this.mapInfo[j][i][0] = (byte)j;
                this.mapInfo[j][i][1] = (byte)i;
                this.mapInfo[j][i][2] = (byte)(Math.abs(i - this.beginY) + Math.abs(j - this.beginX));
                this.mapInfo[j][i][3] = (byte)(Math.abs(i - this.endY) + Math.abs(j - this.endX));
                this.mapInfo[j][i][4] = 1;
                this.mapF[j][i] = this.mapInfo[j][i][2] + this.mapInfo[j][i][3];
            }
        }
    }

    private Vector beginFindWay() {
        this.mapInfo[this.beginX][this.beginY][2] = 0;
        this.addInCloseList(this.beginX, this.beginY);
        byte[] xf = new byte[]{1, -1, 0, 0};
        byte[] yf = new byte[]{0, 0, 1, -1};
        for (int i = 0; i < 4; ++i) {
            if (this.isBlock((byte)(this.beginX + xf[i]), (byte)(this.beginY + yf[i]), true, true)) continue;
            this.addInOpenList((byte)(this.beginX + xf[i]), (byte)(this.beginY + yf[i]));
            this.setFather((byte)(this.beginX + xf[i]), (byte)(this.beginY + yf[i]), this.beginX, this.beginY);
            this.setGHF((byte)(this.beginX + xf[i]), (byte)(this.beginY + yf[i]));
        }
        this.isFinding = true;
        while (this.isFinding) {
            this.findWay();
        }
        Vector<byte[]> v = new Vector<byte[]>();
        if (!this.isNoWay) {
            byte[] a = new byte[]{this.endX, this.endY};
            v.addElement(a);
            byte fx = this.mapInfo[this.endX][this.endY][0];
            byte fy = this.mapInfo[this.endX][this.endY][1];
            do {
                if (fx == this.beginX && fy == this.beginY) {
                    return v;
                }
                byte[] tmp = new byte[]{fx, fy};
                v.addElement(tmp);
                fx = this.mapInfo[tmp[0]][tmp[1]][0];
                fy = this.mapInfo[tmp[0]][tmp[1]][1];
            } while (fx != this.beginX || fy != this.beginY);
            return v;
        }
        return null;
    }

    private void findWay() {
        if (this.openList.size() == 0) {
            this.isFinding = false;
            this.isNoWay = true;
            return;
        }
        int minFIndex = -1;
        byte x = -1;
        byte y = -1;
        minFIndex = this.getMinF();
        byte[] tmp = (byte[])this.openList.elementAt(minFIndex);
        x = tmp[0];
        y = tmp[1];
        this.addInCloseList(x, y);
        this.removeFromOpenList(x, y);
        byte[] xf = new byte[]{1, -1, 0, 0};
        byte[] yf = new byte[]{0, 0, 1, -1};
        for (int i = 0; i < 4; ++i) {
            if (this.isBlock((byte)(x + xf[i]), (byte)(y + yf[i]), true, true) || this.isInCloseList((byte)(x + xf[i]), (byte)(y + yf[i]))) continue;
            if (this.isInOpenList((byte)(x + xf[i]), (byte)(y + yf[i]))) {
                if (this.mapInfo[x + xf[i]][y + yf[i]][2] <= this.getG(x, y) + this.mapInfo[x + xf[i]][y + yf[i]][4]) continue;
                this.setFather((byte)(x + xf[i]), (byte)(y + yf[i]), x, y);
                this.setGHF((byte)(x + xf[i]), (byte)(y + yf[i]));
                continue;
            }
            this.addInOpenList((byte)(x + xf[i]), (byte)(y + yf[i]));
            this.setFather((byte)(x + xf[i]), (byte)(y + yf[i]), x, y);
            if (x + xf[i] == this.endX && y + yf[i] == this.endY || x == this.endX && y == this.endY) {
                this.isFinding = false;
                return;
            }
            this.setGHF((byte)(x + xf[i]), (byte)(y + yf[i]));
        }
    }

    private int getMinF() {
        byte[] tmp = (byte[])this.openList.elementAt(0);
        int num = this.mapF[tmp[0]][tmp[1]];
        int index = 0;
        for (int i = 0; i < this.openListIndex; ++i) {
            tmp = (byte[])this.openList.elementAt(i);
            if (num <= this.mapF[tmp[0]][tmp[1]]) continue;
            num = this.mapF[tmp[0]][tmp[1]];
            index = i;
        }
        return index;
    }

    private void removeFromOpenList(byte x, byte y) {
        for (int i = 0; i < this.openListIndex; ++i) {
            byte[] tmp = (byte[])this.openList.elementAt(i);
            if (tmp[0] != x || tmp[1] != y) continue;
            this.openList.removeElementAt(i);
            --this.openListIndex;
            break;
        }
    }

    private boolean isInOpenList(byte x, byte y) {
        for (int i = 0; i < this.openListIndex; ++i) {
            byte[] tmp = (byte[])this.openList.elementAt(i);
            if (tmp[0] != x || tmp[1] != y) continue;
            return true;
        }
        return false;
    }

    private boolean isInCloseList(byte x, byte y) {
        for (int i = 0; i < this.closeListIndex; ++i) {
            byte[] tmp = (byte[])this.closeList.elementAt(i);
            if (tmp[0] != x || tmp[1] != y) continue;
            return true;
        }
        return false;
    }

    private void addInOpenList(byte x, byte y) {
        byte[] tmp = new byte[]{x, y};
        this.openList.addElement(tmp);
        ++this.openListIndex;
    }

    private void addInCloseList(byte x, byte y) {
        byte[] tmp = new byte[]{x, y};
        this.closeList.addElement(tmp);
        ++this.closeListIndex;
    }

    private void setFather(byte x, byte y, byte fx, byte fy) {
        this.mapInfo[x][y][0] = fx;
        this.mapInfo[x][y][1] = fy;
    }

    private byte getH(byte x, byte y) {
        return (byte)(Math.abs(x - this.endX) + Math.abs(y - this.endY));
    }

    private byte getG(byte x, byte y) {
        return (byte)(this.mapInfo[this.mapInfo[x][y][0]][this.mapInfo[x][y][1]][2] + this.mapInfo[x][y][4]);
    }

    private int getF(int x, int y) {
        return this.mapInfo[x][y][2] + this.mapInfo[x][y][3];
    }

    private void countBuildBlock(int rtx, int rty, int id) {
        int baseY = rty += this.buildOffBaseY[id];
        int baseX = rtx -= this.buildOffBaseX[id];
        int tw = this.buildTileW[id];
        int th = this.buildTileH[id];
        int tx = baseX;
        int ty = baseY;
        byte[] bBlock = this.buildBlock[id];
        for (int n = 0; n < th; ++n) {
            tx = baseX;
            for (int m = 0; m < tw; ++m) {
                if (tx < 0 || ty < 0 || tx >= this.mapWidth || ty >= this.mapHeight) continue;
                byte block = bBlock[n * tw + m];
                this.block[ty][tx] = block == 1;
                ++tx;
            }
            --ty;
        }
        this.refurshSmallMap();
    }

    private void setGHF(byte x, byte y) {
        this.mapInfo[x][y][2] = this.getG(x, y);
        this.mapInfo[x][y][3] = this.getH(x, y);
        this.mapF[x][y] = this.getF(x, y);
    }

    public static void Fake(Exception e) {
        e.toString();
    }

    private void spl(String s) {
        System.out.println(s);
    }
}

