/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Elements {
    private MyCanvas canvas;
    public int xPosition;
    public int yPosition;
    public int width;
    public int height;
    public byte xVel;
    public byte yVel;
    public byte dir;
    public byte stage;
    public byte type;
    public boolean hidden;
    public boolean collided;
    private int length;
    private int rand;
    private boolean isEnd;
    int tempX;
    int tempY;
    int xEnd;
    int yEnd;
    int angle;
    private byte frame = 0;
    Elements elements;
    int distX;
    int distY;

    public Elements(int xPosition, int yPosition, int width, int height, int xVel, int yVel, boolean hidden, int type, MyCanvas canvas) {
        this.canvas = canvas;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.xVel = (byte)xVel;
        this.yVel = (byte)yVel;
        this.hidden = hidden;
        this.type = (byte)type;
    }

    public void draw(Graphics g) {
        try {
            switch (this.type) {
                case 0: {
                    this.length = 40;
                    this.tempX = this.xPosition;
                    this.tempY = this.yPosition - this.length;
                    this.angle = this.angle == 0 ? 85 : this.angle;
                    this.xEnd = this.tempX + this.length * MyCanvas.cos(this.angle) / 255;
                    this.yEnd = this.tempY + this.length * MyCanvas.sin(this.angle) / 255;
                    if (this.collided && this.canvas.hero.action == 8) {
                        this.canvas.hero.xPosition = this.xEnd;
                        this.canvas.hero.yPosition = this.yEnd;
                        this.angle -= 8 * this.xVel;
                        if (this.angle > 135) {
                            this.angle = 135;
                            this.xVel = (byte)(this.xVel * -1);
                        } else if (this.angle < 45) {
                            this.angle = 45;
                            this.xVel = (byte)(this.xVel * -1);
                        }
                        this.canvas.hero.frame = this.angle < 90 ? (byte)(this.canvas.hero.dir == 1 ? 1 : 2) : (this.angle > 100 ? (byte)(this.canvas.hero.dir == 1 ? 2 : 1) : (byte)0);
                    } else {
                        this.angle -= this.xVel;
                        if (this.angle > 95) {
                            this.angle = 95;
                            this.xVel = (byte)(this.xVel * -1);
                        } else if (this.angle < 85) {
                            this.angle = 85;
                            this.xVel = (byte)(this.xVel * -1);
                        }
                    }
                    g.setStrokeStyle(0);
                    g.setColor(0);
                    g.drawLine(this.tempX - 1, this.tempY, this.xEnd - 1, this.yEnd);
                    g.setColor(9200937);
                    g.drawLine(this.tempX, this.tempY, this.xEnd, this.yEnd);
                    g.setColor(3811353);
                    g.drawLine(this.tempX + 1, this.tempY, this.xEnd + 1, this.yEnd);
                    g.setStrokeStyle(1);
                    g.setColor(4859920);
                    g.drawLine(this.tempX, this.tempY, this.xEnd, this.yEnd);
                    this.rand = MyCanvas.gameLevel == 3 ? (this.frame + 25) * 6 : (this.frame + 24) * 6;
                    g.drawRegion(MyCanvas.effectsImg, (int)MyCanvas.effClip[this.rand + 0], (int)MyCanvas.effClip[this.rand + 1], (int)MyCanvas.effClip[this.rand + 2], (int)MyCanvas.effClip[this.rand + 3], 0, this.xEnd + MyCanvas.effClip[this.rand + 4], this.yEnd + MyCanvas.effClip[this.rand + 5], 0);
                    break;
                }
                case 1: 
                case 16: {
                    this.xPosition += this.xVel;
                    g.drawRegion(MyCanvas.effectsImg, (int)MyCanvas.effClip[0], (int)MyCanvas.effClip[1], (int)MyCanvas.effClip[2], (int)MyCanvas.effClip[3], 0, this.xPosition, this.yPosition, 0);
                    for (int i = 1; i < 4; ++i) {
                        int j = MyCanvas.random(1, 3) * 6;
                        g.drawRegion(MyCanvas.effectsImg, (int)MyCanvas.effClip[j + 0], (int)MyCanvas.effClip[j + 1], (int)MyCanvas.effClip[j + 2], (int)MyCanvas.effClip[j + 3], 0, this.xPosition + (this.xVel < 0 ? 6 * i : -(6 * i)), this.yPosition - 1, 0);
                    }
                    break;
                }
                case 2: {
                    if (!this.isEnd && Math.abs(this.length) < MyCanvas.canvasWidth >> 1) {
                        this.xPosition += this.xVel;
                        this.length += this.xVel;
                    } else {
                        this.isEnd = true;
                        this.xPosition -= this.xVel;
                        this.length -= this.xVel;
                        if (this.xVel < 0 && this.length > 15 || this.xVel > 0 && this.length < -15) {
                            this.hidden = true;
                        }
                    }
                    this.rand = (this.frame + 5) * 6;
                    g.drawRegion(MyCanvas.effectsImg, (int)MyCanvas.effClip[this.rand + 0], (int)MyCanvas.effClip[this.rand + 1], (int)MyCanvas.effClip[this.rand + 2], (int)MyCanvas.effClip[this.rand + 3], 0, this.xPosition + MyCanvas.effClip[this.rand + 4], this.yPosition + MyCanvas.effClip[this.rand + 5], 0);
                    this.frame = this.frame < 2 ? (this.frame = (byte)(this.frame + 1)) : (byte)0;
                    break;
                }
                case 3: {
                    int ht = 50;
                    if (!this.isEnd) {
                        this.dir = (byte)(this.xVel < 0 ? -1 : 1);
                        this.xEnd = this.canvas.hero.xPosition + (this.dir < 0 ? this.width * 2 : -this.width);
                        this.yEnd = this.yPosition;
                        this.length = Math.abs(this.xPosition - this.xEnd);
                        this.length >>= 1;
                        if (this.length < 15) {
                            this.length = 15;
                        }
                        ht = this.length >> 1;
                        this.tempX = this.xPosition + (this.dir < 0 ? -this.length : this.length);
                        this.tempY = this.yPosition;
                        this.angle = this.dir < 0 ? this.length : -this.length;
                        this.isEnd = true;
                        this.distX = this.canvas.hero.xPosition + (this.dir < 0 ? this.width : 0);
                        this.distY = this.yPosition + this.canvas.hero.height;
                        this.getDirectionAndVelocity(this.xEnd, this.yEnd, this.distX, this.distY, 3);
                        this.xEnd = this.xPosition;
                    }
                    switch (this.stage) {
                        case 0: {
                            this.tempX += this.xPosition - this.xEnd;
                            this.tempY += this.yPosition - this.yEnd;
                            this.xPosition = this.angle + this.tempX;
                            this.yPosition = ht * this.angle * this.angle / (this.length * this.length) + this.tempY - ht;
                            if (this.dir == -1) {
                                this.angle -= 5;
                                if (this.angle >= -this.length) break;
                                this.stage = 1;
                                break;
                            }
                            this.angle += 5;
                            if (this.angle <= this.length) break;
                            this.stage = 1;
                            break;
                        }
                        case 1: {
                            if (this.collided) break;
                            this.xPosition += this.xVel;
                            this.yPosition += this.yVel;
                        }
                    }
                    this.rand = MyCanvas.random(1, 3) * 6;
                    g.drawRegion(MyCanvas.effectsImg, (int)MyCanvas.effClip[this.rand + 0], (int)MyCanvas.effClip[this.rand + 1], (int)MyCanvas.effClip[this.rand + 2], (int)MyCanvas.effClip[this.rand + 3], 0, this.xEnd, this.yEnd, 0);
                    this.xEnd = this.xPosition;
                    this.yEnd = this.yPosition;
                    if (this.collided) {
                        this.canvas.playSound(10);
                        this.canvas.vectorElement.addElement(new Elements(this.xPosition - 12, this.yPosition - 12, 10, 30, 0, 0, false, 4, this.canvas));
                        this.hidden = true;
                        break;
                    }
                    this.rand = (this.frame + 8) * 6;
                    g.drawRegion(MyCanvas.effectsImg, (int)MyCanvas.effClip[this.rand + 0], (int)MyCanvas.effClip[this.rand + 1], (int)MyCanvas.effClip[this.rand + 2], (int)MyCanvas.effClip[this.rand + 3], 0, this.xPosition, this.yPosition, 0);
                    this.frame = 0;
                    break;
                }
                case 4: {
                    if (this.frame == 3) {
                        this.hidden = true;
                    }
                    this.rand = (this.frame + 9) * 6;
                    g.drawRegion(MyCanvas.effectsImg, (int)MyCanvas.effClip[this.rand + 0], (int)MyCanvas.effClip[this.rand + 1], (int)MyCanvas.effClip[this.rand + 2], (int)MyCanvas.effClip[this.rand + 3], 0, this.xPosition - (MyCanvas.effClip[this.rand + 2] >> 1), this.yPosition, 0);
                    g.drawRegion(MyCanvas.effectsImg, (int)MyCanvas.effClip[this.rand + 0], (int)MyCanvas.effClip[this.rand + 1], (int)MyCanvas.effClip[this.rand + 2], (int)MyCanvas.effClip[this.rand + 3], 0, this.xPosition, this.yPosition - (MyCanvas.effClip[this.rand + 3] >> 1), 0);
                    g.drawRegion(MyCanvas.effectsImg, (int)MyCanvas.effClip[this.rand + 0], (int)MyCanvas.effClip[this.rand + 1], (int)MyCanvas.effClip[this.rand + 2], (int)MyCanvas.effClip[this.rand + 3], 0, this.xPosition + (MyCanvas.effClip[this.rand + 2] >> 1), this.yPosition, 0);
                    this.frame = (byte)(this.frame + 1);
                    break;
                }
                case 5: {
                    if (this.frame == 3) {
                        this.hidden = true;
                    }
                    this.rand = (this.frame + 5) * 6;
                    g.drawRegion(MyCanvas.obsEleImg, (int)MyCanvas.obsEleClip[this.rand + 0], (int)MyCanvas.obsEleClip[this.rand + 1], (int)MyCanvas.obsEleClip[this.rand + 2], (int)MyCanvas.obsEleClip[this.rand + 3], 0, this.xPosition + MyCanvas.obsEleClip[this.rand + 4], this.yPosition + MyCanvas.obsEleClip[this.rand + 5], 0);
                    this.frame = (byte)(this.frame + 1);
                    break;
                }
                case 6: {
                    this.xPosition += this.xVel;
                    this.length += this.xVel;
                    this.rand = (this.frame + 9) * 6;
                    g.drawRegion(MyCanvas.obsEleImg, (int)MyCanvas.obsEleClip[this.rand + 0], (int)MyCanvas.obsEleClip[this.rand + 1], (int)MyCanvas.obsEleClip[this.rand + 2], (int)MyCanvas.obsEleClip[this.rand + 3], 0, this.xPosition, this.yPosition, 0);
                    byte by = this.frame = this.frame < 2 ? (this.frame = (byte)(this.frame + 1)) : (byte)0;
                    if (Math.abs(this.length) <= 60 && !this.collided) break;
                    this.canvas.vectorElement.addElement(new Elements(this.xPosition - 12, this.yPosition - 12, 10, 30, 0, 0, false, 4, this.canvas));
                    this.hidden = true;
                    break;
                }
                case 7: {
                    this.rand = 0;
                    g.drawRegion(MyCanvas.obsEleImg, (int)MyCanvas.obsEleClip[this.rand + 0], (int)MyCanvas.obsEleClip[this.rand + 1], (int)MyCanvas.obsEleClip[this.rand + 2], (int)MyCanvas.obsEleClip[this.rand + 3], 0, this.xPosition, this.yPosition, 0);
                    this.rand = this.frame * 6;
                    if (this.frame != 0) {
                        g.drawRegion(MyCanvas.obsEleImg, (int)MyCanvas.obsEleClip[this.rand + 0], (int)MyCanvas.obsEleClip[this.rand + 1], (int)MyCanvas.obsEleClip[this.rand + 2], (int)MyCanvas.obsEleClip[this.rand + 3], 0, this.xPosition + MyCanvas.obsEleClip[this.rand + 4], this.yPosition + MyCanvas.obsEleClip[this.rand + 5], 0);
                    }
                    if (this.length > 25) {
                        byte by = this.frame = this.frame < 4 ? (this.frame = (byte)(this.frame + 1)) : (byte)0;
                        if (this.frame == 0) {
                            this.length = 0;
                        }
                    }
                    ++this.length;
                    break;
                }
                case 9: {
                    this.rand = this.collided ? 108 : (16 + this.xVel) * 6;
                    g.drawRegion(MyCanvas.obsEleImg, (int)MyCanvas.obsEleClip[this.rand + 0], (int)MyCanvas.obsEleClip[this.rand + 1], (int)MyCanvas.obsEleClip[this.rand + 2], (int)MyCanvas.obsEleClip[this.rand + 3], MyCanvas.random(0, 7), this.xPosition + MyCanvas.obsEleClip[this.rand + 4], this.yPosition + MyCanvas.obsEleClip[this.rand + 5], 0);
                    this.yPosition += this.yVel;
                    if (!this.collided) break;
                    this.hidden = true;
                    break;
                }
                case 10: {
                    for (int i = 0; i < this.width / 2; ++i) {
                        this.rand = (13 + MyCanvas.random(0, 2)) * 6;
                        g.drawRegion(MyCanvas.effectsImg, (int)MyCanvas.effClip[this.rand + 0], (int)MyCanvas.effClip[this.rand + 1], (int)MyCanvas.effClip[this.rand + 2], (int)MyCanvas.effClip[this.rand + 3], 0, this.xPosition + MyCanvas.effClip[this.rand + 4] + MyCanvas.random(0, this.width), this.yPosition + MyCanvas.effClip[this.rand + 5] + MyCanvas.random(0, this.height), 0);
                    }
                    ++this.length;
                    if (this.length <= 16) break;
                    this.hidden = true;
                    break;
                }
                case 11: {
                    this.rand = (16 + this.length % 3) * 6;
                    g.drawRegion(MyCanvas.effectsImg, (int)MyCanvas.effClip[this.rand + 0], (int)MyCanvas.effClip[this.rand + 1], (int)MyCanvas.effClip[this.rand + 2], (int)MyCanvas.effClip[this.rand + 3], 0, this.xPosition + MyCanvas.effClip[this.rand + 4], this.yPosition + MyCanvas.effClip[this.rand + 5], 0);
                    ++this.length;
                    if (this.length > 10) {
                        this.hidden = true;
                        break;
                    }
                    if (this.length != 1 || this.hidden) break;
                    this.canvas.score += 50;
                    break;
                }
                case 12: {
                    this.rand = 120;
                    g.drawRegion(MyCanvas.effectsImg, (int)MyCanvas.effClip[this.rand + 0], (int)MyCanvas.effClip[this.rand + 1], (int)MyCanvas.effClip[this.rand + 2], (int)MyCanvas.effClip[this.rand + 3], 0, this.xPosition + MyCanvas.effClip[this.rand + 4], this.yPosition + MyCanvas.effClip[this.rand + 5], 0);
                    ++this.length;
                    if (this.length <= 20) break;
                    this.hidden = true;
                    break;
                }
                case 13: {
                    this.rand = (21 + this.frame) * 6;
                    if (this.xVel == 0 || this.xVel == 1) {
                        g.drawRegion(MyCanvas.effectsImg, (int)MyCanvas.effClip[this.rand + 0], (int)MyCanvas.effClip[this.rand + 1], (int)MyCanvas.effClip[this.rand + 2], (int)MyCanvas.effClip[this.rand + 3], 0, this.xPosition + MyCanvas.effClip[this.rand + 4], this.yPosition + MyCanvas.effClip[this.rand + 5], 10);
                    }
                    if (this.xVel == 0 || this.xVel == -1) {
                        g.drawRegion(MyCanvas.effectsImg, (int)MyCanvas.effClip[this.rand + 0], (int)MyCanvas.effClip[this.rand + 1], (int)MyCanvas.effClip[this.rand + 2], (int)MyCanvas.effClip[this.rand + 3], 2, this.xPosition + MyCanvas.effClip[this.rand + 4], this.yPosition + MyCanvas.effClip[this.rand + 5], 6);
                    }
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame <= 2) break;
                    this.hidden = true;
                    break;
                }
                case 14: {
                    this.rand = (MyCanvas.gameLevel == 4 ? 25 : 19) * 6;
                    g.drawRegion(MyCanvas.obsEleImg, (int)MyCanvas.obsEleClip[this.rand + 0], (int)MyCanvas.obsEleClip[this.rand + 1], (int)MyCanvas.obsEleClip[this.rand + 2], (int)MyCanvas.obsEleClip[this.rand + 3], 0, this.xPosition + MyCanvas.obsEleClip[this.rand + 4], this.yPosition + MyCanvas.obsEleClip[this.rand + 5], 0);
                    this.yVel = this.yVel < 10 ? (this.yVel = (byte)(this.yVel + 1)) : this.yVel;
                    this.yPosition += this.yVel;
                    this.hidden = this.yPosition > MyCanvas.canvasHeight;
                    break;
                }
                case 15: {
                    this.xPosition += this.xVel;
                    this.rand = (this.frame + 5) * 6;
                    g.drawRegion(MyCanvas.effectsImg, (int)MyCanvas.effClip[this.rand + 0], (int)MyCanvas.effClip[this.rand + 1], (int)MyCanvas.effClip[this.rand + 2], (int)MyCanvas.effClip[this.rand + 3], 0, this.xPosition + MyCanvas.effClip[this.rand + 4], this.yPosition + MyCanvas.effClip[this.rand + 5], 0);
                    this.frame = this.frame < 2 ? (this.frame = (byte)(this.frame + 1)) : (byte)0;
                    break;
                }
                case 17: {
                    if (this.collided) {
                        this.frame = (byte)MyCanvas.random(1, 3);
                        ++this.length;
                        this.canvas.vectorElement.addElement(new Elements(this.xPosition + (this.xVel < 0 ? -this.length * 7 : this.length * 7), this.yPosition, 7, 7, 0, 0, false, 18, this.canvas));
                        if (this.length > 4) {
                            this.hidden = true;
                        }
                    } else {
                        this.xPosition += this.xVel;
                        this.yPosition += this.yVel;
                        this.frame = 0;
                    }
                    this.rand = (this.frame + 26) * 6;
                    g.drawRegion(MyCanvas.obsEleImg, (int)MyCanvas.obsEleClip[this.rand + 0], (int)MyCanvas.obsEleClip[this.rand + 1], (int)MyCanvas.obsEleClip[this.rand + 2], (int)MyCanvas.obsEleClip[this.rand + 3], this.xVel < 0 ? 0 : 2, this.xPosition + MyCanvas.obsEleClip[this.rand + 4], this.yPosition + MyCanvas.obsEleClip[this.rand + 5], 0);
                    break;
                }
                case 18: {
                    this.frame = this.frame > 2 ? (byte)1 : (this.frame = (byte)(this.frame + 1));
                    ++this.length;
                    if (this.length > 4) {
                        this.hidden = true;
                    }
                    this.rand = (this.frame + 26) * 6;
                    g.drawRegion(MyCanvas.obsEleImg, (int)MyCanvas.obsEleClip[this.rand + 0], (int)MyCanvas.obsEleClip[this.rand + 1], (int)MyCanvas.obsEleClip[this.rand + 2], (int)MyCanvas.obsEleClip[this.rand + 3], this.xVel < 0 ? 0 : 2, this.xPosition + MyCanvas.obsEleClip[this.rand + 4], this.yPosition + MyCanvas.obsEleClip[this.rand + 5], 0);
                    break;
                }
                case 21: {
                    if (this.frame == 3) {
                        this.hidden = true;
                    }
                    this.rand = (this.frame + 9) * 6;
                    g.drawRegion(MyCanvas.effectsImg, (int)MyCanvas.effClip[this.rand + 0], (int)MyCanvas.effClip[this.rand + 1], (int)MyCanvas.effClip[this.rand + 2], (int)MyCanvas.effClip[this.rand + 3], 0, this.xPosition, this.yPosition, 0);
                    this.frame = (byte)(this.frame + 1);
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in Elements draw " + this.type + " type>>" + e);
        }
        if (this.type != 2 && !this.canvas.isInView(this.xPosition, this.yPosition, this.width, this.height)) {
            this.hidden = true;
        }
        this.checkCollison();
    }

    private void checkCollison() {
        try {
            switch (this.type) {
                case 1: {
                    if (this.hidden || !MyCanvas.intersectsOfSprites(this.xPosition, this.yPosition, this.width, this.height, this.canvas.hero.xPosition, this.canvas.hero.yPosition, this.canvas.hero.width, this.canvas.hero.height) || this.canvas.hero.action == 4) break;
                    this.canvas.hero.isHit = true;
                    this.hidden = true;
                    break;
                }
                case 2: {
                    if (!this.hidden) {
                        for (int i = 0; i < this.canvas.vectorEnemy.size(); ++i) {
                            Enemy enemy = (Enemy)this.canvas.vectorEnemy.elementAt(i);
                            if (enemy.type != 5 || !MyCanvas.intersectsOfSprites(this.xPosition, this.yPosition, this.width, this.height, enemy.xPosition, enemy.yPosition, enemy.width, enemy.height)) continue;
                            enemy.isEnd = true;
                            this.hidden = true;
                        }
                    }
                }
                case 15: {
                    if (this.hidden || !MyCanvas.intersectsOfSprites(this.xPosition + 5, this.yPosition, this.width / 2, this.height, this.canvas.hero.xPosition, this.canvas.hero.yPosition + (this.canvas.hero.action == 4 ? this.canvas.hero.height / 2 : 0), this.canvas.hero.width, this.canvas.hero.height / (this.canvas.hero.action == 4 ? 2 : 1))) break;
                    if (this.canvas.hero.action >= 11 && this.canvas.hero.action <= 15) {
                        this.hidden = true;
                        this.canvas.vectorElementTopLayer.addElement(new Elements(this.canvas.hero.xPosition + (this.canvas.hero.dir == 1 ? 34 : -5), this.canvas.hero.yPosition + 15, this.width, this.height, 0, 0, false, 13, this.canvas));
                        break;
                    }
                    this.canvas.hero.isHit = true;
                    this.hidden = true;
                    break;
                }
                case 3: {
                    if (this.hidden || this.collided || !MyCanvas.intersectsOfSprites(this.xPosition, this.yPosition, this.width, this.height, this.canvas.hero.xPosition, this.canvas.hero.yPosition + (this.canvas.hero.action == 4 ? this.canvas.hero.height / 2 : 0), this.canvas.hero.width, this.canvas.hero.height / (this.canvas.hero.action == 4 ? 2 : 1))) break;
                    this.canvas.hero.isHit = true;
                    this.canvas.life -= 10;
                    this.collided = true;
                    break;
                }
                case 16: {
                    if (this.hidden) break;
                    for (int i = 0; i < this.canvas.vectorEnemy.size(); ++i) {
                        Enemy enemy = (Enemy)this.canvas.vectorEnemy.elementAt(i);
                        if (enemy.isDead || !MyCanvas.intersectsOfSprites(this.xPosition, this.yPosition, this.width, this.height, enemy.xPosition, enemy.yPosition, enemy.width, enemy.height)) continue;
                        enemy.isDead = true;
                        this.canvas.score += 100;
                        this.hidden = true;
                        this.canvas.vectorElementTopLayer.addElement(new Elements(enemy.xPosition + (enemy.width >> 1), this.yPosition, 0, 0, this.xVel < 0 ? -1 : 1, 0, false, 13, this.canvas));
                    }
                    break;
                }
                case 4: {
                    if (this.hidden) break;
                    for (int i = 0; i < this.canvas.vectorEnemy.size(); ++i) {
                        Enemy enemy = (Enemy)this.canvas.vectorEnemy.elementAt(i);
                        if (!MyCanvas.intersectsOfSprites(this.xPosition - this.width, this.yPosition, this.width * 4, this.height, enemy.xPosition, enemy.yPosition, enemy.width, enemy.height)) continue;
                        enemy.isDead = true;
                        this.canvas.score += 100;
                    }
                    break;
                }
                case 6: {
                    if (this.hidden) break;
                    for (int i = 0; i < this.canvas.vectorEnemy.size(); ++i) {
                        Enemy enemy = (Enemy)this.canvas.vectorEnemy.elementAt(i);
                        if (!MyCanvas.intersectsOfSprites(this.xPosition, this.yPosition, this.width, this.height, enemy.xPosition + (enemy.width >> 1), enemy.yPosition, 5, enemy.height)) continue;
                        this.collided = true;
                    }
                    break;
                }
                case 7: {
                    if (this.hidden || this.frame != 2 && this.frame != 3 || !MyCanvas.intersectsOfSprites(this.xPosition - (this.width >> 1), this.yPosition, this.width >> 2, this.height, this.canvas.hero.xPosition, this.canvas.hero.yPosition + (this.canvas.hero.action == 4 ? this.canvas.hero.height / 2 : 0), this.canvas.hero.width, this.canvas.hero.height / (this.canvas.hero.action == 4 ? 2 : 1)) || this.canvas.hero.action == 4) break;
                    this.canvas.hero.isHit = true;
                    break;
                }
                case 9: {
                    if (this.hidden || this.collided || !MyCanvas.intersectsOfSprites(this.xPosition, this.yPosition, this.width, this.height, this.canvas.hero.xPosition, this.canvas.hero.yPosition + (this.canvas.hero.action == 4 ? this.canvas.hero.height / 2 : 0), this.canvas.hero.width, this.canvas.hero.height / (this.canvas.hero.action == 4 ? 2 : 1))) break;
                    this.canvas.hero.isHit = true;
                    this.collided = true;
                    break;
                }
                case 17: 
                case 18: {
                    if (this.hidden || !MyCanvas.intersectsOfSprites(this.xPosition, this.yPosition, this.width, this.height, this.canvas.hero.xPosition, this.canvas.hero.yPosition + (this.canvas.hero.action == 4 ? this.canvas.hero.height / 2 : 0), this.canvas.hero.width, this.canvas.hero.height / (this.canvas.hero.action == 4 ? 2 : 1))) break;
                    this.canvas.hero.isHit = true;
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in elements type " + this.type + " checkCollison>>" + e);
        }
    }

    private boolean getDirectionAndVelocity(int currX, int currY, int destX, int destY, int accelaration) {
        boolean retVal = false;
        this.distX = Math.abs(currX - destX);
        this.distY = Math.abs(currY - destY);
        if (this.distX <= Math.abs(this.xVel * accelaration) && this.distY <= Math.abs(this.yVel * accelaration)) {
            return true;
        }
        this.xVel = 0;
        this.yVel = 0;
        if (this.distX == this.distY) {
            this.xVel = this.yVel = (byte)(3 * accelaration);
        } else if (this.distX > this.distY) {
            if (this.distY > this.distX / 10) {
                this.xVel = (byte)(3 * accelaration);
                this.yVel = (byte)(2 * accelaration);
            } else if (this.distY != 0) {
                this.xVel = (byte)(4 * accelaration);
                this.yVel = (byte)(1 * accelaration);
            } else {
                this.xVel = (byte)(4 * accelaration);
                this.yVel = (byte)(0 * accelaration);
            }
        } else if (this.distX > this.distY / 10) {
            this.yVel = (byte)(3 * accelaration);
            this.xVel = (byte)(2 * accelaration);
        } else if (this.distX != 0) {
            this.yVel = (byte)(4 * accelaration);
            this.xVel = (byte)(1 * accelaration);
        } else {
            this.yVel = (byte)(4 * accelaration);
            this.xVel = (byte)(0 * accelaration);
        }
        if (destX >= currX && destY <= currY) {
            this.xVel = (byte)(this.xVel * 1);
            this.yVel = (byte)(this.yVel * -1);
        } else if (destX >= currX && destY >= currY) {
            this.xVel = (byte)(this.xVel * 1);
            this.yVel = (byte)(this.yVel * 1);
        } else if (destX <= currX && destY >= currY) {
            this.xVel = (byte)(this.xVel * -1);
            this.yVel = (byte)(this.yVel * 1);
        } else if (destX <= currX && destY <= currY) {
            this.xVel = (byte)(this.xVel * -1);
            this.yVel = (byte)(this.yVel * -1);
        }
        return retVal;
    }
}

