/*
 * Decompiled with CFR 0.152.
 */
public class FixedPointBasic {
    public final int FIXED_PRECISION;
    public final int FIXED_ONE;
    public final int FIXED_ZERO;
    public final int FIXED_HALF;
    public final int FIXED_QUATER;
    public final int FIXED_MINF = Integer.MIN_VALUE;
    public final int FIXED_PINF = Integer.MAX_VALUE;
    public final int FIXED_EPS;
    public final int FIXED_PI_HALF = this.FixedFromFloat(1.5707964f);
    public final int FIXED_PI = this.FixedFromFloat((float)Math.PI);
    public final int FIXED_2PI = this.FixedFromFloat((float)Math.PI * 2);
    public final int FIXED_R2PI = this.FixedFromFloat(0.15915494f);
    public final int FIXED_90 = this.FixedFromInt(90);
    public final int FIXED_180 = this.FixedFromInt(180);
    public final int FIXED_270 = this.FixedFromInt(270);
    public final int FIXED_360 = this.FixedFromInt(360);
    private static final short[] sqrt_table = new short[]{0, 16, 22, 27, 32, 35, 39, 42, 45, 48, 50, 53, 55, 57, 59, 61, 64, 65, 67, 69, 71, 73, 75, 76, 78, 80, 81, 83, 84, 86, 87, 89, 90, 91, 93, 94, 96, 97, 98, 99, 101, 102, 103, 104, 106, 107, 108, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 128, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 144, 145, 146, 147, 148, 149, 150, 150, 151, 152, 153, 154, 155, 155, 156, 157, 158, 159, 160, 160, 161, 162, 163, 163, 164, 165, 166, 167, 167, 168, 169, 170, 170, 171, 172, 173, 173, 174, 175, 176, 176, 177, 178, 178, 179, 180, 181, 181, 182, 183, 183, 184, 185, 185, 186, 187, 187, 188, 189, 189, 190, 191, 192, 192, 193, 193, 194, 195, 195, 196, 197, 197, 198, 199, 199, 200, 201, 201, 202, 203, 203, 204, 204, 205, 206, 206, 207, 208, 208, 209, 209, 210, 211, 211, 212, 212, 213, 214, 214, 215, 215, 216, 217, 217, 218, 218, 219, 219, 220, 221, 221, 222, 222, 223, 224, 224, 225, 225, 226, 226, 227, 227, 228, 229, 229, 230, 230, 231, 231, 232, 232, 233, 234, 234, 235, 235, 236, 236, 237, 237, 238, 238, 239, 240, 240, 241, 241, 242, 242, 243, 243, 244, 244, 245, 245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 251, 251, 252, 252, 253, 253, 254, 254, 255};
    public final int sk_precision;
    public final int[] SK = new int[]{498, 10882};
    public final int FIXED_SIN_45 = this.Sin(this.degree_to_radian(this.FixedFromInt(45)));
    public final int as_precision;
    public final int[] AS = new int[]{-1228, 4866, 13901, 102939};
    public final int VR_EDGE;
    public final int VR_VERTEX;
    public static final int SHAPE_AARECT = 65536;
    public static final int SHAPE_ROTRECT = 131072;
    public static final int SHAPE_CIRCLE = 262144;
    public static final int SHAPE_AATRI = 524288;

    public FixedPointBasic() {
        this.FIXED_PRECISION = 16;
        this.FIXED_ONE = 65536;
        this.FIXED_ZERO = 0;
        this.FIXED_HALF = 32768;
        this.FIXED_QUATER = 16384;
        this.FIXED_EPS = 4;
        this.sk_precision = 31;
        this.as_precision = 30;
        this.VR_EDGE = 1;
        this.VR_VERTEX = 2;
    }

    public final int FixedFromInt(int aInt) {
        return aInt << 16;
    }

    public final int FixedToInt(int a_fix) {
        return a_fix >> 16;
    }

    public final int FixedFromFloat(float aFloat) {
        return (int)(65536.0f * aFloat);
    }

    public final float FixedToFloat(int aInt) {
        return (float)aInt * 1.5258789E-5f;
    }

    public final void printToFloat(int a_fix) {
        System.out.println(this.FixedToFloat(a_fix));
    }

    public final int Mul(int one_fix, int two_fix) {
        return (int)((long)one_fix * (long)two_fix >> 16);
    }

    public final int Div(int one_fix, int two_fix) {
        if (two_fix > Math.abs(4)) {
            return (int)(((long)one_fix << 16) / (long)two_fix);
        }
        return 0;
    }

    private final int fastSqrt(int x) {
        if (x >= 65536) {
            if (x >= 0x1000000) {
                if (x >= 0x10000000) {
                    if (x >= 0x40000000) {
                        return sqrt_table[x >> 24] << 8;
                    }
                    return sqrt_table[x >> 22] << 7;
                }
                if (x >= 0x4000000) {
                    return sqrt_table[x >> 20] << 6;
                }
                return sqrt_table[x >> 18] << 5;
            }
            if (x >= 0x100000) {
                if (x >= 0x400000) {
                    return sqrt_table[x >> 16] << 4;
                }
                return sqrt_table[x >> 14] << 3;
            }
            if (x >= 262144) {
                return sqrt_table[x >> 12] << 2;
            }
            return sqrt_table[x >> 10] << 1;
        }
        if (x >= 256) {
            if (x >= 4096) {
                if (x >= 16384) {
                    return sqrt_table[x >> 8];
                }
                return sqrt_table[x >> 6] >> 1;
            }
            if (x >= 1024) {
                return sqrt_table[x >> 4] >> 2;
            }
            return sqrt_table[x >> 2] >> 3;
        }
        if (x >= 0) {
            return sqrt_table[x] >> 4;
        }
        return -1;
    }

    public final int SqrtRound(int x_fix) {
        return this.fastSqrt(x_fix >> 16) << 16;
    }

    public final int Sqrt(int a_fix) {
        int s_fixed = a_fix + 65536 >> 1;
        int i = 8;
        while (--i >= 0) {
            s_fixed = s_fixed + this.Div(a_fix, s_fixed) >> 1;
        }
        return s_fixed;
    }

    public final int Abs(int a_fix) {
        return a_fix < 0 ? -a_fix : a_fix;
    }

    public final int Round(int a_fix) {
        return a_fix + 32768 >> 16;
    }

    public final int Nearest(int a_fix) {
        return this.Truncate(a_fix + 32768);
    }

    public final int Truncate(int a_fix) {
        return a_fix & 0xFFFF0000;
    }

    public final int Fraction(int a_fix) {
        return a_fix & 0x8000FFFF;
    }

    public final int Min(int one_fix, int two_fix) {
        return one_fix < two_fix ? one_fix : two_fix;
    }

    public final int Max(int one_fix, int two_fix) {
        return one_fix > two_fix ? one_fix : two_fix;
    }

    public final int degree_to_radian(int degree_fix) {
        return this.Mul(degree_fix, this.Div(this.FIXED_PI, this.FIXED_180));
    }

    public final int radian_to_degree(int radian_fix) {
        return this.Mul(radian_fix, this.Div(this.FIXED_180, this.FIXED_PI));
    }

    public final int Sin(int radians_fix) {
        int sign = 1;
        if ((radians_fix %= this.FIXED_PI << 1) < 0) {
            radians_fix = (this.FIXED_PI << 1) + radians_fix;
        }
        if (radians_fix > this.FIXED_PI_HALF && radians_fix <= this.FIXED_PI) {
            radians_fix = this.FIXED_PI - radians_fix;
        } else if (radians_fix > this.FIXED_PI && radians_fix <= this.FIXED_PI + this.FIXED_PI_HALF) {
            radians_fix -= this.FIXED_PI;
            sign = -1;
        } else if (radians_fix > this.FIXED_PI + this.FIXED_PI_HALF) {
            radians_fix = (this.FIXED_PI << 1) - radians_fix;
            sign = -1;
        }
        int sqr = this.Mul(radians_fix, radians_fix);
        int result = this.SK[0];
        result = this.Mul(result, sqr);
        result -= this.SK[1];
        result = this.Mul(result, sqr);
        result += 65536;
        result = this.Mul(result, radians_fix);
        return sign * result;
    }

    public final int Cos(int radians_fix) {
        return this.Sin(this.FIXED_PI_HALF - radians_fix);
    }

    public final int Tan(int radians_fix) {
        return this.Div(this.Sin(radians_fix), this.Cos(radians_fix));
    }

    public final int ASin(int a_fix) {
        boolean neg = false;
        if (a_fix < 0) {
            neg = true;
            a_fix = -a_fix;
        }
        int fRoot = this.Sqrt(65536 - a_fix);
        int result = this.AS[0];
        result = this.Mul(result, a_fix);
        result += this.AS[1];
        result = this.Mul(result, a_fix);
        result -= this.AS[2];
        result = this.Mul(result, a_fix);
        result += this.AS[3];
        result = this.FIXED_PI_HALF - this.Mul(fRoot, result);
        if (neg) {
            result = -result;
        }
        return result;
    }

    public final int ACos(int f) {
        return this.FIXED_PI_HALF - this.ASin(f);
    }

    public final int ATan(int f) {
        return this.ASin(this.Div(f, this.Sqrt(65536 + this.Mul(f, f))));
    }

    public final int SquareLength(int one_fix, int two_fix) {
        int squared_fix = this.Mul(one_fix, one_fix) + this.Mul(two_fix, two_fix);
        if (squared_fix < this.FixedFromInt(Short.MAX_VALUE) && squared_fix > 0) {
            return squared_fix;
        }
        return this.FixedFromInt(32766);
    }
}

