/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class FixedPointGamePack
extends FixedPointBasic {
    public final int VR_EDGE;
    public final int VR_VERTEX;
    public static final int SHAPE_AARECT = 65536;
    public static final int SHAPE_ROTRECT = 131072;
    public static final int SHAPE_CIRCLE = 262144;
    public static final int SHAPE_AATRI = 524288;

    public FixedPointGamePack() {
        this.VR_EDGE = 1;
        this.VR_VERTEX = 2;
    }

    public final void vec2d_Add(int[] vec_one_fix, int indiceOne, int[] vec_two_fix, int indiceTwo) {
        int n = indiceOne;
        vec_one_fix[n] = vec_one_fix[n] + vec_two_fix[indiceTwo];
        int n2 = indiceOne + 1;
        vec_one_fix[n2] = vec_one_fix[n2] + vec_two_fix[indiceTwo + 1];
    }

    public final void vec2d_Add(int[] vec_one_fix, int indiceOne, int vec_two_X_fix, int vec_two_Y_fix) {
        int n = indiceOne;
        vec_one_fix[n] = vec_one_fix[n] + vec_two_X_fix;
        int n2 = indiceOne + 1;
        vec_one_fix[n2] = vec_one_fix[n2] + vec_two_Y_fix;
    }

    public final void vec2d_Sub(int[] vec_one_fix, int indiceOne, int[] vec_two_fix, int indiceTwo) {
        int n = indiceOne;
        vec_one_fix[n] = vec_one_fix[n] - vec_two_fix[indiceTwo];
        int n2 = indiceOne + 1;
        vec_one_fix[n2] = vec_one_fix[n2] - vec_two_fix[indiceTwo + 1];
    }

    public final void vec2d_Sub(int[] vec_one_fix, int indiceOne, int vec_two_X_fix, int vec_two_Y_fix) {
        int n = indiceOne;
        vec_one_fix[n] = vec_one_fix[n] - vec_two_X_fix;
        int n2 = indiceOne + 1;
        vec_one_fix[n2] = vec_one_fix[n2] - vec_two_Y_fix;
    }

    public final void vec2d_Mul(int[] vec_fix, int indice, int scalar_fix) {
        vec_fix[indice] = this.Mul(vec_fix[indice], scalar_fix);
        vec_fix[indice + 1] = this.Mul(vec_fix[indice + 1], scalar_fix);
    }

    public final void vec2d_Div(int[] vec_fix, int indice, int scalar_fix) {
        vec_fix[indice] = this.Div(vec_fix[indice], scalar_fix);
        vec_fix[indice + 1] = this.Div(vec_fix[indice + 1], scalar_fix);
    }

    public final boolean vec2d_Equal(int[] vecOne_fix, int indiceOne, int[] vecTwo_fix, int indiceTwo) {
        return vecOne_fix[indiceOne] == vecTwo_fix[indiceTwo] || vecOne_fix[indiceOne + 1] == vecTwo_fix[indiceTwo + 1];
    }

    public final void vec2d_SetXY(int[] vec_one_fix, int indiceOne, int[] vec_two_fix, int indiceTwo) {
        vec_one_fix[indiceOne] = vec_two_fix[indiceTwo];
        vec_one_fix[indiceOne + 1] = vec_two_fix[indiceTwo + 1];
    }

    public final void vec2d_SetXY(int[] vec_fix, int indiceVec, int X_fix, int Y_fix) {
        vec_fix[indiceVec] = X_fix;
        vec_fix[indiceVec + 1] = Y_fix;
    }

    public final void vec2d_Normalize(int[] vec_fix, int indiceVec) {
        int length = this.vec2d_GetLength(vec_fix, indiceVec);
        while (length >= this.FIXED_180 || length < 0) {
            this.vec2d_Mul(vec_fix, indiceVec, 32768);
        }
        this.vec2d_Div(vec_fix, indiceVec, this.vec2d_GetLength(vec_fix, indiceVec));
    }

    public final int vec2d_GetLength(int[] vec_fix, int indiceVec) {
        if (vec_fix[indiceVec] == 0 && vec_fix[indiceVec + 1] == 0) {
            return 0;
        }
        int squared_fix = this.SquareLength(vec_fix[indiceVec], vec_fix[indiceVec + 1]);
        return this.Sqrt(squared_fix);
    }

    public final int vec2d_GetLengthRound(int[] vec_fix, int indiceVec) {
        if (vec_fix[indiceVec] == 0 && vec_fix[indiceVec + 1] == 0) {
            return 0;
        }
        int squared_fix = this.SquareLength(vec_fix[indiceVec], vec_fix[indiceVec + 1]);
        return this.SqrtRound(squared_fix);
    }

    public final int vec2d_Dot(int[] vec_one_fix, int indiceOne, int[] vec_two_fix, int indiceTwo) {
        return this.Mul(vec_one_fix[indiceOne], vec_two_fix[indiceTwo]) + this.Mul(vec_one_fix[indiceOne + 1], vec_two_fix[indiceTwo + 1]);
    }

    public final int vec2d_Dot(int[] vec_one_fix, int indiceOne, int vecX_fix, int vecY_fix) {
        return this.Mul(vec_one_fix[indiceOne], vecX_fix) + this.Mul(vec_one_fix[indiceOne + 1], vecY_fix);
    }

    public final int vec2d_Cross(int[] vec_one_fix, int indiceOne, int[] vec_two_fix, int indiceTwo) {
        return this.Mul(vec_one_fix[indiceOne], vec_two_fix[indiceTwo + 1]) - this.Mul(vec_one_fix[indiceOne + 1], vec_two_fix[indiceTwo]);
    }

    public final int vec2d_Cross(int[] vec_one_fix, int indiceOne, int vecX_fix, int vecY_fix) {
        return this.Mul(vec_one_fix[indiceOne], vecY_fix) - this.Mul(vec_one_fix[indiceOne + 1], vecX_fix);
    }

    public final int[] vec2d_Proj(int[] vec_one_fix, int indiceOne, int[] vec_two_fix, int indiceTwo) {
        int dp_fix = this.vec2d_Dot(vec_one_fix, indiceOne, vec_two_fix, indiceTwo);
        int vecTwoLengthSquared = this.vec2d_Dot(vec_one_fix, indiceOne, vec_one_fix, indiceOne);
        int factor = this.Div(dp_fix, vecTwoLengthSquared);
        return new int[]{this.Mul(factor, vec_two_fix[indiceTwo]), this.Mul(factor, vec_two_fix[indiceTwo + 1])};
    }

    public final void vec2d_Rotate(int[] vec_fix, int indiceVec, int degrees_fix) {
        int radians_fix = this.degree_to_radian(degrees_fix);
        int Sin_fix = this.Sin(radians_fix);
        int Cos_fix = this.Cos(radians_fix);
        int vecX_fix = vec_fix[indiceVec];
        int vecY_fix = vec_fix[indiceVec + 1];
        vec_fix[indiceVec] = this.Mul(Cos_fix, vecX_fix) - this.Mul(Sin_fix, vecY_fix);
        vec_fix[indiceVec + 1] = this.Mul(Sin_fix, vecX_fix) + this.Mul(Cos_fix, vecY_fix);
    }

    public final int vec2d_AngleDegreeBetween(int[] vec_one_fix, int indiceOne, int[] vec_two_fix, int indiceTwo) {
        return this.radian_to_degree(this.ACos(this.vec2d_Dot(vec_one_fix, indiceOne, vec_two_fix, indiceTwo)));
    }

    public final void vec2d_Invert(int[] vec_fix, int indiceVec) {
        vec_fix[indiceVec] = -vec_fix[indiceVec];
        vec_fix[indiceVec + 1] = -vec_fix[indiceVec + 1];
    }

    public final int[] vec2d_CopyVector(int[] vec_fix, int indiceVec) {
        return new int[]{vec_fix[indiceVec], vec_fix[indiceVec + 1]};
    }

    public final int[] vec2d_GetUnitVec() {
        return new int[]{65536, 0};
    }

    public final int[] vec2d_GetUnitVecFromDegrees(int degrees_fix) {
        int radians_fix = this.degree_to_radian(degrees_fix);
        return this.vec2d_GetUnitVecFromRadians(radians_fix);
    }

    public final int[] vec2d_GetUnitVecFromRadians(int radians_fix) {
        return new int[]{this.Cos(radians_fix), this.Sin(radians_fix)};
    }

    public final int[] vec2d_GetLHNormalVec(int[] vec_fix, int indiceVec) {
        return new int[]{vec_fix[indiceVec + 1], -vec_fix[indiceVec]};
    }

    public final int[] vec2d_GetRHNormalVec(int[] vec_fix, int indiceVec) {
        return new int[]{-vec_fix[indiceVec + 1], vec_fix[indiceVec]};
    }

    public final void vec2d_SetAsUnitVec(int[] vec_fix, int indiceVec) {
        vec_fix[indiceVec] = 65536;
        vec_fix[indiceVec + 1] = 0;
    }

    public final void vec2d_Repell(int[] n1_fix, int indiceN1, int[] s1_fix, int indiceS1) {
        this.vec2d_Mul(s1_fix, indiceS1, this.Mul(this.vec2d_Dot(n1_fix, indiceN1, s1_fix, indiceS1), this.FixedFromInt(2)));
        this.vec2d_Sub(n1_fix, indiceN1, s1_fix, indiceS1);
        this.vec2d_Normalize(n1_fix, indiceN1);
    }

    public final boolean point2d_IsInsideAARect(int[] point_fix, int pointIndice, int[] aarect_fix, int aarectIndice) {
        int pointX_fix = point_fix[pointIndice];
        int pointY_fix = point_fix[pointIndice + 1];
        int aarectX = aarect_fix[aarectIndice];
        int aarectY = aarect_fix[aarectIndice + 1];
        int aarectWidth = aarect_fix[aarectIndice + 2];
        int aarectHeight = aarect_fix[aarectIndice + 3];
        return pointX_fix >= aarectX - aarectWidth && pointX_fix <= aarectX + aarectWidth && pointY_fix >= aarectY - aarectHeight && pointY_fix <= aarectY + aarectHeight;
    }

    public final boolean point2d_IsInsideRotRect(int[] point_fix, int pointIndice, int[] rotrect_fix, int rotrectIndice) {
        int rotrectX_fix = rotrect_fix[rotrectIndice];
        int rotrectY_fix = rotrect_fix[rotrectIndice + 1];
        int rotrectW_fix = rotrect_fix[rotrectIndice + 2];
        int rotrectH_fix = rotrect_fix[rotrectIndice + 3];
        int[] rotrectAARect = new int[]{rotrectX_fix, rotrectY_fix, this.Max(rotrectW_fix, rotrectH_fix) + (this.Min(rotrectW_fix, rotrectH_fix) >> 1), this.Max(rotrectW_fix, rotrectH_fix) + (this.Min(rotrectW_fix, rotrectH_fix) >> 1)};
        if (!this.point2d_IsInsideAARect(point_fix, pointIndice, rotrectAARect, 0)) {
            return false;
        }
        int[] rotrectCorners = this.rotrect_GetCorners(rotrect_fix, rotrectIndice);
        int[] rotrectXAxis = this.vec2d_CopyVector(rotrectCorners, 2);
        this.vec2d_Sub(rotrectXAxis, 0, rotrectCorners, 4);
        this.vec2d_Normalize(rotrectXAxis, 0);
        int[] toPointVec = this.vec2d_CopyVector(point_fix, pointIndice);
        this.vec2d_Sub(toPointVec, 0, rotrect_fix, rotrectIndice);
        int proj = this.Abs(this.vec2d_Dot(toPointVec, 0, rotrectXAxis, 0));
        if (proj - rotrect_fix[rotrectIndice + 2] > 0) {
            return false;
        }
        int[] rotrectYAxis = this.vec2d_CopyVector(rotrectCorners, 6);
        this.vec2d_Sub(rotrectYAxis, 0, rotrectCorners, 4);
        this.vec2d_Normalize(rotrectYAxis, 0);
        proj = this.Abs(this.vec2d_Dot(toPointVec, 0, rotrectYAxis, 0));
        return proj - rotrect_fix[rotrectIndice + 3] <= 0;
    }

    public final boolean point2d_IsInsideCircle(int[] point_fix, int pointIndice, int[] circle_fix, int circleIndice) {
        int vertDist = circle_fix[circleIndice] - point_fix[pointIndice];
        int horsDist = circle_fix[circleIndice + 1] - point_fix[pointIndice + 1];
        int radius = circle_fix[circleIndice + 2];
        return this.Mul(vertDist, vertDist) + this.Mul(horsDist, horsDist) < this.Mul(radius, radius);
    }

    public final boolean point2d_IsInsideAATri(int[] point_fix, int pointIndice, int[] aatri_fix, int aatriIndice) {
        int aatriWidth = aatri_fix[aatriIndice + 2];
        int aatriHeight = aatri_fix[aatriIndice + 3];
        int[] aatriAARect = new int[]{aatri_fix[aatriIndice] + (aatriWidth >> 1), aatri_fix[aatriIndice + 1] + (aatriHeight >> 1), this.Abs(aatriWidth >> 1), this.Abs(aatriHeight >> 1)};
        if (!this.point2d_IsInsideAARect(point_fix, pointIndice, aatriAARect, 0)) {
            return false;
        }
        int[] vertPoint = this.vec2d_CopyVector(aatri_fix, aatriIndice);
        this.vec2d_Add(vertPoint, 0, 0, aatriHeight);
        int[] horsPoint = this.vec2d_CopyVector(aatri_fix, aatriIndice);
        this.vec2d_Add(horsPoint, 0, aatriWidth, 0);
        this.vec2d_Sub(vertPoint, 0, horsPoint, 0);
        int[] perpenHypoVec = this.vec2d_GetRHNormalVec(vertPoint, 0);
        int[] pointVec = this.vec2d_CopyVector(point_fix, pointIndice);
        this.vec2d_Sub(pointVec, 0, horsPoint, 0);
        int proj = this.vec2d_Dot(pointVec, 0, perpenHypoVec, 0);
        return !(aatriWidth < 0 && aatriHeight > 0 || aatriWidth > 0 && aatriHeight < 0 ? proj > 0 : proj < 0);
    }

    public final int[] point2d_VoronoiRegion_AARect(int[] point_fix, int pointIndice, int[] aarect_fix, int aarectIndice) {
        int[] aarectCorners = this.aarect_GetCorners(aarect_fix, aarectIndice);
        int[] aarectEdgeIndex = new int[]{0, 1, 1, 2, 2, 3, 3, 0};
        int[] aarectVertIndex = new int[]{3, 0, 0, 1, 1, 2, 2, 3};
        return this.voronoi_Check(point_fix, pointIndice, aarectCorners, aarectEdgeIndex, aarectVertIndex);
    }

    public final int[] point2d_VoronoiRegion_RotRect(int[] point_fix, int pointIndice, int[] rotrect_fix, int rotrectIndice) {
        int[] rotrectCorners = this.rotrect_GetCorners(rotrect_fix, rotrectIndice);
        int[] rotrectEdgeIndex = new int[]{0, 1, 1, 2, 2, 3, 3, 0};
        int[] rotrectVertIndex = new int[]{3, 0, 0, 1, 1, 2, 2, 3};
        return this.voronoi_Check(point_fix, pointIndice, rotrectCorners, rotrectEdgeIndex, rotrectVertIndex);
    }

    public final int[] point2d_VoronoiRegion_AATri(int[] point_fix, int pointIndice, int[] aatri_fix, int aatriIndice) {
        int[] aatriCorners = this.aatri_GetCorners(aatri_fix, aatriIndice);
        int[] aatriEdgeIndex = new int[]{0, 1, 1, 2, 2, 0};
        int[] aatriVertIndex = new int[]{2, 0, 0, 1, 1, 2};
        return this.voronoi_Check(point_fix, pointIndice, aatriCorners, aatriEdgeIndex, aatriVertIndex);
    }

    private final int[] voronoi_Check(int[] point_fix, int pointIndice, int[] corners_fix, int[] edgeIndex, int[] vertIndex) {
        int[] toPoint;
        int[] edge;
        int[] vertTwo;
        int[] vertOne;
        int i;
        int numVerts = corners_fix.length >> 1;
        int[] edges = new int[corners_fix.length];
        for (i = 0; i < numVerts; ++i) {
            vertOne = this.vec2d_CopyVector(corners_fix, edgeIndex[i << 1] << 1);
            vertTwo = this.vec2d_CopyVector(corners_fix, edgeIndex[(i << 1) + 1] << 1);
            edge = this.vec2d_CopyVector(vertTwo, 0);
            this.vec2d_Sub(edge, 0, vertOne, 0);
            int[] edgeNorm = this.vec2d_GetRHNormalVec(edge, 0);
            this.vec2d_SetXY(edges, i << 1, edge, 0);
            toPoint = this.vec2d_CopyVector(point_fix, pointIndice);
            this.vec2d_Sub(toPoint, 0, vertOne, 0);
            if (this.vec2d_Dot(toPoint, 0, edgeNorm, 0) < 0 || this.vec2d_Dot(toPoint, 0, edge, 0) < 0) continue;
            toPoint = this.vec2d_CopyVector(point_fix, pointIndice);
            this.vec2d_Sub(toPoint, 0, vertTwo, 0);
            if (this.vec2d_Dot(toPoint, 0, edge, 0) > 0) continue;
            return new int[]{1, i};
        }
        for (i = 0; i < numVerts; ++i) {
            toPoint = this.vec2d_CopyVector(point_fix, pointIndice);
            this.vec2d_Sub(toPoint, 0, corners_fix, i << 1);
            if (this.vec2d_Dot(toPoint, 0, edges, vertIndex[i << 1] << 1) < 0 || this.vec2d_Dot(toPoint, 0, edges, vertIndex[(i << 1) + 1] << 1) > 0) continue;
            return new int[]{2, i};
        }
        int[] centerPoint_fix = new int[]{0, 0};
        int i2 = numVerts;
        while (--i2 >= 0) {
            this.vec2d_Add(centerPoint_fix, 0, corners_fix, i2 << 1);
        }
        this.vec2d_Div(centerPoint_fix, 0, this.FixedFromInt(numVerts));
        for (i2 = 0; i2 < numVerts; ++i2) {
            vertOne = this.vec2d_CopyVector(corners_fix, edgeIndex[i2 << 1] << 1);
            vertTwo = this.vec2d_CopyVector(corners_fix, edgeIndex[(i2 << 1) + 1] << 1);
            edge = this.vec2d_CopyVector(centerPoint_fix, 0);
            this.vec2d_Sub(edge, 0, vertOne, 0);
            toPoint = this.vec2d_CopyVector(point_fix, pointIndice);
            this.vec2d_Sub(toPoint, 0, vertOne, 0);
            if (this.vec2d_Cross(toPoint, 0, edge, 0) > 0) continue;
            edge = this.vec2d_CopyVector(centerPoint_fix, 0);
            this.vec2d_Sub(edge, 0, vertTwo, 0);
            toPoint = this.vec2d_CopyVector(point_fix, pointIndice);
            this.vec2d_Sub(toPoint, 0, vertTwo, 0);
            if (this.vec2d_Cross(toPoint, 0, edge, 0) < 0) continue;
            return new int[]{1, i2};
        }
        return null;
    }

    public final int[] voronoi_Resp_ConvexPolygon(int[] dirVec, int dirIndice, int[] edges, int[] voronoiRegion) {
        int[] outwardNorm;
        if (voronoiRegion[0] == 1) {
            outwardNorm = this.vec2d_GetRHNormalVec(edges, voronoiRegion[1] << 1);
            this.vec2d_Normalize(outwardNorm, 0);
        } else {
            int[] edge;
            if (voronoiRegion[1] != 0) {
                outwardNorm = this.vec2d_CopyVector(edges, voronoiRegion[1] << 1);
                edge = this.vec2d_CopyVector(edges, voronoiRegion[1] - 1 << 1);
            } else {
                outwardNorm = this.vec2d_CopyVector(edges, 0);
                edge = this.vec2d_CopyVector(edges, edges.length - 2);
            }
            this.vec2d_Normalize(outwardNorm, 0);
            this.vec2d_Invert(outwardNorm, 0);
            this.vec2d_Normalize(edge, 0);
            this.vec2d_Add(outwardNorm, 0, edge, 0);
            this.vec2d_Normalize(outwardNorm, 0);
        }
        return outwardNorm;
    }

    public final int[] aarect_GetCorners(int[] aarect_fix, int aarectIndice) {
        int aarectHalfWidth = aarect_fix[aarectIndice + 2];
        int aarectHalfHeight = aarect_fix[aarectIndice + 3];
        int aarectCenterX = aarect_fix[aarectIndice];
        int aarectCenterY = aarect_fix[aarectIndice + 1];
        return new int[]{aarectCenterX + aarectHalfWidth, aarectCenterY + aarectHalfHeight, aarectCenterX + aarectHalfWidth, aarectCenterY - aarectHalfHeight, aarectCenterX - aarectHalfWidth, aarectCenterY - aarectHalfHeight, aarectCenterX - aarectHalfWidth, aarectCenterY + aarectHalfHeight};
    }

    public final int[] aarect_GetEdges(int[] aarect_fix, int aarectIndice) {
        int[] aarectCorners = this.aarect_GetCorners(aarect_fix, aarectIndice);
        return this.edgesFromCorners(aarectCorners);
    }

    public final int[] circle_GetBoundingAARect(int[] circle_fix, int circleIndice) {
        int radius_fix = circle_fix[circleIndice + 2];
        return this.getAARect(circle_fix[circleIndice], circle_fix[circleIndice + 1], radius_fix, radius_fix);
    }

    public final int[] rotrect_GetCorners(int[] rotrect_fix, int rotrectIndice) {
        int[] widthHalfVec_fix = new int[]{0, rotrect_fix[rotrectIndice + 2]};
        int[] heightHalfVec_fix = new int[]{rotrect_fix[rotrectIndice + 3], 0};
        int rotrectDegree = rotrect_fix[rotrectIndice + 4];
        this.vec2d_Rotate(widthHalfVec_fix, 0, rotrectDegree);
        this.vec2d_Rotate(heightHalfVec_fix, 0, rotrectDegree);
        int[] rotrectCorners_fix = new int[8];
        this.vec2d_Add(rotrectCorners_fix, 0, widthHalfVec_fix, 0);
        this.vec2d_Add(rotrectCorners_fix, 0, heightHalfVec_fix, 0);
        this.vec2d_Add(rotrectCorners_fix, 2, widthHalfVec_fix, 0);
        this.vec2d_Sub(rotrectCorners_fix, 2, heightHalfVec_fix, 0);
        this.vec2d_Sub(rotrectCorners_fix, 4, widthHalfVec_fix, 0);
        this.vec2d_Sub(rotrectCorners_fix, 4, heightHalfVec_fix, 0);
        this.vec2d_Sub(rotrectCorners_fix, 6, widthHalfVec_fix, 0);
        this.vec2d_Add(rotrectCorners_fix, 6, heightHalfVec_fix, 0);
        for (int i = 0; i < rotrectCorners_fix.length; i += 2) {
            this.vec2d_Add(rotrectCorners_fix, i, rotrect_fix[rotrectIndice], rotrect_fix[rotrectIndice + 1]);
        }
        return rotrectCorners_fix;
    }

    public final int[] rotrect_GetEdges(int[] rotrect_fix, int rotrectIndice) {
        int[] rotrectCorners = this.rotrect_GetCorners(rotrect_fix, rotrectIndice);
        return this.edgesFromCorners(rotrectCorners);
    }

    public final int[] rotrect_GetBoundingAARect(int[] rotrect_fix, int rotrectIndice) {
        int[] rotrectCorners_fix = this.rotrect_GetCorners(rotrect_fix, rotrectIndice);
        int aarectBottom = Integer.MIN_VALUE;
        int aarectTop = Integer.MAX_VALUE;
        int aarectRight = Integer.MIN_VALUE;
        int aarectLeft = Integer.MAX_VALUE;
        int i = rotrectCorners_fix.length;
        while ((i -= 2) >= 0) {
            int x_fix = rotrectCorners_fix[i];
            int y_fix = rotrectCorners_fix[i + 1];
            aarectLeft = this.Min(x_fix, aarectLeft);
            aarectRight = this.Max(x_fix, aarectRight);
            aarectTop = this.Min(y_fix, aarectTop);
            aarectBottom = this.Max(y_fix, aarectBottom);
        }
        return this.getAARect(rotrect_fix[rotrectIndice], rotrect_fix[rotrectIndice + 1], aarectRight - aarectLeft >> 1, aarectBottom - aarectTop >> 1);
    }

    public final int[] aatri_GetCorners(int[] aatri_fix, int aatriIndice) {
        int aatriX_fix = aatri_fix[aatriIndice];
        int aatriY_fix = aatri_fix[aatriIndice + 1];
        int aatriWidth = aatri_fix[aatriIndice + 2];
        int aatriHeight = aatri_fix[aatriIndice + 3];
        if (aatriWidth < 0 && aatriHeight > 0 || aatriWidth > 0 && aatriHeight < 0) {
            return new int[]{aatriX_fix, aatriY_fix, aatriX_fix + aatriWidth, aatriY_fix, aatriX_fix, aatriY_fix + aatriHeight};
        }
        return new int[]{aatriX_fix, aatriY_fix, aatriX_fix, aatriY_fix + aatriHeight, aatriX_fix + aatriWidth, aatriY_fix};
    }

    public final int[] aatri_GetEdges(int[] aatri_fix, int aatriIndice) {
        int[] aatriCorners = this.aatri_GetCorners(aatri_fix, aatriIndice);
        return this.edgesFromCorners(aatriCorners);
    }

    public final int[] aatri_GetBoundingAARect(int[] aatri_fix, int aatriIndice) {
        int width_fix = aatri_fix[aatriIndice + 2] >> 1;
        int height_fix = aatri_fix[aatriIndice + 3] >> 1;
        return new int[]{aatri_fix[aatriIndice] + width_fix, aatri_fix[aatriIndice + 1] + height_fix, this.Abs(width_fix), this.Abs(height_fix)};
    }

    public final int[] aatri_GetCentroid(int[] aatri_fix, int aatriIndice) {
        return new int[]{aatri_fix[aatriIndice] + this.Div(aatri_fix[aatriIndice + 2], this.FixedFromInt(3)), aatri_fix[aatriIndice + 1] + this.Div(aatri_fix[aatriIndice + 3], this.FixedFromInt(3))};
    }

    private int[] edgesFromCorners(int[] corners_fix) {
        int[] edges = new int[corners_fix.length];
        for (int i = 0; i < corners_fix.length - 2; i += 2) {
            this.vec2d_SetXY(edges, i, corners_fix, i + 2);
            this.vec2d_Sub(edges, i, corners_fix, i);
        }
        this.vec2d_SetXY(edges, corners_fix.length - 2, corners_fix, 0);
        this.vec2d_Sub(edges, corners_fix.length - 2, corners_fix, corners_fix.length - 2);
        return edges;
    }

    public final boolean collision_AARect_vs_AARect(int[] aarectOne_fix, int aarectOneIndice, int[] aarectTwo_fix, int aarectTwoIndice) {
        int deltaX_fix = aarectOne_fix[aarectOneIndice] - aarectTwo_fix[aarectTwoIndice];
        int penetrationX_fix = aarectOne_fix[aarectOneIndice + 2] + aarectTwo_fix[aarectTwoIndice + 2] - this.Abs(deltaX_fix);
        if (penetrationX_fix < 0) {
            return false;
        }
        int deltaY_fix = aarectOne_fix[aarectOneIndice + 1] - aarectTwo_fix[aarectTwoIndice + 1];
        int penetrationY_fix = aarectOne_fix[aarectOneIndice + 3] + aarectTwo_fix[aarectTwoIndice + 3] - this.Abs(deltaY_fix);
        return penetrationY_fix >= 0;
    }

    public final boolean collision_AARect_vs_Circle(int[] aarect_fix, int aarectIndice, int[] circle_fix, int circleIndice) {
        int[] circleAARect_fix = this.circle_GetBoundingAARect(circle_fix, circleIndice);
        if (!this.collision_AARect_vs_AARect(aarect_fix, aarectIndice, circleAARect_fix, 0)) {
            return false;
        }
        int circleX_fix = circle_fix[circleIndice];
        int circleY_fix = circle_fix[circleIndice + 1];
        int aarectX_fix = aarect_fix[aarectIndice];
        int aarectY_fix = aarect_fix[aarectIndice + 1];
        int aarectW_fix = aarect_fix[aarectIndice + 2];
        int aarectH_fix = aarect_fix[aarectIndice + 3];
        if (this.Abs(circleX_fix - aarectX_fix) < aarectW_fix || this.Abs(circleY_fix - aarectY_fix) < aarectH_fix) {
            return true;
        }
        int[] closestCornerVec = new int[]{0, 0};
        closestCornerVec[0] = circleX_fix >= aarectX_fix ? aarectX_fix + aarectW_fix : aarectX_fix - aarectW_fix;
        closestCornerVec[1] = circleY_fix >= aarectY_fix ? aarectY_fix + aarectH_fix : aarectY_fix - aarectH_fix;
        return this.point2d_IsInsideCircle(closestCornerVec, 0, circle_fix, circleIndice);
    }

    public final boolean collision_AARect_vs_RotRect(int[] aarect_fix, int aarectIndice, int[] rotrect_fix, int rotrectIndice) {
        int[] rotrectEdges = this.rotrect_GetEdges(rotrect_fix, rotrectIndice);
        int[] axes = new int[]{0, 0, 0, 0};
        this.vec2d_SetXY(axes, 0, 65536, 0);
        this.vec2d_SetXY(axes, 2, 0, 65536);
        int[] projVecs_fix = new int[]{0, 0, 0, 0};
        this.vec2d_SetXY(projVecs_fix, 0, rotrectEdges, 2);
        this.vec2d_SetXY(projVecs_fix, 2, rotrectEdges, 0);
        int[] distanceVec_fix = this.vec2d_CopyVector(rotrect_fix, rotrectIndice);
        this.vec2d_Sub(distanceVec_fix, 0, aarect_fix, aarectIndice);
        int aarectW_fix = aarect_fix[aarectIndice + 2];
        int delta_fix = this.Abs(this.vec2d_Dot(distanceVec_fix, 0, axes, 0));
        int projection_fix = this.Abs(this.vec2d_Dot(projVecs_fix, 0, axes, 0)) + this.Abs(this.vec2d_Dot(projVecs_fix, 2, axes, 0)) >> 1;
        int penetration_fix = projection_fix + aarectW_fix - delta_fix;
        if (penetration_fix < 0) {
            return false;
        }
        int aarectH_fix = aarect_fix[aarectIndice + 3];
        delta_fix = this.Abs(this.vec2d_Dot(distanceVec_fix, 0, axes, 2));
        projection_fix = this.Abs(this.vec2d_Dot(projVecs_fix, 0, axes, 2)) + this.Abs(this.vec2d_Dot(projVecs_fix, 2, axes, 2)) >> 1;
        penetration_fix = projection_fix + aarectH_fix - delta_fix;
        if (penetration_fix < 0) {
            return false;
        }
        this.vec2d_SetXY(axes, 0, rotrectEdges, 2);
        this.vec2d_SetXY(axes, 2, rotrectEdges, 0);
        this.vec2d_SetXY(projVecs_fix, 0, aarectW_fix, 0);
        this.vec2d_SetXY(projVecs_fix, 2, 0, aarectH_fix);
        this.vec2d_Normalize(axes, 0);
        delta_fix = this.Abs(this.vec2d_Dot(distanceVec_fix, 0, axes, 0));
        projection_fix = this.Abs(this.vec2d_Dot(projVecs_fix, 0, axes, 0)) + this.Abs(this.vec2d_Dot(projVecs_fix, 2, axes, 0));
        penetration_fix = projection_fix + rotrect_fix[rotrectIndice + 2] - delta_fix;
        if (penetration_fix < 0) {
            return false;
        }
        this.vec2d_Normalize(axes, 2);
        delta_fix = this.Abs(this.vec2d_Dot(distanceVec_fix, 0, axes, 2));
        projection_fix = this.Abs(this.vec2d_Dot(projVecs_fix, 0, axes, 2)) + this.Abs(this.vec2d_Dot(projVecs_fix, 2, axes, 2));
        penetration_fix = projection_fix + rotrect_fix[rotrectIndice + 3] - delta_fix;
        return penetration_fix >= 0;
    }

    public final boolean collision_AARect_vs_AATri(int[] aarect_fix, int aarectIndice, int[] aatri_fix, int aatriIndice) {
        int[] aatriAARect = this.aatri_GetBoundingAARect(aatri_fix, aatriIndice);
        if (!this.collision_AARect_vs_AARect(aarect_fix, aarectIndice, aatriAARect, 0)) {
            return false;
        }
        int aatriWidth = aatri_fix[aatriIndice + 2];
        int aatriHeight = aatri_fix[aatriIndice + 3];
        int[] aarectProjVecs_fix = new int[]{aarect_fix[aarectIndice + 2], 0, 0, aarect_fix[aarectIndice + 3]};
        int[] aatriProjVecs_fix = new int[]{aatriWidth, 0};
        int[] axes_fix = new int[]{aatriWidth, -aatriHeight};
        axes_fix = this.vec2d_GetLHNormalVec(axes_fix, 0);
        this.vec2d_Normalize(axes_fix, 0);
        int[] aatriCenter = new int[]{aatri_fix[aatriIndice] + (aatriWidth >> 2), aatri_fix[aatriIndice + 1] + (aatriHeight >> 2)};
        int[] distanceVec_fix = this.vec2d_CopyVector(aarect_fix, aarectIndice);
        this.vec2d_Sub(distanceVec_fix, 0, aatriCenter, 0);
        int delta_fix = this.Abs(this.vec2d_Dot(distanceVec_fix, 0, axes_fix, 0));
        int aarectProjection = this.Abs(this.vec2d_Dot(aarectProjVecs_fix, 0, axes_fix, 0)) + this.Abs(this.vec2d_Dot(aarectProjVecs_fix, 2, axes_fix, 0));
        int aatriProjection = this.Abs(this.vec2d_Dot(aatriProjVecs_fix, 0, axes_fix, 0)) >> 1;
        int penetration_fix = aarectProjection + aatriProjection - delta_fix;
        return penetration_fix >= 0;
    }

    public final boolean collision_Circle_vs_Circle(int[] circleOne_fix, int circleOneIndice, int[] circleTwo_fix, int circleTwoIndice) {
        int vertDist = circleTwo_fix[circleTwoIndice] - circleOne_fix[circleOneIndice];
        int horsDist = circleTwo_fix[circleTwoIndice + 1] - circleOne_fix[circleOneIndice + 1];
        int radiusSum = circleTwo_fix[circleTwoIndice + 2] + circleOne_fix[circleOneIndice + 2];
        return this.Mul(vertDist, vertDist) + this.Mul(horsDist, horsDist) < this.Mul(radiusSum, radiusSum);
    }

    public final boolean collision_Circle_vs_RotRect(int[] circle_fix, int circleIndice, int[] rotrect_fix, int rotrectIndice) {
        int circleRadius_fix = circle_fix[circleIndice + 2];
        int[] rotrectEdges = this.rotrect_GetEdges(rotrect_fix, rotrectIndice);
        int[] axes_fix = new int[]{0, 0, 0, 0};
        this.vec2d_SetXY(axes_fix, 0, rotrectEdges, 2);
        this.vec2d_SetXY(axes_fix, 2, rotrectEdges, 0);
        int[] distanceVec_fix = this.vec2d_CopyVector(rotrect_fix, rotrectIndice);
        this.vec2d_Sub(distanceVec_fix, 0, circle_fix, circleIndice);
        this.vec2d_Normalize(axes_fix, 0);
        int delta_fix = this.Abs(this.vec2d_Dot(distanceVec_fix, 0, axes_fix, 0));
        int penetration_fix = circleRadius_fix + rotrect_fix[rotrectIndice + 2] - delta_fix;
        if (penetration_fix < 0) {
            return false;
        }
        this.vec2d_Normalize(axes_fix, 2);
        delta_fix = this.Abs(this.vec2d_Dot(distanceVec_fix, 0, axes_fix, 2));
        penetration_fix = circleRadius_fix + rotrect_fix[rotrectIndice + 3] - delta_fix;
        if (penetration_fix < 0) {
            return false;
        }
        int[] voroniRegion = this.point2d_VoronoiRegion_RotRect(circle_fix, circleIndice, rotrect_fix, rotrectIndice);
        if (voroniRegion[0] == 1) {
            return true;
        }
        int[] rotrectCorners = this.rotrect_GetCorners(rotrect_fix, rotrectIndice);
        int[] closestCorner = this.vec2d_CopyVector(rotrectCorners, voroniRegion[1] << 1);
        return this.point2d_IsInsideCircle(closestCorner, 0, circle_fix, circleIndice);
    }

    public final boolean collision_Circle_vs_AATri(int[] circle_fix, int circleIndice, int[] aatri_fix, int aatriIndice) {
        int[] aatriAARect;
        int[] circleAARect = this.circle_GetBoundingAARect(circle_fix, circleIndice);
        if (!this.collision_AARect_vs_AARect(circleAARect, 0, aatriAARect = this.aatri_GetBoundingAARect(aatri_fix, aatriIndice), 0)) {
            return false;
        }
        int aatriWidth = aatri_fix[aatriIndice + 2];
        int aatriHeight = aatri_fix[aatriIndice + 3];
        int circleRadius = circle_fix[circleIndice + 2];
        int[] aatriProjVecs_fix = new int[]{aatriWidth, 0};
        int[] axes_fix = new int[]{aatriWidth, -aatriHeight};
        axes_fix = this.vec2d_GetLHNormalVec(axes_fix, 0);
        this.vec2d_Normalize(axes_fix, 0);
        int[] aatriCenter = new int[]{aatri_fix[aatriIndice] + (aatriWidth >> 2), aatri_fix[aatriIndice + 1] + (aatriHeight >> 2)};
        int[] distanceVec_fix = this.vec2d_CopyVector(circle_fix, circleIndice);
        this.vec2d_Sub(distanceVec_fix, 0, aatriCenter, 0);
        int delta_fix = this.Abs(this.vec2d_Dot(distanceVec_fix, 0, axes_fix, 0));
        int aatriProjection = this.Abs(this.vec2d_Dot(aatriProjVecs_fix, 0, axes_fix, 0)) >> 1;
        int penetration_fix = circleRadius + aatriProjection - delta_fix;
        if (penetration_fix < 0) {
            return false;
        }
        int[] voroniRegion = this.point2d_VoronoiRegion_AATri(circle_fix, circleIndice, aatri_fix, aatriIndice);
        if (voroniRegion[0] == 1) {
            return true;
        }
        int[] aatriCorners = this.aatri_GetCorners(aatri_fix, aatriIndice);
        int[] closestCorner = this.vec2d_CopyVector(aatriCorners, voroniRegion[1] << 1);
        return this.point2d_IsInsideCircle(closestCorner, 0, circle_fix, circleIndice);
    }

    public final boolean collision_RotRect_vs_RotRect(int[] rotrectOne_fix, int rotrectOneIndice, int[] rotrectTwo_fix, int rotrectTwoIndice) {
        int[] rotrectOneEdges = this.rotrect_GetEdges(rotrectOne_fix, rotrectOneIndice);
        int[] rotrectTwoEdges = this.rotrect_GetEdges(rotrectTwo_fix, rotrectTwoIndice);
        int[] axes_fix = new int[]{0, 0, 0, 0};
        this.vec2d_SetXY(axes_fix, 0, rotrectTwoEdges, 2);
        this.vec2d_SetXY(axes_fix, 2, rotrectTwoEdges, 0);
        this.vec2d_Normalize(axes_fix, 0);
        this.vec2d_Normalize(axes_fix, 2);
        int[] distanceVec_fix = this.vec2d_CopyVector(rotrectOne_fix, rotrectOneIndice);
        this.vec2d_Sub(distanceVec_fix, 0, rotrectTwo_fix, rotrectTwoIndice);
        int deltaX_fix = this.Abs(this.vec2d_Dot(distanceVec_fix, 0, axes_fix, 0));
        int projectionX = this.Abs(this.vec2d_Dot(rotrectOneEdges, 0, axes_fix, 0)) + this.Abs(this.vec2d_Dot(rotrectOneEdges, 2, axes_fix, 0)) >> 1;
        int penetrationX_fix = projectionX + rotrectTwo_fix[rotrectTwoIndice + 2] - deltaX_fix;
        if (penetrationX_fix < 0) {
            return false;
        }
        int deltaY_fix = this.Abs(this.vec2d_Dot(distanceVec_fix, 0, axes_fix, 2));
        int projectionY = this.Abs(this.vec2d_Dot(rotrectOneEdges, 0, axes_fix, 2)) + this.Abs(this.vec2d_Dot(rotrectOneEdges, 2, axes_fix, 2)) >> 1;
        int penetrationY_fix = projectionY + rotrectTwo_fix[rotrectTwoIndice + 3] - deltaY_fix;
        if (penetrationY_fix < 0) {
            return false;
        }
        this.vec2d_SetXY(axes_fix, 0, rotrectOneEdges, 2);
        this.vec2d_SetXY(axes_fix, 2, rotrectOneEdges, 0);
        this.vec2d_Normalize(axes_fix, 0);
        this.vec2d_Normalize(axes_fix, 2);
        deltaX_fix = this.Abs(this.vec2d_Dot(distanceVec_fix, 0, axes_fix, 0));
        projectionX = this.Abs(this.vec2d_Dot(rotrectTwoEdges, 0, axes_fix, 0)) + this.Abs(this.vec2d_Dot(rotrectTwoEdges, 2, axes_fix, 0)) >> 1;
        penetrationX_fix = projectionX + rotrectOne_fix[rotrectOneIndice + 2] - deltaX_fix;
        if (penetrationX_fix < 0) {
            return false;
        }
        deltaY_fix = this.Abs(this.vec2d_Dot(distanceVec_fix, 0, axes_fix, 2));
        projectionY = this.Abs(this.vec2d_Dot(rotrectTwoEdges, 0, axes_fix, 2)) + this.Abs(this.vec2d_Dot(rotrectTwoEdges, 2, axes_fix, 2)) >> 1;
        penetrationY_fix = projectionY + rotrectOne_fix[rotrectOneIndice + 3] - deltaY_fix;
        return penetrationY_fix >= 0;
    }

    public final boolean collision_RotRect_vs_AATri(int[] rotrect_fix, int rotrectIndice, int[] aatri_fix, int aatriIndice) {
        int[] rotrectAARect = this.rotrect_GetBoundingAARect(rotrect_fix, rotrectIndice);
        if (!this.collision_AARect_vs_AATri(rotrectAARect, 0, aatri_fix, aatriIndice)) {
            return false;
        }
        int[] aatriAARect = this.aatri_GetBoundingAARect(aatri_fix, aatriIndice);
        if (!this.collision_AARect_vs_RotRect(aatriAARect, 0, rotrect_fix, rotrectIndice)) {
            return false;
        }
        int[] rotrectEdges = this.rotrect_GetEdges(rotrect_fix, rotrectIndice);
        int[] rotrectProjVecs_fix = new int[]{0, 0, 0, 0};
        this.vec2d_SetXY(rotrectProjVecs_fix, 0, rotrectEdges, 2);
        this.vec2d_SetXY(rotrectProjVecs_fix, 2, rotrectEdges, 0);
        int aatriWidth = aatri_fix[aatriIndice + 2];
        int aatriHeight = aatri_fix[aatriIndice + 3];
        int[] axes_fix = new int[]{aatriWidth, -aatriHeight};
        axes_fix = this.vec2d_GetLHNormalVec(axes_fix, 0);
        this.vec2d_Normalize(axes_fix, 0);
        int[] aatriProjVecs_fix = new int[]{aatriWidth, 0};
        int[] aatriCenter = new int[]{aatri_fix[aatriIndice] + (aatriWidth >> 2), aatri_fix[aatriIndice + 1] + (aatriHeight >> 2)};
        int[] distanceVec_fix = this.vec2d_CopyVector(rotrect_fix, rotrectIndice);
        this.vec2d_Sub(distanceVec_fix, 0, aatriCenter, 0);
        int delta_fix = this.Abs(this.vec2d_Dot(distanceVec_fix, 0, axes_fix, 0));
        int rotrectProjection = this.Abs(this.vec2d_Dot(rotrectProjVecs_fix, 0, axes_fix, 0)) + this.Abs(this.vec2d_Dot(rotrectProjVecs_fix, 2, axes_fix, 0)) >> 1;
        int aatriProjection = this.Abs(this.vec2d_Dot(aatriProjVecs_fix, 0, axes_fix, 0)) >> 1;
        int penetration_fix = rotrectProjection + aatriProjection - delta_fix;
        return penetration_fix >= 0;
    }

    public final boolean collision_AATri_vs_AATri(int[] aatriOne_fix, int aatriOneIndice, int[] aatriTwo_fix, int aatriTwoIndice) {
        return false;
    }

    public final int[] getVec2d(int dirX_fix, int dirY_fix) {
        return new int[]{dirX_fix, dirY_fix};
    }

    public final int[] getPoint2d(int x_fix, int y_fix) {
        return new int[]{x_fix, y_fix};
    }

    public final int[] getLine2d(int x1_fix, int y1_fix, int x2_fix, int y2_fix) {
        return new int[]{x1_fix, y1_fix, x2_fix, y2_fix};
    }

    public final int[] getAARect(int centerX_fix, int centerY_fix, int halfWidth_fix, int halfHeight_fix) {
        return new int[]{centerX_fix, centerY_fix, halfWidth_fix, halfHeight_fix};
    }

    public final int[] getRotRect(int centerX_fix, int centerY_fix, int halfWidth_fix, int halfHeight_fix, int rotDegree_fix) {
        return new int[]{centerX_fix, centerY_fix, halfWidth_fix, halfHeight_fix, rotDegree_fix};
    }

    public final int[] getCircle(int centerX_fix, int centerY_fix, int radius_fix) {
        return new int[]{centerX_fix, centerY_fix, radius_fix};
    }

    public final int[] getAATri(int cornerX_fix, int cornerY_fix, int widthVecLength_fix, int heightVecLength_fix) {
        return new int[]{cornerX_fix, cornerY_fix, widthVecLength_fix, heightVecLength_fix};
    }

    public void drawAARect(int[] aarect_fix, int aarectIndice, Graphics g, int fillColor, int outlineColor) {
        int centerX_fix = aarect_fix[aarectIndice];
        int centerY_fix = aarect_fix[aarectIndice + 1];
        int halfWidth_fix = aarect_fix[aarectIndice + 2];
        int halfHeight_fix = aarect_fix[aarectIndice + 3];
        g.setColor(fillColor);
        g.fillRect(this.Round(centerX_fix - halfWidth_fix), this.Round(centerY_fix - halfHeight_fix), this.Round(halfWidth_fix << 1), this.Round(halfHeight_fix << 1));
        g.setColor(outlineColor);
        g.drawRect(this.Round(centerX_fix - halfWidth_fix), this.Round(centerY_fix - halfHeight_fix), this.Round(halfWidth_fix << 1), this.Round(halfHeight_fix << 1));
    }

    public void drawAABB(int[] aabb_fix, int aabbIndice, Graphics g, int color) {
        int centerX_fix = aabb_fix[aabbIndice];
        int centerY_fix = aabb_fix[aabbIndice + 1];
        int halfWidth_fix = aabb_fix[aabbIndice + 2];
        int halfHeight_fix = aabb_fix[aabbIndice + 3];
        g.setColor(color);
        g.drawRect(this.Round(centerX_fix - halfWidth_fix), this.Round(centerY_fix - halfHeight_fix), this.Round(halfWidth_fix << 1), this.Round(halfHeight_fix << 1));
    }

    public void drawRotRect(int[] rotrect_fix, int rotrectIndice, Graphics g, int fillColor, int outlineColor) {
        int[] rotrectCorners_fix = this.rotrect_GetCorners(rotrect_fix, rotrectIndice);
        g.setColor(fillColor);
        g.fillTriangle(this.Round(rotrectCorners_fix[0]), this.Round(rotrectCorners_fix[1]), this.Round(rotrectCorners_fix[2]), this.Round(rotrectCorners_fix[3]), this.Round(rotrectCorners_fix[6]), this.Round(rotrectCorners_fix[7]));
        g.fillTriangle(this.Round(rotrectCorners_fix[2]), this.Round(rotrectCorners_fix[3]), this.Round(rotrectCorners_fix[4]), this.Round(rotrectCorners_fix[5]), this.Round(rotrectCorners_fix[6]), this.Round(rotrectCorners_fix[7]));
        g.setColor(outlineColor);
        g.drawLine(this.Round(rotrectCorners_fix[0]), this.Round(rotrectCorners_fix[1]), this.Round(rotrectCorners_fix[2]), this.Round(rotrectCorners_fix[3]));
        g.drawLine(this.Round(rotrectCorners_fix[2]), this.Round(rotrectCorners_fix[3]), this.Round(rotrectCorners_fix[4]), this.Round(rotrectCorners_fix[5]));
        g.drawLine(this.Round(rotrectCorners_fix[4]), this.Round(rotrectCorners_fix[5]), this.Round(rotrectCorners_fix[6]), this.Round(rotrectCorners_fix[7]));
        g.drawLine(this.Round(rotrectCorners_fix[6]), this.Round(rotrectCorners_fix[7]), this.Round(rotrectCorners_fix[0]), this.Round(rotrectCorners_fix[1]));
    }

    public void drawCircle(int[] circle_fix, int circleIndice, Graphics g, int fillColor, int outlineColor) {
        g.setColor(fillColor);
        int diameter = this.Round(circle_fix[circleIndice + 2] << 1);
        g.fillRoundRect(this.Round(circle_fix[circleIndice]) - (diameter >> 1), this.Round(circle_fix[circleIndice + 1]) - (diameter >> 1), diameter, diameter, diameter, diameter);
        g.setColor(outlineColor);
        g.drawRoundRect(this.Round(circle_fix[circleIndice]) - (diameter >> 1), this.Round(circle_fix[circleIndice + 1]) - (diameter >> 1), diameter, diameter, diameter, diameter);
    }

    public void drawPoint(int[] point_fix, int pointIndice, Graphics g) {
        g.setColor(0);
        g.fillRect(this.Round(point_fix[pointIndice]), this.Round(point_fix[pointIndice + 1]), 1, 1);
    }

    public void drawAATri(int[] aatri_fix, int aatriIndice, Graphics g, int fillColor, int outlineColor) {
        int[] aatriCorners = this.aatri_GetCorners(aatri_fix, aatriIndice);
        g.setColor(fillColor);
        g.fillTriangle(this.Round(aatriCorners[0]), this.Round(aatriCorners[1]), this.Round(aatriCorners[2]), this.Round(aatriCorners[3]), this.Round(aatriCorners[4]), this.Round(aatriCorners[5]));
        g.setColor(outlineColor);
        g.drawLine(this.Round(aatriCorners[0]), this.Round(aatriCorners[1]), this.Round(aatriCorners[2]), this.Round(aatriCorners[3]));
        g.drawLine(this.Round(aatriCorners[2]), this.Round(aatriCorners[3]), this.Round(aatriCorners[4]), this.Round(aatriCorners[5]));
        g.drawLine(this.Round(aatriCorners[4]), this.Round(aatriCorners[5]), this.Round(aatriCorners[0]), this.Round(aatriCorners[1]));
    }
}

