/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.game.ChopAnimation;
import sk.inlogic.screen.ScreenMain;
import sk.inlogic.util.RandomNum;

public class Game {
    public static final byte MAX_TREEPARTS = 15;
    public static final byte MAX_BRANCHTYPES = 2;
    public static final byte TOTAL_ENVIROMENTS = 3;
    public static final int COLOR_BROWN_DARK = 6564625;
    public static final int COLOR_BROWN_LIGHT = 0x713113;
    public static final int COLOR_RED_DARK = 0xDB0000;
    public static final int COLOR_RED_LIGHT = 0xC00000;
    public static Sprite[][] sprBranches = new Sprite[3][2];
    public static Image[] imgTree = new Image[3];
    private Image[] imgPen = new Image[3];
    private Image[] imgGrave = new Image[3];
    private Image[] imgPlayerShadow = new Image[3];
    private Sprite[] sprGraveDust = new Sprite[3];
    private Sprite sprTutorialLeft;
    private Sprite sprTutorialRight;
    private Sprite[] sprPlayer = new Sprite[4];
    private int[] treeParts = new int[15];
    private int[] branchTypes = new int[15];
    private static final int TYPE_LEFT = 0;
    private static final int TYPE_RIGHT = 1;
    private static final int TYPE_FREE = 2;
    private static final int TOTAL_TYPES = 3;
    private static final int BRANCHTYPE_NONE = 0;
    private static final int BRANCHTYPE_01 = 1;
    private static final int BRANCHTYPE_02 = 2;
    public static final int[] MEDAL_POINTS = new int[]{100, 250, 400};
    public static final int[] HERO_POINTS = new int[]{100, 200, 300};
    private ChopAnimation[] chopAnimations;
    private int iTreeW;
    private int iTreeH;
    private int iTreeX;
    private int iTreeY;
    private int iTwigWidth;
    private int iTwigHeight;
    private int iScore;
    public static int iEnviroment;
    private int iPlayerW;
    private int iPlayerH;
    private int iPlayerY;
    private int iPlayerX;
    private int iPlayerLeftX;
    private int iPlayerRightX;
    private int iPlayerHeroY;
    private int iGraveStartY;
    private int iGraveEndY;
    private int iGraveLeftX;
    private int iGraveRightX;
    private byte playerPosition;
    public static final byte POS_LEFT = 0;
    public static final byte POS_RIGHT = 1;
    private ScreenMain gameScreen;
    private boolean chopInProgress = false;
    private boolean bEnergyAdd = false;
    private boolean bGameOver = false;
    boolean bPlayerChop = false;
    private static final int MAX_ENERGY = 1000;
    private static final int[] ENERGY_LVL;
    private static final int[] ENERGY_BONUS;
    private byte currEnergyLvl;
    private int actEnergy;
    private int iEnergyMaxW;
    private int iEnergyActW;
    private int iEnergyH;
    private int iEnergyX;
    private int iEnergyY;
    private int iTopBarH;
    private int iTopBarW;
    private int iTopBarX;
    private int iTopBarY;
    private int iBestScoreCenterX;
    private int iBestScoreCenterY;
    private int iBestScoreW;
    private int iBestScoreH;
    private int iBestScoreTextCenterY;
    private int iTopBarAnimationStep;
    private int iTotalPlayerFrames;
    private static final int TIME_ANIMATION_TOPBAR = 200;
    private static final int TIME_ANIMATION_TREEDOWN = 100;
    private int actAnimTreeDownTime = 0;
    private int iTreeDownAnimOffset = 0;
    private int iTreeDownAnimStep;
    private int iTutorialY;
    private int iTutorialLeftX;
    private int iTutorialRightX;
    private int iOffShdw;
    int treeStepPaint = 1;
    Sprite tempTutorialSpr;
    int tutorialTextW;
    int tutorialCountSpr;
    int tutorialSprW;
    int tutorialLeftX;
    int tutorialTextX;
    private int sec = 3000;
    private char[] strSec = new char[1];
    int iPlayerFrame;
    int frameDuration = 320;
    int actFrameDuration = 0;
    int chopFrameDuration = 5;
    int iGraveStep = 1;
    int dustFrameDuration = 80;
    int dustActFrameDuration = 0;
    int dustActFrame = 0;
    private static final byte MAX_DUST_FRAMES = 5;

    public Game(ScreenMain screen) {
        this.gameScreen = screen;
    }

    public void initFirst() {
        Game.imgTree[0] = Resources.resImgs[10];
        Game.imgTree[1] = Resources.resImgs[27];
        Game.imgTree[2] = Resources.resImgs[28];
        this.imgPen[0] = Resources.resImgs[11];
        this.imgPen[1] = Resources.resImgs[12];
        this.imgPen[2] = Resources.resImgs[13];
        Game.sprBranches[0][0] = Resources.resSprs[10];
        Game.sprBranches[0][1] = Resources.resSprs[11];
        Game.sprBranches[1][0] = Resources.resSprs[12];
        Game.sprBranches[1][1] = Resources.resSprs[13];
        Game.sprBranches[2][0] = Resources.resSprs[14];
        Game.sprBranches[2][1] = Resources.resSprs[15];
        this.imgPlayerShadow[0] = Resources.resImgs[16];
        this.imgPlayerShadow[1] = Resources.resImgs[17];
        this.imgPlayerShadow[2] = Resources.resImgs[18];
        this.sprPlayer[0] = Resources.resSprs[5];
        this.sprPlayer[1] = Resources.resSprs[18];
        this.sprPlayer[2] = Resources.resSprs[20];
        this.sprPlayer[3] = Resources.resSprs[19];
        this.imgGrave[0] = Resources.resImgs[23];
        this.imgGrave[1] = Resources.resImgs[24];
        this.imgGrave[2] = Resources.resImgs[25];
        this.sprTutorialLeft = Resources.resSprs[16];
        this.sprTutorialRight = Resources.resSprs[17];
        this.sprGraveDust[0] = Resources.resSprs[7];
        this.sprGraveDust[1] = Resources.resSprs[8];
        this.sprGraveDust[2] = Resources.resSprs[9];
        this.iTreeW = imgTree[0].getWidth();
        this.iTreeH = imgTree[0].getHeight();
        this.iTwigWidth = sprBranches[0][0].getWidth();
        this.iTwigHeight = sprBranches[0][0].getHeight();
        this.iTreeX = MainCanvas.WIDTH >> 1;
        this.iTreeY = MainCanvas.HEIGHT - this.iTreeH - this.imgPen[0].getHeight() - this.gameScreen.imgBtnPause.getHeight();
        this.initChopAnimations();
        this.setTopBarYPosition(0);
        this.iGraveStartY = MainCanvas.HEIGHT - this.imgGrave[0].getHeight() - this.gameScreen.imgBtnPause.getHeight() - ScreenMain.onePixel;
        this.iGraveEndY = MainCanvas.HEIGHT - this.imgGrave[0].getHeight() - this.gameScreen.imgBtnPause.getHeight();
        this.iTopBarW = (MainCanvas.WIDTH >> 3) * 5 + (ScreenMain.onePixel << 1);
        if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
            this.iTopBarW = (MainCanvas.HEIGHT >> 3) * 5 + (ScreenMain.onePixel << 1);
        }
        this.iTopBarH = (this.gameScreen.fontNumbers.getHeight() + (this.gameScreen.fontNumbers.getHeight() >> 2) << 1) + (ScreenMain.onePixel << 1);
        this.iTopBarX = (MainCanvas.WIDTH >> 1) - (this.iTopBarW >> 1);
        this.iTopBarY = 0 - this.iTopBarH;
        this.iBestScoreW = this.iTopBarW;
        this.iBestScoreH = this.gameScreen.sprDialog2.getHeight();
        this.iBestScoreCenterX = this.iTopBarX + (this.iTopBarW >> 1);
        this.iBestScoreCenterY = this.iTopBarY + (this.iTopBarH >> 1) - this.iBestScoreH;
        this.iBestScoreTextCenterY = this.iTopBarY + (this.gameScreen.fontNumbers.getHeight() >> 1) + ((this.iTopBarH >> 1) - this.gameScreen.fontNumbers.getHeight() >> 2);
        this.iEnergyX = this.iTopBarX + ScreenMain.onePixel;
        this.iEnergyY = this.iTopBarY + this.gameScreen.fontNumbers.getHeight() + (this.gameScreen.fontNumbers.getHeight() >> 2) + ScreenMain.onePixel;
        this.bEnergyAdd = false;
        this.iEnergyH = (this.iTopBarH >> 1) - ScreenMain.onePixel;
        this.iEnergyMaxW = this.iTopBarW - (ScreenMain.onePixel << 1);
        this.actEnergy = 500;
        this.iEnergyActW = this.getActEnergyW();
        this.iTutorialY = MainCanvas.HEIGHT >> 1;
        this.iTutorialLeftX = (MainCanvas.WIDTH >> 1) - (MainCanvas.WIDTH >> 2) - (MainCanvas.WIDTH >> 4);
        this.iTutorialRightX = (MainCanvas.WIDTH >> 1) + (MainCanvas.WIDTH >> 2) + (MainCanvas.WIDTH >> 4);
        this.iTopBarAnimationStep = this.iTopBarH / 5;
        this.iTopBarAnimationStep = this.iTopBarH >> 2;
        this.iTreeDownAnimStep = (this.iTreeH >> 1) / 2;
        this.resetDataBeforePlay(RandomNum.getRandomUInt(3));
    }

    private void initPlayer() {
        this.iPlayerW = this.sprPlayer[this.gameScreen.iSelectedHero].getWidth();
        this.iPlayerH = this.sprPlayer[this.gameScreen.iSelectedHero].getHeight();
        this.iPlayerHeroY = this.iPlayerY = MainCanvas.HEIGHT - this.iPlayerH - this.gameScreen.imgBtnPause.getHeight() - (this.gameScreen.imgBtnPause.getHeight() >> 3);
        switch (this.gameScreen.iSelectedHero) {
            case 0: {
                this.iPlayerLeftX = (MainCanvas.WIDTH >> 1) - this.iPlayerW;
                this.iPlayerRightX = (MainCanvas.WIDTH >> 1) - (this.iTreeW >> 4);
                this.iGraveLeftX = (MainCanvas.WIDTH >> 1) + (this.iTreeW >> 3) - this.imgGrave[0].getWidth() - (this.iPlayerW >> 1) + (this.imgGrave[0].getWidth() >> 1);
                this.iGraveRightX = (MainCanvas.WIDTH >> 1) - (this.iTreeW >> 3) + (this.iPlayerW >> 1) - (this.imgGrave[0].getWidth() >> 1);
                this.iOffShdw = 0;
                this.iTotalPlayerFrames = 3;
                break;
            }
            case 1: {
                this.iPlayerLeftX = (MainCanvas.WIDTH >> 1) - this.iPlayerW;
                this.iPlayerRightX = (MainCanvas.WIDTH >> 1) - (this.iTreeW >> 4);
                this.iGraveLeftX = this.iPlayerLeftX + (this.iPlayerW >> 1) - (this.imgGrave[0].getWidth() >> 1);
                this.iGraveRightX = this.iPlayerRightX + (this.iPlayerW >> 1) - (this.imgGrave[0].getWidth() >> 1);
                this.iOffShdw = (this.sprPlayer[this.gameScreen.iSelectedHero].getWidth() >> 2) - (ScreenMain.onePixel << 1);
                this.iTotalPlayerFrames = 4;
                break;
            }
            case 2: {
                this.iPlayerLeftX = (MainCanvas.WIDTH >> 1) - this.iPlayerW;
                this.iPlayerRightX = (MainCanvas.WIDTH >> 1) - (this.iTreeW >> 4);
                this.iGraveLeftX = (MainCanvas.WIDTH >> 1) + (this.iTreeW >> 3) - (this.iPlayerW >> 2) - (this.iPlayerW >> 4) - this.imgGrave[0].getWidth() - (this.iPlayerW >> 1) + (this.imgGrave[0].getWidth() >> 1);
                this.iGraveRightX = (MainCanvas.WIDTH >> 1) - (this.iTreeW >> 3) + (this.iPlayerW >> 2) + (this.iPlayerW >> 4) + (this.iPlayerW >> 1) - (this.imgGrave[0].getWidth() >> 1);
                this.iOffShdw = this.sprPlayer[this.gameScreen.iSelectedHero].getWidth() >> 2;
                this.iTotalPlayerFrames = 3;
                break;
            }
            case 3: {
                this.iPlayerLeftX = (MainCanvas.WIDTH >> 1) - this.iPlayerW;
                this.iPlayerRightX = (MainCanvas.WIDTH >> 1) - (this.iTreeW >> 4);
                this.iGraveLeftX = (MainCanvas.WIDTH >> 1) - this.imgGrave[0].getWidth() - (this.iPlayerW >> 1) + (this.imgGrave[0].getWidth() >> 1);
                this.iGraveRightX = (MainCanvas.WIDTH >> 1) - (this.iTreeW >> 3) + (this.iPlayerW >> 1) - (this.imgGrave[0].getWidth() >> 1);
                this.iOffShdw = ScreenMain.onePixel << 1;
                this.iTotalPlayerFrames = 3;
                break;
            }
        }
    }

    private void setTopBarYPosition(int pos) {
        this.iTopBarY = pos;
        this.iBestScoreCenterY = this.iTopBarY + (this.iTopBarH >> 1) - this.iBestScoreH;
        this.iBestScoreTextCenterY = this.iTopBarY + (this.gameScreen.fontNumbers.getHeight() >> 1) + ((this.iTopBarH >> 1) - this.gameScreen.fontNumbers.getHeight() >> 2);
        this.iEnergyY = this.iTopBarY + this.gameScreen.fontNumbers.getHeight() + (this.gameScreen.fontNumbers.getHeight() >> 2) + ScreenMain.onePixel;
    }

    private void initChopAnimations() {
    }

    private void startChopAnimation(int direction, boolean isTwig, int branchType) {
    }

    private void resetChopAnimation() {
    }

    public void resetDataBeforePlay(int iEnviroment) {
        Game.iEnviroment = iEnviroment;
        this.initPlayer();
        this.generateStartingTree();
        this.resetChopAnimation();
        this.playerPosition = 0;
        this.actEnergy = 500;
        this.iEnergyActW = this.getActEnergyW();
        this.bGameOver = false;
        this.currEnergyLvl = 0;
        this.iScore = 0;
        this.iPlayerFrame = 0;
        this.gameScreen.iMedal = 0;
        this.bPlayerChop = false;
        this.dustActFrameDuration = 0;
        this.dustActFrame = 0;
    }

    private int getActEnergyW() {
        return this.actEnergy * this.iEnergyMaxW / 1000;
    }

    private void generateStartingTree() {
        for (int i = 0; i < 15; ++i) {
            if (i < 3) {
                this.treeParts[i] = 2;
                this.branchTypes[i] = 0;
                continue;
            }
            if (this.treeParts[i - 1] != 2) {
                this.treeParts[i] = 2;
                this.branchTypes[i] = 0;
                continue;
            }
            this.treeParts[i] = RandomNum.getRandomUInt(3);
            if (this.treeParts[i] == 2) continue;
            this.branchTypes[i] = iEnviroment != 1 ? RandomNum.getRandomUInt(2) : 1;
        }
    }

    private void generateNextTreePart() {
        if (this.treeParts[13] != 2) {
            this.treeParts[14] = 2;
            this.branchTypes[14] = 0;
        } else {
            this.treeParts[14] = RandomNum.getRandomUInt(3);
            this.branchTypes[14] = iEnviroment != 1 ? RandomNum.getRandomUInt(2) : 1;
        }
    }

    public void chop(boolean direction) {
        if (this.chopInProgress || this.bPlayerChop) {
            return;
        }
        this.playerPosition = direction ? (byte)1 : 0;
        if (this.checkGameOver()) {
            this.gameOver();
            return;
        }
        this.bEnergyAdd = true;
        this.actEnergy += ENERGY_LVL[this.currEnergyLvl] + ENERGY_BONUS[this.gameScreen.iSelectedHero];
        if (this.actEnergy > 1000) {
            this.actEnergy = 1000;
        }
        this.chopInProgress = true;
        this.startChopAnimation(this.playerPosition, this.treeParts[0] != 2, this.branchTypes[0]);
        this.bPlayerChop = true;
        this.iPlayerFrame = 1;
    }

    private void gameOver() {
        this.bGameOver = true;
        this.setMedal();
        this.saveHighscore();
    }

    private boolean checkGameOver() {
        return this.playerPosition == 1 && this.treeParts[0] == 1 || this.playerPosition == 0 && this.treeParts[0] == 0;
    }

    public boolean isGameOver() {
        return this.bGameOver;
    }

    private void setMedal() {
        if (this.iScore >= MEDAL_POINTS[2]) {
            this.gameScreen.iMedal = 3;
        } else if (this.iScore >= MEDAL_POINTS[1]) {
            this.gameScreen.iMedal = 2;
        } else if (this.iScore >= MEDAL_POINTS[0]) {
            this.gameScreen.iMedal = 1;
        }
    }

    public void saveHighscore() {
        if (this.iScore >= HERO_POINTS[2]) {
            if (Profile.iUnlockedHero < 3) {
                Profile.iUnlockedHero = 3;
            }
        } else if (this.iScore >= HERO_POINTS[1]) {
            if (Profile.iUnlockedHero < 2) {
                Profile.iUnlockedHero = 2;
            }
        } else if (this.iScore >= HERO_POINTS[0] && Profile.iUnlockedHero < 1) {
            Profile.iUnlockedHero = 1;
        }
        if (this.iScore > Profile.iBestScore) {
            Profile.iBestScore = this.iScore;
            Profile.save();
        }
    }

    public int getScore() {
        return this.iScore;
    }

    private void paintTree(Graphics g) {
        g.drawImage(this.imgPen[iEnviroment], this.iTreeX, this.iTreeY + this.iTreeH, 17);
        for (int i = 0; i < 15; ++i) {
            if (i == 0 && this.chopInProgress) {
                this.iTreeY -= this.iTreeH >> 1;
                continue;
            }
            this.paintTreeTile(g, this.iTreeX, this.iTreeY + this.iTreeDownAnimOffset, this.treeParts[i], this.branchTypes[i]);
        }
        this.treeStepPaint = 0;
    }

    private void paintTreeTile(Graphics g, int x, int y, int tileType, int branchType) {
        g.drawImage(imgTree[iEnviroment], x, y - this.treeStepPaint * this.iTreeH, 17);
        if (tileType == 1) {
            sprBranches[iEnviroment][branchType].setTransform(0);
            sprBranches[iEnviroment][branchType].setPosition(x + (this.iTreeW >> 1), y - this.treeStepPaint * this.iTreeH + this.iTreeH - (this.iTwigHeight >> 1));
            sprBranches[iEnviroment][branchType].paint(g);
        } else if (tileType == 0) {
            sprBranches[iEnviroment][branchType].setTransform(2);
            sprBranches[iEnviroment][branchType].setPosition(x - this.iTwigWidth - (this.iTreeW >> 1), y - this.treeStepPaint * this.iTreeH + this.iTreeH - (this.iTwigHeight >> 1));
            sprBranches[iEnviroment][branchType].paint(g);
        }
        ++this.treeStepPaint;
    }

    private void paintPlayer(Graphics g) {
        if (this.bGameOver) {
            if (this.dustActFrame < 3) {
                this.sprGraveDust[iEnviroment].setFrame(this.dustActFrame);
                this.sprGraveDust[iEnviroment].setPosition(this.iPlayerX + (this.imgGrave[iEnviroment].getWidth() >> 1) - (this.sprGraveDust[iEnviroment].getWidth() >> 1), this.iPlayerY + (this.imgGrave[iEnviroment].getHeight() >> 1) - (this.sprGraveDust[iEnviroment].getHeight() >> 1));
                this.sprGraveDust[iEnviroment].paint(g);
            } else {
                g.drawImage(this.imgGrave[iEnviroment], this.iPlayerX, this.iPlayerY, 20);
                if (this.dustActFrame < 5) {
                    this.sprGraveDust[iEnviroment].setFrame(this.dustActFrame);
                    this.sprGraveDust[iEnviroment].setPosition(this.iPlayerX + (this.imgGrave[iEnviroment].getWidth() >> 1) - (this.sprGraveDust[iEnviroment].getWidth() >> 1), this.iPlayerY + (this.imgGrave[iEnviroment].getHeight() >> 1) - (this.sprGraveDust[iEnviroment].getHeight() >> 1));
                    this.sprGraveDust[iEnviroment].paint(g);
                }
            }
            return;
        }
        if (this.playerPosition == 1) {
            this.sprPlayer[this.gameScreen.iSelectedHero].setTransform(2);
        } else {
            this.sprPlayer[this.gameScreen.iSelectedHero].setTransform(0);
        }
        this.sprPlayer[this.gameScreen.iSelectedHero].setFrame(this.iPlayerFrame);
        this.sprPlayer[this.gameScreen.iSelectedHero].setPosition(this.iPlayerX, this.iPlayerY);
        if (this.playerPosition == 0) {
            g.drawImage(this.imgPlayerShadow[iEnviroment], this.sprPlayer[this.gameScreen.iSelectedHero].getX() + (this.sprPlayer[this.gameScreen.iSelectedHero].getWidth() >> 1) - (this.imgPlayerShadow[iEnviroment].getWidth() >> 1) - this.iOffShdw, this.sprPlayer[this.gameScreen.iSelectedHero].getY() + this.sprPlayer[this.gameScreen.iSelectedHero].getHeight() - (this.imgPlayerShadow[iEnviroment].getHeight() >> 1), 20);
        } else if (this.playerPosition == 1) {
            g.drawImage(this.imgPlayerShadow[iEnviroment], this.sprPlayer[this.gameScreen.iSelectedHero].getX() + (this.sprPlayer[this.gameScreen.iSelectedHero].getWidth() >> 1) - (this.imgPlayerShadow[iEnviroment].getWidth() >> 1) + this.iOffShdw, this.sprPlayer[this.gameScreen.iSelectedHero].getY() + this.sprPlayer[this.gameScreen.iSelectedHero].getHeight() - (this.imgPlayerShadow[iEnviroment].getHeight() >> 1), 20);
        }
        this.sprPlayer[this.gameScreen.iSelectedHero].paint(g);
    }

    private void paintEnergy(Graphics g) {
        g.setColor(6564625);
        g.fillRect(this.iEnergyX, this.iEnergyY, this.iEnergyMaxW, this.iEnergyH >> 1);
        g.setColor(0x713113);
        g.fillRect(this.iEnergyX, this.iEnergyY + (this.iEnergyH >> 1), this.iEnergyMaxW, this.iEnergyH >> 1);
        if (this.bEnergyAdd) {
            g.setColor(0xE94949);
            this.bEnergyAdd = false;
            g.fillRect(this.iEnergyX, this.iEnergyY, this.iEnergyActW, this.iEnergyH);
        } else {
            g.setColor(0xDB0000);
            g.fillRect(this.iEnergyX, this.iEnergyY, this.iEnergyActW, this.iEnergyH >> 1);
            g.setColor(0xC00000);
            g.fillRect(this.iEnergyX, this.iEnergyY + (this.iEnergyH >> 1), this.iEnergyActW, this.iEnergyH >> 1);
        }
    }

    private void paintScore(Graphics g) {
        if (this.iScore >= 0) {
            String s = this.iScore + "";
            int x = MainCanvas.WIDTH >> 1;
            this.gameScreen.fontNumbersBig.drawString(g, s.toCharArray(), x, MainCanvas.HEIGHT >> 2, 3);
        }
    }

    private void paintChopAnimations(Graphics g) {
    }

    private void paintTopBar(Graphics g) {
        g.setColor(4529677);
        g.fillRect(this.iTopBarX, this.iTopBarY, this.iTopBarW, this.iTopBarH);
        this.gameScreen.paintTable(g, this.gameScreen.sprDialog2, this.iBestScoreCenterX, this.iBestScoreCenterY, this.iBestScoreW, this.iBestScoreH);
        this.paintEnergy(g);
        this.paintBestScore(g);
    }

    private void paintTimer(Graphics g) {
        if (this.gameScreen.bIsFromPause) {
            this.gameScreen.fontNumbers.drawString(g, this.strSec, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, 3);
        }
    }

    private void paintBestScore(Graphics g) {
        if (this.gameScreen.iBestScore >= 0) {
            String s1 = this.gameScreen.sTextInfo + ": ";
            String s2 = this.gameScreen.iBestScore + "";
            int x = (MainCanvas.WIDTH >> 1) - (this.gameScreen.fontMain2.stringWidth(s1.toCharArray()) >> 1) - (this.gameScreen.fontNumbers.stringWidth(s2.toCharArray()) >> 1);
            this.gameScreen.fontMain2.drawString(g, s1.toCharArray(), x, this.iBestScoreTextCenterY - (this.gameScreen.fontMain2.getHeight() >> 1) - ScreenMain.onePixel, 20);
            this.gameScreen.fontNumbers.drawString(g, s2.toCharArray(), x += this.gameScreen.fontMain2.stringWidth(s1.toCharArray()), this.iBestScoreTextCenterY - (this.gameScreen.fontNumbers.getHeight() >> 1), 20);
        }
    }

    private void paintTutorialArrow(Graphics g, int centerX, int topY, String text, boolean left) {
        if (!this.gameScreen.bIsFromPause) {
            int aminOff = this.gameScreen.iShiftX;
            if (left) {
                this.tempTutorialSpr = this.sprTutorialLeft;
                centerX -= aminOff;
            } else {
                this.tempTutorialSpr = this.sprTutorialRight;
                centerX += aminOff;
            }
            this.tutorialTextW = left ? this.gameScreen.fontMain1.stringWidth(text.toCharArray()) : this.gameScreen.fontMain1.stringWidth(text.toCharArray());
            this.tutorialSprW = this.tempTutorialSpr.getWidth();
            this.tutorialCountSpr = this.tutorialTextW / this.tutorialSprW;
            if (this.tutorialCountSpr == 0) {
                ++this.tutorialCountSpr;
            }
            this.tutorialLeftX = this.tutorialCountSpr % 2 == 0 ? centerX - ((this.tutorialCountSpr >> 1) + 1) * this.tutorialSprW : centerX - ((this.tutorialCountSpr - 1 >> 1) + 1) * this.tutorialSprW - (this.tutorialSprW >> 1);
            this.tempTutorialSpr.setFrame(0);
            this.tempTutorialSpr.setPosition(this.tutorialLeftX, topY);
            this.tempTutorialSpr.paint(g);
            this.tempTutorialSpr.setFrame(1);
            for (int i = 0; i < this.tutorialCountSpr; ++i) {
                this.tempTutorialSpr.move(this.tutorialSprW, 0);
                this.tempTutorialSpr.paint(g);
            }
            this.tempTutorialSpr.setFrame(2);
            this.tempTutorialSpr.move(this.tutorialSprW, 0);
            this.tempTutorialSpr.paint(g);
            this.tutorialTextX = this.tutorialLeftX + this.tutorialSprW + ((this.tutorialCountSpr * this.tutorialSprW >> 1) - (this.tutorialTextW >> 1));
            this.gameScreen.fontMain2.drawString(g, text.toCharArray(), this.tutorialTextX, topY + (this.tempTutorialSpr.getHeight() >> 1) - (ScreenMain.onePixel >> 1), 6);
        }
    }

    public void paint(Graphics g) {
        this.paintTree(g);
        this.paintPlayer(g);
        this.paintChopAnimations(g);
        this.paintTopBar(g);
        switch (this.gameScreen.subScreen) {
            case 0: {
                this.paintTimer(g);
                this.paintTutorialArrow(g, this.iTutorialLeftX, this.iTutorialY, Resources.resTexts[0].getHashedString(29), true);
                this.paintTutorialArrow(g, this.iTutorialRightX, this.iTutorialY, Resources.resTexts[0].getHashedString(29), false);
                break;
            }
            case 1: {
                this.paintScore(g);
                break;
            }
            case 2: {
                if (this.gameScreen.iResultStep <= 0) {
                    // empty if block
                }
                if (this.gameScreen.iResultStep > 0) {
                    this.gameScreen.paintGameOverText(g);
                }
                if (this.gameScreen.iResultStep > 1) {
                    this.gameScreen.paintResult(g);
                }
                if (this.gameScreen.iResultStep <= 2) break;
                this.gameScreen.paintPlayButton(g, true);
                break;
            }
            case 3: {
                this.gameScreen.paintLogo(g);
                this.gameScreen.paintPauseMenu(g);
                break;
            }
            case 4: {
                this.gameScreen.paintInstructions(g);
                break;
            }
            case 5: {
                this.gameScreen.paintLogo(g);
                this.gameScreen.paintQuitToMenu(g);
                break;
            }
        }
    }

    public void update(long dt) {
        switch (this.gameScreen.subScreen) {
            case 0: {
                this.gameScreen.updateShift();
                this.updateTimer(dt);
                this.updateChopAnimations(dt);
                this.updateTopBar(dt, true);
                break;
            }
            case 1: {
                this.updateEnergy();
                this.updateChopAnimations(dt);
                if (this.bGameOver) {
                    this.updateTopBar(dt, false);
                } else {
                    this.updateTopBar(dt, true);
                }
                this.updateGameOver();
                break;
            }
            case 2: {
                this.updateTopBar(dt, false);
                this.updateChopAnimations(dt);
                this.gameScreen.updateResult(dt);
                break;
            }
            case 3: {
                this.gameScreen.updateMenu(dt);
                this.gameScreen.updateShift();
                this.updateTopBar(dt, false);
                break;
            }
            case 4: {
                this.gameScreen.updateMenu(dt);
                this.gameScreen.updateShift();
                this.updateTopBar(dt, false);
                this.gameScreen.updateInstructions();
                break;
            }
            case 5: {
                this.updateTopBar(dt, false);
                break;
            }
        }
        this.updateTree(dt);
        this.updatePlayer(dt);
    }

    private void updateChopAnimations(long dt) {
    }

    private void updateTopBar(long dt, boolean bShow) {
        if (bShow) {
            if (this.iTopBarY < 0) {
                this.setTopBarYPosition(this.iTopBarY + this.iTopBarAnimationStep);
            }
        } else {
            this.setTopBarYPosition(-this.iTopBarH);
        }
    }

    private void updateTimer(long dt) {
        if (this.gameScreen.bIsFromPause) {
            if (this.sec > 0) {
                if (this.sec > 2000) {
                    this.strSec[0] = 51;
                } else if (this.sec > 1000) {
                    this.strSec[0] = 50;
                } else if (this.sec > 0) {
                    this.strSec[0] = 49;
                }
                this.sec = (int)((long)this.sec - dt);
            } else {
                this.sec = 3000;
                this.gameScreen.getClass();
                this.gameScreen.nextScreen(2, 1);
                this.gameScreen.bIsFromPause = false;
            }
        }
    }

    private void updateGameOver() {
        if (this.bGameOver && this.iTopBarY <= 0 - this.iTopBarH && this.iPlayerY >= this.iGraveEndY) {
            this.gameScreen.getClass();
            this.gameScreen.nextScreen(2, 2);
        }
    }

    public void updatePlayer(long dt) {
        if (this.bGameOver) {
            if (this.dustActFrame < 3) {
                if (this.dustActFrameDuration > this.dustFrameDuration) {
                    this.dustActFrameDuration = 0;
                    ++this.dustActFrame;
                }
                this.iPlayerY = this.iGraveStartY;
                this.dustActFrameDuration = (int)((long)this.dustActFrameDuration + dt);
            } else {
                if (this.dustActFrame < 5 && this.dustActFrameDuration > this.dustFrameDuration) {
                    this.dustActFrameDuration = 0;
                    ++this.dustActFrame;
                }
                this.dustActFrameDuration = (int)((long)this.dustActFrameDuration + dt);
                if (this.iPlayerY < this.iGraveEndY) {
                    this.iPlayerY = this.iGraveStartY - this.iGraveStep * ScreenMain.onePixel;
                    --this.iGraveStep;
                } else {
                    this.iGraveStep = 1;
                    this.iPlayerY = this.iGraveEndY;
                }
            }
            this.iPlayerX = this.playerPosition == 0 ? this.iGraveLeftX : this.iGraveRightX;
            return;
        }
        this.actFrameDuration = (int)((long)this.actFrameDuration + dt);
        if (!this.bPlayerChop) {
            if (this.actFrameDuration > this.frameDuration) {
                this.actFrameDuration = 0;
                if (this.iPlayerFrame == 0) {
                    this.iPlayerFrame = 1;
                } else if (this.iPlayerFrame == 1) {
                    this.iPlayerFrame = 0;
                }
            }
        } else if (this.actFrameDuration > this.chopFrameDuration) {
            this.actFrameDuration = 0;
            if (this.iPlayerFrame == 0 || this.iPlayerFrame == 1) {
                this.iPlayerFrame = this.iTotalPlayerFrames;
            } else if (this.iPlayerFrame == this.iTotalPlayerFrames) {
                this.iPlayerFrame = 0;
                this.bPlayerChop = false;
            }
        }
        this.iPlayerY = this.iPlayerHeroY;
        this.iPlayerX = this.playerPosition == 0 ? this.iPlayerLeftX : this.iPlayerRightX;
    }

    private void updateTree(long dt) {
        this.iTreeX = MainCanvas.WIDTH >> 1;
        this.iTreeY = MainCanvas.HEIGHT - this.iTreeH - this.imgPen[iEnviroment].getHeight() - this.gameScreen.imgBtnPause.getHeight();
        if (this.chopInProgress) {
            for (int i = 0; i < 14; ++i) {
                this.treeParts[i] = this.treeParts[i + 1];
                this.branchTypes[i] = this.branchTypes[i + 1];
            }
            this.generateNextTreePart();
            if (!this.checkGameOver()) {
                ++this.iScore;
                if (this.iScore % 25 == 0 && this.currEnergyLvl < ENERGY_LVL.length - 1) {
                    this.currEnergyLvl = (byte)(this.currEnergyLvl + 1);
                }
            } else {
                this.gameOver();
            }
            this.chopInProgress = false;
        }
    }

    private void updateEnergy() {
        this.actEnergy -= 10;
        if (this.actEnergy <= 0) {
            this.gameOver();
            return;
        }
        this.iEnergyActW = this.getActEnergyW();
    }

    private void logTree(String state) {
    }

    static {
        ENERGY_LVL = new int[]{31, 30, 29, 28, 26, 25, 24, 23, 22, 21, 20, 19};
        ENERGY_BONUS = new int[]{0, 1, 2, 3};
    }
}

