/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.game.Game;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class ScreenMain
implements IScreen {
    public MainCanvas mainCanvas;
    public GFont fontMain1;
    public GFont fontMain2;
    public GFont fontNumbers;
    public GFont fontNumbersBig;
    public final byte SCREEN_INTRO;
    public final byte SCREEN_MENU;
    public final byte SCREEN_GAME = (byte)2;
    public final byte INTRO_INIT_GRAPHICS;
    public final byte INTRO_INIT;
    public final byte INTRO_LOGO_INLOGIC = (byte)2;
    public final byte INTRO_LANGUAGE = (byte)3;
    public final byte INTRO_ENABLE_MUSIC = (byte)4;
    public final byte MENU_MAIN;
    public final byte MENU_INSTRUCTIONS;
    public final byte MENU_ABOUT = (byte)2;
    public final byte MENU_MORE_GAMES = (byte)3;
    public final byte MENU_QUIT = (byte)4;
    public final byte MENU_SELECT_HERO = (byte)5;
    public static final byte GAME_READY = 0;
    public static final byte GAME_MAIN = 1;
    public static final byte GAME_OVER = 2;
    public static final byte GAME_PAUSE = 3;
    public static final byte GAME_INSTRUCTIONS = 4;
    public static final byte GAME_QUIT_TO_MENU = 5;
    final byte ID_MENU_PLAY;
    final byte ID_MENU_INSTRUCTIONS;
    final byte ID_MENU_SOUND = (byte)2;
    final byte ID_MENU_ABOUT = (byte)3;
    final byte ID_MENU_MORE_GAMES = (byte)4;
    final byte ID_MENU_ITEMS_TOTAL = (byte)5;
    final byte ID_PAUSE_SOUND;
    final byte ID_PAUSE_INSTRUCTIONS;
    final byte ID_PAUSE_QUIT_TO_MENU = (byte)2;
    final byte ID_PAUSE_ITEMS_TOTAL = (byte)3;
    private int iMenuItemsTotal;
    private int iHeroShift;
    private int iHeroShiftSteps = 8;
    String link;
    String buysetup;
    private int screen;
    public int subScreen;
    private int iSelectedMenuItem;
    private int iShiftDirection;
    public int iShiftX;
    private int iShiftStep;
    private int updateCounter = 0;
    boolean bMoreGames = false;
    boolean bLoading = false;
    boolean bFlash = false;
    int iChangeSelectedHero = 0;
    public static final byte MAX_HEROES = 4;
    static final byte MAX_MEDALS = 4;
    private static final String[] strHeroes = new String[]{"FREDDY", "FRANKENSTEIN", "JASON", "SCREAM"};
    private static final int BG_COLOR = 0x585757;
    Image imgLogoInlogic;
    Image imgLogoInlogic2;
    Image imgTitle;
    public Image imgBtnPause;
    Image imgBtnOk;
    Image imgBtnCancel;
    Image imgBtnBack;
    Image imgBtnQuit;
    Image imgShadowMenu;
    Image imgLock;
    Image[] imgHeroes = new Image[4];
    Image[] imgMedals = new Image[4];
    Image[] imgBg = new Image[3];
    Sprite sprLanguage;
    public Sprite sprDialog;
    public Sprite sprDialog2;
    Sprite sprButton;
    Sprite sprArrow;
    Sprite sprArrow02;
    Sprite sprStars;
    private int iScoreShowed;
    public int iSelectedHero;
    private int iEnviroment;
    public static int onePixel;
    public int iMedal;
    Rectangle[] rectMenuItems;
    Rectangle[] rectPauseItems;
    Rectangle rectPlayButton;
    Rectangle rectTitle;
    Rectangle rectTitleCenter;
    Rectangle rectExitGame;
    private Game game;
    private int iSelectHeroImgX;
    private int iSelectHeroimgY;
    private int iSelectHeroDialogWidth;
    private int iSelectHeroDialogHeight;
    private int iSelectHeroDialogY;
    private int iSelectHeroFontY;
    private int iSelectHeroArrowLeftX;
    private int iSelectHeroArrowRightX;
    private int iSelectHeroArrowY;
    private int iTitleX;
    private int iTitleY;
    private int menuButtonH;
    private int menuButtonW;
    private int iMenuItemSpaceY;
    private int iTitleAreaH;
    private int iResultTableCenterY;
    private int iResultTableWidth;
    private int iResultTableHeight;
    public int iBestScore;
    public int iResultStep = 0;
    private int iResultCounter = 0;
    private int iAboutCenterY;
    private int iAboutWidth;
    private int iAboutHeight;
    private int iInstructionsCenterY;
    private int iInstructionsWidth;
    private int iInstructionsHeight;
    private int iTextShiftY = 0;
    private int iInstructionsShiftY = 0;
    private int iInstructionsMaxShiftY = 0;
    boolean bDragInstructions = false;
    private int iTextLines = 1;
    String sTextTitle;
    String sTextButton;
    public String sTextInfo;
    String[] sTextMenu = new String[5];
    String[] sTextPom = new String[3];
    String sTextUnlock;
    String[] sTextNumberToUnlock = new String[]{"100", "200", "300"};
    PreparedText prepText;
    private static final int DELAY_TIME = 3000;
    private int delay;
    private static String[] langCodes;
    private static final int[] LANGUAGES;
    private static final int MAX_LANGUAGES = 5;
    private Rectangle[] rectLanguages = new Rectangle[5];
    private int iSelectedLanguage;
    int actFlashTime = 0;
    int maxFlashTime = 120;
    int iMenuStartY;
    int iMenuEndY;
    int iMenuStepY;
    boolean bChangingHero = false;
    private int iHeroShiftX;
    public boolean bIsFromPause = false;
    int iOffsetTitle;

    public ScreenMain(MainCanvas mainCanvas) {
        this.SCREEN_INTRO = 0;
        this.SCREEN_MENU = 1;
        this.INTRO_INIT_GRAPHICS = 0;
        this.INTRO_INIT = 1;
        this.MENU_MAIN = 0;
        this.MENU_INSTRUCTIONS = 1;
        this.ID_MENU_PLAY = 0;
        this.ID_MENU_INSTRUCTIONS = 1;
        this.ID_PAUSE_SOUND = 0;
        this.ID_PAUSE_INSTRUCTIONS = 1;
        this.mainCanvas = mainCanvas;
        this.setOnePixel();
    }

    private void setOnePixel() {
        onePixel = MainCanvas.WIDTH < 240 ? 1 : (MainCanvas.WIDTH < 480 ? 2 : (MainCanvas.WIDTH < 720 ? 3 : 4));
    }

    public void update(long lTick) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (!this.bLoading) {
            block0 : switch (this.screen) {
                case 0: {
                    switch (this.subScreen) {
                        case 0: {
                            this.initGraphics();
                            break block0;
                        }
                        case 1: {
                            this.initIntro();
                            break block0;
                        }
                        case 2: {
                            if (this.delay > 0) {
                                this.delay = (int)((long)this.delay - lTick);
                                break block0;
                            }
                            this.nextScreen(0, 3);
                            break block0;
                        }
                        case 3: {
                            this.updateShift();
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.subScreen) {
                        case 0: {
                            this.updateMenu(lTick);
                            this.updateShift();
                            break block0;
                        }
                        case 1: {
                            this.updateInstructions();
                            break block0;
                        }
                        case 5: {
                            this.updateShift();
                            this.updateChangeHero(lTick);
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    this.game.update(lTick);
                    break;
                }
            }
            this.updateFlash(lTick);
            this.mainCanvas.repaint();
        }
    }

    public void updateFlash(long dt) {
        if (this.bFlash) {
            if (this.actFlashTime < this.maxFlashTime) {
                this.actFlashTime = (int)((long)this.actFlashTime + dt);
            } else {
                this.bFlash = false;
                this.actFlashTime = 0;
            }
        }
    }

    public void updateMenu(long dt) {
        if (this.iTitleY < this.iMenuEndY) {
            this.iTitleY += this.iMenuStepY;
            if (this.iTitleY > this.iMenuEndY) {
                this.iTitleY = this.iMenuEndY;
            }
        }
    }

    public void updateChangeHero(long dt) {
        if (this.iChangeSelectedHero > 0) {
            if (this.iChangeSelectedHero == 1) {
                if (this.iHeroShiftX > -this.imgHeroes[0].getWidth()) {
                    this.iHeroShiftX -= this.iHeroShift;
                } else {
                    this.iHeroShiftX = -this.iHeroShiftX;
                    this.iChangeSelectedHero = -this.iChangeSelectedHero;
                    this.changeSelectedHero(-this.iChangeSelectedHero);
                }
            } else if (this.iChangeSelectedHero == 2) {
                if (this.iHeroShiftX < this.imgHeroes[0].getWidth()) {
                    this.iHeroShiftX += this.iHeroShift;
                } else {
                    this.iHeroShiftX = -this.iHeroShiftX;
                    this.iChangeSelectedHero = -this.iChangeSelectedHero;
                    this.changeSelectedHero(-this.iChangeSelectedHero);
                }
            }
        } else if (this.iChangeSelectedHero < 0) {
            if (this.iChangeSelectedHero == -1) {
                if (this.iHeroShiftX != 0) {
                    this.iHeroShiftX -= this.iHeroShift;
                } else {
                    this.iChangeSelectedHero = 0;
                }
            } else if (this.iChangeSelectedHero == -2) {
                if (this.iHeroShiftX != 0) {
                    this.iHeroShiftX += this.iHeroShift;
                } else {
                    this.iChangeSelectedHero = 0;
                }
            }
        }
    }

    public void updateResult(long lTick) {
        if (this.game.isGameOver() && this.iResultStep < 5) {
            if (this.iResultStep == 2) {
                if (this.iScoreShowed != this.game.getScore()) {
                    this.iResultCounter = (int)((long)this.iResultCounter + lTick);
                    if (this.iResultCounter >= 250) {
                        int step = this.game.getScore() >> 3;
                        if (step < 1) {
                            step = 1;
                        }
                        this.iScoreShowed += step;
                        if (this.iScoreShowed >= this.game.getScore()) {
                            this.iScoreShowed = this.game.getScore();
                            this.iResultCounter = 0;
                        }
                    }
                    return;
                }
                if (this.iBestScore != Profile.iBestScore) {
                    this.iResultCounter = (int)((long)this.iResultCounter + lTick);
                    if (this.iResultCounter >= 250) {
                        this.iResultCounter = 0;
                        this.iBestScore = Profile.iBestScore;
                    }
                    return;
                }
            }
            this.iResultCounter = (int)((long)this.iResultCounter + lTick);
            if (this.iResultCounter >= 250) {
                this.iResultCounter = 0;
                ++this.iResultStep;
            }
        }
    }

    public void updateShift() {
        ++this.updateCounter;
        if (this.updateCounter > 1) {
            this.updateCounter = 0;
            if (this.iShiftDirection > 0) {
                this.iShiftX += this.iShiftStep;
                if (this.iShiftX >= this.iShiftStep << 1) {
                    this.iShiftDirection = -1;
                }
            } else {
                this.iShiftX -= this.iShiftStep;
                if (this.iShiftX <= -(this.iShiftStep << 1)) {
                    this.iShiftDirection = 1;
                }
            }
        }
    }

    public void paint(Graphics g) {
        block0 : switch (this.screen) {
            case 0: {
                this.paintBgIntro(g);
                switch (this.subScreen) {
                    case 2: {
                        this.paintLogoInlogic(g);
                        break block0;
                    }
                    case 3: {
                        this.paintLanguages(g);
                        break block0;
                    }
                    case 4: {
                        this.paintEnableMusic(g);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                this.paintBg(g);
                switch (this.subScreen) {
                    case 0: {
                        this.paintLogo(g);
                        this.paintMainMenu(g);
                        break block0;
                    }
                    case 1: {
                        this.paintInstructions(g);
                        break block0;
                    }
                    case 2: {
                        this.paintAbout(g);
                        break block0;
                    }
                    case 3: {
                        this.paintLogo(g);
                        this.paintMoreGames(g);
                        break block0;
                    }
                    case 4: {
                        this.paintLogo(g);
                        this.paintQuit(g);
                        break block0;
                    }
                    case 5: {
                        this.paintSelectHero(g);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                this.paintBg(g);
                this.game.paint(g);
                break;
            }
        }
        this.paintControls(g);
        this.paintFlash(g);
    }

    public void paintFlash(Graphics g) {
        if (this.bFlash) {
            g.setColor(0x585757);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        }
    }

    public void paintControls(Graphics g) {
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 3: {
                        this.paintLeftButton(g);
                        break block0;
                    }
                    case 4: {
                        this.paintLeftButton(g);
                        this.paintRightButton(g);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: 
                    case 5: {
                        this.paintLeftButton(g);
                        this.paintRightButton(g);
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        this.paintRightButton(g);
                        break block0;
                    }
                    case 3: 
                    case 4: {
                        this.paintLeftButton(g);
                        this.paintRightButton(g);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 1: {
                        this.paintRightButton(g);
                        break block0;
                    }
                    case 3: {
                        this.paintLeftButton(g);
                        this.paintRightButton(g);
                        break block0;
                    }
                    case 0: {
                        if (this.bIsFromPause) break block0;
                        this.paintRightButton(g);
                        break block0;
                    }
                    case 4: {
                        this.paintRightButton(g);
                        break block0;
                    }
                    case 2: {
                        if (this.iResultStep <= 2) break block0;
                        this.paintLeftButton(g);
                        this.paintRightButton(g);
                        break block0;
                    }
                    case 5: {
                        this.paintLeftButton(g);
                        this.paintRightButton(g);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void paintLeftButton(Graphics g) {
        g.drawImage(this.imgBtnOk, 0, MainCanvas.HEIGHT - this.imgBtnOk.getHeight(), 20);
    }

    public void paintRightButton(Graphics g) {
        switch (this.screen) {
            case 0: {
                g.drawImage(this.imgBtnCancel, MainCanvas.WIDTH - this.imgBtnCancel.getWidth(), MainCanvas.HEIGHT - this.imgBtnCancel.getHeight(), 20);
                break;
            }
            case 1: {
                if (this.subScreen == 0) {
                    g.drawImage(this.imgBtnQuit, MainCanvas.WIDTH - this.imgBtnQuit.getWidth(), MainCanvas.HEIGHT - this.imgBtnQuit.getHeight(), 20);
                    break;
                }
                if (this.subScreen == 4 || this.subScreen == 3) {
                    g.drawImage(this.imgBtnCancel, MainCanvas.WIDTH - this.imgBtnCancel.getWidth(), MainCanvas.HEIGHT - this.imgBtnCancel.getHeight(), 20);
                    break;
                }
                g.drawImage(this.imgBtnBack, MainCanvas.WIDTH - this.imgBtnBack.getWidth(), MainCanvas.HEIGHT - this.imgBtnBack.getHeight(), 20);
                break;
            }
            case 2: {
                if (this.subScreen == 1 || this.subScreen == 0) {
                    g.drawImage(this.imgBtnPause, MainCanvas.WIDTH - this.imgBtnPause.getWidth(), MainCanvas.HEIGHT - this.imgBtnPause.getHeight(), 20);
                    break;
                }
                if (this.subScreen == 5) {
                    g.drawImage(this.imgBtnCancel, MainCanvas.WIDTH - this.imgBtnCancel.getWidth(), MainCanvas.HEIGHT - this.imgBtnCancel.getHeight(), 20);
                    break;
                }
                g.drawImage(this.imgBtnBack, MainCanvas.WIDTH - this.imgBtnBack.getWidth(), MainCanvas.HEIGHT - this.imgBtnBack.getHeight(), 20);
                break;
            }
        }
    }

    public void paintBgIntro(Graphics g) {
        g.setColor(0x585757);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public void paintLogoInlogic(Graphics g) {
        g.drawImage(this.imgLogoInlogic, (MainCanvas.WIDTH >> 1) - (this.imgLogoInlogic.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) - (this.imgLogoInlogic.getHeight() >> 1), 20);
    }

    public void paintLanguages(Graphics g) {
        for (int i = 0; i < 5; ++i) {
            int pomShiftX = 0;
            if (i == this.iSelectedLanguage) {
                pomShiftX = this.iShiftX;
            }
            this.sprLanguage.setFrame(LANGUAGES[i]);
            this.sprLanguage.setPosition(this.rectLanguages[i].x + pomShiftX, this.rectLanguages[i].y);
            this.sprLanguage.paint(g);
        }
    }

    public void paintEnableMusic(Graphics g) {
        this.paintButton2(g, this.rectTitleCenter);
    }

    public void paintBg(Graphics g) {
        if (this.screen == 2) {
            g.drawImage(this.imgBg[Game.iEnviroment], 0, 0, 20);
        } else {
            g.drawImage(this.imgBg[0], 0, 0, 20);
        }
    }

    public void paintLogo(Graphics g) {
        g.drawImage(this.imgTitle, this.iTitleX, this.iTitleY, 20);
    }

    public void paintMainMenu(Graphics g) {
        String s = "";
        for (int i = 0; i < this.iMenuItemsTotal; ++i) {
            s = this.sTextMenu[i];
            if (this.screen == 1 && this.subScreen == 0 && i == 2) {
                s = s + " " + (Profile.bMusic ? this.sTextPom[0] : this.sTextPom[1]);
            }
            if (i == this.iSelectedMenuItem) {
                this.paintMenuButton(g, this.rectMenuItems[i], s, true);
                continue;
            }
            this.paintMenuButton(g, this.rectMenuItems[i], s, false);
        }
    }

    public void paintPauseMenu(Graphics g) {
        String s = "";
        for (int i = 0; i < 3; ++i) {
            s = this.sTextMenu[i];
            if (this.screen == 2 && this.subScreen == 3 && i == 0) {
                s = s + " " + (Profile.bMusic ? this.sTextPom[0] : this.sTextPom[1]);
            }
            if (i == this.iSelectedMenuItem) {
                this.paintMenuButton(g, this.rectPauseItems[i], s, true);
                continue;
            }
            this.paintMenuButton(g, this.rectPauseItems[i], s, false);
        }
    }

    public void paintMenuButton(Graphics g, Rectangle rect, String s, boolean bSelected) {
        int pomShiftX = 0;
        if (bSelected) {
            pomShiftX = this.iShiftX;
        }
        this.paintTable(g, this.sprButton, rect.getCenterX() + pomShiftX, rect.getCenterY(), rect.width, rect.height);
        this.fontMain1.drawString(g, s.toCharArray(), rect.getCenterX() - (this.fontMain1.stringWidth(s.toCharArray()) >> 1) + pomShiftX, rect.getCenterY() - (this.fontMain1.getHeight() >> 1) - 1, 20);
    }

    public void paintInstructions(Graphics g) {
        this.paintButton(g, this.rectTitle, this.sTextTitle, true);
        this.paintTable(g, this.sprDialog, MainCanvas.WIDTH >> 1, this.iInstructionsCenterY, this.iInstructionsWidth, this.iInstructionsHeight);
        if (!this.bLoading) {
            this.paintInstructionsText(g);
        }
    }

    public void paintUnlockHero(Graphics g, String[] s) {
        int x = MainCanvas.WIDTH >> 1;
        int y = this.iSelectHeroDialogY + (this.fontMain1.getHeight() << 1) + this.fontMain1.getHeight();
        this.fontMain1.drawString(g, this.sTextUnlock.toCharArray(), x, y, 3);
        switch (this.iSelectedHero) {
            case 1: {
                this.fontNumbers.drawString(g, s[0].toCharArray(), x, this.iSelectHeroDialogY + (this.fontMain1.getHeight() << 1) + (this.fontNumbers.getHeight() >> 1), 3);
                break;
            }
            case 2: {
                this.fontNumbers.drawString(g, s[1].toCharArray(), x, this.iSelectHeroDialogY + (this.fontMain1.getHeight() << 1) + (this.fontNumbers.getHeight() >> 1), 3);
                break;
            }
            case 3: {
                this.fontNumbers.drawString(g, s[2].toCharArray(), x, this.iSelectHeroDialogY + (this.fontMain1.getHeight() << 1) + (this.fontNumbers.getHeight() >> 1), 3);
            }
        }
    }

    public void updateInstructions() {
        if ((Keys.isActionPressed(1) || Keys.isKeyPressed(50)) && this.iInstructionsShiftY > 0) {
            this.iInstructionsShiftY -= this.fontMain1.getHeight();
            if (this.iInstructionsShiftY < 0) {
                this.iInstructionsShiftY = 0;
            }
        }
        if ((Keys.isActionPressed(2) || Keys.isKeyPressed(56)) && this.iInstructionsShiftY < this.iInstructionsMaxShiftY) {
            this.iInstructionsShiftY += this.fontMain1.getHeight();
            if (this.iInstructionsShiftY > this.iInstructionsMaxShiftY) {
                this.iInstructionsShiftY = this.iInstructionsMaxShiftY;
            }
        }
    }

    public boolean isPressedInstructionsText(int x, int y) {
        return x > (MainCanvas.WIDTH >> 1) - (this.iInstructionsWidth >> 1) && x < (MainCanvas.WIDTH >> 1) + (this.iInstructionsWidth >> 1) && y > this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) && y < this.iInstructionsCenterY + (this.iInstructionsHeight >> 1);
    }

    public void paintInstructionsText(Graphics g) {
        int iTextYUp = this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) + this.sprArrow.getHeight() * 3;
        int iTextYDown = this.iInstructionsCenterY + (this.iInstructionsHeight >> 1) - this.sprArrow.getHeight() * 3;
        if (this.iInstructionsShiftY > 0) {
            this.sprArrow.setTransform(3);
            this.sprArrow.setFrame(1);
            this.sprArrow.setPosition((MainCanvas.WIDTH >> 1) - (this.sprArrow.getWidth() >> 1), iTextYUp - this.sprArrow.getHeight() - (this.sprArrow.getHeight() >> 1));
            this.sprArrow.paint(g);
        }
        if (this.iInstructionsShiftY < this.iInstructionsMaxShiftY) {
            this.sprArrow.setTransform(3);
            this.sprArrow.setFrame(0);
            this.sprArrow.setPosition((MainCanvas.WIDTH >> 1) - (this.sprArrow.getWidth() >> 1), iTextYDown + (this.sprArrow.getHeight() >> 1));
            this.sprArrow.paint(g);
        }
        g.setClip(0, iTextYUp, MainCanvas.WIDTH, iTextYDown - iTextYUp);
        int lineY = 0;
        for (int i = 0; i < this.iTextLines; ++i) {
            lineY = iTextYUp + i * this.fontMain1.getHeight() - this.iInstructionsShiftY;
            if (lineY <= this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) || lineY + this.fontMain1.getHeight() >= this.iInstructionsCenterY + (this.iInstructionsHeight >> 1)) continue;
            this.fontMain1.drawString(g, this.prepText.getText(i).toCharArray(), MainCanvas.WIDTH >> 1, lineY, 17);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public void paintAbout(Graphics g) {
        this.paintButton(g, this.rectTitle, this.sTextTitle, true);
        this.paintTable(g, this.sprDialog, MainCanvas.WIDTH >> 1, this.iAboutCenterY, this.iAboutWidth, this.iAboutHeight + this.fontMain1.getHeight());
        int pomHeight = this.imgLogoInlogic.getHeight() + (this.fontMain1.getHeight() << 1) + (this.fontMain1.getHeight() >> 1);
        int pomY = this.iAboutCenterY - (pomHeight >> 1);
        g.drawImage(this.imgLogoInlogic2, (MainCanvas.WIDTH >> 1) - (this.imgLogoInlogic.getWidth() >> 1), pomY, 20);
        this.sTextPom[2] = this.sTextPom[0].substring(0, 9);
        this.fontMain1.drawString(g, this.sTextPom[2].toCharArray(), (MainCanvas.WIDTH >> 1) - (this.fontMain1.stringWidth(this.sTextPom[2].toCharArray()) >> 1), pomY += this.imgLogoInlogic.getHeight() + (this.fontMain1.getHeight() >> 1), 20);
        this.sTextPom[2] = this.sTextPom[0].substring(10, 25);
        this.fontMain1.drawString(g, this.sTextPom[2].toCharArray(), (MainCanvas.WIDTH >> 1) - (this.fontMain1.stringWidth(this.sTextPom[2].toCharArray()) >> 1), pomY += this.fontMain1.getHeight(), 20);
        this.fontMain2.drawString(g, this.sTextPom[1].toCharArray(), (MainCanvas.WIDTH >> 1) - (this.fontMain1.stringWidth(this.sTextPom[1].toCharArray()) >> 1), pomY += this.fontMain1.getHeight(), 20);
    }

    public void paintMoreGames(Graphics g) {
        this.paintButton2(g, this.rectTitleCenter);
    }

    public void paintQuit(Graphics g) {
        this.paintButton2(g, this.rectExitGame);
    }

    public void paintQuitToMenu(Graphics g) {
        this.paintButton2(g, this.rectExitGame);
    }

    public void paintSelectHero(Graphics g) {
        this.paintTable(g, this.sprDialog, MainCanvas.WIDTH >> 1, this.iSelectHeroDialogY, this.iSelectHeroDialogWidth, this.iSelectHeroDialogHeight);
        g.setClip(this.iSelectHeroImgX, this.iSelectHeroimgY, this.imgHeroes[0].getWidth(), this.imgHeroes[0].getHeight() + (this.imgShadowMenu.getHeight() >> 1));
        g.drawImage(this.imgShadowMenu, this.iSelectHeroImgX + (this.imgHeroes[0].getWidth() >> 1) - (this.imgShadowMenu.getWidth() >> 1) - this.iHeroShiftX, this.iSelectHeroimgY + this.imgHeroes[this.iSelectedHero].getHeight() - (this.imgShadowMenu.getHeight() >> 1), 20);
        if (this.iSelectedHero > 0) {
            g.drawImage(this.imgHeroes[this.iSelectedHero], this.iSelectHeroImgX + ((this.imgHeroes[0].getWidth() >> 1) - (this.imgHeroes[this.iSelectedHero].getWidth() >> 1)) - this.iHeroShiftX, this.iSelectHeroimgY, 20);
        } else {
            g.drawImage(this.imgHeroes[this.iSelectedHero], this.iSelectHeroImgX - this.iHeroShiftX, this.iSelectHeroimgY, 20);
        }
        if (this.iSelectedHero > Profile.iUnlockedHero) {
            g.drawImage(this.imgLock, this.iSelectHeroImgX + (this.imgHeroes[0].getWidth() >> 1) - (this.imgLock.getWidth() >> 1) - this.iHeroShiftX, this.iSelectHeroimgY + (this.imgHeroes[this.iSelectedHero].getHeight() >> 1) - (this.imgLock.getHeight() >> 1), 20);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this.fontMain1.drawString(g, strHeroes[this.iSelectedHero].toCharArray(), MainCanvas.WIDTH >> 1, this.iSelectHeroFontY, 3);
        if (this.iSelectedHero > 0) {
            this.sprArrow02.setFrame(0);
            this.sprArrow02.setPosition(this.iSelectHeroArrowLeftX - this.iShiftX, this.iSelectHeroArrowY);
            this.sprArrow02.paint(g);
        }
        if (this.iSelectedHero != 3) {
            this.sprArrow02.setFrame(1);
            this.sprArrow02.setPosition(this.iSelectHeroArrowRightX + this.iShiftX, this.iSelectHeroArrowY);
            this.sprArrow02.paint(g);
        }
        if (this.iSelectedHero > Profile.iUnlockedHero) {
            this.paintPlayButton(g, false);
            this.paintUnlockHero(g, this.sTextNumberToUnlock);
        } else {
            this.paintPlayButton(g, true);
        }
    }

    public void paintPlayButton(Graphics g, boolean bActive) {
        this.paintButton(g, this.rectPlayButton, this.sTextButton, bActive);
    }

    public void paintButton(Graphics g, Rectangle rect, String s, boolean bActive) {
        this.paintTable(g, this.sprButton, rect.getCenterX(), rect.getCenterY(), rect.width, rect.height);
        if (bActive) {
            this.fontMain1.drawString(g, s.toCharArray(), rect.getCenterX() - (this.fontMain2.stringWidth(s.toCharArray()) >> 1), rect.getCenterY() - (this.fontMain2.getHeight() >> 1) - 1, 20);
        } else {
            this.fontMain2.drawString(g, s.toCharArray(), rect.getCenterX() - (this.fontMain1.stringWidth(s.toCharArray()) >> 1), rect.getCenterY() - (this.fontMain1.getHeight() >> 1) - 1, 20);
        }
    }

    public void paintButton2(Graphics g, Rectangle rect) {
        int iCenterY = rect.y;
        if (this.screen == 0) {
            iCenterY = MainCanvas.HEIGHT >> 1;
        }
        this.paintTable(g, this.sprButton, rect.getCenterX(), iCenterY, rect.width, rect.height);
        int textHeight = this.fontMain2.getHeight() * this.iTextLines;
        int pomY = iCenterY - (textHeight >> 1) - 1;
        for (int i = 0; i < this.iTextLines; ++i) {
            this.fontMain1.drawString(g, this.prepText.getText(i).toCharArray(), rect.getCenterX(), pomY, 17);
            pomY += this.fontMain1.getHeight();
        }
    }

    public void paintTable(Graphics g, Sprite spr, int centerX, int centerY, int width, int height) {
        int i;
        if (height < spr.getHeight() << 1) {
            height = spr.getHeight() << 1;
        }
        int left = centerX - (width >> 1);
        int top = centerY - (height >> 1);
        int countX = (width - (spr.getWidth() << 1)) / spr.getWidth() + 1;
        int countY = (height - (spr.getHeight() << 1)) / spr.getHeight() + 1;
        int iX = left;
        int iY = top;
        spr.setFrame(0);
        spr.setPosition(iX, iY);
        spr.paint(g);
        for (i = 0; i < countY; ++i) {
            spr.setFrame(3);
            spr.setPosition(iX, iY += spr.getHeight());
            spr.paint(g);
        }
        iY = top + height - spr.getHeight();
        spr.setFrame(6);
        spr.setPosition(iX, iY);
        spr.paint(g);
        for (i = 0; i < countX; ++i) {
            iY = top;
            spr.setFrame(1);
            spr.setPosition(iX += spr.getWidth(), iY);
            spr.paint(g);
            for (int j = 0; j < countY; ++j) {
                spr.setFrame(4);
                spr.setPosition(iX, iY += spr.getHeight());
                spr.paint(g);
            }
            iY = top + height - spr.getHeight();
            spr.setFrame(7);
            spr.setPosition(iX, iY);
            spr.paint(g);
        }
        iX = left + width - spr.getWidth();
        iY = top;
        spr.setFrame(2);
        spr.setPosition(iX, iY);
        spr.paint(g);
        for (i = 0; i < countY; ++i) {
            spr.setFrame(5);
            spr.setPosition(iX, iY += spr.getHeight());
            spr.paint(g);
        }
        iY = top + height - spr.getHeight();
        spr.setFrame(8);
        spr.setPosition(iX, iY);
        spr.paint(g);
    }

    public void paintResult(Graphics g) {
        this.paintTable(g, this.sprDialog, MainCanvas.WIDTH >> 1, this.iResultTableCenterY, this.iResultTableWidth, this.iResultTableHeight);
        int pomX1 = (MainCanvas.WIDTH >> 1) - (this.iResultTableWidth >> 2) + (this.sprDialog.getWidth() >> 2);
        int pomX2 = (MainCanvas.WIDTH >> 1) + (this.iResultTableWidth >> 2) - (this.sprDialog.getWidth() >> 2);
        int pomHeight1 = this.fontMain1.getHeight() + this.imgMedals[this.iMedal].getHeight() + (this.fontMain1.getHeight() >> 2);
        int pomHeight2 = (this.fontMain1.getHeight() << 1) + this.fontMain1.getHeight() + (this.fontNumbers.getHeight() << 1);
        if (Resources.langCode.compareTo("es") == 0) {
            pomX1 -= this.fontMain1.getSpaceWidth() >> 1;
            pomX2 -= this.fontMain1.getSpaceWidth() >> 1;
            pomHeight1 -= this.fontMain1.getHeight() >> 3;
            pomHeight2 += this.fontMain1.getHeight() >> 2;
        } else if (Resources.langCode.compareTo("pt") == 0) {
            pomX1 -= this.fontMain1.getSpaceWidth() >> 1;
            pomHeight1 -= this.fontMain1.getHeight() >> 3;
            pomHeight2 += this.fontMain1.getHeight() >> 2;
        }
        this.fontMain1.drawString(g, this.sTextPom[0].toCharArray(), pomX1 - (this.fontMain1.stringWidth(this.sTextPom[0].toCharArray()) >> 1), this.iResultTableCenterY - (pomHeight1 >> 1), 20);
        g.drawImage(this.imgMedals[this.iMedal], pomX1 - (this.imgMedals[this.iMedal].getWidth() >> 1), this.iResultTableCenterY + (pomHeight1 >> 1) - this.imgMedals[this.iMedal].getHeight(), 20);
        int pomY = this.iResultTableCenterY - (pomHeight2 >> 1);
        this.fontMain1.drawString(g, this.sTextPom[1].toCharArray(), pomX2 - (this.fontMain1.stringWidth(this.sTextPom[1].toCharArray()) >> 1), pomY, 20);
        this.fontNumbers.drawString(g, (this.iScoreShowed + "").toCharArray(), pomX2 - (this.fontNumbers.stringWidth((this.iScoreShowed + "").toCharArray()) >> 1), pomY += this.fontMain1.getHeight() + (this.fontMain1.getHeight() >> 2), 20);
        this.fontMain1.drawString(g, this.sTextPom[2].toCharArray(), pomX2 - (this.fontMain1.stringWidth(this.sTextPom[2].toCharArray()) >> 1), pomY += this.fontNumbers.getHeight() + (this.fontMain1.getHeight() >> 1), 20);
        this.fontNumbers.drawString(g, (this.iBestScore + "").toCharArray(), pomX2 - (this.fontNumbers.stringWidth((this.iBestScore + "").toCharArray()) >> 1), pomY += this.fontMain1.getHeight() + (this.fontMain1.getHeight() >> 2), 20);
    }

    public void paintGameOverText(Graphics g) {
        if (this.game.isGameOver()) {
            this.paintButton(g, this.rectTitle, this.sTextTitle, true);
        }
    }

    public void paintText(Graphics g, int centerX, int centerY, int width, int height, String s) {
        this.paintTable(g, this.sprDialog, centerX, centerY, width, height);
        this.fontMain1.drawString(g, s.toCharArray(), centerX - (this.fontMain1.stringWidth(s.toCharArray()) >> 1), centerY - (this.fontMain1.getHeight() >> 1) - 1, 20);
    }

    public void paintText2(Graphics g, int centerX, int centerY, int width, int height, String s) {
        this.paintTable(g, this.sprDialog, centerX, centerY, width, height);
        this.fontMain1.drawString(g, s.toCharArray(), centerX - (this.fontMain2.stringWidth(s.toCharArray()) >> 1) - 1, centerY - (this.fontMain2.getHeight() >> 1) - 1 - 1, 20);
        this.fontMain2.drawString(g, s.toCharArray(), centerX - (this.fontMain1.stringWidth(s.toCharArray()) >> 1), centerY - (this.fontMain1.getHeight() >> 1) - 1, 20);
    }

    public void keyPressed(int keyCode) {
    }

    public void soundOn() {
        Profile.bMusic = true;
        MainCanvas.soundManager.SetSoundOn(true);
        MainCanvas.soundManager.SetMusicOn(true);
    }

    public void soundOff() {
        Profile.bMusic = false;
        MainCanvas.soundManager.SetSoundOn(false);
        MainCanvas.soundManager.SetMusicOn(false);
    }

    public void changeLanguage(int iType) {
        switch (iType) {
            case 0: {
                if (this.iSelectedLanguage <= 0) break;
                --this.iSelectedLanguage;
                break;
            }
            case 1: {
                if (this.iSelectedLanguage < 4) {
                    ++this.iSelectedLanguage;
                    break;
                }
                this.iSelectedLanguage = 0;
                break;
            }
        }
    }

    public void changeSelectedHero(int iType) {
        switch (iType) {
            case 1: {
                if (this.iSelectedHero <= 0) break;
                --this.iSelectedHero;
                break;
            }
            case 2: {
                if (this.iSelectedHero >= 3) break;
                ++this.iSelectedHero;
                break;
            }
        }
        this.bChangingHero = false;
    }

    public void changeSound() {
        Profile.bMusic = !Profile.bMusic;
        Profile.save();
        if (Profile.bMusic) {
            this.soundOn();
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
        } else {
            this.soundOff();
        }
    }

    public void changeSelectedMenuItem(int iShift) {
        int pom = 0;
        switch (this.screen) {
            case 1: {
                pom = this.iMenuItemsTotal;
                break;
            }
            case 2: {
                pom = 3;
                break;
            }
        }
        this.iSelectedMenuItem = iShift > 0 ? (this.iSelectedMenuItem + 1) % pom : (this.iSelectedMenuItem > 0 ? --this.iSelectedMenuItem : pom - 1);
    }

    public void pause(boolean bMusic, int sourceScreen) {
        if (!this.game.isGameOver()) {
            this.iSelectedMenuItem = 0;
            this.nextScreen(2, 3);
            if (sourceScreen != 0) {
                this.bIsFromPause = true;
            }
            if (bMusic) {
                MainCanvas.soundManager.Stop();
                MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
            }
        }
    }

    public void unpause() {
        this.nextScreen(2, 0);
        MainCanvas.soundManager.Stop();
        MainCanvas.soundManager.Play(Sounds.MUSIC_GAME, -1);
    }

    public void keyReleased(int keyCode) {
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 2: {
                        if (this.delay <= 100) break block0;
                        this.delay = 100;
                        break block0;
                    }
                    case 3: {
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeLanguage(0);
                            return;
                        }
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeLanguage(1);
                            return;
                        }
                        if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                        this.nextScreen(0, 4);
                        return;
                    }
                    case 4: {
                        if (Keys.isFKLeftCode(keyCode)) {
                            this.soundOn();
                            this.init();
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.soundOff();
                        this.init();
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeSelectedMenuItem(1);
                            return;
                        }
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeSelectedMenuItem(-1);
                            return;
                        }
                        if (Keys.isFKRightCode(keyCode)) {
                            this.nextScreen(1, 4);
                            return;
                        }
                        if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                        switch (this.iSelectedMenuItem) {
                            case 0: {
                                this.nextScreen(1, 5);
                                break;
                            }
                            case 1: {
                                this.nextScreen(1, 1);
                                break;
                            }
                            case 2: {
                                this.changeSound();
                                break;
                            }
                            case 3: {
                                this.nextScreen(1, 2);
                                break;
                            }
                            case 4: {
                                this.nextScreen(1, 3);
                                break;
                            }
                        }
                        return;
                    }
                    case 1: {
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 2: {
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 4: {
                        if (Keys.isFKLeftCode(keyCode)) {
                            this.quit();
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 3: {
                        if (Keys.isFKLeftCode(keyCode)) {
                            this.moreGames();
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 5: {
                        if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                            if (this.iSelectedHero > 0 && this.iChangeSelectedHero == 0) {
                                this.iChangeSelectedHero = 1;
                                this.bChangingHero = true;
                            }
                            return;
                        }
                        if (Keys.isActionPressed(4) || Keys.isKeyPressed(54)) {
                            if (this.iSelectedHero < 3 && this.iChangeSelectedHero == 0) {
                                this.iChangeSelectedHero = 2;
                                this.bChangingHero = true;
                            }
                            return;
                        }
                        if (Keys.isFKLeftCode(keyCode) || Keys.isActionPressed(5) || Keys.isKeyPressed(53)) {
                            this.play();
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.iSelectedMenuItem = 0;
                        this.nextScreen(1, 0);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 0: {
                        if (Keys.isFKRightCode(keyCode)) {
                            if (this.bIsFromPause) break block0;
                            this.pause(true, 0);
                            break block0;
                        }
                        if (Keys.isActionGeneratedByKey(3, keyCode)) {
                            if (this.bIsFromPause) break block0;
                            this.nextScreen(2, 1);
                            this.game.chop(false);
                            break block0;
                        }
                        if (!Keys.isActionGeneratedByKey(4, keyCode) || this.bIsFromPause) break block0;
                        this.nextScreen(2, 1);
                        this.game.chop(true);
                        break block0;
                    }
                    case 1: {
                        if (this.game.isGameOver()) break block0;
                        if (Keys.isFKRightCode(keyCode)) {
                            this.pause(true, 1);
                            break block0;
                        }
                        if (Keys.isActionGeneratedByKey(3, keyCode)) {
                            this.game.chop(false);
                            break block0;
                        }
                        if (!Keys.isActionGeneratedByKey(4, keyCode)) break block0;
                        this.game.chop(true);
                        break block0;
                    }
                    case 2: {
                        if (this.iResultStep <= 2) break block0;
                        if (Keys.isFKLeftCode(keyCode) || Keys.isActionPressed(5) || Keys.isKeyPressed(53)) {
                            this.play();
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.nextScreen(1, 5);
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
                        return;
                    }
                    case 3: {
                        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                            this.changeSelectedMenuItem(1);
                            return;
                        }
                        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                            this.changeSelectedMenuItem(-1);
                            return;
                        }
                        if (Keys.isFKRightCode(keyCode)) {
                            this.unpause();
                            return;
                        }
                        if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                        switch (this.iSelectedMenuItem) {
                            case 0: {
                                this.changeSound();
                                break;
                            }
                            case 1: {
                                this.nextScreen(2, 4);
                                break;
                            }
                            case 2: {
                                this.nextScreen(2, 5);
                                break;
                            }
                        }
                        return;
                    }
                    case 4: {
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.nextScreen(2, 3);
                        return;
                    }
                    case 5: {
                        if (Keys.isFKLeftCode(keyCode)) {
                            this.iSelectedMenuItem = 0;
                            this.bIsFromPause = false;
                            this.nextScreen(1, 0);
                            return;
                        }
                        if (!Keys.isFKRightCode(keyCode)) break block0;
                        this.nextScreen(2, 3);
                        return;
                    }
                }
                break;
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if ((this.screen == 1 && this.subScreen == 1 || this.screen == 2 && this.subScreen == 4) && this.isPressedInstructionsText(x, y)) {
            this.bDragInstructions = true;
        }
    }

    public void moreGames() {
        X.singleton.requestLink(this.link);
    }

    public void quit() {
        X.quitApp();
    }

    public boolean isLeftButtonPressed(int x, int y) {
        return x <= this.imgBtnOk.getWidth() + (this.imgBtnOk.getWidth() >> 1) && y >= MainCanvas.HEIGHT - this.imgBtnOk.getHeight() - (this.imgBtnOk.getHeight() >> 1);
    }

    public boolean isRightButtonPressed(int x, int y) {
        return x >= MainCanvas.WIDTH - this.imgBtnOk.getWidth() - (this.imgBtnOk.getWidth() >> 1) && y >= MainCanvas.HEIGHT - this.imgBtnOk.getHeight() - (this.imgBtnOk.getHeight() >> 1);
    }

    public void pointerDragged(int x, int y) {
        if ((this.screen == 1 && this.subScreen == 1 || this.screen == 2 && this.subScreen == 4) && this.bDragInstructions) {
            if (!this.isPressedInstructionsText(x, y)) {
                this.bDragInstructions = false;
            }
            this.iTextShiftY += MainCanvas.lastPointerPressedY - y;
            MainCanvas.lastPointerPressedY = y;
        }
    }

    public void pointerReleased(int x, int y) {
        if ((this.screen == 1 && this.subScreen == 1 || this.screen == 2 && this.subScreen == 4) && this.bDragInstructions) {
            this.bDragInstructions = false;
        }
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 2: {
                        if (this.delay <= 100) break;
                        this.delay = 100;
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < 5; ++i) {
                            if (!this.rectLanguages[i].contains(x, y)) continue;
                            this.iSelectedLanguage = i;
                            this.nextScreen(0, 4);
                            return;
                        }
                        break block0;
                    }
                    case 4: {
                        if (this.isLeftButtonPressed(x, y)) {
                            this.soundOn();
                            this.init();
                            return;
                        }
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.soundOff();
                        this.init();
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        if (this.isRightButtonPressed(x, y)) {
                            this.nextScreen(1, 4);
                            return;
                        }
                        for (int i = 0; i < this.iMenuItemsTotal; ++i) {
                            if (!this.rectMenuItems[i].contains(x, y)) continue;
                            this.iSelectedMenuItem = i;
                            switch (this.iSelectedMenuItem) {
                                case 0: {
                                    this.nextScreen(1, 5);
                                    break;
                                }
                                case 1: {
                                    this.nextScreen(1, 1);
                                    break;
                                }
                                case 2: {
                                    this.changeSound();
                                    break;
                                }
                                case 3: {
                                    this.nextScreen(1, 2);
                                    break;
                                }
                                case 4: {
                                    this.nextScreen(1, 3);
                                    break;
                                }
                            }
                            return;
                        }
                        break block0;
                    }
                    case 1: {
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 2: {
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 4: {
                        if (this.isLeftButtonPressed(x, y)) {
                            this.quit();
                            return;
                        }
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 3: {
                        if (this.isLeftButtonPressed(x, y)) {
                            this.moreGames();
                            return;
                        }
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.nextScreen(1, 0);
                        return;
                    }
                    case 5: {
                        this.onSelectHeroPointerReleased(x, y);
                        if (this.rectPlayButton.contains(x, y)) {
                            this.play();
                            this.bFlash = true;
                            return;
                        }
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.iSelectedMenuItem = 0;
                        this.nextScreen(1, 0);
                        break;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 0: {
                        if (this.isRightButtonPressed(x, y)) {
                            if (this.bIsFromPause) break;
                            this.pause(true, 0);
                            break;
                        }
                        if (x < MainCanvas.WIDTH >> 1) {
                            if (this.bIsFromPause) break;
                            this.nextScreen(2, 1);
                            this.game.chop(false);
                            break;
                        }
                        if (x <= MainCanvas.WIDTH >> 1 || this.bIsFromPause) break;
                        this.nextScreen(2, 1);
                        this.game.chop(true);
                        break;
                    }
                    case 1: {
                        if (this.game.isGameOver()) break;
                        if (this.isRightButtonPressed(x, y)) {
                            this.pause(true, 1);
                            return;
                        }
                        if (x < MainCanvas.WIDTH >> 1) {
                            this.game.chop(false);
                            break;
                        }
                        if (x <= MainCanvas.WIDTH >> 1) break;
                        this.game.chop(true);
                        break;
                    }
                    case 2: {
                        if (this.iResultStep <= 2) break;
                        if (this.rectPlayButton.contains(x, y)) {
                            this.play();
                            return;
                        }
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.nextScreen(1, 5);
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
                        return;
                    }
                    case 3: {
                        if (this.isRightButtonPressed(x, y)) {
                            this.unpause();
                            return;
                        }
                        for (int i = 0; i < 3; ++i) {
                            if (!this.rectPauseItems[i].contains(x, y)) continue;
                            this.iSelectedMenuItem = i;
                            switch (this.iSelectedMenuItem) {
                                case 0: {
                                    this.changeSound();
                                    break;
                                }
                                case 1: {
                                    this.nextScreen(2, 4);
                                    break;
                                }
                                case 2: {
                                    this.nextScreen(2, 5);
                                    break;
                                }
                            }
                            return;
                        }
                        break block0;
                    }
                    case 4: {
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.nextScreen(2, 3);
                        return;
                    }
                    case 5: {
                        if (this.isLeftButtonPressed(x, y)) {
                            this.iSelectedMenuItem = 0;
                            this.bIsFromPause = false;
                            this.nextScreen(1, 0);
                            return;
                        }
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.nextScreen(2, 3);
                        return;
                    }
                }
                break;
            }
        }
    }

    public void onSelectHeroPointerReleased(int x, int y) {
        if (y > this.iSelectHeroDialogY - (this.iSelectHeroDialogHeight >> 1) && y < this.iSelectHeroDialogY + (this.iSelectHeroDialogHeight >> 1)) {
            if (x < MainCanvas.WIDTH >> 1 && x > (MainCanvas.WIDTH >> 1) - (this.iSelectHeroDialogWidth >> 1)) {
                if (this.iSelectedHero > 0 && this.iChangeSelectedHero == 0) {
                    this.iChangeSelectedHero = 1;
                    this.bChangingHero = true;
                }
                return;
            }
            if (x > MainCanvas.WIDTH >> 1 && x < (MainCanvas.WIDTH >> 1) + (this.iSelectHeroDialogWidth >> 1)) {
                if (this.iSelectedHero < 3 && this.iChangeSelectedHero == 0) {
                    this.iChangeSelectedHero = 2;
                    this.bChangingHero = true;
                }
                return;
            }
        }
    }

    public void afterHide() {
    }

    public void beforeShow() {
        Profile.load();
        this.screen = 0;
        this.subScreen = 0;
    }

    public void beforeInteruption() {
        if (this.screen != 0) {
            MainCanvas.soundManager.Stop();
            if (this.screen == 2 && (this.subScreen == 0 || this.subScreen == 1)) {
                this.pause(false, this.subScreen);
            }
        }
    }

    public void afterInteruption() {
        if (this.screen != 0) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Stop();
            if (this.screen == 2 && (this.subScreen == 0 || this.subScreen == 1 || this.subScreen == 2)) {
                MainCanvas.soundManager.Play(Sounds.MUSIC_GAME, -1);
            } else {
                MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
            }
        }
    }

    public void initGraphics() {
        this.bLoading = true;
        Resources.loadGFonts(new int[]{0, 1, 2, 3});
        this.fontMain1 = Resources.resGFonts[0];
        this.fontMain2 = Resources.resGFonts[1];
        this.fontNumbers = Resources.resGFonts[2];
        this.fontNumbersBig = Resources.resGFonts[3];
        Resources.loadImages(new int[]{1, 2, 3, 4, 5, 6, 7, 10, 27, 28, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 8, 9, 30, 29, 31, 32, 33});
        this.imgLogoInlogic = Resources.resImgs[1];
        this.imgLogoInlogic2 = Resources.resImgs[33];
        this.imgTitle = Resources.resImgs[26];
        this.imgBtnPause = Resources.resImgs[2];
        this.imgBtnOk = Resources.resImgs[3];
        this.imgBtnCancel = Resources.resImgs[4];
        this.imgBtnBack = Resources.resImgs[5];
        this.imgBtnQuit = Resources.resImgs[6];
        this.imgBg[0] = Resources.resImgs[7];
        this.imgBg[1] = Resources.resImgs[8];
        this.imgBg[2] = Resources.resImgs[9];
        this.imgHeroes[0] = Resources.resImgs[14];
        this.imgHeroes[1] = Resources.resImgs[29];
        this.imgHeroes[2] = Resources.resImgs[31];
        this.imgHeroes[3] = Resources.resImgs[30];
        this.imgMedals[0] = Resources.resImgs[19];
        this.imgMedals[1] = Resources.resImgs[20];
        this.imgMedals[2] = Resources.resImgs[21];
        this.imgMedals[3] = Resources.resImgs[22];
        this.imgShadowMenu = Resources.resImgs[15];
        this.imgLock = Resources.resImgs[32];
        Resources.loadSprites(new int[]{0, 1, 5, 2, 10, 11, 12, 13, 14, 15, 3, 6, 4, 7, 8, 9, 16, 17, 19, 18, 20, 21});
        this.sprLanguage = Resources.resSprs[0];
        this.sprDialog = Resources.resSprs[1];
        this.sprDialog2 = Resources.resSprs[6];
        this.sprButton = Resources.resSprs[2];
        this.sprArrow = Resources.resSprs[3];
        this.sprArrow02 = Resources.resSprs[4];
        this.sprStars = Resources.resSprs[21];
        this.nextScreen(0, 1);
        this.bLoading = false;
    }

    public void initIntro() {
        this.bLoading = true;
        this.iSelectedLanguage = 0;
        int iLangItemH = this.sprLanguage.getHeight() + (this.sprLanguage.getHeight() >> 1);
        int iLangAreaH = iLangItemH * 5 - (this.sprLanguage.getHeight() >> 1);
        int iOffsetY = MainCanvas.HEIGHT - iLangAreaH >> 1;
        for (int i = 0; i < 5; ++i) {
            this.rectLanguages[i] = new Rectangle((MainCanvas.WIDTH >> 1) - (this.sprLanguage.getWidth() >> 1), iOffsetY + i * iLangItemH, this.sprLanguage.getWidth(), this.sprLanguage.getHeight());
        }
        int pomMenuButtonHeight = this.fontMain2.getHeight() + (this.fontMain2.getHeight() >> 1);
        int pomMenuButtonWidth = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2);
        this.rectTitleCenter = new Rectangle((MainCanvas.WIDTH >> 1) - (pomMenuButtonWidth >> 1), (MainCanvas.HEIGHT >> 1) - (pomMenuButtonHeight >> 1), pomMenuButtonWidth, pomMenuButtonHeight);
        this.iShiftDirection = 1;
        this.iShiftX = 0;
        this.iShiftStep = MainCanvas.WIDTH / 120;
        if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
            this.iShiftStep = MainCanvas.HEIGHT / 160;
        }
        this.nextScreen(0, 2);
        this.bLoading = false;
    }

    public void init() {
        int iHlpW;
        int i;
        this.bLoading = true;
        Resources.freeSprites(new int[]{0});
        this.sprLanguage = null;
        System.gc();
        this.iScoreShowed = 0;
        this.iSelectedHero = 0;
        this.bChangingHero = false;
        this.game = new Game(this);
        this.game.initFirst();
        this.iBestScore = Profile.iBestScore;
        this.menuButtonH = this.fontMain2.getHeight() + (this.fontMain2.getHeight() >> 1);
        this.menuButtonW = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2);
        this.iMenuItemSpaceY = (this.menuButtonH >> 2) - (this.menuButtonH >> 3);
        if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
            this.menuButtonW = MainCanvas.HEIGHT - (MainCanvas.HEIGHT >> 2);
        }
        this.iOffsetTitle = MainCanvas.HEIGHT >> 5;
        this.iTitleX = (MainCanvas.WIDTH >> 1) - (this.imgTitle.getWidth() >> 1);
        this.iTitleY = this.iOffsetTitle;
        this.iTitleAreaH = this.imgTitle.getHeight() + (this.iOffsetTitle << 1);
        this.iMenuStartY = -this.imgTitle.getHeight() - this.iOffsetTitle;
        this.iMenuStepY = (this.imgTitle.getHeight() + this.iOffsetTitle) / 8;
        this.iMenuEndY = this.iOffsetTitle;
        this.rectMenuItems = new Rectangle[this.iMenuItemsTotal];
        for (i = 0; i < this.iMenuItemsTotal; ++i) {
            this.rectMenuItems[i] = new Rectangle((MainCanvas.WIDTH >> 1) - (this.menuButtonW >> 1), this.iTitleAreaH + i * (this.menuButtonH + this.iMenuItemSpaceY), this.menuButtonW, this.menuButtonH);
        }
        int iCenterOffY = this.getMenuItemsCenterOffset(3);
        this.rectPauseItems = new Rectangle[3];
        for (i = 0; i < 3; ++i) {
            this.rectPauseItems[i] = new Rectangle(this.rectMenuItems[i].x, this.iTitleAreaH + iCenterOffY + i * (this.menuButtonH + this.iMenuItemSpaceY), this.menuButtonW, this.menuButtonH);
        }
        if (Resources.langCode.compareTo("pt") == 0 || Resources.langCode.compareTo("fr") == 0) {
            for (i = 0; i < 3; ++i) {
                this.rectPauseItems[i].width += this.menuButtonW >> 3;
                this.rectPauseItems[i].x = (MainCanvas.WIDTH >> 1) - (this.rectPauseItems[i].width >> 1);
            }
        }
        this.rectTitle = new Rectangle((MainCanvas.WIDTH >> 1) - (this.menuButtonW >> 1), this.menuButtonH >> 1, this.menuButtonW, this.menuButtonH);
        if (Resources.langCode.compareTo("es") == 0 && this.rectTitle.width < (iHlpW = this.fontMain2.stringWidth(Resources.resTexts[0].getHashedString(21).toCharArray())) + (iHlpW >> 3)) {
            this.rectTitle.width = iHlpW + (iHlpW >> 3);
            this.rectTitle.x = (MainCanvas.WIDTH >> 1) - (this.rectTitle.width >> 1);
        }
        iCenterOffY = this.getMenuItemsCenterOffset(1);
        this.rectExitGame = new Rectangle((MainCanvas.WIDTH >> 1) - (this.menuButtonW >> 1), this.iTitleAreaH + iCenterOffY, this.menuButtonW, this.menuButtonH);
        this.rectTitleCenter = new Rectangle((MainCanvas.WIDTH >> 1) - (this.menuButtonW >> 1), (MainCanvas.HEIGHT >> 1) - (this.menuButtonH >> 1), this.menuButtonW, this.menuButtonH);
        this.iAboutCenterY = this.rectTitle.getBottom() + (MainCanvas.HEIGHT - this.imgBtnOk.getHeight() - this.rectTitle.getBottom() >> 1);
        this.iAboutWidth = this.rectTitle.width + this.sprDialog.getWidth();
        this.iAboutHeight = this.imgLogoInlogic.getHeight() + (this.fontMain1.getHeight() << 2) + this.fontMain1.getHeight();
        if (Resources.langCode.compareTo("es") == 0) {
            this.iAboutWidth = this.rectTitle.width;
        }
        this.iSelectHeroDialogHeight = this.fontMain1.getHeight() + (this.imgHeroes[0].getHeight() << 1) + this.fontMain1.getHeight();
        this.iSelectHeroDialogWidth = this.iAboutWidth;
        int pomNewSpaceY = (MainCanvas.HEIGHT - this.imgBtnOk.getHeight() - this.menuButtonH - this.iSelectHeroDialogHeight) / 3;
        this.iSelectHeroDialogY = pomNewSpaceY + (pomNewSpaceY >> 2) + (this.iSelectHeroDialogHeight >> 1);
        int hlpSelectHeroContentH = this.imgHeroes[0].getHeight() + this.fontMain1.getHeight() + (this.fontMain1.getHeight() >> 1);
        int hlpCenterOffsetY = (this.iSelectHeroDialogHeight - hlpSelectHeroContentH >> 1) - (this.fontMain1.getHeight() >> 2);
        this.iSelectHeroFontY = this.iSelectHeroDialogY - (this.iSelectHeroDialogHeight >> 1) + (this.fontMain1.getHeight() >> 1) + hlpCenterOffsetY - (this.sprStars.getHeight() >> 1);
        this.iSelectHeroImgX = (MainCanvas.WIDTH >> 1) - (this.imgHeroes[0].getWidth() >> 1);
        this.iSelectHeroimgY = this.iSelectHeroFontY + this.fontMain1.getHeight();
        this.iSelectHeroArrowLeftX = this.iSelectHeroImgX - (this.sprArrow02.getWidth() << 1) - this.sprArrow02.getWidth();
        this.iSelectHeroArrowRightX = this.iSelectHeroImgX + this.imgHeroes[0].getWidth() + (this.sprArrow02.getWidth() << 1);
        this.iSelectHeroArrowY = this.iSelectHeroimgY + (this.imgHeroes[0].getHeight() >> 1) - this.sprArrow02.getHeight();
        this.rectPlayButton = new Rectangle((MainCanvas.WIDTH >> 1) - (this.menuButtonW >> 1), (pomNewSpaceY << 1) + this.iSelectHeroDialogHeight, this.menuButtonW, this.menuButtonH);
        this.iHeroShift = this.imgHeroes[0].getWidth() / this.iHeroShiftSteps;
        this.iResultTableHeight = (this.fontNumbers.getHeight() << 1) + this.fontMain1.getHeight() * 5;
        this.iResultTableWidth = this.iAboutWidth;
        this.iResultTableCenterY = this.rectTitle.getBottom() + (this.rectPlayButton.y - this.rectTitle.getBottom() >> 1);
        this.iInstructionsCenterY = this.iAboutCenterY;
        this.iInstructionsWidth = this.iAboutWidth;
        this.iInstructionsHeight = MainCanvas.HEIGHT - this.imgBtnOk.getHeight() - this.rectTitle.getBottom() - (this.fontMain1.getHeight() << 1);
        this.nextScreen(1, 0);
        if (Profile.bMusic) {
            this.soundOn();
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
        } else {
            this.soundOff();
        }
        this.bLoading = false;
    }

    private int getMenuItemsCenterOffset(int numOfItems) {
        int iMenuItemCenterOffsetY = MainCanvas.HEIGHT - this.iTitleAreaH - this.imgBtnBack.getHeight() - numOfItems * (this.menuButtonH + this.iMenuItemSpaceY);
        return iMenuItemCenterOffsetY >>= 1;
    }

    public void initTexts() {
        Resources.initLangDirs(langCodes[this.iSelectedLanguage]);
        Resources.loadText(0);
        try {
            this.link = Resources.langCode.compareTo("pt") == 0 ? X.singleton.getAppProperty("C2M-URL-pt-PT") : (Resources.langCode.compareTo("es") == 0 ? X.singleton.getAppProperty("C2M-URL-es-ES") : (Resources.langCode.compareTo("fr") == 0 ? X.singleton.getAppProperty("C2M-URL-fr-FR") : (Resources.langCode.compareTo("de") == 0 ? X.singleton.getAppProperty("C2M-URL-de-DE") : X.singleton.getAppProperty("C2M-URL-en-GB"))));
        }
        catch (Exception e) {
            this.link = null;
        }
        try {
            this.buysetup = X.singleton.getAppProperty("C2M-BuySetup");
        }
        catch (Exception e) {
            this.buysetup = null;
        }
        this.iSelectedMenuItem = 0;
        this.iMenuItemsTotal = 4;
        if (this.containParam(this.buysetup, "menu") && this.link != null) {
            this.iMenuItemsTotal = 5;
            this.bMoreGames = true;
        }
    }

    public void setTexts() {
        this.iTextLines = 1;
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 4: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(2);
                        this.setTitleCenter(this.sTextTitle);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        this.sTextMenu[0] = Resources.resTexts[0].getHashedString(7);
                        this.sTextMenu[1] = Resources.resTexts[0].getHashedString(8);
                        this.sTextMenu[2] = Resources.resTexts[0].getHashedString(9);
                        this.sTextMenu[3] = Resources.resTexts[0].getHashedString(10);
                        if (this.bMoreGames) {
                            this.sTextMenu[4] = Resources.resTexts[0].getHashedString(11);
                        }
                        this.sTextPom[0] = Resources.resTexts[0].getHashedString(15);
                        this.sTextPom[1] = Resources.resTexts[0].getHashedString(16);
                        break block0;
                    }
                    case 1: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(8);
                        this.bLoading = true;
                        this.sTextPom[0] = Resources.resTexts[0].getHashedString(28) + "\n\n" + Resources.resTexts[0].getHashedString(27);
                        int textMaxWidth = this.iInstructionsWidth - (this.iInstructionsWidth >> 3);
                        this.prepText = new PreparedText(this.fontMain1);
                        this.prepText.prepareText(this.sTextPom[0], textMaxWidth);
                        this.iTextLines = this.prepText.getTextHeight() / this.fontMain1.getHeight();
                        int iTextYUp = this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) + this.sprArrow.getHeight() * 3;
                        int iTextYDown = this.iInstructionsCenterY + (this.iInstructionsHeight >> 1) - this.sprArrow.getHeight() * 3;
                        int iTextHeight = iTextYDown - iTextYUp;
                        this.iTextShiftY = 0;
                        this.iInstructionsShiftY = 0;
                        this.iInstructionsMaxShiftY = this.prepText.getTextHeight() - iTextHeight;
                        this.bDragInstructions = false;
                        this.bLoading = false;
                        break block0;
                    }
                    case 2: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(10);
                        this.sTextPom[0] = X.singleton.getAppProperty("MIDlet-Name").toUpperCase();
                        this.sTextPom[1] = Resources.resTexts[0].getHashedString(17) + " " + X.singleton.getAppProperty("MIDlet-Version").toUpperCase();
                        break block0;
                    }
                    case 4: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(12);
                        this.setTitleCenter(this.sTextTitle);
                        break block0;
                    }
                    case 3: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(18);
                        this.setTitleCenter(this.sTextTitle);
                        break block0;
                    }
                    case 5: {
                        this.sTextButton = Resources.resTexts[0].getHashedString(7);
                        this.sTextUnlock = Resources.resTexts[0].getHashedString(30);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 0: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(21);
                        this.sTextButton = Resources.resTexts[0].getHashedString(7);
                        this.sTextPom[0] = Resources.resTexts[0].getHashedString(22);
                        this.sTextPom[1] = Resources.resTexts[0].getHashedString(23);
                        this.sTextPom[2] = Resources.resTexts[0].getHashedString(24);
                        this.sTextInfo = Resources.resTexts[0].getHashedString(24);
                        break block0;
                    }
                    case 2: {
                        break block0;
                    }
                    case 3: {
                        this.sTextMenu[0] = Resources.resTexts[0].getHashedString(9);
                        this.sTextMenu[1] = Resources.resTexts[0].getHashedString(8);
                        this.sTextMenu[2] = Resources.resTexts[0].getHashedString(13);
                        this.sTextPom[0] = Resources.resTexts[0].getHashedString(15);
                        this.sTextPom[1] = Resources.resTexts[0].getHashedString(16);
                        break block0;
                    }
                    case 4: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(8);
                        this.bLoading = true;
                        this.sTextPom[0] = Resources.resTexts[0].getHashedString(28) + "\n\n" + Resources.resTexts[0].getHashedString(27);
                        int textMaxWidth = this.iInstructionsWidth - (this.iInstructionsWidth >> 3);
                        this.prepText = new PreparedText(this.fontMain1);
                        this.prepText.prepareText(this.sTextPom[0], textMaxWidth);
                        this.iTextLines = this.prepText.getTextHeight() / this.fontMain1.getHeight();
                        int iTextYUp = this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) + this.sprArrow.getHeight() * 3;
                        int iTextYDown = this.iInstructionsCenterY + (this.iInstructionsHeight >> 1) - this.sprArrow.getHeight() * 3;
                        int iTextHeight = iTextYDown - iTextYUp;
                        this.iTextShiftY = 0;
                        this.iInstructionsShiftY = 0;
                        this.iInstructionsMaxShiftY = this.prepText.getTextHeight() - iTextHeight;
                        this.bDragInstructions = false;
                        this.bLoading = false;
                        break block0;
                    }
                    case 5: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(14);
                        this.setTitleCenter(this.sTextTitle);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private boolean containParam(String source, String param) {
        int index;
        if (source == null) {
            return false;
        }
        do {
            if (!(source = source.trim()).startsWith(param)) continue;
            return true;
        } while ((source = (index = source.indexOf(",")) < 0 ? "" : source.substring(index + 1, source.length())) != "");
        return false;
    }

    public void play() {
        if (this.iSelectedHero <= Profile.iUnlockedHero && !this.bChangingHero) {
            this.bFlash = true;
            this.bLoading = true;
            this.iEnviroment = RandomNum.getRandomUInt(3);
            this.iScoreShowed = 0;
            this.iResultStep = 0;
            this.iResultCounter = 0;
            this.game.resetDataBeforePlay(this.iEnviroment);
            this.nextScreen(2, 0);
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_GAME, -1);
            this.bLoading = false;
        }
    }

    public void nextScreen(int nextScreen, int nextSubScreen) {
        this.screen = nextScreen;
        this.subScreen = nextSubScreen;
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 4: {
                        this.initTexts();
                        break block0;
                    }
                    case 2: {
                        this.delay = 3000;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                if (this.iEnviroment != 0) {
                    this.iEnviroment = 0;
                }
                if (this.subScreen == 0) {
                    this.iTitleY = this.iMenuStartY;
                    break;
                }
                if (this.subScreen == 4) {
                    this.iTitleY = this.iMenuEndY;
                    break;
                }
                if (this.subScreen != 5) break;
                this.iChangeSelectedHero = 0;
                this.iHeroShiftX = 0;
                this.bChangingHero = false;
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 2: {
                        this.iScoreShowed = 0;
                        this.iResultStep = 0;
                        this.iResultCounter = 0;
                        break block0;
                    }
                    case 3: {
                        this.iTitleY = this.iMenuStartY;
                        break block0;
                    }
                }
                break;
            }
        }
        this.setTexts();
    }

    public void setTitleCenter(String s) {
        this.rectTitleCenter.height = this.fontMain2.getHeight() + (this.fontMain2.getHeight() >> 1);
        int textMaxWidth = this.rectTitleCenter.width - (this.rectTitleCenter.width >> 3);
        this.prepText = new PreparedText(this.fontMain2);
        this.prepText.prepareText(s, textMaxWidth);
        this.iTextLines = this.prepText.getTextHeight() / this.fontMain2.getHeight();
        if (this.iTextLines > 1) {
            this.rectTitleCenter.height += (this.iTextLines - 1) * this.fontMain2.getHeight() + 1;
        }
        if (this.rectExitGame != null) {
            this.rectExitGame.height = this.fontMain2.getHeight() + (this.fontMain2.getHeight() >> 1);
            textMaxWidth = this.rectExitGame.width - (this.rectExitGame.width >> 3);
            this.prepText = new PreparedText(this.fontMain2);
            this.prepText.prepareText(s, textMaxWidth);
            this.iTextLines = this.prepText.getTextHeight() / this.fontMain2.getHeight();
            if (this.iTextLines > 1) {
                this.rectExitGame.height += (this.iTextLines - 1) * this.fontMain2.getHeight() + 1;
                this.rectExitGame.height += this.fontMain2.getHeight();
            }
        }
    }

    static {
        langCodes = new String[]{"en", "de", "fr", "es", "pt"};
        LANGUAGES = new int[]{1, 2, 0, 4, 3};
    }
}

