/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import sk.inlogic.MainCanvas;
import sk.inlogic.game.Game;

public class ChopAnimation {
    private boolean inProgress = false;
    private int sx;
    private int sy;
    private int x;
    private int y;
    private int maxTime;
    private int actTime;
    private int iStepX;
    private int iStepY;
    private int position;
    private int branchType;
    private boolean isTwig;

    public ChopAnimation(int sx, int sy, int time) {
        this.maxTime = time;
        this.sx = sx;
        this.sy = sy;
        this.iStepX = MainCanvas.WIDTH >> 4;
        this.iStepY = MainCanvas.HEIGHT >> 6;
    }

    public void start(int position, boolean isTwig, int branchType) {
        this.isTwig = isTwig;
        this.position = position;
        this.branchType = branchType;
        this.actTime = 0;
        this.y = this.sy;
        this.x = position == 0 ? this.sx + (Game.imgTree[Game.iEnviroment].getWidth() >> 1) : this.sx - (Game.imgTree[Game.iEnviroment].getWidth() >> 1);
        this.inProgress = true;
    }

    public void reset() {
        this.inProgress = false;
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public void update(long dt) {
        if (this.inProgress) {
            if (this.actTime < this.maxTime) {
                this.y = this.actTime < this.maxTime >> 1 ? (this.y -= this.iStepY) : (this.y += this.iStepY);
                this.x = this.position == 0 ? (this.x += this.iStepX) : (this.x -= this.iStepX);
                this.actTime = (int)((long)this.actTime + dt);
            } else {
                this.inProgress = false;
            }
        }
    }

    public void paint(Graphics g, Image img) {
        if (this.inProgress) {
            g.drawImage(img, this.x, this.y, 17);
            if (this.isTwig) {
                if (this.position == 0 || this.position == 0) {
                    Game.sprBranches[Game.iEnviroment][this.branchType].setTransform(2);
                    Game.sprBranches[Game.iEnviroment][this.branchType].setPosition(this.x + (img.getWidth() >> 1), this.y + (img.getHeight() >> 1) - (Game.sprBranches[Game.iEnviroment][this.branchType].getHeight() >> 1));
                    Game.sprBranches[Game.iEnviroment][this.branchType].paint(g);
                } else if (this.position == 1 || this.position == -1) {
                    Game.sprBranches[Game.iEnviroment][this.branchType].setTransform(0);
                    Game.sprBranches[Game.iEnviroment][this.branchType].setPosition(this.x - (img.getWidth() >> 1) - Game.sprBranches[Game.iEnviroment][this.branchType].getWidth(), this.y + (img.getHeight() >> 1) - (Game.sprBranches[Game.iEnviroment][this.branchType].getHeight() >> 1));
                    Game.sprBranches[Game.iEnviroment][this.branchType].paint(g);
                }
            }
        }
    }
}

