/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Hero {
    private MyCanvas canvas;
    public int xPosition;
    public int yPosition;
    public int width;
    public int height;
    public byte dir = 1;
    public byte frame;
    public byte jetframe;
    public byte firePos = 1;
    public int frameCtr;
    public byte framePtr;
    public byte xVel;
    public byte yVel = (byte)4;
    public byte bulletType = 0;
    public byte bulletXVel;
    public byte bulletYVel;
    public byte bulletSpeed = (byte)15;
    public int jumpCtr;
    public int jumpLimit;
    public boolean JumpHtReached;
    public byte actionFrmPtr = 0;
    public boolean isHit = false;
    public boolean startAnim;
    public boolean jetStart = false;
    private byte hitCounter = 0;
    public boolean receiveKeypressed = false;
    public byte weapon = 0;
    private byte imageRotation;
    public boolean fireArrow;
    private byte waitCtr;
    private byte jetWaitCtr;
    public boolean isDead;
    private boolean isEnd;
    public byte action = 0;
    public static final byte STAND = 0;
    public static final byte RUN = 1;
    public static final byte JUMP = 2;
    public static final byte DIE = 5;
    public static final byte FALL = 6;
    public static final byte CROUCH = 8;
    public static final byte FIRE = 11;
    public static final byte LONG_JUMP = 34;
    public static final byte CROUCH_WALK = 43;
    public static final byte JET = 44;
    public byte imageNo;
    private byte[] seqArr = new byte[]{8, 3, 3, 3, 4};
    public static Image[] image;
    public byte swordLockCtr = (byte)10;
    public short[] heroClipping = new short[]{0, 1, 29, 39, 29, 1, 30, 39, 59, 1, 31, 39, 90, 0, 36, 42, 126, 0, 36, 42, 162, 0, 36, 42, 198, 0, 36, 42, 234, 0, 36, 42, 270, 0, 36, 42, 0, 0, 51, 39, 51, 0, 51, 39, 102, 0, 51, 39, 153, 0, 51, 39, 204, 0, 51, 39, 255, 0, 51, 39, 0, 0, 30, 46, 30, 0, 30, 45, 30, 0, 30, 45, 30, 0, 30, 45, 30, 0, 30, 45, 0, 0, 30, 46, 0, 1, 32, 39, 32, 1, 32, 39, 64, 0, 26, 40, 0, 2, 22, 78, 22, 2, 22, 78, 44, 0, 22, 80, 66, 28, 22, 52, 88, 26, 22, 54, 64, 0, 26, 40, 32, 1, 32, 39, 0, 1, 32, 39, 0, 1, 46, 43, 46, 0, 46, 44, 92, 0, 42, 44, 132, 7, 36, 37, 167, 4, 36, 40, 203, 7, 35, 37, 0, 0, 46, 39, 46, 0, 48, 39, 94, 0, 47, 39, 141, 0, 34, 39, 175, 0, 35, 39, 209, 0, 34, 39, 60, 0, 48, 43, 108, 3, 50, 39, 158, 3, 50, 39, 208, 2, 35, 40, 243, 2, 36, 40, 279, 0, 22, 52, 301, 0, 22, 54, 323, 0, 22, 54, 345, 0, 22, 37, 367, 0, 22, 36, 0, 0, 32, 24, 32, 0, 32, 24, 64, 0, 32, 24, 96, 0, 33, 24, 129, 0, 33, 24, 0, 0, 32, 36, 32, 0, 42, 36, 74, 2, 47, 34, 121, 2, 46, 31, 167, 4, 46, 26, 213, 3, 46, 25, 259, 5, 44, 26, 303, 11, 48, 20};
    private byte[] framePos = new byte[]{0, 3, 9, 15, 21, 32, 38, 44, 49, 54, 59};
    private byte[] heroPlacingRt = new byte[]{0, 0, 0, 0, 0, 0, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -7, 0, -7, 0, -7, 0, -19, 0, -19, 0, -19, 0, 0, 0, 0, 0, -1, 0, -39, 0, -39, 0, -41, 0, -13, 0, -15, 0, -1, 0, 0, 0, 0, 0, -4, 0, -5, 0, -5, 0, 2, 0, -1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4, 15, -4, 15, -4, 15, -4, 15, -4, 15, -8, 5, -23, -2, -15, 1, -15, 7, -15, 9, -14, 8, -14, 10, -17, 16};
    private byte[] heroPlacingLf = new byte[]{-9, 0, -10, 0, -11, 0, -10, 1, -10, 1, -10, 1, -10, 1, -10, 1, -10, 1, -31, 0, -31, 0, -31, 0, -31, 0, -31, 0, -31, 0, -12, -7, -12, -7, -12, -7, -12, -19, -12, -19, -12, -19, -12, 0, -12, 0, -6, -1, -2, -39, -2, -39, -2, -41, -2, -13, -2, -15, -6, -1, -12, 0, -12, 0, -26, -4, -26, -5, -25, -5, -10, 2, -16, -1, -15, 2, -26, 0, -28, 0, -27, 0, -14, 0, -15, 0, -14, 0, -30, 0, -30, 0, -30, 0, -17, 0, -18, 0, -2, 0, -2, 0, -2, 0, -2, 0, -2, 0, 3, 15, 3, 15, 3, 15, 3, 15, 3, 15, -4, 5, 1, -2, -12, 1, -11, 7, -11, 9, -12, 8, -10, 10, -11, 16};

    public Hero(int xPosition, int yPosition, int width, int height, int direction, boolean hidden, MyCanvas canvas) {
        this.canvas = canvas;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.dir = (byte)direction;
    }

    public static void initResources() {
        try {
            image = new Image[10];
            Hero.image[0] = Image.createImage((String)"/h_st_run.png");
            Hero.image[1] = Image.createImage((String)"/h_jump.png");
            Hero.image[2] = Image.createImage((String)"/h_lookUp.png");
            Hero.image[3] = Image.createImage((String)"/h_upfire.png");
            Hero.image[4] = Image.createImage((String)"/straightFire.png");
            Hero.image[5] = Image.createImage((String)"/h_die.png");
            Hero.image[6] = Image.createImage((String)"/h_downRightfire.png");
            Hero.image[7] = Image.createImage((String)"/h_upRightfire.png");
            if (image[7] != null) {
                // empty if block
            }
            Hero.image[9] = Image.createImage((String)"/h_crouch.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWeapon() {
        try {
            if (this.canvas.arrowCount <= 0 && this.canvas.spearCount <= 0 && this.canvas.golaCount <= 0) {
                this.weapon = 0;
                this.action = 0;
                return;
            }
            switch (this.weapon) {
                case 0: {
                    if (this.canvas.arrowCount <= 0) {
                        if (this.canvas.spearCount <= 0) {
                            this.weapon = (byte)3;
                            this.action = 0;
                            break;
                        }
                        this.weapon = (byte)2;
                        this.action = 0;
                        break;
                    }
                    this.weapon = 1;
                    this.action = 0;
                    break;
                }
                case 1: {
                    if (this.canvas.spearCount <= 0) {
                        if (this.canvas.golaCount > 0) {
                            this.weapon = (byte)3;
                            this.action = 0;
                            break;
                        }
                        this.weapon = 0;
                        this.action = 0;
                        break;
                    }
                    this.weapon = (byte)2;
                    this.action = 0;
                    break;
                }
                case 2: {
                    if (this.canvas.golaCount <= 0) {
                        this.weapon = 0;
                        this.action = 0;
                        break;
                    }
                    this.weapon = (byte)3;
                    this.action = 0;
                    break;
                }
                case 3: {
                    this.weapon = 0;
                    this.action = 0;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWeaponAction() {
        try {
            switch (this.weapon) {
                case 0: {
                    this.action = 0;
                    break;
                }
                case 1: {
                    this.action = 0;
                    break;
                }
                case 2: {
                    this.action = 0;
                    break;
                }
                case 3: {
                    this.action = 0;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFirePos() {
        try {
            switch (this.firePos) {
                case 0: {
                    this.bulletXVel = (byte)(this.bulletSpeed * this.dir);
                    this.bulletYVel = this.bulletSpeed;
                    break;
                }
                case 1: {
                    this.bulletXVel = (byte)(this.bulletSpeed * this.dir);
                    this.bulletYVel = 0;
                    break;
                }
                case 2: {
                    this.bulletXVel = (byte)((this.bulletSpeed - 5) * this.dir);
                    this.bulletYVel = -this.bulletSpeed;
                    break;
                }
                case 3: {
                    this.bulletXVel = 0;
                    this.bulletYVel = -this.bulletSpeed;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBulletType() {
        switch (this.weapon) {
            case 0: {
                this.bulletType = 0;
                break;
            }
            case 1: {
                this.bulletType = (byte)37;
                break;
            }
            case 2: {
                this.bulletType = (byte)38;
                break;
            }
            case 3: {
                this.bulletType = (byte)39;
            }
        }
    }

    public void setBulletCount() {
        try {
            switch (this.weapon) {
                case 0: {
                    break;
                }
                case 1: {
                    this.canvas.arrowCount = (byte)(this.canvas.arrowCount - 1);
                    if (this.canvas.arrowCount > 0) break;
                    this.canvas.arrowCount = 0;
                    break;
                }
                case 2: {
                    this.canvas.spearCount = (byte)(this.canvas.spearCount - 1);
                    if (this.canvas.spearCount > 0) break;
                    this.canvas.spearCount = 0;
                    break;
                }
                case 3: {
                    this.canvas.golaCount = (byte)(this.canvas.golaCount - 1);
                    if (this.canvas.golaCount > 0) break;
                    this.canvas.golaCount = 0;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkBullet() {
        try {
            switch (this.weapon) {
                case 0: {
                    this.action = (byte)11;
                    this.frame = (byte)-1;
                    break;
                }
                case 1: {
                    if (this.canvas.arrowCount <= 0) break;
                    this.action = (byte)11;
                    this.frame = (byte)-1;
                    break;
                }
                case 2: {
                    if (this.canvas.spearCount <= 0) break;
                    this.action = (byte)11;
                    this.frame = (byte)-1;
                    break;
                }
                case 3: {
                    if (this.canvas.golaCount <= 0) break;
                    this.action = (byte)11;
                    this.frame = (byte)-1;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    void updateHero() {
        try {
            block1 : switch (this.action) {
                case 0: {
                    if (this.canvas.jetPackCollected && this.jetStart) ** GOTO lbl9
                    if (MyCanvas.gameLevel == 3) ** GOTO lbl9
                    if (MyCanvas.gameLevel != 4) ** GOTO lbl14
lbl9:
                    // 3 sources

                    this.frame = 0;
                    this.actionFrmPtr = 0;
                    this.imageNo = 0;
                    this.action = (byte)44;
                    break;
lbl14:
                    // 1 sources

                    if (MyCanvas.haveKeyPressed(4)) {
                        this.dir = 1;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(64)) {
                        this.dir = (byte)-1;
                        break;
                    }
                    if (MyCanvas.haveKeyHold(4)) {
                        this.action = 1;
                        this.dir = 1;
                        break;
                    }
                    if (MyCanvas.haveKeyHold(64)) {
                        this.action = 1;
                        this.dir = (byte)-1;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(32)) {
                        this.firePos = this.firePos < 3 ? (this.firePos = (byte)(this.firePos + 1)) : this.firePos;
                        this.setFirePos();
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(8)) {
                        this.firePos = this.firePos > 0 ? (this.firePos = (byte)(this.firePos - 1)) : this.firePos;
                        this.setFirePos();
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(16)) {
                        this.action = (byte)8;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(1)) {
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 4;
                        this.jumpCtr = 0;
                        this.xVel = (byte)((24 >> 1) - 4);
                        this.JumpHtReached = false;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(2) || MyCanvas.haveKeyPressed(2)) {
                        if (this.dir == 1) {
                            this.action = (byte)34;
                            this.frame = (byte)-1;
                            this.jumpLimit = 6;
                            this.jumpCtr = 0;
                            this.JumpHtReached = false;
                            this.dir = (byte)(MyCanvas.haveKeyPressed(2) != false ? 1 : -1);
                            this.xVel = (byte)((24 >> 1) - 4);
                            break;
                        }
                        this.dir = 1;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(128)) {
                        if (this.dir == -1) {
                            this.action = (byte)34;
                            this.frame = (byte)-1;
                            this.jumpLimit = 6;
                            this.jumpCtr = 0;
                            this.JumpHtReached = false;
                            this.dir = (byte)(MyCanvas.haveKeyPressed(2) != false ? 1 : -1);
                            this.xVel = (byte)((24 >> 1) - 4);
                            break;
                        }
                        this.dir = (byte)-1;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(2048)) {
                        this.setWeapon();
                        this.setBulletType();
                        break;
                    }
                    this.setFirePos();
                    if (!MyCanvas.haveKeyPressed(256) && !MyCanvas.haveKeyHold(256)) break;
                    this.checkBullet();
                    break;
                }
                case 1: {
                    this.setWeaponAction();
                    if (MyCanvas.haveKeyReleased(4) || MyCanvas.haveKeyReleased(64) || MyCanvas.haveKeyReleased(2) || MyCanvas.haveKeyReleased(128)) {
                        if (this.weapon == 0) {
                            this.setWeaponAction();
                            this.frame = 0;
                        } else {
                            this.setWeaponAction();
                            this.frame = 1;
                        }
                        this.frameCtr = 0;
                    }
                    if (MyCanvas.haveKeyHold(4)) {
                        this.action = 1;
                        this.dir = 1;
                    } else if (MyCanvas.haveKeyHold(64)) {
                        this.action = 1;
                        this.dir = (byte)-1;
                    } else if (MyCanvas.haveKeyPressed(16)) {
                        this.action = (byte)8;
                    } else if (MyCanvas.haveKeyHold(2)) {
                        this.action = 1;
                        this.dir = 1;
                    } else if (MyCanvas.haveKeyHold(128)) {
                        this.action = 1;
                        this.dir = (byte)-1;
                    }
                    if (!MyCanvas.haveKeyPressed(1)) break;
                    this.action = (byte)34;
                    this.frame = (byte)-1;
                    this.jumpLimit = 6;
                    this.jumpCtr = 0;
                    this.JumpHtReached = false;
                    this.xVel = (byte)((24 >> 1) - 4);
                    break;
                }
                case 11: {
                    if (!this.canvas.jetPackCollected) ** GOTO lbl143
                    if (MyCanvas.gameLevel == 3) ** GOTO lbl125
                    if (MyCanvas.gameLevel != 4) ** GOTO lbl136
lbl125:
                    // 2 sources

                    if ((MyCanvas.haveKeyPressed(1) || MyCanvas.haveKeyHold(1)) && this.canvas.fuelPower > 0) {
                        --this.canvas.fuelPower;
                        if (this.yVel >= 8) {
                            this.yVel = (byte)8;
                            this.waitCtr = 0;
                        } else {
                            if (this.waitCtr % 2 == 0) {
                                this.yVel = (byte)(this.yVel + 4);
                            }
                            this.waitCtr = (byte)(this.waitCtr + 1);
                        }
                    } else {
                        this.yVel = (byte)-1;
                    }
lbl136:
                    // 4 sources

                    if (MyCanvas.haveKeyPressed(64) || MyCanvas.haveKeyHold(64)) {
                        this.xPosition -= this.xVel;
                        this.dir = (byte)-1;
                    } else if (MyCanvas.haveKeyPressed(4) || MyCanvas.haveKeyHold(4)) {
                        this.xPosition += this.xVel;
                        this.dir = 1;
                    }
lbl143:
                    // 5 sources

                    if (MyCanvas.haveKeyPressed(32)) {
                        this.firePos = this.firePos < 3 ? (this.firePos = (byte)(this.firePos + 1)) : this.firePos;
                        this.setFirePos();
                    } else if (MyCanvas.haveKeyPressed(8)) {
                        this.firePos = this.firePos > 0 ? (this.firePos = (byte)(this.firePos - 1)) : this.firePos;
                        this.setFirePos();
                    }
                    this.setFirePos();
                    switch (this.firePos) {
                        case 0: {
                            if (this.frame != 0) break;
                            if (this.bulletType == 0 || this.bulletType == 37) {
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 30 : -20), this.yPosition + 20, 3, 3, this.bulletXVel, this.bulletYVel, false, this.bulletType, 0, 0, this.canvas));
                            } else {
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 30 : -30), this.yPosition + 20, 3, 3, (24 * MyCanvas.cos(30) >> 9) * this.dir, 24 * MyCanvas.sin(30) >> 9, false, this.bulletType, 0, 0, this.canvas));
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 30 : -30), this.yPosition + 20, 3, 3, (24 * MyCanvas.cos(40) >> 9) * this.dir, 24 * MyCanvas.sin(40) >> 9, false, this.bulletType, 0, 0, this.canvas));
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 30 : -30), this.yPosition + 20, 3, 3, (24 * MyCanvas.cos(50) >> 9) * this.dir, 24 * MyCanvas.sin(50) >> 9, false, this.bulletType, 0, 0, this.canvas));
                            }
                            this.setBulletCount();
                            break block1;
                        }
                        case 1: {
                            if (this.frame != 0) break;
                            if (this.bulletType == 0 || this.bulletType == 37) {
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 25 : -10), this.yPosition + 11, 3, 3, this.bulletXVel, this.bulletYVel, false, this.bulletType, 0, 0, this.canvas));
                            } else {
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 25 : -10), this.yPosition + 11, 3, 3, (24 * MyCanvas.cos(20) >> 9) * this.dir, -(24 * MyCanvas.sin(20) >> 9), false, this.bulletType, 0, 0, this.canvas));
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 25 : -10), this.yPosition + 11, 3, 3, (24 * MyCanvas.cos(0) >> 9) * this.dir, -(24 * MyCanvas.sin(0) >> 9), false, this.bulletType, 0, 0, this.canvas));
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 25 : -10), this.yPosition + 11, 3, 3, (24 * MyCanvas.cos(20) >> 9) * this.dir, 24 * MyCanvas.sin(20) >> 9, false, this.bulletType, 0, 0, this.canvas));
                            }
                            this.setBulletCount();
                            break block1;
                        }
                        case 2: {
                            if (this.frame != 0) break;
                            if (this.bulletType == 0 || this.bulletType == 37) {
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 26 : -this.width + 4), this.yPosition, 3, 3, this.bulletXVel, this.bulletYVel, false, this.bulletType, 0, 0, this.canvas));
                            } else {
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 26 : -this.width + 4), this.yPosition - 7, 3, 3, (24 * MyCanvas.cos(30) >> 9) * this.dir, -(24 * MyCanvas.sin(30) >> 9), false, this.bulletType, 0, 0, this.canvas));
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 26 : -this.width + 4), this.yPosition - 7, 3, 3, (24 * MyCanvas.cos(40) >> 9) * this.dir, -(24 * MyCanvas.sin(40) >> 9), false, this.bulletType, 0, 0, this.canvas));
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 26 : -this.width + 4), this.yPosition - 7, 3, 3, (24 * MyCanvas.cos(50) >> 9) * this.dir, -(24 * MyCanvas.sin(50) >> 9), false, this.bulletType, 0, 0, this.canvas));
                            }
                            this.setBulletCount();
                            break block1;
                        }
                        case 3: {
                            if (this.frame != 3) break;
                            if (this.bulletType == 0 || this.bulletType == 37) {
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 5 : 6), this.yPosition - 30, 3, 3, this.bulletXVel, this.bulletYVel, false, this.bulletType, 0, 0, this.canvas));
                            } else {
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 5 : 6), this.yPosition - 20, 3, 3, -(24 * MyCanvas.cos(100) >> 9) * this.dir, -(24 * MyCanvas.sin(110) >> 9), false, this.bulletType, 0, 0, this.canvas));
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 5 : 6), this.yPosition - 20, 3, 3, (24 * MyCanvas.cos(90) >> 9) * this.dir, -(24 * MyCanvas.sin(90) >> 9), false, this.bulletType, 0, 0, this.canvas));
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 5 : 6), this.yPosition - 20, 3, 3, (24 * MyCanvas.cos(100) >> 9) * this.dir, -(24 * MyCanvas.sin(110) >> 9), false, this.bulletType, 0, 0, this.canvas));
                            }
                            this.setBulletCount();
                        }
                    }
                    break;
                }
                case 2: {
                    if (MyCanvas.haveKeyHold(1) && this.jumpLimit < 5) {
                        ++this.jumpLimit;
                    }
                    if (!MyCanvas.haveKeyPressed(256) || this.fireArrow) break;
                    this.fireArrow = true;
                    this.frame = (byte)-1;
                    this.actionFrmPtr = (byte)7;
                    this.bulletXVel = (byte)(this.bulletSpeed * this.dir);
                    this.bulletYVel = 0;
                    break;
                }
                case 34: {
                    if (!MyCanvas.haveKeyHold(1) && !MyCanvas.haveKeyHold(2) && !MyCanvas.haveKeyHold(128) || this.jumpLimit >= 4) break;
                    ++this.jumpLimit;
                    break;
                }
                case 44: {
                    this.xVel = (byte)5;
                    if (this.yVel > 5) {
                        if (this.jetWaitCtr > 0) {
                            this.jetframe = (byte)(this.jetframe + 1);
                            this.jetWaitCtr = 0;
                        } else {
                            this.jetWaitCtr = (byte)(this.jetWaitCtr + 1);
                        }
                        if (this.jetframe > 1) {
                            this.jetframe = 0;
                        }
                    } else {
                        if (this.jetWaitCtr > 0) {
                            this.jetframe = (byte)(this.jetframe + 1);
                            this.jetWaitCtr = 0;
                        } else {
                            this.jetWaitCtr = (byte)(this.jetWaitCtr + 1);
                        }
                        if (this.jetframe > 3) {
                            this.jetframe = (byte)2;
                        }
                    }
                    if (!this.jetStart) {
                        this.yVel = 0;
                    }
                    if (!this.jetStart) {
                        if (MyCanvas.gameLevel != 2) {
                            if (MyCanvas.gameLevel != 5 && (MyCanvas.haveKeyPressed(1) || MyCanvas.haveKeyPressed(1))) {
                                this.jetStart = true;
                                this.yVel = (byte)8;
                            }
                        }
                    }
                    if (this.canvas.showSun && !this.jetStart) {
                        this.yVel = 1;
                    }
                    if (!this.jetStart) ** GOTO lbl289
                    if (!MyCanvas.haveKeyPressed(1) && !MyCanvas.haveKeyHold(1)) ** GOTO lbl-1000
                    if (this.canvas.fuelPower > 0) ** GOTO lbl-1000
                    if (MyCanvas.gameLevel == 2) lbl-1000:
                    // 2 sources

                    {
                        this.waitCtr = 0;
                        --this.canvas.fuelPower;
                        if (this.yVel >= 8) {
                            this.yVel = (byte)8;
                            this.waitCtr = 0;
                        } else {
                            this.yVel = (byte)(this.yVel + 4);
                        }
                    } else if (MyCanvas.gameLevel == 4) {
                        this.waitCtr = (byte)(this.waitCtr + 1);
                        if (this.waitCtr > 3) {
                            this.yVel = (byte)-2;
                            this.waitCtr = (byte)3;
                        } else {
                            this.yVel = (byte)-1;
                        }
                    } else {
                        this.yVel = (byte)-1;
                    }
lbl289:
                    // 6 sources

                    if (this.jetStart && (MyCanvas.haveKeyPressed(64) || MyCanvas.haveKeyHold(64))) {
                        this.xPosition -= this.xVel;
                        this.dir = (byte)-1;
                        break;
                    }
                    if (this.jetStart && (MyCanvas.haveKeyPressed(4) || MyCanvas.haveKeyHold(4))) {
                        this.xPosition += this.xVel;
                        this.dir = 1;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(32)) {
                        this.firePos = this.firePos < 3 ? (this.firePos = (byte)(this.firePos + 1)) : this.firePos;
                        this.setFirePos();
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(8)) {
                        this.firePos = this.firePos > 0 ? (this.firePos = (byte)(this.firePos - 1)) : this.firePos;
                        this.setFirePos();
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(2048)) {
                        this.setWeapon();
                        this.setBulletType();
                        break;
                    }
                    this.setFirePos();
                    if (!MyCanvas.haveKeyPressed(256) && !MyCanvas.haveKeyHold(256)) break;
                    this.checkBullet();
                    break;
                }
                case 8: {
                    if (MyCanvas.haveKeyPressed(1)) {
                        if (this.weapon == 0) {
                            this.setWeaponAction();
                            this.frame = 0;
                        } else {
                            this.setWeaponAction();
                            this.frame = 1;
                        }
                        this.frameCtr = 0;
                    } else if (MyCanvas.haveKeyPressed(64)) {
                        if (this.dir == -1) {
                            this.action = (byte)43;
                        } else {
                            this.dir = (byte)-1;
                        }
                    } else if (MyCanvas.haveKeyPressed(4)) {
                        if (this.dir == 1) {
                            this.action = (byte)43;
                        } else {
                            this.dir = 1;
                        }
                    }
                    if (this.dir >= 0) {
                        this.bulletXVel = this.bulletSpeed;
                        this.bulletYVel = 0;
                        break;
                    }
                    this.bulletXVel = -this.bulletSpeed;
                    this.bulletYVel = 0;
                    break;
                }
                case 6: {
                    if (this.canvas.jetPackCollected && this.jetStart) {
                        this.action = (byte)44;
                        break;
                    }
                    this.xVel = 0;
                    if (MyCanvas.haveKeyHold(4) || MyCanvas.haveKeyHold(2)) {
                        this.dir = 1;
                        this.xVel = (byte)6;
                        break;
                    }
                    if (!MyCanvas.haveKeyHold(64) && !MyCanvas.haveKeyHold(128)) break;
                    this.dir = (byte)-1;
                    this.xVel = (byte)6;
                }
            }
        }
        catch (Exception var1_1) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    void update() {
        try {
            this.updateHero();
            if (MyCanvas.gameLevel != 4) {
                if (this.dir == 1) {
                    this.imageRotation = 0;
                    this.canvas.HeroXposOnScr = (MyCanvas.canvasWidth >> 1) - this.width;
                } else {
                    this.imageRotation = (byte)2;
                    this.canvas.HeroXposOnScr = MyCanvas.canvasWidth >> 1;
                }
            } else if (this.dir == 1) {
                this.imageRotation = 0;
                this.canvas.HeroXposOnScr = (MyCanvas.canvasWidth >> 1) - this.width;
                this.canvas.HeroYposOnScr = MyCanvas.canvasHeight >> 1;
            } else {
                this.imageRotation = (byte)2;
                this.canvas.HeroXposOnScr = MyCanvas.canvasWidth >> 1;
                this.canvas.HeroYposOnScr = MyCanvas.canvasHeight >> 1;
            }
            switch (this.action) {
                case 0: {
                    this.receiveKeypressed = true;
                    if (!this.canvas.jetPackCollected) ** GOTO lbl40
                    if (this.jetStart) ** GOTO lbl35
                    if (MyCanvas.gameLevel == 3) ** GOTO lbl35
                    if (MyCanvas.gameLevel != 4) ** GOTO lbl40
lbl35:
                    // 3 sources

                    this.frame = 0;
                    this.actionFrmPtr = 0;
                    this.imageNo = 0;
                    this.action = (byte)44;
                    break;
lbl40:
                    // 2 sources

                    this.setWeaponAction();
                    this.xVel = 0;
                    this.actionFrmPtr = 0;
                    ++this.frameCtr;
                    if (this.frameCtr > 1) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    this.imageNo = 0;
                    if (this.frame > 2) {
                        this.frame = 0;
                    }
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)3;
                    break;
                }
                case 1: {
                    this.imageNo = 0;
                    this.actionFrmPtr = 1;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame > 5) {
                        this.frame = 0;
                    }
                    this.xPosition += 6 * this.dir;
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)3;
                    break;
                }
                case 11: {
                    switch (this.firePos) {
                        case 0: {
                            this.actionFrmPtr = (byte)6;
                            this.imageNo = (byte)6;
                            this.frame = (byte)(this.frame + 1);
                            if (this.frame <= 4) break;
                            this.actionFrmPtr = 0;
                            this.imageNo = 0;
                            this.frame = 0;
                            this.action = 0;
                            break;
                        }
                        case 1: {
                            this.actionFrmPtr = (byte)2;
                            this.imageNo = (byte)4;
                            this.frame = (byte)(this.frame + 1);
                            if (this.frame <= 5) break;
                            this.actionFrmPtr = 0;
                            this.imageNo = 0;
                            this.frame = 0;
                            this.action = 0;
                            break;
                        }
                        case 2: {
                            this.actionFrmPtr = (byte)5;
                            this.imageNo = (byte)7;
                            this.frame = (byte)(this.frame + 1);
                            if (this.frame <= 5) break;
                            this.actionFrmPtr = 0;
                            this.imageNo = 0;
                            this.frame = 0;
                            this.action = 0;
                            break;
                        }
                        case 3: {
                            this.actionFrmPtr = (byte)4;
                            this.frame = (byte)(this.frame + 1);
                            this.imageNo = this.frame < 3 || this.frame > 7 ? (byte)2 : (byte)3;
                            if (this.frame <= 10) break;
                            this.actionFrmPtr = 0;
                            this.imageNo = 0;
                            this.frame = 0;
                            this.action = 0;
                        }
                    }
                    if (MyCanvas.isGroundTouched || this.canvas.jetPackCollected) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)3;
                    break;
                }
                case 44: {
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    break;
                }
                case 8: {
                    this.imageNo = (byte)9;
                    this.actionFrmPtr = (byte)9;
                    this.frame = 0;
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)3;
                    break;
                }
                case 43: {
                    if (MyCanvas.haveKeyPressed(1)) {
                        if (this.weapon == 0) {
                            this.setWeaponAction();
                            this.frame = 0;
                        } else {
                            this.setWeaponAction();
                            this.frame = 1;
                        }
                    }
                    if (MyCanvas.haveKeyHold(4)) {
                        this.action = (byte)43;
                        this.dir = 1;
                    } else if (MyCanvas.haveKeyHold(64)) {
                        this.action = (byte)43;
                        this.dir = (byte)-1;
                    }
                    if (MyCanvas.haveKeyReleased(64) || MyCanvas.haveKeyReleased(4)) {
                        this.action = (byte)8;
                        this.frame = 0;
                    }
                    this.frameCtr = 0;
                    this.imageNo = (byte)9;
                    this.actionFrmPtr = (byte)9;
                    this.frame = (byte)(this.frame + 1);
                    this.xPosition += (24 >> 4) * this.dir;
                    if (this.frame >= 5) {
                        this.frame = 0;
                    }
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)3;
                    break;
                }
                case 2: {
                    if (this.fireArrow) {
                        this.imageNo = 1;
                        if (this.frame < 4) {
                            this.frame = (byte)(this.frame + 1);
                            this.yPosition -= (byte)(24 >> 3);
                            ++this.jumpCtr;
                            if (this.frame != 2) break;
                            switch (this.weapon) {
                                case 0: {
                                    this.bulletType = 0;
                                    break;
                                }
                                case 1: {
                                    this.bulletType = (byte)37;
                                    break;
                                }
                                case 2: {
                                    this.bulletType = (byte)38;
                                    break;
                                }
                                case 3: {
                                    this.bulletType = (byte)39;
                                }
                            }
                            if (this.bulletType == 0 || this.bulletType == 37) {
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 25 : -10), this.yPosition + 11, 3, 3, this.bulletXVel, this.bulletYVel, false, this.bulletType, 0, 0, this.canvas));
                            } else {
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 25 : -10), this.yPosition + 11, 3, 3, (24 * MyCanvas.cos(20) >> 9) * this.dir, -(24 * MyCanvas.sin(20) >> 9), false, this.bulletType, 0, 0, this.canvas));
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 25 : -10), this.yPosition + 11, 3, 3, (24 * MyCanvas.cos(0) >> 9) * this.dir, -(24 * MyCanvas.sin(0) >> 9), false, this.bulletType, 0, 0, this.canvas));
                                this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 25 : -10), this.yPosition + 11, 3, 3, (24 * MyCanvas.cos(20) >> 9) * this.dir, 24 * MyCanvas.sin(20) >> 9, false, this.bulletType, 0, 0, this.canvas));
                            }
                            this.setBulletCount();
                            break;
                        }
                        this.fireArrow = false;
                        this.JumpHtReached = true;
                        this.action = (byte)6;
                        break;
                    }
                    this.actionFrmPtr = (byte)3;
                    this.imageNo = 1;
                    if (this.JumpHtReached) {
                        if (!MyCanvas.isGroundTouched) {
                            if (this.frame < 3) {
                                this.frame = (byte)(this.frame + 1);
                            }
                            this.action = (byte)6;
                            break;
                        }
                    }
                    if (this.JumpHtReached) {
                        if (MyCanvas.isGroundTouched) {
                            this.frame = (byte)2;
                            this.action = (byte)6;
                            this.yPosition += 24 >> 1;
                            break;
                        }
                    }
                    if (this.jumpCtr >= this.jumpLimit) break;
                    if (this.frame < 1) {
                        this.frame = (byte)(this.frame + 1);
                    }
                    if (this.frame != 0) {
                        this.yPosition -= (byte)((24 >> 1) - 4);
                        ++this.jumpCtr;
                    }
                    if (this.jumpCtr < this.jumpLimit) break;
                    this.JumpHtReached = true;
                    break;
                }
                case 6: {
                    if (this.isDead) {
                        this.imageNo = (byte)5;
                        this.actionFrmPtr = (byte)10;
                        this.frame = 0;
                        this.yPosition += 24 >> 1;
                        if (!MyCanvas.isGroundTouched) break;
                        this.action = (byte)5;
                        break;
                    }
                    this.actionFrmPtr = (byte)3;
                    if (MyCanvas.isGroundTouched) {
                        ++this.frameCtr;
                        if (this.frame != 2 || this.frameCtr < 3) {
                            this.imageNo = 0;
                            this.actionFrmPtr = 0;
                            this.frame = (byte)2;
                            break;
                        }
                        this.JumpHtReached = false;
                        this.xVel = 0;
                        this.frame = (byte)2;
                        this.imageNo = 0;
                        this.action = 0;
                        this.actionFrmPtr = 0;
                        if (this.weapon == 0) {
                            this.setWeaponAction();
                            this.frame = (byte)2;
                            this.actionFrmPtr = 0;
                            this.imageNo = 0;
                        } else {
                            this.setWeaponAction();
                            this.frame = (byte)2;
                            this.actionFrmPtr = 0;
                            this.imageNo = 0;
                        }
                        this.frameCtr = 0;
                        break;
                    }
                    this.xPosition += this.xVel * this.dir;
                    this.frameCtr = 0;
                    this.actionFrmPtr = (byte)3;
                    this.imageNo = 1;
                    this.frame = this.frame < 2 ? (byte)(this.frame + 1) : (byte)2;
                    this.yPosition += (byte)((24 >> 1) - 4);
                    break;
                }
                case 34: {
                    if (this.fireArrow) {
                        this.imageNo = 1;
                        if (this.frame < 4) {
                            this.frame = (byte)(this.frame + 1);
                            this.yPosition -= (byte)(24 >> 3);
                            ++this.jumpCtr;
                            if (this.frame != 2) break;
                            this.canvas.addTopLayerElement(new Elements(this.xPosition, this.yPosition + 11, 3, 3, this.bulletXVel, this.bulletYVel, false, this.bulletType, 0, 0, this.canvas));
                            this.setBulletCount();
                            break;
                        }
                        this.fireArrow = false;
                        this.JumpHtReached = true;
                        this.action = (byte)6;
                        break;
                    }
                    this.actionFrmPtr = (byte)3;
                    this.imageNo = 1;
                    this.xPosition += this.xVel * this.dir;
                    if (this.JumpHtReached) {
                        if (!MyCanvas.isGroundTouched) {
                            if (this.frame < 2) {
                                this.frame = (byte)(this.frame + 1);
                            }
                            this.action = (byte)6;
                            this.yPosition += (24 >> 1) - 4;
                            break;
                        }
                    }
                    if (this.JumpHtReached) {
                        if (MyCanvas.isGroundTouched) {
                            this.frame = (byte)3;
                            this.action = (byte)6;
                            this.yPosition += (24 >> 1) - 4;
                            break;
                        }
                    }
                    if (this.jumpCtr >= this.jumpLimit) break;
                    if (this.frame <= 1) {
                        this.frame = (byte)(this.frame + 1);
                    }
                    this.yPosition -= (24 >> 1) - 4;
                    ++this.jumpCtr;
                    if (this.jumpCtr < this.jumpLimit) break;
                    this.JumpHtReached = true;
                    break;
                }
                case 5: {
                    this.yVel = this.jetStart != false ? 1 : 0;
                    this.imageNo = (byte)5;
                    this.actionFrmPtr = (byte)10;
                    if (this.frameCtr < 2) {
                        ++this.frameCtr;
                    } else {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    if (this.frame <= 7) break;
                    this.frame = (byte)7;
                    this.canvas.getClass();
                    this.canvas.currPage = (byte)9;
                    this.canvas.shutterY = 0;
                    this.canvas.shutterMaxY = 24 * 2;
                }
            }
            this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + this.frame);
            if (this.isHit) {
                if (this.hitCounter == 0) {
                    this.canvas.life = (byte)(this.canvas.life - 7);
                }
                this.hitCounter = (byte)(this.hitCounter + 1);
                if (this.hitCounter > 15) {
                    this.isHit = false;
                    this.hitCounter = 0;
                }
            }
        }
        catch (Exception var1_1) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void draw(Graphics g) {
        try {
            block9: {
                block10: {
                    if (this.hitCounter % 2 != 0) {
                        if (this.action != 5) return;
                    }
                    if (!this.canvas.jetPackCollected) break block9;
                    if (this.jetStart) break block10;
                    if (MyCanvas.gameLevel == 3) break block10;
                    if (MyCanvas.gameLevel != 4) break block9;
                }
                this.yPosition -= this.yVel;
                if (this.action != 5) {
                    g.drawRegion(MyCanvas.jetPackImg, MyCanvas.jetPackImg.getWidth() / 5 * this.jetframe, 0, MyCanvas.jetPackImg.getWidth() / 5, MyCanvas.jetPackImg.getHeight(), (int)this.imageRotation, this.xPosition + (this.dir == 1 ? -7 : 9), this.yPosition, 0);
                }
                g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]), 0);
                return;
            }
            if (MyCanvas.gameLevel == 5 && (Enemy.isAttack1 || Enemy.isAttack2) && this.action != 5) {
                this.canvas.effectPtr = (byte)(Enemy.isAttack1 ? 46 + this.waitCtr : 48 + this.waitCtr);
                g.drawRegion(MyCanvas.laserHitImg, (int)this.canvas.effectClip[this.canvas.effectPtr * 6 + 0], (int)this.canvas.effectClip[this.canvas.effectPtr * 6 + 1], (int)this.canvas.effectClip[this.canvas.effectPtr * 6 + 2], (int)this.canvas.effectClip[this.canvas.effectPtr * 6 + 3], 0, this.xPosition + this.canvas.effectClip[this.canvas.effectPtr * 6 + 4] + (this.dir > 0 ? 0 : -(this.width >> 2)), this.yPosition + this.canvas.effectClip[this.canvas.effectPtr * 6 + 5], 0);
                this.waitCtr = (byte)(this.waitCtr + 1);
                if (this.waitCtr > 1) {
                    Enemy.isAttack1 = false;
                    Enemy.isAttack2 = false;
                    this.waitCtr = 0;
                }
            }
            g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]), 0);
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

