/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.mathquiz;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import net.handyx.api.BasicSoundManager;
import net.handyx.api.FontRenderer;
import net.handyx.api.RecordManager;
import net.handyx.api.RunnableCanvas;
import net.handyx.api.Toast;

public class GameRes {
    public static final String RES_FOLDER = "";
    public static final boolean SOUND_SUPPORTS_VOLUME = false;
    public static final boolean DISABLE_ALPHA_EFFECTS = false;
    public static String VERSION_STRING = "1.0.0";
    public static final boolean DISABLE_ANIMATING_PANELS = false;
    public static boolean debug = true;
    public static boolean setting_sound = true;
    public static int setting_sound_volume = 50;
    public static boolean setting_countdown = false;
    public static boolean setting_show_answers = true;
    public static final String[] soundResources = new String[]{"applause", "incorrect", "joker", "whistle_end_lose", "whistle_end_win", "whistle_start"};
    public static boolean soundEnabled = false;
    public static BasicSoundManager soundMan = null;
    public static boolean useVolumeControl = true;
    public static boolean supportsMixing = false;
    public static FontRenderer gameFont;
    public static FontRenderer gameBlackFont;
    public static FontRenderer whiteFont;
    public static Image bgImage;
    public static Image menuBarImage;
    public static Image scrollBarOnImage;
    public static Image scrollBarOffImage;
    public static Image quizTitleImage;
    public static Image meshImage;
    public static Image scrollImage;
    public static Image yesOnImage;
    public static Image yesOffImage;
    public static Image noOnImage;
    public static Image noOffImage;
    public static boolean resourcesLoaded;
    private static Random a;
    public static Vector toastQueue;

    public static void purgeResources() {
        resourcesLoaded = false;
        menuBarImage = null;
        quizTitleImage = null;
        bgImage = null;
        scrollBarOffImage = null;
        scrollBarOnImage = null;
        if (gameFont != null) {
            gameFont.purge();
            gameFont = null;
        }
        if (gameBlackFont != null) {
            gameBlackFont.purge();
            gameBlackFont = null;
        }
        if (whiteFont != null) {
            whiteFont.purge();
            whiteFont = null;
        }
        System.gc();
    }

    public static void loadResources() {
        if (resourcesLoaded) {
            return;
        }
        gameFont = new FontRenderer("/fonts/komik_thin_white_16pt");
        gameBlackFont = new FontRenderer("/fonts/komik_thin_black_16pt");
        whiteFont = new FontRenderer("/fonts/komik_thin_white");
        try {
            if (soundMan == null) {
                soundMan = new BasicSoundManager();
                if (useVolumeControl) {
                    soundMan.enableVolumeControl();
                }
                soundMan.setSounds(soundResources);
                soundMan.loadSounds();
                soundMan.start();
            }
            bgImage = RunnableCanvas.loadImage("/bg.png");
            quizTitleImage = RunnableCanvas.loadImage("/quiz_title.png");
            menuBarImage = RunnableCanvas.loadImage("/menu_bar.png");
            scrollBarOnImage = RunnableCanvas.loadImage("/scrollbar_on.png");
            scrollBarOffImage = RunnableCanvas.loadImage("/scrollbar_off.png");
            resourcesLoaded = true;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static int random(int n) {
        if (n == 0) {
            return 0;
        }
        return Math.abs(a.nextInt() % n);
    }

    public static void displayToast(String string) {
        if (toastQueue == null) {
            toastQueue = new Vector();
        }
        toastQueue.addElement(new Toast(string, 3000L));
    }

    public static void processToasts() {
        if (toastQueue != null) {
            for (int i = 0; i < toastQueue.size(); ++i) {
                Toast toast = (Toast)toastQueue.elementAt(i);
                if (!toast.hasExpired()) continue;
                toastQueue.removeElementAt(i);
                --i;
            }
        }
    }

    public static void renderToasts(Graphics graphics) {
        if (toastQueue != null) {
            for (int i = 0; i < toastQueue.size(); ++i) {
                GameRes.renderToast(graphics, (Toast)toastQueue.elementAt(i));
            }
        }
    }

    public static void renderToast(Graphics graphics, Toast stringArray) {
        if (gameFont == null) {
            return;
        }
        int n = RunnableCanvas.screenWidth - 50;
        stringArray = whiteFont.wrap(stringArray.getMessage(), n - 12);
        int n2 = whiteFont.getHeight() * stringArray.length + 15;
        int n3 = RunnableCanvas.screenHeight - n2 - 30;
        graphics.setColor(0);
        graphics.fillRoundRect(25, n3, n, n2, 14, 14);
        for (n = 0; n < stringArray.length; ++n) {
            whiteFont.drawString(graphics, stringArray[n], (RunnableCanvas.screenWidth - whiteFont.stringWidth(stringArray[n])) / 2, n3 + 7 + n * whiteFont.getHeight());
        }
    }

    public static void getVersion(MIDlet object) {
        try {
            object = object.getAppProperty("MIDlet-Version");
            if (object != null) {
                VERSION_STRING = ((String)object).trim();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static String loadText(String object) {
        if (object == null) {
            return RES_FOLDER;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            object = object.getClass().getResourceAsStream(RES_FOLDER + (String)object);
            if (object != null) {
                int n;
                while ((n = ((InputStream)object).read()) != -1) {
                    stringBuffer.append((char)n);
                }
                ((InputStream)object).close();
            }
        }
        catch (Exception exception) {
            object = exception;
            GameRes.log(exception.toString());
        }
        return stringBuffer.toString();
    }

    public static void doSound(String string) {
        if (!soundEnabled || !setting_sound) {
            return;
        }
        if (soundMan != null) {
            soundMan.setVolume(setting_sound_volume);
            soundMan.queueSound(string);
        }
    }

    public static void stopSounds() {
        if (soundMan != null) {
            soundMan.stopSounds();
        }
    }

    public static boolean supportsSound() {
        return true;
    }

    public static void log(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public void loadSettings() {
        try {
            if (RecordManager.exists("quiz_settings")) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(RecordManager.load("quiz_settings")));
                setting_countdown = dataInputStream.readBoolean();
                setting_show_answers = dataInputStream.readBoolean();
                setting_sound = dataInputStream.readBoolean();
                setting_sound_volume = dataInputStream.readInt();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void saveSettings() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBoolean(setting_countdown);
            dataOutputStream.writeBoolean(setting_show_answers);
            dataOutputStream.writeBoolean(setting_sound);
            dataOutputStream.writeInt(setting_sound_volume);
            RecordManager.save(byteArrayOutputStream.toByteArray(), "quiz_settings");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static {
        resourcesLoaded = false;
        a = new Random();
        toastQueue = null;
    }
}

