/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenGame;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMenu
implements IScreen {
    private MainCanvas mainCanvas;
    public static final int COMP_ID_PLAY = 0;
    public static final int COMP_ID_INSTRUCTIONS = 1;
    public static final int COMP_ID_SCORE = 2;
    public static final int COMP_ID_ABOUT = 3;
    public static final int COMP_ID_SETTINGS = 4;
    public static final int COMP_ID_QUIT = 5;
    public static final int COMP_ID_OPTIONS = 6;
    public static final int COMP_ID_RIGHT_FK = 7;
    public static final int COMP_ID_LEFT_FK = 8;
    public static final int COMP_ID_NONE = 9;
    private static final int TOTAL_COMP_IDS = 10;
    public static final int COMP_ID_PLAY_TXT = 0;
    public static final int COMP_ID_INSTRUCTIONS_TXT = 1;
    public static final int COMP_ID_SCORE_TXT = 2;
    public static final int COMP_ID_ABOUT_TXT = 3;
    public static final int COMP_ID_NONE_TXT = 6;
    private static final int TOTAL_COMP_IDS_TXT = 7;
    private int actualSceen = 0;
    private static final int SCREEN_MAIN_MENU = 0;
    private static final int SCREEN_INSTRUCTIONS = 1;
    private static final int SCREEN_ABOUT = 2;
    private static final int SCREEN_START_GAME = 3;
    private static final int SCREEN_QUIT_GAME = 4;
    private static final int SCREEN_OPTIONS = 5;
    private static final int SCREEN_TOPSCORES = 6;
    private Rectangle[] rectItems = new Rectangle[10];
    private Rectangle[] rectItems_TXT = new Rectangle[7];
    private int[][] _animationSequence = new int[7][11];
    private AnimationComponent[] _animationComponents = new AnimationComponent[11];
    private Rectangle rectLeftFk;
    private Rectangle rectRightFk;
    private Rectangle _rectTopBig;
    private Rectangle rectPanel;
    private Rectangle rectText;
    private Rectangle _rectDialog;
    private Rectangle _rectAboutDialog;
    private int selectedCompId;
    private int selectorCompId;
    private int interuption = 0;
    private int _iTotalRowTiles = 0;
    private int _iTotalColTiles = 0;
    private int _iOffsetX;
    private int _iFinalHeight;
    private boolean scrollUP = false;
    private boolean scrollDOWN = true;
    private boolean needRepaint = false;
    private boolean activeButton = true;
    PreparedText _ptMnuItem;
    PreparedText _ptNavigationKeysBB;
    PreparedText title;
    PreparedText _ptInstruction;
    PreparedText _ptVersionOfGame;
    PreparedText _ptDifficulty;
    private int textOffsetY;
    private Image _imgGameLogo;
    private Image _imgCorpLogo;
    private Image _imgMenuBg;
    private Image _imgButton;
    private Image _imgButtonSelector;
    private Image _imgWindow;
    private Sprite _sprArrows;
    private Sprite _sprIconsFk;
    private Sprite _sprWindow;
    private static int _WIDTH = 0;
    private static int _HEIGHT = 0;
    private static int _totalRowTiles = 0;
    private static int _totalColTiles = 0;
    boolean check = false;
    int _iColorBg = 15691352;
    private int _iMode = 0;
    int _finalHeight;
    int _off;
    int cycle = 10;
    private int musicControler = 0;
    private int _sequenceStop = 0;
    private int _sequenceShow = 1;
    private int _sequenceHide = 2;
    private int _sequence = 0;
    boolean changeSequence = false;
    private int nextScreen;
    int a;
    private boolean releasedTouch = false;
    private int sel = this.selectedCompId;
    private int s = this.selectedCompId;
    private int force = this.selectedCompId;
    int posX = 0;
    int posY = 0;

    public ScreenMenu(MainCanvas mainCanvas, int selectedItem, int _imode) {
        MainCanvas.counterX = 0;
        MainCanvas.counterY = 0;
        MainCanvas.slcPack = 0;
        this.actualSceen = 0;
        this.mainCanvas = mainCanvas;
        this.initDimensions();
        this.selectedCompId = 9;
        this.selectorCompId = 9;
        this._iMode = _imode;
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initTxt();
        this.calculatePositions();
        this.prepareTxt();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.initMode();
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{3, 8, 2, 6, 7, 5});
        Resources.loadSprites(new int[]{13, 7, 8, 12, 11, 16, 9, 4, 16});
        Resources.loadGFont(0);
        Resources.loadGFont(1);
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{3, 8, 3, 6, 7, 5});
        Resources.freeSprites(new int[]{13, 7, 8, 12, 11, 16, 9, 4, 16});
        Resources.freeGFont(0);
        Resources.freeGFont(1);
    }

    private void initDimensions() {
        _WIDTH = this.mainCanvas.getWidth();
        _HEIGHT = this.mainCanvas.getHeight();
    }

    private void initImages() {
        this._imgGameLogo = Resources.resImgs[2];
        this._imgCorpLogo = Resources.resImgs[8];
        this._imgMenuBg = Resources.resImgs[3];
        this._imgButton = Resources.resImgs[6];
        this._imgButtonSelector = Resources.resImgs[7];
        this._imgWindow = Resources.resImgs[5];
    }

    private void initSprites() {
        this._sprArrows = Resources.resSprs[13];
        this._sprIconsFk = Resources.resSprs[12];
        this._sprWindow = Resources.resSprs[4];
    }

    public void initTxt() {
        this._ptMnuItem = new PreparedText(Resources.resGFonts[0]);
        this._ptVersionOfGame = new PreparedText(Resources.resGFonts[0]);
        this._ptInstruction = new PreparedText(Resources.resGFonts[0]);
        this._ptNavigationKeysBB = new PreparedText(Resources.resGFonts[1]);
        this._ptDifficulty = new PreparedText(Resources.resGFonts[0]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 0;
        this._animationSequence[0][1] = 1;
        this._animationSequence[0][2] = 2;
        this._animationSequence[0][3] = 3;
        this._animationSequence[0][4] = 4;
        this._animationSequence[0][5] = 8;
        this._animationSequence[0][6] = -1;
        this._animationSequence[0][7] = -1;
        this._animationSequence[0][8] = -1;
        this._animationSequence[0][9] = -1;
        this._animationSequence[0][10] = -1;
        this._animationSequence[5][0] = 6;
        this._animationSequence[5][1] = 7;
        this._animationSequence[5][2] = 11;
        this._animationSequence[5][3] = 0;
        this._animationSequence[5][4] = -1;
        this._animationSequence[5][5] = -1;
        this._animationSequence[5][6] = -1;
        this._animationSequence[5][7] = -1;
        this._animationSequence[5][8] = -1;
        this._animationSequence[5][9] = -1;
        this._animationSequence[5][10] = -1;
        this._animationSequence[1][0] = 6;
        this._animationSequence[1][1] = 8;
        this._animationSequence[1][2] = 9;
        this._animationSequence[1][3] = -1;
        this._animationSequence[1][4] = -1;
        this._animationSequence[1][5] = -1;
        this._animationSequence[1][6] = -1;
        this._animationSequence[1][7] = -1;
        this._animationSequence[1][8] = -1;
        this._animationSequence[1][9] = -1;
        this._animationSequence[1][10] = -1;
        this._animationSequence[2][0] = 5;
        this._animationSequence[2][1] = 8;
        this._animationSequence[2][2] = 10;
        this._animationSequence[2][3] = -1;
        this._animationSequence[2][4] = -1;
        this._animationSequence[2][5] = -1;
        this._animationSequence[2][6] = -1;
        this._animationSequence[2][7] = -1;
        this._animationSequence[2][8] = -1;
        this._animationSequence[2][9] = -1;
        this._animationSequence[2][10] = -1;
        this._animationSequence[4][0] = 6;
        this._animationSequence[4][1] = 7;
        this._animationSequence[4][2] = 8;
        this._animationSequence[4][3] = -1;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
        this._animationSequence[4][6] = -1;
        this._animationSequence[4][7] = -1;
        this._animationSequence[4][8] = -1;
        this._animationSequence[4][9] = -1;
        this._animationSequence[4][10] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this._rectTopBig, _WIDTH, _HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectItems[0], _WIDTH, _HEIGHT);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectItems[1], _WIDTH, _HEIGHT);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectItems[3], _WIDTH, _HEIGHT);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this.rectItems[2], _WIDTH, _HEIGHT);
        this._animationComponents[4].startShowAnimation(0);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this.rectPanel, _WIDTH, _HEIGHT);
        this._animationComponents[5].startShowAnimation(2);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, this.rectText, _WIDTH, _HEIGHT);
        this._animationComponents[6].startShowAnimation(3);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this.rectItems[7], _WIDTH, _HEIGHT);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this.rectItems[8], _WIDTH, _HEIGHT);
        this._animationComponents[8].startShowAnimation(0);
        this._animationComponents[9] = new AnimationComponent(this.mainCanvas, this._rectDialog, _WIDTH, _HEIGHT);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10] = new AnimationComponent(this.mainCanvas, this._rectAboutDialog, _WIDTH, _HEIGHT);
        this._animationComponents[10].startShowAnimation(2);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(0);
        this._animationComponents[5].startShowAnimation(2);
        this._animationComponents[6].startShowAnimation(3);
        this._animationComponents[7].startShowAnimation(0);
        this._animationComponents[8].startShowAnimation(1);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10].startShowAnimation(2);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(1);
        this._animationComponents[2].startHideAnimation(0);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(0);
        this._animationComponents[5].startHideAnimation(2);
        this._animationComponents[6].startHideAnimation(3);
        this._animationComponents[7].startHideAnimation(0);
        this._animationComponents[8].startHideAnimation(1);
        this._animationComponents[9].startHideAnimation(3);
        this._animationComponents[10].startHideAnimation(2);
    }

    private void freeGraphics() {
        this._imgGameLogo = null;
        this._imgCorpLogo = null;
        this._imgMenuBg = null;
        this._imgButton = null;
        this._imgButtonSelector = null;
        this._imgWindow = null;
        this._sprArrows = null;
        this._sprIconsFk = null;
        this._sprWindow = null;
        this._ptMnuItem = null;
        this._ptVersionOfGame = null;
        this._ptInstruction = null;
        this._ptNavigationKeysBB = null;
        this._ptDifficulty = null;
    }

    public void prepareTxt() {
        String controls = "";
        this.textOffsetY = 0;
        controls = Resources.resTexts[0].getHashedString(16);
        controls = Resources.resTexts[0].getHashedString(17);
        this._ptVersionOfGame.prepareText(X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + ", " + X.singleton.getAppProperty("MIDlet-Version"), this.rectPanel.width);
        this._ptInstruction.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls + "\n\n", this.rectText.width);
        this._ptInstruction.setLineHeightCorrection(-2);
    }

    private void initMode() {
        if (this._iMode >= 3) {
            this._iMode = 0;
        }
        this._imgGameLogo = Resources.resImgs[2];
        this._imgMenuBg = Resources.resImgs[3];
        this._iColorBg = 15691352;
    }

    private void changeGraphicsForMode() {
        ++this._iMode;
        if (this._iMode >= 3) {
            this._iMode = 0;
        }
        this._imgGameLogo = Resources.resImgs[2];
        this._imgMenuBg = Resources.resImgs[3];
        this._iColorBg = 15691352;
    }

    public void beforeInteruption() {
        this.check = MainCanvas.soundManager.IsSoundOn();
        MainCanvas.soundManager.Stop();
        this.interuption = 1;
    }

    public void afterInteruption() {
        if (this.interuption == 0 && MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    private void calculatePositions() {
        int itemHeight = Resources.resGFonts[0].getHeight();
        int itemWidth = _WIDTH;
        int posX = _WIDTH >> 1;
        int posY = (_HEIGHT >> 1) - (itemHeight << 1);
        if (this._sprWindow == null) {
            this._sprWindow = Resources.resSprs[4];
        }
        int rectTextOffsetX = this._sprIconsFk.getWidth();
        int rectTextOffsetY = this._sprIconsFk.getHeight();
        this.rectPanel = new Rectangle(0, itemHeight, _WIDTH, _HEIGHT - (itemHeight << 1));
        this.rectText = new Rectangle(rectTextOffsetX, this.rectPanel.y + rectTextOffsetY, _WIDTH - (rectTextOffsetX << 1), this.rectPanel.height - (this.rectPanel.y + rectTextOffsetY));
        this._rectTopBig = new Rectangle(_WIDTH >> 1, 0, this._imgGameLogo.getWidth(), this._imgGameLogo.getHeight());
        this.rectItems[7] = this.rectLeftFk = new Rectangle(0, _HEIGHT - this._sprIconsFk.getHeight(), this._sprIconsFk.getWidth(), this._sprIconsFk.getHeight());
        this.rectItems[8] = this.rectRightFk = new Rectangle(this.mainCanvas.getWidth() - this._sprIconsFk.getWidth(), _HEIGHT - this._sprIconsFk.getHeight(), this._sprIconsFk.getWidth(), this._sprIconsFk.getHeight());
        int _iOffsetY = _HEIGHT - this._imgGameLogo.getWidth() - this._sprIconsFk.getWidth();
        posY = this._imgGameLogo.getHeight() + (_iOffsetY >>= 4);
        posX = (_WIDTH >> 1) - (this._imgButton.getWidth() >> 1);
        this.rectItems[0] = new Rectangle(posX, posY, this._imgButton.getWidth(), this._imgButton.getHeight());
        this.rectItems[1] = new Rectangle(posX, posY += this._imgButton.getHeight() + _iOffsetY, this._imgButton.getWidth(), this._imgButton.getHeight());
        this.rectItems[3] = new Rectangle(posX, posY += this._imgButton.getHeight() + _iOffsetY, this._imgButton.getWidth(), this._imgButton.getHeight());
        this.rectItems[2] = new Rectangle(posX, posY += this._imgButton.getHeight() + _iOffsetY, this._imgButton.getWidth(), this._imgButton.getHeight());
        int _windowWidth = _WIDTH >> 1;
        int _offsetX = _windowWidth % this._sprWindow.getWidth() > 0 ? _windowWidth % this._sprWindow.getWidth() : this._sprWindow.getWidth();
        int _offsetTopY = (this._sprIconsFk.getHeight() - this._sprIconsFk.getHeight() << 1) + this._sprIconsFk.getHeight();
        int _offsetBottomY = this._sprIconsFk.getHeight() + (this._sprIconsFk.getHeight() - this._sprIconsFk.getHeight());
        int _panelHeight = _HEIGHT - _offsetTopY - _offsetBottomY;
        this._iOffsetX = _offsetX;
        this._iFinalHeight = _panelHeight % this._sprWindow.getWidth() == 0 ? _panelHeight : _panelHeight - _panelHeight % this._sprWindow.getWidth();
        this._rectDialog = new Rectangle(_offsetX, _offsetTopY, _WIDTH - (_offsetX << 1), this._iFinalHeight);
        this._rectAboutDialog = new Rectangle(_offsetX, _offsetTopY, _WIDTH - (_offsetX << 1), this._iFinalHeight);
        this.calculateWindowTiles();
    }

    private void calculateWindowTiles() {
        this._iTotalColTiles = (_WIDTH - (this._iOffsetX << 1)) / this._sprWindow.getWidth();
        this._iTotalRowTiles = this._iFinalHeight / this._sprWindow.getWidth();
    }

    public void update(long lastRunLenght) {
        this.musicInteruptUpdate();
        this.animationController();
        this.animationComponentsUpdate();
        if (this.actualSceen == 1) {
            this.textMove();
            if (this.needRepaint) {
                this.mainCanvas.repaint();
            }
        }
    }

    private boolean animationController() {
        if (this.changeSequence) {
            if (this._sequence == this._sequenceShow) {
                this.showAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceHide) {
                this.hideAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceStop) {
                this.changeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationSequence[this.actualSceen].length; ++i) {
            if (this._animationSequence[this.actualSceen][i] == -1 || this._animationComponents[this._animationSequence[this.actualSceen][i]] == null || this._animationComponents[this._animationSequence[this.actualSceen][i]].isComponentAnimated()) continue;
            this._animationComponents[this._animationSequence[this.actualSceen][i]].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._sequence == this._sequenceHide) {
                if (this.nextScreen == 3) {
                    this.startGameScreen();
                }
                this._sequence = this._sequenceShow;
                this.actualSceen = this.nextScreen;
                this.changeSequence = true;
            } else if (this._sequence == this._sequenceShow) {
                this._sequence = this._sequenceStop;
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextScreen) {
        this.changeSequence = changeSequencem;
        this.nextScreen = nextScreen;
        this._sequence = this._sequenceHide;
    }

    private void startGameScreen() {
        ScreenGame sg = new ScreenGame(this.mainCanvas, this._iMode);
        this.mainCanvas.changeLastActiveScreen(sg);
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
        }
    }

    private void musicInteruptUpdate() {
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this.actualSceen) {
            case 0: {
                this.paintGameLogo(g);
                this.paintMainMenuDialogItems(g);
                break;
            }
            case 1: {
                this.paintWindow(g, this._rectDialog);
                this.paintInstrusctionTxt(g);
                this.paintArrows(g);
                break;
            }
            case 2: {
                this.paintWindow(g, this._rectAboutDialog);
                this.paintAboutLogo(g);
                break;
            }
            case 4: {
                this.paintQuit(g);
            }
        }
        this.paintFK(g);
    }

    public void paintBackground(Graphics g) {
        if (this._imgMenuBg == null) {
            System.out.println("Image is null");
        }
        g.drawImage(this._imgMenuBg, _WIDTH >> 1, _HEIGHT >> 1, 3);
    }

    public void paintGameLogo(Graphics g) {
        g.drawImage(this._imgGameLogo, this._rectTopBig.x, this._rectTopBig.getCenterY(), 3);
    }

    private void paintInstrusctionTxt(Graphics g) {
        this._ptInstruction.drawText(g, this.rectText, this.textOffsetY, 20);
    }

    private void paintArrows(Graphics g) {
        if (this.scrollDOWN && this.scrollUP) {
            this._sprArrows.setPosition((this.rectText.x + this.rectText.width >> 1) + (this._sprArrows.getWidth() >> 1), this.rectText.y - this._sprArrows.getHeight() - (this._sprArrows.getHeight() >> 1));
            this._sprArrows.setFrame(0);
            this._sprArrows.paint(g);
            this._sprArrows.setPosition((this.rectText.x + this.rectText.width >> 1) + (this._sprArrows.getWidth() >> 1), this.rectText.y + this.rectText.height + (this._sprArrows.getHeight() >> 1));
            this._sprArrows.setFrame(1);
            this._sprArrows.paint(g);
        } else if (!this.scrollDOWN && this.scrollUP) {
            this._sprArrows.setPosition((this.rectText.x + this.rectText.width >> 1) + (this._sprArrows.getWidth() >> 1), this.rectText.y - this._sprArrows.getHeight() - (this._sprArrows.getHeight() >> 1));
            this._sprArrows.setFrame(0);
            this._sprArrows.paint(g);
        }
        if (this.scrollDOWN && !this.scrollUP) {
            this._sprArrows.setPosition((this.rectText.x + this.rectText.width >> 1) + (this._sprArrows.getWidth() >> 1), this.rectText.y + this.rectText.height + (this._sprArrows.getHeight() >> 1));
            this._sprArrows.setFrame(1);
            this._sprArrows.paint(g);
        }
    }

    private void paintAboutLogo(Graphics g) {
        g.drawImage(this._imgCorpLogo, this.rectPanel.getCenterX(), this.rectPanel.getCenterY(), 3);
        this._ptVersionOfGame.prepareText(X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + ", " + X.singleton.getAppProperty("MIDlet-Version"), this.rectPanel.width);
        this._ptVersionOfGame.drawText(g, this.rectPanel, this._sprIconsFk.getHeight(), 33);
    }

    private void paintQuit(Graphics g) {
        this._ptVersionOfGame.prepareText(Resources.resTexts[0].getHashedString(2), _WIDTH);
        g.drawImage(this._imgWindow, this.rectText.getCenterX(), this.rectText.getCenterY(), 3);
        this._ptVersionOfGame.drawText(g, this.rectText, 0, 3);
    }

    private void paintFK(Graphics g) {
        if (this.actualSceen == 4) {
            this._sprIconsFk.setFrame(3);
            this._sprIconsFk.setPosition(this.rectItems[7].x, this.rectItems[7].y);
            this._sprIconsFk.paint(g);
            this._sprIconsFk.setFrame(4);
            this._sprIconsFk.setPosition(this.rectItems[8].x, this.rectItems[8].y);
            this._sprIconsFk.paint(g);
        } else if (this.actualSceen == 0) {
            this._sprIconsFk.setFrame(6);
            this._sprIconsFk.setPosition(this.rectItems[8].x, this.rectItems[8].y);
            this._sprIconsFk.paint(g);
        } else if (this.actualSceen != 0) {
            this._sprIconsFk.setFrame(5);
            this._sprIconsFk.setPosition(this.rectItems[8].x, this.rectItems[8].y);
            this._sprIconsFk.paint(g);
        }
    }

    private void paintMainMenuDialogItems(Graphics g) {
        if (this.selectedCompId == 0) {
            this.paintGraphicsButton(g, this.selectedCompId, 0, true);
        } else {
            this.paintGraphicsButton(g, 0, 0, false);
        }
        if (this.selectedCompId == 2) {
            this.paintGraphicsButton(g, this.selectedCompId, MainCanvas.soundManager.IsSoundOn() ? 0 : 1, true);
        } else {
            this.paintGraphicsButton(g, 2, MainCanvas.soundManager.IsSoundOn() ? 0 : 1, false);
        }
        if (this.selectedCompId == 1) {
            this.paintGraphicsButton(g, this.selectedCompId, 3, true);
        } else {
            this.paintGraphicsButton(g, 1, 3, false);
        }
        if (this.selectedCompId == 3) {
            this.paintGraphicsButton(g, this.selectedCompId, 2, true);
        } else {
            this.paintGraphicsButton(g, 3, 2, false);
        }
    }

    private void paintGraphicsButton(Graphics g, int _type, int frame, boolean active) {
        if (active) {
            g.drawImage(this._imgButtonSelector, this.rectItems[_type].getCenterX(), this.rectItems[_type].getCenterY(), 3);
        } else {
            g.drawImage(this._imgButton, this.rectItems[_type].getCenterX(), this.rectItems[_type].getCenterY(), 3);
        }
        this._ptMnuItem.prepareText(this.getButtonName(_type), this.rectItems[_type].width);
        this._ptMnuItem.drawText(g, this.rectItems[_type], 0, 3);
    }

    private String getButtonName(int _idx) {
        if (_idx == 0) {
            return Resources.resTexts[0].getHashedString(21);
        }
        if (_idx == 1) {
            return Resources.resTexts[0].getHashedString(22);
        }
        if (_idx == 3) {
            return Resources.resTexts[0].getHashedString(23);
        }
        if (_idx == 2) {
            return MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27);
        }
        return "NAN";
    }

    private void paintWindow(Graphics g, Rectangle _rectWindow) {
        int _actualTileX = 0;
        int _actualTileY = 0;
        for (int x = _rectWindow.x; x < _rectWindow.x + _rectWindow.width; x += this._sprWindow.getWidth()) {
            for (int y = _rectWindow.y; y < _rectWindow.y + _rectWindow.height; y += this._sprWindow.getWidth()) {
                this._sprWindow.setFrame(this.getWindowTileSprite(_actualTileX, _actualTileY));
                this._sprWindow.setPosition(x, y);
                this._sprWindow.paint(g);
                ++_actualTileY;
            }
            _actualTileY = 0;
            ++_actualTileX;
        }
    }

    private int getWindowTileSprite(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < this._iTotalColTiles - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == this._iTotalColTiles - 1) {
            return 2;
        }
        if (_y == this._iTotalRowTiles - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < this._iTotalRowTiles - 1 && _y > 0) {
            return 3;
        }
        if (_x == this._iTotalColTiles - 1 && _y < this._iTotalRowTiles - 1 && _y > 0) {
            return 5;
        }
        if (_y == this._iTotalRowTiles - 1 && _x < this._iTotalColTiles - 1 && _x > 0) {
            return 7;
        }
        if (_y == this._iTotalRowTiles - 1 && _x == this._iTotalColTiles - 1) {
            return 8;
        }
        return 4;
    }

    public void keyPressed(int keyCode) {
        if (this.interuption == 1) {
            this.interuption = 0;
            this.afterInteruption();
        }
    }

    public void keyReleased(int keyCode) {
        this.a = keyCode;
        if (this.activeButton) {
            if (Keys.isFKRightCode(keyCode)) {
                switch (this.actualSceen) {
                    case 0: {
                        this.startAnimation(true, 4);
                        this.selectedCompId = 0;
                        this.selectorCompId = 0;
                        break;
                    }
                    case 1: {
                        this.startAnimation(true, 0);
                        this.selectedCompId = 1;
                        this.selectorCompId = 1;
                        this.textOffsetY = 0;
                        break;
                    }
                    case 5: {
                        this.startAnimation(true, 0);
                        this.selectedCompId = 0;
                        this.selectorCompId = 0;
                        break;
                    }
                    case 2: {
                        this.startAnimation(true, 0);
                        this.selectorCompId = 3;
                        break;
                    }
                    case 4: {
                        this.startAnimation(true, 0);
                        this.selectorCompId = 0;
                    }
                }
            } else if (Keys.isFKLeftCode(keyCode)) {
                if (this.actualSceen == 4) {
                    X.quitApp();
                }
            } else {
                if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
                    switch (this.actualSceen) {
                        case 0: {
                            switch (this.selectedCompId) {
                                case 0: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 1;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.startAnimation(true, 3);
                                    break;
                                }
                                case 2: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.releasedTouch = true;
                                    if (MainCanvas.soundManager.IsSoundOn()) {
                                        MainCanvas.soundManager.SetSoundOn(false);
                                        MainCanvas.soundManager.Stop();
                                        break;
                                    }
                                    MainCanvas.soundManager.SetSoundOn(true);
                                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                                    break;
                                }
                                case 1: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.startAnimation(true, 1);
                                    break;
                                }
                                case 3: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 1;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.startAnimation(true, 2);
                                }
                            }
                            break;
                        }
                    }
                }
                this.selectorCompId = this.selectedCompId;
                this.a = this.selectedCompId;
                this.force = this.selectedCompId;
            }
            this.mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        this.posX = x;
        this.posY = y;
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (i == 9) {
                this.selectorCompId = this.selectedCompId = 9;
                this.mainCanvas.repaint();
                break;
            }
            if (i == 9 || this.rectItems[i] == null || !this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            this.s = i;
            System.out.println("selectedCompId: " + this.selectedCompId);
            switch (this.selectedCompId) {
                case 5: {
                    this.force = 5;
                    this.selectedCompId = 5;
                    i = 5;
                    this.selectorCompId = 5;
                    this.a = this.selectedCompId;
                    this.keyReleased(-5);
                    Keys.keyReleased(-5);
                    break;
                }
                case 8: {
                    this.selectorCompId = i;
                    this.a = this.selectedCompId;
                    Keys.keyReleased(-7);
                    break;
                }
                case 7: {
                    this.selectorCompId = i;
                    this.a = this.selectedCompId;
                    Keys.keyReleased(-6);
                    break;
                }
                default: {
                    this.selectorCompId = i;
                    this.a = this.selectedCompId;
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.actualSceen == 1) {
            System.out.println("SCROL");
            if (this.posY > y) {
                if (Resources.sysFont) {
                    this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                } else {
                    this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                }
                if (this.textOffsetY < 0) {
                    this.textOffsetY = 0;
                    this.scrollUP = false;
                    this.scrollDOWN = true;
                }
                this.needRepaint = true;
            } else if (this.posY < y) {
                int maxOffsetY = this._ptInstruction.getTextHeight() - this.rectText.height;
                if (Resources.sysFont) {
                    this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                } else {
                    this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                }
                if (this.textOffsetY > maxOffsetY) {
                    this.textOffsetY = maxOffsetY;
                    this.scrollUP = true;
                    this.scrollDOWN = false;
                }
                this.needRepaint = true;
            }
        }
        if (this.selectedCompId != 9) {
            if (!this.rectItems[this.selectedCompId].contains(x, y)) {
                switch (this.selectedCompId) {
                    case 4: {
                        break;
                    }
                    case 8: {
                        Keys.keyReleased(-7);
                        break;
                    }
                    case 7: {
                        Keys.keyReleased(-6);
                        break;
                    }
                    default: {
                        Keys.keyReleased(53);
                        break;
                    }
                }
            }
        } else {
            this.selectorCompId = this.selectedCompId = 9;
            this.mainCanvas.repaint();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.selectedCompId != 9) {
            System.out.println("tu som 0 : " + this.selectedCompId);
            switch (this.selectedCompId) {
                case 5: {
                    this.activeButton = true;
                    this.selectedCompId = this.force;
                    this.keyReleased(-5);
                    Keys.keyReleased(-5);
                    break;
                }
                case 4: {
                    if (this.actualSceen != 4) break;
                    X.quitApp();
                    break;
                }
                case 8: {
                    System.out.println("tu som 1");
                    this.activeButton = true;
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                    break;
                }
                case 7: {
                    System.out.println("tu som 2");
                    this.activeButton = true;
                    this.keyReleased(-6);
                    Keys.keyReleased(-6);
                    break;
                }
                default: {
                    this.activeButton = true;
                    if (!Keys.isKeyPressed(53)) break;
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
            }
        }
        this.selectorCompId = this.selectedCompId = 9;
        this.mainCanvas.repaint();
    }

    private void textMove() {
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY < 0) {
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
            this.needRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = this._ptInstruction.getTextHeight() - this.rectText.height;
            if (Resources.sysFont) {
                this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY > maxOffsetY) {
                this.textOffsetY = maxOffsetY;
                this.scrollUP = true;
                this.scrollDOWN = false;
            }
            this.needRepaint = true;
        }
    }
}

