/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.ResourceBundle;

public class Resources {
    private static String graphicsBaseDir = "/";
    private static String graphicsDisplayDir = "/";
    public static final int _IMG_INLOGIC_LOGO = 0;
    public static final int _IMG_RES_ROTATION = 1;
    public static final int _IMG_MENU_LOGO = 2;
    public static final int _IMG_MENU_BG = 3;
    public static final int _IMG_GAME_BG = 4;
    public static final int _IMG_GAME_OVER_BG = 5;
    public static final int _IMG_BUTTON = 6;
    public static final int _IMG_BUTTON_SELECTOR = 7;
    public static final int _IMG_INLOGIC_LOGO_WHITE = 8;
    public static final int TOTAL_IMGS = 9;
    public static Image[] resImgs = new Image[9];
    public static final int _SPR_LANGUAGE = 0;
    public static final int _SPR_WALL_HOR_1 = 1;
    public static final int _SPR_WALL_HOR_2 = 2;
    public static final int _SPR_WALL_VER_1 = 3;
    public static final int _SPR_WALL_VER_2 = 3;
    public static final int _SPR_WALL_VER_3 = 3;
    public static final int _SPR_WINDOW = 4;
    public static final int _SPR_ICON_PLAY = 7;
    public static final int _SPR_ICON_PLAY_SELECTOR = 8;
    public static final int _SPR_MENU_SELECTOR = 9;
    public static final int _SPR_ICONS_MENU = 11;
    public static final int _SPR_ICONS_FK = 12;
    public static final int _SPR_ARROWS = 13;
    public static final int _SPR_CHARACTER = 14;
    public static final int _SPR_SQUARE = 15;
    public static final int _SPR_ICONS_MENU_SELECTOR = 16;
    public static final int _SPR_ICONS_GAME_OVER_SELECTOR = 17;
    public static final int _SPR_CHARACTER_MEDUSA_1 = 18;
    public static final int _SPR_CHARACTER_MEDUSA_2 = 19;
    public static final int _SPR_CORAL_VERTICAL_1 = 20;
    public static final int _SPR_CORAL_VERTICAL_2 = 21;
    public static final int _SPR_CORAL_VERTICAL_3 = 22;
    public static final int _SPR_CORAL_HORIZONTAL_BLANK_1 = 23;
    public static final int _SPR_CORAL_HORIZONTAL_BLANK_2 = 24;
    public static final int _SPR_CORAL_HORIZONTAL_BLANK_3 = 25;
    public static final int _SPR_CORAL_HORIZONTAL_BLANK_4 = 29;
    public static final int _SPR_CORAL_HORIZONTAL_CORNER_1 = 26;
    public static final int _SPR_CORAL_HORIZONTAL_CORNER_2 = 27;
    public static final int _SPR_CORAL_HORIZONTAL_CORNER_3 = 28;
    public static final int _SPR_CORAL_HORIZONTAL_CORNER_4 = 30;
    public static final int TOTAL_SPRS = 31;
    public static Sprite[] resSprs = new Sprite[31];
    public static final int _GFONT_MAIN = 0;
    public static final int _GFONT_INSTURCTION = 1;
    public static final int _GFONT_GAME_OVER = 2;
    public static final int _GFONT_NUMBERS = 3;
    public static final int TOTAL_GFONTS = 4;
    public static GFont[] resGFonts = new GFont[4];
    public static final int TEXT_MAIN = 0;
    public static final int TOTAL_TEXTS = 85;
    private static String langDir = "/";
    public static ResourceBundle[] resTexts = new ResourceBundle[85];
    public static final int TEXT_MAIN_INSTRUCTIONS = 1;
    public static final int TEXT_REALY_QUIT = 2;
    public static final int TEXT_MAIN_ENABLE_MUSIC = 5;
    public static final int TEXT_MAIN_YES = 6;
    public static final int TEXT_MAIN_NO = 7;
    public static final int TEXT_LEVEL = 8;
    public static final int TEXT_COMPLETED = 9;
    public static final int TEXT_SCORE = 10;
    public static final int TEXT_TIMEISUP = 11;
    public static final int TEXT_NOMOREMOVES = 12;
    public static final int TEXT_GAMEOVER = 13;
    public static final int TEXT_CONTINUE = 14;
    public static final int TEXT_NEWRECORD = 15;
    public static final int TEXT_CONTROLS_NOTOUCH = 16;
    public static final int TEXT_CONTROLS_TOUCH_1 = 17;
    public static final int TEXT_MENU_ITEMS = 18;
    public static final int TEXT_MENU = 19;
    public static final int TEXT_BACK = 20;
    public static final int TEXT_NEW_GAME = 21;
    public static final int TEXT_INSTRUCT = 22;
    public static final int TEXT_ABOUT = 23;
    public static final int TEXT_CONT = 24;
    public static final int TEXT_RESTART = 25;
    public static final int TEXT_ON = 26;
    public static final int TEXT_OFF = 27;
    public static final int TEXT_SOUNDS = 28;
    public static final int TEXT_TUTORIAL_KEYBOARD = 29;
    public static final int TEXT_TUTORIAL_TOUCH = 30;
    public static final int TEXT_TUTORIAL_MOVES = 31;
    public static final int TEXT_TUTORIAL_BLOCKS = 32;
    public static final int TEXT_TUTORIAL_ESCAPE = 33;
    public static final int TEXT_TUTORIAL_DOWNFALL = 34;
    public static final int TEXT_TUTORIAL_TIME_ATTACK = 35;
    public static final int TEXT_GOALS_SCORE_GET = 36;
    public static final int TEXT_GOALS_SCORE_POINTS = 37;
    public static final int TEXT_GOALS_BLOCKS = 38;
    public static final int TEXT_GOALS_ESCAPE_POP = 39;
    public static final int TEXT_GOALS_ESCAPE_DIAMONDS = 40;
    public static final int TEXT_GOALS_DOWNFALL_BRING = 41;
    public static final int TEXT_GOALS_DOWNFALL_DIAMONDS = 42;
    public static final int TEXT_GOALS_MOVES_MAKE = 43;
    public static final int TEXT_GOALS_MOVES_TURNS = 44;
    public static final int TEXT_GOALS_TIME_ADD_WITHIN = 45;
    public static final int TEXT_GOALS_TIME_ADD_SECONDS = 46;
    public static final int TEXT_GOALS_TURNS_ADD_WITHIN = 47;
    public static final int TEXT_GOALS_TURNS_ADD_TURNS = 48;
    public static final int TEXT_RESULT_WELL_DONE = 49;
    public static final int TEXT_RESULT_GLAMOROUS = 50;
    public static final int TEXT_RESULT_SHINY = 51;
    public static final int TEXT_RESULT_GAME_OVER = 52;
    public static final int TEXT_CONTROLS_TOUCH_2 = 53;
    public static final int TEXT_CONTROLS_KEYS = 54;
    public static final int TEXT_RESULT_TITLE = 56;
    public static final int TEXT_RESULT_BOMB_LEFT = 57;
    public static final int TEXT_RESULT_DIAMOND = 58;
    public static final int TEXT_RESULT_RING = 59;
    public static final int TEXT_RESULT_TITLE_LOSE = 60;
    public static final int TEXT_RESULT_LOSE_OUT_OF_OPTIONS = 61;
    public static final int TEXT_RESULT_LOSE_BUBBLE_ESCAPED = 62;
    public static final int TEXT_RESULT_LOSE_OUT_OF_MOVES = 63;
    public static final int TEXT_RESULT_LOSE_OUT_OF_TIMES = 64;
    public static final int TEXT_RESULT_FAIL_POINTS = 65;
    public static final int TEXT_RESULT_FAIL_BLOCKS = 66;
    public static final int TEXT_RESULT_FAIL_RING = 67;
    public static final int TEXT_RESULT_FAIL_DIAMOND = 68;
    public static final int TEXT_RESULT_FAIL_MOVES = 69;
    public static final int TEXT_CLASSIC_PACK = 70;
    public static final int TEXT_BONUS_PACK = 71;
    public static final int TEXT_LAST_MESSAGE_FAIL = 72;
    public static final int TEXT_LAST_MESSAGE_OK = 73;
    public static final int TEXT_LAST_MESSAGE_SURPRISE = 74;
    public static final int TEXT_LAST_MESSAGE_BONUS_FAIL = 75;
    public static final int TEXT_LAST_MESSAGE_BONUS_OK = 76;
    public static final int TEXT_INGAME_REALY_QUIT = 77;
    public static final int TEXT_RESTART_QUESTIONS = 78;
    public static final int TEXT_CONTR_TITLE = 79;
    public static final int TEXT_START_KEYS = 80;
    public static final int TEXT_START_TOCH = 81;
    public static final int TEXT_EASY = 80;
    public static final int TEXT_MEDIUM = 81;
    public static final int TEXT_HARD = 82;
    public static final int TEXT_BEST = 83;
    public static boolean sysFont;
    public static int widht;

    public static void initGraphicsDirs(int width, int height) {
        System.out.println(widht + " : " + width);
        graphicsBaseDir = "/" + width + "x" + height + "/";
        graphicsDisplayDir = "/" + width + "x" + height + "/";
        if (width == 240) {
            if (height > 320) {
                graphicsBaseDir = "/240x400/";
                graphicsDisplayDir = "/240x400/";
            } else {
                graphicsBaseDir = "/240x320/";
                graphicsDisplayDir = "/240x320/";
            }
        }
    }

    public static Image createImage(String imgName) {
        Image image = null;
        try {
            Common.trace(imgName);
            image = Image.createImage((String)imgName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return image;
    }

    public static Sprite createSprite(Image image, int slicesX, int slicesY) {
        Sprite sprite = null;
        try {
            int sprWidth = image.getWidth() / slicesX;
            int sprHeight = image.getHeight() / slicesY;
            sprite = new Sprite(image, sprWidth, sprHeight);
        }
        catch (Exception e) {
            sprite = null;
        }
        return sprite;
    }

    public static void loadImage(int _iImgIdx) {
        String _sImgPath = null;
        switch (_iImgIdx) {
            case 0: {
                _sImgPath = graphicsBaseDir + "logo-inlogic.png";
                break;
            }
            case 8: {
                _sImgPath = graphicsBaseDir + "logo-inlogic-biele.png";
                break;
            }
            case 1: {
                _sImgPath = graphicsBaseDir + "rot.png";
                break;
            }
            case 2: {
                _sImgPath = graphicsBaseDir + "logo-tiny-medusa.png";
                break;
            }
            case 3: {
                _sImgPath = graphicsBaseDir + "pozadie-uvod.png";
                break;
            }
            case 4: {
                _sImgPath = graphicsBaseDir + "pozadie.png";
                break;
            }
            case 5: {
                _sImgPath = graphicsBaseDir + "game-over.png";
                break;
            }
            case 6: {
                _sImgPath = graphicsBaseDir + "button.png";
                break;
            }
            case 7: {
                _sImgPath = graphicsBaseDir + "button-a-selector.png";
            }
        }
        if (_sImgPath != null && resImgs[_iImgIdx] == null) {
            Resources.resImgs[_iImgIdx] = Resources.createImage(_sImgPath);
        }
    }

    public static void freeImage(int imgIdx) {
        Resources.resImgs[imgIdx] = null;
    }

    public static void loadImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.loadImage(imgsIdx[i]);
        }
    }

    public static void freeImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.resImgs[imgsIdx[i]] = null;
        }
    }

    public static void loadSprite(int _iSprIdx) {
        String _sSprPath = null;
        int _iSlicesX = 1;
        int _iSlicesY = 1;
        switch (_iSprIdx) {
            case 0: {
                _sSprPath = graphicsBaseDir + "language.png";
                _iSlicesX = 4;
                _iSlicesY = 3;
                break;
            }
            case 1: {
                _sSprPath = graphicsBaseDir + "mur-horiz.-1a3.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 2: {
                _sSprPath = graphicsBaseDir + "mur-horiz.-2.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 3: {
                _sSprPath = graphicsBaseDir + "mur-vertikal.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 4: {
                _sSprPath = graphicsBaseDir + "okno.png";
                _iSlicesX = 3;
                _iSlicesY = 3;
                break;
            }
            case 7: {
                _sSprPath = graphicsBaseDir + "play.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 8: {
                _sSprPath = graphicsBaseDir + "play-selector.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 11: {
                _sSprPath = graphicsBaseDir + "tlacidla-uvod.png";
                _iSlicesX = 4;
                _iSlicesY = 1;
                break;
            }
            case 12: {
                _sSprPath = graphicsBaseDir + "tlacidla.png";
                _iSlicesX = 8;
                _iSlicesY = 1;
                break;
            }
            case 13: {
                _sSprPath = graphicsBaseDir + "sipky-vyber.png";
                _iSlicesX = 1;
                _iSlicesY = 2;
                break;
            }
            case 18: {
                _sSprPath = graphicsBaseDir + "meduza-1.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 19: {
                _sSprPath = graphicsBaseDir + "meduza-2.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 14: {
                _sSprPath = graphicsBaseDir + "sipka.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 15: {
                _sSprPath = graphicsBaseDir + "stvorcek.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 16: {
                _sSprPath = graphicsBaseDir + "tlacidla-uvod-selector.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 17: {
                _sSprPath = graphicsBaseDir + "tlacidla-selector.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 9: {
                _sSprPath = graphicsBaseDir + "podciarknutie.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 20: {
                _sSprPath = graphicsBaseDir + "koral-1.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 21: {
                _sSprPath = graphicsBaseDir + "koral-2.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 22: {
                _sSprPath = graphicsBaseDir + "koral-3.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 23: {
                _sSprPath = graphicsBaseDir + "1...png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 24: {
                _sSprPath = graphicsBaseDir + "2...png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 25: {
                _sSprPath = graphicsBaseDir + "3...png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 29: {
                _sSprPath = graphicsBaseDir + "4...png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 26: {
                _sSprPath = graphicsBaseDir + "1.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 27: {
                _sSprPath = graphicsBaseDir + "2.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 28: {
                _sSprPath = graphicsBaseDir + "3.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 30: {
                _sSprPath = graphicsBaseDir + "4.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
            }
        }
        if (_sSprPath != null && resSprs[_iSprIdx] == null) {
            Resources.resSprs[_iSprIdx] = Resources.createSprite(Resources.createImage(_sSprPath), _iSlicesX, _iSlicesY);
        }
    }

    public static void freeSprite(int sprIdx) {
        Resources.resSprs[sprIdx] = null;
    }

    public static void loadSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.loadSprite(sprsIdx[i]);
        }
    }

    public static void freeSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.resSprs[sprsIdx[i]] = null;
        }
    }

    private static GFont createGFontMain(Image gFontImg) {
        char[] _fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c3', '\u00c1', '\u00c0', '\u00c2', '\u00c4', '\u00c7', '\u010c', '\u010e', '\u00ca', '\u00cb', '\u00c9', '\u00c8', '\u00cf', '\u00cd', '\u00cc', '\u013d', '\u00d1', '\u0147', '\u00d4', '\u00d5', '\u00d6', '\u00d3', '\u00d2', '\u00dc', '\u00da', '\u00d9', '\u0158', '\u0160', '\u015a', '\u0164', '\u00dd', '\u017d', '$', '#', '*', '@', '\\', '[', '(', '{', '}', ')', ']', '|', '\u2014', '\u00f7', '%', '<', '>', '+', '-', '=', ';', ',', '.', ':', '\"', '\'', '!', '?', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0110', '\u2044', '\u00a1', '\u00bf'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 1;
        switch (gFontImg.getHeight()) {
            case 16: {
                fontCharsWidth = new short[]{5, 6, 5, 5, 5, 4, 6, 5, 3, 5, 6, 5, 6, 5, 5, 5, 6, 6, 6, 6, 5, 5, 7, 8, 6, 5, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 4, 5, 5, 5, 6, 6, 5, 6, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 5, 5, 7, 7, 5, 7, 7, 6, 5, 6, 5, 4, 5, 3, 18, 6, 8, 7, 6, 5, 5, 8, 4, 4, 4, 3, 5, 4, 4, 6, 6, 5, 6, 5, 5, 6, 5, 6, 6, 5, 6, 8, 3, 5, 0};
                break;
            }
            case 21: {
                fontCharsWidth = new short[]{6, 6, 7, 6, 5, 5, 7, 6, 4, 6, 6, 5, 6, 6, 6, 6, 7, 6, 7, 6, 5, 6, 8, 9, 7, 6, 7, 7, 7, 7, 7, 7, 7, 7, 5, 5, 6, 5, 4, 5, 5, 6, 7, 6, 6, 7, 6, 6, 6, 6, 6, 6, 6, 7, 7, 6, 6, 7, 8, 8, 6, 8, 8, 7, 5, 6, 6, 5, 7, 3, 22, 7, 10, 7, 6, 7, 6, 9, 4, 4, 3, 3, 4, 4, 4, 6, 7, 6, 7, 6, 6, 8, 7, 7, 7, 6, 7, 11, 4, 6, 0};
                break;
            }
            case 26: {
                fontCharsWidth = new short[]{6, 7, 7, 7, 5, 6, 7, 6, 3, 6, 8, 6, 8, 7, 7, 6, 8, 7, 7, 7, 7, 6, 10, 10, 8, 7, 8, 8, 8, 8, 8, 8, 8, 7, 6, 6, 6, 6, 4, 5, 5, 6, 8, 7, 6, 8, 7, 6, 6, 7, 7, 6, 7, 8, 8, 8, 8, 8, 9, 10, 6, 9, 10, 8, 6, 6, 7, 5, 7, 3, 27, 7, 11, 8, 8, 8, 6, 11, 3, 4, 3, 3, 6, 4, 5, 8, 8, 6, 8, 7, 7, 8, 7, 9, 7, 7, 8, 12, 4, 6, 0};
                break;
            }
            case 35: {
                fontCharsWidth = new short[]{9, 8, 10, 8, 7, 7, 8, 8, 3, 7, 9, 7, 9, 8, 7, 8, 10, 8, 9, 10, 8, 8, 12, 12, 10, 9, 10, 9, 9, 10, 9, 10, 9, 9, 7, 7, 7, 7, 5, 6, 6, 7, 9, 9, 7, 10, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 10, 8, 11, 13, 7, 12, 11, 10, 7, 8, 8, 6, 8, 4, 36, 9, 14, 10, 10, 10, 8, 14, 4, 4, 4, 3, 6, 5, 5, 9, 10, 7, 10, 8, 8, 10, 9, 10, 9, 9, 9, 16, 4, 8, 0};
                break;
            }
            case 50: {
                fontCharsWidth = new short[]{12, 10, 12, 10, 8, 8, 11, 10, 4, 9, 12, 10, 11, 12, 9, 10, 12, 10, 12, 13, 10, 10, 16, 17, 12, 11, 13, 13, 13, 12, 13, 12, 12, 12, 8, 8, 9, 8, 6, 8, 8, 10, 12, 11, 9, 13, 9, 10, 9, 10, 10, 10, 11, 12, 12, 12, 12, 11, 14, 18, 9, 15, 15, 13, 9, 10, 10, 8, 10, 4, 49, 13, 18, 13, 12, 13, 10, 20, 5, 5, 4, 4, 7, 5, 5, 11, 12, 9, 12, 11, 10, 12, 12, 14, 11, 12, 13, 21, 5, 10, 0};
                break;
            }
            case 59: {
                fontCharsWidth = new short[]{14, 11, 15, 11, 9, 9, 13, 11, 4, 9, 14, 11, 13, 13, 10, 11, 15, 12, 14, 14, 12, 12, 18, 19, 14, 13, 14, 14, 14, 14, 14, 14, 14, 14, 10, 9, 10, 9, 7, 8, 9, 11, 14, 12, 11, 14, 10, 10, 10, 12, 11, 11, 12, 14, 13, 14, 14, 13, 16, 20, 11, 17, 18, 16, 10, 12, 11, 8, 12, 4, 59, 15, 22, 15, 16, 14, 11, 22, 4, 6, 4, 4, 8, 10, 12, 14, 10, 14, 13, 12, 15, 13, 15, 13, 13, 13, 25, 6, 12, 0};
                break;
            }
            case 68: {
                fontCharsWidth = new short[]{15, 13, 15, 13, 11, 10, 14, 12, 4, 11, 16, 12, 14, 15, 11, 12, 16, 13, 16, 16, 13, 12, 19, 22, 16, 15, 16, 17, 15, 16, 16, 16, 16, 15, 10, 10, 11, 11, 8, 10, 10, 12, 16, 15, 11, 16, 11, 12, 10, 14, 12, 12, 13, 15, 15, 16, 16, 16, 18, 23, 12, 21, 20, 18, 12, 13, 13, 10, 13, 5, 67, 16, 25, 17, 16, 16, 12, 25, 5, 5, 4, 4, 9, 6, 6, 14, 16, 11, 17, 14, 12, 16, 15, 17, 15, 15, 16, 28, 6, 13, 0};
                break;
            }
            case 80: {
                fontCharsWidth = new short[]{18, 15, 18, 14, 12, 11, 17, 14, 5, 12, 18, 13, 17, 17, 12, 14, 19, 15, 17, 19, 14, 14, 23, 26, 18, 17, 19, 18, 18, 18, 18, 19, 18, 17, 12, 11, 13, 12, 9, 11, 12, 14, 19, 17, 12, 19, 13, 13, 12, 15, 15, 14, 15, 18, 18, 19, 18, 17, 22, 27, 13, 23, 23, 20, 13, 14, 15, 11, 16, 5, 78, 19, 29, 20, 19, 19, 14, 29, 5, 6, 5, 4, 10, 7, 7, 16, 18, 13, 19, 16, 14, 19, 17, 19, 17, 17, 18, 34, 7, 15, 0};
                break;
            }
            case 113: {
                fontCharsWidth = new short[]{24, 20, 24, 20, 15, 15, 22, 19, 6, 16, 24, 19, 23, 22, 17, 19, 25, 20, 23, 25, 20, 19, 32, 36, 24, 23, 25, 25, 26, 24, 25, 24, 24, 23, 16, 16, 18, 16, 12, 16, 15, 19, 25, 22, 17, 25, 17, 18, 17, 20, 20, 20, 20, 23, 24, 25, 24, 23, 29, 37, 18, 32, 32, 28, 18, 20, 21, 14, 22, 5, 109, 26, 40, 26, 25, 26, 18, 40, 7, 13, 5, 13, 8, 9, 22, 25, 17, 26, 22, 20, 26, 23, 28, 23, 24, 24, 46, 9, 21, 0};
                break;
            }
            case 125: {
                fontCharsWidth = new short[]{27, 22, 27, 22, 17, 17, 24, 21, 6, 18, 26, 20, 26, 25, 19, 21, 28, 22, 26, 27, 21, 21, 35, 38, 28, 26, 28, 28, 28, 28, 27, 27, 27, 25, 17, 17, 19, 17, 12, 17, 17, 21, 28, 25, 19, 27, 19, 20, 19, 21, 22, 22, 22, 26, 26, 27, 27, 25, 32, 41, 20, 36, 37, 30, 19, 22, 22, 16, 23, 6, 121, 29, 43, 29, 28, 28, 20, 45, 8, 9, 5, 5, 15, 8, 9, 25, 28, 18, 28, 24, 22, 29, 26, 30, 25, 26, 26, 51, 9, 24, 0};
                break;
            }
            default: {
                fontCharsWidth = new short[]{14, 12, 14, 13, 11, 11, 14, 13, 3, 10, 13, 11, 16, 13, 15, 12, 15, 12, 12, 14, 13, 15, 23, 14, 14, 12, 15, 15, 15, 15, 15, 14, 14, 13, 11, 11, 11, 11, 6, 4, 4, 11, 13, 13, 15, 15, 15, 15, 15, 13, 13, 13, 12, 12, 12, 14, 14, 12, 12, 14, 6, 17, 12, 4, 5, 5, 5, 5, 4, 2, 18, 10, 15, 10, 10, 8, 8, 8, 3, 3, 3, 3, 5, 3, 3, 9, 14, 13, 3, 9, 12, 9, 10, 10, 12, 11, 12, 11, 12, 11, 0};
            }
        }
        return new GFont(gFontImg, _fontChars, fontCharsWidth, spaceBetweenChars, fontCharsWidth[0]);
    }

    private static GFont createGFontGameScore(Image gFontImg) {
        char[] fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c3', '\u00c1', '\u00c0', '\u00c2', '\u00c4', '\u00c7', '\u010c', '\u010e', '\u00ca', '\u00cb', '\u00c9', '\u00c8', '\u00cf', '\u00cd', '\u00cc', '\u013d', '\u00d1', '\u0147', '\u00d4', '\u00d5', '\u00d6', '\u00d3', '\u00d2', '\u00dc', '\u00da', '\u00d9', '\u0158', '\u0160', '\u015a', '\u0164', '\u00dd', '\u017d', '$', '#', '*', '@', '\\', '[', '(', '{', '}', ')', ']', '|', '\u2014', '\u00f7', '%', '<', '>', '+', '-', '=', ';', ',', '.', ':', '\"', '\'', '!', '?', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0110', '\u2044', '\u00a1', '\u00bf'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 13: {
                fontCharsWidth = new short[]{10, 8, 11, 9, 7, 7, 9, 9, 4, 8, 10, 8, 10, 9, 8, 8, 11, 9, 10, 10, 9, 9, 13, 14, 11, 9, 10, 10, 10, 11, 10, 11, 11, 10, 7, 7, 7, 7, 5, 7, 7, 8, 11, 10, 8, 10, 8, 8, 8, 9, 8, 9, 9, 10, 10, 10, 10, 9, 12, 14, 8, 13, 13, 12, 8, 8, 9, 7, 9, 4, 40, 10, 16, 11, 10, 10, 8, 16, 4, 5, 3, 3, 7, 5, 5, 9, 10, 7, 10, 9, 8, 10, 10, 11, 10, 10, 10, 18, 5, 9, 0};
                break;
            }
            case 20: {
                fontCharsWidth = new short[]{6, 6, 7, 6, 5, 4, 6, 5, 3, 5, 7, 5, 7, 6, 5, 6, 7, 6, 6, 6, 6, 6, 8, 8, 7, 6, 7, 7, 7, 7, 7, 7, 7, 6, 5, 4, 5, 5, 4, 5, 5, 6, 7, 6, 5, 6, 5, 6, 5, 6, 5, 6, 6, 7, 7, 7, 6, 6, 8, 9, 5, 8, 8, 7, 6, 6, 6, 5, 6, 3, 21, 6, 10, 7, 7, 6, 6, 9, 4, 3, 3, 4, 4, 3, 4, 6, 7, 5, 7, 6, 6, 7, 7, 7, 6, 6, 6, 11, 4, 6, 0};
                break;
            }
            case 33: {
                fontCharsWidth = new short[]{8, 8, 9, 7, 6, 6, 8, 7, 4, 6, 9, 7, 9, 9, 7, 7, 9, 7, 9, 9, 8, 8, 11, 12, 9, 9, 9, 9, 9, 9, 10, 9, 9, 8, 7, 6, 7, 6, 6, 5, 6, 7, 10, 9, 7, 9, 7, 7, 7, 8, 7, 8, 7, 9, 9, 9, 9, 8, 11, 12, 7, 12, 11, 9, 7, 8, 8, 6, 8, 3, 34, 10, 13, 10, 9, 9, 7, 13, 4, 4, 3, 4, 5, 4, 4, 8, 9, 7, 10, 9, 7, 9, 9, 9, 9, 9, 9, 15, 5, 8, 0};
                break;
            }
            case 53: {
                fontCharsWidth = new short[]{13, 10, 13, 11, 9, 9, 13, 9, 4, 9, 12, 10, 13, 12, 10, 10, 13, 10, 12, 13, 11, 10, 16, 18, 13, 11, 13, 13, 13, 13, 13, 13, 13, 12, 9, 9, 9, 8, 6, 8, 8, 10, 13, 12, 9, 13, 9, 9, 10, 10, 11, 10, 11, 12, 13, 13, 13, 12, 15, 18, 10, 16, 16, 14, 9, 10, 11, 8, 11, 3, 52, 13, 20, 13, 13, 13, 10, 20, 5, 8, 4, 8, 5, 5, 12, 13, 9, 13, 12, 11, 14, 13, 14, 12, 12, 13, 23, 5, 11, 0};
                break;
            }
            case 90: {
                fontCharsWidth = new short[]{20, 16, 20, 17, 13, 13, 18, 16, 5, 14, 20, 15, 19, 18, 15, 15, 21, 16, 19, 20, 16, 16, 26, 29, 20, 19, 21, 20, 20, 21, 20, 20, 20, 19, 13, 13, 14, 13, 10, 12, 13, 15, 20, 18, 14, 21, 14, 15, 14, 16, 16, 16, 17, 20, 20, 20, 20, 18, 25, 29, 15, 26, 26, 23, 14, 17, 16, 12, 17, 5, 88, 21, 32, 21, 21, 21, 15, 33, 6, 6, 5, 5, 11, 7, 7, 18, 21, 14, 21, 19, 16, 21, 19, 23, 19, 20, 20, 37, 7, 18, 0};
                break;
            }
            case 100: {
                fontCharsWidth = new short[]{14, 11, 15, 11, 9, 9, 13, 11, 4, 9, 14, 11, 13, 13, 10, 11, 15, 12, 14, 14, 12, 12, 18, 19, 14, 13, 14, 14, 14, 14, 14, 14, 14, 14, 10, 9, 10, 9, 7, 8, 9, 11, 14, 12, 11, 14, 10, 10, 10, 12, 11, 11, 12, 14, 13, 14, 14, 13, 16, 20, 11, 17, 18, 16, 10, 12, 11, 8, 12, 4, 59, 15, 22, 15, 16, 14, 11, 22, 4, 6, 4, 4, 8, 10, 12, 14, 10, 14, 13, 12, 15, 13, 15, 13, 13, 13, 25, 6, 12, 0};
                break;
            }
            case 125: {
                fontCharsWidth = new short[]{27, 22, 27, 22, 17, 17, 24, 21, 6, 18, 26, 20, 26, 25, 19, 21, 28, 22, 26, 27, 21, 21, 35, 38, 28, 26, 28, 28, 28, 28, 27, 27, 27, 25, 17, 17, 19, 17, 12, 17, 17, 21, 28, 25, 19, 27, 19, 20, 19, 21, 22, 22, 22, 26, 26, 27, 27, 25, 32, 41, 20, 36, 37, 30, 19, 22, 22, 16, 23, 6, 121, 29, 43, 29, 28, 28, 20, 45, 8, 9, 5, 5, 15, 8, 9, 25, 28, 18, 28, 24, 22, 29, 26, 30, 25, 26, 26, 51, 9, 24, 0};
                break;
            }
            case 180: {
                fontCharsWidth = new short[]{38, 31, 39, 31, 23, 23, 33, 29, 8, 24, 38, 28, 36, 35, 27, 29, 40, 31, 37, 39, 30, 30, 48, 55, 38, 36, 39, 39, 39, 39, 38, 38, 38, 35, 24, 24, 26, 24, 18, 23, 24, 29, 39, 35, 27, 39, 26, 27, 26, 30, 30, 30, 31, 37, 37, 39, 38, 35, 46, 58, 28, 50, 51, 43, 27, 30, 31, 22, 32, 8, 174, 40, 62, 42, 39, 40, 28, 63, 11, 11, 8, 8, 20, 11, 12, 34, 39, 26, 39, 34, 30, 41, 37, 42, 35, 36, 38, 73, 12, 33, 0};
                break;
            }
            case 213: {
                fontCharsWidth = new short[]{45, 36, 45, 37, 27, 27, 39, 34, 9, 29, 43, 33, 42, 41, 30, 33, 47, 36, 43, 46, 35, 35, 57, 64, 44, 42, 46, 45, 45, 45, 45, 45, 45, 41, 28, 28, 31, 28, 21, 27, 27, 33, 46, 41, 31, 46, 30, 32, 31, 36, 36, 35, 36, 44, 43, 45, 44, 42, 53, 68, 32, 60, 59, 50, 31, 36, 37, 25, 38, 9, 205, 47, 72, 49, 45, 47, 33, 75, 12, 12, 8, 9, 23, 13, 14, 40, 46, 30, 46, 40, 35, 47, 43, 50, 41, 43, 44, 86, 14, 39, 0};
                break;
            }
            default: {
                fontCharsWidth = new short[]{10, 8, 11, 9, 7, 7, 9, 9, 4, 8, 10, 8, 10, 9, 8, 8, 11, 9, 10, 10, 9, 9, 13, 14, 11, 9, 10, 10, 10, 11, 10, 11, 11, 10, 7, 7, 7, 7, 5, 7, 7, 8, 11, 10, 8, 10, 8, 8, 8, 9, 8, 9, 9, 10, 10, 10, 10, 9, 12, 14, 8, 13, 13, 12, 8, 8, 9, 7, 9, 4, 40, 10, 16, 11, 10, 10, 8, 16, 4, 5, 3, 3, 7, 5, 5, 9, 10, 7, 10, 9, 8, 10, 10, 11, 10, 10, 10, 18, 5, 9, 0};
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, fontCharsWidth[0]);
    }

    private static GFont createGFontGameOver(Image gFontImg) {
        char[] _fontChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'S'};
        short[] _fontCharsWidth = null;
        int _spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 8: {
                _fontCharsWidth = new short[]{4, 6, 5, 5, 6, 4, 5, 5, 5, 5, 4, 0};
                break;
            }
            case 10: {
                _fontCharsWidth = new short[]{6, 7, 6, 7, 8, 6, 7, 7, 7, 7, 6, 0};
                break;
            }
            case 13: {
                _fontCharsWidth = new short[]{9, 9, 8, 8, 9, 8, 8, 8, 8, 8, 9, 0};
                break;
            }
            case 20: {
                _fontCharsWidth = new short[]{12, 14, 12, 12, 15, 12, 12, 12, 11, 12, 12, 0};
                break;
            }
            case 22: {
                _fontCharsWidth = new short[]{13, 14, 13, 12, 15, 13, 12, 13, 12, 13, 13, 0};
                break;
            }
            case 26: {
                _fontCharsWidth = new short[]{7, 6, 8, 7, 7, 8, 8, 8, 8, 8, 6, 0};
                break;
            }
            case 31: {
                _fontCharsWidth = new short[]{19, 20, 18, 18, 22, 18, 18, 18, 18, 18, 17, 0};
                break;
            }
            case 36: {
                _fontCharsWidth = new short[]{9, 7, 10, 9, 8, 10, 10, 10, 9, 9, 9, 0};
                break;
            }
            case 59: {
                _fontCharsWidth = new short[]{14, 10, 14, 13, 11, 14, 14, 15, 13, 13, 13, 0};
                break;
            }
            default: {
                _fontCharsWidth = new short[]{9, 9, 8, 8, 9, 8, 8, 8, 8, 8, 9, 0};
            }
        }
        return new GFont(gFontImg, _fontChars, _fontCharsWidth, _spaceBetweenChars, _fontCharsWidth[0]);
    }

    private static GFont createGFontNumbers(Image gFontImg) {
        char[] _fontChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'S'};
        short[] _fontCharsWidth = null;
        int _spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 72: {
                _fontCharsWidth = new short[]{16, 12, 17, 15, 13, 17, 15, 18, 15, 16, 15, 0};
                break;
            }
            case 8: {
                _fontCharsWidth = new short[]{4, 6, 5, 5, 6, 4, 5, 5, 5, 5, 4, 0};
                break;
            }
            case 10: {
                _fontCharsWidth = new short[]{6, 7, 6, 7, 8, 6, 7, 7, 7, 7, 6, 0};
                break;
            }
            case 13: {
                _fontCharsWidth = new short[]{9, 9, 8, 8, 9, 8, 8, 8, 8, 8, 9, 0};
                break;
            }
            case 20: {
                _fontCharsWidth = new short[]{12, 14, 12, 12, 15, 12, 12, 12, 11, 12, 12, 0};
                break;
            }
            case 22: {
                _fontCharsWidth = new short[]{13, 14, 13, 12, 15, 13, 12, 13, 12, 13, 13, 0};
                break;
            }
            case 26: {
                _fontCharsWidth = new short[]{7, 6, 8, 7, 7, 8, 8, 8, 8, 8, 6, 0};
                break;
            }
            case 31: {
                _fontCharsWidth = new short[]{19, 20, 18, 18, 22, 18, 18, 18, 18, 18, 17, 0};
                break;
            }
            case 36: {
                _fontCharsWidth = new short[]{9, 7, 10, 9, 8, 10, 10, 10, 9, 9, 9, 0};
                break;
            }
            case 59: {
                _fontCharsWidth = new short[]{14, 10, 14, 13, 11, 14, 14, 15, 13, 13, 13, 0};
                break;
            }
            case 92: {
                _fontCharsWidth = new short[]{20, 14, 21, 19, 17, 22, 19, 22, 20, 19, 20, 0};
                break;
            }
            case 108: {
                _fontCharsWidth = new short[]{23, 17, 24, 21, 19, 25, 22, 27, 22, 22, 22, 0};
                break;
            }
            case 120: {
                _fontCharsWidth = new short[]{26, 18, 27, 24, 21, 27, 24, 29, 24, 25, 25, 0};
                break;
            }
            case 180: {
                _fontCharsWidth = new short[]{38, 26, 39, 34, 29, 40, 36, 42, 35, 36, 36, 0};
                break;
            }
            case 200: {
                _fontCharsWidth = new short[]{42, 28, 43, 37, 34, 43, 40, 47, 38, 40, 40, 0};
                break;
            }
            default: {
                _fontCharsWidth = new short[]{9, 7, 10, 9, 8, 10, 10, 10, 9, 9, 9, 0};
            }
        }
        return new GFont(gFontImg, _fontChars, _fontCharsWidth, _spaceBetweenChars, _fontCharsWidth[0]);
    }

    public static void loadGFont(int gFontIdx) {
        Image gFontImg = null;
        if (resGFonts[gFontIdx] != null) {
            return;
        }
        switch (gFontIdx) {
            case 0: {
                gFontImg = Resources.createImage(graphicsBaseDir + "uvod-a-score-font.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMain(gFontImg);
                break;
            }
            case 1: {
                gFontImg = Resources.createImage(graphicsBaseDir + "game-over-font.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontGameScore(gFontImg);
                break;
            }
            case 2: {
                gFontImg = Resources.createImage(graphicsBaseDir + "game-over-font.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontGameOver(gFontImg);
                break;
            }
            case 3: {
                gFontImg = Resources.createImage(graphicsBaseDir + "level-cisla.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontNumbers(gFontImg);
            }
        }
    }

    public static void freeGFont(int gFontIdx) {
        Resources.resGFonts[gFontIdx] = null;
    }

    public static void loadGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.loadGFont(gFontsIdx[i]);
        }
    }

    public static void freeGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.resGFonts[gFontsIdx[i]] = null;
        }
    }

    public static void initLangDirs(String langCode) {
        if (langCode.equals("fr")) {
            MainCanvas.languageFR = true;
        }
        langDir = "/lang/" + langCode + "/";
        if (langCode == "ru" || langCode == "cn") {
            sysFont = true;
        }
    }

    public static void loadText(int textIdx) {
        String textPath = null;
        switch (textIdx) {
            case 0: {
                textPath = langDir + "m.csr";
            }
        }
        Resources.resTexts[textIdx] = new ResourceBundle(X.singleton, textPath);
    }

    public static void freeText(int textIdx) {
        Resources.resTexts[textIdx] = null;
    }

    static {
        widht = 0;
    }
}

