/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    private MainCanvas mainCanvas;
    private int status;
    private int interuption = 0;
    private static final int STATUS_GAME = 0;
    private static final int STATUS_INGAMEMENU = 1;
    private static final int STATUS_RESULTDIALOG = 2;
    private static final int STATUS_INSTRUCTIONS = 3;
    private static final int STATUS_TUTORIAL = 4;
    private static final int STATUS_RESTARTSCREEN = 5;
    private static final int STATUS_REALY_QUIT = 6;
    private static final int STATUS_MAIN_MENU = 7;
    private static final int COMP_ID_HINT = 0;
    private static final int COMP_ID_MENU = 1;
    private static final int COMP_ID_RESUME = 2;
    private static final int COMP_ID_RESTART = 3;
    private static final int COMP_ID_SOUNDS = 4;
    private static final int COMP_ID_MAINMENU = 5;
    private static final int COMP_ID_INSTRUCTION = 6;
    private static final int TOTAL_COMP_IDS = 9;
    private static final int COMP_ID_RESTART_TXT = 0;
    private static final int COMP_ID_SOUNDS_TXT = 1;
    private static final int COMP_ID_MAINMENU_TXT = 2;
    private static final int COMP_ID_INSTRUCTION_TXT = 3;
    private static final int TOTAL_COMP_IDS_TXT = 9;
    private int[][] _animationSequence = new int[7][11];
    private AnimationComponent[] _animationComponents = new AnimationComponent[19];
    private Rectangle[] _rectItems_TXT = new Rectangle[9];
    private Rectangle[] rectItems = new Rectangle[9];
    private Rectangle rectGameArea;
    private Rectangle rectPanel;
    private Rectangle rectText;
    private Rectangle rectScore;
    private Rectangle rectBestScore;
    private Rectangle rectBB_BACK;
    private Rectangle rectBB_MENU;
    private Rectangle rectPlay;
    private Rectangle rectLeftFk;
    private Rectangle rectRightFk;
    private Rectangle _rectDialog;
    private Rectangle _rectTopBig;
    private int selectedCompId;
    private static PreparedText _ptMenuItem;
    private static PreparedText _ptInstruction;
    private static PreparedText _ptActualScore;
    private static PreparedText bestScore;
    private static PreparedText navigationKeysBB;
    private int textOffsetY;
    private boolean needRepaint;
    private boolean scrollUP = false;
    private boolean scrollDOWN = true;
    private Image _imgGameLogo;
    private Image _imgMenuBg;
    private Image _imgGameOver;
    private Image _imgButton;
    private Image _imgButtonSelector;
    private Sprite _sprArrows;
    private Sprite _sprIconsFk;
    private Sprite _sprWindow;
    private static int _WIDTH;
    private static int _HEIGHT;
    int _iMode = 0;
    private static final int NORMAL = 0;
    private static final int HARD = 1;
    private static final int EASY = 2;
    private int _iTotalRowTiles = 0;
    private int _iTotalColTiles = 0;
    private int _iOffsetX;
    private int _iFinalHeight;
    int bestScoreSave = 0;
    private int scoresCount = 0;
    int _finalHeight;
    int _off;
    int cycle = 10;
    private int _sequenceStop = 0;
    private int _sequenceShow = 1;
    private int _sequenceHide = 2;
    private int _sequence = 0;
    boolean changeSequence = false;
    private int nextScreen;
    boolean _bBkickUpdate = true;
    int lvl = 0;
    int checkButton = 2;
    int checkButton2 = 2;
    int posX = 0;
    int posY = 0;

    public ScreenGame(MainCanvas mainCanvas, int mode) {
        this.mainCanvas = mainCanvas;
        this._iMode = 0;
        this.initDimensions();
        this.status = 0;
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.prepareTxt();
        RMSObjects.game.restartGame(this.rectGameArea, this._iMode);
        this._bBkickUpdate = false;
    }

    public void afterHide() {
        this.freeGraphics();
        this.freeResources();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{4, 5, 2, 6, 7});
        Resources.loadSprites(new int[]{13, 14, 18, 19, 17, 12, 9, 23, 24, 25, 29, 26, 27, 28, 30, 20, 21, 22, 4});
        Resources.loadGFonts(new int[]{0, 2, 1, 3});
    }

    private void freeResources() {
        Resources.freeImages(new int[]{4, 5, 2, 6, 7});
        Resources.loadSprites(new int[]{13, 14, 18, 19, 17, 12, 23, 24, 25, 29, 26, 27, 28, 30, 20, 21, 22, 4});
        Resources.freeGFonts(new int[]{0, 2, 1, 3});
    }

    private void initDimensions() {
        _WIDTH = this.mainCanvas.getWidth();
        _HEIGHT = this.mainCanvas.getHeight();
    }

    private void initImages() {
        this._imgGameLogo = Resources.resImgs[2];
        this._imgMenuBg = Resources.resImgs[4];
        this._imgGameOver = Resources.resImgs[5];
        this._imgButton = Resources.resImgs[6];
        this._imgButtonSelector = Resources.resImgs[7];
    }

    private void initSprites() {
        this._sprArrows = Resources.resSprs[13];
        this._sprIconsFk = Resources.resSprs[12];
        this._sprWindow = Resources.resSprs[4];
    }

    public void initTxt() {
        Resources.loadText(0);
        _ptMenuItem = new PreparedText(Resources.resGFonts[0]);
        _ptInstruction = new PreparedText(Resources.resGFonts[0]);
        _ptMenuItem = new PreparedText(Resources.resGFonts[0]);
        _ptActualScore = new PreparedText(Resources.resGFonts[3]);
        bestScore = new PreparedText(Resources.resGFonts[0]);
        navigationKeysBB = new PreparedText(Resources.resGFonts[1]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 9;
        this._animationSequence[0][1] = 7;
        this._animationSequence[0][2] = 12;
        this._animationSequence[0][3] = -1;
        this._animationSequence[0][4] = -1;
        this._animationSequence[0][5] = -1;
        this._animationSequence[0][6] = -1;
        this._animationSequence[0][7] = -1;
        this._animationSequence[0][8] = -1;
        this._animationSequence[0][9] = -1;
        this._animationSequence[0][10] = -1;
        this._animationSequence[1][0] = 0;
        this._animationSequence[1][1] = 1;
        this._animationSequence[1][2] = 2;
        this._animationSequence[1][3] = 3;
        this._animationSequence[1][4] = 4;
        this._animationSequence[1][5] = 6;
        this._animationSequence[1][6] = 12;
        this._animationSequence[1][7] = 10;
        this._animationSequence[1][8] = -1;
        this._animationSequence[1][9] = -1;
        this._animationSequence[1][10] = -1;
        this._animationSequence[3][0] = 10;
        this._animationSequence[3][1] = 12;
        this._animationSequence[3][2] = 17;
        this._animationSequence[3][3] = 9;
        this._animationSequence[3][4] = 5;
        this._animationSequence[3][5] = 13;
        this._animationSequence[3][6] = -1;
        this._animationSequence[3][7] = -1;
        this._animationSequence[3][8] = -1;
        this._animationSequence[3][9] = -1;
        this._animationSequence[3][10] = -1;
        this._animationSequence[6][0] = 8;
        this._animationSequence[6][1] = 9;
        this._animationSequence[6][2] = 16;
        this._animationSequence[6][3] = 17;
        this._animationSequence[6][4] = 5;
        this._animationSequence[6][5] = 13;
        this._animationSequence[6][6] = 11;
        this._animationSequence[6][7] = 12;
        this._animationSequence[6][8] = -1;
        this._animationSequence[6][9] = -1;
        this._animationSequence[6][10] = -1;
        this._animationSequence[5][0] = 8;
        this._animationSequence[5][1] = 9;
        this._animationSequence[5][2] = 16;
        this._animationSequence[5][3] = 17;
        this._animationSequence[5][4] = 5;
        this._animationSequence[5][5] = 13;
        this._animationSequence[5][6] = 12;
        this._animationSequence[5][7] = 11;
        this._animationSequence[5][8] = -1;
        this._animationSequence[5][9] = -1;
        this._animationSequence[5][10] = -1;
        this._animationSequence[2][0] = 8;
        this._animationSequence[2][1] = 9;
        this._animationSequence[2][2] = 16;
        this._animationSequence[2][3] = 17;
        this._animationSequence[2][4] = 5;
        this._animationSequence[2][5] = 11;
        this._animationSequence[2][6] = 12;
        this._animationSequence[2][7] = -1;
        this._animationSequence[2][8] = -1;
        this._animationSequence[2][9] = -1;
        this._animationSequence[2][10] = -1;
        this._animationSequence[4][0] = 10;
        this._animationSequence[4][1] = 11;
        this._animationSequence[4][2] = 8;
        this._animationSequence[4][3] = -1;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
        this._animationSequence[4][6] = -1;
        this._animationSequence[4][7] = -1;
        this._animationSequence[4][8] = -1;
        this._animationSequence[4][9] = -1;
        this._animationSequence[4][10] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this.rectItems[3], _WIDTH, _HEIGHT);
        this._animationComponents[0].startShowAnimation(0);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectItems[4], _WIDTH, _HEIGHT);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectItems[6], _WIDTH, _HEIGHT);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectItems[5], _WIDTH, _HEIGHT);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this.rectPanel, _WIDTH, _HEIGHT);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this.rectText, _WIDTH, _HEIGHT);
        this._animationComponents[5].startShowAnimation(3);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, new Rectangle(0, 0, 0, 0), _WIDTH, _HEIGHT);
        this._animationComponents[6].startShowAnimation(2);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this.rectScore, _WIDTH, _HEIGHT);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this.rectBestScore, _WIDTH, _HEIGHT);
        this._animationComponents[8].startShowAnimation(0);
        this._animationComponents[9] = new AnimationComponent(this.mainCanvas, this.rectGameArea, _WIDTH, _HEIGHT);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10] = new AnimationComponent(this.mainCanvas, this._rectTopBig, _WIDTH, _HEIGHT);
        this._animationComponents[10].startShowAnimation(2);
        this._animationComponents[11] = new AnimationComponent(this.mainCanvas, this.rectLeftFk, _WIDTH, _HEIGHT);
        this._animationComponents[11].startShowAnimation(0);
        this._animationComponents[12] = new AnimationComponent(this.mainCanvas, this.rectRightFk, _WIDTH, _HEIGHT);
        this._animationComponents[12].startShowAnimation(1);
        this._animationComponents[13] = new AnimationComponent(this.mainCanvas, this._rectDialog, _WIDTH, _HEIGHT);
        this._animationComponents[13].startShowAnimation(3);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(0);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5].startShowAnimation(3);
        this._animationComponents[6].startShowAnimation(2);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8].startShowAnimation(0);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10].startShowAnimation(2);
        this._animationComponents[11].startShowAnimation(0);
        this._animationComponents[12].startShowAnimation(1);
        this._animationComponents[13].startShowAnimation(3);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(0);
        this._animationComponents[1].startHideAnimation(1);
        this._animationComponents[2].startHideAnimation(0);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(3);
        this._animationComponents[5].startHideAnimation(3);
        this._animationComponents[6].startHideAnimation(2);
        this._animationComponents[7].startHideAnimation(1);
        this._animationComponents[8].startHideAnimation(0);
        this._animationComponents[9].startHideAnimation(3);
        this._animationComponents[10].startHideAnimation(2);
        this._animationComponents[11].startHideAnimation(0);
        this._animationComponents[12].startHideAnimation(1);
        this._animationComponents[13].startHideAnimation(3);
    }

    private void freeGraphics() {
        this._imgGameLogo = null;
        this._imgMenuBg = null;
        this._imgGameOver = null;
        this._sprArrows = null;
        this._sprIconsFk = null;
        this._sprWindow = null;
    }

    private void prepareTxt() {
        this.initTxt();
        String controls = "";
        controls = Resources.resTexts[0].getHashedString(17) + "\n\n\n\n" + "\n\n\n\n";
        controls = Resources.resTexts[0].getHashedString(16);
        _ptInstruction.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls, this.rectText.width);
        _ptInstruction.setLineHeightCorrection(-2);
        this.loadBestScore();
    }

    private void loadBestScore() {
        Vector scores = RMSObjects.normal.getScoresForGame(0);
        if (this._iMode == 2) {
            RMSObjects.createRMSConnect(4);
            if (!RMSObjects.rmsConnects[4].load()) {
                RMSObjects.rmsConnects[4].create();
            }
            scores = RMSObjects.easy.getScoresForGame(0);
        } else if (this._iMode == 0) {
            RMSObjects.createRMSConnect(5);
            if (!RMSObjects.rmsConnects[5].load()) {
                RMSObjects.rmsConnects[5].create();
            }
            scores = RMSObjects.normal.getScoresForGame(0);
        } else if (this._iMode == 1) {
            RMSObjects.createRMSConnect(3);
            if (!RMSObjects.rmsConnects[3].load()) {
                RMSObjects.rmsConnects[3].create();
            }
            scores = RMSObjects.hard.getScoresForGame(0);
        } else {
            RMSObjects.createRMSConnect(5);
            if (!RMSObjects.rmsConnects[5].load()) {
                RMSObjects.rmsConnects[5].create();
            }
            scores = RMSObjects.normal.getScoresForGame(0);
        }
        if (scores != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (this.scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            this.bestScoreSave = scoreItem.scoreValue;
        }
    }

    private void saveBestScore() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = "0";
        if (RMSObjects.game.getScore() > this.bestScoreSave) {
            scoreItem.scoreValue = RMSObjects.game.getScore();
            if (this._iMode == 2) {
                RMSObjects.easy.userName = Integer.toString(0);
                RMSObjects.easy.insertScoreItem(scoreItem, 0);
                if (!RMSObjects.rmsConnects[4].isExist()) {
                    RMSObjects.rmsConnects[4].create();
                }
                RMSObjects.rmsConnects[4].save();
            } else if (this._iMode == 0) {
                RMSObjects.normal.userName = Integer.toString(0);
                RMSObjects.normal.insertScoreItem(scoreItem, 0);
                if (!RMSObjects.rmsConnects[5].isExist()) {
                    RMSObjects.rmsConnects[5].create();
                }
                RMSObjects.rmsConnects[5].save();
            } else if (this._iMode == 1) {
                RMSObjects.hard.userName = Integer.toString(0);
                RMSObjects.hard.insertScoreItem(scoreItem, 0);
                if (!RMSObjects.rmsConnects[3].isExist()) {
                    RMSObjects.rmsConnects[3].create();
                }
                RMSObjects.rmsConnects[3].save();
            }
        }
    }

    public void beforeInteruption() {
        if (this.status == 0) {
            Keys.resetAllPressedKeysAndActions();
            RMSObjects.game.releaaseControls();
            this.setGameMenuStatus();
        }
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
    }

    private void calculatePositions() {
        int itemHeight = Resources.resGFonts[0].getHeight();
        int itemWidth = _WIDTH;
        int posX = _WIDTH >> 1;
        int posY = (_HEIGHT >> 1) - (itemHeight << 1);
        int rectPanelY = itemHeight;
        int rectTextOffsetX = this._sprIconsFk.getWidth();
        int rectTextOffsetY = this._sprIconsFk.getHeight();
        this.rectPanel = new Rectangle(0, rectPanelY, _WIDTH, _HEIGHT - rectPanelY);
        int _iWallWidth = Resources.resSprs[23].getWidth();
        int _gaOffset = _WIDTH % _iWallWidth >> 1;
        int _gaWidth = _WIDTH / _iWallWidth * _iWallWidth;
        this.rectGameArea = new Rectangle(_gaOffset, 0, _gaWidth, _HEIGHT - this._sprIconsFk.getHeight());
        _ptActualScore = new PreparedText(Resources.resGFonts[3]);
        _ptActualScore.prepareText("0", this.mainCanvas.getWidth());
        this.rectScore = new Rectangle(0, itemHeight >> 1, this.mainCanvas.getWidth(), _ptActualScore.getTextHeight());
        this.rectBestScore = new Rectangle(0, itemHeight >> 1, this.mainCanvas.getWidth(), itemHeight);
        this.rectPanel = new Rectangle(0, itemHeight, _WIDTH, _HEIGHT - (itemHeight << 1));
        this.rectText = new Rectangle(rectTextOffsetX, this.rectPanel.y + rectTextOffsetY, _WIDTH - (rectTextOffsetX << 1), this.rectPanel.height - (this.rectPanel.y + rectTextOffsetY));
        posX = _WIDTH - itemWidth >> 1;
        posY = this.rectPanel.getTop() + itemHeight;
        int _iOffsetY = _HEIGHT - this._imgGameLogo.getWidth() - this._sprIconsFk.getWidth();
        posY = this._imgGameLogo.getHeight() + (_iOffsetY >>= 3);
        posX = (_WIDTH >> 1) - (this._imgButton.getWidth() >> 1);
        this.rectItems[3] = new Rectangle(posX, posY, this._imgButton.getWidth(), this._imgButton.getHeight());
        this.rectItems[4] = new Rectangle(0, 0, 0, 0);
        this.rectItems[6] = new Rectangle(posX, posY += this._imgButton.getHeight() + _iOffsetY, this._imgButton.getWidth(), this._imgButton.getHeight());
        this.rectItems[5] = new Rectangle(posX, posY += this._imgButton.getHeight() + _iOffsetY, this._imgButton.getWidth(), this._imgButton.getHeight());
        this.rectItems[0] = this.rectLeftFk = new Rectangle(0, MainCanvas.HEIGHT - this._sprIconsFk.getHeight(), this._sprIconsFk.getWidth(), this._sprIconsFk.getHeight());
        this.rectItems[1] = this.rectRightFk = new Rectangle(MainCanvas.WIDTH - this._sprIconsFk.getWidth(), MainCanvas.HEIGHT - this._sprIconsFk.getHeight(), this._sprIconsFk.getWidth(), this._sprIconsFk.getHeight());
        this.rectPlay = new Rectangle(0, _HEIGHT >> 1, _WIDTH, itemHeight);
        this._rectTopBig = new Rectangle(_WIDTH >> 1, 0, this._imgGameLogo.getWidth(), this._imgGameLogo.getHeight());
        int _windowWidth = _WIDTH >> 1;
        int _offsetX = _windowWidth % this._sprWindow.getWidth() > 0 ? _windowWidth % this._sprWindow.getWidth() : this._sprWindow.getWidth();
        int _offsetTopY = (this._sprIconsFk.getHeight() - this._sprIconsFk.getHeight() << 1) + this._sprIconsFk.getHeight();
        int _offsetBottomY = this._sprIconsFk.getHeight() + (this._sprIconsFk.getHeight() - this._sprIconsFk.getHeight());
        int _panelHeight = _HEIGHT - _offsetTopY - _offsetBottomY;
        this._iOffsetX = _offsetX;
        this._iFinalHeight = _panelHeight % this._sprWindow.getWidth() == 0 ? _panelHeight : _panelHeight - _panelHeight % this._sprWindow.getWidth();
        this._rectDialog = new Rectangle(_offsetX, _offsetTopY, _WIDTH - (_offsetX << 1), this._iFinalHeight);
        this.calculateWindowTiles();
    }

    private void calculateWindowTiles() {
        this._iTotalColTiles = (_WIDTH - (this._iOffsetX << 1)) / this._sprWindow.getWidth();
        this._iTotalRowTiles = this._iFinalHeight / this._sprWindow.getWidth();
    }

    public void update(long lastRunLenght) {
        if (MainCanvas.interuption_nokia == 0) {
            if (this.cycle > 0) {
                --this.cycle;
            } else if (MainCanvas.nokia == 1) {
                MainCanvas.nokia = 0;
                MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                this.cycle = 10;
            }
        }
        this.animationController();
        this.animationComponentsUpdate();
        if (this.status == 0) {
            if (this.nextScreen == 2) {
                return;
            }
            if (this._bBkickUpdate) {
                return;
            }
            RMSObjects.game.update(lastRunLenght);
            this.mainCanvas.repaint();
            if (RMSObjects.game.isGameOver()) {
                this.startAnimation(true, 2);
            }
        }
        if (this.status == 2) {
            this.mainCanvas.repaint();
        }
        if (this.status == 3) {
            this.needRepaint = false;
            this.textMove();
            if (this.needRepaint) {
                this.mainCanvas.repaint();
            }
        }
        if (this.status == 1) {
            // empty if block
        }
    }

    public void textMove() {
        this.needRepaint = false;
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY < 0) {
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
            this.needRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = _ptInstruction.getTextHeight() - this.rectText.height;
            if (Resources.sysFont) {
                this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY > maxOffsetY) {
                this.textOffsetY = maxOffsetY;
                this.scrollUP = true;
                this.scrollDOWN = false;
            }
            this.needRepaint = true;
        }
        if (this.needRepaint) {
            this.mainCanvas.repaint();
        }
    }

    private boolean animationController() {
        if (this.changeSequence) {
            if (this._sequence == this._sequenceShow) {
                this.showAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceHide) {
                this.hideAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceStop) {
                this.changeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        if (this._sequence == this._sequenceHide) {
            this._sequence = this._sequenceShow;
            this.status = this.nextScreen;
            this.changeSequence = true;
            this.mainCanvas.repaint();
        } else if (this._sequence == this._sequenceShow) {
            this._sequence = this._sequenceStop;
            this.mainCanvas.repaint();
        }
        boolean _return = false;
        for (int i = 0; i < this._animationSequence[this.status].length; ++i) {
            if (this._animationSequence[this.status][i] == -1 || this._animationComponents[this._animationSequence[this.status][i]] == null || this._animationComponents[this._animationSequence[this.status][i]].isComponentAnimated()) continue;
            this._animationComponents[this._animationSequence[this.status][i]].update();
            if (this.status == 0) {
                // empty if block
            }
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._sequence == this._sequenceHide) {
                if (this.nextScreen == 7) {
                    this.startMenuScreen();
                }
                this._sequence = this._sequenceShow;
                this.status = this.nextScreen;
                this.changeSequence = true;
            } else if (this._sequence == this._sequenceShow) {
                this._sequence = this._sequenceStop;
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextScreen) {
        this.changeSequence = changeSequencem;
        this.nextScreen = nextScreen;
        this._sequence = this._sequenceHide;
    }

    private void startMenuScreen() {
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode));
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this.status) {
            case 0: {
                RMSObjects.game.paint(g, this.status);
                this.paintPanelTop(g);
                break;
            }
            case 1: {
                this.paintGameLogo(g);
                this.paintMenuDialogItems(g);
                break;
            }
            case 2: {
                this.paintMessage(g);
                break;
            }
            case 3: {
                this.paintWindow(g, this._rectDialog);
                this.paintInstrusctionTxt(g);
                this.paintArrows(g);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.paintMessage(g);
                break;
            }
            case 6: {
                this.paintMessage(g);
            }
        }
        this.paintFK(g);
    }

    public void paintBackground(Graphics g) {
        g.drawImage(this._imgMenuBg, _WIDTH >> 1, _HEIGHT >> 1, 3);
    }

    public void paintGameLogo(Graphics g) {
        g.drawImage(this._imgGameLogo, this._rectTopBig.x, this._rectTopBig.y, 17);
    }

    private void paintInstrusctionTxt(Graphics g) {
        _ptInstruction.drawText(g, this.rectText, this.textOffsetY, 20);
    }

    private void paintMessage(Graphics g) {
        if (this.status == 6) {
            this.paintWindow(g, this._rectDialog);
            _ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(77), this.rectText.width);
            _ptMenuItem.drawText(g, this.rectText, _ptMenuItem.getTextHeight() >> 1, 3);
        } else if (this.status == 5) {
            g.drawImage(this._imgGameOver, this.rectText.getCenterX(), this.rectText.getCenterY(), 3);
            _ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(78), this.rectText.width);
            _ptMenuItem.drawText(g, this.rectText, _ptMenuItem.getTextHeight() >> 1, 3);
        } else if (this.status == 2) {
            g.drawImage(this._imgGameOver, this.rectText.getCenterX(), this.rectText.getCenterY(), 3);
            String text = Resources.resTexts[0].getHashedString(13);
            String nect = this.bestScoreSave < RMSObjects.game.getScore() ? "\n" + Resources.resTexts[0].getHashedString(10) + " : " + RMSObjects.game.getScore() + "\n" + Resources.resTexts[0].getHashedString(83) + ": " + RMSObjects.game.getScore() : "\n" + Resources.resTexts[0].getHashedString(10) + " : " + RMSObjects.game.getScore() + "\n" + Resources.resTexts[0].getHashedString(83) + ": " + this.bestScoreSave;
            _ptMenuItem.prepareText(text, this.rectText.width);
            _ptMenuItem.drawText(g, this.rectText, _ptMenuItem.getTextHeight() + (_ptMenuItem.getTextHeight() >> 1), 3);
            bestScore.prepareText(nect, this.rectText.width);
            bestScore.drawText(g, this.rectText, _ptMenuItem.getTextHeight(), 3);
        } else if (this.status == 0 && RMSObjects.game.isInitGame()) {
            _ptMenuItem.prepareText("PRESS 5 TO START THE GAME", this.rectText.width);
            _ptMenuItem.drawText(g, this.rectText, _ptMenuItem.getTextHeight() >> 1, 3);
        }
    }

    private void paintArrows(Graphics g) {
        if (this.scrollDOWN && this.scrollUP) {
            this._sprArrows.setPosition((this.rectText.x + this.rectText.width >> 1) + (this._sprArrows.getWidth() >> 1), this.rectText.y - this._sprArrows.getHeight() - (this._sprArrows.getHeight() >> 1));
            this._sprArrows.setFrame(0);
            this._sprArrows.paint(g);
            this._sprArrows.setPosition((this.rectText.x + this.rectText.width >> 1) + (this._sprArrows.getWidth() >> 1), this.rectText.y + this.rectText.height + (this._sprArrows.getHeight() >> 1));
            this._sprArrows.setFrame(1);
            this._sprArrows.paint(g);
        } else if (!this.scrollDOWN && this.scrollUP) {
            this._sprArrows.setPosition((this.rectText.x + this.rectText.width >> 1) + (this._sprArrows.getWidth() >> 1), this.rectText.y - this._sprArrows.getHeight() - (this._sprArrows.getHeight() >> 1));
            this._sprArrows.setFrame(0);
            this._sprArrows.paint(g);
        }
        if (this.scrollDOWN && !this.scrollUP) {
            this._sprArrows.setPosition((this.rectText.x + this.rectText.width >> 1) + (this._sprArrows.getWidth() >> 1), this.rectText.y + this.rectText.height + (this._sprArrows.getHeight() >> 1));
            this._sprArrows.setFrame(1);
            this._sprArrows.paint(g);
        }
    }

    private void paintPanelTop(Graphics g) {
        _ptActualScore.prepareText("" + RMSObjects.game.getScore(), this.rectScore.width);
        _ptActualScore.drawText(g, this.rectScore, 0, 3);
    }

    public void paintTop(Graphics g) {
    }

    private void paintFK(Graphics g) {
        if (this.status == 0) {
            this._sprIconsFk.setFrame(2);
            this._sprIconsFk.setPosition(this.rectRightFk.x, this.rectRightFk.y);
            this._sprIconsFk.paint(g);
        } else if (this.status == 4) {
            this._sprIconsFk.setFrame(6);
            this._sprIconsFk.setPosition(this.rectRightFk.x, this.rectRightFk.y);
            this._sprIconsFk.paint(g);
        } else if (this.status == 1) {
            this._sprIconsFk.setFrame(5);
            this._sprIconsFk.setPosition(this.rectRightFk.x, this.rectRightFk.y);
            this._sprIconsFk.paint(g);
        } else if (this.status == 3) {
            this._sprIconsFk.setFrame(5);
            this._sprIconsFk.setPosition(this.rectRightFk.x, this.rectRightFk.y);
            this._sprIconsFk.paint(g);
        } else if (this.status == 5) {
            this._sprIconsFk.setFrame(4);
            this._sprIconsFk.setPosition(this.rectRightFk.x, this.rectRightFk.y);
            this._sprIconsFk.paint(g);
            this._sprIconsFk.setFrame(3);
            this._sprIconsFk.setPosition(this.rectLeftFk.x, this.rectLeftFk.y);
            this._sprIconsFk.paint(g);
        } else if (this.status == 6) {
            this._sprIconsFk.setFrame(4);
            this._sprIconsFk.setPosition(this.rectRightFk.x, this.rectRightFk.y);
            this._sprIconsFk.paint(g);
            this._sprIconsFk.setFrame(3);
            this._sprIconsFk.setPosition(this.rectLeftFk.x, this.rectLeftFk.y);
            this._sprIconsFk.paint(g);
        } else if (this.status == 2) {
            if (RMSObjects.game.isGameOver()) {
                this._sprIconsFk.setFrame(7);
                this._sprIconsFk.setPosition(this.rectRightFk.x, this.rectRightFk.y);
                this._sprIconsFk.paint(g);
                this._sprIconsFk.setFrame(1);
                this._sprIconsFk.setPosition(this.rectLeftFk.x, this.rectLeftFk.y);
                this._sprIconsFk.paint(g);
            } else {
                this._sprIconsFk.setFrame(5);
                this._sprIconsFk.setPosition(this.rectRightFk.x, this.rectRightFk.y);
                this._sprIconsFk.paint(g);
                this._sprIconsFk.setFrame(4);
                this._sprIconsFk.setPosition(this.rectLeftFk.x, this.rectLeftFk.y);
                this._sprIconsFk.paint(g);
            }
        }
    }

    private void paintMenuDialogItems(Graphics g) {
        if (this.selectedCompId == 3) {
            this.paintButton(g, 3, 0, true);
        } else {
            this.paintButton(g, 3, 0, false);
        }
        if (this.selectedCompId == 6) {
            this.paintButton(g, 6, 1, true);
        } else {
            this.paintButton(g, 6, 1, false);
        }
        if (this.selectedCompId == 5) {
            this.paintButton(g, 5, 2, true);
        } else {
            this.paintButton(g, 5, 2, false);
        }
    }

    private String getButtonName(int _idx) {
        if (_idx == 3) {
            return Resources.resTexts[0].getHashedString(25);
        }
        if (_idx == 6) {
            return Resources.resTexts[0].getHashedString(22);
        }
        if (_idx == 5) {
            return Resources.resTexts[0].getHashedString(19);
        }
        if (_idx == 4) {
            return MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27);
        }
        return "NAN";
    }

    private void paintButton(Graphics g, int _type, int frame, boolean active) {
        if (active) {
            g.drawImage(this._imgButtonSelector, this.rectItems[_type].getCenterX(), this.rectItems[_type].getCenterY(), 3);
        } else {
            g.drawImage(this._imgButton, this.rectItems[_type].getCenterX(), this.rectItems[_type].getCenterY(), 3);
        }
        _ptMenuItem.prepareText(this.getButtonName(_type), this.rectItems[_type].width);
        _ptMenuItem.drawText(g, this.rectItems[_type], 0, 3);
    }

    private void paintWindow(Graphics g, Rectangle _rectWindow) {
        int _actualTileX = 0;
        int _actualTileY = 0;
        for (int x = _rectWindow.x; x < _rectWindow.x + _rectWindow.width; x += this._sprWindow.getWidth()) {
            for (int y = _rectWindow.y; y < _rectWindow.y + _rectWindow.height; y += this._sprWindow.getWidth()) {
                this._sprWindow.setFrame(this.getWindowTileSprite(_actualTileX, _actualTileY));
                this._sprWindow.setPosition(x, y);
                this._sprWindow.paint(g);
                ++_actualTileY;
            }
            _actualTileY = 0;
            ++_actualTileX;
        }
    }

    private int getWindowTileSprite(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < this._iTotalColTiles - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == this._iTotalColTiles - 1) {
            return 2;
        }
        if (_y == this._iTotalRowTiles - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < this._iTotalRowTiles - 1 && _y > 0) {
            return 3;
        }
        if (_x == this._iTotalColTiles - 1 && _y < this._iTotalRowTiles - 1 && _y > 0) {
            return 5;
        }
        if (_y == this._iTotalRowTiles - 1 && _x < this._iTotalColTiles - 1 && _x > 0) {
            return 7;
        }
        if (_y == this._iTotalRowTiles - 1 && _x == this._iTotalColTiles - 1) {
            return 8;
        }
        return 4;
    }

    public void keyPressed(int keyCode) {
        if (0 == this.status) {
            if (Keys.isActionGeneratedByKey(3, keyCode)) {
                RMSObjects.game.startMoveLeft();
            } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
                RMSObjects.game.startMoveRight();
            }
        }
    }

    public void keyReleased(int keyCode) {
        switch (this.status) {
            case 4: {
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 0);
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.setGameMenuStatus();
                }
                if (Keys.isFKLeftCode(keyCode) || keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) {
                    // empty if block
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    RMSObjects.game.endMoveLeft();
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    RMSObjects.game.endMoveRight();
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                RMSObjects.game.rotate();
                break;
            }
            case 1: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                this.keyReleasedMenuGame(keyCode);
                break;
            }
            case 2: {
                this.keyReleasedResult(keyCode);
                break;
            }
            case 3: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55 || !Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
                this.selectedCompId = 6;
                break;
            }
            case 6: {
                if (Keys.isFKLeftCode(keyCode)) {
                    this.startMenuScreen();
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                break;
            }
            case 5: {
                if (Keys.isFKLeftCode(keyCode)) {
                    RMSObjects.game.restartGame(this.rectGameArea, this._iMode);
                    this.startAnimation(true, 0);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
            }
        }
        this.mainCanvas.repaint();
    }

    private void setGameMenuStatus() {
        this.startAnimation(true, 1);
        this.selectedCompId = 3;
    }

    private void keyReleasedMenuGame(int keyCode) {
        switch (this.selectedCompId) {
            case 2: {
                break;
            }
            case 3: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 6;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 5);
                Keys.resetAllPressedKeysAndActions();
                this.mainCanvas.repaint();
                break;
            }
            case 4: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 6;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.SetSoundOn(false);
                    Settings.musicOn = false;
                    MainCanvas.soundManager.Stop();
                    break;
                }
                MainCanvas.soundManager.SetSoundOn(true);
                Settings.musicOn = true;
                MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                break;
            }
            case 6: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 5;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 3);
                break;
            }
            case 5: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 6);
            }
        }
        if (Keys.isFKRightCode(keyCode)) {
            Keys.resetAllPressedKeysAndActions();
            RMSObjects.game.releaaseControls();
            this.startAnimation(true, 0);
        }
    }

    private void keyReleasedResult(int keyCode) {
        if (RMSObjects.game.isGameOver()) {
            if (Keys.isFKRightCode(keyCode)) {
                this.saveBestScore();
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode));
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isFKLeftCode(keyCode)) {
                this.saveBestScore();
                this.loadBestScore();
                RMSObjects.game.restartGame(this.rectGameArea, this._iMode);
                this.startAnimation(true, 0);
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                }
            }
        } else if (RMSObjects.game.isLevelDone()) {
            if (Keys.isFKLeftCode(keyCode)) {
                this.saveBestScore();
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode));
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                // empty if block
            }
        }
    }

    public void pointerPressed(int x, int y) {
        this.posX = x;
        this.posY = y;
        if (this.status == 0 && this.rectGameArea.contains(x, y)) {
            RMSObjects.game.pointerPressed(x, y);
            return;
        }
        block5: for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.existComponentInState(i, this.status) || this.rectItems[i] == null || !this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            switch (this.selectedCompId) {
                case 0: {
                    if (this.status != 1) {
                        Keys.keyPressed(-6);
                        continue block5;
                    }
                    Keys.keyPressed(-6);
                    continue block5;
                }
                case 1: {
                    if (this.status == 3) {
                        this.startAnimation(true, 1);
                        this.textOffsetY = 0;
                        this.scrollUP = false;
                        this.scrollDOWN = true;
                        this.mainCanvas.repaint();
                        continue block5;
                    }
                    Keys.keyPressed(-7);
                    continue block5;
                }
                case 4: {
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.SetSoundOn(false);
                        MainCanvas.soundManager.Stop();
                    } else {
                        MainCanvas.soundManager.SetSoundOn(true);
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                    this.mainCanvas.repaint();
                    continue block5;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                }
            }
        }
    }

    private boolean existComponentInState(int i, int status) {
        if (status == 0) {
            if (i == 1) {
                return true;
            }
        } else if (status == 6) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 1) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
            if (i == 2) {
                return true;
            }
            if (i == 3) {
                return true;
            }
            if (i == 4) {
                return true;
            }
            if (i == 6) {
                return true;
            }
            if (i == 5) {
                return true;
            }
        } else if (status == 3) {
            if (i == 1) {
                return true;
            }
        } else if (status == 2) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 5) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 3) {
            if (i == 1) {
                return true;
            }
        } else if (status == 4) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        if (this.status == 3) {
            if (this.posY > y) {
                this.dragUp();
            } else if (this.posY < y) {
                this.dragDown();
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.status == 4) {
            this.startAnimation(true, 0);
            return;
        }
        if (this.status == 0 && this.rectGameArea.contains(x, y)) {
            RMSObjects.game.pointerReleased(x, y);
            return;
        }
        switch (this.selectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                break;
            }
            case 1: {
                if (Keys.isKeyPressed(-7)) {
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                }
                this.mainCanvas.repaint();
            }
            default: {
                if (Keys.isKeyPressed(53)) {
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
                if (this.status != 1) break;
                this.selectedCompId = 1;
                this.mainCanvas.repaint();
            }
        }
    }

    public void dragUp() {
        if (Resources.sysFont) {
            this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY < 0) {
            this.textOffsetY = 0;
            this.scrollUP = false;
            this.scrollDOWN = true;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    public void dragDown() {
        int maxOffsetY = _ptInstruction.getTextHeight() - this.rectPanel.height;
        if (Resources.sysFont) {
            this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY > maxOffsetY) {
            this.textOffsetY = maxOffsetY;
            this.scrollUP = true;
            this.scrollDOWN = false;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    static {
        _WIDTH = 0;
        _HEIGHT = 0;
    }
}

