/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Particles;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Game
implements RMSHandler {
    private static final int _STATUS_INITLEVEL = 0;
    private static final int _STATUS_READY = 1;
    private static final int _STATUS_LEVELDONE = 2;
    private static final int _STATUS_GAMEOVER = 3;
    public static Rectangle _rectGameArea;
    private Rectangle _rectChar;
    private Rectangle[][] _rectWorld;
    private Rectangle _tmpR;
    private int TOTAL_ROW = 10;
    private int TOTAL_COL = 10;
    private int _iStatus;
    private int _iScore;
    private int _iTmpShift = 50;
    private int _iTmpPositionX = 0;
    private int _iTmpDefaultPositionX;
    private int _iTmpShiftW = 2048;
    private int[] _iTmpPositionXw;
    private int[] _iTmpDefaultPositionXw;
    private int[][] _iWorld;
    private int[][] _iScores;
    private boolean _stsrtMoveLeft = false;
    private boolean _stsrtMoveRight = false;
    private boolean _bCheck = false;
    private Sprite _sprChar;
    private Sprite _sprCoralVer1;
    private Sprite _sprCoralVer2;
    private Sprite _sprCoralVer3;
    private Sprite _sprCoralHorBlank1;
    private Sprite _sprCoralHorBlank2;
    private Sprite _sprCoralHorBlank3;
    private Sprite _sprCoralHorBlank4;
    private Sprite _sprCoralHorCorenr1;
    private Sprite _sprCoralHorCorenr2;
    private Sprite _sprCoralHorCorenr3;
    private Sprite _sprCoralHorCorenr4;
    private PreparedText _tapToStart;
    private PreparedText _ptNumber;
    private boolean _pressed = false;

    public Game() {
        this.init();
    }

    private void init() {
        this._tapToStart = new PreparedText(Resources.resGFonts[0]);
        this._ptNumber = new PreparedText(Resources.resGFonts[0]);
        this._sprCoralVer1 = Resources.resSprs[20];
        this._sprCoralVer2 = Resources.resSprs[21];
        this._sprCoralVer3 = Resources.resSprs[22];
        this._sprCoralHorBlank1 = Resources.resSprs[23];
        this._sprCoralHorBlank2 = Resources.resSprs[24];
        this._sprCoralHorBlank3 = Resources.resSprs[25];
        this._sprCoralHorBlank4 = Resources.resSprs[29];
        this._sprCoralHorCorenr1 = Resources.resSprs[26];
        this._sprCoralHorCorenr2 = Resources.resSprs[27];
        this._sprCoralHorCorenr3 = Resources.resSprs[28];
        this._sprCoralHorCorenr4 = Resources.resSprs[30];
        this._sprChar = RandomNum.getRandomInt(99, 0) % 2 == 0 ? Resources.resSprs[18] : Resources.resSprs[19];
    }

    public void restartGame(Rectangle _rectArea, int mode) {
        this._iTmpShiftW = MainCanvas.HEIGHT << 1;
        this.init();
        this._tmpR = new Rectangle(0, 0, 0, 0);
        this.TOTAL_COL = 5;
        this._rectWorld = new Rectangle[this.TOTAL_COL][this.TOTAL_ROW];
        this._iWorld = new int[this.TOTAL_COL][this.TOTAL_ROW];
        this._iScores = new int[this.TOTAL_COL][this.TOTAL_ROW];
        this._iTmpPositionXw = new int[this.TOTAL_ROW];
        this._iStatus = 0;
        this._tapToStart = new PreparedText(Resources.resGFonts[0]);
        this._rectChar = new Rectangle((_rectArea.width >> 1) - (this._sprChar.getWidth() >> 1), (_rectArea.height >> 1) + (this._sprChar.getWidth() >> 1), this._sprChar.getWidth(), this._sprChar.getWidth() >> 1);
        this._iTmpDefaultPositionX = this._iTmpPositionX = this._rectChar.x << 2;
        this._iTmpShift = MainCanvas.WIDTH / 9;
        this._tapToStart.prepareText(Resources.resTexts[0].getHashedString(80), MainCanvas.WIDTH);
        _rectGameArea = _rectArea;
        this.createWorld();
        this.endMoveLeft();
        this.endMoveRight();
        this._iScore = 0;
        this._iStatus = 1;
    }

    private void createWorld() {
        int freePos = 0;
        int setPos = 0;
        int lastEmpty = -1;
        int wall = 0;
        for (int _iY = 0; _iY < this.TOTAL_ROW; ++_iY) {
            freePos = RandomNum.getRandomInt(this.TOTAL_COL, 0);
            if (freePos < 0) {
                freePos *= -1;
            }
            if (lastEmpty == -1) {
                lastEmpty = freePos;
            } else {
                if (Math.abs(freePos - lastEmpty) > 2) {
                    wall = 2;
                }
                lastEmpty = freePos;
            }
            for (int _iX = 0; _iX < this.TOTAL_COL; ++_iX) {
                this._rectWorld[_iX][_iY] = new Rectangle(Game._rectGameArea.x + _iX * this._sprCoralHorBlank1.getWidth(), Game._rectGameArea.y - (this._sprCoralHorCorenr1.getHeight() << 3) - _iY * (this._sprCoralHorCorenr1.getHeight() + (this._sprCoralVer1.getHeight() >> 1)), this._sprCoralHorBlank1.getWidth(), this._sprCoralHorCorenr1.getHeight() + (this._sprCoralVer1.getHeight() >> 1));
                this._iTmpPositionXw[_iY] = this._rectWorld[_iX][_iY].y << 200 << 1;
                if (_iX == freePos && setPos == 0) {
                    this._iWorld[_iX][_iY] = 1 + wall;
                    ++setPos;
                    continue;
                }
                this._iWorld[_iX][_iY] = wall;
            }
            setPos = 0;
            wall = 0;
        }
    }

    public void update(long lastRunLenght) {
        if (this._iStatus == 1) {
            this.checkScore();
        }
        this.updateWorld();
        if (this._iStatus != 3) {
            if (this._stsrtMoveLeft) {
                this.moveLeft();
            }
            if (this._stsrtMoveRight) {
                this.moveRight();
            }
        }
        Particles.update();
        Particles.createParticle(this._rectChar.getCenterX(), this._rectChar.getCenterY(), 0, 50, RandomNum.getRandomInt(5, -5), 0, 3, 0xFFFFFF, RandomNum.getRandomUInt(10), 0);
    }

    private void updateWorld() {
        int _iCheck = 0;
        int _iReset = 0;
        for (int _iY = 0; _iY < this.TOTAL_ROW; ++_iY) {
            int n = _iY;
            this._iTmpPositionXw[n] = this._iTmpPositionXw[n] + this._iTmpShiftW;
            for (int _iX = 0; _iX < this.TOTAL_COL; ++_iX) {
                if (this.checkGameOver(_iX, _iY)) {
                    return;
                }
                this._rectWorld[_iX][_iY].y = this._iTmpPositionXw[_iY] >> 200 >> 1;
                if (this.checkGameOver(_iX, _iY)) {
                    return;
                }
                if (this._rectWorld[_iX][_iY].y - this._rectWorld[_iX][_iY].height <= MainCanvas.HEIGHT || _iReset != 0) continue;
                this.resetRow(_iY);
                ++_iReset;
            }
            if (this._rectWorld[0][_iY].y > MainCanvas.HEIGHT >> 1 && _iCheck == 0 && this._iScores[0][_iY] == 0) {
                ++this._iScore;
                this._iScores[0][_iY] = 1;
                ++_iCheck;
                if (this._iScore % 30 == 0) {
                    this._iTmpShiftW += 32;
                }
            }
            _iReset = 0;
            _iCheck = 0;
        }
    }

    private boolean checkGameOver(int _iX, int _iY) {
        this._tmpR.x = this._rectWorld[_iX][_iY].x;
        this._tmpR.y = this._rectWorld[_iX][_iY].y;
        this._tmpR.width = this._rectWorld[_iX][_iY].width;
        this._tmpR.height = this._sprCoralHorBlank1.getHeight();
        if (this._tmpR.intersects(this._rectChar) && this._iWorld[_iX][_iY] == 0) {
            this._iStatus = 3;
            return true;
        }
        if (this._tmpR.contains(this._rectChar.x, this._rectChar.y) && (this._iWorld[_iX][_iY] == 0 || this._iWorld[_iX][_iY] == 2)) {
            this._iStatus = 3;
            return true;
        }
        if (this._tmpR.contains(this._rectChar.x + this._rectChar.width, this._rectChar.y + this._rectChar.height) && (this._iWorld[_iX][_iY] == 0 || this._iWorld[_iX][_iY] == 2)) {
            this._iStatus = 3;
            return true;
        }
        if (this._tmpR.contains(this._rectChar.getCenterX(), this._rectChar.getCenterY()) && this._iWorld[_iX][_iY] == 0) {
            this._iStatus = 3;
            return true;
        }
        if (this._rectChar.contains(this._tmpR.x, this._tmpR.y) && (this._iWorld[_iX][_iY] == 0 || this._iWorld[_iX][_iY] == 2)) {
            this._iStatus = 3;
            return true;
        }
        if (this._rectChar.contains(this._tmpR.getCenterX(), this._tmpR.getCenterY()) && (this._iWorld[_iX][_iY] == 0 || this._iWorld[_iX][_iY] == 2)) {
            this._iStatus = 3;
            return true;
        }
        if (_iX == 0) {
            this._tmpR.x = this._rectWorld[_iX][_iY].x;
            this._tmpR.y = this._rectWorld[_iX][_iY].y;
            this._tmpR.width = this._sprCoralVer1.getWidth() >> 1;
            this._tmpR.height = this._rectWorld[_iX][_iY].height;
            if (this._tmpR.intersects(this._rectChar) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
            if (this._tmpR.contains(this._rectChar.x, this._rectChar.y) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
            if (this._tmpR.contains(this._rectChar.getCenterX(), this._rectChar.getCenterY()) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
            if (this._rectChar.contains(this._tmpR.x, this._tmpR.y) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
            if (this._rectChar.contains(this._tmpR.getCenterX(), this._tmpR.getCenterY()) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
        }
        if (_iX == this.TOTAL_COL - 1) {
            this._tmpR.x = this._rectWorld[_iX][_iY].x + this._rectWorld[_iX][_iY].width - (this._sprCoralVer1.getWidth() >> 1);
            this._tmpR.y = this._rectWorld[_iX][_iY].y;
            this._tmpR.width = this._sprCoralVer1.getWidth() >> 1;
            this._tmpR.height = this._rectWorld[_iX][_iY].height;
            if (this._tmpR.intersects(this._rectChar) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
            if (this._tmpR.contains(this._rectChar.x, this._rectChar.y) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
            if (this._tmpR.isOverlap(this._rectChar) && this._iWorld[_iX][_iY] == 0) {
                this._iStatus = 3;
                return true;
            }
            if (this._tmpR.contains(this._rectChar.getCenterX(), this._rectChar.getCenterY()) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
            if (this._rectChar.contains(this._tmpR.x, this._tmpR.y) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
            if (this._rectChar.contains(this._tmpR.getCenterX(), this._tmpR.getCenterY()) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
        }
        return false;
    }

    private void resetRow(int _iY) {
        int _iX;
        int freePos = 0;
        int setPos = 0;
        int wall = 0;
        int tmpIdx = 0;
        if (_iY == 0) {
            for (_iX = 0; _iX < this.TOTAL_COL; ++_iX) {
                if (this._iWorld[_iX][this.TOTAL_ROW - 1] != 1) continue;
                tmpIdx = _iX;
            }
        } else {
            for (_iX = 0; _iX < this.TOTAL_COL; ++_iX) {
                if (this._iWorld[_iX][_iY - 1] != 1) continue;
                tmpIdx = _iX;
            }
        }
        if ((freePos = RandomNum.getRandomInt(this.TOTAL_COL, 0)) < 0) {
            freePos *= -1;
        }
        if (Math.abs(freePos - tmpIdx) > 2) {
            wall = 2;
        }
        for (_iX = 0; _iX < this.TOTAL_COL; ++_iX) {
            this._rectWorld[_iX][_iY] = _iY == 0 ? new Rectangle(Game._rectGameArea.x + _iX * this._sprCoralHorBlank1.getWidth(), this._rectWorld[_iX][this.TOTAL_ROW - 1].y - (this._sprCoralHorCorenr1.getHeight() + (this._sprCoralVer1.getHeight() >> 1)), this._sprCoralHorBlank1.getWidth(), this._sprCoralHorCorenr1.getHeight() + (this._sprCoralVer1.getHeight() >> 1)) : new Rectangle(Game._rectGameArea.x + _iX * this._sprCoralHorBlank1.getWidth(), this._rectWorld[_iX][_iY - 1].y - (this._sprCoralHorCorenr1.getHeight() + (this._sprCoralVer1.getHeight() >> 1)), this._sprCoralHorBlank1.getWidth(), this._sprCoralHorCorenr1.getHeight() + (this._sprCoralVer1.getHeight() >> 1));
            this._iTmpPositionXw[_iY] = this._rectWorld[_iX][_iY].y << 200 << 1;
            if (_iX == freePos && setPos == 0) {
                this._iWorld[_iX][_iY] = 1 + wall;
                ++setPos;
            } else {
                this._iWorld[_iX][_iY] = wall;
            }
            this._iScores[_iX][_iY] = 0;
        }
        setPos = 0;
    }

    public void paint(Graphics g, int status) {
        this.paintWorld(g);
        this.paintCharacter(g);
        g.setColor(0xFFFFFF);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void paintWorld(Graphics g) {
        int _iHorType = 0;
        int _iPosX = 0;
        int _iPosY = 0;
        int _iTmpPos = 0;
        boolean _bCorner = false;
        boolean _bCalculate = false;
        boolean _bSetPosition = false;
        int _iY = 0;
        while (_iY < this.TOTAL_ROW) {
            _bCalculate = false;
            _bSetPosition = false;
            _bCorner = true;
            _iHorType = 0;
            _iTmpPos = 0;
            _iPosX = 0;
            _iPosY = 0;
            for (int _iX = 0; _iX < this.TOTAL_COL; ++_iX) {
                block21: {
                    _iTmpPos = this._rectWorld[_iX][_iY].y + this._rectWorld[_iX][_iY].height;
                    if (this._iWorld[_iX][_iY] != 1 && this._iWorld[_iX][_iY] != 3) {
                        if (_iTmpPos >= -this._sprCoralVer1.getHeight()) {
                            if (!_bCalculate) {
                                ++_iHorType;
                            }
                            if (!_bSetPosition) {
                                _iPosX = _iX;
                                _iPosY = _iY;
                                _bSetPosition = true;
                            }
                            this._sprCoralHorBlank1.setPosition(this._rectWorld[_iX][_iPosY].x, this._rectWorld[_iX][_iPosY].y);
                            break block21;
                        } else {
                            _bCalculate = true;
                            continue;
                        }
                    }
                    _bCalculate = true;
                }
                if (this._iWorld[_iX][_iY] == 2) {
                    _bCorner = false;
                }
                _iPosY = _iY;
            }
            switch (_iHorType) {
                case 0: {
                    if (_bCorner) {
                        this._sprCoralHorCorenr4.setTransform(0);
                        this._sprCoralHorCorenr4.setPosition(this._rectWorld[_iPosX][_iPosY].x, this._rectWorld[_iPosX][_iPosY].y);
                        this._sprCoralHorCorenr4.paint(g);
                        this._sprCoralVer1.setTransform(0);
                        this._sprCoralVer1.setPosition(Game._rectGameArea.x + Game._rectGameArea.width - this._sprCoralVer1.getWidth(), this._rectWorld[_iPosX][_iPosY].y + (this._sprCoralVer1.getHeight() >> 1));
                        this._sprCoralVer1.paint(g);
                        this._sprCoralVer2.setTransform(2);
                        this._sprCoralVer2.setPosition(this._rectWorld[0][_iPosY].x, this._rectWorld[_iPosX][_iPosY].y);
                        this._sprCoralVer2.paint(g);
                        this._sprCoralVer1.setTransform(2);
                        this._sprCoralVer1.setPosition(this._rectWorld[0][_iPosY].x, this._rectWorld[_iPosX][_iPosY].y + (this._sprCoralVer1.getHeight() >> 1));
                        this._sprCoralVer1.paint(g);
                        break;
                    }
                    this._sprCoralHorBlank4.setTransform(0);
                    this._sprCoralHorBlank4.setPosition(this._rectWorld[_iPosX][_iPosY].x, this._rectWorld[_iPosX][_iPosY].y);
                    this._sprCoralHorBlank4.paint(g);
                    break;
                }
                case 1: {
                    if (_bCorner) {
                        this._sprCoralHorCorenr1.setTransform(2);
                        this._sprCoralHorCorenr1.setPosition(this._rectWorld[_iPosX][_iPosY].x, this._rectWorld[_iPosX][_iPosY].y);
                        this._sprCoralHorCorenr1.paint(g);
                        this._sprCoralVer2.setTransform(2);
                        this._sprCoralVer2.setPosition(this._rectWorld[0][_iPosY].x, this._rectWorld[_iPosX][_iPosY].y + (this._sprCoralVer1.getHeight() >> 1));
                        this._sprCoralVer2.paint(g);
                        this._sprCoralHorCorenr3.setTransform(0);
                        this._sprCoralHorCorenr3.setPosition(this._rectWorld[_iPosX + 2][_iPosY].x, this._rectWorld[_iPosX + 2][_iPosY].y);
                        this._sprCoralHorCorenr3.paint(g);
                        this._sprCoralVer3.setTransform(0);
                        this._sprCoralVer3.setPosition(Game._rectGameArea.x + Game._rectGameArea.width - this._sprCoralVer1.getWidth(), this._rectWorld[_iPosX][_iPosY].y + (this._sprCoralVer1.getHeight() >> 1));
                        this._sprCoralVer3.paint(g);
                        break;
                    }
                    this._sprCoralHorBlank1.setTransform(2);
                    this._sprCoralHorBlank1.setPosition(this._rectWorld[_iPosX][_iPosY].x, this._rectWorld[_iPosX][_iPosY].y);
                    this._sprCoralHorBlank1.paint(g);
                    this._sprCoralHorBlank3.setTransform(0);
                    this._sprCoralHorBlank3.setPosition(this._rectWorld[_iPosX + 2][_iPosY].x, this._rectWorld[_iPosX + 2][_iPosY].y);
                    this._sprCoralHorBlank3.paint(g);
                    break;
                }
                case 2: {
                    if (_bCorner) {
                        this._sprCoralHorCorenr2.setTransform(2);
                        this._sprCoralHorCorenr2.setPosition(this._rectWorld[_iPosX][_iPosY].x, this._rectWorld[_iPosX][_iPosY].y);
                        this._sprCoralHorCorenr2.paint(g);
                        this._sprCoralVer3.setTransform(2);
                        this._sprCoralVer3.setPosition(this._rectWorld[0][_iPosY].x, this._rectWorld[_iPosX][_iPosY].y + (this._sprCoralVer1.getHeight() >> 1));
                        this._sprCoralVer3.paint(g);
                        this._sprCoralHorCorenr2.setTransform(0);
                        this._sprCoralHorCorenr2.setPosition(this._rectWorld[_iPosX + 3][_iPosY].x, this._rectWorld[_iPosX + 3][_iPosY].y);
                        this._sprCoralHorCorenr2.paint(g);
                        this._sprCoralVer1.setTransform(0);
                        this._sprCoralVer1.setPosition(Game._rectGameArea.x + Game._rectGameArea.width - this._sprCoralVer1.getWidth(), this._rectWorld[_iPosX][_iPosY].y + (this._sprCoralVer1.getHeight() >> 1));
                        this._sprCoralVer1.paint(g);
                        break;
                    }
                    this._sprCoralHorBlank2.setTransform(2);
                    this._sprCoralHorBlank2.setPosition(this._rectWorld[_iPosX][_iPosY].x, this._rectWorld[_iPosX][_iPosY].y);
                    this._sprCoralHorBlank2.paint(g);
                    this._sprCoralHorBlank2.setTransform(0);
                    this._sprCoralHorBlank2.setPosition(this._rectWorld[_iPosX + 3][_iPosY].x, this._rectWorld[_iPosX + 3][_iPosY].y);
                    this._sprCoralHorBlank2.paint(g);
                    break;
                }
                case 3: {
                    if (_bCorner) {
                        this._sprCoralHorCorenr3.setTransform(2);
                        this._sprCoralHorCorenr3.setPosition(this._rectWorld[_iPosX][_iPosY].x, this._rectWorld[_iPosX][_iPosY].y);
                        this._sprCoralHorCorenr3.paint(g);
                        this._sprCoralVer1.setTransform(2);
                        this._sprCoralVer1.setPosition(this._rectWorld[0][_iPosY].x, this._rectWorld[_iPosX][_iPosY].y + (this._sprCoralVer1.getHeight() >> 1));
                        this._sprCoralVer1.paint(g);
                        this._sprCoralHorCorenr1.setTransform(0);
                        this._sprCoralHorCorenr1.setPosition(this._rectWorld[_iPosX + 4][_iPosY].x, this._rectWorld[_iPosX + 4][_iPosY].y);
                        this._sprCoralHorCorenr1.paint(g);
                        this._sprCoralVer2.setTransform(0);
                        this._sprCoralVer2.setPosition(Game._rectGameArea.x + Game._rectGameArea.width - this._sprCoralVer1.getWidth(), this._rectWorld[_iPosX][_iPosY].y + (this._sprCoralVer1.getHeight() >> 1));
                        this._sprCoralVer2.paint(g);
                        break;
                    }
                    this._sprCoralHorBlank3.setTransform(2);
                    this._sprCoralHorBlank3.setPosition(this._rectWorld[_iPosX][_iPosY].x, this._rectWorld[_iPosX][_iPosY].y);
                    this._sprCoralHorBlank3.paint(g);
                    this._sprCoralHorBlank1.setTransform(0);
                    this._sprCoralHorBlank1.setPosition(this._rectWorld[_iPosX + 4][_iPosY].x, this._rectWorld[_iPosX + 4][_iPosY].y);
                    this._sprCoralHorBlank1.paint(g);
                    break;
                }
                case 4: {
                    if (_bCorner) {
                        this._sprCoralHorCorenr4.setTransform(2);
                        this._sprCoralHorCorenr4.setPosition(this._rectWorld[_iPosX][_iPosY].x, this._rectWorld[_iPosX][_iPosY].y);
                        this._sprCoralHorCorenr4.paint(g);
                        this._sprCoralVer2.setTransform(2);
                        this._sprCoralVer2.setPosition(this._rectWorld[0][_iPosY].x, this._rectWorld[_iPosX][_iPosY].y + (this._sprCoralVer1.getHeight() >> 1));
                        this._sprCoralVer2.paint(g);
                        this._sprCoralVer2.setTransform(0);
                        this._sprCoralVer2.setPosition(Game._rectGameArea.x + Game._rectGameArea.width - this._sprCoralVer1.getWidth(), this._rectWorld[_iPosX][_iPosY].y);
                        this._sprCoralVer2.paint(g);
                        this._sprCoralVer2.setTransform(0);
                        this._sprCoralVer2.setPosition(Game._rectGameArea.x + Game._rectGameArea.width - this._sprCoralVer1.getWidth(), this._rectWorld[_iPosX][_iPosY].y + (this._sprCoralVer1.getHeight() >> 1));
                        this._sprCoralVer2.paint(g);
                        break;
                    }
                    this._sprCoralHorBlank4.setTransform(2);
                    this._sprCoralHorBlank4.setPosition(this._rectWorld[_iPosX][_iPosY].x, this._rectWorld[_iPosX][_iPosY].y);
                    this._sprCoralHorBlank4.paint(g);
                    break;
                }
                default: {
                    if (this._bCheck) break;
                    System.out.println("case default");
                    this._bCheck = true;
                }
            }
            _iHorType = 0;
            ++_iY;
        }
        return;
    }

    private void paintCharacter(Graphics g) {
        this._sprChar.setPosition(this._rectChar.x, this._rectChar.y);
        Particles.paint(g, 0);
        this._sprChar.paint(g);
    }

    private void checkScore() {
    }

    public void rotate() {
        if (this._iStatus == 0) {
            this._iStatus = 1;
            return;
        }
    }

    public void DragOrDrop() {
    }

    public void releaaseControls() {
        this._pressed = false;
        this.endMoveLeft();
        this.endMoveRight();
    }

    public void pointerPressed(int x, int y) {
        if (!this._pressed) {
            this._pressed = true;
            if (x < Game._rectGameArea.width >> 1) {
                this.startMoveLeft();
            } else {
                this.startMoveRight();
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this._pressed) {
            this.endMoveLeft();
            this.endMoveRight();
            this._pressed = false;
        }
    }

    public int getScore() {
        return this._iScore;
    }

    public boolean isGameOver() {
        return this._iStatus == 3;
    }

    public boolean isLevelDone() {
        return this._iStatus == 2;
    }

    public boolean isInitGame() {
        return this._iStatus == 0;
    }

    public void moveLeft() {
        this._iTmpPositionX -= this._iTmpShift;
        this._rectChar.x = this._iTmpPositionX >> 2;
        if (this._rectChar.x < Game._rectGameArea.x) {
            this._rectChar.x = Game._rectGameArea.width;
            this._iTmpDefaultPositionX = this._iTmpPositionX = this._rectChar.x << 2;
        }
    }

    public void moveRight() {
        this._iTmpPositionX += this._iTmpShift;
        this._rectChar.x = this._iTmpPositionX >> 2;
        if (this._rectChar.x > Game._rectGameArea.width) {
            this._rectChar.x = Game._rectGameArea.x;
            this._iTmpDefaultPositionX = this._iTmpPositionX = this._rectChar.x << 2;
        }
    }

    public void startMoveLeft() {
        this._stsrtMoveLeft = true;
        this._stsrtMoveRight = false;
    }

    public void startMoveRight() {
        this._stsrtMoveLeft = false;
        this._stsrtMoveRight = true;
    }

    public void endMoveLeft() {
        this._stsrtMoveLeft = false;
    }

    public void endMoveRight() {
        this._stsrtMoveRight = false;
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
    }
}

