/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenSplash;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenLanguage
implements IScreen {
    private MainCanvas mainCanvas;
    private static String[] langCodes = new String[]{"en", "de", "fr", "es", "pt", "it"};
    private Rectangle[] rectItems = new Rectangle[6];
    private static int _WIDTH = 0;
    private static int _HEIGHT = 0;
    private int[] _animationSequence = new int[6];
    private AnimationComponent[] _animationComponents = new AnimationComponent[6];
    private int selectedCompId;
    private static final int selectorPadding = 0;
    int _iColorBg = 15691352;
    private boolean _bChangeScreen = false;
    int x;
    int y;

    public ScreenLanguage(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
        this.initDimensions();
    }

    private void initDimensions() {
        _WIDTH = this.mainCanvas.getWidth();
        _HEIGHT = this.mainCanvas.getHeight();
    }

    public void beforeShow() {
        Resources.loadSprite(0);
        this.calculatePositions();
        this.selectedCompId = 0;
        this.calculateSelectorPos();
    }

    public void afterHide() {
        Resources.freeSprite(0);
    }

    public void beforeInteruption() {
    }

    public void afterInteruption() {
    }

    private void calculatePositions() {
        int btnWidth = Resources.resSprs[0].getWidth();
        int btnHeight = Resources.resSprs[0].getHeight();
        int spaceX = (MainCanvas.WIDTH - btnWidth * 2) / 3;
        int spaceY = (MainCanvas.HEIGHT - btnHeight * 3) / 4;
        for (int i = 0; i < 6; ++i) {
            this.rectItems[i] = new Rectangle(spaceX + i % 2 * (btnWidth + spaceX), spaceY + i / 2 * (btnHeight + spaceY), btnWidth, btnHeight);
        }
        this.showAnimationComponents();
    }

    private void showAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this.rectItems[0], _WIDTH, _HEIGHT);
        this._animationComponents[0].startShowAnimation(4);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectItems[1], _WIDTH, _HEIGHT);
        this._animationComponents[1].startShowAnimation(5);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectItems[2], _WIDTH, _HEIGHT);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectItems[3], _WIDTH, _HEIGHT);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this.rectItems[4], _WIDTH, _HEIGHT);
        this._animationComponents[4].startShowAnimation(6);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this.rectItems[5], _WIDTH, _HEIGHT);
        this._animationComponents[5].startShowAnimation(7);
    }

    private void hideAnimationComponents() {
        this._animationComponents[0].startHideAnimation(4);
        this._animationComponents[1].startHideAnimation(5);
        this._animationComponents[2].startHideAnimation(0);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(6);
        this._animationComponents[5].startHideAnimation(7);
    }

    private void calculateSelectorPos() {
        if (MainCanvas.touchActivated) {
            return;
        }
    }

    public void update(long lastRunLenght) {
        this.animationComponentsUpdate();
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (this._bChangeScreen && !_return) {
            this.changeScreen();
        }
    }

    private void hideLanguage() {
        this.changeScreen();
    }

    private void changeScreen() {
        Resources.initLangDirs(langCodes[this.selectedCompId]);
        this.mainCanvas.changeLastActiveScreen(new ScreenSplash(this.mainCanvas));
    }

    public void keyPressed(int keyCode) {
        this.mainCanvas.repaint();
    }

    public void keyReleased(int keyCode) {
        if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
            if (Keys.isActionGeneratedByKey(3, keyCode)) {
                if (this.selectedCompId % 2 == 1) {
                    --this.selectedCompId;
                    this.calculateSelectorPos();
                }
            } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
                if (this.selectedCompId % 2 == 0) {
                    ++this.selectedCompId;
                    this.calculateSelectorPos();
                }
            } else if (Keys.isActionGeneratedByKey(1, keyCode)) {
                if (this.selectedCompId / 2 > 0) {
                    this.selectedCompId -= 2;
                    this.calculateSelectorPos();
                }
            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                if (this.selectedCompId != 5 && this.selectedCompId != 4 && this.selectedCompId / 2 < 3) {
                    this.selectedCompId += 2;
                    this.calculateSelectorPos();
                }
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                this.hideLanguage();
            } else if (Keys.isActionGeneratedByKey(-21, keyCode)) {
                Resources.initLangDirs(langCodes[this.selectedCompId]);
            } else if (Keys.isActionGeneratedByKey(-22, keyCode)) {
                Resources.initLangDirs(langCodes[this.selectedCompId]);
            }
        }
        this.mainCanvas.repaint();
        this.mainCanvas.repaint();
    }

    public void paint(Graphics g) {
        Sprite flag = Resources.resSprs[0];
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.mainCanvas.getWidth(), this.mainCanvas.getHeight());
        if (MainCanvas.touchActivated) {
            flag.setFrame(0);
            flag.setPosition(this.rectItems[0].x, this.rectItems[0].y);
            flag.paint(g);
            flag.setFrame(2);
            flag.setPosition(this.rectItems[1].x, this.rectItems[1].y);
            flag.paint(g);
            flag.setFrame(4);
            flag.setPosition(this.rectItems[2].x, this.rectItems[2].y);
            flag.paint(g);
            flag.setFrame(6);
            flag.setPosition(this.rectItems[3].x, this.rectItems[3].y);
            flag.paint(g);
            flag.setFrame(8);
            flag.setPosition(this.rectItems[4].x, this.rectItems[4].y);
            flag.paint(g);
            flag.setFrame(10);
            flag.setPosition(this.rectItems[5].x, this.rectItems[5].y);
            flag.paint(g);
        } else {
            flag.setFrame(this.selectedCompId == 0 ? 0 : 1);
            flag.setPosition(this.rectItems[0].x, this.rectItems[0].y);
            flag.paint(g);
            flag.setFrame(this.selectedCompId == 1 ? 2 : 3);
            flag.setPosition(this.rectItems[1].x, this.rectItems[1].y);
            flag.paint(g);
            flag.setFrame(this.selectedCompId == 2 ? 4 : 5);
            flag.setPosition(this.rectItems[2].x, this.rectItems[2].y);
            flag.paint(g);
            flag.setFrame(this.selectedCompId == 3 ? 6 : 7);
            flag.setPosition(this.rectItems[3].x, this.rectItems[3].y);
            flag.paint(g);
            flag.setFrame(this.selectedCompId == 4 ? 8 : 9);
            flag.setPosition(this.rectItems[4].x, this.rectItems[4].y);
            flag.paint(g);
            flag.setFrame(this.selectedCompId == 5 ? 10 : 11);
            flag.setPosition(this.rectItems[5].x, this.rectItems[5].y);
            flag.paint(g);
        }
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            switch (this.selectedCompId) {
                default: 
            }
            Keys.keyPressed(53);
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems[this.selectedCompId].contains(x, y)) {
            switch (this.selectedCompId) {
                default: 
            }
            Keys.keyReleased(53);
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this.selectedCompId) {
            default: 
        }
        if (Keys.isKeyPressed(53)) {
            this.keyReleased(53);
            Keys.keyReleased(53);
        }
    }
}

