/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class Menu
extends FullCanvas
implements Runnable {
    public static boolean[] keys = new boolean[7];
    public static int UP = 0;
    public static int DOWN = 1;
    public static int LEFT = 2;
    public static int RIGHT = 3;
    public static int FIRE = 4;
    public static int SOFT_L = 5;
    public static int SOFT_R = 6;
    private static long LOGO_DELAY = 3000L;
    private static long lastTime;
    protected static boolean active;
    public static Menu instance;
    private static boolean running;
    public static int W;
    public static int H;
    public static final int SCENE_MAIN = 0;
    public static final int SCENE_HELP = 1;
    public static final int SCENE_ABOUT = 2;
    public static final int SCENE_SOUND_QUERY = 3;
    public static final int SCENE_LOAD = 4;
    public static final int SCENE_LOGO = 5;
    public static final int SCENE_OPTIONS = 6;
    public static final int SCENE_EXIT_QUERY = 7;
    public static final int SCENE_GAME = 8;
    public static final int SCENE_CONTINUE = 9;
    public static final int SCENE_LANG = 10;
    public static int curScene;
    public static final int SC_TYPE_LIST = 0;
    public static final int SC_TYPE_LOGO = -2;
    public static final int SC_TYPE_LOAD = -1;
    public static final int SC_TYPE_TEXT = 2;
    public static final int SC_TYPE_GAME = -3;
    public static Image img;
    public static final short[][] SC_DATA;
    public static final int[][] itemList;
    public static int itemMaxVis;
    public static int itemCnt;
    public static int curItem;
    public static int itemShift;
    public static int[] curList;
    public static int itemTop;
    public static int header;
    public static int softL;
    public static int softR;
    public static short[] parsed;
    public static byte[] txt;
    public static int scroll;
    public static int itemH;
    public static int loadCnt;
    public static final String RS_GAME = "bobr.save";
    public static final String RS_OPT = "bobr.save.opt";

    private static void drawBox(Graphics g, int x, int y, int w, int h) {
        g.setClip(x, y, w, h);
        g.setColor(2630685);
        g.fillRect(x, y, w, h);
        g.setColor(0);
        g.drawRect(x, y, w, h);
    }

    private static void drawButton(Graphics g, int x, int y, boolean active, int w, int txt) {
        g.setClip(x, y, w, itemH);
        g.setColor(active ? 13936741 : 6307621);
        g.fillRect(x, y, w, itemH);
        g.setColor(active ? 15319696 : 3481105);
        g.drawRect(x, y, w - 1, itemH - 1);
        FontText.renderText(g, txt, x + w / 2, y + itemH / 2, 5);
    }

    private static void drawHeader(Graphics g, int header) {
        g.setClip(0, 0, W, itemH);
        g.setColor(6307621);
        g.fillRect(0, 0, W, itemH);
        g.setColor(6307621);
        g.drawRect(0, 0, W - 1, itemH - 1);
        FontText.renderText(g, header, W / 2, 0, 1);
    }

    public static void drawLoadBar(Graphics g) {
        g.setClip(0, 0, W, H);
        g.drawImage(img, 0, 0, 4 | 0x10);
        g.setColor(0);
        g.fillRect(0, H - 4, W, 4);
        g.setColor(255, 191, 0);
        g.fillRect(0, H - 3, W * curItem / (loadCnt + 2), 3);
    }

    public static void drawSoftBar(Graphics g, int softL, int softR) {
        g.setClip(0, H - itemH, W, H);
        g.setColor(0);
        g.fillRect(0, H - itemH, W, H);
        g.setColor(0);
        g.drawRect(0, H - itemH, W - 1, H - 1);
        if (softL != -1) {
            Menu.drawSoftL(g, softL);
        }
        if (softR != -1) {
            Menu.drawSoftR(g, softR);
        }
    }

    public static void drawSoftL(Graphics g, int softL) {
        FontText.renderText(g, softL, 0, H, 8);
    }

    public static void drawSoftR(Graphics g, int softR) {
        FontText.renderText(g, softR, W, H, 10);
    }

    private static boolean isActive() {
        return active;
    }

    public void nextLoadPhase(int i) {
    }

    public void newGame() {
        active = true;
    }

    public void pauseGame() {
    }

    public void resumeGame() {
    }

    public Menu() {
        instance = this;
        new Thread(this).start();
    }

    protected void paint(Graphics g) {
        if (!running) {
            return;
        }
        if (SC_DATA[curScene][0] == -3) {
            this.gameLoop(g);
            return;
        }
        Menu.updateScene();
        this.drawBG(g);
        Menu.renderScene(g);
    }

    public void run() {
        W = this.getWidth();
        H = this.getHeight();
        Menu.setNextScene(5);
        running = true;
        while (running) {
            this.repaint();
            this.serviceRepaints();
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {}
        }
        try {
            Mid.ins.destroyApp(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void resetKeys() {
        for (int i = 0; i < keys.length; ++i) {
            Menu.keys[i] = false;
        }
    }

    protected void keyReleased(int key) {
        if (key == 54 || key == -4) {
            Menu.keys[Menu.RIGHT] = false;
            this.numKeyReleased(6);
        } else if (key == 52 || key == -3) {
            Menu.keys[Menu.LEFT] = false;
            this.numKeyReleased(4);
        } else if (key == 50 || key == -1) {
            Menu.keys[Menu.UP] = false;
            this.numKeyReleased(2);
        } else if (key == 56 || key == -2) {
            Menu.keys[Menu.DOWN] = false;
            this.numKeyReleased(8);
        } else if (key == 57) {
            this.numKeyReleased(9);
        } else if (key == 51) {
            this.numKeyReleased(3);
        } else if (key == 49) {
            this.numKeyReleased(1);
        } else if (key == 48) {
            this.numKeyReleased(0);
        } else if (key != 35) {
            if (key == 55) {
                this.numKeyReleased(7);
            } else if (key == 53 || key == -5) {
                Menu.keys[Menu.FIRE] = false;
                this.numKeyReleased(5);
            } else if (key == -6) {
                Menu.keys[Menu.SOFT_L] = false;
            } else if (key == -7) {
                Menu.keys[Menu.SOFT_R] = false;
            }
        }
    }

    protected void keyPressed(int key) {
        if (key == 54 || key == -4) {
            Menu.keys[Menu.RIGHT] = true;
            this.gameKey(RIGHT);
            this.numKeyPressed(6);
        } else if (key == 52 || key == -3) {
            Menu.keys[Menu.LEFT] = true;
            this.gameKey(LEFT);
            this.numKeyPressed(4);
        } else if (key == 50 || key == -1) {
            Menu.keys[Menu.UP] = true;
            this.gameKey(UP);
            this.numKeyPressed(2);
        } else if (key == 56 || key == -2) {
            Menu.keys[Menu.DOWN] = true;
            this.gameKey(DOWN);
            this.numKeyPressed(8);
        } else if (key == 57) {
            this.numKeyPressed(9);
        } else if (key == 51) {
            this.numKeyPressed(3);
        } else if (key == 49) {
            this.numKeyPressed(1);
        } else if (key == 48) {
            this.numKeyPressed(0);
        } else if (key != 35) {
            if (key == 55) {
                this.numKeyPressed(7);
            } else if (key == 53 || key == -5) {
                Menu.keys[Menu.FIRE] = true;
                this.gameKey(FIRE);
                this.numKeyPressed(5);
            } else if (key == -6) {
                Menu.keys[Menu.SOFT_L] = true;
                this.gameKey(SOFT_L);
            } else if (key == -7) {
                Menu.keys[Menu.SOFT_R] = true;
                this.gameKey(SOFT_R);
            }
        }
    }

    public void drawBG(Graphics g) {
        g.setClip(0, 0, W, H);
        g.setColor(0x222222);
        g.fillRect(0, 0, W, H);
    }

    public void gameKey(int key) {
    }

    public void numKeyReleased(int key) {
    }

    public void numKeyPressed(int key) {
    }

    public static void setNextScene(int nextScene) {
        Menu.resetKeys();
        if (nextScene == 0) {
            Snd.sndPlay(0);
        } else {
            Snd.stopAllSounds();
        }
        if (curScene == 6 || curScene == 10) {
            Menu.saveOpt();
        }
        if (nextScene == -1) {
            return;
        }
        Menu.constructScene(nextScene);
        curScene = nextScene;
    }

    public static void constructScene(int scene) {
        short[] data = SC_DATA[scene];
        short type = data[0];
        header = data[1];
        softL = data[2];
        softR = data[3];
        if (data[4] != -1) {
            try {
                img = Image.createImage((String)("/" + data[4] + ".png"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            img = null;
        }
        switch (type) {
            case 0: {
                try {
                    itemTop = itemH;
                    if (img != null) {
                        itemTop += img.getHeight();
                    }
                    curItem = 0;
                    itemShift = 0;
                    if (data[8] == -1) {
                        curList = new int[FontText.getFontCng() * 2];
                        for (int i = 0; i < curList.length; ++i) {
                            Menu.curList[i] = -10 - i / 2;
                        }
                    } else {
                        curList = itemList[data[8]];
                        if ((Menu.hasRS(RS_GAME) || Menu.isActive()) && scene == 0) {
                            curList = itemList[data[8] + 1];
                        }
                    }
                    itemCnt = curList.length / 2;
                    itemMaxVis = Math.min(itemCnt, (H - itemH - itemTop) / (itemH + 3));
                    itemTop = H / 2 - itemMaxVis * (itemH + 3) / 2;
                }
                catch (Exception e) {}
                break;
            }
            case -2: {
                curItem = 0;
                lastTime = 0L;
                break;
            }
            case 2: {
                parsed = FontText.parseText(data[7], W);
                break;
            }
            case -1: {
                curItem = 0;
                try {
                    img = Image.createImage((String)"/splash.png");
                }
                catch (Exception exception) {}
                break;
            }
            case -3: {
                if (scene == 8) {
                    instance.newGame();
                    break;
                }
                if (Menu.isActive()) {
                    instance.resumeGame();
                    break;
                }
                instance.loadGame();
            }
        }
        System.gc();
    }

    public static void renderScene(Graphics g) {
        g.setClip(0, 0, W, H);
        g.setColor(4073752);
        g.fillRect(0, 0, W, H);
        int buttH = itemH;
        if (header != -1) {
            Menu.drawHeader(g, header);
        }
        Menu.drawSoftBar(g, softL, softR);
        if (img != null && SC_DATA[curScene][0] >= 0) {
            g.setClip(0, 0, W, H);
            g.drawImage(img, W / 2, buttH + 2, 17);
        }
        switch (SC_DATA[curScene][0]) {
            case 0: {
                for (int i = 0; i < itemMaxVis; ++i) {
                    Menu.drawButton(g, W / 40, itemTop + i * (buttH + 3), i + itemShift == curItem, W * 19 / 20, curList[(i + itemShift) * 2]);
                }
                break;
            }
            case 2: {
                Menu.drawBox(g, 0, buttH, W, H - buttH * 2);
                scroll = FontText.renderParseText(g, parsed, scroll, new int[]{0, buttH, W, H - buttH}, 5);
                break;
            }
            case -2: {
                g.setClip(0, 0, W, H);
                g.setColor(-1);
                g.fillRect(0, 0, W, H);
                g.drawImage(img, W / 2, H / 2, 3);
                break;
            }
            case -1: {
                Menu.drawLoadBar(g);
                g.setClip(0, 0, W, H);
                g.setColor(-1);
            }
        }
    }

    public static void updateScene() {
        if (SC_DATA[curScene][0] == -1) {
            switch (curItem) {
                case 0: {
                    FontText.loadFonts("f");
                    break;
                }
                case 1: {
                    FontText.loadTexts("t");
                    break;
                }
                default: {
                    if (curItem > loadCnt + 1) {
                        if (Menu.hasRS(RS_OPT)) {
                            Menu.loadOpt();
                            Menu.setNextScene(0);
                        } else {
                            Menu.setNextScene(10);
                        }
                        return;
                    }
                    instance.nextLoadPhase(curItem - 2);
                }
            }
            ++curItem;
            return;
        }
        if (SC_DATA[curScene][0] == -2) {
            try {
                W = instance.getWidth();
                H = instance.getHeight();
                long time = System.currentTimeMillis();
                if (time - lastTime > LOGO_DELAY) {
                    img = Image.createImage((String)("/l" + curItem + ".png"));
                    ++curItem;
                    lastTime = time;
                }
                return;
            }
            catch (Exception e) {
                Menu.setNextScene(4);
            }
        } else if (SC_DATA[curScene][0] == 0) {
            if (keys[UP]) {
                Menu.keys[Menu.UP] = false;
                if (curItem <= itemShift) {
                    if (itemShift > 0) {
                        --itemShift;
                        --curItem;
                    } else {
                        curItem = itemCnt - 1;
                        itemShift = Math.max(itemCnt - itemMaxVis, 0);
                    }
                } else {
                    --curItem;
                }
            } else if (keys[DOWN]) {
                Menu.keys[Menu.DOWN] = false;
                if (curItem < itemMaxVis + itemShift - 1) {
                    curItem = curItem < itemCnt - 1 ? ++curItem : 0;
                } else if (itemShift < itemCnt - itemMaxVis) {
                    ++itemShift;
                    ++curItem;
                } else {
                    curItem = 0;
                    itemShift = 0;
                }
            }
        }
        Menu.processSoft();
    }

    public static void processSoft() {
        if (keys[SOFT_R]) {
            Menu.keys[Menu.SOFT_R] = false;
            Menu.setNextScene(SC_DATA[curScene][5]);
        } else if (keys[SOFT_L] || keys[FIRE]) {
            Menu.keys[Menu.FIRE] = false;
            Menu.keys[Menu.SOFT_L] = false;
            if (curScene == 3) {
                Data.isSoundOn = true;
                Menu.setNextScene(0);
                return;
            }
            if (curScene == 10) {
                FontText.curLang = curItem;
                if (Menu.hasRS(RS_OPT)) {
                    Menu.setNextScene(0);
                } else {
                    Menu.setNextScene(3);
                }
                return;
            }
            if (curScene == 6) {
                if (curItem == 0) {
                    Data.isSoundOn = !Data.isSoundOn;
                } else {
                    Menu.setNextScene(10);
                }
                Menu.saveOpt();
                return;
            }
            if (curScene == 7) {
                try {
                    running = false;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return;
            }
            int next = SC_DATA[curScene][6];
            if (SC_DATA[curScene][0] == 0) {
                next = curList[curItem * 2 + 1];
            }
            Menu.setNextScene(next);
        }
    }

    public void gameLoop(Graphics g) {
    }

    public static void setloadCnt(int i) {
        loadCnt = i + 2;
    }

    public void loadGame() {
        DataInputStream dis = Menu.recordGet(RS_GAME);
        try {
            Game.LEV = (byte)dis.readInt();
            System.out.println("load level " + Game.LEV + 1);
            Guys.TOTAL_KILLED = dis.readInt();
            Guys.TOTAL_FAILED = dis.readInt();
            Coin.TOTAL_GOLD = dis.readInt();
            Data.isSoundOn = dis.readBoolean();
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveGame() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(Game.LEV);
            System.out.println("save " + Game.LEV + 1);
            dos.writeInt(Guys.TOTAL_KILLED);
            dos.writeInt(Guys.TOTAL_FAILED);
            dos.writeInt(Coin.TOTAL_GOLD);
            dos.writeBoolean(Data.isSoundOn);
            Menu.recordSet(baos, RS_GAME);
            dos.close();
            baos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadOpt() {
        try {
            DataInputStream dis = Menu.recordGet(RS_OPT);
            Data.isSoundOn = dis.readBoolean();
            Data.isVibraOn = dis.readBoolean();
            FontText.curLang = dis.readByte();
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveOpt() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeBoolean(Data.isSoundOn);
            dos.writeBoolean(Data.isVibraOn);
            dos.writeByte(FontText.curLang);
            Menu.recordSet(baos, RS_OPT);
            dos.close();
            baos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final DataInputStream recordGet(String recordName) {
        try {
            RecordStore record = RecordStore.openRecordStore((String)recordName, (boolean)false);
            byte[] data = record.getRecord(1);
            record.closeRecordStore();
            return new DataInputStream(new ByteArrayInputStream(data));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final boolean hasRS(String a_name) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)a_name, (boolean)false);
            rs.closeRecordStore();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean recordSet(ByteArrayOutputStream baos, String name) {
        boolean result = false;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)name, (boolean)true);
            try {
                rs.setRecord(1, baos.toByteArray(), 0, baos.size());
            }
            catch (Exception e) {
                rs.addRecord(baos.toByteArray(), 0, baos.size());
                e.printStackTrace();
            }
            rs.closeRecordStore();
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean fileExist(String fileName) {
        boolean result = false;
        try {
            InputStream is = ((Object)((Object)Mid.ins)).getClass().getResourceAsStream(fileName);
            if (is != null) {
                result = true;
                is.close();
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    protected void hideNotify() {
        this.pauseGame();
        Snd.stopAllSounds();
    }

    protected void showNotify() {
        if (SC_DATA[curScene][0] == -3) {
            Menu.setNextScene(0);
        }
    }

    static {
        active = false;
        curScene = 0;
        SC_DATA = new short[][]{{0, 9, 23, 7, -1, 7, -1, -1, 0}, {2, 4, -1, 9, -1, 0, -1, 26}, {2, 5, -1, 9, -1, 0, -1, 27}, {2, 11, 21, 22, -1, 0, -1, 28}, {-1, -1, -1, -1, -1, -1, -1, -1}, {-2, -1, -1, -1, -1, -1, -1, -1}, {0, 3, 23, 10, -1, 0, -1, -1, 2}, {2, 7, 21, 22, -1, 0, -1, 7}, {-3, -1, -1, -1, -1, -1, -1}, {-3, -1, -1, -1, -1, -1, -1}, {0, 14, 23, -1, -1, -1, -1, -1, -1}};
        itemList = new int[][]{{2, 8, 3, 6, 5, 2, 4, 1, 7, 7}, {8, 9, 2, 8, 3, 6, 5, 2, 4, 1, 7, 7}, {-2, -1, 14, -1}};
        itemMaxVis = 0;
        itemCnt = 0;
        curItem = 0;
        itemShift = 0;
        itemTop = 0;
        header = 0;
        softL = 0;
        softR = 0;
        itemH = 20;
        loadCnt = 0;
    }
}

