/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Utils {
    public static final int _FNT_COUNT = 3;
    public static final int RC_L = 0;
    public static final int RC_T = 1;
    public static final int RC_R = 2;
    public static final int RC_B = 3;
    private static final byte[][] _FontX = new byte[3][];
    private static final byte[][] _FontY = new byte[3][];
    private static final byte[][] _FontW = new byte[3][];
    private static final byte[] _FontH = new byte[3];
    private static final byte[] _FontSpace = new byte[3];
    private static final byte[] _FontShadowSize = new byte[3];
    public static final Image[] _FontImage = new Image[3];
    private static short[] _TextIndexes;
    private static byte[] _Texts;
    static final int SYMBOL_SPACE = -1;

    Utils() {
    }

    public static final DataInputStream getFile(String string) {
        return new DataInputStream(GameMidlet.midlet.getClass().getResourceAsStream("/" + string));
    }

    public static final byte[] readByteArray(DataInputStream dataInputStream, int n) throws Exception {
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray);
        return byArray;
    }

    public static final short[] readShortArray(DataInputStream dataInputStream, int n) throws Exception {
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = dataInputStream.readShort();
        }
        return sArray;
    }

    public static final void loadFont(int n) throws Exception {
        if (_FontImage[n] == null) {
            DataInputStream dataInputStream = Utils.getFile("f" + n + ".def");
            int n2 = dataInputStream.readUnsignedByte();
            Utils._FontX[n] = Utils.readByteArray(dataInputStream, n2);
            Utils._FontY[n] = Utils.readByteArray(dataInputStream, n2);
            Utils._FontW[n] = Utils.readByteArray(dataInputStream, n2);
            Utils._FontH[n] = dataInputStream.readByte();
            Utils._FontSpace[n] = dataInputStream.readByte();
            Utils._FontShadowSize[n] = dataInputStream.readByte();
            Utils._FontImage[n] = Utils.getImage("/f" + n + ".png");
        }
    }

    public static final int symbolWidth(int n, int n2) {
        if (n2 < 0) {
            return _FontSpace[n] + 2;
        }
        return _FontW[n][n2];
    }

    protected static final int renderSymbol(Graphics graphics, int n, int n2, int n3, int n4, int n5, int[] nArray) {
        byte by;
        int n6 = n2 & 0xFF;
        if (n6 < 240) {
            n2 = n6;
        }
        byte by2 = by = n2 < 0 ? _FontSpace[n] : _FontW[n][n2];
        if (n2 >= 0) {
            int n7 = Utils.textHeight(n);
            Utils.setClip(graphics, nArray);
            graphics.clipRect(n3 += Utils.getAnchorX(by, n5), n4 += Utils.getAnchorY(n7, n5), (int)by, n7);
            graphics.drawImage(_FontImage[n], n3 - _FontX[n][n2], n4 - _FontY[n][n2], 0);
        }
        return Utils.symbolWidth(n, n2);
    }

    protected static final int getAnchorX(int n, int n2) {
        if ((n2 & 1) == 1) {
            return -(n >>> 1);
        }
        if ((n2 & 8) == 8) {
            return -n;
        }
        return 0;
    }

    protected static final int getAnchorY(int n, int n2) {
        if ((n2 & 2) == 2) {
            return -(n >>> 1);
        }
        if ((n2 & 0x20) == 32) {
            return -n;
        }
        return 0;
    }

    public static final void loadTextSet(int n) throws Exception {
        DataInputStream dataInputStream = Utils.getFile("t" + n);
        _TextIndexes = Utils.readShortArray(dataInputStream, dataInputStream.readUnsignedShort());
        _Texts = Utils.readByteArray(dataInputStream, dataInputStream.readUnsignedShort());
    }

    public static final int textLength(int n) {
        return _TextIndexes[n + 1] - _TextIndexes[n];
    }

    public static final int textWidth(int n, int n2) {
        return Utils.textWidth(n, _Texts, (int)_TextIndexes[n2], (int)_TextIndexes[n2 + 1]);
    }

    public static final int textWidth(int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        for (int i = n2; i < n3; ++i) {
            n4 += Utils.symbolWidth(n, byArray[i]) + 1 - _FontShadowSize[n];
        }
        return n4;
    }

    public static final int textHeight(int n) {
        return _FontH[n];
    }

    public static final void renderText(Graphics graphics, int n, int n2, int n3, int n4, int n5, int[] nArray) {
        Utils.renderText(graphics, n, _Texts, (int)_TextIndexes[n2], (int)_TextIndexes[n2 + 1], n3, n4, n5, nArray);
    }

    public static final void renderText(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        Utils.renderText(graphics, n, _Texts, _TextIndexes[n2] + n3, _TextIndexes[n2] + n3 + n4, n5, n6, n7, nArray);
    }

    protected static final void renderText(Graphics graphics, int n, byte[] byArray, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        int n7 = Utils.textWidth(n, byArray, n2, n3);
        n4 += Utils.getAnchorX(n7, n6);
        int n8 = Utils.textHeight(n);
        n5 += Utils.getAnchorY(n8, n6);
        for (int i = n2; i < n3; ++i) {
            n4 += Utils.renderSymbol(graphics, n, byArray[i], n4, n5, 0, nArray);
        }
    }

    public static final void setClip(Graphics graphics, int[] nArray) {
        graphics.setClip(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
    }

    static final boolean setClip(int[] nArray, Graphics graphics) {
        return Utils.setClip(nArray[0], nArray[1], nArray[2], nArray[3], graphics);
    }

    static final boolean setClip(int n, int n2, int n3, int n4, Graphics graphics) {
        if (n < -graphics.getTranslateX()) {
            n3 += n + graphics.getTranslateX();
            n = -graphics.getTranslateX();
        }
        if (n2 < -graphics.getTranslateY()) {
            n4 += n2 + graphics.getTranslateY();
            n2 = -graphics.getTranslateY();
        }
        if (n + n3 > 128) {
            n3 = 128 - n;
        }
        if (n2 + n4 > 160) {
            n4 = 160 - n2;
        }
        if (n3 > 0 && n4 > 0) {
            graphics.setClip(n, n2, n3, n4);
            return true;
        }
        return false;
    }

    static Image getImage(String string) {
        Image image = null;
        System.out.println("getImage " + string);
        try {
            image = Image.createImage((String)string);
        }
        catch (IOException iOException) {
            System.out.println("Error " + string);
            iOException.printStackTrace();
        }
        return image;
    }

    static final Vector parseText(int n, int n2, int n3) {
        Vector<int[]> vector = new Vector<int[]>();
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        n4 = n5;
        int[] nArray = new int[2];
        while (true) {
            if ((n5 = Utils.indexOf(n, -1, n6)) == -1) {
                n5 = Utils.textLength(n);
            }
            if (Utils.textWidth(n3, n, n4, n5 - 1) > n2) {
                nArray = new int[]{n4, n6 - n4};
                vector.addElement(nArray);
                n4 = n6++;
                continue;
            }
            if (n5 == Utils.textLength(n)) break;
            n6 = n5 + 1;
        }
        nArray = new int[]{n4, n5 - n4};
        vector.addElement(nArray);
        return vector;
    }

    static int indexOf(int n, int n2, int n3) {
        for (int i = _TextIndexes[n] + n3; i < _TextIndexes[n + 1]; ++i) {
            if (_Texts[i] != n2) continue;
            return i - _TextIndexes[n];
        }
        return -1;
    }

    static int textWidth(int n, int n2, int n3, int n4) {
        Utils.textWidth(n, _Texts, _TextIndexes[n2] + n3, _TextIndexes[n2] + n4);
        return Utils.textWidth(n, _Texts, _TextIndexes[n2] + n3, _TextIndexes[n2] + n4);
    }
}

