/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

final class MainCanvas
extends Canvas
implements Runnable {
    private static MainCanvasInterface canvas;
    static MainCanvas This;
    static final int KEY_LEFT = -3;
    static final int KEY_RIGHT = -4;
    static final int KEY_UP = -1;
    static final int KEY_DOWN = -2;
    static final int KEY_SOFT1 = 42;
    static final int KEY_SOFT2 = 35;
    static final int KEY_SOFT3 = 100;
    static final int KEY_FIRE = -5;
    static final Vector PressedKeyVector;
    private static final Vector PressedKeyVectorOnce;
    private static final Vector ReleasedKeyVectorOnce;
    static final int KEY_NUM0 = 48;
    static final int KEY_NUM1 = 49;
    static final int KEY_NUM2 = 50;
    static final int KEY_NUM3 = 51;
    static final int KEY_NUM4 = 52;
    static final int KEY_NUM5 = 53;
    static final int KEY_NUM6 = 54;
    static final int KEY_NUM7 = 55;
    static final int KEY_NUM8 = 56;
    static final int KEY_NUM9 = 57;
    static final int KEY_POUND = 35;
    static final int KEY_STAR = 42;
    static final int KEY_EMPTY = -1000;
    static GameMidlet gm;
    static boolean stop;
    static final int Width = 128;
    static final int Height = 160;
    private static long sleepTime;
    static final Image BufferIm;
    static final Graphics ig;
    private static long fps;
    private static long fps1;
    private static long fps2;
    private static long lastTime;
    private final Font f = Font.getFont((int)0, (int)1, (int)8);
    static long lastPres;
    static boolean PAUSE;
    static Command[] commands;

    MainCanvas(GameMidlet gameMidlet) {
        gm = gameMidlet;
        This = this;
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
        Snd.stop();
    }

    protected final void keyPressed(int n) {
        if (MainCanvasInterface.wait != 0) {
            return;
        }
        lastPres = System.currentTimeMillis();
        if (n != 42 && n != 35 && (PressedKeyVector.contains(new Integer(n)) || PressedKeyVectorOnce.contains(new Integer(n)))) {
            return;
        }
        PressedKeyVector.addElement(new Integer(n));
        PressedKeyVectorOnce.addElement(new Integer(n));
        if (PressedKeyVectorOnce.size() > 2) {
            PressedKeyVector.removeAllElements();
            PressedKeyVectorOnce.removeAllElements();
            ReleasedKeyVectorOnce.removeAllElements();
        }
    }

    protected final void keyReleased(int n) {
        if (MainCanvasInterface.wait != 0) {
            return;
        }
        PressedKeyVector.removeElement(new Integer(n));
        ReleasedKeyVectorOnce.addElement(new Integer(n));
        if (ReleasedKeyVectorOnce.size() > 2) {
            PressedKeyVector.removeAllElements();
            PressedKeyVectorOnce.removeAllElements();
            ReleasedKeyVectorOnce.removeAllElements();
        }
    }

    protected final void keyRepeated(int n) {
        lastPres = System.currentTimeMillis();
    }

    static void setActive(MainCanvasInterface mainCanvasInterface) {
        canvas = mainCanvasInterface;
    }

    static boolean isActive(MainCanvasInterface mainCanvasInterface) {
        return mainCanvasInterface == canvas;
    }

    static MainCanvasInterface getActive() {
        return canvas;
    }

    static boolean isPressed(int n) {
        return PressedKeyVector.contains(new Integer(n));
    }

    static boolean isReleased(int n) {
        return !PressedKeyVector.contains(new Integer(n));
    }

    static boolean isAnyPressed() {
        return PressedKeyVector.size() == 0;
    }

    public final void paint(Graphics graphics) {
        if (PAUSE) {
            graphics.setColor(170);
            graphics.fillRect(0, 0, 128, 160);
            MainCanvasInterface.drawString(8, 64, 80, 1 | 2, graphics);
            MainCanvasInterface.drawString(68, 1, 159, 4 | 0x20, graphics);
            this.repaint();
            return;
        }
        try {
            if (stop) {
                return;
            }
            if (System.currentTimeMillis() - sleepTime >= 0L && canvas != null) {
                canvas.repaint(ig);
            }
            graphics.setClip(0, 0, 128, 160);
            graphics.drawImage(BufferIm, 0, 0, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        lastTime = System.currentTimeMillis();
    }

    static void stop() {
        stop = true;
    }

    public void run() {
        try {
            while (!stop) {
                this.repaint();
                this.serviceRepaints();
                Thread.yield();
                Thread.currentThread();
                Thread.sleep(20L);
            }
        }
        catch (Exception exception) {
            this.start();
        }
        gm.destroyApp(true);
    }

    void start() {
        stop = false;
        Thread thread = new Thread(this);
        thread.start();
    }

    static boolean newPressed() {
        return PressedKeyVectorOnce.size() > 0;
    }

    static boolean newReleased() {
        return ReleasedKeyVectorOnce.size() > 0;
    }

    static int lastPressed() {
        int n = (Integer)PressedKeyVectorOnce.lastElement();
        PressedKeyVectorOnce.removeElement(PressedKeyVectorOnce.lastElement());
        PressedKeyVectorOnce.trimToSize();
        return n;
    }

    static int lastReleased() {
        int n = (Integer)ReleasedKeyVectorOnce.lastElement();
        ReleasedKeyVectorOnce.removeElement(ReleasedKeyVectorOnce.lastElement());
        return n;
    }

    static void sleep(long l) {
        sleepTime = System.currentTimeMillis() + l;
    }

    static long getFreeMem() {
        return Runtime.getRuntime().freeMemory();
    }

    static void clearKeys() {
        PressedKeyVector.removeAllElements();
        PressedKeyVectorOnce.removeAllElements();
        ReleasedKeyVectorOnce.removeAllElements();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getPriority() == 0) {
            canvas.keyPressedSoft1();
        } else {
            canvas.keyPressedSoft2();
        }
    }

    static void initCommands() {
    }

    static {
        PressedKeyVector = new Vector();
        PressedKeyVectorOnce = new Vector();
        ReleasedKeyVectorOnce = new Vector();
        stop = true;
        sleepTime = System.currentTimeMillis();
        BufferIm = Image.createImage((int)128, (int)160);
        ig = BufferIm.getGraphics();
        fps = 0L;
        fps1 = 0L;
        fps2 = 0L;
        lastPres = 0L;
        PAUSE = false;
        commands = new Command[11];
    }
}

