/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Hero {
    private MyCanvas canvas;
    public int xPosition;
    public int yPosition;
    public int width;
    public int height;
    public byte dir = 1;
    public byte frame;
    public byte bowPos = 1;
    private byte heroOffY;
    public byte frameCtr;
    public byte framePtr;
    public byte xVel;
    public byte yVel;
    public short fallHeight;
    public boolean fallHtReached;
    public int jumpCtr;
    public int jumpLimit;
    public boolean JumpHtReached;
    public byte actionFrmPtr = 0;
    public boolean isHit = false;
    private byte hitCounter = 0;
    public boolean receiveKeypressed = false;
    public boolean swordLock = false;
    public byte weapon = 0;
    public boolean fireArrow;
    private byte waitCtr;
    public boolean isDead;
    private boolean isEnd;
    public byte action = 0;
    public static final byte STAND = 0;
    public static final byte RUN = 1;
    public static final byte JUMP = 2;
    public static final byte EDGE_HANG = 3;
    public static final byte EDGE_CLIMB = 4;
    public static final byte DIE = 5;
    public static final byte FALL = 6;
    public static final byte SWING = 7;
    public static final byte POLE_ROLL = 8;
    public static final byte JUMP_ROLL = 9;
    public static final byte ROAR = 10;
    public static final byte CROUCH = 11;
    public static final byte CROUCH_ROLL = 12;
    public static final byte TOP_EDGE_CLIMB = 16;
    public static final byte TOP_EDGE_GETDOWN = 17;
    public byte imageNo;
    private byte imageRotation;
    public static Image[] image;
    public byte[][] ImgRotArr = new byte[][]{{0, 6, 3, 5}, {2, 7, 1, 4}};
    private byte[][] anchorArr = new byte[][]{{24, 20, 36, 40}, {20, 24, 40, 36}};
    public short[] heroClipping = new short[]{0, 1, 23, 18, 23, 0, 22, 19, 45, 4, 27, 15, 72, 3, 28, 16, 100, 0, 32, 19, 132, 6, 32, 13, 164, 4, 31, 15, 195, 4, 27, 15, 222, 0, 22, 26, 0, 17, 26, 20, 26, 3, 19, 34, 45, 3, 20, 34, 65, 17, 27, 20, 92, 6, 25, 31, 117, 3, 23, 34, 140, 0, 21, 37, 161, 9, 18, 28, 179, 20, 21, 17, 0, 14, 23, 30, 23, 12, 23, 32, 46, 2, 16, 42, 62, 0, 16, 44, 78, 3, 17, 41, 95, 13, 20, 31, 115, 18, 23, 26, 138, 25, 26, 19, 0, 0, 63, 41, 63, 0, 50, 58, 113, 0, 40, 61, 0, 2, 52, 35, 52, 0, 34, 37, 86, 8, 33, 29, 119, 7, 28, 30, 147, 6, 31, 31, 178, 7, 30, 30, 208, 5, 31, 32, 239, 5, 48, 32, 0, 8, 52, 36, 52, 12, 51, 32, 103, 4, 58, 40, 161, 0, 63, 44, 224, 6, 48, 38, 23, 2, 32, 24, 23, 2, 32, 24, 56, 6, 35, 20, 91, 10, 41, 16, 0, 0, 31, 24, 31, 0, 25, 29, 56, 0, 23, 32, 79, 0, 26, 32, 56, 0, 23, 32, 31, 0, 25, 29, 105, 0, 17, 17, 0, 4, 28, 21, 28, 7, 27, 18, 55, 2, 32, 23, 87, 0, 33, 25, 120, 3, 26, 22, 28, 7, 27, 18};
    private byte[] heroPlacingRt = new byte[]{0, 0, 1, -1, -1, 6, -1, 4, -7, 1, -10, 3, -9, 5, -5, 6, -8, 2, -3, -5, -1, -28, -2, -32, -5, -31, -2, -38, 0, -36, 5, -37, 2, -23, 2, -1, 0, -3, 7, -2, 11, -3, 10, -8, 10, -11, 9, -6, 8, -13, 14, -18, -19, 0, -6, 0, -21, 0, 7, 0, 7, 0, 15, 0, 11, 0, 16, 0, 0, 0, 0, 0, 0, 0, -5, -3, -4, 0, -2, -4, -1, -6, 0, -4, 10, 0, 10, 0, 5, 10, 4, 16, -29, -13, -22, -2, -14, -2, -7, -2, -14, -2, -22, -2, 0, -14, -5, -3, -4, 0, -2, -4, -1, -6, 0, -4, -4, 0};
    private byte[] heroPlacingLf = new byte[]{0, 1, 0, 0, -6, 4, -4, 2, -9, -2, -8, 5, -6, 8, -3, 4, 0, -2, -2, -5, 7, -28, 9, -32, -2, -31, -2, -38, 0, -36, -2, -37, 8, -23, 2, -1, -7, -1, -14, 0, -11, -3, -10, -8, -11, -11, -13, -6, -15, -13, -24, -18, -1, 1, -32, 1, -2, 1, 1, 0, -5, 0, -7, 0, -15, 0, -7, 0, 0, 0, 0, 0, 0, 0, 0, -3, 0, 0, -7, -4, -9, -6, -3, -4, -25, 0, -25, 0, -33, 10, -34, 16, 1, -13, 2, -2, -5, -2, -15, -2, -5, -2, 2, -2, 0, -14, 0, -3, 0, 0, -7, -4, -9, -6, -3, -4, 0, 0};
    public byte[] framePos = new byte[]{0, 2, 9, 18, 26, 29, 37, 42, 46, 53};

    public Hero(int xPosition, int yPosition, int width, int height, int direction, boolean hidden, MyCanvas canvas) {
        this.canvas = canvas;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.dir = (byte)direction;
    }

    public static void initResources() {
        try {
            image = new Image[7];
            Hero.image[0] = Image.createImage((String)"/h_st_run.png");
            Hero.image[1] = Image.createImage((String)"/h_jump.png");
            Hero.image[2] = Image.createImage((String)"/h_eg_hang.png");
            Hero.image[3] = Image.createImage((String)"/h_die.png");
            Hero.image[4] = Image.createImage((String)"/h_poleRoll.png");
            Hero.image[6] = Image.createImage((String)"/hero_roar.png");
        }
        catch (Exception e) {
            System.out.println("Error in Hero Image Creation :" + e.toString());
        }
    }

    void updateHero() {
        try {
            switch (this.action) {
                case 0: {
                    if (MyCanvas.haveKeyPressed(4) || MyCanvas.haveKeyHold(4)) {
                        this.action = 1;
                        this.dir = 1;
                    } else if (MyCanvas.haveKeyPressed(64) || MyCanvas.haveKeyHold(64)) {
                        this.action = 1;
                        this.dir = (byte)-1;
                    }
                    if (MyCanvas.haveKeyPressed(1)) {
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 5;
                        this.jumpCtr = 0;
                        this.xVel = (byte)(16 >> 1);
                        this.JumpHtReached = false;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(128)) {
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 5;
                        this.jumpCtr = 0;
                        this.JumpHtReached = false;
                        this.dir = (byte)-1;
                        this.xVel = (byte)((16 >> 1) + (16 >> 2));
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(2)) {
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 5;
                        this.jumpCtr = 0;
                        this.JumpHtReached = false;
                        this.dir = 1;
                        this.xVel = (byte)((16 >> 1) + (16 >> 2));
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(256)) {
                        this.action = (byte)10;
                        this.frame = 0;
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(2048)) break;
                    break;
                }
                case 1: {
                    if (MyCanvas.haveKeyReleased(4) || MyCanvas.haveKeyReleased(64)) {
                        this.action = 0;
                        this.frame = 0;
                        this.frameCtr = 0;
                    }
                    if (MyCanvas.haveKeyHold(4)) {
                        this.action = 1;
                        this.dir = 1;
                    } else if (MyCanvas.haveKeyHold(64)) {
                        this.action = 1;
                        this.dir = (byte)-1;
                    }
                    if (MyCanvas.haveKeyPressed(1)) {
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 5;
                        this.jumpCtr = 0;
                        this.JumpHtReached = false;
                        this.xVel = (byte)(16 >> 1);
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(256)) break;
                    this.action = (byte)10;
                    this.frame = 0;
                    break;
                }
                case 2: {
                    if (!MyCanvas.haveKeyHold(1) || this.jumpLimit >= 5) break;
                    ++this.jumpLimit;
                    break;
                }
                case 3: {
                    if (MyCanvas.haveKeyPressed(1)) {
                        if (MyCanvas.isReadyToClimb) {
                            this.action = (byte)16;
                            this.xPosition = this.canvas.edgeOffX;
                            this.yPosition = this.canvas.edgeOffY;
                            break;
                        }
                        this.action = (byte)4;
                        this.frame = 0;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(16)) {
                        this.action = (byte)6;
                        this.yPosition += 16 >> 2;
                        break;
                    }
                    if (this.dir > 0 && (MyCanvas.haveKeyPressed(64) || MyCanvas.haveKeyPressed(128))) {
                        this.action = (byte)2;
                        this.dir = (byte)-1;
                        this.frame = (byte)-1;
                        this.jumpLimit = 2;
                        this.jumpCtr = 0;
                        this.xVel = (byte)(16 >> 1);
                        this.JumpHtReached = false;
                        break;
                    }
                    if (this.dir >= 0 || !MyCanvas.haveKeyPressed(4) && !MyCanvas.haveKeyPressed(2)) break;
                    this.action = (byte)2;
                    this.dir = 1;
                    this.frame = (byte)-1;
                    this.jumpLimit = 2;
                    this.jumpCtr = 0;
                    this.xVel = (byte)(16 >> 1);
                    this.JumpHtReached = false;
                    break;
                }
                case 6: {
                    this.xVel = 0;
                    if (MyCanvas.haveKeyHold(4) || MyCanvas.haveKeyHold(2)) {
                        if (MyCanvas.isReadyToClimb) {
                            this.action = (byte)3;
                            this.xPosition = this.canvas.edgeOffX;
                            this.yPosition = this.canvas.edgeOffY;
                            this.frame = (byte)-1;
                        }
                        this.dir = 1;
                        this.xVel = (byte)4;
                        break;
                    }
                    if (!MyCanvas.haveKeyHold(64) && !MyCanvas.haveKeyHold(128)) break;
                    if (MyCanvas.isReadyToClimb) {
                        this.action = (byte)3;
                        this.xPosition = this.canvas.edgeOffX;
                        this.yPosition = this.canvas.edgeOffY;
                        this.frame = (byte)-1;
                    }
                    this.dir = (byte)-1;
                    this.xVel = (byte)4;
                    break;
                }
                case 8: {
                    if (!MyCanvas.haveKeyPressed(4) && !MyCanvas.haveKeyPressed(64)) break;
                    this.xVel = (byte)8;
                    this.action = (byte)9;
                    this.frame = (byte)-1;
                    this.jumpLimit = 4;
                    this.jumpCtr = 0;
                    this.JumpHtReached = false;
                    this.frameCtr = 0;
                    break;
                }
                case 7: {
                    if (MyCanvas.haveKeyPressed(1) || MyCanvas.haveKeyPressed(4) || MyCanvas.haveKeyPressed(64)) {
                        this.xVel = (byte)5;
                        this.xPosition = this.dir == 1 ? (this.xPosition += 16 * 2) : (this.xPosition -= 16 * 2);
                        this.action = (byte)2;
                        this.frame = 0;
                        this.jumpLimit = 2;
                        this.jumpCtr = 0;
                        this.JumpHtReached = false;
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(16)) break;
                    this.action = (byte)6;
                    this.frame = 0;
                    this.xVel = 0;
                    this.yPosition += 16 >> 2;
                    break;
                }
                case 11: {
                    this.action = 0;
                    this.frame = 0;
                    this.frameCtr = 0;
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in updateHero>>" + e);
        }
    }

    void update() {
        try {
            byte by = this.canvas.currPage;
            this.canvas.getClass();
            if (by != 18) {
                this.updateHero();
            }
            if (this.dir == 1) {
                this.imageRotation = 0;
                this.canvas.HeroXposOnScr = (MyCanvas.canvasWidth >> 1) - this.width;
                if (MyCanvas.gameLevel != 4) {
                    this.canvas.HeroYposOnScr = MyCanvas.canvasHeight >> 1;
                }
            } else {
                this.imageRotation = (byte)2;
                this.canvas.HeroXposOnScr = MyCanvas.canvasWidth >> 1;
                if (MyCanvas.gameLevel != 4) {
                    this.canvas.HeroYposOnScr = MyCanvas.canvasHeight >> 1;
                }
            }
            if (this.action != 6) {
                this.fallHeight = 0;
            }
            switch (this.action) {
                case 0: {
                    this.receiveKeypressed = true;
                    this.xVel = 0;
                    this.weapon = 0;
                    this.actionFrmPtr = 0;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    if (this.frameCtr > 3) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    this.imageNo = 0;
                    if (this.frame > 1) {
                        this.frame = 0;
                    }
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)3;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                    break;
                }
                case 1: {
                    this.actionFrmPtr = 1;
                    this.frame = (byte)(this.frame + 1);
                    this.imageNo = 0;
                    if (this.frame > 5) {
                        this.frame = 0;
                    }
                    this.xPosition += 6 * this.dir;
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)3;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                    break;
                }
                case 3: {
                    this.actionFrmPtr = (byte)3;
                    this.imageNo = (byte)2;
                    break;
                }
                case 4: {
                    this.actionFrmPtr = (byte)3;
                    this.imageNo = (byte)2;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame != 4) break;
                    this.action = (byte)6;
                    this.yPosition -= 16 * 2;
                    break;
                }
                case 16: {
                    this.actionFrmPtr = (byte)3;
                    this.imageNo = (byte)2;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame <= 6) break;
                    this.action = 0;
                    this.frame = 0;
                    this.actionFrmPtr = 0;
                    this.imageNo = 0;
                    this.frameCtr = 0;
                    this.yPosition -= this.height;
                    if (this.dir == 1) {
                        this.xPosition += 16 * this.dir;
                        break;
                    }
                    this.xPosition += this.width * this.dir;
                    System.out.println(this.xPosition + " " + this.frame + " " + this.yPosition);
                    break;
                }
                case 17: {
                    this.actionFrmPtr = (byte)3;
                    this.imageNo = (byte)2;
                    this.xPosition = this.canvas.edgeOffX;
                    this.yPosition = this.canvas.edgeOffY;
                    this.frame = (byte)(this.frame - 1);
                    if (this.frame >= 6) break;
                    this.action = (byte)3;
                    break;
                }
                case 5: {
                    this.imageNo = (byte)3;
                    this.actionFrmPtr = (byte)7;
                    if (this.frameCtr < 1) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                    } else {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    if (this.frame <= 3 || !MyCanvas.isGroundTouched) break;
                    this.frame = (byte)3;
                    this.canvas.getClass();
                    this.canvas.currPage = (byte)9;
                    this.canvas.shutterY = 0;
                    this.canvas.shutterMaxY = 16 * 2;
                    break;
                }
                case 8: {
                    this.actionFrmPtr = (byte)8;
                    this.imageNo = (byte)4;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame > 5) {
                        this.frame = 0;
                    }
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    break;
                }
                case 9: {
                    int n;
                    this.actionFrmPtr = (byte)8;
                    this.imageNo = (byte)4;
                    this.frame = (byte)6;
                    if (this.frameCtr > 1) {
                        byte by2 = (byte)(this.frameCtr - 1);
                        n = by2;
                        this.frameCtr = by2;
                    } else {
                        n = 3;
                    }
                    this.frameCtr = (byte)n;
                    this.imageRotation = this.ImgRotArr[0][this.frameCtr];
                    this.xPosition += this.xVel * this.dir;
                    if (this.JumpHtReached) {
                        if (!MyCanvas.isGroundTouched) {
                            this.action = (byte)6;
                            this.yPosition += 16 >> 2;
                            break;
                        }
                    }
                    if (this.jumpCtr >= this.jumpLimit) break;
                    this.yPosition -= 16 >> 1;
                    ++this.jumpCtr;
                    if (this.jumpCtr < this.jumpLimit) break;
                    this.JumpHtReached = true;
                    break;
                }
                case 7: {
                    this.actionFrmPtr = (byte)4;
                    this.imageNo = (byte)5;
                    break;
                }
                case 11: {
                    this.imageNo = (byte)5;
                    this.actionFrmPtr = (byte)5;
                    this.frame = (byte)7;
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                    break;
                }
                case 12: {
                    this.imageNo = (byte)5;
                    this.actionFrmPtr = (byte)5;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame >= 7) {
                        this.action = (byte)11;
                        this.frame = 0;
                    } else {
                        this.xPosition += 10 * this.dir;
                    }
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                    break;
                }
                case 10: {
                    this.imageNo = (byte)6;
                    this.actionFrmPtr = (byte)9;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame >= 4) {
                        this.action = 0;
                        this.imageNo = 0;
                        this.actionFrmPtr = 0;
                        this.frame = 0;
                    }
                    System.out.println("ROAR  frame         >>" + this.frame);
                    break;
                }
                case 2: {
                    this.actionFrmPtr = (byte)2;
                    this.imageNo = 1;
                    this.xPosition += this.xVel * this.dir;
                    this.fallHeight = 0;
                    if (this.JumpHtReached) {
                        if (!MyCanvas.isGroundTouched) {
                            this.frame = (byte)3;
                            this.action = (byte)6;
                            this.yPosition += 16 >> 2;
                            break;
                        }
                    }
                    if (this.JumpHtReached) {
                        if (MyCanvas.isGroundTouched) {
                            this.frame = (byte)3;
                            this.action = (byte)6;
                            this.yPosition += 16 >> 2;
                            break;
                        }
                    }
                    if (this.jumpCtr >= this.jumpLimit) break;
                    if (this.frame < 1) {
                        this.frame = (byte)(this.frame + 1);
                    }
                    this.yPosition -= 16 >> 1;
                    ++this.jumpCtr;
                    if (this.jumpCtr < this.jumpLimit) break;
                    this.JumpHtReached = true;
                    break;
                }
                case 6: {
                    if (this.isDead) {
                        this.imageNo = (byte)3;
                        this.actionFrmPtr = (byte)7;
                        this.frame = 0;
                        this.yPosition += 16 >> 1;
                        if (!MyCanvas.isGroundTouched) break;
                        this.action = (byte)5;
                        break;
                    }
                    this.actionFrmPtr = (byte)2;
                    if (MyCanvas.isGroundTouched) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frame != 5 || this.frameCtr < 3) {
                            this.imageNo = 0;
                            this.actionFrmPtr = 1;
                            this.frame = (byte)5;
                            System.out.println("in hereeee");
                            break;
                        }
                        this.JumpHtReached = false;
                        this.xVel = 0;
                        this.action = 0;
                        this.frame = 0;
                        this.actionFrmPtr = 0;
                        this.imageNo = 0;
                        this.frameCtr = 0;
                        break;
                    }
                    this.xPosition += this.xVel * this.dir;
                    this.frameCtr = 0;
                    this.actionFrmPtr = (byte)2;
                    this.imageNo = 1;
                    this.frame = this.frame < 6 ? (byte)(this.frame + 1) : (byte)6;
                    this.yPosition += 16 >> 1;
                }
            }
            this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + this.frame);
            if (this.isHit) {
                if (this.hitCounter == 0) {
                    this.canvas.life = (byte)(this.canvas.life - 12);
                }
                this.hitCounter = (byte)(this.hitCounter + 1);
                if (this.hitCounter > 15) {
                    this.isHit = false;
                    this.hitCounter = 0;
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in hero update>>" + this.action + " " + e);
        }
    }

    public void draw(Graphics g) {
        try {
            if (this.hitCounter % 2 == 0 || this.action == 5) {
                g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]), 0);
            }
        }
        catch (Exception e) {
            System.out.println("err in hero draw>>" + e + "" + this.action);
        }
    }
}

