/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Boss {
    private MyCanvas canvas;
    int xPosition;
    int yPosition;
    int width;
    int height;
    int xDistance;
    int yDistance;
    int tempX;
    int tempY;
    byte dir;
    byte type;
    byte action;
    boolean hidden;
    boolean isEnd;
    boolean isHurt;
    boolean flag;
    boolean isDead;
    boolean levelUp;
    public byte damage;
    public byte hitCounter = 1;
    public byte hits;
    public byte frame;
    public byte framePtr;
    private byte frameCtr;
    private byte imageRotation;
    private byte deadCtr;
    public byte waitCtr;
    public byte life;
    Image[] image;
    private byte imageNo;
    short[] clipArr;

    public Boss(int xPosition, int yPosition, int width, int height, int direction, int hitCounter, int type, MyCanvas canvas) {
        this.canvas = canvas;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.dir = (byte)direction;
        this.type = (byte)type;
        this.life = this.hitCounter = (byte)hitCounter;
        try {
            this.image = new Image[4];
            for (int i = 0; i < this.image.length; ++i) {
                this.image[i] = Image.createImage((String)("/b" + i + ".png"));
            }
            this.clipArr = canvas.convertBytetoShort(canvas.readFile("/b" + type));
        }
        catch (Exception e) {
            System.out.println("err in boss image " + e);
        }
    }

    private void update(Graphics g) {
        try {
            switch (this.type) {
                case 0: {
                    this.xDistance = this.xPosition + (this.width >> 1) - (this.canvas.hero.xPosition + (this.canvas.hero.width >> 1));
                    this.yDistance = this.yPosition - this.canvas.hero.yPosition;
                    this.blockHero();
                    switch (this.action) {
                        case 0: {
                            this.imageNo = 1;
                            if (Math.abs(this.yDistance) < this.height && Math.abs(this.xDistance) < this.canvas.hero.width + this.width / 2) {
                                if (MyCanvas.isGroundTouched) {
                                    this.action = 1;
                                    if (this.frame > 11 || this.frame < 6) {
                                        this.frame = (byte)6;
                                    }
                                }
                            }
                            if (Math.abs(this.tempX) < 16 << 2 && this.tempY == 0) {
                                this.tempX += (16 >> 3) * this.dir;
                                this.xPosition += (16 >> 3) * this.dir;
                                if (this.isEnd) {
                                    int n;
                                    if (this.frame > 0) {
                                        byte by = (byte)(this.frame - 1);
                                        n = by;
                                        this.frame = by;
                                    } else {
                                        n = 5;
                                    }
                                    this.frame = (byte)n;
                                    byte by = this.frame = this.frame >= 5 && this.frame <= 5 ? (byte)0 : this.frame;
                                    if (this.frame > 0) break;
                                    this.isEnd = false;
                                    break;
                                }
                                this.frame = this.frame < 5 ? (this.frame = (byte)(this.frame + 1)) : (byte)0;
                                int n = this.frame = this.frame >= 1 && this.frame <= 4 ? 5 : this.frame;
                                if (this.frame < 5) break;
                                this.isEnd = true;
                                break;
                            }
                            this.frame = (byte)(this.frame != 0 ? 1 : 0);
                            int n = this.tempY = this.tempY > 3 ? 0 : (this.tempY = this.tempY + 1);
                            if (this.tempY != 0) break;
                            this.dir = (byte)(this.dir * -1);
                            this.tempX += (16 >> 2) * this.dir;
                            this.xPosition += (16 >> 2) * this.dir;
                            break;
                        }
                        case 1: {
                            this.imageNo = 0;
                            if (this.frame > 11 || this.frame < 6) {
                                this.frame = (byte)6;
                            }
                            if (this.xDistance >= 32) break;
                            this.waitCtr = (byte)(this.waitCtr + 1);
                            if (this.waitCtr <= 5) break;
                            this.waitCtr = 0;
                            this.action = (byte)(this.xDistance > 1 ? 2 : 3);
                            break;
                        }
                        case 2: {
                            if (Math.abs(this.yDistance) < this.height && Math.abs(this.xDistance) < this.canvas.hero.width + this.width / 2) {
                                if (MyCanvas.isGroundTouched) {
                                    this.imageNo = 0;
                                    this.dir = (byte)-1;
                                    if (this.frame < 10 && !this.isEnd) {
                                        this.frame = (byte)(this.frame + 1);
                                        if (this.frame < 9) break;
                                        this.xPosition -= 8;
                                        break;
                                    }
                                    this.isEnd = true;
                                    this.frame = (byte)(this.frame != 8 ? 8 : 6);
                                    if (this.frame != 6) break;
                                    this.isEnd = false;
                                    this.action = 0;
                                    break;
                                }
                            }
                            this.action = 1;
                            break;
                        }
                        case 3: {
                            if (Math.abs(this.yDistance) < this.height && Math.abs(this.xDistance) < this.canvas.hero.width + this.width / 2) {
                                if (MyCanvas.isGroundTouched) {
                                    this.imageNo = 0;
                                    this.dir = 1;
                                    if (this.frame < 10 && !this.isEnd) {
                                        this.frame = (byte)(this.frame + 1);
                                        if (this.frame < 9) break;
                                        this.xPosition += 8;
                                        break;
                                    }
                                    this.isEnd = true;
                                    this.frame = (byte)(this.frame != 8 ? 8 : 6);
                                    if (this.frame != 6) break;
                                    this.isEnd = false;
                                    this.action = 1;
                                    break;
                                }
                            }
                            this.action = 0;
                            break;
                        }
                        case 4: {
                            this.imageNo = 0;
                            if (this.deadCtr > 10) {
                                this.waitCtr = (byte)(this.waitCtr + 1);
                                if (this.waitCtr >= 15) {
                                    this.hidden = true;
                                    if (MyCanvas.gameLevel != 4) {
                                        this.canvas.getClass();
                                        this.canvas.currPage = (byte)10;
                                    }
                                }
                            } else if (this.frame == 6) {
                                this.deadCtr = (byte)(this.deadCtr + 1);
                            }
                            this.frame = (byte)(this.frame < 6 ? 6 : (int)this.frame);
                            this.frameCtr = (byte)(this.frameCtr + 1);
                            if (this.frameCtr <= 3) break;
                            this.frameCtr = 0;
                            this.frame = (byte)(this.frame + 1);
                            if (this.frame < 6) break;
                            this.frame = (byte)6;
                        }
                    }
                    if (!this.canvas.hero.isHit && MyCanvas.intersectsOfSprites(this.canvas.hero.xPosition, this.canvas.hero.yPosition, this.canvas.hero.width, this.canvas.hero.height, this.xPosition + this.clipArr[(this.frame << 3) + (this.dir < 0 ? 4 : 6)], this.yPosition + this.clipArr[(this.frame << 3) + (this.dir < 0 ? 5 : 7)], this.clipArr[(this.frame << 3) + 2], this.clipArr[(this.frame << 3) + 3])) {
                        this.canvas.hero.isHit = true;
                    }
                    if (this.checkHeroAttack()) {
                        this.hits = (byte)(this.hits + this.damage);
                        this.canvas.addTopLayerElement(new Elements(this.xPosition + 20, this.yPosition, 0, 0, 0, 0, false, 1, 0, 0, this.canvas));
                        break;
                    }
                    if (this.hits < 8) break;
                    this.action = (byte)4;
                    break;
                }
                case 1: {
                    this.xDistance = this.xPosition + (this.width >> 1) - (this.canvas.hero.xPosition + (this.canvas.hero.width >> 1));
                    this.yDistance = this.yPosition - this.canvas.hero.yPosition;
                    this.blockHero();
                    switch (this.action) {
                        case 0: {
                            this.imageNo = (byte)2;
                            if (Math.abs(this.yDistance) < this.height && Math.abs(this.xDistance) < this.canvas.hero.width + this.width / 2) {
                                if (MyCanvas.isGroundTouched) {
                                    this.action = 1;
                                    if (this.frame > 14 || this.frame < 6) {
                                        this.frame = (byte)6;
                                    }
                                }
                            }
                            if (Math.abs(this.tempX) < 16 << 2 && this.tempY == 0) {
                                this.tempX += (16 >> 3) * this.dir;
                                this.xPosition += (16 >> 3) * this.dir;
                                if (this.isEnd) {
                                    int n;
                                    if (this.frame > 0) {
                                        byte by = (byte)(this.frame - 1);
                                        n = by;
                                        this.frame = by;
                                    } else {
                                        n = 5;
                                    }
                                    this.frame = (byte)n;
                                    byte by = this.frame = this.frame >= 5 && this.frame <= 5 ? (byte)0 : this.frame;
                                    if (this.frame > 0) break;
                                    this.isEnd = false;
                                    break;
                                }
                                this.frame = this.frame < 5 ? (this.frame = (byte)(this.frame + 1)) : (byte)0;
                                int n = this.frame = this.frame >= 1 && this.frame <= 4 ? 5 : this.frame;
                                if (this.frame < 5) break;
                                this.isEnd = true;
                                break;
                            }
                            this.frame = (byte)(this.frame != 0 ? 1 : 0);
                            int n = this.tempY = this.tempY > 3 ? 0 : (this.tempY = this.tempY + 1);
                            if (this.tempY != 0) break;
                            this.dir = (byte)(this.dir * -1);
                            this.tempX += (16 >> 2) * this.dir;
                            this.xPosition += (16 >> 2) * this.dir;
                            break;
                        }
                        case 1: {
                            this.imageNo = (byte)3;
                            if (this.frame > 14 || this.frame < 6) {
                                this.frame = (byte)6;
                            }
                            if (Math.abs(this.yDistance) < this.height && Math.abs(this.xDistance) < this.canvas.hero.width + this.width / 2) {
                                if (MyCanvas.isGroundTouched) {
                                    int n;
                                    this.dir = (byte)(this.xDistance > 0 ? -1 : 1);
                                    this.frameCtr = (byte)(this.frameCtr + 1);
                                    if (this.frameCtr <= 2) break;
                                    this.frameCtr = 0;
                                    if (this.frame < 14) {
                                        byte by = (byte)(this.frame + 1);
                                        n = by;
                                        this.frame = by;
                                    } else {
                                        n = 6;
                                    }
                                    this.frame = (byte)n;
                                    if (this.frame <= 10) break;
                                    this.waitCtr = (byte)(this.waitCtr + 1);
                                    this.frameCtr = 0;
                                    break;
                                }
                            }
                            this.action = 0;
                            break;
                        }
                        case 2: {
                            this.imageNo = (byte)3;
                            if (this.deadCtr > 10) {
                                this.waitCtr = (byte)(this.waitCtr + 1);
                                if (this.waitCtr > 15) {
                                    this.hidden = true;
                                    if (MyCanvas.gameLevel == 2) {
                                        this.canvas.getClass();
                                        this.canvas.currPage = (byte)10;
                                    }
                                    return;
                                }
                            } else if (this.frame == 15) {
                                this.deadCtr = (byte)(this.deadCtr + 1);
                            }
                            this.frame = (byte)15;
                        }
                    }
                    if (!this.canvas.hero.isHit && MyCanvas.intersectsOfSprites(this.canvas.hero.xPosition, this.canvas.hero.yPosition, this.canvas.hero.width, this.canvas.hero.height, this.xPosition + this.clipArr[(this.frame << 3) + (this.dir < 0 ? 4 : 6)], this.yPosition + this.clipArr[(this.frame << 3) + (this.dir < 0 ? 5 : 7)], this.clipArr[(this.frame << 3) + 2], this.clipArr[(this.frame << 3) + 3])) {
                        this.canvas.hero.isHit = true;
                    }
                    if (this.checkHeroAttack()) {
                        this.hits = (byte)(this.hits + this.damage);
                        this.canvas.addTopLayerElement(new Elements(this.xPosition + 20, this.yPosition, 0, 0, 0, 0, false, 1, 0, 0, this.canvas));
                        break;
                    }
                    if (this.hits < 8) break;
                    this.action = (byte)2;
                }
            }
            this.imageRotation = (byte)(this.dir == 1 ? 2 : 0);
        }
        catch (Exception e) {
            System.out.println("err in boss update " + e);
        }
    }

    public void draw(Graphics g) {
        try {
            this.update(g);
            if (this.deadCtr % 2 == 0) {
                g.drawRegion(this.image[this.imageNo], (int)this.clipArr[this.frame << 3], (int)this.clipArr[(this.frame << 3) + 1], (int)this.clipArr[(this.frame << 3) + 2], (int)this.clipArr[(this.frame << 3) + 3], (int)this.imageRotation, this.xPosition + this.clipArr[(this.frame << 3) + (this.dir < 0 ? 4 : 6)], this.yPosition + this.clipArr[(this.frame << 3) + (this.dir < 0 ? 5 : 7)], 0);
            }
        }
        catch (Exception e) {
            System.out.println("err in boss draw>>" + e);
        }
    }

    private boolean checkHeroAttack() {
        switch (this.canvas.hero.action) {
            case 6: {
                if (this.canvas.hero.frame <= 5 || this.canvas.hero.xPosition + this.canvas.hero.width < this.xPosition || this.canvas.hero.xPosition > this.xPosition + this.width || this.canvas.hero.yPosition + this.canvas.hero.height <= this.yPosition || this.canvas.hero.yPosition >= this.yPosition + this.height) break;
                this.damage = 1;
                return true;
            }
        }
        return false;
    }

    private void blockHero() {
        if (MyCanvas.intersectsOfSprites(this.canvas.hero.xPosition, this.canvas.hero.yPosition, this.canvas.hero.width, this.canvas.hero.height, this.xPosition, this.yPosition, this.width, this.height)) {
            this.canvas.hero.xPosition = this.canvas.hero.xPosition < this.xPosition ? this.xPosition - this.canvas.hero.width : this.xPosition + this.width;
        }
    }
}

