/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Enemy {
    private MyCanvas canvas;
    int xPosition;
    int yPosition;
    int width;
    int height;
    int xDistance;
    int yDistance;
    byte dir;
    byte type;
    byte action = 0;
    byte vDir = 1;
    boolean hidden;
    boolean isDead;
    boolean isEnd;
    public int tempX;
    public int tempY;
    public int xEnd;
    public int yEnd;
    public int minX;
    public int maxX;
    private boolean isCutterEnd;
    public byte hitCounter = 0;
    public byte hits;
    private byte imageNo;
    private byte imageRotation;
    public byte frame;
    public byte frameCtr = 0;
    private byte framePtr;
    private byte xVel;
    private byte yVel;
    public byte waitCtr;
    public byte actionFrmPtr;
    public byte actionCtr = 0;
    public byte life = (byte)100;
    public byte counter = 0;
    public byte deadCtr;
    int tileX;
    int tileY;
    char tileType;
    public static Image[] image;
    public static final byte STAND = 0;
    public static final byte RUN = 1;
    public static final byte SHOOT = 2;
    public static final byte GRENADE_THROW = 3;
    public static final byte HURT = 4;
    public static final byte DIE = 5;
    public static final byte CROUCH_SHOOT = 6;
    public static final byte VERTICAL_RUN = 7;
    public static final byte PATROLLING = 8;
    public static final byte PATROL_SHOOT = 9;
    public static final byte JUMP = 10;
    int distX;
    int distY;

    public Enemy(int xPosition, int yPosition, int width, int height, int direction, int hitCounter, int type, int imageNo, int actionFrmPtr, MyCanvas canvas, int tileX, int tileY, char tileType) {
        this.canvas = canvas;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.dir = (byte)direction;
        this.type = (byte)type;
        this.imageNo = (byte)imageNo;
        this.actionFrmPtr = (byte)actionFrmPtr;
        this.hitCounter = (byte)hitCounter;
        this.tileX = tileX;
        this.tileY = tileY;
        this.tileType = tileType;
        if (type == 1) {
            this.action = 1;
        }
    }

    public static void initResources() {
        try {
            image = new Image[8];
            Enemy.image[0] = Image.createImage((String)"/e_stand.png");
            Enemy.image[1] = Image.createImage((String)"/e_run.png");
            Enemy.image[2] = Image.createImage((String)"/e_shoot.png");
            Enemy.image[3] = Image.createImage((String)"/e_jump.png");
            Enemy.image[5] = Image.createImage((String)"/e_die.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void callAction() {
        switch (this.action) {
            case 0: {
                this.imageNo = 0;
                this.actionFrmPtr = 0;
                this.frameCtr = (byte)(this.frameCtr + 1);
                if (this.frameCtr > 3) {
                    this.frame = (byte)(this.frame + 1);
                    this.frameCtr = 0;
                }
                if (this.frame <= 1) break;
                this.frame = 0;
                break;
            }
            case 1: {
                if (MyCanvas.gameLevel != 1 && MyCanvas.gameLevel != 2 && Math.abs(this.xDistance) > 96) {
                    this.action = 0;
                    this.frame = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    break;
                }
                this.imageNo = 1;
                this.actionFrmPtr = 1;
                this.frame = (byte)(this.frame + 1);
                if (this.frame > 6) {
                    this.frame = 0;
                }
                this.xVel = MyCanvas.gameLevel == 1 ? (byte)5 : (byte)6;
                this.tempX += (24 >> 2) * this.dir;
                this.xPosition += this.xVel * this.dir;
                break;
            }
            case 10: {
                this.imageNo = (byte)3;
                this.actionFrmPtr = (byte)10;
                this.frameCtr = (byte)(this.frameCtr + 1);
                if (this.frameCtr > 1) {
                    this.xPosition += 16 * this.dir;
                    this.frameCtr = 0;
                    this.frame = (byte)(this.frame + 1);
                }
                if (this.frame <= 5) break;
                this.frameCtr = 0;
                this.frame = 0;
                this.action = 1;
                break;
            }
            case 7: {
                this.imageNo = 1;
                this.actionFrmPtr = 1;
                this.frame = (byte)(this.frame + 1);
                if (this.frame > 6) {
                    this.frame = 0;
                }
                Hero cfr_ignored_0 = this.canvas.hero;
                if (this.canvas.hero.action == 27) break;
                this.yPosition += this.yVel;
                break;
            }
            case 2: {
                this.actionFrmPtr = (byte)2;
                this.imageNo = (byte)2;
                this.frameCtr = (byte)(this.frameCtr + 1);
                if (this.frameCtr > 1) {
                    this.frame = (byte)(this.frame + 1);
                    this.frameCtr = 0;
                }
                if (Math.abs(this.yDistance) < this.height >> 1 && Math.abs(this.xDistance) <= this.canvas.hero.width + (this.width >> 1)) {
                    this.dir = (byte)(this.xDistance > 0 ? 1 : -1);
                    byte by = this.waitCtr = this.waitCtr < 12 ? (this.waitCtr = (byte)(this.waitCtr + 1)) : (byte)0;
                    if (this.frame == 1 && !this.canvas.hero.isHit) {
                        this.canvas.hero.isHit = MyCanvas.intersectsOfSprites(this.canvas.hero.xPosition - 12, this.canvas.hero.yPosition, this.canvas.hero.width + 24, this.canvas.hero.height / 2, this.xPosition, this.yPosition + (this.dir == 1 ? MyCanvas.enemyPlacingRt[this.framePtr * 2 + 1] : MyCanvas.enemyPlacingLf[this.framePtr * 2 + 1]), MyCanvas.enemyClipping[this.framePtr * 4 + 2] / 2, MyCanvas.enemyClipping[this.framePtr * 4 + 3] / 2);
                    }
                }
                if (this.frame <= 2) break;
                this.actionFrmPtr = 0;
                this.imageNo = 0;
                this.frame = 0;
                this.action = 0;
                break;
            }
            case 6: {
                this.actionFrmPtr = (byte)6;
                this.imageNo = (byte)2;
                this.frameCtr = (byte)(this.frameCtr + 1);
                if (this.frameCtr > 2) {
                    this.frame = (byte)(this.frame + 1);
                    this.frameCtr = 0;
                }
                if (this.frame != 1 || this.frameCtr == 0) {
                    // empty if block
                }
                if (this.frame <= 2) break;
                this.actionFrmPtr = 0;
                this.imageNo = 0;
                this.frame = 0;
                this.action = 0;
                break;
            }
            case 3: {
                this.imageNo = (byte)3;
                this.actionFrmPtr = (byte)3;
                this.frameCtr = (byte)(this.frameCtr + 1);
                if (this.frameCtr > 1) {
                    this.frame = (byte)(this.frame + 1);
                    this.frameCtr = 0;
                }
                if (this.frame <= 4) break;
                this.action = 0;
                this.frame = 0;
                this.imageNo = 0;
                this.actionFrmPtr = 0;
                break;
            }
            case 4: {
                System.out.println("inside hurt");
                this.imageNo = (byte)4;
                this.actionFrmPtr = (byte)4;
                this.frame = (byte)(this.frame + 1);
                if (this.frame <= 1) break;
                this.action = 0;
                this.frame = 0;
                this.imageNo = 0;
                this.actionFrmPtr = 0;
                break;
            }
            case 5: {
                this.imageNo = (byte)5;
                this.actionFrmPtr = (byte)5;
                this.frameCtr = (byte)(this.frameCtr + 1);
                if (this.frameCtr > 3) {
                    this.frame = (byte)(this.frame + 1);
                    this.frameCtr = 0;
                }
                if (this.frame < 3) break;
                this.frame = (byte)3;
                this.hidden = true;
                break;
            }
            case 8: {
                if (this.vDir > 0) {
                    this.imageNo = (byte)6;
                    this.actionFrmPtr = (byte)7;
                } else {
                    this.imageNo = (byte)7;
                    this.actionFrmPtr = (byte)8;
                }
                if (this.frameCtr > 1) {
                    this.frame = (byte)(this.frame + 1);
                    this.frameCtr = 0;
                    this.yVel = (byte)3;
                    this.yPosition += this.yVel * this.vDir;
                }
                this.frameCtr = (byte)(this.frameCtr + 1);
                if (this.frame <= 5) break;
                this.frame = 0;
                break;
            }
            case 9: {
                this.actionFrmPtr = (byte)2;
                this.imageNo = (byte)2;
                this.frameCtr = (byte)(this.frameCtr + 1);
                if (this.frameCtr > 1) {
                    this.frame = (byte)(this.frame + 1);
                    this.frameCtr = 0;
                }
                if (this.frame == 3) {
                    this.canvas.addTopLayerElement(new Elements(this.xPosition + (this.dir == 1 ? 35 : -10), this.yPosition + 15, 3, 3, 15 * this.dir, 0, false, 1, 0, 0, this.canvas));
                }
                if (this.frame <= 2) break;
                this.frame = 0;
                this.action = (byte)8;
            }
        }
        this.checkHitByHero();
    }

    private void checkHitByHero() {
        if (MyCanvas.gameLevel != 1 && this.canvas.hero.dir != this.dir && (this.canvas.hero.action == 2 || this.canvas.hero.action == 30) && this.canvas.hero.frame == 2 && MyCanvas.intersectsOfSprites(this.canvas.hero.xPosition - 12, this.canvas.hero.yPosition, this.canvas.hero.width + 24, this.canvas.hero.height, this.xPosition, this.yPosition + (this.dir == 1 ? MyCanvas.enemyPlacingRt[this.framePtr * 2 + 1] : MyCanvas.enemyPlacingLf[this.framePtr * 2 + 1]), MyCanvas.enemyClipping[this.framePtr * 4 + 2] / 2, MyCanvas.enemyClipping[this.framePtr * 4 + 3] / 2)) {
            this.canvas.playSound(5);
            this.hits = (byte)(this.hits + 1);
            if (this.hits >= this.hitCounter && !this.isDead) {
                this.isDead = true;
                if (MyCanvas.gameLevel == 2) {
                    this.canvas.enemyHitCount = (byte)(this.canvas.enemyHitCount + 1);
                    if (this.canvas.enemyHitCount >= MyCanvas.totalEnemyCount) {
                        this.canvas.getClass();
                        this.canvas.currPage = (byte)9;
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void update(Graphics g) {
        block56: {
            block55: {
                this.xDistance = this.canvas.hero.xPosition - this.xPosition;
                this.yDistance = this.canvas.hero.yPosition - this.yPosition;
                if (Math.abs(this.yDistance) <= 24 << 1) {
                    this.dir = (byte)(this.xDistance > 0 ? 1 : -1);
                }
                if (!this.isDead) break block55;
                if (this.action != 5) {
                    this.frame = 0;
                }
                this.action = (byte)5;
                break block56;
            }
            if (this.canvas.hero.action != 3 && this.canvas.hero.action != 27) {
                this.blockHero();
            }
            switch (this.type) {
                case 0: {
                    if (this.canvas.hero.action != 25) {
                        if (Math.abs(this.yDistance) <= 24 * 3) {
                            if (!MyCanvas.intersectsOfSprites(this.canvas.hero.xPosition, this.canvas.hero.yPosition, MyCanvas.canvasWidth, 2, this.xPosition, this.yPosition, this.width, 2)) {
                                this.action = (byte)7;
                                this.yVel = (byte)(3 * (this.yDistance > 0 ? 1 : -1));
                                this.waitCtr = (byte)9;
                                break;
                            }
                        }
                    }
                    if (this.waitCtr <= 8) ** GOTO lbl37
                    if (Math.abs(this.xDistance) > 3 * 24 >> 1) ** GOTO lbl-1000
                    if (Math.abs(this.yDistance) <= 24 && this.canvas.hero.action != 23 && this.canvas.hero.action != 25) {
                        this.action = (byte)2;
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.action = 0;
                    }
                    this.frame = 0;
                    this.waitCtr = 0;
                    break;
lbl37:
                    // 1 sources

                    this.waitCtr = (byte)(this.waitCtr + 1);
                    break;
                }
                case 1: {
                    this.dir = 1;
                    if (this.hidden || this.xPosition < this.canvas.hero.xPosition) break;
                    this.canvas.hero.action = (byte)10;
                    break;
                }
                case 2: {
                    if (this.canvas.hero.action != 25) {
                        if (Math.abs(this.yDistance) <= 24 * 3) {
                            if (!MyCanvas.intersectsOfSprites(0, this.canvas.hero.yPosition, MyCanvas.canvasWidth, 2, this.xPosition, this.yPosition, this.width, 2)) {
                                this.action = (byte)7;
                                this.yVel = (byte)(3 * (this.yDistance > 0 ? 1 : -1));
                                this.waitCtr = (byte)9;
                                break;
                            }
                        }
                    }
                    if (this.waitCtr <= 8) ** GOTO lbl66
                    if (Math.abs(this.xDistance) > 3 * 24 >> 1) ** GOTO lbl-1000
                    if (Math.abs(this.yDistance) <= 24 && this.canvas.hero.action != 23 && this.canvas.hero.action != 25) {
                        this.action = (byte)2;
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.action = 0;
                    }
                    this.frame = 0;
                    this.waitCtr = 0;
                    break;
lbl66:
                    // 1 sources

                    this.waitCtr = (byte)(this.waitCtr + 1);
                    break;
                }
                case 3: {
                    this.dir = (byte)(this.xDistance > 0 ? 1 : -1);
                    if (!MyCanvas.isStopLineTouch) {
                        if (Math.abs(this.tempX) > 48) {
                            if (this.waitCtr < 8) {
                                this.action = 0;
                                this.waitCtr = (byte)(this.waitCtr + 1);
                                break;
                            }
                            this.tempX = 0;
                            this.waitCtr = 0;
                            if (Math.abs(this.xDistance) > 24 || Math.abs(this.yDistance) > 24) break;
                            this.action = (byte)2;
                            break;
                        }
                        if (this.action == 2 || this.action == 6) break;
                        this.action = 1;
                        if (Math.abs(this.xDistance) <= 24 && Math.abs(this.yDistance) <= 24) {
                            if (this.waitCtr < 8) {
                                this.action = 0;
                                this.waitCtr = (byte)(this.waitCtr + 1);
                                break;
                            }
                            this.waitCtr = 0;
                            this.action = (byte)2;
                            break;
                        }
                        if (Math.abs(this.xDistance) > 24) break;
                        this.action = 0;
                        break;
                    }
                    if (this.action == 2 || this.action == 6) break;
                    if (Math.abs(this.xDistance) > 3 * 24 >> 1) break;
                    if (Math.abs(this.yDistance) > 24) break;
                    if (this.waitCtr < 10) {
                        this.waitCtr = (byte)(this.waitCtr + 1);
                        break;
                    }
                    this.action = (byte)2;
                    this.waitCtr = 0;
                    break;
                }
                case 4: {
                    if (Math.abs(this.xDistance) >= 24 << 4) {
                        if (Math.abs(this.yDistance) <= 24) {
                            if (Math.abs(this.tempX) <= 48) break;
                            if (this.waitCtr < 10) {
                                this.action = 0;
                                this.waitCtr = (byte)(this.waitCtr + 1);
                                break;
                            }
                            this.dir = (byte)(this.dir * -1);
                            this.tempX = 0;
                            this.waitCtr = 0;
                            break;
                        }
                    }
                    if (this.waitCtr > 11) {
                        this.action = (byte)2;
                        this.frame = 0;
                        this.frameCtr = 0;
                        this.waitCtr = 0;
                        break;
                    }
                    this.waitCtr = (byte)(this.waitCtr + 1);
                    if (this.action == 2) {
                        this.action = (byte)2;
                        break;
                    }
                    if (this.action == 6) {
                        this.action = (byte)6;
                        break;
                    }
                    this.action = 0;
                    break;
                }
                case 5: {
                    this.canvas.hero;
                    if (this.canvas.hero.action == 23) ** GOTO lbl142
                    if (MyCanvas.intersectsOfSprites(0, this.canvas.hero.yPosition, MyCanvas.canvasWidth, 2, this.xPosition, this.yPosition, this.width, 2)) ** GOTO lbl148
lbl142:
                    // 2 sources

                    this.action = (byte)8;
                    if (Math.abs(this.yDistance) <= 24 << 1) {
                        this.vDir = (byte)(this.yDistance >= 0 ? 1 : -1);
                    }
                    this.waitCtr = (byte)11;
                    break;
lbl148:
                    // 1 sources

                    if (this.waitCtr > 10) {
                        this.action = (byte)2;
                        this.waitCtr = 0;
                        break;
                    }
                    this.waitCtr = (byte)(this.waitCtr + 1);
                    break;
                }
                case 6: {
                    this.dir = (byte)(this.xDistance > 0 ? -1 : 1);
                    this.action = 0;
                    break;
                }
                case 7: {
                    this.dir = 1;
                    this.xVel = (byte)6;
                    this.yVel = (byte)3;
                    minlen = -this.width;
                    if (!this.isCutterEnd) {
                        if (this.tempX - this.xVel <= minlen) {
                            this.isCutterEnd = true;
                            break;
                        }
                        this.tempX -= this.xVel;
                        break;
                    }
                    if (this.counter < 10) {
                        this.frame = (byte)(this.frame + 1);
                        if (this.frame > 9) {
                            this.frame = 0;
                        }
                        this.waitCtr = (byte)(this.waitCtr + 1);
                        if (this.waitCtr % 20 != 0) break;
                        this.waitCtr = 0;
                        pos = new short[]{160, 96, 180, 121, 96, 121, 160, 96, 121, 96, 160, 180};
                        this.counter = (byte)(this.counter + 1);
                        this.canvas.addElementArr(new Elements(this.xPosition + this.tempX + pos[this.counter], this.yPosition, this.canvas.effectClip[68], this.canvas.effectClip[69], this.counter, 6, false, 63, 0, 0, this.canvas));
                        break;
                    }
                    this.tempY -= this.yVel;
                    if (this.tempY + this.height >= 0) break;
                    this.hidden = true;
                }
            }
        }
        try {
            if (this.type != 7) {
                this.callAction();
            }
            this.imageRotation = this.dir == 1 ? 0 : (byte)2;
            this.framePtr = (byte)(MyCanvas.enemyFramePos[this.actionFrmPtr] + this.frame);
            if (this.isDead && !this.hidden && this.type != 10 && this.type != 12 && this.type != 15 && this.type != 17 && this.type != 18) {
                this.deadCtr = (byte)(this.deadCtr + 1);
                if (this.deadCtr > 20) {
                    this.hidden = true;
                }
            }
        }
        catch (Exception var2_3) {
            // empty catch block
        }
        switch (this.type) {
            case 0: {
                if (this.hidden || this.canvas.isInView(this.xPosition, this.yPosition, this.width, this.height)) break;
                this.hidden = false;
                break;
            }
            case 7: {
                if (this.hidden || this.canvas.isInView(this.xPosition, this.yPosition, this.width, this.height)) break;
                this.hidden = true;
                break;
            }
            default: {
                if (this.hidden || this.canvas.isInView(this.xPosition, this.yPosition, this.width, this.height)) break;
                this.hidden = true;
                this.canvas.levelTileMap[this.tileY][this.tileX] = this.tileType;
            }
        }
    }

    public void draw(Graphics g) {
        this.update(g);
        switch (this.type) {
            case 7: {
                g.drawRegion(image[this.imageNo], (int)MyCanvas.enemyClipping[this.framePtr * 4], (int)MyCanvas.enemyClipping[this.framePtr * 4 + 1], (int)MyCanvas.enemyClipping[this.framePtr * 4 + 2], (int)MyCanvas.enemyClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.tempX + this.xPosition + (this.dir == 1 ? MyCanvas.enemyPlacingRt[this.framePtr * 2] : MyCanvas.enemyPlacingLf[this.framePtr * 2]), this.tempY + this.yPosition + (this.dir == 1 ? MyCanvas.enemyPlacingRt[this.framePtr * 2 + 1] : MyCanvas.enemyPlacingLf[this.framePtr * 2 + 1]), 0);
                break;
            }
            default: {
                g.drawRegion(image[this.imageNo], (int)MyCanvas.enemyClipping[this.framePtr * 4], (int)MyCanvas.enemyClipping[this.framePtr * 4 + 1], (int)MyCanvas.enemyClipping[this.framePtr * 4 + 2], (int)MyCanvas.enemyClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? MyCanvas.enemyPlacingRt[this.framePtr * 2] : MyCanvas.enemyPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? MyCanvas.enemyPlacingRt[this.framePtr * 2 + 1] : MyCanvas.enemyPlacingLf[this.framePtr * 2 + 1]), 0);
            }
        }
    }

    private boolean getDirectionAndVelocity(int currX, int currY, int destX, int destY, int accelaration) {
        boolean retVal = false;
        this.distX = Math.abs(currX - destX);
        this.distY = Math.abs(currY - destY);
        if (this.distX <= Math.abs(this.xVel * accelaration) && this.distY <= Math.abs(this.yVel * accelaration)) {
            return true;
        }
        this.xVel = 0;
        this.yVel = 0;
        if (this.distX == this.distY) {
            this.xVel = this.yVel = (byte)(3 * accelaration);
        } else if (this.distX > this.distY) {
            if (this.distY > this.distX / 10) {
                this.xVel = (byte)(3 * accelaration);
                this.yVel = (byte)(2 * accelaration);
            } else if (this.distY != 0) {
                this.xVel = (byte)(4 * accelaration);
                this.yVel = (byte)(1 * accelaration);
            } else {
                this.xVel = (byte)(4 * accelaration);
                this.yVel = (byte)(0 * accelaration);
            }
        } else if (this.distX > this.distY / 10) {
            this.yVel = (byte)(3 * accelaration);
            this.xVel = (byte)(2 * accelaration);
        } else if (this.distX != 0) {
            this.yVel = (byte)(4 * accelaration);
            this.xVel = (byte)(1 * accelaration);
        } else {
            this.yVel = (byte)(4 * accelaration);
            this.xVel = (byte)(0 * accelaration);
        }
        if (destX >= currX && destY <= currY) {
            this.xVel = (byte)(this.xVel * 1);
            this.yVel = (byte)(this.yVel * -1);
        } else if (destX >= currX && destY >= currY) {
            this.xVel = (byte)(this.xVel * 1);
            this.yVel = (byte)(this.yVel * 1);
        } else if (destX <= currX && destY >= currY) {
            this.xVel = (byte)(this.xVel * -1);
            this.yVel = (byte)(this.yVel * 1);
        } else if (destX <= currX && destY <= currY) {
            this.xVel = (byte)(this.xVel * -1);
            this.yVel = (byte)(this.yVel * -1);
        }
        return retVal;
    }

    private void blockHero() {
        if (MyCanvas.gameLevel != 1) {
            if (MyCanvas.intersectsOfSprites(this.canvas.hero.xPosition, this.canvas.hero.yPosition, this.canvas.hero.width >> 1, this.height >> 1, this.xPosition, this.yPosition, this.width >> 1, this.height >> 1)) {
                if (this.xDistance < 0 && this.canvas.hero.xPosition + (this.canvas.hero.width >> 1) >= this.xPosition) {
                    this.canvas.hero.xPosition = this.xPosition - (this.canvas.hero.width >> 1);
                }
                if (this.xDistance > 0 && this.xPosition + (this.width >> 1) >= this.canvas.hero.xPosition) {
                    this.canvas.hero.xPosition = this.xPosition + (this.width >> 1);
                }
            }
        }
    }
}

