/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Resources;
import sk.inlogic.World;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Stone {
    private int _iX = 0;
    private int _iY = 0;
    private int _iType = 0;
    private int _iTYPE_STONE_SMALL = 0;
    private int _iTYPE_STONE_MIDDLE = 1;
    private int _iTYPE_STONE_BIG = 2;
    private int _iTYPE_WOOD = 3;
    private int RANDOM_RANGE = 120;
    private int RANDOM_RATIO = 30;
    private boolean _bIsActive = false;
    private Sprite _sprStone;
    private Rectangle _rectStone;
    private World _world;

    public Stone(World world) {
        this._world = world;
        this.setStoneType();
        this._rectStone = new Rectangle();
    }

    public void activateStone(int x, int y) {
        this.setX(x);
        this.setY(y);
        if (this._world._tTiles[this.getX()][this.getY()].getType() != 0) {
            this.setActive(false);
            return;
        }
        this.setStoneType();
        this._rectStone = new Rectangle(this._world._tTiles[this.getX()][this.getY()].get_rectTile().x, this._world._tTiles[this.getX()][this.getY()].get_rectTile().y, this._world._tTiles[this.getX()][this.getY()].get_rectTile().width, this._world._tTiles[this.getX()][this.getY()].get_rectTile().height);
        this._world._tTiles[this.getX()][this.getY()].setEmpty(false);
        this.setActive(true);
    }

    private void setStoneType() {
        int _iTmpType = RandomNum.getRandomInt(this.RANDOM_RANGE, 0);
        if (_iTmpType < 0) {
            _iTmpType *= -1;
        }
        if (_iTmpType < this.RANDOM_RATIO) {
            this._iType = this._iTYPE_STONE_BIG;
            this._sprStone = Resources.resSprs[26];
        } else if (_iTmpType < this.RANDOM_RATIO * 2) {
            this._iType = this._iTYPE_STONE_MIDDLE;
            this._sprStone = Resources.resSprs[27];
        } else if (_iTmpType < this.RANDOM_RATIO * 3) {
            this._iType = this._iTYPE_STONE_SMALL;
            this._sprStone = Resources.resSprs[28];
        } else {
            this._iType = this._iTYPE_WOOD;
            this._sprStone = Resources.resSprs[29];
        }
    }

    public void update() {
        if (this._world._tTiles[this.getX()][this.getY()].getType() != 0) {
            this.deactivate();
        }
        if (this.isActive() && this._rectStone != null) {
            this._rectStone.y = this._world._tTiles[this.getX()][this.getY()].get_rectTile().y;
            if (this._rectStone.y > this._world.getHeight()) {
                this.deactivate();
            }
            if (this._sprStone.getY() + (this._sprStone.getHeight() >> 3) >= this._world.getHeight()) {
                this.deactivate();
            }
            if (this._rectStone.y >= this._world.getHeight()) {
                this.deactivate();
            }
            if (this._rectStone.y + this._rectStone.height >= this._world.getHeight()) {
                this.deactivate();
            }
            if (this._sprStone.getY() >= this._world.getHeight()) {
                this.deactivate();
            }
        }
        if (this._rectStone == null) {
            this.deactivate();
        }
    }

    public void paint(Graphics g) {
        if (this.isActive() && this._rectStone != null) {
            this._sprStone.setPosition(this._rectStone.x, this._rectStone.y);
            this._sprStone.paint(g);
        }
    }

    private void deactivate() {
        this._world._tTiles[this.getX()][this.getY()].setEmpty(true);
        this.setActive(false);
    }

    public void setX(int _iX) {
        this._iX = _iX;
    }

    public int getX() {
        return this._iX;
    }

    public void setY(int _iY) {
        this._iY = _iY;
    }

    public int getY() {
        return this._iY;
    }

    public void set_iType(int _iType) {
        this._iType = _iType;
    }

    public int get_iType() {
        return this._iType;
    }

    public void setActive(boolean _bIsActive) {
        this._bIsActive = _bIsActive;
    }

    public boolean isActive() {
        return this._bIsActive;
    }

    public void setRect(Rectangle _rectTree) {
        this._rectStone = _rectTree;
    }

    public Rectangle getRect() {
        return this._rectStone;
    }
}

