/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Car;
import sk.inlogic.Character;
import sk.inlogic.Coin;
import sk.inlogic.Resources;
import sk.inlogic.Stone;
import sk.inlogic.Tile;
import sk.inlogic.Train;
import sk.inlogic.Tree;
import sk.inlogic.Wood;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.RandomNum;

public class World {
    public static final int _iTILE_TYPE_GRASS = 0;
    public static final int _iTILE_TYPE_WATTER = 1;
    public static final int _iTILE_TYPE_ROAD = 2;
    public static final int _iTILE_TYPE_TRAIL = 3;
    public static final int _iTILE_TYPE_TOTAL = 4;
    public static final int _iTOTOAL_CARS = 500;
    public static final int _iTOTOAL_COINS = 500;
    public static final int _iTOTOAL_STONES = 500;
    public static final int _iTOTOAL_WOODS = 500;
    public static final int _iTOTOAL_TREES = 500;
    public static final int _iTOTOAL_TRAINS = 500;
    private int _iWIDTH = 0;
    private int _iHEIGHT = 0;
    public int _iTOTAL_ROWS;
    public int _iTOTAL_COLS;
    private int _iRandomRange = 4000;
    private int _iRandomPiece = 0;
    private int _iShiftWorldY = 1;
    private int _iOffsetX = 0;
    private int _iScore = 0;
    private int _iMoves = 0;
    private int _iEarnedCoins = 0;
    private int _iCheckBackJmp = 0;
    private boolean _bUpdatePause = false;
    private boolean _bIsGameOver = false;
    private boolean _bIsGameOverBirdAnim = false;
    private int[][] _iWorld;
    private Sprite _sprTile;
    public Tile[][] _tTiles;
    private Character _cCharacter;
    private Car[] _cCars;
    private Coin[] _cCoins;
    private Stone[] _sStones;
    private Wood[] _wWoods;
    private Tree[] _tTrees;
    private Train[] _tTrain;
    private PreparedText _ptNum = new PreparedText(Resources.resGFonts[0]);
    boolean water = false;
    int lastTile = -1;
    boolean s = false;
    boolean start = true;

    public World(int _width, int _height, Sprite _sprUp, Sprite _sprRight) {
        this.setHeight(_height);
        this.setWidth(_width);
        this.initSprites();
        this.initVar();
        this.initWorld();
        this.createWorld();
        this.createCharacter(_sprUp, _sprRight);
        this.initDecors();
        this.createDecors();
    }

    void initSprites() {
        this._sprTile = Resources.resSprs[12];
    }

    void initVar() {
        this._iEarnedCoins = 0;
        this._iScore = 0;
        this._iMoves = 0;
        this._iCheckBackJmp = 0;
        this.setGameOver(false, "Reset");
        this.setBirdAnim(false);
        if (this._sprTile == null) {
            this._sprTile = Resources.resSprs[12];
        }
        this._iTOTAL_ROWS = this.getHeight() / this._sprTile.getHeight() + 200;
        this._iTOTAL_COLS = this.getWidth() / this._sprTile.getWidth();
        this._iOffsetX = this.getWidth() % this._sprTile.getWidth() >> 1;
        if (this._iOffsetX > 0) {
            this._iTOTAL_COLS += 2;
            this._iOffsetX -= this._sprTile.getWidth();
        }
        this._iRandomPiece = this._iRandomRange / 4;
        this.set_iShiftWorldY(1);
    }

    void initDecors() {
        int i;
        this._cCars = new Car[500];
        this._cCoins = new Coin[500];
        this._sStones = new Stone[500];
        this._tTrees = new Tree[this._iTOTAL_ROWS * this._iTOTAL_COLS];
        this._tTrain = new Train[500];
        this._wWoods = new Wood[500];
        for (i = 0; i < this._wWoods.length - 1; ++i) {
            this._wWoods[i] = new Wood(this);
            this._wWoods[i].setActive(false);
            this._wWoods[i].setMoveable(false);
        }
        for (i = 0; i < this._tTrain.length - 1; ++i) {
            this._tTrain[i] = null;
            this._tTrain[i] = new Train(this);
            this._tTrain[i].setActive(false);
            this._tTrain[i].setMoveable(false);
        }
        for (i = 0; i < this._tTrees.length - 1; ++i) {
            this._tTrees[i] = new Tree(this);
            this._tTrees[i].setActive(false);
        }
        for (i = 0; i < this._sStones.length - 1; ++i) {
            this._sStones[i] = new Stone(this);
            this._sStones[i].setActive(false);
        }
        for (i = 0; i < this._cCoins.length - 1; ++i) {
            this._cCoins[i] = new Coin(this);
            this._cCoins[i].setActive(false);
        }
    }

    void initWorld() {
        this._iWorld = new int[this._iTOTAL_COLS][this._iTOTAL_ROWS];
        this._tTiles = new Tile[this._iTOTAL_COLS][this._iTOTAL_ROWS];
    }

    void createWorld() {
        int _iRandomType = this.getRandomTileType();
        for (int y = 0; y < this._iTOTAL_ROWS; ++y) {
            for (int x = 0; x < this._iTOTAL_COLS; ++x) {
                if (y < 4) {
                    this._tTiles[x][y] = new Tile(this, 0, x, y, this._iOffsetX);
                    this._iWorld[x][y] = 0;
                    continue;
                }
                if (_iRandomType == 1 && this.lastTile == 1) {
                    while ((_iRandomType = this.getRandomTileType()) != 1) {
                    }
                }
                this.lastTile = _iRandomType;
                this._tTiles[x][y] = new Tile(this, _iRandomType, x, y, this._iOffsetX);
                this._iWorld[x][y] = _iRandomType;
            }
            _iRandomType = this.getRandomTileType();
        }
    }

    void createDecors() {
        boolean _tmpWoodY = false;
        boolean _iTmpTree = false;
        int _iTmpRnd = Math.abs(RandomNum.getRandomInt(150, 0));
        for (int y = 0; y < this._iTOTAL_ROWS; ++y) {
            if (this._tTiles[0][y].getType() == 0) {
                if (y == 0) {
                    for (int x = 0; x < this._iTOTAL_COLS; ++x) {
                        if (Math.abs(RandomNum.getRandomInt(200, 0)) > 100) {
                            this.getFreeStone(x, y);
                            continue;
                        }
                        this.getFreeTree(x, y);
                    }
                } else if (y != 0) {
                    if (Math.abs(RandomNum.getRandomInt(200, 0)) > 100) {
                        this.getFreeStone(0, y);
                    } else {
                        this.getFreeTree(0, y);
                    }
                    if (Math.abs(RandomNum.getRandomInt(200, 0)) > 100) {
                        this.getFreeStone(this._iTOTAL_COLS - 1, y);
                    } else {
                        this.getFreeTree(this._iTOTAL_COLS - 1, y);
                    }
                    _iTmpRnd = Math.abs(RandomNum.getRandomInt(150, 0));
                    if (_iTmpRnd < 50) {
                        if (Math.abs(RandomNum.getRandomInt(200, 0)) > 100) {
                            this.getFreeStone(this._iTOTAL_COLS >> 1, y);
                        } else {
                            this.getFreeTree(this._iTOTAL_COLS >> 1, y);
                        }
                    } else if (_iTmpRnd < 100 && y != 3) {
                        if (Math.abs(RandomNum.getRandomInt(200, 0)) > 100) {
                            this.getFreeStone((this._iTOTAL_COLS >> 1) - 1, y);
                        } else {
                            this.getFreeTree((this._iTOTAL_COLS >> 1) - 1, y);
                        }
                    } else if (_iTmpRnd < 150) {
                        if (Math.abs(RandomNum.getRandomInt(200, 0)) > 100) {
                            this.getFreeStone((this._iTOTAL_COLS >> 1) + 1, y);
                        } else {
                            this.getFreeTree((this._iTOTAL_COLS >> 1) + 1, y);
                        }
                    }
                }
            } else if (this._tTiles[0][y].getType() == 2) {
                this.getFreeCar(0, y, this._tTiles[0][y].getType());
            } else if (this._tTiles[0][y].getType() == 3) {
                this.getFreeTrains(0, y);
            } else if (this._tTiles[0][y].getType() == 1) {
                this.getFreeWood(0, y, "create ");
            }
            this.addCoin();
        }
    }

    private void addCoin() {
        int _iTmpCol = Math.abs(RandomNum.getRandomInt(this._iTOTAL_COLS - 1, 0));
        int _iTmpRow = Math.abs(RandomNum.getRandomInt(this._iTOTAL_ROWS - 1, 0));
        if (Math.abs(RandomNum.getRandomInt(100, 0)) < 20 && this._tTiles[_iTmpCol][_iTmpRow].getType() != 1 && this._tTiles[_iTmpCol][_iTmpRow].isEmpty()) {
            this.getFreeCoin(_iTmpCol, _iTmpRow);
        }
    }

    private Wood getFreeWood(int x, int y, String message) {
        for (int _iDx = 0; _iDx < this._wWoods.length - 1; ++_iDx) {
            if (this._wWoods[_iDx].getY() == y) continue;
            if (this._wWoods[_iDx] == null) {
                this._wWoods[_iDx] = new Wood(this);
                this._wWoods[_iDx].activeWood(0, y, Math.abs(RandomNum.getRandomInt(60, 0)) / 50, Math.abs(RandomNum.getRandomInt(240, 0)) / 15);
                System.out.println(message + " Call create decor 1: " + y);
                return null;
            }
            if (this._wWoods[_iDx].isActive()) continue;
            this._wWoods[_iDx] = new Wood(this);
            this._wWoods[_iDx].activeWood(0, y, Math.abs(RandomNum.getRandomInt(60, 0)) / 50, Math.abs(RandomNum.getRandomInt(240, 0)) / 15);
            return null;
        }
        return null;
    }

    private void getFreeCar(int x, int y, int type) {
        for (int _iDx = 0; _iDx < this._cCars.length - 1; ++_iDx) {
            if (this._cCars[_iDx] == null) {
                this._cCars[_iDx] = new Car(this);
                this._cCars[_iDx].activeCar(0, y, Math.abs(RandomNum.getRandomInt(60, 0)) / 50, Math.abs(RandomNum.getRandomInt(60, 0)) / 15, type);
                return;
            }
            if (this._cCars[_iDx].isActive()) continue;
            this._cCars[_iDx] = new Car(this);
            this._cCars[_iDx].activeCar(0, y, Math.abs(RandomNum.getRandomInt(60, 0)) / 50, Math.abs(RandomNum.getRandomInt(60, 0)) / 15, type);
            return;
        }
    }

    private void getFreeTrains(int x, int y) {
        for (int _iDx = 0; _iDx < this._tTrain.length - 1; ++_iDx) {
            if (this._tTrain[_iDx] == null) {
                this._tTrain[_iDx] = new Train(this);
                this._tTrain[_iDx].activateTrain(0, y);
                return;
            }
            if (this._tTrain[_iDx].isActive()) continue;
            this._tTrain[_iDx] = new Train(this);
            this._tTrain[_iDx].activateTrain(0, y);
            return;
        }
    }

    private void getFreeTree(int x, int y) {
        for (int _iDx = 0; _iDx < this._tTrees.length - 1; ++_iDx) {
            if (this._tTrees[_iDx] == null) {
                this._tTrees[_iDx] = new Tree(this);
                this._tTrees[_iDx].activateTree(x, y);
                return;
            }
            if (this._tTrees[_iDx].isActive()) continue;
            this._tTrees[_iDx] = new Tree(this);
            this._tTrees[_iDx].activateTree(x, y);
            return;
        }
    }

    private void getFreeStone(int x, int y) {
        for (int _iDx = 0; _iDx < this._sStones.length - 1; ++_iDx) {
            if (this._sStones[_iDx] == null) {
                this._sStones[_iDx] = new Stone(this);
                this._sStones[_iDx].activateStone(x, y);
                return;
            }
            if (this._sStones[_iDx].isActive()) continue;
            this._sStones[_iDx] = new Stone(this);
            this._sStones[_iDx].activateStone(x, y);
            return;
        }
    }

    private void getFreeCoin(int x, int y) {
        for (int _iDx = 0; _iDx < this._cCoins.length - 1; ++_iDx) {
            if (this._cCoins[_iDx] == null) {
                this._cCoins[_iDx] = new Coin(this);
                this._cCoins[_iDx].activateCoin(x, y);
                return;
            }
            if (this._cCoins[_iDx].isActive()) continue;
            this._cCoins[_iDx] = new Coin(this);
            this._cCoins[_iDx].activateCoin(x, y);
            return;
        }
    }

    private void createCharacter(Sprite _sprUp, Sprite _sprRight) {
        this._cCharacter = new Character(this, _sprUp, _sprRight, this._iTOTAL_COLS / 2, 3);
    }

    public int getRandomTileType() {
        int _type = RandomNum.getRandomInt(this._iRandomRange, 0);
        if (_type < 0) {
            _type *= -1;
        }
        if (_type < this._iRandomPiece - (this._iRandomPiece >> 3)) {
            return 0;
        }
        if (_type < this._iRandomPiece * 2) {
            return 2;
        }
        if (_type < this._iRandomPiece * 3) {
            return 2;
        }
        if (_type < this._iRandomPiece * 4) {
            return 3;
        }
        _type = RandomNum.getRandomInt(3, 2);
        return _type < 0 ? _type + -1 : _type;
    }

    private void resetRow(int _x, int _y) {
        this.disableDecorsOnPosition(_x, _y);
        int _tmpType = this.getRandomTileType();
        this._bUpdatePause = true;
        int _iTmpReset = 0;
        for (int x = 0; x < this._iTOTAL_COLS; ++x) {
            if (_tmpType == 1 && this.lastTile == 1) {
                while ((_tmpType = this.getRandomTileType()) != 1) {
                }
            }
            this.lastTile = _tmpType;
            this._tTiles[x][_y].resetTile(_tmpType, this._iTOTAL_ROWS);
        }
        if (_iTmpReset == 0) {
            this.resetDecorsInRow(0, _y);
            ++_iTmpReset;
        }
        this._bUpdatePause = false;
    }

    private void resetDecorsInRow(int _x, int _y) {
        int _iTmpWoods = 0;
        int _iTmpCars = 0;
        int _iTmpTrails = 0;
        int _iTmpTrees = 0;
        int _iTmpRnd = 0;
        for (int x = 0; x < this._iTOTAL_COLS; ++x) {
            if (this._tTiles[x][_y].getType() == 0) {
                if (_iTmpTrees == 0) {
                    this.getFreeTree(0, _y);
                    this.getFreeTree(this._iTOTAL_COLS - 1, _y);
                    ++_iTmpTrees;
                    if (Math.abs(RandomNum.getRandomInt(200, 0)) > 100) {
                        this.getFreeStone(0, _y);
                    } else {
                        this.getFreeTree(0, _y);
                    }
                    if (Math.abs(RandomNum.getRandomInt(200, 0)) > 100) {
                        this.getFreeStone(this._iTOTAL_COLS - 1, _y);
                    } else {
                        this.getFreeTree(this._iTOTAL_COLS - 1, _y);
                    }
                    _iTmpRnd = Math.abs(RandomNum.getRandomInt(150, 0));
                    if (_iTmpRnd < 50) {
                        if (Math.abs(RandomNum.getRandomInt(200, 0)) > 100) {
                            this.getFreeStone(this._iTOTAL_COLS >> 1, _y);
                        } else {
                            this.getFreeTree(this._iTOTAL_COLS >> 1, _y);
                        }
                    } else if (_iTmpRnd < 100 && _y != 3) {
                        if (Math.abs(RandomNum.getRandomInt(200, 0)) > 100) {
                            this.getFreeStone((this._iTOTAL_COLS >> 1) - 1, _y);
                        } else {
                            this.getFreeTree((this._iTOTAL_COLS >> 1) - 1, _y);
                        }
                    } else if (_iTmpRnd < 150) {
                        if (Math.abs(RandomNum.getRandomInt(200, 0)) > 100) {
                            this.getFreeStone((this._iTOTAL_COLS >> 1) + 1, _y);
                        } else {
                            this.getFreeTree((this._iTOTAL_COLS >> 1) + 1, _y);
                        }
                    }
                }
                if (_iTmpCars > 0) continue;
                this.getFreeCar(x, _y, this._tTiles[0][_y].getType());
                ++_iTmpCars;
                continue;
            }
            if (this._tTiles[x][_y].getType() == 2) {
                if (_iTmpCars > 0) continue;
                this.getFreeCar(x, _y, this._tTiles[x][_y].getType());
                this._tTiles[x][_y].resetTile(1, this._iTOTAL_ROWS);
                ++_iTmpCars;
                continue;
            }
            if (this._tTiles[x][_y].getType() == 3) {
                if (_iTmpTrails != 0) continue;
                this.getFreeTrains(x, _y);
                ++_iTmpTrails;
                continue;
            }
            if (this._tTiles[x][_y].getType() != 1 || _y < this.getCharacter().get_iY() || _iTmpWoods != 0) continue;
            this.getFreeWood(x, _y, "reset ");
            ++_iTmpWoods;
        }
    }

    public void updateWorld(long lastRunLenght, boolean updateDecors) {
        if (updateDecors) {
            this.updateDecors(lastRunLenght);
            return;
        }
        if (this._bUpdatePause) {
            return;
        }
        for (int y = 0; y < this._iTOTAL_ROWS; ++y) {
            for (int x = 0; x < this._iTOTAL_COLS; ++x) {
                this._tTiles[x][y].incShiftY(this.get_iShiftWorldY());
                if (!this._tTiles[x][y].isReset()) continue;
                this.disableDecorsOnPosition(this._tTiles[x][y].getX(), this._tTiles[x][y].getY());
                this.disableDecorsOnPosition(x, y);
                this.resetRow(x, y);
                return;
            }
        }
        this.updateDecors(lastRunLenght);
        this._cCharacter.update();
    }

    private void updateDecors(long lastRunLenght) {
        int _iDx;
        for (_iDx = 0; _iDx < this._wWoods.length - 1; ++_iDx) {
            if (!this._wWoods[_iDx].isActive()) continue;
            this._wWoods[_iDx].update();
        }
        for (_iDx = 0; _iDx < this._cCars.length - 1; ++_iDx) {
            if (this._cCars[_iDx] == null || !this._cCars[_iDx].isActive()) continue;
            this._cCars[_iDx].update();
        }
        for (_iDx = 0; _iDx < this._tTrain.length - 1; ++_iDx) {
            if (!this._tTrain[_iDx].isActive()) continue;
            this._tTrain[_iDx].update(lastRunLenght);
        }
        for (_iDx = 0; _iDx < this._tTrees.length - 1; ++_iDx) {
            if (!this._tTrees[_iDx].isActive()) continue;
            this._tTrees[_iDx].update();
        }
        for (_iDx = 0; _iDx < this._sStones.length - 1; ++_iDx) {
            if (!this._sStones[_iDx].isActive()) continue;
            this._sStones[_iDx].update();
        }
        for (_iDx = 0; _iDx < this._cCoins.length - 1; ++_iDx) {
            if (!this._cCoins[_iDx].isActive()) continue;
            this._cCoins[_iDx].update();
            if (!this._cCoins[_iDx].collectCoin()) continue;
            ++this._iScore;
        }
    }

    public void paint(Graphics _g) {
        this.paintWorld(_g);
        this.paintDecors(_g);
        this.paintCharacter(_g);
        this.checkGameOver();
    }

    private void paintWorld(Graphics _g) {
        for (int y = 0; y < this._iTOTAL_ROWS; ++y) {
            for (int x = 0; x < this._iTOTAL_COLS; ++x) {
                this._tTiles[x][y].paint(_g);
            }
        }
    }

    private void paintDecors(Graphics _g) {
        int _iDx;
        for (_iDx = this._cCoins.length - 1; _iDx > 0; --_iDx) {
            if (this._cCoins[_iDx] == null || !this._cCoins[_iDx].isActive()) continue;
            this._cCoins[_iDx].paint(_g);
        }
        for (_iDx = this._sStones.length - 1; _iDx > 0; --_iDx) {
            if (this._sStones[_iDx] == null || !this._sStones[_iDx].isActive()) continue;
            this._sStones[_iDx].paint(_g);
        }
        for (_iDx = this._cCars.length - 1; _iDx > 0; --_iDx) {
            if (this._cCars[_iDx] == null || !this._cCars[_iDx].isActive()) continue;
            this._cCars[_iDx].paint(_g);
        }
        for (_iDx = this._tTrain.length - 1; _iDx > 0; --_iDx) {
            if (this._tTrain[_iDx] == null || !this._tTrain[_iDx].isActive()) continue;
            this._tTrain[_iDx].paint(_g);
        }
        for (_iDx = 0; _iDx < this._wWoods.length - 1; ++_iDx) {
            if (!this._wWoods[_iDx].isActive()) continue;
            this._wWoods[_iDx].paint(_g);
        }
        for (_iDx = this._tTrees.length - 1; _iDx > 0; --_iDx) {
            if (this._tTrees[_iDx] == null || !this._tTrees[_iDx].isActive()) continue;
            this._tTrees[_iDx].paint(_g);
        }
    }

    private void checkGameOver() {
        int _iDx;
        for (_iDx = 0; _iDx < this._cCars.length - 1; ++_iDx) {
            if (this._cCars[_iDx] == null || !this._cCars[_iDx].isActive() || !this._cCars[_iDx].isGameOver()) continue;
            this.setGameOver(true, "Car collision");
        }
        for (_iDx = 0; _iDx < this._tTrain.length - 1; ++_iDx) {
            if (!this._tTrain[_iDx].isActive() || !this._tTrain[_iDx].isGameOver()) continue;
            this.setGameOver(true, "Train collision");
        }
    }

    private void disableDecorsOnPosition(int x, int y) {
        int _iDx;
        for (_iDx = this._tTrees.length - 1; _iDx > 0; --_iDx) {
            if (this._tTrees[_iDx] == null || this._tTrees[_iDx].getX() != x || this._tTrees[_iDx].getX() != y) continue;
            this._tTrees[_iDx].setActive(false);
            System.out.println("deactive tree on position- x: " + this._tTrees[_iDx].getX() + " ,y: " + this._tTrees[_iDx].getY());
            return;
        }
        for (_iDx = this._cCoins.length - 1; _iDx > 0; --_iDx) {
            if (this._cCoins[_iDx] == null || this._cCoins[_iDx].getX() != x || this._cCoins[_iDx].getX() != y) continue;
            this._cCoins[_iDx].setActive(false);
            return;
        }
        for (_iDx = this._tTrain.length - 1; _iDx > 0; --_iDx) {
            if (this._tTrain[_iDx] == null || this._tTrain[_iDx].getX() != x || this._tTrain[_iDx].getX() != y) continue;
            this._tTrain[_iDx].setActive(false);
            return;
        }
        for (_iDx = this._sStones.length - 1; _iDx > 0; --_iDx) {
            if (this._sStones[_iDx] == null || this._sStones[_iDx].getX() != x || this._sStones[_iDx].getX() != y) continue;
            this._sStones[_iDx].setActive(false);
            return;
        }
        for (_iDx = this._cCars.length - 1; _iDx > 0; --_iDx) {
            if (this._cCars[_iDx] == null || this._cCars[_iDx].getX() != x || this._cCars[_iDx].getX() != y) continue;
            this._cCars[_iDx].setActive(false);
            return;
        }
    }

    private void paintCharacter(Graphics _g) {
        this._cCharacter.paint(_g);
    }

    public void setTOTAL_ROWS(int _iTOTAL_ROWS) {
        this._iTOTAL_ROWS = _iTOTAL_ROWS;
    }

    public int getTOTAL_ROWS() {
        return this._iTOTAL_ROWS;
    }

    public void setTOTAL_COLS(int _iTOTAL_COLS) {
        this._iTOTAL_COLS = _iTOTAL_COLS;
    }

    public int getTOTAL_COLS() {
        return this._iTOTAL_COLS;
    }

    public void setHeight(int _iHEIGHT) {
        this._iHEIGHT = _iHEIGHT;
    }

    public int getHeight() {
        return this._iHEIGHT;
    }

    public void setWidth(int _iWIDTH) {
        this._iWIDTH = _iWIDTH;
    }

    public int getWidth() {
        return this._iWIDTH;
    }

    public void setScore(int _iScore) {
        this._iScore = _iScore;
    }

    public int getScore() {
        return this._iScore;
    }

    public int getEarnedCoins() {
        return this._iEarnedCoins;
    }

    public void setEarnedCoins(int value) {
        this._iEarnedCoins = value;
    }

    public void incEarnedCoins(int value) {
        this._iEarnedCoins += value;
    }

    public Character getCharacter() {
        return this._cCharacter;
    }

    public void characterMoveUp() {
        this._cCharacter.moveUp();
        if (this._iCheckBackJmp <= 0) {
            if (this._cCharacter.isEnableIncScore()) {
                ++this._iMoves;
            } else if (this._cCharacter.isEnableIncScore()) {
                --this._iCheckBackJmp;
            }
        }
    }

    public void characterMoveDown() {
        this._cCharacter.moveDown();
        ++this._iCheckBackJmp;
    }

    public void characterMoveRight() {
        this._cCharacter.moveRight();
    }

    public void characterMoveLeft() {
        this._cCharacter.moveLeft();
    }

    public void setGameOver(boolean _bIsGameOver, String name) {
        this._bIsGameOver = _bIsGameOver;
    }

    public boolean isGameOver() {
        return this._bIsGameOver;
    }

    public void setBirdAnim(boolean _bIsGameOverBirdAnim) {
        this._bIsGameOverBirdAnim = _bIsGameOverBirdAnim;
    }

    public boolean isBirdAnim() {
        return this._bIsGameOverBirdAnim;
    }

    public void set_iShiftWorldY(int _iShiftWorldY) {
        this._iShiftWorldY = _iShiftWorldY;
    }

    public int get_iShiftWorldY() {
        return this._iShiftWorldY;
    }

    public void setMoves(int _iMoves) {
        this._iMoves = _iMoves;
    }

    public int getMoves() {
        return this._iMoves;
    }
}

