/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSplash
implements IScreen {
    private MainCanvas mainCanvas;
    private static int _WIDTH = 0;
    private static int _HEIGHT = 0;
    private int _iActualMode;
    private long _lModeDelay = 3000L;
    private static final int MODE_ENABLE_MUSIC_QUESTION = 0;
    private static final int MODE_COMPANY_LOGO = 1;
    private static final int MODE_SPLASH = 2;
    private static final int MODE_TIME = 3000;
    private int _ANIM_LOGO = 0;
    private int _ANIM_QUEST = 1;
    private int _ANIM_YES = 2;
    private int _ANIM_NO = 3;
    private int _ANIM_TOTAL = 4;
    private int _BUTTON_NO = 0;
    private int _BUTTON_YES = 1;
    private int _TOTAL_BUTTONS = 2;
    private int _iInteruption = 0;
    private boolean _bHideLogo = false;
    private boolean _bHideQuest = false;
    private AnimationComponent[] _animationComponent = new AnimationComponent[this._ANIM_TOTAL];
    private Rectangle _rectLeftFk;
    private Rectangle _rectRightFk;
    private Rectangle _rectBB_BACK;
    private Rectangle _rectBB_MENU;
    private Rectangle _rectLogo;
    private Rectangle _rectQuestion;
    private Rectangle[] rectButton = new Rectangle[this._TOTAL_BUTTONS];
    private PreparedText _ptNavigationKeysBB;
    private PreparedText _ptSoundQuestions;
    private Image _imgCorpLogo;
    private Image _imgIconYes;
    private Image _imgIconNo;
    private Sprite _icons;
    private Sprite _sprCheckBox;
    private int _selectedButton = 0;
    boolean startMusic = false;

    public ScreenSplash(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
        this.initDimensions();
    }

    public void beforeShow() {
        this._iActualMode = 0;
        this._iActualMode = 2;
        Resources.loadImages(new int[]{0, 3, 4});
        Resources.loadSprites(new int[]{42});
        Resources.loadGFont(0);
        Resources.loadText(0);
        this.initImages();
        this.initSprites();
        this.prepareTxt();
        this.calculatePosition();
        this.initAnimationControllers();
        System.out.println("Screen Splash");
    }

    public void afterHide() {
        Resources.freeImages(new int[]{0, 3, 4});
        Resources.freeSprites(new int[]{42});
        Resources.loadGFont(0);
        this.freeGraphics();
    }

    public void calculatePosition() {
        int _iItemHeight = this._sprCheckBox.getHeight();
        int _iItemWidth = this._sprCheckBox.getWidth();
        this._rectLogo = new Rectangle(_WIDTH >> 1, _HEIGHT >> 1, this._imgCorpLogo.getWidth(), this._imgCorpLogo.getHeight());
        this._rectQuestion = new Rectangle(0, 0, _WIDTH, _HEIGHT);
        this.rectButton[this._BUTTON_NO] = new Rectangle(0, _HEIGHT - _iItemHeight, _iItemWidth, _iItemHeight);
        this.rectButton[this._BUTTON_YES] = new Rectangle(_WIDTH - _iItemWidth, _HEIGHT - _iItemHeight, _iItemWidth, _iItemHeight);
        this._rectBB_BACK = new Rectangle(0, _HEIGHT - _iItemHeight, _WIDTH - _iItemWidth, _iItemHeight);
        this._rectBB_MENU = new Rectangle(_iItemWidth, _HEIGHT - _iItemHeight, _WIDTH, _iItemHeight);
    }

    private void initAnimationControllers() {
        this._animationComponent[this._ANIM_LOGO] = new AnimationComponent(this.mainCanvas, this._rectLogo, _WIDTH, _HEIGHT, 0, 0);
        this._animationComponent[this._ANIM_LOGO].startShowAnimation(2);
        this._animationComponent[this._ANIM_QUEST] = new AnimationComponent(this.mainCanvas, this._rectQuestion, _WIDTH, _HEIGHT, 0, 0);
        this._animationComponent[this._ANIM_QUEST].startShowAnimation(2);
        this._animationComponent[this._ANIM_YES] = new AnimationComponent(this.mainCanvas, this.rectButton[this._BUTTON_YES], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponent[this._ANIM_YES].startShowAnimation(1);
        this._animationComponent[this._ANIM_NO] = new AnimationComponent(this.mainCanvas, this.rectButton[this._BUTTON_NO], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponent[this._ANIM_NO].startShowAnimation(0);
    }

    private void initDimensions() {
        _WIDTH = this.mainCanvas.getWidth();
        _HEIGHT = this.mainCanvas.getHeight();
    }

    private void initImages() {
        this._imgCorpLogo = Resources.resImgs[0];
        this._imgIconYes = Resources.resImgs[3];
        this._imgIconNo = Resources.resImgs[4];
    }

    private void initSprites() {
        this._sprCheckBox = Resources.resSprs[42];
    }

    private void freeGraphics() {
        this._imgCorpLogo = null;
        this._imgIconYes = null;
        this._imgIconNo = null;
        this._sprCheckBox = null;
    }

    private void prepareTxt() {
        this._ptSoundQuestions = new PreparedText(Resources.resGFonts[0]);
        this._ptSoundQuestions.prepareText(Resources.resTexts[0].getHashedString(5), MainCanvas.WIDTH);
        this._ptNavigationKeysBB = new PreparedText(Resources.resGFonts[0]);
    }

    public void beforeInteruption() {
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
    }

    public void update(long lastRunLenght) {
        if (this._iActualMode == 2) {
            if (!this._bHideLogo) {
                this._animationComponent[this._ANIM_LOGO].update();
            }
            this._lModeDelay -= lastRunLenght;
            if (this._lModeDelay < 0L) {
                if (this.startMusic) {
                    Settings.musicOn = true;
                    MainCanvas.music = true;
                    MainCanvas.soundManager.SetSoundOn(true);
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    }
                } else {
                    Settings.musicOn = false;
                    MainCanvas.music = false;
                    MainCanvas.soundManager.SetSoundOn(false);
                }
                if (!this._bHideLogo) {
                    this._animationComponent[this._ANIM_LOGO].startHideAnimation(2);
                    this._bHideLogo = true;
                }
                if (!this._animationComponent[this._ANIM_LOGO].isComponentAnimated()) {
                    this._animationComponent[this._ANIM_LOGO].update();
                    return;
                }
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
                this.mainCanvas.repaint();
                this.mainCanvas.serviceRepaints();
            }
        } else if (this._iActualMode == 0) {
            if (this._bHideQuest) {
                if (!this._animationComponent[this._ANIM_QUEST].isComponentAnimated()) {
                    this._animationComponent[this._ANIM_QUEST].update();
                    this._animationComponent[this._ANIM_YES].update();
                    this._animationComponent[this._ANIM_NO].update();
                    return;
                }
                this._iActualMode = 2;
            } else {
                this._animationComponent[this._ANIM_QUEST].update();
                this._animationComponent[this._ANIM_YES].update();
                this._animationComponent[this._ANIM_NO].update();
            }
        }
    }

    public void paint(Graphics g) {
        this.paintBackgroundColor(g);
        if (this._iActualMode == 0) {
            this.paintMusicQuestion(g);
            this.paintFK(g);
            return;
        }
        this.paintCorpLogo(g);
    }

    private void paintBackgroundColor(Graphics g) {
        g.setColor(11856989);
        g.fillRect(0, 0, _WIDTH, _HEIGHT);
    }

    private void paintCorpLogo(Graphics g) {
        g.drawImage(this._imgCorpLogo, this._rectLogo.x, this._rectLogo.y, 3);
    }

    private void paintMusicQuestion(Graphics g) {
        this._ptSoundQuestions.drawText(g, this._rectQuestion, 0, 3);
    }

    public void paintFK(Graphics g) {
        this._sprCheckBox.setPosition(this.rectButton[this._BUTTON_YES].x, this.rectButton[this._BUTTON_YES].y);
        this._sprCheckBox.paint(g);
        this._sprCheckBox.setPosition(this.rectButton[this._BUTTON_NO].x, this.rectButton[this._BUTTON_NO].y);
        this._sprCheckBox.paint(g);
        g.drawImage(this._imgIconYes, this.rectButton[this._BUTTON_YES].getCenterX(), this.rectButton[this._BUTTON_YES].getCenterY(), 3);
        g.drawImage(this._imgIconNo, this.rectButton[this._BUTTON_NO].getCenterX(), this.rectButton[this._BUTTON_NO].getCenterY(), 3);
    }

    public void keyPressed(int keyCode) {
        if (this._iActualMode == 0) {
            if (Keys.isFKRightCode(keyCode)) {
                this._animationComponent[this._ANIM_QUEST].startHideAnimation(2);
                this._animationComponent[this._ANIM_YES].startHideAnimation(1);
                this._animationComponent[this._ANIM_NO].startHideAnimation(0);
                this._bHideQuest = true;
                this.startMusic = true;
                this.mainCanvas.repaint();
                System.out.println("RIGHT");
            } else if (Keys.isFKLeftCode(keyCode)) {
                this._animationComponent[this._ANIM_QUEST].startHideAnimation(2);
                this._animationComponent[this._ANIM_YES].startHideAnimation(1);
                this._animationComponent[this._ANIM_NO].startHideAnimation(0);
                this._bHideQuest = true;
                this.startMusic = false;
                this.mainCanvas.repaint();
                System.out.println("LEFT");
            }
        }
    }

    public void keyReleased(int keyCode) {
        if (this._iActualMode == 0) {
            if (Keys.isFKRightCode(keyCode)) {
                this._animationComponent[this._ANIM_QUEST].startHideAnimation(2);
                this._animationComponent[this._ANIM_YES].startHideAnimation(1);
                this._animationComponent[this._ANIM_NO].startHideAnimation(0);
                this._bHideQuest = true;
                this.startMusic = true;
                this.mainCanvas.repaint();
            } else if (Keys.isFKLeftCode(keyCode)) {
                this._animationComponent[this._ANIM_QUEST].startHideAnimation(2);
                this._animationComponent[this._ANIM_YES].startHideAnimation(1);
                this._animationComponent[this._ANIM_NO].startHideAnimation(0);
                this._bHideQuest = true;
                this.startMusic = false;
                this.mainCanvas.repaint();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this._iActualMode == 0) {
            for (int i = 0; i < this.rectButton.length; ++i) {
                if (!this.rectButton[i].contains(x, y)) continue;
                this._selectedButton = i;
            }
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        if (this._iActualMode == 0) {
            if (this._selectedButton == this._BUTTON_NO) {
                this._animationComponent[this._ANIM_QUEST].startHideAnimation(2);
                this._animationComponent[this._ANIM_YES].startHideAnimation(1);
                this._animationComponent[this._ANIM_NO].startHideAnimation(0);
                this._iActualMode = 2;
                this.startMusic = false;
                this.mainCanvas.repaint();
            } else if (this._selectedButton == this._BUTTON_YES) {
                this._animationComponent[this._ANIM_QUEST].startHideAnimation(2);
                this._animationComponent[this._ANIM_YES].startHideAnimation(1);
                this._animationComponent[this._ANIM_NO].startHideAnimation(0);
                this._iActualMode = 2;
                this.startMusic = true;
                this.mainCanvas.repaint();
            }
        }
    }
}

