/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Resources;
import sk.inlogic.World;
import sk.inlogic.util.Rectangle;

public class Tile {
    private boolean _bEmpty = true;
    private boolean _bReset = false;
    private int _iType = -1;
    private int _iX = 0;
    private int _iY = 0;
    private int _iPositionX = 0;
    private int _iPositionY = 0;
    private int _iOffsetX = 0;
    private int _iActualFrame = 0;
    private Sprite _sprTile;
    private World _world;
    private Rectangle _rectTile;

    public Tile(World _wWorld, int _type, int _x, int _y, int _offset) {
        this.setSprTile(Resources.resSprs[12]);
        this._world = _wWorld;
        this._iType = _type;
        this.setX(_x);
        this.setY(_y);
        this._iOffsetX = _offset;
        this._iPositionX = this._iOffsetX + this.getX() * this.getSprTile().getWidth();
        this._iPositionY = this._world.getHeight() - this.getY() * this.getSprTile().getHeight();
        this._rectTile = new Rectangle(this._iPositionX, this._iPositionY, this.getSprTile().getWidth(), this.getSprTile().getHeight());
        this.initTile(true);
    }

    public void resetTile(int _type, int _y) {
        this.setReset(false);
        this._iType = _type;
        this._rectTile.y = this.getY() == 0 ? this._world._tTiles[this.getX()][_y - 1].getPositionY() - this.getSprTile().getHeight() : this._world._tTiles[this.getX()][this.getY() - 1].getPositionY() - this.getSprTile().getHeight();
        if (this.getX() == 0) {
            // empty if block
        }
        this.initTile(false);
    }

    void initTile(boolean _bFirstInit) {
        this._iActualFrame = this._iType == 0 ? (this.getY() == 0 ? (_bFirstInit ? 2 : (this._world._tTiles[this.getX()][this._world._tTiles[this.getX()].length - 1] != null && this._world._tTiles[this.getX()][this._world._tTiles[this.getX()].length - 1].getType() == 0 ? 1 : 2)) : (this._world._tTiles[this.getX()][this.getY() - 1].getType() == 0 ? 1 : 2)) : (this._iType == 1 ? (this.getX() == 0 ? 4 : (this.getX() == this._world.getTOTAL_COLS() - 1 ? 4 : 3)) : (this._iType == 2 ? (this.getY() == 0 ? (this._world._tTiles[this.getX()][this._world._tTiles[this.getX()].length - 1] != null && this._world._tTiles[this.getX()][this._world._tTiles[this.getX()].length - 1].getType() == 2 ? (this.getX() % 2 == 0 ? 6 : 7) : (this._world._tTiles[this.getX()][this._world._tTiles[this.getX()].length - 1] != null && this._world._tTiles[this.getX()][this._world._tTiles[this.getX()].length - 1].getType() == 3 ? 6 : 5)) : (this._world._tTiles[this.getX()][this.getY() - 1].getType() == 2 ? (this.getX() % 2 == 0 ? 6 : 7) : (this._world._tTiles[this.getX()][this.getY() - 1].getType() == 3 ? 6 : 5))) : (this._iType == 3 ? 8 : 9)));
        this.setReset(false);
    }

    void paint(Graphics _g) {
        if (this._rectTile.x + this.getSprTile().getWidth() >= 0 && this._rectTile.x <= this._world.getWidth() && this._rectTile.y + this.getSprTile().getHeight() >= 0 && this._rectTile.y <= this._world.getHeight()) {
            this.getSprTile().setPosition(this._rectTile.x, this._rectTile.y);
            this.getSprTile().setFrame(this._iActualFrame);
            this.getSprTile().paint(_g);
        }
    }

    public void incShiftY(int _iShift) {
        this._rectTile.y += _iShift;
        this._iPositionY = this._rectTile.y;
        if (this._rectTile.y > this._world.getHeight() + (this.getSprTile().getHeight() >> 1)) {
            this.setReset(true);
        }
    }

    public void setType(int _iType) {
        this._iType = _iType;
    }

    public int getType() {
        return this._iType;
    }

    public void setEmpty(boolean _bEmpty) {
        this._bEmpty = _bEmpty;
    }

    public boolean isEmpty() {
        return this._bEmpty;
    }

    public void setPositionX(int _iPositionX) {
        this._iPositionX = _iPositionX;
    }

    public int getPositionX() {
        return this._iPositionX;
    }

    public void setPositionY(int _iPositionY) {
        this._iPositionY = _iPositionY;
    }

    public int getPositionY() {
        return this._iPositionY;
    }

    public void setSprTile(Sprite _sprTile) {
        this._sprTile = _sprTile;
    }

    public Sprite getSprTile() {
        return this._sprTile;
    }

    public void setReset(boolean _bReset) {
        this._bReset = _bReset;
    }

    public boolean isReset() {
        return this._bReset;
    }

    public void set_rectTile(Rectangle _rectTile) {
        this._rectTile = _rectTile;
    }

    public Rectangle get_rectTile() {
        return this._rectTile;
    }

    public void setX(int _iX) {
        this._iX = _iX;
    }

    public int getX() {
        return this._iX;
    }

    public void setY(int _iY) {
        this._iY = _iY;
    }

    public int getY() {
        return this._iY;
    }
}

