/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Resources;
import sk.inlogic.World;
import sk.inlogic.util.Particles;
import sk.inlogic.util.Rectangle;

public class Character {
    private World _world;
    private Rectangle _rectChar;
    private Sprite _sprActualSprite;
    private Sprite _sprCharacter;
    private Sprite _sprShadow;
    private Sprite _sprCharacterUp;
    private Sprite _sprCharacterRight;
    private Particles _particles;
    public static final int _iTYPE_FROG = 0;
    public static final int _iTYPE_PLATYPUS = 1;
    public static final int _iTYPE_BIRD = 2;
    public static final int _iTYPE_PIG = 3;
    public static final int _iTYPE_MOLE = 4;
    public static final int _iTYPE_TURTLE = 6;
    public static final int _iDIR_UP = 0;
    public static final int _iDIR_DOWN = 1;
    public static final int _iDIR_LEFT = 2;
    public static final int _iDIR_RIGHT = 3;
    private int _iDirection = -1;
    private int _iX = 0;
    private int _iY = 0;
    private int _iPositionX = 0;
    private int _iPositionY = 0;
    private int _iOffsetX = 0;
    private int _iShiftX = 10;
    private int _iShiftY = 10;
    private int _iWorldWidth;
    private int _iWorldHeight;
    private boolean _bOnWood = false;
    private boolean _bMoveAfterSetWood = false;
    private boolean enableIncScore = false;
    int _tmpCheck = 0;

    public Character(World _wWorld, Sprite _sprUp, Sprite _sprRight, int _x, int _y) {
        this._world = _wWorld;
        this.setX(_x);
        this.set_iY(_y);
        this._iDirection = 0;
        this._sprCharacterUp = _sprUp;
        this._sprCharacterRight = _sprRight;
        this._sprShadow = Resources.resSprs[36];
        this.setDefaultSprite();
        this.set_rectChar(new Rectangle(this._world._tTiles[this.getX()][this.get_iY()].getPositionX(), this._world._tTiles[this.getX()][this.get_iY()].getPositionY(), this._sprActualSprite.getWidth(), this._sprActualSprite.getHeight()));
    }

    public void update() {
        this.get_rectChar().x = this._world._tTiles[this.getX()][this.get_iY()].getPositionX() + this.getOffsetX();
        this.get_rectChar().y = this._world._tTiles[this.getX()][this.get_iY()].getPositionY();
        Character character = this;
        character._particles.update();
    }

    public void paint(Graphics _g) {
        this.paintCharacterShadow(_g);
        this._sprActualSprite.setPosition(this.get_rectChar().x, this.get_rectChar().y);
        this._sprActualSprite.paint(_g);
        this.checkGameOver();
    }

    private void paintCharacterShadow(Graphics _g) {
        this._sprShadow.setPosition(this.get_rectChar().x + (this._sprActualSprite.getWidth() >> 2), this.get_rectChar().y + (this._sprActualSprite.getHeight() >> 2));
        this._sprShadow.paint(_g);
    }

    private void setDefaultSprite() {
        this._iDirection = 0;
        this._sprCharacterUp.setTransform(0);
        this._sprActualSprite = this._sprCharacterUp;
    }

    private void setSpriteUp() {
        this._iDirection = 0;
        this._sprCharacterUp.setTransform(0);
        this._sprActualSprite = this._sprCharacterUp;
    }

    private void setSpriteDown() {
        this._iDirection = 1;
        this._sprCharacterUp.setTransform(3);
        this._sprActualSprite = this._sprCharacterUp;
    }

    private void setSpriteRight() {
        this._iDirection = 3;
        this._sprCharacterRight.setTransform(0);
        this._sprActualSprite = this._sprCharacterRight;
    }

    private void setSpriteLeft() {
        this._iDirection = 2;
        this._sprCharacterRight.setTransform(2);
        this._sprActualSprite = this._sprCharacterRight;
    }

    public void moveUp() {
        if (this._bMoveAfterSetWood) {
            if (this.isOnWood()) {
                this._bMoveAfterSetWood = false;
            }
        } else {
            this._bMoveAfterSetWood = true;
        }
        if (this._iDirection != 0) {
            this.setSpriteUp();
        }
        if (this.checkNewPosition(this.get_rectChar().x, this.get_rectChar().y - this._iShiftY)) {
            this.incMove(true);
        }
        this._bMoveAfterSetWood = true;
        this.setOffsetX(0);
    }

    public void moveDown() {
        if (this._bMoveAfterSetWood) {
            if (this.isOnWood()) {
                this._bMoveAfterSetWood = false;
            }
        } else {
            this._bMoveAfterSetWood = true;
        }
        if (this._iDirection != 1) {
            this.setSpriteDown();
        }
        if (this.checkNewPosition(this.get_rectChar().x, this.get_rectChar().y + this._iShiftY)) {
            this.incMove(false);
        }
        this.setOffsetX(0);
    }

    public void moveLeft() {
        if (this._bMoveAfterSetWood) {
            if (this.isOnWood()) {
                this._bMoveAfterSetWood = false;
            }
        } else {
            this._bMoveAfterSetWood = true;
        }
        if (this._iDirection != 2) {
            this.setSpriteLeft();
        }
        if (this.checkNewPosition(this.get_rectChar().x - this._iShiftX, this.get_rectChar().y)) {
            this.incSide(false);
        }
        this._bMoveAfterSetWood = true;
        this.setOffsetX(0);
    }

    public void moveRight() {
        if (this._bMoveAfterSetWood) {
            if (this.isOnWood()) {
                this._bMoveAfterSetWood = false;
            }
        } else {
            this._bMoveAfterSetWood = true;
        }
        if (this._iDirection != 3) {
            this.setSpriteRight();
        }
        if (this.checkNewPosition(this.get_rectChar().x + this._iShiftX, this.get_rectChar().y)) {
            this.incSide(true);
        }
        this._bMoveAfterSetWood = true;
        this.setOffsetX(0);
    }

    private void incSide(boolean _bSideRight) {
        if (_bSideRight) {
            if (this.getX() < this._world.getTOTAL_COLS() - 1 && this._world._tTiles[this.getX() + 1][this._iY].isEmpty()) {
                this.setX(this.getX() + 1);
            }
        } else if (this.getX() > 0 && this._world._tTiles[this.getX() - 1][this._iY].isEmpty()) {
            this.setX(this.getX() - 1);
        }
        this._changeWood();
    }

    public boolean isEnableIncScore() {
        return this.enableIncScore;
    }

    private void setEnableIncSocre(boolean enable) {
        this.enableIncScore = enable;
    }

    private void incMove(boolean _bMoveUp) {
        if (_bMoveUp) {
            if (this.get_iY() < this._world.getTOTAL_ROWS() - 1) {
                if (this._world._tTiles[this.getX()][this._iY + 1].isEmpty()) {
                    this.set_iY(this.get_iY() + 1);
                    this.setEnableIncSocre(true);
                } else {
                    this.setEnableIncSocre(false);
                }
            } else if (this._world._tTiles[this.getX()][0].isEmpty()) {
                this.setEnableIncSocre(true);
                this.set_iY(0);
            } else {
                this.setEnableIncSocre(false);
            }
        } else {
            if (this.get_iY() > 0) {
                if (this._world._tTiles[this.getX()][this._iY - 1].isEmpty()) {
                    this.set_iY(this.get_iY() - 1);
                }
            } else if (this._world._tTiles[this.getX()][this._world.getTOTAL_ROWS() - 1].isEmpty()) {
                this.set_iY(this._world.getTOTAL_ROWS() - 1);
            }
            this.setEnableIncSocre(false);
        }
        this._changeWood();
    }

    public boolean checkGameOver() {
        if (this.checkStopGameOver()) {
            this._world.setBirdAnim(true);
            this._world.setGameOver(true, "Slow play");
            return true;
        }
        if (this.checkWaterGameOver()) {
            this._world.setGameOver(true, "Water collision");
            return true;
        }
        return false;
    }

    private boolean checkWaterGameOver() {
        if (this._world._tTiles[this.getX()][this.get_iY()].getType() == 1 && !this.isOnWood()) {
            return true;
        }
        if (this._world._tTiles[this.getX()][this.get_iY()].getType() != 1) {
            // empty if block
        }
        return false;
    }

    private boolean checkStopGameOver() {
        return this._sprActualSprite.getY() >= this._world.getHeight() - (this._world._tTiles[this.getX()][this.get_iY()].getSprTile().getHeight() >> 1);
    }

    private boolean checkNewPosition(int _iX, int _iY) {
        return true;
    }

    private boolean checkWorldBordes(int _iX, int _iY) {
        return _iX >= 0 && _iX <= this._iWorldWidth && _iY >= 0 && _iY <= this._iWorldHeight;
    }

    public void set_rectChar(Rectangle _rectChar) {
        this._rectChar = _rectChar;
    }

    public Rectangle get_rectChar() {
        return this._rectChar;
    }

    public void setOnWood(boolean _bOnWood) {
        this._bOnWood = _bOnWood;
    }

    public boolean isOnWood() {
        return this._bOnWood;
    }

    private void _changeWood() {
        if (this._bOnWood) {
            ++this._tmpCheck;
            System.out.println("_tmpCheck: " + this._tmpCheck);
            if (this._tmpCheck == 3) {
                this._tmpCheck = 0;
                this.setOnWood(false);
            }
        }
    }

    public void set_iY(int _iY) {
        this._iY = _iY;
    }

    public int get_iY() {
        return this._iY;
    }

    public void setOffsetX(int _iOffsetX) {
        this._iOffsetX = _iOffsetX;
    }

    public int getOffsetX() {
        return this._iOffsetX;
    }

    public void setX(int _iX) {
        this._iX = _iX;
    }

    public int getX() {
        return this._iX;
    }
}

