/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Resources;
import sk.inlogic.World;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Wood {
    private boolean _bIsActive = false;
    private boolean _bDraw = true;
    private boolean _bIsMoveable = false;
    private int _iX = 0;
    private int _iY = 0;
    private int _iShiftX = 1;
    private int _iOffsetX = 0;
    private int _iType = -1;
    private int _iTmpShift = 50;
    private int _iTmpPositionX = 0;
    private int TYPE_WOOD_LONG = 0;
    private int TYPE_WOOD_MEDIUM = 1;
    private int TYPE_WOOD_SMALL = 2;
    private int TYPE_WOOD_WATERLITY = 3;
    private int _iDir = -1;
    private int DIR_LEFT = 1;
    private int DIR_RIGHT = 0;
    private int _iDelay = 0;
    private int DELAY = 1;
    private final int RANDOM_RANGE;
    private final int RANDOM_RATIO;
    private Rectangle _rectWood;
    private Sprite _sprWood;
    private World _world;

    public Wood(World world) {
        this.RANDOM_RANGE = 100;
        this.RANDOM_RATIO = 20;
        this._world = world;
        this.init();
    }

    private void init() {
    }

    public void activeWood(int _x, int _y, int _iDirection, int _iOffset) {
        this.setX(_x);
        this.setY(_y);
        this._iDir = this.DIR_RIGHT;
        this.setWoodSprite(this.setWoodType());
        _iOffset = Math.abs(RandomNum.getRandomInt(240, 0)) / 15;
        this._iOffsetX = _iOffset != 0 ? _iOffset * (this._sprWood.getWidth() >> 2) : (_iOffset + 1) * (this._sprWood.getWidth() >> 2);
        this._iShiftX = this._sprWood.getWidth() >> 2;
        this._rectWood = new Rectangle(this._world._tTiles[this.getX()][this.getY()].getPositionX() - this._iOffsetX, this._world._tTiles[this.getX()][this.getY()].getPositionY(), this._sprWood.getWidth(), this._sprWood.getHeight());
        this.DELAY = RandomNum.getRandomInt(20, 10);
        if (this.DELAY < 0) {
            this.DELAY *= -1;
        }
        this.DELAY = 0;
        this._iTmpPositionX = this._rectWood.x - this._iOffsetX << 5;
        this._iTmpShift = 8;
        this.setActive(true);
        this.setMoveable(true);
    }

    private int setWoodType() {
        int _iTmpType = Math.abs(RandomNum.getRandomInt(100, 0));
        this.setMoveable(true);
        if (_iTmpType < 20) {
            return this.TYPE_WOOD_LONG;
        }
        if (_iTmpType < 40) {
            return this.TYPE_WOOD_MEDIUM;
        }
        if (_iTmpType < 60) {
            return this.TYPE_WOOD_SMALL;
        }
        return 0;
    }

    private void setWoodSprite(int _type) {
        if (_type == this.TYPE_WOOD_LONG) {
            this._iType = _type;
            this._sprWood = Resources.resSprs[20];
        } else if (_type == this.TYPE_WOOD_MEDIUM) {
            this._iType = _type;
            this._sprWood = Resources.resSprs[21];
        } else if (_type == this.TYPE_WOOD_SMALL) {
            this._iType = _type;
            this._sprWood = Resources.resSprs[22];
        } else if (_type == this.TYPE_WOOD_WATERLITY) {
            this._iType = _type;
            this._sprWood = Resources.resSprs[23];
        }
    }

    public void update() {
        this.chcekCharacterOnTop();
        this.move();
        if (this._rectWood.y >= this._world.getHeight()) {
            this.deactivate();
        }
        this._rectWood.y = this._world._tTiles[this.getX()][this.getY()].getPositionY();
        this.chcekCharacterOnTop();
    }

    public void paint(Graphics g) {
        if (this.isActive() && this._bDraw) {
            this._sprWood.setPosition(this._rectWood.x, this._rectWood.getCenterY());
            this._sprWood.paint(g);
        }
    }

    private void move() {
        if (this._iDir == this.DIR_LEFT) {
            if (this.getX() - 1 > 0) {
                if (this._rectWood.x >= this._world._tTiles[this.getX() + 1][this.getY()].getPositionX()) {
                    this.setX(this.getX() - 1);
                    this._iTmpPositionX -= this._iTmpShift;
                } else {
                    this._iTmpPositionX -= this._iTmpShift;
                }
            } else {
                this._iTmpPositionX -= this._iTmpShift;
                if (this._rectWood.x + this._rectWood.width < 0) {
                    this.reset(this.DIR_LEFT);
                }
            }
        } else if (this._iDir == this.DIR_RIGHT) {
            if (this.getX() + 1 < this._world.getTOTAL_COLS()) {
                if (this._rectWood.x >= this._world._tTiles[this.getX() + 1][this.getY()].getPositionX()) {
                    this.setX(this.getX() + 1);
                    this._iTmpPositionX += this._iTmpShift;
                } else {
                    this._iTmpPositionX += this._iTmpShift;
                }
            } else {
                this._iTmpPositionX += this._iTmpShift;
                if (this._rectWood.x > this._world.getWidth()) {
                    this.reset(this.DIR_RIGHT);
                }
            }
        }
        if (this._rectWood != null) {
            this._rectWood.x = this._iTmpPositionX >> 2;
        } else {
            System.out.println("is NULL");
        }
    }

    private void chcekCharacterOnTop() {
        Rectangle _rTmp = new Rectangle(this._sprWood.getX(), this._sprWood.getY(), this._sprWood.getWidth(), this._sprWood.getHeight());
        if (this._rectWood.contains(this._world.getCharacter().get_rectChar().getCenterX(), this._world.getCharacter().get_rectChar().getCenterY())) {
            this._world.getCharacter().setOnWood(true);
            System.out.println("wood true");
        } else if (this._rectWood.contains(this._world.getCharacter().get_rectChar().x, this._world.getCharacter().get_rectChar().y)) {
            this._world.getCharacter().setOnWood(true);
            System.out.println("wood true");
        } else if (this._rectWood.contains(this._world.getCharacter().get_rectChar().x + this._world.getCharacter().get_rectChar().width, this._world.getCharacter().get_rectChar().y + this._world.getCharacter().get_rectChar().height)) {
            this._world.getCharacter().setOnWood(true);
            System.out.println("wood true");
        }
        if (_rTmp.contains(this._world.getCharacter().get_rectChar().getCenterX(), this._world.getCharacter().get_rectChar().getCenterY())) {
            this._world.getCharacter().setOnWood(true);
            System.out.println("wood true");
        } else if (_rTmp.contains(this._world.getCharacter().get_rectChar().x, this._world.getCharacter().get_rectChar().y)) {
            this._world.getCharacter().setOnWood(true);
            System.out.println("wood true");
        } else if (_rTmp.contains(this._world.getCharacter().get_rectChar().x + this._world.getCharacter().get_rectChar().width, this._world.getCharacter().get_rectChar().y + this._world.getCharacter().get_rectChar().height)) {
            this._world.getCharacter().setOnWood(true);
            System.out.println("wood true");
        }
    }

    private void reset(int _dir) {
        if (_dir == this.DIR_LEFT) {
            this.setX(this._world.getTOTAL_COLS() - 2);
        } else {
            this.setX(0);
        }
        this._iTmpPositionX = this._rectWood.x - this._iOffsetX << 5;
        this._bDraw = false;
        this._rectWood.x = this._world._tTiles[this.getX()][this.getY()].getPositionX() + this._iOffsetX;
        this._rectWood.x = 0 - this._iOffsetX;
        this.activeWood(this.getX(), this.getY(), this._iDir, this.getX());
        this._bDraw = true;
    }

    private void deactivate() {
        this.setActive(false);
        this.setMoveable(false);
    }

    public void setActive(boolean _bIsActive) {
        this._bIsActive = _bIsActive;
    }

    public boolean isActive() {
        return this._bIsActive;
    }

    public void setMoveable(boolean _bIsMoveable) {
        this._bIsMoveable = _bIsMoveable;
    }

    public boolean isMoveable() {
        return this._bIsMoveable;
    }

    public void setX(int _iX) {
        this._iX = _iX;
    }

    public int getX() {
        return this._iX;
    }

    public void setY(int _iY) {
        this._iY = _iY;
    }

    public int getY() {
        return this._iY;
    }
}

