/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    private MainCanvas mainCanvas;
    private int status;
    private int interuption = 0;
    private static final int STATUS_GAME = 0;
    private static final int STATUS_INGAMEMENU = 1;
    private static final int STATUS_RESULTDIALOG = 2;
    private static final int STATUS_INSTRUCTIONS = 3;
    private static final int STATUS_TUTORIAL = 4;
    private static final int STATUS_RESTARTSCREEN = 5;
    private static final int STATUS_REALY_QUIT = 6;
    private static final int STATUS_MAIN_MENU = 7;
    private static final int COMP_ID_HINT = 0;
    private static final int COMP_ID_MENU = 1;
    private static final int COMP_ID_RESUME = 2;
    private static final int COMP_ID_RESTART = 3;
    private static final int COMP_ID_SOUNDS = 4;
    private static final int COMP_ID_MAINMENU = 5;
    private static final int COMP_ID_INSTRUCTION = 6;
    private static final int TOTAL_COMP_IDS = 9;
    private static final int COMP_ID_RESTART_TXT = 0;
    private static final int COMP_ID_SOUNDS_TXT = 1;
    private static final int COMP_ID_MAINMENU_TXT = 2;
    private static final int COMP_ID_INSTRUCTION_TXT = 3;
    private static final int TOTAL_COMP_IDS_TXT = 9;
    private int _totalColTiles;
    private int _totalRowTiles;
    private int[][] _animationSequence = new int[8][11];
    private AnimationComponent[] _animationComponents = new AnimationComponent[19];
    private Rectangle[] rectItems_TXT = new Rectangle[9];
    private Rectangle[] rectItems = new Rectangle[9];
    private Rectangle rectGameArea;
    private Rectangle rectPanel;
    private Rectangle rectText;
    private Rectangle rectScore;
    private Rectangle rectBestScore;
    private Rectangle rectBB_BACK;
    private Rectangle rectBB_MENU;
    private Rectangle rectPlay;
    private Rectangle rectLeftFk;
    private Rectangle rectRightFk;
    private Rectangle rectTopBig;
    private Rectangle rectTopLittle;
    private Rectangle rectTopLittleTXT;
    private Rectangle rectTitle;
    private int selectedCompId;
    private int _iSelectedCharacter = 0;
    private static PreparedText menuItem;
    private static PreparedText instruction;
    private static PreparedText actualScore;
    private static PreparedText actualCoins;
    private static PreparedText navigationKeysBB;
    private int textOffsetY;
    private boolean needRepaint;
    private boolean scrollUP = false;
    private boolean scrollDOWN = true;
    private Image _imgGameLogo;
    private Image _imgIconYes;
    private Image _imgIconNo;
    private Image _imgIconBack;
    private Sprite _sprCharacterUp;
    private Sprite _sprCharacterRight;
    private Sprite _sprCoinG;
    private Sprite _sprCoinW;
    private Sprite _sprCoinR;
    private Sprite _sprCoinT;
    private Sprite _sprCoin;
    private Sprite _sprArrows;
    private Sprite _sprButton;
    private Sprite _sprSelector;
    private Sprite _sprWindow;
    private Sprite _sprWorldTile;
    private Sprite _sprCheckBox;
    private Image _gameLogo;
    private static int _WIDTH;
    private static int _HEIGHT;
    int bestScoreSave = 0;
    private int scoresCount = 0;
    private int _iCoins = 0;
    private int _iCoinsCount = 0;
    int _finalHeight;
    int _off;
    private int _iTotalColRectTile = 0;
    private int _iTotalRowRectTile = 0;
    private int _iTotalColWindowsTile = 0;
    private int _iTotalRowWindowsTile = 0;
    private int _iTotalColButtonTile = 0;
    private int _iTotalRowButtonTile = 0;
    int cycle = 10;
    private int _sequenceStop = 0;
    private int _sequenceShow = 1;
    private int _sequenceHide = 2;
    private int _sequence = 0;
    boolean changeSequence = false;
    private int nextScreen;
    int lvl = 0;
    int posX = 0;
    int posY = 0;
    private boolean checkTouch = false;
    int checkDragg = 0;
    private int[] cood = new int[4];
    int checkButton = 2;
    int checkButton2 = 2;

    public ScreenGame(MainCanvas mainCanvas, int _iCharacter) {
        System.out.println("Start Screen Game");
        this.mainCanvas = mainCanvas;
        this._iSelectedCharacter = _iCharacter;
        this.initDimensions();
        this.status = 0;
        this.selectedCompId = 3;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{1, 2, 4, 3});
        Resources.loadSprites(new int[]{43, 40, 13, 14, 15, 16, 17, 18, 33, 32, 34, 35, 44, 45, 26, 27, 28, 24, 25, 29, 39, 36, 19, 30, 31, 23, 23, 20, 21, 22, 41, 12, 42});
        Resources.loadGFonts(new int[]{0, 1});
        this.loadCharacterGraphics(this._iSelectedCharacter);
        this.initImages();
        this.initSprites();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.prepareTxt();
        RMSObjects.game.restartGame(_WIDTH, _HEIGHT, this._sprCharacterUp, this._sprCharacterRight);
    }

    public void afterHide() {
        this.freeGraphics();
        Resources.freeImages(new int[]{1, 2, 4, 3});
        Resources.freeSprites(new int[]{43, 40, 13, 14, 15, 16, 17, 18, 33, 32, 34, 35, 44, 45, 26, 27, 28, 24, 25, 29, 39, 36, 19, 30, 31, 23, 23, 20, 21, 22, 41, 12, 42});
        Resources.freeGFonts(new int[]{0, 1});
    }

    private void loadCharacterGraphics(int _iCharacter) {
        if (_iCharacter == 7) {
            Resources.loadSprites(new int[]{0, 1});
            this._sprCharacterUp = Resources.resSprs[0];
            this._sprCharacterRight = Resources.resSprs[1];
        } else if (_iCharacter == 8) {
            Resources.loadSprites(new int[]{2, 3});
            this._sprCharacterUp = Resources.resSprs[2];
            this._sprCharacterRight = Resources.resSprs[3];
        } else if (_iCharacter == 9) {
            Resources.loadSprites(new int[]{8, 9});
            this._sprCharacterUp = Resources.resSprs[8];
            this._sprCharacterRight = Resources.resSprs[9];
        } else if (_iCharacter == 10) {
            Resources.loadSprites(new int[]{6, 7});
            this._sprCharacterUp = Resources.resSprs[6];
            this._sprCharacterRight = Resources.resSprs[7];
        } else if (_iCharacter == 11) {
            Resources.loadSprites(new int[]{4, 5});
            this._sprCharacterUp = Resources.resSprs[4];
            this._sprCharacterRight = Resources.resSprs[5];
        } else if (_iCharacter == 12) {
            Resources.loadSprites(new int[]{10, 11});
            this._sprCharacterUp = Resources.resSprs[10];
            this._sprCharacterRight = Resources.resSprs[11];
        }
    }

    private void freeCharacterGraphics(int _iCharacter) {
        if (_iCharacter == 7) {
            Resources.freeSprites(new int[]{0, 1});
            this._sprCharacterUp = null;
            this._sprCharacterRight = null;
        } else if (_iCharacter == 8) {
            Resources.freeSprites(new int[]{2, 3});
            this._sprCharacterUp = null;
            this._sprCharacterRight = null;
        } else if (_iCharacter == 9) {
            Resources.freeSprites(new int[]{8, 9});
            this._sprCharacterUp = null;
            this._sprCharacterRight = null;
        } else if (_iCharacter == 10) {
            Resources.freeSprites(new int[]{6, 7});
            this._sprCharacterUp = null;
            this._sprCharacterRight = null;
        } else if (_iCharacter == 11) {
            Resources.freeSprites(new int[]{4, 5});
            this._sprCharacterUp = null;
            this._sprCharacterRight = null;
        } else if (_iCharacter == 12) {
            Resources.freeSprites(new int[]{10, 11});
            this._sprCharacterUp = null;
            this._sprCharacterRight = null;
        }
    }

    private void initDimensions() {
        _WIDTH = this.mainCanvas.getWidth();
        _HEIGHT = this.mainCanvas.getHeight();
    }

    private void initImages() {
        this._gameLogo = Resources.resImgs[1];
        this._imgIconBack = Resources.resImgs[2];
        this._imgIconYes = Resources.resImgs[3];
        this._imgIconNo = Resources.resImgs[4];
    }

    private void initSprites() {
        this._sprWindow = Resources.resSprs[41];
        this._sprArrows = Resources.resSprs[43];
        this._sprButton = Resources.resSprs[40];
        this._sprSelector = Resources.resSprs[39];
        this._sprCheckBox = Resources.resSprs[42];
    }

    public void initTxt() {
        Resources.loadText(0);
        menuItem = new PreparedText(Resources.resGFonts[0]);
        actualScore = new PreparedText(Resources.resGFonts[0]);
        instruction = new PreparedText(Resources.resGFonts[1]);
        menuItem = new PreparedText(Resources.resGFonts[0]);
        navigationKeysBB = new PreparedText(Resources.resGFonts[1]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 6;
        this._animationSequence[0][1] = 7;
        this._animationSequence[0][2] = -1;
        this._animationSequence[0][3] = -1;
        this._animationSequence[0][4] = -1;
        this._animationSequence[0][5] = -1;
        this._animationSequence[0][6] = -1;
        this._animationSequence[0][7] = -1;
        this._animationSequence[0][8] = -1;
        this._animationSequence[0][9] = -1;
        this._animationSequence[0][10] = -1;
        this._animationSequence[1][0] = 0;
        this._animationSequence[1][1] = 1;
        this._animationSequence[1][2] = 2;
        this._animationSequence[1][3] = 3;
        this._animationSequence[1][4] = 7;
        this._animationSequence[1][5] = 8;
        this._animationSequence[1][6] = 6;
        this._animationSequence[1][7] = -1;
        this._animationSequence[1][8] = -1;
        this._animationSequence[1][9] = -1;
        this._animationSequence[1][10] = -1;
        this._animationSequence[3][0] = 7;
        this._animationSequence[3][1] = 4;
        this._animationSequence[3][2] = 5;
        this._animationSequence[3][3] = 6;
        this._animationSequence[3][4] = -1;
        this._animationSequence[3][5] = -1;
        this._animationSequence[3][6] = -1;
        this._animationSequence[3][7] = -1;
        this._animationSequence[3][8] = -1;
        this._animationSequence[3][9] = -1;
        this._animationSequence[3][10] = -1;
        this._animationSequence[6][0] = 6;
        this._animationSequence[6][1] = 7;
        this._animationSequence[6][2] = 4;
        this._animationSequence[6][3] = 5;
        this._animationSequence[6][4] = -1;
        this._animationSequence[6][5] = -1;
        this._animationSequence[6][6] = -1;
        this._animationSequence[6][7] = -1;
        this._animationSequence[6][8] = -1;
        this._animationSequence[6][9] = -1;
        this._animationSequence[6][10] = -1;
        this._animationSequence[5][0] = 6;
        this._animationSequence[5][1] = 7;
        this._animationSequence[5][2] = 4;
        this._animationSequence[5][3] = 5;
        this._animationSequence[5][4] = -1;
        this._animationSequence[5][5] = -1;
        this._animationSequence[5][6] = -1;
        this._animationSequence[5][7] = -1;
        this._animationSequence[5][8] = -1;
        this._animationSequence[5][9] = -1;
        this._animationSequence[5][10] = -1;
        this._animationSequence[2][0] = 6;
        this._animationSequence[2][1] = 7;
        this._animationSequence[2][2] = 4;
        this._animationSequence[2][3] = 5;
        this._animationSequence[2][4] = -1;
        this._animationSequence[2][5] = -1;
        this._animationSequence[2][6] = -1;
        this._animationSequence[2][7] = -1;
        this._animationSequence[2][8] = -1;
        this._animationSequence[2][9] = -1;
        this._animationSequence[2][10] = -1;
        this._animationSequence[4][0] = -1;
        this._animationSequence[4][1] = -1;
        this._animationSequence[4][2] = -1;
        this._animationSequence[4][3] = -1;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
        this._animationSequence[4][6] = -1;
        this._animationSequence[4][7] = -1;
        this._animationSequence[4][8] = -1;
        this._animationSequence[4][9] = -1;
        this._animationSequence[4][10] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this.rectItems[3], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[0].startShowAnimation(0);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectItems[4], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectItems[6], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectItems[5], _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this.rectPanel, _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[4].startShowAnimation(2);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this.rectText, _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[5].startShowAnimation(2);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, this.rectLeftFk, _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[6].startShowAnimation(1);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this.rectRightFk, _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[7].startShowAnimation(0);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this.rectTopBig, _WIDTH, _HEIGHT, 0, 0);
        this._animationComponents[8].startShowAnimation(2);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(0);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(2);
        this._animationComponents[5].startShowAnimation(2);
        this._animationComponents[6].startShowAnimation(1);
        this._animationComponents[7].startShowAnimation(0);
        this._animationComponents[8].startShowAnimation(2);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(0);
        this._animationComponents[1].startHideAnimation(1);
        this._animationComponents[2].startHideAnimation(0);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(2);
        this._animationComponents[5].startHideAnimation(2);
        this._animationComponents[6].startHideAnimation(1);
        this._animationComponents[7].startHideAnimation(0);
        this._animationComponents[8].startHideAnimation(2);
    }

    private void freeGraphics() {
        this._gameLogo = null;
        this._sprCheckBox = null;
        this.freeCharacterGraphics(this._iSelectedCharacter);
    }

    private void prepareTxt() {
        this.initTxt();
        String controls = "";
        controls = Resources.resTexts[0].getHashedString(17) + "\n\n\n\n" + "\n\n\n\n";
        controls = Resources.resTexts[0].getHashedString(16);
        instruction.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls, this.rectText.width);
        instruction.setLineHeightCorrection(-2);
        this.loadBestScore();
    }

    private void loadBestScore() {
        Vector scores;
        RMSObjects.createRMSConnect(1);
        if (!RMSObjects.rmsConnects[1].load()) {
            RMSObjects.rmsConnects[1].create();
        }
        if ((scores = RMSObjects.bestScores.getScoresForGame(0)) != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (this.scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            this.bestScoreSave = scoreItem.scoreValue;
        }
    }

    private void loadCoinsCount() {
        Vector scores;
        RMSObjects.createRMSConnect(0);
        if (!RMSObjects.rmsConnects[0].load()) {
            RMSObjects.rmsConnects[0].create();
        }
        if ((scores = RMSObjects.coinsCount.getScoresForGame(0)) != null) {
            this._iCoinsCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (this._iCoinsCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            this._iCoins = scoreItem.scoreValue;
        }
    }

    private void saveBestScore() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = "0";
        if (RMSObjects.game.getScore() > this.bestScoreSave) {
            scoreItem.scoreValue = RMSObjects.game.getScore();
            RMSObjects.bestScores.userName = Integer.toString(0);
            RMSObjects.bestScores.insertScoreItem(scoreItem, 0);
            if (!RMSObjects.rmsConnects[1].isExist()) {
                RMSObjects.rmsConnects[1].create();
            }
            RMSObjects.rmsConnects[1].save();
        }
    }

    private void saveEarnedCoins() {
        int saveCoins;
        if (RMSObjects.game.getEarnedCoins() <= 0) {
            return;
        }
        this.loadCoinsCount();
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = "0";
        scoreItem.scoreValue = saveCoins = this._iCoins + RMSObjects.game.getEarnedCoins();
        RMSObjects.coinsCount.userName = Integer.toString(0);
        RMSObjects.coinsCount.insertCoins(scoreItem, 0);
        RMSObjects.createRMSConnect(0);
        if (!RMSObjects.rmsConnects[0].isExist()) {
            RMSObjects.rmsConnects[0].create();
        }
        RMSObjects.rmsConnects[0].save();
    }

    public void beforeInteruption() {
        if (this.status == 0) {
            this.setGameMenuStatus();
        }
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
    }

    private void calculatePositions() {
        int _windowWidth = _WIDTH >> 1;
        int _offsetX = _windowWidth % this._sprWindow.getWidth() > 0 ? _windowWidth % this._sprWindow.getWidth() : this._sprWindow.getWidth();
        int _offsetTopY = this._sprWindow.getHeight() + this._sprWindow.getWidth();
        int _offsetBottomY = this._sprWindow.getWidth();
        int _panelHeight = _HEIGHT - _offsetTopY - _offsetBottomY;
        this._finalHeight = _panelHeight % this._sprWindow.getWidth() == 0 ? _panelHeight : _panelHeight - _panelHeight % this._sprWindow.getWidth();
        this._off = _offsetX;
        this.rectPanel = new Rectangle(_offsetX, _offsetTopY, _WIDTH - (_offsetX << 1), this._finalHeight);
        this.rectText = new Rectangle(_offsetX + this._sprWindow.getWidth(), _offsetTopY + this._sprArrows.getHeight(), _WIDTH - (_offsetX << 1) - (this._sprWindow.getWidth() << 1), this._finalHeight - (this._sprArrows.getHeight() << 1));
        int _iButtonWidth = this.rectPanel.width - (this._sprButton.getWidth() << 1);
        int _iButtonOffsetX = _iButtonWidth % this._sprButton.getWidth() > 0 ? _iButtonWidth % this._sprButton.getWidth() : this.rectPanel.x + this._sprButton.getWidth();
        int _iButtonOffsetY = this.rectPanel.y + this._sprWindow.getHeight() + this._sprButton.getHeight();
        _iButtonOffsetY = (_HEIGHT >> 1) - this._sprButton.getHeight() * 5;
        this.rectItems[3] = new Rectangle(_iButtonOffsetX, _iButtonOffsetY, _WIDTH - (_iButtonOffsetX << 1), this._sprButton.getHeight() * 3);
        this.rectItems[4] = new Rectangle(_iButtonOffsetX, _iButtonOffsetY += this._sprButton.getHeight() << 2, _WIDTH - (_iButtonOffsetX << 1), this._sprButton.getHeight() * 3);
        this.rectItems[6] = new Rectangle(_iButtonOffsetX, _iButtonOffsetY += this._sprButton.getHeight() << 2, _WIDTH - (_iButtonOffsetX << 1), this._sprButton.getHeight() * 3);
        this.rectItems[5] = new Rectangle(_iButtonOffsetX, _iButtonOffsetY += this._sprButton.getHeight() << 2, _WIDTH - (_iButtonOffsetX << 1), this._sprButton.getHeight() * 3);
        this.rectTopBig = new Rectangle(_WIDTH >> 1, this._gameLogo.getWidth() >> 4, this._gameLogo.getWidth(), this._gameLogo.getHeight());
        this.rectItems[0] = this.rectRightFk = new Rectangle(0, _HEIGHT - (this._sprCheckBox.getHeight() << 1), this._sprCheckBox.getWidth() << 1, this._sprCheckBox.getHeight() << 1);
        this.rectItems[1] = this.rectLeftFk = new Rectangle(_WIDTH - (this._sprCheckBox.getWidth() << 1), _HEIGHT - (this._sprCheckBox.getHeight() << 1), this._sprCheckBox.getWidth() << 1, this._sprCheckBox.getHeight() << 1);
        this.rectScore = new Rectangle((_WIDTH >> 1) - this._sprWindow.getHeight() * 3, 0 + (this._sprWindow.getHeight() >> 1), this._sprWindow.getWidth() * 6, this._sprWindow.getHeight() * 3);
        this.rectGameArea = new Rectangle(0, 0, _WIDTH, _HEIGHT - this.rectItems[0].height);
        this.calculateWindowTiles();
    }

    private void calculateWindowTiles() {
        this._iTotalColWindowsTile = (_WIDTH - (this._off << 1)) / this._sprWindow.getWidth();
        this._iTotalRowWindowsTile = this.rectPanel.height / this._sprWindow.getWidth();
        this._iTotalColButtonTile = this.rectItems[6].width / this._sprButton.getWidth();
        this._iTotalRowButtonTile = 3;
        this._iTotalColRectTile = (_WIDTH - (this._off << 1)) / this._sprWindow.getWidth();
        this._iTotalRowRectTile = this.rectPanel.height / this._sprWindow.getWidth();
    }

    public void update(long lastRunLenght) {
        this.animationController();
        this.animationComponentsUpdate();
        if (this.nextScreen == 2) {
            return;
        }
        if (this.status == 0) {
            RMSObjects.game.update(lastRunLenght);
            if (RMSObjects.game.isGameOver()) {
                this.startAnimation(true, 2);
            }
            this.mainCanvas.repaint();
        }
        if (this.status == 2) {
            RMSObjects.game.update(lastRunLenght);
            System.out.println("resut");
            this.mainCanvas.repaint();
        }
        if (this.status == 3) {
            this.needRepaint = false;
            this.textMove();
            if (this.needRepaint) {
                this.mainCanvas.repaint();
            }
        }
        if (this.status == 1) {
            // empty if block
        }
    }

    public void textMove() {
        if (instruction.getTextHeight() < this.rectText.height - (this._sprWindow.getHeight() << 1)) {
            return;
        }
        this.needRepaint = false;
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY < 0) {
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
            this.needRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = instruction.getTextHeight() - this.rectText.height;
            if (Resources.sysFont) {
                this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY > maxOffsetY) {
                this.textOffsetY = maxOffsetY;
                this.scrollUP = true;
                this.scrollDOWN = false;
            }
            this.needRepaint = true;
        }
        if (this.needRepaint) {
            this.mainCanvas.repaint();
        }
    }

    private boolean animationController() {
        if (this.changeSequence) {
            if (this._sequence == this._sequenceShow) {
                this.showAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceHide) {
                this.hideAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceStop) {
                this.changeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationSequence[this.status].length; ++i) {
            if (this._animationSequence[this.status][i] == -1 || this._animationComponents[this._animationSequence[this.status][i]] == null || this._animationComponents[this._animationSequence[this.status][i]].isComponentAnimated()) continue;
            this._animationComponents[this._animationSequence[this.status][i]].update();
            if (this.status == 0) {
                // empty if block
            }
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._sequence == this._sequenceHide) {
                if (this.nextScreen == 7) {
                    this.startMenuScreen();
                }
                this._sequence = this._sequenceShow;
                this.status = this.nextScreen;
                this.changeSequence = true;
            } else if (this._sequence == this._sequenceShow) {
                this._sequence = this._sequenceStop;
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextScreen) {
        this.changeSequence = changeSequencem;
        this.nextScreen = nextScreen;
        this._sequence = this._sequenceHide;
    }

    private void startMenuScreen() {
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    public void paint(Graphics g) {
        switch (this.status) {
            case 0: {
                RMSObjects.game.paint(g, this.status);
                this.paintGameScoreTop(g);
                break;
            }
            case 1: {
                this.paintBackgroundColor(g);
                this.paintGameLogo(g);
                this.paintOptionsItems(g);
                break;
            }
            case 3: {
                this.paintBackgroundColor(g);
                this.paintTiledWindow(g);
                this.paintInstrusctionTxt(g);
                this.paintArrows(g);
                break;
            }
            case 6: {
                this.paintBackgroundColor(g);
                this.paintTiledWindow(g);
                this.paintMessage(g);
                break;
            }
            case 2: {
                this.paintBackgroundColor(g);
                this.paintTiledWindow(g);
                this.paintMessage(g);
                break;
            }
            case 5: {
                this.paintBackgroundColor(g);
                this.paintTiledWindow(g);
                this.paintMessage(g);
            }
        }
        this.paintFK(g);
    }

    private void paintLine(Graphics g) {
        g.setColor(0);
        g.drawLine(this.cood[0], this.cood[1], this.cood[2], this.cood[3]);
    }

    private void paintBackgroundColor(Graphics g) {
        g.setColor(11856989);
        g.fillRect(0, 0, _WIDTH, _HEIGHT);
    }

    public void paintGameLogo(Graphics g) {
        g.drawImage(this._gameLogo, this.rectTopBig.x, this.rectTopBig.y, 17);
    }

    private void paintOptionsItems(Graphics g) {
        this.paintOptionsButtons(g, 3, false);
        menuItem.prepareText(Resources.resTexts[0].getHashedString(25), this.rectItems[6].width);
        menuItem.drawText(g, this.rectItems[3], 0, 3);
        this.paintOptionsButtons(g, 6, false);
        menuItem.prepareText(Resources.resTexts[0].getHashedString(22), this.rectItems[6].width);
        menuItem.drawText(g, this.rectItems[6], 0, 3);
        this.paintOptionsButtons(g, 4, false);
        menuItem.prepareText(Resources.resTexts[0].getHashedString(28) + " " + (MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27)), this.rectItems[6].width);
        menuItem.drawText(g, this.rectItems[4], 0, 3);
        this.paintOptionsButtons(g, 5, true);
        menuItem.prepareText(Resources.resTexts[0].getHashedString(19), this.rectItems[6].width);
        menuItem.drawText(g, this.rectItems[5], 0, 3);
        this.paintOptionsSelector(g);
    }

    private void paintOptionsButtons(Graphics g, int _item, boolean music) {
        int _iTileX = 0;
        int _iTileY = 0;
        this._totalColTiles = this._iTotalColButtonTile;
        this._totalRowTiles = this._iTotalRowButtonTile;
        for (int _x = this.rectItems[_item].x; _x < this.rectItems[_item].x + this.rectItems[_item].width; _x += this._sprButton.getWidth()) {
            for (int _y = this.rectItems[_item].y; _y < this.rectItems[_item].y + this.rectItems[_item].height; _y += this._sprButton.getHeight()) {
                this._sprButton.setFrame(this.getWindowTileSprite(_iTileX, _iTileY, this._totalColTiles, this._totalRowTiles));
                this._sprButton.setPosition(_x, _y);
                this._sprButton.paint(g);
                ++_iTileY;
            }
            _iTileY = 0;
            ++_iTileX;
        }
    }

    private void paintOptionsSelector(Graphics g) {
        this._sprSelector.setFrame(0);
        for (int _iDx = 0; _iDx < this.rectItems.length; ++_iDx) {
            if (_iDx != this.selectedCompId) continue;
            this._sprSelector.setPosition(this.rectItems[_iDx].getCenterX(), this.rectItems[_iDx].getCenterY());
            this._sprSelector.paint(g);
            return;
        }
    }

    private int getWindowTileSprite(int _x, int _y, int totalCols, int totalRows) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < totalCols - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == totalCols - 1) {
            return 2;
        }
        if (_y == totalRows - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < totalRows - 1 && _y > 0) {
            return 3;
        }
        if (_x == totalCols - 1 && _y < totalRows - 1 && _y > 0) {
            return 5;
        }
        if (_y == totalRows - 1 && _x < totalCols - 1 && _x > 0) {
            return 7;
        }
        if (_y == totalRows - 1 && _x == totalCols - 1) {
            return 8;
        }
        return 4;
    }

    private void paintTiledWindow(Graphics g) {
        int _actualTileX = 0;
        int _actualTileY = 0;
        for (int x = this.rectPanel.x; x < this.rectPanel.x + this.rectPanel.width; x += this._sprWindow.getWidth()) {
            for (int y = this.rectPanel.y; y < this.rectPanel.y + this.rectPanel.height; y += this._sprWindow.getHeight()) {
                this._sprWindow.setFrame(this.getWindowTileSprite(_actualTileX, _actualTileY, this._iTotalColRectTile, this._iTotalRowRectTile));
                this._sprWindow.setPosition(x, y);
                this._sprWindow.paint(g);
                ++_actualTileY;
            }
            _actualTileY = 0;
            ++_actualTileX;
        }
    }

    private void paintInstrusctionTxt(Graphics g) {
        instruction.drawText(g, this.rectText, this.textOffsetY, 20);
    }

    private void paintArrows(Graphics g) {
        if (instruction.getTextHeight() < this.rectText.height) {
            return;
        }
        if (this.scrollDOWN && this.scrollUP) {
            this._sprArrows.setPosition((this.rectPanel.x + this.rectPanel.width >> 1) - (this._sprArrows.getWidth() >> 2), this.rectPanel.y - (this._sprArrows.getHeight() << 1));
            this._sprArrows.setFrame(0);
            this._sprArrows.paint(g);
            this._sprArrows.setPosition((this.rectPanel.x + this.rectPanel.width >> 1) - (this._sprArrows.getWidth() >> 2), this.rectPanel.y + this.rectPanel.height + this._sprArrows.getHeight());
            this._sprArrows.setFrame(1);
            this._sprArrows.paint(g);
        } else if (!this.scrollDOWN && this.scrollUP) {
            this._sprArrows.setPosition((this.rectPanel.x + this.rectPanel.width >> 1) - (this._sprArrows.getWidth() >> 2), this.rectPanel.y - (this._sprArrows.getHeight() << 1));
            this._sprArrows.setFrame(0);
            this._sprArrows.paint(g);
        } else if (this.scrollDOWN && !this.scrollUP) {
            this._sprArrows.setPosition((this.rectPanel.x + this.rectPanel.width >> 1) - (this._sprArrows.getWidth() >> 2), this.rectPanel.y + this.rectPanel.height + this._sprArrows.getHeight());
            this._sprArrows.setFrame(1);
            this._sprArrows.paint(g);
        }
    }

    private void paintMessage(Graphics g) {
        if (this.status == 6) {
            menuItem.prepareText(Resources.resTexts[0].getHashedString(77), this.rectText.width);
            menuItem.drawText(g, this.rectText, menuItem.getTextHeight() >> 1, 3);
        } else if (this.status == 5) {
            menuItem.prepareText(Resources.resTexts[0].getHashedString(78), this.rectText.width);
            menuItem.drawText(g, this.rectText, menuItem.getTextHeight() >> 1, 3);
        } else if (this.status == 2) {
            String text = Resources.resTexts[0].getHashedString(13) + "\n" + Resources.resTexts[0].getHashedString(10) + " : " + RMSObjects.game.getScore() + "\n" + Resources.resTexts[0].getHashedString(52);
            menuItem.prepareText(text, this.rectText.width);
            menuItem.drawText(g, this.rectText, menuItem.getTextHeight() >> 1, 3);
        } else if (this.status == 0 && RMSObjects.game.isInitGame()) {
            menuItem.prepareText("PRESS 5 TO START THE GAME", this.rectText.width);
            menuItem.drawText(g, this.rectText, menuItem.getTextHeight() >> 1, 3);
        }
    }

    private void paintGameScoreTop(Graphics g) {
        int _iTileX = 0;
        int _iTileY = 0;
        this._totalColTiles = 6;
        this._totalRowTiles = 3;
        for (int _x = this.rectScore.x; _x < this.rectScore.x + this.rectScore.width; _x += this._sprWindow.getWidth()) {
            for (int _y = this.rectScore.y; _y < this.rectScore.y + this.rectScore.height; _y += this._sprWindow.getHeight()) {
                this._sprWindow.setFrame(this.getWindowTileSprite(_iTileX, _iTileY, this._totalColTiles, this._totalRowTiles));
                this._sprWindow.setPosition(_x, _y);
                this._sprWindow.paint(g);
                ++_iTileY;
            }
            _iTileY = 0;
            ++_iTileX;
        }
        String score = RMSObjects.game.getScore() + "";
        String addscore = "0000";
        addscore = score.length() == 1 ? "000" : (score.length() == 2 ? "00" : (score.length() == 3 ? "0" : ""));
        actualScore.prepareText(addscore + RMSObjects.game.getScore(), this.rectScore.width);
        actualScore.drawText(g, this.rectScore, 0, 3);
    }

    private void paintPanelTop(Graphics g) {
        String score = RMSObjects.game.getScore() + "";
        String addscore = "000000";
        addscore = score.length() == 1 ? "000" : (score.length() == 2 ? "00" : (score.length() == 3 ? "0" : ""));
        actualScore.prepareText(addscore + RMSObjects.game.getScore(), this.rectScore.width);
        actualScore.drawText(g, this.rectScore, 0, 10);
        score = this.bestScoreSave + "";
        String s = "000000";
        s = score.length() == 1 ? "000" : (score.length() == 2 ? "00" : (score.length() == 3 ? "0" : ""));
        actualScore.prepareText(s + this.bestScoreSave, this.rectScore.width);
        actualScore.drawText(g, this.rectBestScore, 0, 6);
    }

    private void paintFK(Graphics g) {
        if (this.status == 6) {
            this._sprCheckBox.setPosition(this.rectLeftFk.x + this._sprCheckBox.getWidth(), this.rectLeftFk.y + this._sprCheckBox.getHeight());
            this._sprCheckBox.paint(g);
            g.drawImage(this._imgIconNo, this._sprCheckBox.getX() + (this._sprCheckBox.getWidth() >> 1) - (this._imgIconNo.getWidth() >> 1), this._sprCheckBox.getY() + (this._sprCheckBox.getWidth() >> 1) - (this._imgIconNo.getWidth() >> 1), 20);
            this._sprCheckBox.setPosition(this.rectRightFk.x, this.rectRightFk.y + this._sprCheckBox.getHeight());
            this._sprCheckBox.paint(g);
            g.drawImage(this._imgIconYes, this._sprCheckBox.getX() + this._sprCheckBox.getWidth() - (this._imgIconNo.getWidth() >> 1), this._sprCheckBox.getY() + (this._sprCheckBox.getWidth() >> 1) - (this._imgIconNo.getWidth() >> 1), 24);
        } else if (this.status == 5) {
            this._sprCheckBox.setPosition(this.rectLeftFk.x + this._sprCheckBox.getWidth(), this.rectLeftFk.y + this._sprCheckBox.getHeight());
            this._sprCheckBox.paint(g);
            g.drawImage(this._imgIconNo, this._sprCheckBox.getX() + (this._sprCheckBox.getWidth() >> 1) - (this._imgIconNo.getWidth() >> 1), this._sprCheckBox.getY() + (this._sprCheckBox.getWidth() >> 1) - (this._imgIconNo.getWidth() >> 1), 20);
            this._sprCheckBox.setPosition(this.rectRightFk.x, this.rectRightFk.y + this._sprCheckBox.getHeight());
            this._sprCheckBox.paint(g);
            g.drawImage(this._imgIconYes, this._sprCheckBox.getX() + this._sprCheckBox.getWidth() - (this._imgIconNo.getWidth() >> 1), this._sprCheckBox.getY() + (this._sprCheckBox.getWidth() >> 1) - (this._imgIconNo.getWidth() >> 1), 24);
        } else if (this.status == 2) {
            this._sprCheckBox.setPosition(this.rectLeftFk.x + this._sprCheckBox.getWidth(), this.rectLeftFk.y + this._sprCheckBox.getHeight());
            this._sprCheckBox.paint(g);
            g.drawImage(this._imgIconNo, this._sprCheckBox.getX() + (this._sprCheckBox.getWidth() >> 1) - (this._imgIconNo.getWidth() >> 1), this._sprCheckBox.getY() + (this._sprCheckBox.getWidth() >> 1) - (this._imgIconNo.getWidth() >> 1), 20);
            this._sprCheckBox.setPosition(this.rectRightFk.x, this.rectRightFk.y + this._sprCheckBox.getHeight());
            this._sprCheckBox.paint(g);
            g.drawImage(this._imgIconYes, this._sprCheckBox.getX() + this._sprCheckBox.getWidth() - (this._imgIconNo.getWidth() >> 1), this._sprCheckBox.getY() + (this._sprCheckBox.getWidth() >> 1) - (this._imgIconNo.getWidth() >> 1), 24);
        } else {
            this._sprCheckBox.setPosition(this.rectItems[1].x + this._sprCheckBox.getWidth(), this.rectItems[1].y + this._sprCheckBox.getHeight());
            this._sprCheckBox.paint(g);
            g.drawImage(this._imgIconBack, this._sprCheckBox.getX() + (this._imgIconNo.getWidth() >> 1), this._sprCheckBox.getY() + (this._imgIconNo.getWidth() >> 1), 20);
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        switch (this.status) {
            case 4: {
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 0);
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.setGameMenuStatus();
                }
                if (Keys.isFKLeftCode(keyCode) || keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    RMSObjects.game.moveLeft();
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    RMSObjects.game.moveRight();
                    break;
                }
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    RMSObjects.game.moveUp();
                    break;
                }
                if (!Keys.isActionGeneratedByKey(2, keyCode)) break;
                RMSObjects.game.moveDown();
                break;
            }
            case 1: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                this.keyReleasedMenuGame(keyCode);
                break;
            }
            case 2: {
                this.keyReleasedResult(keyCode);
                break;
            }
            case 3: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55 || !Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
                this.selectedCompId = 6;
                break;
            }
            case 6: {
                if (Keys.isFKLeftCode(keyCode)) {
                    this.startMenuScreen();
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                break;
            }
            case 5: {
                if (Keys.isFKLeftCode(keyCode)) {
                    this.saveBestScore();
                    this.loadBestScore();
                    this.loadCoinsCount();
                    this.saveEarnedCoins();
                    RMSObjects.game.restartGame(_WIDTH, _HEIGHT, this._sprCharacterUp, this._sprCharacterRight);
                    this.startAnimation(true, 0);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.saveBestScore();
                this.loadBestScore();
                this.loadCoinsCount();
                this.saveEarnedCoins();
                this.startAnimation(true, 1);
            }
        }
        this.mainCanvas.repaint();
    }

    private void setGameMenuStatus() {
        this.startAnimation(true, 1);
        this.selectedCompId = 3;
    }

    private void keyReleasedMenuGame(int keyCode) {
        switch (this.selectedCompId) {
            case 2: {
                break;
            }
            case 3: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 4;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 5);
                this.mainCanvas.repaint();
                break;
            }
            case 4: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 6;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.SetSoundOn(false);
                    Settings.musicOn = false;
                    MainCanvas.soundManager.Stop();
                    break;
                }
                MainCanvas.soundManager.SetSoundOn(true);
                Settings.musicOn = true;
                MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                break;
            }
            case 6: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 4;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 5;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 3);
                break;
            }
            case 5: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 6);
            }
        }
        if (Keys.isFKRightCode(keyCode)) {
            this.startAnimation(true, 0);
        }
    }

    private void keyReleasedResult(int keyCode) {
        if (RMSObjects.game.isGameOver()) {
            if (Keys.isFKRightCode(keyCode)) {
                this.saveBestScore();
                this.saveEarnedCoins();
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isFKLeftCode(keyCode)) {
                this.saveBestScore();
                this.loadBestScore();
                this.saveEarnedCoins();
                RMSObjects.game.restartGame(_WIDTH, _HEIGHT, this._sprCharacterUp, this._sprCharacterRight);
                this.startAnimation(true, 0);
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                }
            }
        } else if (RMSObjects.game.isLevelDone()) {
            if (Keys.isFKLeftCode(keyCode)) {
                this.saveBestScore();
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                // empty if block
            }
        }
    }

    private boolean existComponentInState(int i, int status) {
        if (status == 0) {
            if (i == 1) {
                return true;
            }
        } else if (status == 6) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 1) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
            if (i == 2) {
                return true;
            }
            if (i == 3) {
                return true;
            }
            if (i == 4) {
                return true;
            }
            if (i == 6) {
                return true;
            }
            if (i == 5) {
                return true;
            }
        } else if (status == 3) {
            if (i == 1) {
                return true;
            }
        } else if (status == 2) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 5) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 3) {
            if (i == 1) {
                return true;
            }
        } else if (status == 4) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        if (this.status == 3) {
            if (this.posY > y) {
                this.dragUp();
            } else if (this.posY < y) {
                this.dragDown();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        this.cood[0] = x;
        this.cood[1] = y;
        this.cood[2] = x;
        this.cood[3] = y;
        this.posX = x;
        this.posY = y;
        if (this.status == 0 && this.rectGameArea.contains(x, y)) {
            System.out.println("$touch PRESS");
            RMSObjects.game.pointerPressed(x, y);
            return;
        }
        block5: for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.existComponentInState(i, this.status) || this.rectItems[i] == null || !this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            switch (this.selectedCompId) {
                case 0: {
                    if (this.status != 1) {
                        Keys.keyPressed(-6);
                        continue block5;
                    }
                    Keys.keyPressed(-6);
                    continue block5;
                }
                case 1: {
                    if (this.status == 3) {
                        this.startAnimation(true, 1);
                        this.textOffsetY = 0;
                        this.scrollUP = false;
                        this.scrollDOWN = true;
                        this.mainCanvas.repaint();
                        continue block5;
                    }
                    Keys.keyPressed(-7);
                    continue block5;
                }
                case 4: {
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.SetSoundOn(false);
                        MainCanvas.soundManager.Stop();
                    } else {
                        MainCanvas.soundManager.SetSoundOn(true);
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                    this.mainCanvas.repaint();
                    continue block5;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.status == 4) {
            this.startAnimation(true, 0);
            return;
        }
        if (this.status == 0 && this.rectGameArea.contains(x, y)) {
            this.cood[2] = x;
            this.cood[3] = y;
            System.out.println("$touch RELEASE");
            RMSObjects.game.pointerDrraged(x, y);
            return;
        }
        switch (this.selectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                break;
            }
            case 1: {
                if (Keys.isKeyPressed(-7)) {
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                }
                this.mainCanvas.repaint();
            }
            default: {
                if (Keys.isKeyPressed(53)) {
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
                if (this.status != 1) break;
                this.selectedCompId = 1;
                this.mainCanvas.repaint();
            }
        }
    }

    public void dragUp() {
        if (Resources.sysFont) {
            this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY < 0) {
            this.textOffsetY = 0;
            this.scrollUP = false;
            this.scrollDOWN = true;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    public void dragDown() {
        int maxOffsetY = instruction.getTextHeight() - this.rectPanel.height;
        if (Resources.sysFont) {
            this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY > maxOffsetY) {
            this.textOffsetY = maxOffsetY;
            this.scrollUP = true;
            this.scrollDOWN = false;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    static {
        _WIDTH = 0;
        _HEIGHT = 0;
    }
}

