/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Resources;
import sk.inlogic.World;
import sk.inlogic.util.Rectangle;

public class Coin {
    private int _iX = 0;
    private int _iY = 0;
    private int _iType = 0;
    private boolean _bIsActive = false;
    private Sprite _sprCoin;
    private Rectangle _rectCoin;
    private World _world;

    public Coin(World world) {
        this._world = world;
        this.setCoinType();
        this._rectCoin = new Rectangle();
    }

    public void activateCoin(int x, int y) {
        this.setX(x);
        this.setY(y);
        this.setCoinType();
        this._rectCoin = new Rectangle(this._world._tTiles[this.getX()][this.getY()].get_rectTile().x, this._world._tTiles[this.getX()][this.getY()].get_rectTile().y, this._world._tTiles[this.getX()][this.getY()].get_rectTile().width, this._world._tTiles[this.getX()][this.getY()].get_rectTile().height);
        this.setActive(true);
    }

    private void setCoinType() {
        if (this._world._tTiles[this.getX()][this.getY()].getType() == 0) {
            this._iType = this._world._tTiles[this.getX()][this.getY()].getType();
            this._sprCoin = Resources.resSprs[33];
        } else if (this._world._tTiles[this.getX()][this.getY()].getType() == 2) {
            this._iType = this._world._tTiles[this.getX()][this.getY()].getType();
            this._sprCoin = Resources.resSprs[32];
        } else if (this._world._tTiles[this.getX()][this.getY()].getType() == 3) {
            this._iType = this._world._tTiles[this.getX()][this.getY()].getType();
            this._sprCoin = Resources.resSprs[35];
        }
    }

    public void update() {
        if (this.isActive()) {
            this._rectCoin.y = this._world._tTiles[this.getX()][this.getY()].get_rectTile().y;
            if (this._rectCoin.y > this._world.getHeight()) {
                this.deactivate();
            }
        }
    }

    public void paint(Graphics g) {
        if (this.isActive()) {
            this._sprCoin.setPosition(this._rectCoin.x, this._rectCoin.y);
            this._sprCoin.paint(g);
        }
    }

    public boolean collectCoin() {
        if (this._rectCoin.contains(this._world.getCharacter().get_rectChar().getCenterX(), this._world.getCharacter().get_rectChar().getCenterY())) {
            this._world.incEarnedCoins(1);
            this.deactivate();
            return true;
        }
        return false;
    }

    private void deactivate() {
        this._world._tTiles[this.getX()][this.getY()].setEmpty(true);
        this.setActive(false);
    }

    public void setX(int _iX) {
        this._iX = _iX;
    }

    public int getX() {
        return this._iX;
    }

    public void setY(int _iY) {
        this._iY = _iY;
    }

    public int getY() {
        return this._iY;
    }

    public void set_iType(int _iType) {
        this._iType = _iType;
    }

    public int get_iType() {
        return this._iType;
    }

    public void setActive(boolean _bIsActive) {
        this._bIsActive = _bIsActive;
    }

    public boolean isActive() {
        return this._bIsActive;
    }

    public void setRect(Rectangle _rectTree) {
        this._rectCoin = _rectTree;
    }

    public Rectangle getRect() {
        return this._rectCoin;
    }
}

