/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Particles;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Game
implements RMSHandler {
    private static final int _STATUS_INITLEVEL = 0;
    private static final int _STATUS_READY = 1;
    private static final int _STATUS_LEVELDONE = 2;
    private static final int _STATUS_GAMEOVER = 3;
    public static Rectangle rectGameArea;
    private Rectangle _rectTxt;
    private Rectangle _rectChar;
    private Rectangle[][] _rectWorld;
    private int _iStatus;
    private int _iScore;
    private int[][] _iWorld;
    private int[][] _iScores;
    private boolean _stsrtMoveLeft = false;
    private boolean _stsrtMoveRight = false;
    private Sprite _sprWallHor1;
    private Sprite _sprWallHor2;
    private Sprite _sprWallVer;
    private Sprite _sprChar;
    private int TOTAL_ROW = 10;
    private int TOTAL_COL = 10;
    private PreparedText _tapToStart;
    Rectangle _tmpR;
    private int _iOffsetX = 0;
    private int _iTmpShift = 50;
    private int _iTmpPositionX = 0;
    private int _iTmpDefaultPositionX;
    private int _iTmpShiftW = 2048;
    private int[] _iTmpPositionXw;
    private int[] _iTmpDefaultPositionXw;
    private int _iCheckUpdate = 0;
    private boolean _pressed = false;

    public Game() {
        this.init();
    }

    private void init() {
        this._tapToStart = new PreparedText(Resources.resGFonts[0]);
        this._sprWallHor1 = Resources.resSprs[1];
        this._sprWallHor2 = Resources.resSprs[2];
        this._sprWallVer = Resources.resSprs[3];
        this._sprChar = Resources.resSprs[14];
    }

    public void restartGame(Rectangle _rectArea, int mode) {
        if (mode == 0) {
            this._iTmpShiftW = MainCanvas.HEIGHT << 1;
        }
        if (mode == 1) {
            this._iTmpShiftW = MainCanvas.HEIGHT << 2;
        }
        if (mode == 2) {
            this._iTmpShiftW = MainCanvas.HEIGHT;
        }
        this.init();
        this._tmpR = new Rectangle(0, 0, 0, 0);
        this.TOTAL_COL = _rectArea.width / this._sprWallHor1.getWidth();
        this._rectWorld = new Rectangle[this.TOTAL_COL][this.TOTAL_ROW];
        this._iWorld = new int[this.TOTAL_COL][this.TOTAL_ROW];
        this._iScores = new int[this.TOTAL_COL][this.TOTAL_ROW];
        this._iTmpPositionXw = new int[this.TOTAL_ROW];
        this._iStatus = 0;
        this._tapToStart = new PreparedText(Resources.resGFonts[0]);
        this._rectTxt = new Rectangle(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this._rectChar = new Rectangle((_rectArea.width >> 1) - (this._sprChar.getWidth() >> 1), (_rectArea.height >> 1) + (this._sprChar.getWidth() >> 1), this._sprChar.getWidth(), this._sprChar.getWidth());
        this._iTmpDefaultPositionX = this._iTmpPositionX = this._rectChar.x << 2;
        this._iTmpShift = MainCanvas.WIDTH / 9;
        this._tapToStart.prepareText(Resources.resTexts[0].getHashedString(80), MainCanvas.WIDTH);
        rectGameArea = _rectArea;
        this.createWorld();
        this.endMoveLeft();
        this.endMoveRight();
        this._iCheckUpdate = 0;
        this._iScore = 0;
        this._iStatus = 1;
    }

    private void prepareGameArea() {
    }

    private void createWorld() {
        int freePos = 0;
        int setPos = 0;
        int lastEmpty = -1;
        int wall = 0;
        for (int _iY = 0; _iY < this.TOTAL_ROW; ++_iY) {
            freePos = RandomNum.getRandomInt(this.TOTAL_COL, 0);
            if (freePos < 0) {
                freePos *= -1;
            }
            if (lastEmpty == -1) {
                lastEmpty = freePos;
            } else {
                if (Math.abs(freePos - lastEmpty) > 2) {
                    wall = 2;
                }
                lastEmpty = freePos;
            }
            for (int _iX = 0; _iX < this.TOTAL_COL; ++_iX) {
                this._rectWorld[_iX][_iY] = new Rectangle(Game.rectGameArea.x + _iX * this._sprWallHor1.getWidth(), Game.rectGameArea.y - (this._sprWallVer.getHeight() << 3) - _iY * (this._sprWallVer.getHeight() << 1), this._sprWallHor1.getWidth(), this._sprWallVer.getHeight() << 1);
                this._iTmpPositionXw[_iY] = this._rectWorld[_iX][_iY].y << 200 << 1;
                if (_iX == freePos && setPos == 0) {
                    this._iWorld[_iX][_iY] = 1 + wall;
                    ++setPos;
                    continue;
                }
                this._iWorld[_iX][_iY] = wall;
            }
            setPos = 0;
            wall = 0;
        }
    }

    public void update(long lastRunLenght) {
        if (this._iStatus == 1) {
            this.checkScore();
        }
        if (this._iStatus != 3) {
            this.updateWorld();
        } else if (this._iCheckUpdate == 0) {
            ++this._iCheckUpdate;
            this.updateWorld();
        }
        if (this._iStatus != 3) {
            if (this._stsrtMoveLeft) {
                this.moveLeft();
            }
            if (this._stsrtMoveRight) {
                this.moveRight();
            }
        }
        Particles.update();
        Particles.createParticle(this._rectChar.getCenterX(), this._rectChar.getCenterY(), 0, 50, RandomNum.getRandomInt(5, -5), 0, 3, 0xFFFFFF, RandomNum.getRandomUInt(10), 0);
    }

    private void updateWorld() {
        int _iCheck = 0;
        int _iReset = 0;
        if (this._iStatus != 3) {
            for (int _iY = 0; _iY < this.TOTAL_ROW; ++_iY) {
                int n = _iY;
                this._iTmpPositionXw[n] = this._iTmpPositionXw[n] + this._iTmpShiftW;
                for (int _iX = 0; _iX < this.TOTAL_COL; ++_iX) {
                    if (this.checkGameOver(_iX, _iY)) {
                        return;
                    }
                    this._rectWorld[_iX][_iY].y = this._iTmpPositionXw[_iY] >> 200 >> 1;
                    if (this.checkGameOver(_iX, _iY)) {
                        return;
                    }
                    if (this._rectWorld[_iX][_iY].y <= Game.rectGameArea.height || _iReset != 0) continue;
                    this.resetRow(_iY);
                    ++_iReset;
                }
                if (this._rectWorld[0][_iY].y > MainCanvas.HEIGHT >> 1 && _iCheck == 0 && this._iScores[0][_iY] == 0) {
                    ++this._iScore;
                    this._iScores[0][_iY] = 1;
                    ++_iCheck;
                    if (this._iScore % 30 == 0) {
                        this._iTmpShiftW += 32;
                    }
                }
                _iReset = 0;
                _iCheck = 0;
            }
        }
    }

    private boolean checkGameOver(int _iX, int _iY) {
        this._tmpR.x = this._rectWorld[_iX][_iY].x;
        this._tmpR.y = this._rectWorld[_iX][_iY].y;
        this._tmpR.width = this._rectWorld[_iX][_iY].width;
        this._tmpR.height = this._sprWallHor1.getHeight();
        if (this._tmpR.intersects(this._rectChar) && this._iWorld[_iX][_iY] == 0) {
            this._iStatus = 3;
            return true;
        }
        if (this._tmpR.contains(this._rectChar.x, this._rectChar.y) && (this._iWorld[_iX][_iY] == 0 || this._iWorld[_iX][_iY] == 2)) {
            this._iStatus = 3;
            return true;
        }
        if (this._tmpR.contains(this._rectChar.x + this._rectChar.width, this._rectChar.y + this._rectChar.height) && (this._iWorld[_iX][_iY] == 0 || this._iWorld[_iX][_iY] == 2)) {
            this._iStatus = 3;
            return true;
        }
        if (this._tmpR.contains(this._rectChar.getCenterX(), this._rectChar.getCenterY()) && this._iWorld[_iX][_iY] == 0) {
            this._iStatus = 3;
            return true;
        }
        if (this._rectChar.contains(this._tmpR.x, this._tmpR.y) && (this._iWorld[_iX][_iY] == 0 || this._iWorld[_iX][_iY] == 2)) {
            this._iStatus = 3;
            return true;
        }
        if (this._rectChar.contains(this._tmpR.getCenterX(), this._tmpR.getCenterY()) && (this._iWorld[_iX][_iY] == 0 || this._iWorld[_iX][_iY] == 2)) {
            this._iStatus = 3;
            return true;
        }
        if (_iX == 0) {
            this._tmpR.x = this._rectWorld[_iX][_iY].x;
            this._tmpR.y = this._rectWorld[_iX][_iY].y;
            this._tmpR.width = this._sprWallVer.getWidth();
            this._tmpR.height = this._sprWallVer.getHeight() << 1;
            if (this._tmpR.intersects(this._rectChar) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
            if (this._tmpR.contains(this._rectChar.x, this._rectChar.y) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
            if (this._tmpR.contains(this._rectChar.getCenterX(), this._rectChar.getCenterY()) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
            if (this._rectChar.contains(this._tmpR.x, this._tmpR.y) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
            if (this._rectChar.contains(this._tmpR.getCenterX(), this._tmpR.getCenterY()) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
        }
        if (_iX == this.TOTAL_COL - 1) {
            this._tmpR.x = this._rectWorld[_iX][_iY].x + this._rectWorld[_iX][_iY].width - this._sprWallVer.getWidth();
            this._tmpR.y = this._rectWorld[_iX][_iY].y;
            this._tmpR.width = this._sprWallVer.getWidth();
            this._tmpR.height = this._sprWallVer.getHeight() << 1;
            if (this._tmpR.intersects(this._rectChar) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
            if (this._tmpR.contains(this._rectChar.x, this._rectChar.y) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
            if (this._tmpR.isOverlap(this._rectChar) && this._iWorld[_iX][_iY] == 0) {
                this._iStatus = 3;
                return true;
            }
            if (this._tmpR.contains(this._rectChar.getCenterX(), this._rectChar.getCenterY()) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
            if (this._rectChar.contains(this._tmpR.x, this._tmpR.y) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
            if (this._rectChar.contains(this._tmpR.getCenterX(), this._tmpR.getCenterY()) && this._iWorld[_iX][_iY] != 2 && this._iWorld[_iX][_iY] != 3) {
                this._iStatus = 3;
                return true;
            }
        }
        return false;
    }

    private void resetRow(int _iY) {
        int _iX;
        int freePos = 0;
        int setPos = 0;
        int wall = 0;
        int tmpIdx = 0;
        if (_iY == 0) {
            for (_iX = 0; _iX < this.TOTAL_COL; ++_iX) {
                if (this._iWorld[_iX][this.TOTAL_ROW - 1] != 1) continue;
                tmpIdx = _iX;
            }
        } else {
            for (_iX = 0; _iX < this.TOTAL_COL; ++_iX) {
                if (this._iWorld[_iX][_iY - 1] != 1) continue;
                tmpIdx = _iX;
            }
        }
        if ((freePos = RandomNum.getRandomInt(this.TOTAL_COL, 0)) < 0) {
            freePos *= -1;
        }
        if (Math.abs(freePos - tmpIdx) > 2) {
            wall = 2;
        }
        for (_iX = 0; _iX < this.TOTAL_COL; ++_iX) {
            this._rectWorld[_iX][_iY] = _iY == 0 ? new Rectangle(Game.rectGameArea.x + _iX * this._sprWallHor1.getWidth(), this._rectWorld[_iX][this.TOTAL_ROW - 1].y - (this._sprWallVer.getHeight() << 1), this._sprWallHor1.getWidth(), this._sprWallVer.getHeight() << 1) : new Rectangle(Game.rectGameArea.x + _iX * this._sprWallHor1.getWidth(), this._rectWorld[_iX][_iY - 1].y - (this._sprWallVer.getHeight() << 1), this._sprWallHor1.getWidth(), this._sprWallVer.getHeight() << 1);
            this._iTmpPositionXw[_iY] = this._rectWorld[_iX][_iY].y << 200 << 1;
            if (_iX == freePos && setPos == 0) {
                this._iWorld[_iX][_iY] = 1 + wall;
                ++setPos;
            } else {
                this._iWorld[_iX][_iY] = wall;
            }
            this._iScores[_iX][_iY] = 0;
        }
        setPos = 0;
    }

    public void paint(Graphics g, int status) {
        if (this._iStatus == 0) {
            // empty if block
        }
        this.paintWorld(g);
        this.paintCharacter(g);
        g.setColor(0xFFFFFF);
    }

    private void paintWorld(Graphics g) {
        for (int _iX = 0; _iX < this.TOTAL_COL; ++_iX) {
            for (int _iY = 0; _iY < this.TOTAL_ROW; ++_iY) {
                this._sprWallHor1.setPosition(this._rectWorld[_iX][_iY].x, this._rectWorld[_iX][_iY].y);
                if (this._iWorld[_iX][_iY] == 1 || this._iWorld[_iX][_iY] == 3) continue;
                if (this._sprWallHor1.getY() + this._rectWorld[_iX][_iY].height >= 0) {
                    this._sprWallHor1.paint(g);
                }
                if (this._iWorld[_iX][_iY] == 2) continue;
                if (_iX == 0) {
                    this._sprWallVer.setPosition(this._rectWorld[0][_iY].x, this._rectWorld[0][_iY].y);
                    if (this._sprWallHor1.getY() + this._rectWorld[_iX][_iY].height >= 0) {
                        this._sprWallVer.paint(g);
                    }
                    this._sprWallVer.setPosition(this._rectWorld[0][_iY].x, this._rectWorld[0][_iY].y + this._sprWallVer.getHeight());
                    if (this._sprWallHor1.getY() + this._rectWorld[_iX][_iY].height >= 0) {
                        this._sprWallVer.paint(g);
                    }
                    this._sprWallVer.setPosition(this._rectWorld[this.TOTAL_COL - 1][_iY].x + this._rectWorld[this.TOTAL_COL - 1][_iY].width - this._sprWallVer.getWidth(), this._rectWorld[_iX][_iY].y);
                    if (this._sprWallHor1.getY() + this._rectWorld[_iX][_iY].height >= 0) {
                        this._sprWallVer.paint(g);
                    }
                    this._sprWallVer.setPosition(this._rectWorld[this.TOTAL_COL - 1][_iY].x + this._rectWorld[this.TOTAL_COL - 1][_iY].width - this._sprWallVer.getWidth(), this._rectWorld[_iX][_iY].y + this._sprWallVer.getHeight());
                    if (this._sprWallHor1.getY() + this._rectWorld[_iX][_iY].height >= 0) {
                        this._sprWallVer.paint(g);
                    }
                }
                if (this.TOTAL_COL - 1 != _iX) continue;
                this._sprWallVer.setPosition(this._rectWorld[0][_iY].x, this._rectWorld[0][_iY].y);
                if (this._sprWallHor1.getY() + this._rectWorld[_iX][_iY].height >= 0) {
                    this._sprWallVer.paint(g);
                }
                this._sprWallVer.setPosition(this._rectWorld[0][_iY].x, this._rectWorld[0][_iY].y + this._sprWallVer.getHeight());
                if (this._sprWallHor1.getY() + this._rectWorld[_iX][_iY].height >= 0) {
                    this._sprWallVer.paint(g);
                }
                this._sprWallVer.setPosition(this._rectWorld[this.TOTAL_COL - 1][_iY].x + this._rectWorld[this.TOTAL_COL - 1][_iY].width - this._sprWallVer.getWidth(), this._rectWorld[_iX][_iY].y);
                if (this._sprWallHor1.getY() + this._rectWorld[_iX][_iY].height >= 0) {
                    this._sprWallVer.paint(g);
                }
                this._sprWallVer.setPosition(this._rectWorld[this.TOTAL_COL - 1][_iY].x + this._rectWorld[this.TOTAL_COL - 1][_iY].width - this._sprWallVer.getWidth(), this._rectWorld[_iX][_iY].y + this._sprWallVer.getHeight());
                if (this._sprWallHor1.getY() + this._rectWorld[_iX][_iY].height < 0) continue;
                this._sprWallVer.paint(g);
            }
        }
    }

    private void paintCharacter(Graphics g) {
        this._sprChar.setPosition(this._rectChar.x, this._rectChar.y);
        Particles.paint(g, 0);
        this._sprChar.paint(g);
    }

    private void checkScore() {
    }

    public void rotate() {
        if (this._iStatus == 0) {
            this._iStatus = 1;
            return;
        }
    }

    public void DragOrDrop() {
    }

    public void pointerPressed(int x, int y) {
        this._pressed = true;
        if (x < Game.rectGameArea.width >> 1) {
            this.startMoveLeft();
        } else {
            this.startMoveRight();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this._pressed) {
            this.endMoveLeft();
            this.endMoveRight();
            this._pressed = false;
        }
    }

    public int getScore() {
        return this._iScore;
    }

    public boolean isGameOver() {
        return this._iStatus == 3;
    }

    public boolean isLevelDone() {
        return this._iStatus == 2;
    }

    public boolean isInitGame() {
        return this._iStatus == 0;
    }

    public void moveLeft() {
        this._iTmpPositionX -= this._iTmpShift;
        this._rectChar.x = this._iTmpPositionX >> 2;
        if (this._rectChar.x < Game.rectGameArea.x) {
            this._rectChar.x = Game.rectGameArea.width;
            this._iTmpDefaultPositionX = this._iTmpPositionX = this._rectChar.x << 2;
        }
    }

    public void moveRight() {
        this._iTmpPositionX += this._iTmpShift;
        this._rectChar.x = this._iTmpPositionX >> 2;
        if (this._rectChar.x > Game.rectGameArea.width) {
            this._rectChar.x = Game.rectGameArea.x;
            this._iTmpDefaultPositionX = this._iTmpPositionX = this._rectChar.x << 2;
        }
    }

    public void startMoveLeft() {
        this._stsrtMoveLeft = true;
        this._stsrtMoveRight = false;
    }

    public void startMoveRight() {
        this._stsrtMoveLeft = false;
        this._stsrtMoveRight = true;
    }

    public void endMoveLeft() {
        this._stsrtMoveLeft = false;
    }

    public void endMoveRight() {
        this._stsrtMoveRight = false;
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
    }
}

