/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Map {
    public static final int obj_none = 0;
    public static final int obj_unit = 1;
    public static final int obj_tower = 2;
    public static final int obj_capital = 3;
    public static final int obj_gold = 4;
    public static final int obj_tree = 5;
    public static int hex_half_widht_global = 0;
    public static int hex_half_height_global = 0;
    public static int hex_half_widht_local = 0;
    public static int hex_half_height_local = 0;
    public static int local_map_width = 4;
    public static int local_map_height = 0;
    public static int global_DX = 0;
    public static int global_DY = 0;
    public static int[][] race;
    public static int[][] territory;
    public static int[][] obj_type;
    public static int[][] obj_number;
    public static int activeHexX;
    public static int activeHexY;
    public static boolean global;
    public static Image[] hexIm;
    public static Image waterIm;
    public static Image waterLeft;
    public static Image waterRight;
    public static Image waterDownLeft;
    public static Image waterDownRight;
    public static Image hexFrameIm;
    private static int x;
    private static int d;

    public static void loadImages() {
        hexIm = new Image[5];
        try {
            Map.hexIm[0] = Image.createImage((String)"/h_hex.png");
            Map.hexIm[1] = Image.createImage((String)"/o_hex.png");
            Map.hexIm[2] = Image.createImage((String)"/e_hex.png");
            Map.hexIm[3] = Image.createImage((String)"/u_hex.png");
            Map.hexIm[4] = Image.createImage((String)"/n_hex.png");
            waterIm = Image.createImage((String)"/t_water.png");
            waterLeft = Image.createImage((String)"/wat_left.png");
            waterRight = Image.createImage((String)"/wat_right.png");
            waterDownLeft = Image.createImage((String)"/wat_down_left.png");
            waterDownRight = Image.createImage((String)"/wat_down_right.png");
            hexFrameIm = Image.createImage((String)"/obvodka_hexa.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadMap() {
        int i;
        Players.num_of_players = 0;
        for (i = 0; i < Players.race_active.length; ++i) {
            Players.race_active[i] = false;
        }
        global = false;
        hex_half_widht_global = (Game.W - 10 - 10) / ((MapsInit.race[Game.LEV][0].length + 1) * 2);
        hex_half_height_global = hex_half_widht_global * 1000 / 866 / 2;
        if (Game.H - 120 < hex_half_height_global * 3 * MapsInit.race[Game.LEV].length) {
            hex_half_height_global = (Game.H - 120) / MapsInit.race[Game.LEV].length / 3;
            hex_half_widht_global = hex_half_height_global * 866 * 2 / 1000;
        }
        hex_half_widht_local = Game.W / 2 / local_map_width;
        hex_half_height_local = hex_half_widht_local * 1000 / 866 / 2;
        race = null;
        territory = null;
        obj_number = null;
        obj_type = null;
        System.gc();
        race = new int[MapsInit.race[Game.LEV].length][MapsInit.race[Game.LEV][0].length];
        territory = new int[MapsInit.race[Game.LEV].length][MapsInit.race[Game.LEV][0].length];
        obj_type = new int[MapsInit.race[Game.LEV].length][MapsInit.race[Game.LEV][0].length];
        obj_number = new int[MapsInit.race[Game.LEV].length][MapsInit.race[Game.LEV][0].length];
        for (i = 0; i < MapsInit.race[Game.LEV].length; ++i) {
            for (int j = 0; j < MapsInit.race[Game.LEV][0].length; ++j) {
                Map.race[i][j] = MapsInit.race[Game.LEV][i][j];
                Map.territory[i][j] = 10;
                if (race[i][j] == 100 || race[i][j] == 4 || Players.race_active[race[i][j]]) continue;
                ++Players.num_of_players;
                Players.race_active[Map.race[i][j]] = true;
            }
        }
        activeHexX = race[0].length / 2;
        activeHexY = race.length / 2;
        if (Game.LEV < 6) {
            if (Game.LEV == 4) {
                global_DX = (Game.W - 30 - hex_half_widht_global * (race[0].length * 2 + 1)) / 2;
                global_DY = (Game.H - 30 - hex_half_height_global * (race.length * 3 + 1)) / 2;
            } else if (Game.LEV == 5) {
                global_DX = (Game.W - hex_half_widht_global * (race[0].length * 2 + 1)) / 2;
                global_DY = (Game.H - hex_half_height_global * (race.length * 3 + 1)) / 2;
            } else {
                global_DX = (Game.W - 55 - hex_half_widht_global * (race[0].length * 2 + 1)) / 2;
                global_DY = (Game.H - 90 - hex_half_height_global * (race.length * 3 + 1)) / 2;
            }
        } else {
            global_DX = (Game.W - 20 - hex_half_widht_global * (race[0].length * 2 + 1)) / 2;
            global_DY = (Game.H - 20 - hex_half_height_global * (race.length * 3 + 1)) / 2;
        }
        Gold.init();
        Tree.init();
        Unit.init();
        Tower.init();
        Players.initPlayers();
        Players.step = 0;
        TurnCounter.newTurn();
        for (i = 0; i < Players.num_of_players; ++i) {
            Players.players[i].recountBalance();
        }
        System.out.println("active" + Players.num_of_players);
    }

    public static void drawGlobalMap(Graphics g) {
        g.setClip(0, 0, Game.W, Game.H);
        g.setColor(0);
        g.fillRect(0, 0, Game.W, Game.H);
        Map.drawWater(g);
        for (int i = 0; i < race.length; ++i) {
            for (int j = 0; j < race[0].length; ++j) {
                if (race[i][j] == 100) continue;
                Map.drawGlobalHex(g, i, j);
            }
        }
        Map.drawFrames(g);
        Hud.draw(g);
    }

    public static void drawWater(Graphics g) {
        for (int i = 0; i < Game.H / waterIm.getHeight() + 1; ++i) {
            for (int j = 0; j < Game.W / waterIm.getWidth() + 1; ++j) {
                g.drawImage(waterIm, j * waterIm.getWidth(), i * waterIm.getHeight(), 4 | 0x10);
            }
        }
    }

    public static void drawLocalMap(Graphics g) {
        int j;
        int i;
        Map.drawWater(g);
        local_map_width = Game.W / hexIm[0].getWidth() + 2;
        hex_half_widht_local = hexIm[0].getWidth() / 2;
        hex_half_height_local = hexIm[0].getHeight() / 4;
        local_map_height = Game.H / hex_half_height_local / 3 + 2;
        for (i = activeHexY - local_map_height / 2; i <= activeHexY + local_map_height / 2; i += 2) {
            for (j = activeHexX - local_map_width / 2; j <= activeHexX + local_map_width / 2; ++j) {
                if (j < 0 || j >= race[0].length || i < 0 || i >= race.length || race[i][j] == 100) continue;
                Map.drawLocalHex(g, i, j);
            }
        }
        for (i = activeHexY - local_map_height / 2 + 1; i <= activeHexY + local_map_height / 2 - 1; i += 2) {
            for (j = activeHexY % 2 == 0 ? activeHexX - local_map_width / 2 - 1 : activeHexX - local_map_width / 2; j <= (activeHexY % 2 == 0 ? activeHexX + local_map_width / 2 : activeHexX + local_map_width / 2 + 1 + 2); ++j) {
                if (j < 0 || j >= race[0].length || i < 0 || i >= race.length || race[i][j] == 100) continue;
                Map.drawLocalHex(g, i, j);
            }
        }
        g.drawImage(hexFrameIm, Game.W / 2, Game.H / 2, 2 | 1);
        Map.drawObjects(g);
        Hud.draw(g);
    }

    public static void drawObjects(Graphics g) {
        for (int i = 0; i < race.length; ++i) {
            for (int j = 0; j < race[0].length; ++j) {
                if (race[i][j] == 100) continue;
                try {
                    switch (obj_type[i][j]) {
                        case 1: {
                            Unit.drawOne(g, obj_number[i][j]);
                            break;
                        }
                        case 3: {
                            Capital.drawOne(g, obj_number[i][j]);
                            break;
                        }
                        case 4: {
                            Gold.drawOne(g, obj_number[i][j]);
                            break;
                        }
                        case 5: {
                            Tree.drawOne(g, obj_number[i][j]);
                            break;
                        }
                        case 2: {
                            Tower.drawOne(g, obj_number[i][j]);
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (j > activeHexX + local_map_width / 2 || j < activeHexX - local_map_width / 2 || i > activeHexY + local_map_height / 2 || i < activeHexY - local_map_height / 2) {
                        return;
                    }
                    int x = Game.W / 2 + 2 * hex_half_widht_local * (j - activeHexX);
                    int y = Game.H / 2 + 3 * hex_half_height_local * (i - activeHexY);
                    if ((i - activeHexY) % 2 != 1 && (activeHexY - i) % 2 != 1) continue;
                    if (i % 2 == 0) {
                        x -= hex_half_widht_local;
                        continue;
                    }
                    x += hex_half_widht_local;
                }
            }
        }
    }

    public static void drawLocalHex(Graphics g, int Y, int X) {
        int x = hex_half_widht_local;
        int d = hex_half_height_local;
        int xc = 0;
        int yc = 0;
        xc = Game.W / 2 + 2 * x * (X - activeHexX);
        if ((Y - activeHexY >= 0 ? Y - activeHexY : activeHexY - Y) % 2 == 1) {
            xc = Y % 2 == 0 ? (xc -= x) : (xc += x);
        }
        yc = Game.H / 2 + 3 * d * (Y - activeHexY);
        try {
            g.drawImage(hexIm[race[Y][X]], xc, yc, 1 | 2);
        }
        catch (Exception e) {
            System.out.println(race[Y][X]);
            e.printStackTrace();
        }
        if (X != activeHexX || Y == activeHexY) {
            // empty if block
        }
        if (X == 0 || race[Y][X - 1] == 100) {
            g.drawImage(waterLeft, xc - x, yc - d, 0x10 | 8);
        }
        if (X == race[0].length - 1 || race[Y][X + 1] == 100) {
            g.drawImage(waterRight, xc + x, yc - d, 0x10 | 4);
        }
        if (Y == race.length - 1) {
            g.drawImage(waterDownLeft, xc, yc + d - 2, 0x10 | 8);
        } else if (X == 0) {
            if (Y % 2 == 0) {
                g.drawImage(waterDownLeft, xc, yc + d - 2, 0x10 | 8);
            }
        } else if (race[Y + 1][Y % 2 == 0 ? X - 1 : X] == 100) {
            g.drawImage(waterDownLeft, xc, yc + d - 2, 0x10 | 8);
        }
        if (Y == race.length - 1) {
            g.drawImage(waterDownRight, xc, yc + d - 1, 0x10 | 4);
        } else if (X == race[0].length - 1) {
            if (Y % 2 == 1) {
                g.drawImage(waterDownRight, xc, yc + d - 1, 0x10 | 4);
            }
        } else if (race[Y + 1][Y % 2 == 0 ? X : X + 1] == 100) {
            g.drawImage(waterDownRight, xc, yc + d - 1, 0x10 | 4);
        }
    }

    public static void drawGlobalHex(Graphics g, int Y, int X) {
        Map.shiftingGlobalHex(5, 3, 1);
        int xc = 0;
        int yc = 0;
        xc = Y % 2 == 0 ? x * (1 + X * 2) : x * (2 + X * 2);
        yc = d * (2 + Y * 3);
        if (Game.LEV < 4) {
            xc += 5 + global_DX;
            yc += 20 + global_DY;
        } else {
            xc += global_DX - 20;
            yc += global_DY - 20;
        }
        g.setColor(Data.RACECOLOR[race[Y][X]]);
        g.fillTriangle(xc, yc, xc - x, yc - d, xc, yc - 2 * d);
        g.fillTriangle(xc, yc, xc, yc - 2 * d, xc + x, yc - d);
        g.fillTriangle(xc, yc, xc + x, yc - d, xc + x, yc + d);
        g.fillTriangle(xc, yc, xc + x, yc + d, xc, yc + 2 * d);
        g.fillTriangle(xc, yc, xc, yc + 2 * d, xc - x, yc + d);
        g.fillTriangle(xc, yc, xc - x, yc + d, xc - x, yc - d);
        g.setColor(65280);
        if (race[Y][X] == Players.players[Players.turns].race && obj_type[Y][X] == 1 && Unit.is_active[obj_number[Y][X]]) {
            g.fillArc(xc - x / 4, yc - x / 4, x / 2, x / 2, 0, 360);
        }
    }

    private static void shiftingGlobalHex(int num_level, int shift1, int shift2) {
        x = 0;
        d = 0;
        if (Game.LEV < num_level) {
            x = hex_half_widht_global + shift1;
            d = hex_half_height_global + shift1;
        } else {
            x = hex_half_widht_global + shift2;
            d = hex_half_height_global + shift2;
        }
    }

    public static void drawFrames(Graphics g) {
        Map.shiftingGlobalHex(5, 3, 1);
        int xc = 0;
        int yc = 0;
        xc = activeHexY % 2 == 0 ? x * (1 + activeHexX * 2) : x * (2 + activeHexX * 2);
        yc = d * (2 + activeHexY * 3);
        if (Game.LEV < 4) {
            xc += 5 + global_DX;
            yc += 20 + global_DY;
        } else {
            xc += global_DX - 20;
            yc += global_DY - 20;
        }
        g.setColor(0xFFFF00);
        g.drawLine(xc - x, yc - d, xc, yc - 2 * d);
        g.drawLine(xc, yc - 2 * d, xc + x, yc - d);
        g.drawLine(xc + x, yc - d, xc + x, yc + d);
        g.drawLine(xc + x, yc + d, xc, yc + 2 * d);
        g.drawLine(xc, yc + 2 * d, xc - x, yc + d);
        g.drawLine(xc - x, yc + d, xc - x, yc - d);
        g.drawLine(xc - x - 1, yc - d, xc, yc - 2 * d - 1);
        g.drawLine(xc, yc - 2 * d - 1, xc + x + 1, yc - d);
        g.drawLine(xc + x + 1, yc - d, xc + x + 1, yc + d);
        g.drawLine(xc + x + 1, yc + d, xc, yc + 2 * d + 1);
        g.drawLine(xc, yc + 2 * d + 1, xc - x - 1, yc + d);
        g.drawLine(xc - x - 1, yc + d, xc - x - 1, yc - d);
        int w = x * 2 * local_map_width - 10;
        int h = w * Game.H / Game.W - 5;
        g.drawLine(xc - w / 2, yc - h / 2, xc + w / 2, yc - h / 2);
        g.drawLine(xc - w / 2, yc + h / 2, xc + w / 2, yc + h / 2);
        g.drawLine(xc - w / 2, yc - h / 2, xc - w / 2, yc + h / 2);
        g.drawLine(xc + w / 2, yc - h / 2, xc + w / 2, yc + h / 2);
    }

    public static void jumpLeft() {
        if (activeHexX == 0) {
            return;
        }
        int findx = activeHexX;
        do {
            if (race[activeHexY][--findx] == 100) continue;
            activeHexX = findx;
            return;
        } while (race[activeHexY][findx] == 100 && findx > 0);
    }

    public static void jumpRight() {
        if (activeHexX == race[0].length - 1) {
            return;
        }
        int findx = activeHexX;
        do {
            if (race[activeHexY][++findx] == 100) continue;
            activeHexX = findx;
            return;
        } while (race[activeHexY][findx] == 100 && findx < race[0].length - 1);
    }

    public static void jumpUp() {
        if (activeHexY == 0) {
            return;
        }
        int findy = activeHexY;
        do {
            if (race[--findy][activeHexX] == 100) continue;
            activeHexY = findy;
            return;
        } while (race[findy][activeHexX] == 100 && findy > 0);
    }

    public static void jumpDown() {
        if (activeHexY == race.length - 1) {
            return;
        }
        int findy = activeHexY;
        do {
            if (race[++findy][activeHexX] == 100) continue;
            activeHexY = findy;
            return;
        } while (race[findy][activeHexX] == 100 && findy < race.length - 1);
    }

    public static void jumpLeftUp() {
        if (activeHexY == 0 || activeHexY % 2 == 0 && activeHexX == 0) {
            return;
        }
        int findx = activeHexX;
        int findy = activeHexY;
        do {
            if (findy % 2 == 0) {
                --findx;
            }
            if (race[--findy][findx] == 100) continue;
            activeHexX = findx;
            activeHexY = findy;
            return;
        } while (race[findy][findx] == 100 && findy > 0 && (findx > 0 || findy % 2 == 1));
    }

    public static void jumpRightUp() {
        if (activeHexY == 0 || activeHexY % 2 == 1 && activeHexX == race[0].length - 1) {
            return;
        }
        int findx = activeHexX;
        int findy = activeHexY;
        do {
            if (findy % 2 == 1) {
                ++findx;
            }
            if (race[--findy][findx] == 100) continue;
            activeHexX = findx;
            activeHexY = findy;
            return;
        } while (race[findy][findx] == 100 && findy > 0 && (findx < race[0].length - 1 || findy % 2 == 0));
    }

    public static void jumpLeftDown() {
        if (activeHexY == race.length - 1 || activeHexY % 2 == 0 && activeHexX == 0) {
            return;
        }
        int findx = activeHexX;
        int findy = activeHexY;
        do {
            if (findy % 2 == 0) {
                --findx;
            }
            if (race[++findy][findx] == 100) continue;
            activeHexX = findx;
            activeHexY = findy;
            return;
        } while (race[findy][findx] == 100 && findy < race.length - 1 && (findx > 0 || findy % 2 == 1));
    }

    public static void jumpRightDown() {
        if (activeHexY == race.length - 1 || activeHexY % 2 == 1 && activeHexX == race[0].length - 1) {
            return;
        }
        int findx = activeHexX;
        int findy = activeHexY;
        do {
            if (findy % 2 == 1) {
                ++findx;
            }
            if (race[++findy][findx] == 100) continue;
            activeHexX = findx;
            activeHexY = findy;
            return;
        } while (race[findy][findx] == 100 && findy < race.length - 1 && (findx < race[0].length - 1 || findy % 2 == 0));
    }

    static {
        activeHexX = 0;
        activeHexY = 0;
    }
}

