/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.airport.main;

import com.rocktasticgames.airport.animated.AnimatedElement;
import com.rocktasticgames.airport.animated.AnimatedPointer;
import com.rocktasticgames.airport.main.MainActivity;
import com.rocktasticgames.airport.utils.MotionEvent;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class MainCanvas
extends Canvas {
    private MainActivity activity;
    private AnimatedElement focus;
    private AnimatedPointer pointer;

    public MainCanvas(MainActivity mainActivity) {
        this.activity = mainActivity;
    }

    protected void paint(Graphics graphics) {
        if (this.getWidth() > this.getHeight()) {
            String string;
            if (this.activity.getState() == 3 || this.activity.getState() == 4 || this.activity.getState() == 2) {
                this.activity.pause();
            }
            switch (this.activity.getLanguage()) {
                default: {
                    string = "Please reorientate handset screen.";
                    break;
                }
                case 1: {
                    string = "Veuillez r\u00c3\u00a9orienter l'\u00c3\u00a9cran de votre appareil.";
                    break;
                }
                case 2: {
                    string = "Bitte den Bildschirm des Handys neu orientieren.";
                    break;
                }
                case 3: {
                    string = "Reorienta o ecr\u00c3\u00a3 do telem\u00c3\u00b3vel.";
                    break;
                }
                case 4: {
                    string = "Reorienta la pantalla del dispositivo.";
                }
            }
            string = string.toUpperCase();
            graphics.setColor(-1);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.translate(this.getWidth() / 2 - this.activity.getBrady().measure(string) / 2, this.getHeight() / 2 - graphics.getFont().getHeight() / 2);
            this.activity.getBrady().renderString(graphics, -16777216, string);
            graphics.translate(-(this.getWidth() / 2 - this.activity.getBrady().measure(string) / 2), -(this.getHeight() / 2 - graphics.getFont().getHeight() / 2));
            this.activity.invalidate();
            return;
        }
        switch (this.activity.getState()) {
            case 3: {
                this.activity.getKitchen().onDraw(graphics);
                break;
            }
            case 4: {
                this.activity.getMap().onDraw(graphics);
                break;
            }
            case 2: {
                this.activity.getMenu().onDraw(graphics);
                break;
            }
            case 6: {
                this.activity.getSplashOne().onDraw(graphics);
                break;
            }
            case 7: {
                this.activity.getSplashTwo().onDraw(graphics);
                break;
            }
            case 8: {
                this.activity.getSoundView().onDraw(graphics);
                break;
            }
            case 9: {
                this.activity.getLanguageView().onDraw(graphics);
            }
        }
    }

    private void sendMotionEvent(int n, int n2, int n3) {
        this.activity.invalidate();
        switch (this.activity.getState()) {
            case 3: {
                this.activity.getKitchen().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 4: {
                this.activity.getMap().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 2: {
                this.activity.getMenu().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 6: {
                this.activity.getSplashOne().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 7: {
                this.activity.getSplashTwo().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 8: {
                this.activity.getSoundView().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 9: {
                this.activity.getLanguageView().onTouchEvent(new MotionEvent(n, n2, n3));
            }
        }
    }

    public AnimatedElement getFocus() {
        return this.focus;
    }

    private AnimatedElement getNeighbor(int n) {
        this.activity.invalidate();
        switch (this.activity.getState()) {
            case 3: {
                return this.activity.getKitchen().traverse(this.focus, n);
            }
            case 4: {
                return this.activity.getMap().traverse(this.focus, n);
            }
            case 2: {
                return this.activity.getMenu().traverse(this.focus, n);
            }
            case 8: {
                return this.activity.getSoundView().traverse(this.focus, n);
            }
            case 9: {
                return this.activity.getLanguageView().traverse(this.focus, n);
            }
        }
        return this.focus;
    }

    public void setFocus(AnimatedElement animatedElement) {
    }

    protected void keyPressed(int n) {
        if (n == -11) {
            this.activity.onBackPressed();
            return;
        }
    }

    protected void keyRepeated(int n) {
    }

    protected void keyReleased(int n) {
    }

    protected void pointerReleased(int n, int n2) {
        this.sendMotionEvent(1, n, n2);
    }

    protected void pointerPressed(int n, int n2) {
        this.sendMotionEvent(2, n, n2);
    }

    protected void pointerDragged(int n, int n2) {
        this.sendMotionEvent(3, n, n2);
    }
}

